/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.OutputFormat;
import org.apache.hive.beeline.Rows;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.encoder.DefaultCsvEncoder;
import org.supercsv.encoder.SelectiveCsvEncoder;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

class SeparatedValuesOutputFormat
implements OutputFormat {
    public static final String DSV_OPT_OUTPUT_FORMAT = "dsv";
    public static final String DISABLE_QUOTING_FOR_SV = "disable.quoting.for.sv";
    private static final char DEFAULT_QUOTE_CHAR = '\"';
    private final BeeLine beeLine;
    private final StringBuilderWriter buffer;
    private final char defaultSeparator;

    SeparatedValuesOutputFormat(BeeLine beeLine, char separator) {
        this.beeLine = beeLine;
        this.defaultSeparator = separator;
        this.buffer = new StringBuilderWriter();
    }

    private CsvPreference getCsvPreference() {
        DefaultCsvEncoder encoder;
        char separator = this.defaultSeparator;
        char quoteChar = '\"';
        if (DSV_OPT_OUTPUT_FORMAT.equals(this.beeLine.getOpts().getOutputFormat())) {
            separator = this.beeLine.getOpts().getDelimiterForDSV();
        }
        if (this.isQuotingDisabled()) {
            quoteChar = '\u0000';
            encoder = new SelectiveCsvEncoder(new int[0]);
        } else {
            encoder = new DefaultCsvEncoder();
        }
        return new CsvPreference.Builder(quoteChar, (int)separator, "").useEncoder((CsvEncoder)encoder).build();
    }

    @Override
    public int print(Rows rows) {
        String line;
        CsvPreference csvPreference = this.getCsvPreference();
        CsvListWriter writer = new CsvListWriter((Writer)this.buffer, csvPreference);
        int count = 0;
        Rows.Row labels = (Rows.Row)rows.next();
        if (this.beeLine.getOpts().getShowHeader()) {
            this.fillBuffer(writer, labels);
            line = this.getLine(this.buffer);
            this.beeLine.output(line);
        }
        while (rows.hasNext()) {
            this.fillBuffer(writer, (Rows.Row)rows.next());
            line = this.getLine(this.buffer);
            this.beeLine.output(line);
            ++count;
        }
        return count;
    }

    private void fillBuffer(CsvListWriter writer, Rows.Row row) {
        String[] vals = row.values;
        try {
            writer.write(vals);
            writer.flush();
        }
        catch (Exception e) {
            this.beeLine.error(e);
        }
    }

    private String getLine(StringBuilderWriter buf) {
        String line = buf.toString();
        buf.getBuilder().setLength(0);
        return line;
    }

    private boolean isQuotingDisabled() {
        Boolean quotingDisabled = Boolean.TRUE;
        String quotingDisabledStr = System.getProperty(DISABLE_QUOTING_FOR_SV);
        if (StringUtils.isNotBlank((String)quotingDisabledStr) && (quotingDisabled = BooleanUtils.toBooleanObject((String)quotingDisabledStr)) == null) {
            this.beeLine.error("System Property disable.quoting.for.sv is now " + quotingDisabledStr + " which only accepts boolean values");
            quotingDisabled = Boolean.TRUE;
        }
        return quotingDisabled;
    }
}

