/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.util;

import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.proto.MRProtos;

public class MRProtoUtils {
    private static String JOB_STATE_PREFIX = "J_";
    private static String PHASE_PREFIX = "P_";
    private static String TACE_PREFIX = "TACE_";
    private static String TASK_ATTEMPT_STATE_PREFIX = "TA_";
    private static String TASK_STATE_PREFIX = "TS_";

    public static MRProtos.JobStateProto convertToProtoFormat(JobState e) {
        return MRProtos.JobStateProto.valueOf(JOB_STATE_PREFIX + e.name());
    }

    public static JobState convertFromProtoFormat(MRProtos.JobStateProto e) {
        return JobState.valueOf(e.name().replace(JOB_STATE_PREFIX, ""));
    }

    public static MRProtos.PhaseProto convertToProtoFormat(Phase e) {
        return MRProtos.PhaseProto.valueOf(PHASE_PREFIX + e.name());
    }

    public static Phase convertFromProtoFormat(MRProtos.PhaseProto e) {
        return Phase.valueOf(e.name().replace(PHASE_PREFIX, ""));
    }

    public static MRProtos.TaskAttemptCompletionEventStatusProto convertToProtoFormat(TaskAttemptCompletionEventStatus e) {
        return MRProtos.TaskAttemptCompletionEventStatusProto.valueOf(TACE_PREFIX + e.name());
    }

    public static TaskAttemptCompletionEventStatus convertFromProtoFormat(MRProtos.TaskAttemptCompletionEventStatusProto e) {
        return TaskAttemptCompletionEventStatus.valueOf(e.name().replace(TACE_PREFIX, ""));
    }

    public static MRProtos.TaskAttemptStateProto convertToProtoFormat(TaskAttemptState e) {
        return MRProtos.TaskAttemptStateProto.valueOf(TASK_ATTEMPT_STATE_PREFIX + e.name());
    }

    public static TaskAttemptState convertFromProtoFormat(MRProtos.TaskAttemptStateProto e) {
        return TaskAttemptState.valueOf(e.name().replace(TASK_ATTEMPT_STATE_PREFIX, ""));
    }

    public static MRProtos.TaskStateProto convertToProtoFormat(TaskState e) {
        return MRProtos.TaskStateProto.valueOf(TASK_STATE_PREFIX + e.name());
    }

    public static TaskState convertFromProtoFormat(MRProtos.TaskStateProto e) {
        return TaskState.valueOf(e.name().replace(TASK_STATE_PREFIX, ""));
    }

    public static MRProtos.TaskTypeProto convertToProtoFormat(TaskType e) {
        return MRProtos.TaskTypeProto.valueOf(e.name());
    }

    public static TaskType convertFromProtoFormat(MRProtos.TaskTypeProto e) {
        return TaskType.valueOf(e.name());
    }
}

