/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.util.Preconditions;

class DefaultResultPartition
implements SchedulingResultPartition {
    private final IntermediateResultPartitionID resultPartitionId;
    private final IntermediateDataSetID intermediateDataSetId;
    private final ResultPartitionType partitionType;
    private final Supplier<ResultPartitionState> resultPartitionStateSupplier;
    private DefaultExecutionVertex producer;
    private final Supplier<List<ConsumerVertexGroup>> consumerVertexGroupsSupplier;
    private final Supplier<List<ConsumedPartitionGroup>> consumerPartitionGroupSupplier;

    DefaultResultPartition(IntermediateResultPartitionID partitionId, IntermediateDataSetID intermediateDataSetId, ResultPartitionType partitionType, Supplier<ResultPartitionState> resultPartitionStateSupplier, Supplier<List<ConsumerVertexGroup>> consumerVertexGroupsSupplier, Supplier<List<ConsumedPartitionGroup>> consumerPartitionGroupSupplier) {
        this.resultPartitionId = Preconditions.checkNotNull(partitionId);
        this.intermediateDataSetId = Preconditions.checkNotNull(intermediateDataSetId);
        this.partitionType = Preconditions.checkNotNull(partitionType);
        this.resultPartitionStateSupplier = Preconditions.checkNotNull(resultPartitionStateSupplier);
        this.consumerVertexGroupsSupplier = Preconditions.checkNotNull(consumerVertexGroupsSupplier);
        this.consumerPartitionGroupSupplier = Preconditions.checkNotNull(consumerPartitionGroupSupplier);
    }

    @Override
    public IntermediateResultPartitionID getId() {
        return this.resultPartitionId;
    }

    @Override
    public IntermediateDataSetID getResultId() {
        return this.intermediateDataSetId;
    }

    @Override
    public ResultPartitionType getResultType() {
        return this.partitionType;
    }

    @Override
    public ResultPartitionState getState() {
        return this.resultPartitionStateSupplier.get();
    }

    @Override
    public DefaultExecutionVertex getProducer() {
        return this.producer;
    }

    @Override
    public List<ConsumerVertexGroup> getConsumerVertexGroups() {
        return Preconditions.checkNotNull(this.consumerVertexGroupsSupplier.get());
    }

    @Override
    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.consumerPartitionGroupSupplier.get();
    }

    void setProducer(DefaultExecutionVertex vertex) {
        this.producer = Preconditions.checkNotNull(vertex);
    }
}

