/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.io.Serializable;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ExceptionHistoryEntry
extends ErrorInfo {
    private static final long serialVersionUID = -3855285510064263701L;
    @Nullable
    private final String failingTaskName;
    @Nullable
    private final ArchivedTaskManagerLocation taskManagerLocation;

    public static ExceptionHistoryEntry create(AccessExecution failedExecution, String taskName) {
        Preconditions.checkNotNull(failedExecution, "No Execution is specified.");
        Preconditions.checkNotNull(taskName, "No task name is specified.");
        Preconditions.checkArgument(failedExecution.getFailureInfo().isPresent(), "The selected Execution " + failedExecution.getAttemptId() + " didn't fail.");
        ErrorInfo failure = failedExecution.getFailureInfo().get();
        return new ExceptionHistoryEntry((Throwable)failure.getException(), failure.getTimestamp(), taskName, failedExecution.getAssignedResourceLocation());
    }

    public static ExceptionHistoryEntry createGlobal(Throwable cause) {
        return new ExceptionHistoryEntry(cause, System.currentTimeMillis(), null, (ArchivedTaskManagerLocation)null);
    }

    protected ExceptionHistoryEntry(Throwable cause, long timestamp, @Nullable String failingTaskName, @Nullable TaskManagerLocation taskManagerLocation) {
        this(cause, timestamp, failingTaskName, ArchivedTaskManagerLocation.fromTaskManagerLocation(taskManagerLocation));
    }

    private ExceptionHistoryEntry(Throwable cause, long timestamp, @Nullable String failingTaskName, @Nullable ArchivedTaskManagerLocation taskManagerLocation) {
        super(cause, timestamp);
        this.failingTaskName = failingTaskName;
        this.taskManagerLocation = taskManagerLocation;
    }

    public boolean isGlobal() {
        return this.failingTaskName == null;
    }

    @Nullable
    public String getFailingTaskName() {
        return this.failingTaskName;
    }

    @Nullable
    public ArchivedTaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public static class ArchivedTaskManagerLocation
    implements Serializable {
        private static final long serialVersionUID = -6596854145482446664L;
        private final ResourceID resourceID;
        private final String addressStr;
        private final int port;
        private final String hostname;
        private final String fqdnHostname;

        @Nullable
        @VisibleForTesting
        static ArchivedTaskManagerLocation fromTaskManagerLocation(TaskManagerLocation taskManagerLocation) {
            if (taskManagerLocation == null) {
                return null;
            }
            return new ArchivedTaskManagerLocation(taskManagerLocation.getResourceID(), taskManagerLocation.addressString(), taskManagerLocation.dataPort(), taskManagerLocation.getHostname(), taskManagerLocation.getFQDNHostname());
        }

        private ArchivedTaskManagerLocation(ResourceID resourceID, String addressStr, int port, String hostname, String fqdnHost) {
            this.resourceID = resourceID;
            this.addressStr = addressStr;
            this.port = port;
            this.hostname = hostname;
            this.fqdnHostname = fqdnHost;
        }

        public ResourceID getResourceID() {
            return this.resourceID;
        }

        public String getAddress() {
            return this.addressStr;
        }

        public int getPort() {
            return this.port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getFQDNHostname() {
            return this.fqdnHostname;
        }

        public String toString() {
            return new StringJoiner(", ", ArchivedTaskManagerLocation.class.getSimpleName() + "[", "]").add("resourceID=" + this.resourceID).add("addressStr='" + this.addressStr + "'").add("port=" + this.port).add("hostname='" + this.hostname + "'").add("fqdnHostname='" + this.fqdnHostname + "'").toString();
        }
    }
}

