/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.stringindexer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.common.param.HasHandleInvalid;
import org.apache.flink.ml.feature.stringindexer.StringIndexerModelData;
import org.apache.flink.ml.feature.stringindexer.StringIndexerModelParams;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class StringIndexerModel
implements Model<StringIndexerModel>,
StringIndexerModelParams<StringIndexerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public StringIndexerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(StringIndexerModelData.getModelDataStream(this.modelDataTable), path, new StringIndexerModelData.ModelDataEncoder());
    }

    public static StringIndexerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        StringIndexerModel model = (StringIndexerModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new StringIndexerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public StringIndexerModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String[] inputCols = this.getInputCols();
        String[] outputCols = this.getOutputCols();
        Preconditions.checkArgument((inputCols.length == outputCols.length ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)this.modelDataTable).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        Object[] outputTypes = new TypeInformation[outputCols.length];
        Arrays.fill(outputTypes, BasicTypeInfo.DOUBLE_TYPE_INFO);
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])outputTypes), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])this.getOutputCols()));
        String broadcastModelKey = "broadcastModelKey";
        DataStream<StringIndexerModelData> modelDataStream = StringIndexerModelData.getModelDataStream(this.modelDataTable);
        DataStream result = BroadcastUtils.withBroadcastStream(Collections.singletonList(tEnv.toDataStream(inputs[0])), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.flatMap((FlatMapFunction)new String2Index("broadcastModelKey", inputCols, this.getHandleInvalid()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(result)};
    }

    private static class String2Index
    extends RichFlatMapFunction<Row, Row> {
        private HashMap<String, Double>[] modelDataMap;
        private final String broadcastModelKey;
        private final String[] inputCols;
        private final String handleInValid;

        public String2Index(String broadcastModelKey, String[] inputCols, String handleInValid) {
            this.broadcastModelKey = broadcastModelKey;
            this.inputCols = inputCols;
            this.handleInValid = handleInValid;
        }

        public void flatMap(Row input, Collector<Row> out) {
            if (this.modelDataMap == null) {
                this.modelDataMap = new HashMap[this.inputCols.length];
                StringIndexerModelData modelData = (StringIndexerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                String[][] stringsArray = modelData.stringArrays;
                for (int i = 0; i < stringsArray.length; ++i) {
                    double idx = 0.0;
                    this.modelDataMap[i] = new HashMap(stringsArray[i].length);
                    for (String string : stringsArray[i]) {
                        double d = idx;
                        idx = d + 1.0;
                        this.modelDataMap[i].put(string, d);
                    }
                }
            }
            Row outputIndices = new Row(this.inputCols.length);
            block12: for (int i = 0; i < this.inputCols.length; ++i) {
                String stringVal;
                Object objVal = input.getField(this.inputCols[i]);
                if (null == objVal) {
                    stringVal = null;
                } else if (objVal instanceof String) {
                    stringVal = (String)objVal;
                } else if (objVal instanceof Number) {
                    stringVal = String.valueOf(objVal);
                } else {
                    throw new RuntimeException("The input column only supports string and numeric type.");
                }
                if (this.modelDataMap[i].containsKey(stringVal)) {
                    outputIndices.setField(i, (Object)this.modelDataMap[i].get(stringVal));
                    continue;
                }
                switch (this.handleInValid) {
                    case "skip": {
                        return;
                    }
                    case "error": {
                        throw new RuntimeException("The input contains unseen string: " + stringVal + ". See " + HasHandleInvalid.HANDLE_INVALID + " parameter for more options.");
                    }
                    case "keep": {
                        outputIndices.setField(i, (Object)this.modelDataMap[i].size());
                        continue block12;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported " + HasHandleInvalid.HANDLE_INVALID + "type: " + this.handleInValid);
                    }
                }
            }
            out.collect((Object)Row.join((Row)input, (Row[])new Row[]{outputIndices}));
        }
    }
}

