/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

import java.util.Arrays;
import org.xiph.libogg.ogg_packet;
import org.xiph.libvorbis.bitrate_manager_state;
import org.xiph.libvorbis.codebook;
import org.xiph.libvorbis.codec_setup_info;
import org.xiph.libvorbis.envelope_lookup;
import org.xiph.libvorbis.oggpack_buffer;
import org.xiph.libvorbis.private_state;
import org.xiph.libvorbis.vorbis_block;
import org.xiph.libvorbis.vorbis_block_internal;
import org.xiph.libvorbis.vorbis_comment;
import org.xiph.libvorbis.vorbis_constants.integer_constants;
import org.xiph.libvorbis.vorbis_info;
import org.xiph.libvorbis.vorbis_info_floor1;
import org.xiph.libvorbis.vorbis_info_psy_global;
import org.xiph.libvorbis.vorbis_info_residue0;
import org.xiph.libvorbis.vorbis_look_floor1;
import org.xiph.libvorbis.vorbis_look_psy;
import org.xiph.libvorbis.vorbis_look_psy_global;
import org.xiph.libvorbis.vorbis_look_residue0;

public class vorbis_dsp_state {
    int analysisp;
    public vorbis_info vi;
    float[][] pcm;
    int pcm_storage;
    public int pcm_current;
    int pcm_returned;
    int preextrapolate;
    int eofflag;
    int lW;
    int W;
    int nW;
    int centerW;
    int granulepos;
    int sequence;
    int glue_bits;
    int time_bits;
    int floor_bits;
    int res_bits;
    private_state backend_state;

    private vorbis_look_floor1 floor1_look(vorbis_info_floor1 info) {
        int j;
        int[] sortpointer = new int[65];
        vorbis_look_floor1 look = new vorbis_look_floor1();
        int n = 0;
        look.vi = info;
        look.n = info.postlist[1];
        int i = 0;
        while (i < info.partitions) {
            n += info.class_dim[info.partitionclass[i]];
            ++i;
        }
        look.posts = n += 2;
        i = 0;
        while (i < n) {
            sortpointer[i] = info.postlist[i];
            ++i;
        }
        Arrays.sort(sortpointer, 0, n);
        i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                if (sortpointer[i] == info.postlist[j]) {
                    look.forward_index[i] = j;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            look.reverse_index[look.forward_index[i]] = i;
            ++i;
        }
        i = 0;
        while (i < n) {
            look.sorted_index[i] = info.postlist[look.forward_index[i]];
            ++i;
        }
        switch (info.mult) {
            case 1: {
                look.quant_q = 256;
                break;
            }
            case 2: {
                look.quant_q = 128;
                break;
            }
            case 3: {
                look.quant_q = 86;
                break;
            }
            case 4: {
                look.quant_q = 64;
            }
        }
        i = 0;
        while (i < n - 2) {
            int lo = 0;
            int hi = 1;
            int lx = 0;
            int hx = look.n;
            int currentx = info.postlist[i + 2];
            j = 0;
            while (j < i + 2) {
                int x = info.postlist[j];
                if (x > lx && x < currentx) {
                    lo = j;
                    lx = x;
                }
                if (x < hx && x > currentx) {
                    hi = j;
                    hx = x;
                }
                ++j;
            }
            look.loneighbor[i] = lo;
            look.hineighbor[i] = hi;
            ++i;
        }
        return look;
    }

    private vorbis_look_residue0 res0_look(vorbis_info_residue0 info) {
        int k;
        vorbis_look_residue0 look = new vorbis_look_residue0();
        codec_setup_info ci = this.vi.codec_setup;
        int acc = 0;
        int maxstage = 0;
        look.info = info;
        look.parts = info.partitions;
        look.fullbooks = ci.fullbooks;
        look.phrasebook = ci.fullbooks[info.groupbook];
        int dim = look.phrasebook.dim;
        look.partbooks = new codebook[look.parts][];
        int j = 0;
        while (j < look.parts) {
            int stages = integer_constants.ilog(info.secondstages[j]);
            if (stages > 0) {
                if (stages > maxstage) {
                    maxstage = stages;
                }
                look.partbooks[j] = new codebook[stages];
                k = 0;
                while (k < stages) {
                    if ((info.secondstages[j] & 1 << k) > 0) {
                        look.partbooks[j][k] = ci.fullbooks[info.booklist[acc++]];
                    }
                    ++k;
                }
            }
            ++j;
        }
        look.partvals = new Double(Math.rint(Math.pow(look.parts, dim))).intValue();
        look.stages = maxstage;
        look.decodemap = new int[look.partvals][dim];
        j = 0;
        while (j < look.partvals) {
            int val = j;
            int mult = look.partvals / look.parts;
            k = 0;
            while (k < dim) {
                int deco = val / mult;
                val -= deco * mult;
                mult /= look.parts;
                look.decodemap[j][k] = deco;
                ++k;
            }
            ++j;
        }
        return look;
    }

    private boolean _vds_shared_init(boolean encp) {
        int i;
        codec_setup_info ci = this.vi.codec_setup;
        if (ci == null) {
            return false;
        }
        int hs = ci.halfrate_flag;
        this.backend_state = new private_state();
        this.backend_state.modebits = integer_constants.ilog2(ci.modes);
        this.backend_state.transform[0][0].mdct_init(ci.blocksizes[0] >>> hs);
        this.backend_state.transform[1][0].mdct_init(ci.blocksizes[1] >>> hs);
        this.backend_state.window[0] = integer_constants.ilog2(ci.blocksizes[0]) - 6;
        this.backend_state.window[1] = integer_constants.ilog2(ci.blocksizes[1]) - 6;
        if (encp) {
            this.backend_state.fft_look[0].drft_init(ci.blocksizes[0]);
            this.backend_state.fft_look[1].drft_init(ci.blocksizes[1]);
            if (ci.fullbooks == null) {
                ci.fullbooks = new codebook[ci.books];
                i = 0;
                while (i < ci.books) {
                    ci.fullbooks[i] = new codebook();
                    ci.fullbooks[i].vorbis_book_init_encode(ci.book_param[i]);
                    ++i;
                }
            }
            this.backend_state.psy = new vorbis_look_psy[ci.psys];
            i = 0;
            while (i < ci.psys) {
                this.backend_state.psy[i] = new vorbis_look_psy();
                this.backend_state.psy[i]._vp_psy_init(ci.psy_param[i], ci.psy_g_param, ci.blocksizes[ci.psy_param[i].blockflag] / 2, this.vi.rate);
                ++i;
            }
        } else {
            System.out.println("_vds_shared_init DECODE not yet implemented");
            return false;
        }
        this.analysisp = 1;
        this.pcm_storage = ci.blocksizes[1];
        this.pcm = new float[this.vi.channels][this.pcm_storage];
        this.lW = 0;
        this.W = 0;
        this.pcm_current = this.centerW = ci.blocksizes[1] / 2;
        this.backend_state.flr = new vorbis_look_floor1[ci.floors];
        this.backend_state.residue = new vorbis_look_residue0[ci.residues];
        i = 0;
        while (i < ci.floors) {
            this.backend_state.flr[i] = this.floor1_look(ci.floor_param[i]);
            ++i;
        }
        i = 0;
        while (i < ci.residues) {
            this.backend_state.residue[i] = this.res0_look(ci.residue_param[i]);
            ++i;
        }
        return true;
    }

    public boolean vorbis_analysis_init(vorbis_info _vi) {
        this.vi = _vi;
        if (!this._vds_shared_init(true)) {
            return false;
        }
        this.backend_state.psy_g_look = new vorbis_look_psy_global(this.vi);
        this.backend_state.ve = new envelope_lookup(this.vi);
        this.backend_state.bms = new bitrate_manager_state(this.vi);
        this.sequence = 3;
        return true;
    }

    public boolean vorbis_analysis_headerout(vorbis_comment vc, ogg_packet op, ogg_packet op_comm, ogg_packet op_code) {
        oggpack_buffer opb = new oggpack_buffer();
        if (!opb._vorbis_pack_info(this.vi)) {
            return false;
        }
        this.backend_state.header = new byte[opb.oggpack_bytes()];
        System.arraycopy(opb.buffer, 0, this.backend_state.header, 0, opb.oggpack_bytes());
        op.packet = this.backend_state.header;
        op.bytes = opb.oggpack_bytes();
        op.b_o_s = 1;
        op.e_o_s = 0;
        op.granulepos = 0;
        op.packetno = 0;
        opb = new oggpack_buffer();
        if (!opb._vorbis_pack_comment(vc)) {
            return false;
        }
        this.backend_state.header1 = new byte[opb.oggpack_bytes()];
        System.arraycopy(opb.buffer, 0, this.backend_state.header1, 0, opb.oggpack_bytes());
        op_comm.packet = this.backend_state.header1;
        op_comm.bytes = opb.oggpack_bytes();
        op_comm.b_o_s = 0;
        op_comm.e_o_s = 0;
        op_comm.granulepos = 0;
        op_comm.packetno = 1;
        opb = new oggpack_buffer();
        if (!opb._vorbis_pack_books(this.vi)) {
            return false;
        }
        this.backend_state.header2 = new byte[opb.oggpack_bytes()];
        System.arraycopy(opb.buffer, 0, this.backend_state.header2, 0, opb.oggpack_bytes());
        op_code.packet = this.backend_state.header2;
        op_code.bytes = opb.oggpack_bytes();
        op_code.b_o_s = 0;
        op_code.e_o_s = 0;
        op_code.granulepos = 0;
        op_code.packetno = 2;
        return true;
    }

    public float[][] vorbis_analysis_buffer(int vals) {
        this.backend_state.header = null;
        this.backend_state.header1 = null;
        this.backend_state.header2 = null;
        if (this.pcm_current + vals >= this.pcm_storage) {
            this.pcm_storage = this.pcm_current + vals * 2;
            int i = 0;
            while (i < this.vi.channels) {
                float[] temp = new float[this.pcm_storage];
                System.arraycopy(this.pcm[i], 0, temp, 0, this.pcm_current);
                this.pcm[i] = temp;
                float[] temp2 = new float[this.pcm_storage];
                System.arraycopy(this.pcm[i + 1], 0, temp2, 0, this.pcm_current);
                this.pcm[i + 1] = temp2;
                i += 2;
            }
        }
        return this.pcm;
    }

    public boolean vorbis_analysis_wrote(int vals) {
        codec_setup_info ci = this.vi.codec_setup;
        if (vals <= 0) {
            int order = 32;
            float[] lpc = new float[order];
            if (this.preextrapolate <= 0) {
                this._preextrapolate_helper();
            }
            this.vorbis_analysis_buffer(ci.blocksizes[1] * 3);
            this.eofflag = this.pcm_current;
            this.pcm_current += ci.blocksizes[1] * 3;
            int i = 0;
            while (i < this.vi.channels) {
                if (this.eofflag > order * 2) {
                    int n = this.eofflag;
                    if (n > ci.blocksizes[1]) {
                        n = ci.blocksizes[1];
                    }
                    this.vorbis_lpc_from_data(this.pcm[i], this.eofflag - n, lpc, n, order);
                    this.vorbis_lpc_predict(lpc, this.pcm[i], this.eofflag - order, order, this.eofflag, this.pcm_current - this.eofflag);
                } else {
                    Arrays.fill(this.pcm[i], this.eofflag, this.pcm_current, 0.0f);
                }
                ++i;
            }
        } else {
            if (this.pcm_current + vals > this.pcm_storage) {
                return false;
            }
            this.pcm_current += vals;
            if (this.preextrapolate <= 0 && this.pcm_current - this.centerW > ci.blocksizes[1]) {
                this._preextrapolate_helper();
            }
        }
        return true;
    }

    public boolean vorbis_bitrate_flushpacket(ogg_packet op) {
        private_state b = this.backend_state;
        bitrate_manager_state bm = b.bms;
        vorbis_block vb = bm.vb;
        int choice = 7;
        if (vb == null) {
            return false;
        }
        if (op != null) {
            vorbis_block_internal vbi = vb.internal;
            if (vb.vorbis_bitrate_managed()) {
                choice = bm.choice;
            }
            op.packet = vbi.packetblob[choice].buffer;
            op.bytes = vbi.packetblob[choice].oggpack_bytes();
            op.b_o_s = 0;
            op.e_o_s = vb.eofflag;
            op.granulepos = vb.granulepos;
            op.packetno = vb.sequence;
        }
        bm.vb = null;
        return true;
    }

    public void _preextrapolate_helper() {
        int order = 32;
        float[] lpc = new float[order];
        float[] work = new float[this.pcm_current];
        this.preextrapolate = 1;
        if (this.pcm_current - this.centerW > order * 2) {
            int i = 0;
            while (i < this.vi.channels) {
                int j = 0;
                while (j < this.pcm_current) {
                    work[j] = this.pcm[i][this.pcm_current - j - 1];
                    ++j;
                }
                this.vorbis_lpc_from_data(work, 0, lpc, this.pcm_current - this.centerW, order);
                this.vorbis_lpc_predict(lpc, work, this.pcm_current - this.centerW - order, order, this.pcm_current - this.centerW, this.centerW);
                j = 0;
                while (j < this.pcm_current) {
                    this.pcm[i][this.pcm_current - j - 1] = work[j];
                    ++j;
                }
                ++i;
            }
        }
    }

    public float vorbis_lpc_from_data(float[] data, int offset1, float[] lpci, int n, int m) {
        int i;
        double[] aut = new double[m + 1];
        double[] lpc = new double[m];
        int j = m + 1;
        while (j-- > 0) {
            double d = 0.0;
            i = j;
            while (i < n) {
                d += (double)data[offset1 + i] * (double)data[offset1 + i - j];
                ++i;
            }
            aut[j] = d;
        }
        double error = aut[0];
        i = 0;
        while (i < m) {
            double r = -aut[i + 1];
            if (error == 0.0) {
                lpci = new float[lpci.length];
                return 0.0f;
            }
            j = 0;
            while (j < i) {
                r -= lpc[j] * aut[i - j];
                ++j;
            }
            lpc[i] = r /= error;
            j = 0;
            while (j < i / 2) {
                double tmp = lpc[j];
                int n2 = j;
                lpc[n2] = lpc[n2] + r * lpc[i - 1 - j];
                int n3 = i - 1 - j;
                lpc[n3] = lpc[n3] + r * tmp;
                ++j;
            }
            if (i % 2 > 0) {
                int n4 = j;
                lpc[n4] = lpc[n4] + lpc[j] * r;
            }
            error *= 1.0 - r * r;
            ++i;
        }
        j = 0;
        while (j < m) {
            lpci[j] = (float)lpc[j];
            ++j;
        }
        return new Double(error).floatValue();
    }

    public void vorbis_lpc_predict(float[] coeff, float[] prime, int offset1, int m, int offset2, int n) {
        int i;
        float[] work = new float[m + n];
        if (prime == null) {
            i = 0;
            while (i < m) {
                work[i] = 0.0f;
                ++i;
            }
        } else {
            i = 0;
            while (i < m) {
                work[i] = prime[offset1 + i];
                ++i;
            }
        }
        i = 0;
        while (i < n) {
            float y = 0.0f;
            int o = i;
            int p = m;
            int j = 0;
            while (j < m) {
                y -= work[o++] * coeff[--p];
                ++j;
            }
            prime[offset2 + i] = work[o] = y;
            ++i;
        }
    }

    public int _ve_envelope_search() {
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy_global gi = ci.psy_g_param;
        envelope_lookup ve = this.backend_state.ve;
        int first = ve.current / ve.searchstep;
        int last = this.pcm_current / ve.searchstep - 4;
        if (first < 0) {
            first = 0;
        }
        if (last + 4 + 2 > ve.storage) {
            ve.storage = last + 4 + 2;
            int[] temp = new int[ve.storage];
            System.arraycopy(ve.mark, 0, temp, 0, ve.mark.length);
            ve.mark = temp;
        }
        int j = first;
        while (j < last) {
            int ret = 0;
            ++ve.stretch;
            if (ve.stretch > 24) {
                ve.stretch = 24;
            }
            int i = 0;
            while (i < ve.ch) {
                ret |= ve._ve_amp(gi, this.pcm[i], ve.searchstep * j, ve.band, ve.filter, i * 7, j);
                ++i;
            }
            ve.mark[j + 2] = 0;
            if ((ret & 1) > 0) {
                ve.mark[j] = 1;
                ve.mark[j + 1] = 1;
            }
            if ((ret & 2) > 0) {
                ve.mark[j] = 1;
                if (j > 0) {
                    ve.mark[j - 1] = 1;
                }
            }
            if ((ret & 4) > 0) {
                ve.stretch = -1;
            }
            ++j;
        }
        ve.current = last * ve.searchstep;
        int centerW_local = this.centerW;
        int testW = centerW_local + ci.blocksizes[this.W] / 4 + ci.blocksizes[1] / 2 + ci.blocksizes[0] / 4;
        j = ve.cursor;
        while (j < ve.current - ve.searchstep) {
            if (j >= testW) {
                return 1;
            }
            ve.cursor = j;
            if (ve.mark[j / ve.searchstep] > 0 && j > centerW_local) {
                ve.curmark = j;
                if (j >= testW) {
                    return 1;
                }
                return 0;
            }
            j += ve.searchstep;
        }
        return -1;
    }

    public boolean _ve_envelope_mark() {
        envelope_lookup ve = this.backend_state.ve;
        codec_setup_info ci = this.vi.codec_setup;
        int centerW_local = this.centerW;
        int beginW = centerW_local - ci.blocksizes[this.W] / 4;
        int endW = centerW_local + ci.blocksizes[this.W] / 4;
        if (this.W > 0) {
            beginW -= ci.blocksizes[this.lW] / 4;
            endW += ci.blocksizes[this.nW] / 4;
        } else {
            beginW -= ci.blocksizes[0] / 4;
            endW += ci.blocksizes[0] / 4;
        }
        if (ve.curmark >= beginW && ve.curmark < endW) {
            return true;
        }
        int first = beginW / ve.searchstep;
        int last = endW / ve.searchstep;
        int i = first;
        while (i < last) {
            if (ve.mark[i] > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public float _vp_ampmax_decay(float amp) {
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy_global gi = ci.psy_g_param;
        int n = ci.blocksizes[this.W] / 2;
        float secs = (float)n / (float)this.vi.rate;
        if ((amp += secs * gi.ampmax_att_per_sec) < -9999.0f) {
            amp = -9999.0f;
        }
        return amp;
    }
}

