/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libogg;

import org.xiph.libogg.ogg_packet;
import org.xiph.libogg.ogg_page;

public class ogg_stream_state {
    byte[] body_data;
    int body_storage;
    int body_fill;
    int body_returned;
    int[] lacing_vals;
    long[] granule_vals;
    int lacing_storage;
    int lacing_fill;
    int lacing_packet;
    int lacing_returned;
    byte[] header = new byte[282];
    int header_fill;
    int e_o_s;
    int b_o_s;
    int serialno;
    int pageno;
    long packetno;
    long granulepos;

    public ogg_stream_state() {
    }

    public ogg_stream_state(int _serialno) {
        this.body_storage = 16384;
        this.body_data = new byte[this.body_storage];
        this.lacing_storage = 1024;
        this.lacing_vals = new int[this.lacing_storage];
        this.granule_vals = new long[this.lacing_storage];
        this.serialno = _serialno;
    }

    public int getSerialNo() {
        return this.serialno;
    }

    public void _os_body_expand(int needed) {
        if (this.body_storage <= this.body_fill + needed) {
            this.body_storage += needed + 1024;
            byte[] temp = new byte[this.body_storage];
            System.arraycopy(this.body_data, 0, temp, 0, this.body_data.length);
            this.body_data = temp;
        }
    }

    public void _os_lacing_expand(int needed) {
        if (this.lacing_storage <= this.lacing_fill + needed) {
            this.lacing_storage += needed + 32;
            int[] temp = new int[this.lacing_storage];
            System.arraycopy(this.lacing_vals, 0, temp, 0, this.lacing_vals.length);
            this.lacing_vals = temp;
            long[] temp2 = new long[this.lacing_storage];
            System.arraycopy(this.granule_vals, 0, temp, 0, this.granule_vals.length);
            this.granule_vals = temp2;
        }
    }

    public boolean ogg_stream_packetin(ogg_packet op) {
        int lacing_vals_local = op.bytes / 255 + 1;
        if (this.body_returned > 0) {
            this.body_fill -= this.body_returned;
            if (this.body_fill > 0) {
                System.arraycopy(this.body_data, this.body_returned, this.body_data, 0, this.body_fill);
            }
            this.body_returned = 0;
        }
        this._os_body_expand(op.bytes);
        this._os_lacing_expand(lacing_vals_local);
        System.arraycopy(op.packet, 0, this.body_data, this.body_fill, op.bytes);
        this.body_fill += op.bytes;
        int i = 0;
        while (i < lacing_vals_local - 1) {
            this.lacing_vals[this.lacing_fill + i] = 255;
            this.granule_vals[this.lacing_fill + i] = this.granulepos;
            ++i;
        }
        this.lacing_vals[this.lacing_fill + i] = op.bytes % 255;
        long l = op.granulepos;
        this.granule_vals[this.lacing_fill + i] = l;
        this.granulepos = l;
        int n = this.lacing_fill;
        this.lacing_vals[n] = this.lacing_vals[n] | 0x100;
        this.lacing_fill += lacing_vals_local;
        ++this.packetno;
        if (op.e_o_s > 0) {
            this.e_o_s = 1;
        }
        return true;
    }

    public boolean ogg_stream_flush(ogg_page og) {
        int maxvals;
        int n = maxvals = this.lacing_fill > 255 ? 255 : this.lacing_fill;
        if (maxvals == 0) {
            return false;
        }
        int vals = 0;
        int bytes = 0;
        int acc = 0;
        long granule_pos = this.granule_vals[0];
        if (this.b_o_s == 0) {
            granule_pos = 0L;
            vals = 0;
            while (vals < maxvals) {
                if ((this.lacing_vals[vals] & 0xFF) < 255) {
                    ++vals;
                    break;
                }
                ++vals;
            }
        } else {
            vals = 0;
            while (vals < maxvals) {
                if (acc <= 4096) {
                    acc += this.lacing_vals[vals] & 0xFF;
                    granule_pos = this.granule_vals[vals];
                    ++vals;
                    continue;
                }
                break;
            }
        }
        System.arraycopy("OggS".getBytes(), 0, this.header, 0, 4);
        this.header[4] = 0;
        this.header[5] = 0;
        if ((this.lacing_vals[0] & 0x100) == 0) {
            this.header[5] = (byte)(this.header[5] | 1);
        }
        if (this.b_o_s == 0) {
            this.header[5] = (byte)(this.header[5] | 2);
        }
        if (this.e_o_s > 0 && this.lacing_fill == vals) {
            this.header[5] = (byte)(this.header[5] | 4);
        }
        this.b_o_s = 1;
        int i = 6;
        while (i < 14) {
            this.header[i] = (byte)granule_pos;
            granule_pos >>>= 8;
            ++i;
        }
        int serialno_local = this.serialno;
        i = 14;
        while (i < 18) {
            this.header[i] = (byte)serialno_local;
            serialno_local >>>= 8;
            ++i;
        }
        if (this.pageno == -1) {
            this.pageno = 0;
        }
        int pageno_local = this.pageno++;
        i = 18;
        while (i < 22) {
            this.header[i] = (byte)pageno_local;
            pageno_local >>>= 8;
            ++i;
        }
        this.header[22] = 0;
        this.header[23] = 0;
        this.header[24] = 0;
        this.header[25] = 0;
        this.header[26] = (byte)vals;
        i = 0;
        while (i < vals) {
            this.header[i + 27] = (byte)this.lacing_vals[i];
            bytes += this.header[i + 27] & 0xFF;
            ++i;
        }
        og.header = this.header;
        og.header_len = this.header_fill = vals + 27;
        og.body = new byte[this.body_data.length - this.body_returned];
        System.arraycopy(this.body_data, this.body_returned, og.body, 0, this.body_data.length - this.body_returned);
        og.body_len = bytes;
        this.lacing_fill -= vals;
        System.arraycopy(this.lacing_vals, vals, this.lacing_vals, 0, this.lacing_fill);
        System.arraycopy(this.granule_vals, vals, this.granule_vals, 0, this.lacing_fill);
        this.body_returned += bytes;
        og.ogg_page_checksum_set();
        return true;
    }

    public boolean ogg_stream_pageout(ogg_page og) {
        if (this.e_o_s > 0 && this.lacing_fill > 0 || this.body_fill - this.body_returned > 4096 || this.lacing_fill >= 255 || this.lacing_fill > 0 && this.b_o_s <= 0) {
            return this.ogg_stream_flush(og);
        }
        return false;
    }
}

