#define STRCMP(x, y) (printf("strcmp at line:%d\n", __LINE__),my_strcmp((x),(y)))
#define MALLOC(x) (printf("malloc at line:%d\n", __LINE__),my_malloc(x))
#define DODOMAIN(x) (printf("do domain at line: %d\n", __LINE__),doDomain(x))

#ifdef DEBUG
int
my_strcmp(char * a, char * b)
{
  int retval;
  printf("strcmp(%p,%p)", a, b);
  retval = strcmp(a, b);
  printf(".done\n");
  return retval;
}

void *
my_malloc(size_t s)
{
  void * retval;
  printf("mallocing size %d\n", s);
  retval = malloc(s);
  printf("done\n");
  printf("malloc ptr: %p\n", retval);
  return retval;
}
#endif

struct domains {
	char name[11];
	unsigned long data;
	unsigned long datak;
	unsigned int fileCount;
	char sorted;
	unsigned int seconds;
	struct domains *nextPtr;
};

struct days {
	char name[16];
	unsigned long data;
	unsigned long datak;
	unsigned int fileCount;
	unsigned int seconds;
	struct days *nextPtr;
};

struct dirs {
	char name[1024];
	unsigned long data;
	unsigned long datak;
	unsigned int fileCount;
	char sorted;
	struct dirs *nextPtr;
};

struct hour {
	unsigned long data;
	unsigned long datak;
	unsigned int seconds;
	unsigned int fileCount;
#ifndef NOGRAPH
	float hixfer;
#endif
};	

struct files {
	char name[1024];
	unsigned long data;
	unsigned int fileCount;
	char sorted;
	struct files *nextPtr;
};

struct hour hourStruct[24];
typedef struct domains DomainNode;
typedef DomainNode *DOMPTR;
typedef struct days DayNode;
typedef DayNode *DAYPTR;
typedef struct dirs DirNode;
typedef DirNode *DIRPTR;
typedef struct files FileNode;
typedef FileNode *FILEPTR;

struct ftp_entry {
	/* the date the file was ftped */
	char date[25];

	/* the time it took to transfer the file (in seconds) */
	int seconds;

	/* the hostname of the ftper */
	char host[201];

	/* the size of the file (in bytes, of course) */
	unsigned long data;

	/* the filename */
	char file_name[201];

	/* 'I' if the command was a PUT, 'O' if the command was a GET */
	char in_out;

	/* 'a' or 'g' == anonymous/guest.  'r' == real user */
	char user_type;
};

struct config_ops {
	/* report on files ftped by real users.  0 == no */
	char real_traffic;

	/* report on files ftped by anonymous/guest users.  0 == no */
	char anon_traffic;

	/* generate hourly reports.  0 == no */
	char hourly_traffic;

	/* generate top-level domain reports.  0 == no */
	char top_domain_traffic;

	/* generate total traffic by section reports.  0 == no */
	char section_traffic;

	/* generate Most Downloaded Files report.  0 == no */
	char most_downloads;

	/* generate HTML output.  0 == no */
	char html_output;

	/* get the log from the standard input.  0 == no */
	char use_stdin;

	/* the log style to use (1 == wu-ftpd, 2 == ncftpd) */
	char log_style;

	/* how deep in the directory tree should the total report by section
	   compare? */
	char depth;

	/* what section should be displayed.  NULL == all sections */
	char only_section[255];

	/* what domain should be displayed.  NULL == all domains */
	char only_domain[11];

	/* how many Most Downloaded Files should be reported? */
	char number_most_downloads;

	/* how many days should be listed in the daily stats? */
	char number_daily_stats;

	/* how many sections should be listed in the total report by section? */
	char number_section_stats;

	/* how many domains should be listed in the domain statistics? */
	char number_top_domain_stats;

	/* mmap pointer */
	char * map;
};
