.TH XPSEUDOROOT 1 "25 October 1988" "X Version 11"
.SH NAME
xpseudoroot - create a pseudo root window
.SH SYNOPSIS
.B xpseudoroot
[-options ...] \fIproperty_name\fP
.SH DESCRIPTION
.PP
The \fIxpseudoroot\fP program allows you to create pseudo root windows as
outlined in the
Inter-Client Communications Conventions Manual.  By default it just makes a
copy of the normal root window, but command line options may be used to 
alter much of the screen-related information.
.PP
The command line argument \fIproperty_name\fP specifies
the name of a property on the screen's real root window in which to store the
pseudo root information.
Applications can be run within the pseudo root window by
appending \fI\.property_name\fP to the \fIdisplaynumber.screennumber\fP
part of the display name; for example: expo:0.0.\fIproperty_name\fP
.PP
\fBWARNING\fP: This is experimental code for implementing pseudo root windows
as specified
by the Inter-Client Communications Conventions Manual.  The interfaces that
it provides should be considered private to the MIT implementation of Xlib
and WILL CHANGE IN THE NEXT RELEASE.
The interfaces that it provides should not be incorporated
into any toolkits or applications.  No effort will be made to provide 
backward compatibility.
.SH OPTIONS
.PP
.TP 8
.B "-display \fIdisplayname\fP"
This option specifies the name of the X server to contact.
.TP 8
.B "-geometry \fIgeom\fP"
This option specifies size and location of the pseudo root window.
.TP 8
.B "-visuals \fIvisualid ...\fP"
This option specifies a list of visuals to support on the pseudo root window.
Any number of numeric visual identifiers (in hex, octal, or decimal) may be
given per \fI-visuals\fP.
.TP 8
.B "-colormap \fIcolormapid\fP"
This option specifies the numeric colormap identifier to be associated with 
the pseudo root window.
.TP 8
.B "-Colormap \fIvisualid\fP"
This option specifies a numeric visual identifier to be used in creating a
new colormap for the pseudo root window.  If this option is given,
.I xpseudoroot
will create a new colormap from the given visual and set the black and white
pixel fields to the desired colors.
.TP 8
.B "-white \fIpixel\fP"
This option specifies the numeric pixel value to use for WhitePixel when
creating a new colormap with \fI\-Colormap\fP.  The default is to copy the
real screen's WhitePixel.
.TP 8
.B "-White \fIcolorname\fP"
This option specifies the color to use when setting WhitePixel in newly
created colormaps.  It may be used with \fI\-white\fP to create arbitrary
WhitePixels.
.TP 8
.B "-black \fIpixel\fP"
This option specifies the numeric pixel value to use for BlackPixel when
creating a new colormap with \fI\-Colormap\fP.  The default is to copy the
real screen's BlackPixel.
.TP 8
.B "-Black \fIcolorname\fP"
This option specifies the color to use when setting BlackPixel in newly
created colormaps.  It may be used with \fI\-black\fP to create arbitrary
BlackPixels.
.TP 8
.B "-empty"
This option indicates that any colormaps created with \fI\-Colormap\fP
should not have BlackPixel and WhitePixel preallocated (although the values
may still be set with \fI\-black\fP and \fI\-white\fP).  This leaves as 
much room as possible for running applications that would otherwise not
find enough colors.  This is not for general use as it guarantees that
an application will be displayed in incorrect colors.
.TP 8
.B "-max \fInumber\fP"
This option specifies the maximum number of installed colormaps that will be
allowed on this screen.  The default is to use the real screen's value.
.TP 8
.B "-min \fInumber\fP"
This option specifies the minimum number of installed colormaps that will be
allowed on this screen.  The default is to use the real screen's value.
.TP 8
.B "-backingstore \fIwhen\fP"
This option specifies when backing store window attributes will be honored and
takes one of the following arguments:  \fBNotUseful\fP, \fBWhenMapped\fP, or 
\fBAlways\fP.  The default is to use the real screen's value.
.TP 8
.B "-saveunders \fIboolean\fP"
This option specifies whether or not this screen supports save-unders and
takes one of the following arguments:  \fIyes\fP or \fIno\fP.
.TP 8
.B "-name \fIstring\fP"
This option specifies the name to be used for the pseudo root window.
.SH "SEE ALSO"
X(1), xdpyinfo(1), xwininfo(1), xprop(1), Inter-Client Communications
Conventions Manual
.SH BUGS
This is a sample program that is primarily intended as a testbed for
ICCCM pseudo roots.  It should not be incorporated into any toolkit or
application.  Both the command line arguments and internal interfaces are
\fBguaranteed\fP to change in the next release.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Jim Fulton, MIT X Consortium
