.TH XMAN 1 "24 October 1988" "X Version 11"
.SH NAME
xman - Manual page display program for the X Window System.
.SH SYNOPSIS
.B xman
[-options ...]
.SH DESCRIPTION
.I Xman
is a manual page browser.  The default size of the initial \fIxman\fP
window is small so that you can leave it running throughout your entire login
session.  In the initial window there are three options:
\fIHelp\fP will pop up a window with on-line help, \fIQuit\fP will
exit, and \fIManual Page\fP will pop up a window with a manual page
browser in it.  You may pop up more than one manual page browser window
from a single execution of \fIxman\fP.
.PP
For further information on using \fIxman\fP please read the on-line
help information.  The rest of this manual page will discuss
customization of \fIxman\fP.
.PP
.sh "CUSTOMIZING XMAN"
.PP
.I Xman
allows customization of both the directories to be searched for manual pages,
and the name that each directory will map to in the \fIManual Sections\fP
menu.  Xman determines which direcories it will
search by reading the \fIMANPATH\fP environment variable.  This enviroment
is expected to be a colon seperated list of directories for xman to search.
.nf

setenv MANPATH /mit/kit/man:/usr/man
.fi
.PP
By default,
.I xman
will search each of the following directories (in each of the directories 
specified in the users MANPATH) for manual pages.  If manual pages exist
in that directory then they are added to list of manual pages for 
the corrosponding menu item.
A menu item is only displayed for those sections that actually contain
manual pages.
.ta 1.5i
.nf

Directory	Section Name
---------	------------
man1	User Commands       (1)    
man2	System Calls        (2)
man3	Subroutines         (3)
man4	Devices             (4)
man5	File Formats        (5)
man6	Games               (6)
man7	Miscellaneous       (7)
man8	Sys. Administration (8)
manl	Local               (l)
mann	New                 (n)
mano	Old                 (o)

.fi     
For instance, a user has three directories in her manual path and each
contain a directory called \fIman3\fP.  All these manual pages will appear
alphabetically sorted when the user clicks on the menu item called
\fISubroutines (3)\fP.  If there is no directory called \fImano\fP in
any of the directories in her MANPATH, or there are no manual pages
in any of the directories called \fImano\fP then no menu item will be
displayed for the section called \fIOld (o)\fP.
.PP
.sh "THE MANDESC FILE"        
.PP
By using the \fImandesc\fP file a user or system manager is able to 
more closely control which manual pages will appear in each of the sections
represented by menu items in the \fIManual Sections\fP menu.  This 
functionality is only avaliable on a section by section basis, and individual
manual pages may not be handled in this manner (Although generous use of 
symbolic links - ln(1) - will allow almost any configuration you can imagine).
The format of the mandesc file is a character followed by a label.  The
character determines which of the sections will be added under this label.
For instance suppose that you would like to create an extra menu item that 
contains all programmer subroutines.  This label should contain all manual
pages in both sections two and three.  The \fImandesc\fP file
would look like this.
.nf     
        
2Programmer Subroutines
3Programmer Subroutines

.fi
This will add a menu item to the \fIManual Sections\fP menu that would
bring up a listing of all manual pages in sections two and three of
Unix Programmers Manual.  Since the label names are \fIexactly\fP the
same they will be added to the same section. Note, however, that the
original sections still exist.
.PP
If you want to completely ignore the default sections in a manual directory
the add the line:
.nf

no default sections

.fi
Anywhere in your mandesc file.  This keeps xman from searching
the default manual sections \fIIn that directory only\fP.  As an example,
suppose you want to do the same thing as above, but you don't think that
it is useful to have the \fISystem Calls\fP or \fISubroutines\fP sections
any longer.  You would need to duplicate the default entries, as well as
adding your new one.
.nf

no default sections
1User Commands       (1)
2Programmer Subroutines
3Programmer Subroutines
4Devices             (4)
5File Formats        (5)
6Games               (6)
7Miscellaneous       (7)
8Sys. Administration (8)
lLocal               (l)
nNew                 (n)
oOld                 (o)

.fi
Xman will read any section that is of the from \fIman<character>\fP, where
<character> is an upper or lower case letter (they are treated distinctly) or
a numeral (0-9).  Be warned, however, that man(1) and catman(8) will 
not search directories that are non-standard.
.PP
.I Xman
creates temporary files in /tmp for all unformatted man pages and all apropos
searches.
.PP
.SH "COMMAND LINE OPTIONS"
.PP
.IP "\fB-helpfile\fP \fIfilename\fP"
Specifies a helpfile to use other than the default.
.IP \fB-bothshown\fP
Allows both the manual page and manual directory to be on the screen at
the same time.
.IP \fB-notopbox\fP
Starts without the Top Menu with the three buttons in it.
.IP "\fB-geometry\fP \fIWxH+X+Y\fP"
Sets the size and location of the Top Menu with the three buttons in it.
.IP "\fB-pagesize\fP \fIWxH+X+Y\fP"
Sets the size and location of all the Manual Pages.
.IP "\fB-bw\fP \fIpixels\fP or \fB-borderwidth\fP \fIpixels\fP"
Specifies the width of the border for all windows in \fIxman\fP.
.IP "\fB-bd\fP \fIcolor\fP or \fB-bordercolor\fP \fIcolor\fP"
Specifies the color of the borders of all windows in \fIxman\fP.
.IP "\fB-fg\fP \fIcolor\fP or \fB-foreground\fP \fIcolor\fP"
Specifies the foreground color to be used.
.IP "\fB-bg\fP \fIcolor\fP or \fB-background\fP \fIcolor\fP"
Specifies the background color to be used.
.IP "\fB-fn\fP \fIfont\fP or \fB-font\fP \fIfont\fP"
Specifies the font to use for all buttons and labels.
.IP "\fB-display\fP \fIhost:display[.screen]\fP"
Specifies a display other than the default specified by the DISPLAY
environment variable.
.IP "\fB-name\fP \fIname\fP"
Specifies the name to use when retrieving resources.
.IP "\fB-title\fP \fItitle\fP"
Specifies the title of this application.
.IP "\fB-xrm\fP \fIresources\fP"
Allows a resource to be specified on the command line.
.PP
.SH "X DEFAULTS"

The \fIxman\fP program uses the following X resources: 
\fBforeground\fP,
\fBbackground\fP,
\fBwidth\fP, \fBheight\fP,
\fBborderWidth\fP, and
\fBborderColor\fP.
.PP
In order to change the default values for widget resources you need
to know widget names.  Below are the names of some of the
most common widgets.
You can also reference Widgets by class.  The most common classes
are \fBLabel\fP, \fBCommand\fP, and \fBText\fP.
.TP 16
\fBtopBox\fP
the top menu
.TP 16
\fBhelp\fP
the help window
.TP 16
\fBmanualBrowser\fP
the manual page display window
.TP 16
\fBxmanCommands\fP
manual page command popup menu 	
.TP 16
\fBxmanSections\fP
manual page section popup menu 	
.TP 16
\fBxmanSearch\fP
manual page search popup menu
.PP
In addition, \fIxman\fP has application-specific resources which allow
unique \fIxman\fP customizations.
.PP
.TP 18
\fBmanualFontNormal\fP
The font to use for normal text in the manual pages.
.TP 18
\fBmanualFontBold\fP
The font to use for bold text in the manual pages.
.TP 18
\fBmanualFontItalic\fP
The font to use for italic text in the manual pages.
.TP 18
\fBdirectoryFontNormal\fP
The font to use for the directory text.
.TP 18
\fBbothShown\fP
Either 'true' or 'false', specifies whether or not you want both the
directory and the manual page shown at start up.
.TP 18
\fBdirectoryHeight\fP
The height in pixels of the directory, when the directory and the manual page
are shown simultaneously.
.TP 18
\fBtopCursor\fP
The cursor to use in the top box.
.TP 18
\fBhelpCursor\fP
The cursor to use in the help window.
.TP 18
\fBmanpageCursor\fP
The cursor to use in the manual page window.
.TP 18
\fBsearchEntryCursor\fP
The cursor to use in the search entry text widget.
.TP 18 
\fBhelpFile\fP
Use this rather than the system default helpfile.
.TP 18
\fBtopBox\fP
Either 'true' or 'false', determines whether the top box (containing
the help, quit and manual page buttons) or a manual page is put on the screen
at start-up.  The default is true.
.TP 18
\fBverticalList\fP
Either 'true' or 'false', determines whether the directory listing is 
vertically or horizontally organized.  The default is horizontal (false).
.PP
.br
Here are a few examples of how to string all this information together into
a resource specification that can be used on the command line with the -xrm
flag, or added to your .Xresource or .Xdefaults file.
.TP 35
.B xman*Command.foreground: Blue
All command buttons will be blue.
.TP 35
.B xman*topBox*foreground: Blue
Everything in the top menu has a blue foreground.
.TP 35
.B xman*Text.border: Red
All text widgets have a red border.
.TP 35
.B xman*Label.font: 9x15  
All label buttons have a 9x15 font.
.PP
.SH FILES
/usr/man/* or those specified in the MANPATH.
.br 
mandesc
.PP
.SH "SEE ALSO"
X(1), X(8C), man(1), apropos(1), catman(8)
.PP
.SH ENVIRONMENT
DISPLAY - the default host and display to use.
.br
MANPATH - the search path for manual pages.  Directories are separated by
colons (e.g. /usr/man:/mit/kit/man:/foo/bar/man).
.PP
.SH BUGS
The -fn and -font option only specify the fonts for the command button
and not the text of the manpages or directories. 
.br
Protocol error upon selecting "Remove This Manpage".
.br
Specification of the \fImandesc\fP file format is not given in the man page.
.SH COPYRIGHT
Copyright 1988 by Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Chris Peterson, MIT Project Athena from the V10 version written by Barry
Shein of Boston University.
