#!/bin/sh
#
# To make the change from wwwoffle-2.9e to wwwoffle-2.9f
#
# 1) Change directory to the wwwoffle version 2.9e source directory.
#
# 2) Run wwwoffle-2.9e-2.9f.diff (requires GNU patch).
#
# 3) Compile it all.
#

patch -p0 -E < $0
if [ $? = 0 ]; then
   echo '----------------------------------------'
   echo 'wwwoffle 2.9e -> 2.9f patch applied succesfully.'
else
   echo '----------------------------------------'
   echo 'wwwoffle 2.9e -> 2.9f patch failed, check *.rej files.'
fi
exit

diff -c -a -r -P ../wwwoffle-2.9e/ChangeLog ./ChangeLog
*** ../wwwoffle-2.9e/ChangeLog	Sun Jan 25 16:03:58 2009
--- ./ChangeLog	Sun Jan 31 19:24:13 2010
***************
*** 1,3 ****
--- 1,90 ----
+ 2010-01-31  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	Version 2.9f of WWWOFFLE released.
+ 
+ 2010-01-31  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* doc/NEWS: Updated with news for this version.
+ 
+ 	* src/version.h: Updated version number.
+ 
+ 2010-01-22  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* src/document.c: Perform the MIME type check case insensitively.
+ 
+ 	* src/document.c:
+ 	Fix segmentation fault when getting list of references in parsed document.
+ 
+ 	* src/connect.c:
+ 	Clarify Last-Online and Last-Offline messages if never been online since
+ 	starting.
+ 
+ 2010-01-19  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* src/wwwoffles.c, src/ssl.c, src/https.c, doc/README.CONF:
+ 	Clarified documentation (SSL vs https) and improved error messages for https
+ 	failures.
+ 
+ 2009-11-29  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* doc/README.CONF:
+ 	Clarify the meaning of the DontCompress:mime-type option.
+ 
+ 2009-08-23  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* conf/wwwoffle.conf.template: Updated version number.
+ 
+ 2009-07-19  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* doc/README.CONF:
+ 	The webbugs are defined by what the HTML says, not what they actually are.
+ 
+ 2009-06-22  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* src/wwwoffles.c:
+ 	Return a 304 reply if online and the cached page won't be refreshed and meets
+ 	the conditions for this header.
+ 
+ 	* doc/README.CONF:
+ 	Clarification to request-conditional and validate-with-etag options.
+ 
+ 2009-06-07  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* src/parse.c:
+ 	Only remove "authorization" header if it is "basic" authentication.
+ 
+ 2009-05-28  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* doc/INSTALL, configure.in:
+ 	Remove the use of the libgnutls-config program and search for the library in the
+ 	normal configure script method.
+ 
+ 2009-04-25  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* doc/FAQ: Remove link to internet feedback form.
+ 
+ 2009-03-25  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* src/wwwoffles.c:
+ 	When making a HEAD request use the cached version if possible.
+ 
+ 2009-03-13  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
+ 
+ 	* doc/wwwoffle.man, src/connect.c, src/wwwoffle.c, src/wwwoffled.c:
+ 	Add a new option to the wwwoffle program to close and re-open the log file.
+ 
+ 	* src/css.l, src/html.l, src/htmlmodify.l:
+ 	Remove compilation warning with newer version of flex.
+ 
+ 	* conf/upgrade-config.pl, doc/CHANGES.CONF, doc/README.CONF, src/certificates.c,
+ 	src/config.h, src/configdata.c:
+ 	Add an option to expire certificates after a longer than default time.
+ 
+ 	* src/config.h, src/configdata.c, conf/upgrade-config.pl, doc/CHANGES.CONF, doc/README.CONF,
+ 	src/certificates.c:
+ 	Add an option to use a faster but weaker source of random numbers for key
+ 	generation (/dev/urandom instead of /dev/random).
+ 
  2009-01-25  Andrew M. Bishop  <amb@gedanken.demon.co.uk>
  
  	Version 2.9e of WWWOFFLE released.
diff -c -a -r -P ../wwwoffle-2.9e/LSM ./LSM
*** ../wwwoffle-2.9e/LSM	Sun Jan 25 16:06:37 2009
--- ./LSM	Sun Jan 31 19:26:13 2010
***************
*** 1,7 ****
  Begin3
  Title:          WWWOFFLE - World Wide Web Offline Explorer
! Version:        2.9e [Jan-25-09]
! Entered-date:   25JAN09
  Description:    A proxy HTTP/FTP server for computers with intermittent internet
                  access.
                  - Caching of pages viewed while connected for review later.
--- 1,7 ----
  Begin3
  Title:          WWWOFFLE - World Wide Web Offline Explorer
! Version:        2.9f [Jan-31-10]
! Entered-date:   31JAN10
  Description:    A proxy HTTP/FTP server for computers with intermittent internet
                  access.
                  - Caching of pages viewed while connected for review later.
***************
*** 18,24 ****
  Author:         amb@gedanken.demon.co.uk
  Maintained-by:  amb@gedanken.demon.co.uk
  Primary-site:   www.gedanken.demon.co.uk /download-wwwoffle
!                 1067k wwwoffle-2.9e.tgz
  Alternate-site: gedanken.demon.co.uk /download-wwwoffle
  Original-site:  
  Platforms:      UNIX
--- 18,24 ----
  Author:         amb@gedanken.demon.co.uk
  Maintained-by:  amb@gedanken.demon.co.uk
  Primary-site:   www.gedanken.demon.co.uk /download-wwwoffle
!                 1064k wwwoffle-2.9f.tgz
  Alternate-site: gedanken.demon.co.uk /download-wwwoffle
  Original-site:  
  Platforms:      UNIX
diff -c -a -r -P ../wwwoffle-2.9e/cache/html/en/FAQ.html ./cache/html/en/FAQ.html
*** ../wwwoffle-2.9e/cache/html/en/FAQ.html	Sun Jan 25 15:37:49 2009
--- ./cache/html/en/FAQ.html	Sun Jan 31 19:14:42 2010
***************
*** 945,951 ****
  <h3><a name="Q-6.1">Q 6.1   Who wrote WWWOFFLE, When and Why?</a></h3>
  <pre>
  The WWWOFFLE program was written by Andrew M. Bishop &lt;amb@gedanken.demon.co.uk&gt;
! in 1996,97,98,99,2000,01,02,03,04,05,06.
  
  There is a WWWOFFLE home-page on the World Wide Web, available via the author's
  home-page at <a href="http://www.gedanken.demon.co.uk/">http://www.gedanken.demon.co.uk/</a> .  This is kept updated with news
--- 945,951 ----
  <h3><a name="Q-6.1">Q 6.1   Who wrote WWWOFFLE, When and Why?</a></h3>
  <pre>
  The WWWOFFLE program was written by Andrew M. Bishop &lt;amb@gedanken.demon.co.uk&gt;
! between 1996 and 2009.
  
  There is a WWWOFFLE home-page on the World Wide Web, available via the author's
  home-page at <a href="http://www.gedanken.demon.co.uk/">http://www.gedanken.demon.co.uk/</a> .  This is kept updated with news
***************
*** 983,991 ****
  The Win32 version of the program was made possible by version beta-20 of the
  Cygwin development kit at the end of October 1998 when version 2.3e of WWWOFFLE
  was released.  Versions 2.4b and 2.5a of WWWOFFLE were also released for Win32
! although none of them work totally on most platforms due to incompatibilities.
  With version 1.1.7 of the cygwin DLL version 2.6a of WWWOFFLE is much more
! successful.
  
  The WWWOFFLE program can be freely distributed according to the terms of the GNU
  General Public License (see the file `COPYING').
--- 983,992 ----
  The Win32 version of the program was made possible by version beta-20 of the
  Cygwin development kit at the end of October 1998 when version 2.3e of WWWOFFLE
  was released.  Versions 2.4b and 2.5a of WWWOFFLE were also released for Win32
! although none of them worked totally on most platforms due to incompatibilities.
  With version 1.1.7 of the cygwin DLL version 2.6a of WWWOFFLE is much more
! successful.  The most recent versions should work with Cygwin, but no
! information about their current status is available.
  
  The WWWOFFLE program can be freely distributed according to the terms of the GNU
  General Public License (see the file `COPYING').
***************
*** 1010,1018 ****
  <h3><a name="Q-6.3">Q 6.3   How do I report bugs in WWWOFFLE?</a></h3>
  <pre>
  By e-mail, send them to me at &lt;amb@gedanken.demon.co.uk&gt; and put WWWOFFLE
! somewhere in the subject line.  You can also report bugs or provide comments via
! the feedback form on the WWWOFFLE home-page on the World Wide Web accessible via
! <a href="http://www.gedanken.demon.co.uk/">http://www.gedanken.demon.co.uk/</a> .
  
  Before doing this, you should check the FAQ and the WWWOFFLE web-page to see if
  the answer is there.  If it is not and you want to report it to me then it helps
--- 1011,1017 ----
  <h3><a name="Q-6.3">Q 6.3   How do I report bugs in WWWOFFLE?</a></h3>
  <pre>
  By e-mail, send them to me at &lt;amb@gedanken.demon.co.uk&gt; and put WWWOFFLE
! somewhere in the subject line.
  
  Before doing this, you should check the FAQ and the WWWOFFLE web-page to see if
  the answer is there.  If it is not and you want to report it to me then it helps
diff -c -a -r -P ../wwwoffle-2.9e/cache/html/en/README.CONF.html ./cache/html/en/README.CONF.html
*** ../wwwoffle-2.9e/cache/html/en/README.CONF.html	Sun Jan 25 15:37:49 2009
--- ./cache/html/en/README.CONF.html	Sun Jan 31 19:14:42 2010
***************
*** 318,332 ****
  
  <p>
  While online pages that are requested from the server will be
! conditional requests so that server only sends data if the page has
! changed (default=yes).
  
  <h3><a name="OnlineOptions_validate-with-etag"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] validate-with-etag = yes | no</h3>
  
  <p>
  When making a conditional request to a server enable the use of the
  HTTP/1.1 cache validator 'Etag' as well as modification time
! (default=yes).
  
  <h3><a name="OnlineOptions_try-without-password"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] try-without-password = yes | no</h3>
  
--- 318,333 ----
  
  <p>
  While online pages that are requested from the server will be
! conditional requests so that the server only sends data if the page
! has changed (default=yes).
  
  <h3><a name="OnlineOptions_validate-with-etag"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] validate-with-etag = yes | no</h3>
  
  <p>
  When making a conditional request to a server enable the use of the
  HTTP/1.1 cache validator 'Etag' as well as modification time
! 'If-Modified-Since' (default=yes).  The request-conditional option
! must also be selected for this option to take effect.
  
  <h3><a name="OnlineOptions_try-without-password"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] try-without-password = yes | no</h3>
  
***************
*** 425,486 ****
  <h2><a name="SSLOptions"></a>SSLOptions</h2>
  
  <p>
! Options that control how WWWOFFLE behaves when a connection is made to it for
! a Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no
! decryption or caching of the data) is possible.  When WWWOFFLE is compiled
! with the gnutls library it is possible configure WWWOFFLE to decrypt, cache
! and re-encrypt the connections.
  
  <h3><a name="SSLOptions_enable-caching"></a>enable-caching = yes | no</h3>
  
  <p>
! If caching (involving decryption and re-encryption) of Secure Sockets
! Layer (SSL) server connections is allowed (default = no).
  
  <h3><a name="SSLOptions_allow-tunnel"></a>allow-tunnel = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an SSL server that
! can be connected to using WWWOFFLE as a tunnelling proxy (no caching
! or decryption of the data) (default is no hosts or ports allowed).
! This option should be set to *:443 to allow https to the default port
! number.  There can be more than one option for other ports or hosts as
! required.  This option takes precedence over the allow-cache option.
! The host value is matched against the URL as presented, no hostname to
! IP or IP to hostname lookups are performed to find alternative
! equivalent names.
  
  <h3><a name="SSLOptions_disallow-tunnel"></a>disallow-tunnel = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an SSL server that
! can not be connected to using WWWOFFLE as a tunnelling proxy.  There
! can be more than one option for other ports or hosts as required.
! This option takes precedence over the allow-tunnel option.  The host
! value is matched against the URL as presented, no hostname to IP or IP
! to hostname lookups are performed to find alternative equivalent
! names.
  
  <h3><a name="SSLOptions_allow-cache"></a>allow-cache = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an SSL server that
! can be connected to using WWWOFFLE as a caching proxy (decryption of
! the data) (default is no hosts or ports allowed).  This option should
! be set to *:443 to allow https to the default port number.  There can
! be more than one option for other ports or hosts as required.  The
! host value is matched against the URL as presented, no hostname to IP
! or IP to hostname lookups are performed to find alternative equivalent
! names.
  
  <h3><a name="SSLOptions_disallow-cache"></a>disallow-cache = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an SSL server that
! can not be connected to using WWWOFFLE as a caching proxy.  This
  option takes precedence over the allow-cache option.  The host value
  is matched against the URL as presented, no hostname to IP or IP to
  hostname lookups are performed to find alternative equivalent names.
  
  <h2><a name="FetchOptions"></a>FetchOptions</h2>
  
--- 426,503 ----
  <h2><a name="SSLOptions"></a>SSLOptions</h2>
  
  <p>
! Options that control how WWWOFFLE behaves when a connection is made to it for an
! https or Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no
! decryption or caching of the data) is possible.  When WWWOFFLE is compiled with
! the gnutls library it is possible configure WWWOFFLE to decrypt, cache and
! re-encrypt the connections.
! 
! <h3><a name="SSLOptions_quick-key-gen"></a>quick-key-gen = yes | no</h3>
! 
! <p>
! Normally generation of secret keys for the SSL/https functions uses the
! default GnuTLS option for random number source.  This can be slow on
! some machines so this option selects a quicker but less secure random
! number source (default = no).  Requires GnuTLS compilation option.
! 
! <h3><a name="SSLOptions_expiration-time"></a>expiration-time = (age)</h3>
! 
! <p>
! The length of time after creation that each certificate will expire
! (default = 1y).  Requires GnuTLS compilation option.
  
  <h3><a name="SSLOptions_enable-caching"></a>enable-caching = yes | no</h3>
  
  <p>
! If caching (involving decryption and re-encryption) of SSL/https
! server connections is allowed (default = no).  Requires GnuTLS
! compilation option.
  
  <h3><a name="SSLOptions_allow-tunnel"></a>allow-tunnel = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an https/SSL server
! that can be connected to using WWWOFFLE as a tunnelling proxy (no
! caching or decryption of the data) (default is no hosts or ports
! allowed).  This option should be set to *:443 to allow https to the
! default port number.  There can be more than one option for other
! ports or hosts as required.  This option takes precedence over the
! allow-cache option.  The host value is matched against the URL as
! presented, no hostname to IP or IP to hostname lookups are performed
! to find alternative equivalent names.
  
  <h3><a name="SSLOptions_disallow-tunnel"></a>disallow-tunnel = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an https/SSL server
! that can not be connected to using WWWOFFLE as a tunnelling proxy.
! There can be more than one option for other ports or hosts as
! required.  This option takes precedence over the allow-tunnel option.
! The host value is matched against the URL as presented, no hostname to
! IP or IP to hostname lookups are performed to find alternative
! equivalent names.
  
  <h3><a name="SSLOptions_allow-cache"></a>allow-cache = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an https/SSL server
! that can be connected to using WWWOFFLE as a caching proxy (decryption
! of the data) (default is no hosts or ports allowed).  This option
! should be set to *:443 to allow https to the default port number.
! There can be more than one option for other ports or hosts as
! required.  The host value is matched against the URL as presented, no
! hostname to IP or IP to hostname lookups are performed to find
! alternative equivalent names.  Requires GnuTLS compilation option.
  
  <h3><a name="SSLOptions_disallow-cache"></a>disallow-cache = (host[:port])</h3>
  
  <p>
! A hostname and port number (a <a href="#WILDCARD">WILDCARD</a> match) for an https/SSL server
! that can not be connected to using WWWOFFLE as a caching proxy.  This
  option takes precedence over the allow-cache option.  The host value
  is matched against the URL as presented, no hostname to IP or IP to
  hostname lookups are performed to find alternative equivalent names.
+ Requires GnuTLS compilation option.
  
  <h2><a name="FetchOptions"></a>FetchOptions</h2>
  
***************
*** 501,510 ****
  <h3><a name="FetchOptions_webbug-images"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] webbug-images = yes | no</h3>
  
  <p>
! If images that are 1 pixel square are also to be fetched, requires the
! images option to also be selected. (default=yes).  If these images are
! not fetched then the replace-webbug-images option in the ModifyHTML
! section can be used to stop browsers requesting them.
  
  <h3><a name="FetchOptions_icon-images"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] icon-images = yes | no</h3>
  
--- 518,528 ----
  <h3><a name="FetchOptions_webbug-images"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] webbug-images = yes | no</h3>
  
  <p>
! If images that are declared in the HTML to be 1 pixel square are also to
! be fetched, requires the images option to also be selected
! (default=yes).  If these images are not fetched then the
! replace-webbug-images option in the ModifyHTML section can be used to
! stop browsers requesting them.
  
  <h3><a name="FetchOptions_icon-images"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] icon-images = yes | no</h3>
  
***************
*** 873,886 ****
  
  <p>
  A list of MIME types and file extensions that are not to be compressed by
! WWWOFFLE (because they are already compressed or not not worth compressing).
  Requires zlib compilation option.
  
  <h3><a name="DontCompress_mime-type"></a>mime-type = (mime-type)/(subtype)</h3>
  
  <p>
! The MIME type of a URL that is not to be compressed in the cache or
! when providing compressed pages to clients.
  
  <h3><a name="DontCompress_file-ext"></a>file-ext = .(file-ext)</h3>
  
--- 891,904 ----
  
  <p>
  A list of MIME types and file extensions that are not to be compressed by
! WWWOFFLE (because they are already compressed or not worth compressing).
  Requires zlib compilation option.
  
  <h3><a name="DontCompress_mime-type"></a>mime-type = (mime-type)/(subtype)</h3>
  
  <p>
! The MIME type of a URL that is not to be compressed in the cache (when
! purging) or when providing pages to clients.
  
  <h3><a name="DontCompress_file-ext"></a>file-ext = .(file-ext)</h3>
  
***************
*** 1011,1019 ****
  <h3><a name="Proxy_ssl"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] ssl = (host[:port])</h3>
  
  <p>
! A proxy server that should be used for Secure Socket Layer (SSL)
! connections e.g. https.  Note that for the &lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt; that only the
! host is checked and that the other parts must be '*' <a href="#WILDCARD">WILDCARD</a>s.
  
  <h2><a name="Alias"></a>Alias</h2>
  
--- 1029,1037 ----
  <h3><a name="Proxy_ssl"></a>[&lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt;] ssl = (host[:port])</h3>
  
  <p>
! A proxy server that should be used for https or Secure Socket Layer
! (SSL) connections.  Note that for the &lt;<a href="#URL-SPECIFICATION">URL-SPEC</a>&gt; that only the host is
! checked and that the other parts must be '*' <a href="#WILDCARD">WILDCARD</a>s.
  
  <h2><a name="Alias"></a>Alias</h2>
  
diff -c -a -r -P ../wwwoffle-2.9e/cache/html/en/messages/README.CONF.txt ./cache/html/en/messages/README.CONF.txt
*** ../wwwoffle-2.9e/cache/html/en/messages/README.CONF.txt	Sun Jan 25 15:37:49 2009
--- ./cache/html/en/messages/README.CONF.txt	Sun Jan 31 19:14:42 2010
***************
*** 117,126 ****
  While online pages that redirect the client to another URL temporarily will be requested again. (default=no).  This option takes precedence over the request-changed and request-changed-once options.
  ITEM request-conditional
  [<URL-SPEC>] request-conditional = yes | no
! While online pages that are requested from the server will be conditional requests so that server only sends data if the page has changed (default=yes).
  ITEM validate-with-etag
  [<URL-SPEC>] validate-with-etag = yes | no
! When making a conditional request to a server enable the use of the HTTP/1.1 cache validator 'Etag' as well as modification time (default=yes).
  ITEM try-without-password
  [<URL-SPEC>] try-without-password = yes | no
  If a request is made for a URL that contains a username and password then a request is made for the same URL without a username and password specified (default=yes).  This allows for requests for the URL without a password to re-direct the client to the passworded version.
--- 117,126 ----
  While online pages that redirect the client to another URL temporarily will be requested again. (default=no).  This option takes precedence over the request-changed and request-changed-once options.
  ITEM request-conditional
  [<URL-SPEC>] request-conditional = yes | no
! While online pages that are requested from the server will be conditional requests so that the server only sends data if the page has changed (default=yes).
  ITEM validate-with-etag
  [<URL-SPEC>] validate-with-etag = yes | no
! When making a conditional request to a server enable the use of the HTTP/1.1 cache validator 'Etag' as well as modification time 'If-Modified-Since' (default=yes).  The request-conditional option must also be selected for this option to take effect.
  ITEM try-without-password
  [<URL-SPEC>] try-without-password = yes | no
  If a request is made for a URL that contains a username and password then a request is made for the same URL without a username and password specified (default=yes).  This allows for requests for the URL without a password to re-direct the client to the passworded version.
***************
*** 163,184 ****
  [<URL-SPEC>] dont-request = yes | no
  Do not request any URLs that match this when offline (default=no).
  SECTION SSLOptions
! Options that control how WWWOFFLE behaves when a connection is made to it for a Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no decryption or caching of the data) is possible.  When WWWOFFLE is compiled with the gnutls library it is possible configure WWWOFFLE to decrypt, cache and re-encrypt the connections.
  ITEM enable-caching
  enable-caching = yes | no
! If caching (involving decryption and re-encryption) of Secure Sockets Layer (SSL) server connections is allowed (default = no).
  ITEM allow-tunnel
  allow-tunnel = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an SSL server that can be connected to using WWWOFFLE as a tunnelling proxy (no caching or decryption of the data) (default is no hosts or ports allowed). This option should be set to *:443 to allow https to the default port number.  There can be more than one option for other ports or hosts as required.  This option takes precedence over the allow-cache option. The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names.
  ITEM disallow-tunnel
  disallow-tunnel = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an SSL server that can not be connected to using WWWOFFLE as a tunnelling proxy.  There can be more than one option for other ports or hosts as required. This option takes precedence over the allow-tunnel option.  The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names.
  ITEM allow-cache
  allow-cache = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an SSL server that can be connected to using WWWOFFLE as a caching proxy (decryption of the data) (default is no hosts or ports allowed).  This option should be set to *:443 to allow https to the default port number.  There can be more than one option for other ports or hosts as required.  The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names.
  ITEM disallow-cache
  disallow-cache = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an SSL server that can not be connected to using WWWOFFLE as a caching proxy.  This option takes precedence over the allow-cache option.  The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names.
  SECTION FetchOptions
  Options that control what linked elements are downloaded when fetching pages that were requested while offline.
  ITEM stylesheets
--- 163,190 ----
  [<URL-SPEC>] dont-request = yes | no
  Do not request any URLs that match this when offline (default=no).
  SECTION SSLOptions
! Options that control how WWWOFFLE behaves when a connection is made to it for an https or Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no decryption or caching of the data) is possible.  When WWWOFFLE is compiled with the gnutls library it is possible configure WWWOFFLE to decrypt, cache and re-encrypt the connections.
! ITEM quick-key-gen
! quick-key-gen = yes | no
! Normally generation of secret keys for the SSL/https functions uses the default GnuTLS option for random number source.  This can be slow on some machines so this option selects a quicker but less secure random number source (default = no).  Requires GnuTLS compilation option.
! ITEM expiration-time
! expiration-time = (age)
! The length of time after creation that each certificate will expire (default = 1y).  Requires GnuTLS compilation option.
  ITEM enable-caching
  enable-caching = yes | no
! If caching (involving decryption and re-encryption) of SSL/https server connections is allowed (default = no).  Requires GnuTLS compilation option.
  ITEM allow-tunnel
  allow-tunnel = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an https/SSL server that can be connected to using WWWOFFLE as a tunnelling proxy (no caching or decryption of the data) (default is no hosts or ports allowed).  This option should be set to *:443 to allow https to the default port number.  There can be more than one option for other ports or hosts as required.  This option takes precedence over the allow-cache option.  The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names.
  ITEM disallow-tunnel
  disallow-tunnel = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an https/SSL server that can not be connected to using WWWOFFLE as a tunnelling proxy. There can be more than one option for other ports or hosts as required.  This option takes precedence over the allow-tunnel option. The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names.
  ITEM allow-cache
  allow-cache = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an https/SSL server that can be connected to using WWWOFFLE as a caching proxy (decryption of the data) (default is no hosts or ports allowed).  This option should be set to *:443 to allow https to the default port number. There can be more than one option for other ports or hosts as required.  The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names.  Requires GnuTLS compilation option.
  ITEM disallow-cache
  disallow-cache = (host[:port])
! A hostname and port number (a <a href="/configuration/#WILDCARD">WILDCARD</a> match) for an https/SSL server that can not be connected to using WWWOFFLE as a caching proxy.  This option takes precedence over the allow-cache option.  The host value is matched against the URL as presented, no hostname to IP or IP to hostname lookups are performed to find alternative equivalent names. Requires GnuTLS compilation option.
  SECTION FetchOptions
  Options that control what linked elements are downloaded when fetching pages that were requested while offline.
  ITEM stylesheets
***************
*** 189,195 ****
  If images are to be fetched (default=no).
  ITEM webbug-images
  [<URL-SPEC>] webbug-images = yes | no
! If images that are 1 pixel square are also to be fetched, requires the images option to also be selected. (default=yes).  If these images are not fetched then the replace-webbug-images option in the ModifyHTML section can be used to stop browsers requesting them.
  ITEM icon-images
  [<URL-SPEC>] icon-images = yes | no
  If icons (also called favourite icons or shortcut icons) as used by browsers for bookmarks are to be fetched (default=no).
--- 195,201 ----
  If images are to be fetched (default=no).
  ITEM webbug-images
  [<URL-SPEC>] webbug-images = yes | no
! If images that are declared in the HTML to be 1 pixel square are also to be fetched, requires the images option to also be selected (default=yes).  If these images are not fetched then the replace-webbug-images option in the ModifyHTML section can be used to stop browsers requesting them.
  ITEM icon-images
  [<URL-SPEC>] icon-images = yes | no
  If icons (also called favourite icons or shortcut icons) as used by browsers for bookmarks are to be fetched (default=no).
***************
*** 354,363 ****
  <URL-SPEC> location-error = yes | no
  When a URL reply contains a 'Location' header that redirects to a URL that is not got (specified in this section) then the reply is modified to be an error message instead (default=no).  This will stop ISP proxies from redirecting users to adverts if the advert URLs are in this section.
  SECTION DontCompress
! A list of MIME types and file extensions that are not to be compressed by WWWOFFLE (because they are already compressed or not not worth compressing). Requires zlib compilation option.
  ITEM mime-type
  mime-type = (mime-type)/(subtype)
! The MIME type of a URL that is not to be compressed in the cache or when providing compressed pages to clients.
  ITEM file-ext
  file-ext = .(file-ext)
  The file extension of a URL that is not to be requested compressed from a server.
--- 360,369 ----
  <URL-SPEC> location-error = yes | no
  When a URL reply contains a 'Location' header that redirects to a URL that is not got (specified in this section) then the reply is modified to be an error message instead (default=no).  This will stop ISP proxies from redirecting users to adverts if the advert URLs are in this section.
  SECTION DontCompress
! A list of MIME types and file extensions that are not to be compressed by WWWOFFLE (because they are already compressed or not worth compressing). Requires zlib compilation option.
  ITEM mime-type
  mime-type = (mime-type)/(subtype)
! The MIME type of a URL that is not to be compressed in the cache (when purging) or when providing pages to clients.
  ITEM file-ext
  file-ext = .(file-ext)
  The file extension of a URL that is not to be requested compressed from a server.
***************
*** 413,419 ****
  The password to use on a proxy host to authenticate WWWOFFLE to it. The <a href="/configuration/#URL-SPECIFICATION">URL-SPEC</a> in this case refers to the proxy and not the URL being retrieved.
  ITEM ssl
  [<URL-SPEC>] ssl = (host[:port])
! A proxy server that should be used for Secure Socket Layer (SSL) connections e.g. https.  Note that for the &lt;<a href="/configuration/#URL-SPECIFICATION">URL-SPEC</a>&gt; that only the host is checked and that the other parts must be '*' <a href="/configuration/#WILDCARD">WILDCARD</a>s.
  SECTION Alias
  A list of aliases that are used to replace the server name and path with another server name and path.
  ITEM 
--- 419,425 ----
  The password to use on a proxy host to authenticate WWWOFFLE to it. The <a href="/configuration/#URL-SPECIFICATION">URL-SPEC</a> in this case refers to the proxy and not the URL being retrieved.
  ITEM ssl
  [<URL-SPEC>] ssl = (host[:port])
! A proxy server that should be used for https or Secure Socket Layer (SSL) connections.  Note that for the &lt;<a href="/configuration/#URL-SPECIFICATION">URL-SPEC</a>&gt; that only the host is checked and that the other parts must be '*' <a href="/configuration/#WILDCARD">WILDCARD</a>s.
  SECTION Alias
  A list of aliases that are used to replace the server name and path with another server name and path.
  ITEM 
diff -c -a -r -P ../wwwoffle-2.9e/cache/html/en/wwwoffle.css ./cache/html/en/wwwoffle.css
*** ../wwwoffle-2.9e/cache/html/en/wwwoffle.css	Sat Jul 23 20:17:10 2005
--- ./cache/html/en/wwwoffle.css	Thu Mar 26 17:02:58 2009
***************
*** 289,294 ****
--- 289,301 ----
   white-space:     normal;
  }
  
+ DIV.wwwoffle-addinfo A:hover, DIV.wwwoffle-addinfo A:focus, DIV.wwwoffle-addinfo A:visited, DIV.wwwoffle-addinfo A:link
+ {
+  /* Undo any color manipulation CSS inherited from page (CSS 2.0 section 14) */
+  color:      blue;
+  background: white;
+ }
+ 
  HR.wwwoffle-addinfo  /* Horizontal rule, not needed, see DIV */
  {
   display: none;
diff -c -a -r -P ../wwwoffle-2.9e/conf/upgrade-config.pl ./conf/upgrade-config.pl
*** ../wwwoffle-2.9e/conf/upgrade-config.pl	Sat Sep 29 19:51:32 2007
--- ./conf/upgrade-config.pl	Fri Mar 13 19:10:00 2009
***************
*** 1,12 ****
  #!/bin/sh
  #
! # WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
  #
! # A Perl script to update the configuration file to version 2.9d standard (from version 2.8).
  #
  # Written by Andrew M. Bishop
  #
! # This file Copyright 2000-2007 Andrew M. Bishop
  # It may be distributed under the GNU Public License, version 2, or
  # any higher version.  See section COPYING of the GNU Public license
  # for conditions under which this file may be redistributed.
--- 1,12 ----
  #!/bin/sh
  #
! # WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
  #
! # A Perl script to update the configuration file to version 2.9f standard (from version 2.8).
  #
  # Written by Andrew M. Bishop
  #
! # This file Copyright 2000-2009 Andrew M. Bishop
  # It may be distributed under the GNU Public License, version 2, or
  # any higher version.  See section COPYING of the GNU Public license
  # for conditions under which this file may be redistributed.
***************
*** 22,28 ****
  
  $conf=$ARGV[0];
  
! $version="2.9";
  
  $urlspec="[^ \t:<!]+://[^ \t/=]+/?[^ \t=>]*";
  $urlspec1="([^ \t:<!]+)://([^ \t/=]+)(/?[^ \t=>]*)";
--- 22,28 ----
  
  $conf=$ARGV[0];
  
! $version="2.9f";
  
  $urlspec="[^ \t:<!]+://[^ \t/=]+/?[^ \t=>]*";
  $urlspec1="([^ \t:<!]+)://([^ \t/=]+)(/?[^ \t=>]*)";
***************
*** 34,39 ****
--- 34,41 ----
               );
  
  %new_SSLOptions=(
+                  "quick-key-gen *="   , "quick-key-gen = no",
+                  "expiration-time *=" , "expiration-time = 1y",
                   "enable-caching *="  , "enable-caching = no",
                   "allow-tunnel *="    , "#allow-tunnel = *:443"
                  );
diff -c -a -r -P ../wwwoffle-2.9e/conf/wwwoffle.conf ./conf/wwwoffle.conf
*** ../wwwoffle-2.9e/conf/wwwoffle.conf	Sun Jan 25 15:37:50 2009
--- ./conf/wwwoffle.conf	Sun Jan 31 19:14:43 2010
***************
*** 1,9 ****
  #
! # WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
  #
  # WWWOFFLE Configuration file CONFDIR/wwwoffle.conf
  #
! # Example configuration file Copyright 1997-2007 Andrew M. Bishop.
  # They may be distributed under the GNU Public License, version 2, or
  # any higher version.  See section COPYING of the GNU Public license
  # for conditions under which this file may be redistributed.
--- 1,9 ----
  #
! # WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
  #
  # WWWOFFLE Configuration file CONFDIR/wwwoffle.conf
  #
! # Example configuration file Copyright 1997-2009 Andrew M. Bishop.
  # They may be distributed under the GNU Public License, version 2, or
  # any higher version.  See section COPYING of the GNU Public license
  # for conditions under which this file may be redistributed.
***************
*** 298,310 ****
  #
  # [<URL-SPEC>] request-conditional = yes | no
  #         While online pages that are requested from the server will be
! #         conditional requests so that server only sends data if the page has
! #         changed (default=yes).
  #
  # [<URL-SPEC>] validate-with-etag = yes | no
  #         When making a conditional request to a server enable the use of the
  #         HTTP/1.1 cache validator 'Etag' as well as modification time
! #         (default=yes).
  #
  # [<URL-SPEC>] try-without-password = yes | no
  #         If a request is made for a URL that contains a username and password
--- 298,311 ----
  #
  # [<URL-SPEC>] request-conditional = yes | no
  #         While online pages that are requested from the server will be
! #         conditional requests so that the server only sends data if the page
! #         has changed (default=yes).
  #
  # [<URL-SPEC>] validate-with-etag = yes | no
  #         When making a conditional request to a server enable the use of the
  #         HTTP/1.1 cache validator 'Etag' as well as modification time
! #         'If-Modified-Since' (default=yes).  The request-conditional option
! #         must also be selected for this option to take effect.
  #
  # [<URL-SPEC>] try-without-password = yes | no
  #         If a request is made for a URL that contains a username and password
***************
*** 430,481 ****
  # SSLOptions
  # ----------
  #
! # Options that control how WWWOFFLE behaves when a connection is made to it for
! # a Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no
! # decryption or caching of the data) is possible.  When WWWOFFLE is compiled
! # with the gnutls library it is possible configure WWWOFFLE to decrypt, cache
! # and re-encrypt the connections.
  #
  # enable-caching = yes | no
! #         If caching (involving decryption and re-encryption) of Secure Sockets
! #         Layer (SSL) server connections is allowed (default = no).
  #
  # allow-tunnel = (host[:port])
! #         A hostname and port number (a WILDCARD match) for an SSL server that
! #         can be connected to using WWWOFFLE as a tunnelling proxy (no caching
! #         or decryption of the data) (default is no hosts or ports allowed).
! #         This option should be set to *:443 to allow https to the default port
! #         number.  There can be more than one option for other ports or hosts as
! #         required.  This option takes precedence over the allow-cache option.
  #         The host value is matched against the URL as presented, no hostname to
  #         IP or IP to hostname lookups are performed to find alternative
  #         equivalent names.
  #
- # disallow-tunnel = (host[:port])
- #         A hostname and port number (a WILDCARD match) for an SSL server that
- #         can not be connected to using WWWOFFLE as a tunnelling proxy.  There
- #         can be more than one option for other ports or hosts as required.
- #         This option takes precedence over the allow-tunnel option.  The host
- #         value is matched against the URL as presented, no hostname to IP or IP
- #         to hostname lookups are performed to find alternative equivalent
- #         names.
- #
  # allow-cache = (host[:port])
! #         A hostname and port number (a WILDCARD match) for an SSL server that
! #         can be connected to using WWWOFFLE as a caching proxy (decryption of
! #         the data) (default is no hosts or ports allowed).  This option should
! #         be set to *:443 to allow https to the default port number.  There can
! #         be more than one option for other ports or hosts as required.  The
! #         host value is matched against the URL as presented, no hostname to IP
! #         or IP to hostname lookups are performed to find alternative equivalent
! #         names.
  #
  # disallow-cache = (host[:port])
! #         A hostname and port number (a WILDCARD match) for an SSL server that
! #         can not be connected to using WWWOFFLE as a caching proxy.  This
  #         option takes precedence over the allow-cache option.  The host value
  #         is matched against the URL as presented, no hostname to IP or IP to
  #         hostname lookups are performed to find alternative equivalent names.
  #
  
  SSLOptions
--- 431,494 ----
  # SSLOptions
  # ----------
  #
! # Options that control how WWWOFFLE behaves when a connection is made to it for an
! # https or Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no
! # decryption or caching of the data) is possible.  When WWWOFFLE is compiled with
! # the gnutls library it is possible configure WWWOFFLE to decrypt, cache and
! # re-encrypt the connections.
! #
! # quick-key-gen = yes | no
! #         Normally generation of secret keys for the SSL/https functions uses the
! #         default GnuTLS option for random number source.  This can be slow on
! #         some machines so this option selects a quicker but less secure random
! #         number source (default = no).  Requires GnuTLS compilation option.
! #
! # expiration-time = (age)
! #         The length of time after creation that each certificate will expire
! #         (default = 1y).  Requires GnuTLS compilation option.
  #
  # enable-caching = yes | no
! #         If caching (involving decryption and re-encryption) of SSL/https
! #         server connections is allowed (default = no).  Requires GnuTLS
! #         compilation option.
  #
  # allow-tunnel = (host[:port])
! #         A hostname and port number (a WILDCARD match) for an https/SSL server
! #         that can be connected to using WWWOFFLE as a tunnelling proxy (no
! #         caching or decryption of the data) (default is no hosts or ports
! #         allowed).  This option should be set to *:443 to allow https to the
! #         default port number.  There can be more than one option for other
! #         ports or hosts as required.  This option takes precedence over the
! #         allow-cache option.  The host value is matched against the URL as
! #         presented, no hostname to IP or IP to hostname lookups are performed
! #         to find alternative equivalent names.
! #
! # disallow-tunnel = (host[:port])
! #         A hostname and port number (a WILDCARD match) for an https/SSL server
! #         that can not be connected to using WWWOFFLE as a tunnelling proxy.
! #         There can be more than one option for other ports or hosts as
! #         required.  This option takes precedence over the allow-tunnel option.
  #         The host value is matched against the URL as presented, no hostname to
  #         IP or IP to hostname lookups are performed to find alternative
  #         equivalent names.
  #
  # allow-cache = (host[:port])
! #         A hostname and port number (a WILDCARD match) for an https/SSL server
! #         that can be connected to using WWWOFFLE as a caching proxy (decryption
! #         of the data) (default is no hosts or ports allowed).  This option
! #         should be set to *:443 to allow https to the default port number.
! #         There can be more than one option for other ports or hosts as
! #         required.  The host value is matched against the URL as presented, no
! #         hostname to IP or IP to hostname lookups are performed to find
! #         alternative equivalent names.  Requires GnuTLS compilation option.
  #
  # disallow-cache = (host[:port])
! #         A hostname and port number (a WILDCARD match) for an https/SSL server
! #         that can not be connected to using WWWOFFLE as a caching proxy.  This
  #         option takes precedence over the allow-cache option.  The host value
  #         is matched against the URL as presented, no hostname to IP or IP to
  #         hostname lookups are performed to find alternative equivalent names.
+ #         Requires GnuTLS compilation option.
  #
  
  SSLOptions
***************
*** 500,509 ****
  #         If images are to be fetched (default=no).
  #
  # [<URL-SPEC>] webbug-images = yes | no
! #         If images that are 1 pixel square are also to be fetched, requires the
! #         images option to also be selected. (default=yes).  If these images are
! #         not fetched then the replace-webbug-images option in the ModifyHTML
! #         section can be used to stop browsers requesting them.
  #
  # [<URL-SPEC>] icon-images = yes | no
  #         If icons (also called favourite icons or shortcut icons) as used by
--- 513,523 ----
  #         If images are to be fetched (default=no).
  #
  # [<URL-SPEC>] webbug-images = yes | no
! #         If images that are declared in the HTML to be 1 pixel square are also to
! #         be fetched, requires the images option to also be selected
! #         (default=yes).  If these images are not fetched then the
! #         replace-webbug-images option in the ModifyHTML section can be used to
! #         stop browsers requesting them.
  #
  # [<URL-SPEC>] icon-images = yes | no
  #         If icons (also called favourite icons or shortcut icons) as used by
***************
*** 959,970 ****
  # ------------
  #
  # A list of MIME types and file extensions that are not to be compressed by
! # WWWOFFLE (because they are already compressed or not not worth compressing).
  # Requires zlib compilation option.
  #
  # mime-type = (mime-type)/(subtype)
! #         The MIME type of a URL that is not to be compressed in the cache or
! #         when providing compressed pages to clients.
  #
  # file-ext = .(file-ext)
  #         The file extension of a URL that is not to be requested compressed
--- 973,984 ----
  # ------------
  #
  # A list of MIME types and file extensions that are not to be compressed by
! # WWWOFFLE (because they are already compressed or not worth compressing).
  # Requires zlib compilation option.
  #
  # mime-type = (mime-type)/(subtype)
! #         The MIME type of a URL that is not to be compressed in the cache (when
! #         purging) or when providing pages to clients.
  #
  # file-ext = .(file-ext)
  #         The file extension of a URL that is not to be requested compressed
***************
*** 1203,1211 ****
  #         retrieved.
  #
  # [<URL-SPEC>] ssl = (host[:port])
! #         A proxy server that should be used for Secure Socket Layer (SSL)
! #         connections e.g. https.  Note that for the <URL-SPEC> that only the
! #         host is checked and that the other parts must be '*' WILDCARDs.
  #
  
  Proxy
--- 1217,1225 ----
  #         retrieved.
  #
  # [<URL-SPEC>] ssl = (host[:port])
! #         A proxy server that should be used for https or Secure Socket Layer
! #         (SSL) connections.  Note that for the <URL-SPEC> that only the host is
! #         checked and that the other parts must be '*' WILDCARDs.
  #
  
  Proxy
diff -c -a -r -P ../wwwoffle-2.9e/conf/wwwoffle.conf.template ./conf/wwwoffle.conf.template
*** ../wwwoffle-2.9e/conf/wwwoffle.conf.template	Sat Sep 29 19:51:16 2007
--- ./conf/wwwoffle.conf.template	Sun Aug 23 10:19:37 2009
***************
*** 1,9 ****
  #
! # WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
  #
  # WWWOFFLE Configuration file CONFDIR/wwwoffle.conf
  #
! # Example configuration file Copyright 1997-2007 Andrew M. Bishop.
  # They may be distributed under the GNU Public License, version 2, or
  # any higher version.  See section COPYING of the GNU Public license
  # for conditions under which this file may be redistributed.
--- 1,9 ----
  #
! # WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
  #
  # WWWOFFLE Configuration file CONFDIR/wwwoffle.conf
  #
! # Example configuration file Copyright 1997-2009 Andrew M. Bishop.
  # They may be distributed under the GNU Public License, version 2, or
  # any higher version.  See section COPYING of the GNU Public license
  # for conditions under which this file may be redistributed.
diff -c -a -r -P ../wwwoffle-2.9e/config.guess ./config.guess
*** ../wwwoffle-2.9e/config.guess	Sun Apr 24 21:01:25 2005
--- ./config.guess	Mon May  4 00:55:47 2009
***************
*** 1,9 ****
  #! /bin/sh
  # Attempt to guess a canonical system name.
  #   Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
! #   2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.
  
! timestamp='2005-04-22'
  
  # This file is free software; you can redistribute it and/or modify it
  # under the terms of the GNU General Public License as published by
--- 1,10 ----
  #! /bin/sh
  # Attempt to guess a canonical system name.
  #   Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
! #   2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008
! #   Free Software Foundation, Inc.
  
! timestamp='2009-04-27'
  
  # This file is free software; you can redistribute it and/or modify it
  # under the terms of the GNU General Public License as published by
***************
*** 17,29 ****
  #
  # You should have received a copy of the GNU General Public License
  # along with this program; if not, write to the Free Software
! # Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  #
  # As a special exception to the GNU General Public License, if you
  # distribute this file as part of a program that contains a
  # configuration script generated by Autoconf, you may include it under
  # the same distribution terms that you use for the rest of that program.
  
  # Originally written by Per Bothner <per@bothner.com>.
  # Please send patches to <config-patches@gnu.org>.  Submit a context
  # diff and a properly formatted ChangeLog entry.
--- 18,32 ----
  #
  # You should have received a copy of the GNU General Public License
  # along with this program; if not, write to the Free Software
! # Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA
! # 02110-1301, USA.
  #
  # As a special exception to the GNU General Public License, if you
  # distribute this file as part of a program that contains a
  # configuration script generated by Autoconf, you may include it under
  # the same distribution terms that you use for the rest of that program.
  
+ 
  # Originally written by Per Bothner <per@bothner.com>.
  # Please send patches to <config-patches@gnu.org>.  Submit a context
  # diff and a properly formatted ChangeLog entry.
***************
*** 53,60 ****
  GNU config.guess ($timestamp)
  
  Originally written by Per Bothner.
! Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005
! Free Software Foundation, Inc.
  
  This is free software; see the source for copying conditions.  There is NO
  warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
--- 56,63 ----
  GNU config.guess ($timestamp)
  
  Originally written by Per Bothner.
! Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001,
! 2002, 2003, 2004, 2005, 2006, 2007, 2008 Free Software Foundation, Inc.
  
  This is free software; see the source for copying conditions.  There is NO
  warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
***************
*** 66,76 ****
  while test $# -gt 0 ; do
    case $1 in
      --time-stamp | --time* | -t )
!        echo "$timestamp" ; exit 0 ;;
      --version | -v )
!        echo "$version" ; exit 0 ;;
      --help | --h* | -h )
!        echo "$usage"; exit 0 ;;
      -- )     # Stop option processing
         shift; break ;;
      - )	# Use stdin as input.
--- 69,79 ----
  while test $# -gt 0 ; do
    case $1 in
      --time-stamp | --time* | -t )
!        echo "$timestamp" ; exit ;;
      --version | -v )
!        echo "$version" ; exit ;;
      --help | --h* | -h )
!        echo "$usage"; exit ;;
      -- )     # Stop option processing
         shift; break ;;
      - )	# Use stdin as input.
***************
*** 104,110 ****
  trap "exitcode=\$?; (rm -f \$tmpfiles 2>/dev/null; rmdir \$tmp 2>/dev/null) && exit \$exitcode" 0 ;
  trap "rm -f \$tmpfiles 2>/dev/null; rmdir \$tmp 2>/dev/null; exit 1" 1 2 13 15 ;
  : ${TMPDIR=/tmp} ;
!  { tmp=`(umask 077 && mktemp -d -q "$TMPDIR/cgXXXXXX") 2>/dev/null` && test -n "$tmp" && test -d "$tmp" ; } ||
   { test -n "$RANDOM" && tmp=$TMPDIR/cg$$-$RANDOM && (umask 077 && mkdir $tmp) ; } ||
   { tmp=$TMPDIR/cg-$$ && (umask 077 && mkdir $tmp) && echo "Warning: creating insecure temp directory" >&2 ; } ||
   { echo "$me: cannot create a temporary directory in $TMPDIR" >&2 ; exit 1 ; } ;
--- 107,113 ----
  trap "exitcode=\$?; (rm -f \$tmpfiles 2>/dev/null; rmdir \$tmp 2>/dev/null) && exit \$exitcode" 0 ;
  trap "rm -f \$tmpfiles 2>/dev/null; rmdir \$tmp 2>/dev/null; exit 1" 1 2 13 15 ;
  : ${TMPDIR=/tmp} ;
!  { tmp=`(umask 077 && mktemp -d "$TMPDIR/cgXXXXXX") 2>/dev/null` && test -n "$tmp" && test -d "$tmp" ; } ||
   { test -n "$RANDOM" && tmp=$TMPDIR/cg$$-$RANDOM && (umask 077 && mkdir $tmp) ; } ||
   { tmp=$TMPDIR/cg-$$ && (umask 077 && mkdir $tmp) && echo "Warning: creating insecure temp directory" >&2 ; } ||
   { echo "$me: cannot create a temporary directory in $TMPDIR" >&2 ; exit 1 ; } ;
***************
*** 123,129 ****
  	;;
   ,,*)   CC_FOR_BUILD=$CC ;;
   ,*,*)  CC_FOR_BUILD=$HOST_CC ;;
! esac ;'
  
  # This is needed to find uname on a Pyramid OSx when run in the BSD universe.
  # (ghazi@noc.rutgers.edu 1994-08-24)
--- 126,132 ----
  	;;
   ,,*)   CC_FOR_BUILD=$CC ;;
   ,*,*)  CC_FOR_BUILD=$HOST_CC ;;
! esac ; set_cc_for_build= ;'
  
  # This is needed to find uname on a Pyramid OSx when run in the BSD universe.
  # (ghazi@noc.rutgers.edu 1994-08-24)
***************
*** 158,163 ****
--- 161,167 ----
  	    arm*) machine=arm-unknown ;;
  	    sh3el) machine=shl-unknown ;;
  	    sh3eb) machine=sh-unknown ;;
+ 	    sh5el) machine=sh5le-unknown ;;
  	    *) machine=${UNAME_MACHINE_ARCH}-unknown ;;
  	esac
  	# The Operating System including object format, if it has switched
***************
*** 196,250 ****
  	# contains redundant information, the shorter form:
  	# CPU_TYPE-MANUFACTURER-OPERATING_SYSTEM is used.
  	echo "${machine}-${os}${release}"
! 	exit 0 ;;
!     amd64:OpenBSD:*:*)
! 	echo x86_64-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     amiga:OpenBSD:*:*)
! 	echo m68k-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     cats:OpenBSD:*:*)
! 	echo arm-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     hp300:OpenBSD:*:*)
! 	echo m68k-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     luna88k:OpenBSD:*:*)
!     	echo m88k-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     mac68k:OpenBSD:*:*)
! 	echo m68k-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     macppc:OpenBSD:*:*)
! 	echo powerpc-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     mvme68k:OpenBSD:*:*)
! 	echo m68k-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     mvme88k:OpenBSD:*:*)
! 	echo m88k-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     mvmeppc:OpenBSD:*:*)
! 	echo powerpc-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     sgi:OpenBSD:*:*)
! 	echo mips64-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
!     sun3:OpenBSD:*:*)
! 	echo m68k-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
      *:OpenBSD:*:*)
! 	echo ${UNAME_MACHINE}-unknown-openbsd${UNAME_RELEASE}
! 	exit 0 ;;
      *:ekkoBSD:*:*)
  	echo ${UNAME_MACHINE}-unknown-ekkobsd${UNAME_RELEASE}
! 	exit 0 ;;
      macppc:MirBSD:*:*)
! 	echo powerppc-unknown-mirbsd${UNAME_RELEASE}
! 	exit 0 ;;
      *:MirBSD:*:*)
  	echo ${UNAME_MACHINE}-unknown-mirbsd${UNAME_RELEASE}
! 	exit 0 ;;
      alpha:OSF1:*:*)
  	case $UNAME_RELEASE in
  	*4.0)
--- 200,222 ----
  	# contains redundant information, the shorter form:
  	# CPU_TYPE-MANUFACTURER-OPERATING_SYSTEM is used.
  	echo "${machine}-${os}${release}"
! 	exit ;;
      *:OpenBSD:*:*)
! 	UNAME_MACHINE_ARCH=`arch | sed 's/OpenBSD.//'`
! 	echo ${UNAME_MACHINE_ARCH}-unknown-openbsd${UNAME_RELEASE}
! 	exit ;;
      *:ekkoBSD:*:*)
  	echo ${UNAME_MACHINE}-unknown-ekkobsd${UNAME_RELEASE}
! 	exit ;;
!     *:SolidBSD:*:*)
! 	echo ${UNAME_MACHINE}-unknown-solidbsd${UNAME_RELEASE}
! 	exit ;;
      macppc:MirBSD:*:*)
! 	echo powerpc-unknown-mirbsd${UNAME_RELEASE}
! 	exit ;;
      *:MirBSD:*:*)
  	echo ${UNAME_MACHINE}-unknown-mirbsd${UNAME_RELEASE}
! 	exit ;;
      alpha:OSF1:*:*)
  	case $UNAME_RELEASE in
  	*4.0)
***************
*** 297,336 ****
  	# A Xn.n version is an unreleased experimental baselevel.
  	# 1.2 uses "1.2" for uname -r.
  	echo ${UNAME_MACHINE}-dec-osf`echo ${UNAME_RELEASE} | sed -e 's/^[PVTX]//' | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz'`
! 	exit 0 ;;
      Alpha\ *:Windows_NT*:*)
  	# How do we know it's Interix rather than the generic POSIX subsystem?
  	# Should we change UNAME_MACHINE based on the output of uname instead
  	# of the specific Alpha model?
  	echo alpha-pc-interix
! 	exit 0 ;;
      21064:Windows_NT:50:3)
  	echo alpha-dec-winnt3.5
! 	exit 0 ;;
      Amiga*:UNIX_System_V:4.0:*)
  	echo m68k-unknown-sysv4
! 	exit 0;;
      *:[Aa]miga[Oo][Ss]:*:*)
  	echo ${UNAME_MACHINE}-unknown-amigaos
! 	exit 0 ;;
      *:[Mm]orph[Oo][Ss]:*:*)
  	echo ${UNAME_MACHINE}-unknown-morphos
! 	exit 0 ;;
      *:OS/390:*:*)
  	echo i370-ibm-openedition
! 	exit 0 ;;
      *:z/VM:*:*)
  	echo s390-ibm-zvmoe
! 	exit 0 ;;
      *:OS400:*:*)
          echo powerpc-ibm-os400
! 	exit 0 ;;
      arm:RISC*:1.[012]*:*|arm:riscix:1.[012]*:*)
  	echo arm-acorn-riscix${UNAME_RELEASE}
! 	exit 0;;
      SR2?01:HI-UX/MPP:*:* | SR8000:HI-UX/MPP:*:*)
  	echo hppa1.1-hitachi-hiuxmpp
! 	exit 0;;
      Pyramid*:OSx*:*:* | MIS*:OSx*:*:* | MIS*:SMP_DC-OSx*:*:*)
  	# akee@wpdis03.wpafb.af.mil (Earle F. Ake) contributed MIS and NILE.
  	if test "`(/bin/universe) 2>/dev/null`" = att ; then
--- 269,311 ----
  	# A Xn.n version is an unreleased experimental baselevel.
  	# 1.2 uses "1.2" for uname -r.
  	echo ${UNAME_MACHINE}-dec-osf`echo ${UNAME_RELEASE} | sed -e 's/^[PVTX]//' | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz'`
! 	exit ;;
      Alpha\ *:Windows_NT*:*)
  	# How do we know it's Interix rather than the generic POSIX subsystem?
  	# Should we change UNAME_MACHINE based on the output of uname instead
  	# of the specific Alpha model?
  	echo alpha-pc-interix
! 	exit ;;
      21064:Windows_NT:50:3)
  	echo alpha-dec-winnt3.5
! 	exit ;;
      Amiga*:UNIX_System_V:4.0:*)
  	echo m68k-unknown-sysv4
! 	exit ;;
      *:[Aa]miga[Oo][Ss]:*:*)
  	echo ${UNAME_MACHINE}-unknown-amigaos
! 	exit ;;
      *:[Mm]orph[Oo][Ss]:*:*)
  	echo ${UNAME_MACHINE}-unknown-morphos
! 	exit ;;
      *:OS/390:*:*)
  	echo i370-ibm-openedition
! 	exit ;;
      *:z/VM:*:*)
  	echo s390-ibm-zvmoe
! 	exit ;;
      *:OS400:*:*)
          echo powerpc-ibm-os400
! 	exit ;;
      arm:RISC*:1.[012]*:*|arm:riscix:1.[012]*:*)
  	echo arm-acorn-riscix${UNAME_RELEASE}
! 	exit ;;
!     arm:riscos:*:*|arm:RISCOS:*:*)
! 	echo arm-unknown-riscos
! 	exit ;;
      SR2?01:HI-UX/MPP:*:* | SR8000:HI-UX/MPP:*:*)
  	echo hppa1.1-hitachi-hiuxmpp
! 	exit ;;
      Pyramid*:OSx*:*:* | MIS*:OSx*:*:* | MIS*:SMP_DC-OSx*:*:*)
  	# akee@wpdis03.wpafb.af.mil (Earle F. Ake) contributed MIS and NILE.
  	if test "`(/bin/universe) 2>/dev/null`" = att ; then
***************
*** 338,369 ****
  	else
  		echo pyramid-pyramid-bsd
  	fi
! 	exit 0 ;;
      NILE*:*:*:dcosx)
  	echo pyramid-pyramid-svr4
! 	exit 0 ;;
      DRS?6000:unix:4.0:6*)
  	echo sparc-icl-nx6
! 	exit 0 ;;
      DRS?6000:UNIX_SV:4.2*:7* | DRS?6000:isis:4.2*:7*)
  	case `/usr/bin/uname -p` in
! 	    sparc) echo sparc-icl-nx7 && exit 0 ;;
  	esac ;;
      sun4H:SunOS:5.*:*)
  	echo sparc-hal-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit 0 ;;
      sun4*:SunOS:5.*:* | tadpole*:SunOS:5.*:*)
  	echo sparc-sun-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit 0 ;;
!     i86pc:SunOS:5.*:*)
! 	echo i386-pc-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit 0 ;;
      sun4*:SunOS:6*:*)
  	# According to config.sub, this is the proper way to canonicalize
  	# SunOS6.  Hard to guess exactly what SunOS6 will be like, but
  	# it's likely to be more like Solaris than SunOS4.
  	echo sparc-sun-solaris3`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit 0 ;;
      sun4*:SunOS:*:*)
  	case "`/usr/bin/arch -k`" in
  	    Series*|S4*)
--- 313,360 ----
  	else
  		echo pyramid-pyramid-bsd
  	fi
! 	exit ;;
      NILE*:*:*:dcosx)
  	echo pyramid-pyramid-svr4
! 	exit ;;
      DRS?6000:unix:4.0:6*)
  	echo sparc-icl-nx6
! 	exit ;;
      DRS?6000:UNIX_SV:4.2*:7* | DRS?6000:isis:4.2*:7*)
  	case `/usr/bin/uname -p` in
! 	    sparc) echo sparc-icl-nx7; exit ;;
  	esac ;;
+     s390x:SunOS:*:*)
+ 	echo ${UNAME_MACHINE}-ibm-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
+ 	exit ;;
      sun4H:SunOS:5.*:*)
  	echo sparc-hal-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit ;;
      sun4*:SunOS:5.*:* | tadpole*:SunOS:5.*:*)
  	echo sparc-sun-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit ;;
!     i86pc:SunOS:5.*:* | i86xen:SunOS:5.*:*)
! 	eval $set_cc_for_build
! 	SUN_ARCH="i386"
! 	# If there is a compiler, see if it is configured for 64-bit objects.
! 	# Note that the Sun cc does not turn __LP64__ into 1 like gcc does.
! 	# This test works for both compilers.
! 	if [ "$CC_FOR_BUILD" != 'no_compiler_found' ]; then
! 	    if (echo '#ifdef __amd64'; echo IS_64BIT_ARCH; echo '#endif') | \
! 		(CCOPTS= $CC_FOR_BUILD -E - 2>/dev/null) | \
! 		grep IS_64BIT_ARCH >/dev/null
! 	    then
! 		SUN_ARCH="x86_64"
! 	    fi
! 	fi
! 	echo ${SUN_ARCH}-pc-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit ;;
      sun4*:SunOS:6*:*)
  	# According to config.sub, this is the proper way to canonicalize
  	# SunOS6.  Hard to guess exactly what SunOS6 will be like, but
  	# it's likely to be more like Solaris than SunOS4.
  	echo sparc-sun-solaris3`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit ;;
      sun4*:SunOS:*:*)
  	case "`/usr/bin/arch -k`" in
  	    Series*|S4*)
***************
*** 372,381 ****
  	esac
  	# Japanese Language versions have a version number like `4.1.3-JL'.
  	echo sparc-sun-sunos`echo ${UNAME_RELEASE}|sed -e 's/-/_/'`
! 	exit 0 ;;
      sun3*:SunOS:*:*)
  	echo m68k-sun-sunos${UNAME_RELEASE}
! 	exit 0 ;;
      sun*:*:4.2BSD:*)
  	UNAME_RELEASE=`(sed 1q /etc/motd | awk '{print substr($5,1,3)}') 2>/dev/null`
  	test "x${UNAME_RELEASE}" = "x" && UNAME_RELEASE=3
--- 363,372 ----
  	esac
  	# Japanese Language versions have a version number like `4.1.3-JL'.
  	echo sparc-sun-sunos`echo ${UNAME_RELEASE}|sed -e 's/-/_/'`
! 	exit ;;
      sun3*:SunOS:*:*)
  	echo m68k-sun-sunos${UNAME_RELEASE}
! 	exit ;;
      sun*:*:4.2BSD:*)
  	UNAME_RELEASE=`(sed 1q /etc/motd | awk '{print substr($5,1,3)}') 2>/dev/null`
  	test "x${UNAME_RELEASE}" = "x" && UNAME_RELEASE=3
***************
*** 387,396 ****
  		echo sparc-sun-sunos${UNAME_RELEASE}
  		;;
  	esac
! 	exit 0 ;;
      aushp:SunOS:*:*)
  	echo sparc-auspex-sunos${UNAME_RELEASE}
! 	exit 0 ;;
      # The situation for MiNT is a little confusing.  The machine name
      # can be virtually everything (everything which is not
      # "atarist" or "atariste" at least should have a processor
--- 378,387 ----
  		echo sparc-sun-sunos${UNAME_RELEASE}
  		;;
  	esac
! 	exit ;;
      aushp:SunOS:*:*)
  	echo sparc-auspex-sunos${UNAME_RELEASE}
! 	exit ;;
      # The situation for MiNT is a little confusing.  The machine name
      # can be virtually everything (everything which is not
      # "atarist" or "atariste" at least should have a processor
***************
*** 401,440 ****
      # be no problem.
      atarist[e]:*MiNT:*:* | atarist[e]:*mint:*:* | atarist[e]:*TOS:*:*)
          echo m68k-atari-mint${UNAME_RELEASE}
! 	exit 0 ;;
      atari*:*MiNT:*:* | atari*:*mint:*:* | atarist[e]:*TOS:*:*)
  	echo m68k-atari-mint${UNAME_RELEASE}
!         exit 0 ;;
      *falcon*:*MiNT:*:* | *falcon*:*mint:*:* | *falcon*:*TOS:*:*)
          echo m68k-atari-mint${UNAME_RELEASE}
! 	exit 0 ;;
      milan*:*MiNT:*:* | milan*:*mint:*:* | *milan*:*TOS:*:*)
          echo m68k-milan-mint${UNAME_RELEASE}
!         exit 0 ;;
      hades*:*MiNT:*:* | hades*:*mint:*:* | *hades*:*TOS:*:*)
          echo m68k-hades-mint${UNAME_RELEASE}
!         exit 0 ;;
      *:*MiNT:*:* | *:*mint:*:* | *:*TOS:*:*)
          echo m68k-unknown-mint${UNAME_RELEASE}
!         exit 0 ;;
      m68k:machten:*:*)
  	echo m68k-apple-machten${UNAME_RELEASE}
! 	exit 0 ;;
      powerpc:machten:*:*)
  	echo powerpc-apple-machten${UNAME_RELEASE}
! 	exit 0 ;;
      RISC*:Mach:*:*)
  	echo mips-dec-mach_bsd4.3
! 	exit 0 ;;
      RISC*:ULTRIX:*:*)
  	echo mips-dec-ultrix${UNAME_RELEASE}
! 	exit 0 ;;
      VAX*:ULTRIX*:*:*)
  	echo vax-dec-ultrix${UNAME_RELEASE}
! 	exit 0 ;;
      2020:CLIX:*:* | 2430:CLIX:*:*)
  	echo clipper-intergraph-clix${UNAME_RELEASE}
! 	exit 0 ;;
      mips:*:*:UMIPS | mips:*:*:RISCos)
  	eval $set_cc_for_build
  	sed 's/^	//' << EOF >$dummy.c
--- 392,431 ----
      # be no problem.
      atarist[e]:*MiNT:*:* | atarist[e]:*mint:*:* | atarist[e]:*TOS:*:*)
          echo m68k-atari-mint${UNAME_RELEASE}
! 	exit ;;
      atari*:*MiNT:*:* | atari*:*mint:*:* | atarist[e]:*TOS:*:*)
  	echo m68k-atari-mint${UNAME_RELEASE}
!         exit ;;
      *falcon*:*MiNT:*:* | *falcon*:*mint:*:* | *falcon*:*TOS:*:*)
          echo m68k-atari-mint${UNAME_RELEASE}
! 	exit ;;
      milan*:*MiNT:*:* | milan*:*mint:*:* | *milan*:*TOS:*:*)
          echo m68k-milan-mint${UNAME_RELEASE}
!         exit ;;
      hades*:*MiNT:*:* | hades*:*mint:*:* | *hades*:*TOS:*:*)
          echo m68k-hades-mint${UNAME_RELEASE}
!         exit ;;
      *:*MiNT:*:* | *:*mint:*:* | *:*TOS:*:*)
          echo m68k-unknown-mint${UNAME_RELEASE}
!         exit ;;
      m68k:machten:*:*)
  	echo m68k-apple-machten${UNAME_RELEASE}
! 	exit ;;
      powerpc:machten:*:*)
  	echo powerpc-apple-machten${UNAME_RELEASE}
! 	exit ;;
      RISC*:Mach:*:*)
  	echo mips-dec-mach_bsd4.3
! 	exit ;;
      RISC*:ULTRIX:*:*)
  	echo mips-dec-ultrix${UNAME_RELEASE}
! 	exit ;;
      VAX*:ULTRIX*:*:*)
  	echo vax-dec-ultrix${UNAME_RELEASE}
! 	exit ;;
      2020:CLIX:*:* | 2430:CLIX:*:*)
  	echo clipper-intergraph-clix${UNAME_RELEASE}
! 	exit ;;
      mips:*:*:UMIPS | mips:*:*:RISCos)
  	eval $set_cc_for_build
  	sed 's/^	//' << EOF >$dummy.c
***************
*** 458,489 ****
  	  exit (-1);
  	}
  EOF
! 	$CC_FOR_BUILD -o $dummy $dummy.c \
! 	  && $dummy `echo "${UNAME_RELEASE}" | sed -n 's/\([0-9]*\).*/\1/p'` \
! 	  && exit 0
  	echo mips-mips-riscos${UNAME_RELEASE}
! 	exit 0 ;;
      Motorola:PowerMAX_OS:*:*)
  	echo powerpc-motorola-powermax
! 	exit 0 ;;
      Motorola:*:4.3:PL8-*)
  	echo powerpc-harris-powermax
! 	exit 0 ;;
      Night_Hawk:*:*:PowerMAX_OS | Synergy:PowerMAX_OS:*:*)
  	echo powerpc-harris-powermax
! 	exit 0 ;;
      Night_Hawk:Power_UNIX:*:*)
  	echo powerpc-harris-powerunix
! 	exit 0 ;;
      m88k:CX/UX:7*:*)
  	echo m88k-harris-cxux7
! 	exit 0 ;;
      m88k:*:4*:R4*)
  	echo m88k-motorola-sysv4
! 	exit 0 ;;
      m88k:*:3*:R3*)
  	echo m88k-motorola-sysv3
! 	exit 0 ;;
      AViiON:dgux:*:*)
          # DG/UX returns AViiON for all architectures
          UNAME_PROCESSOR=`/usr/bin/uname -p`
--- 449,481 ----
  	  exit (-1);
  	}
  EOF
! 	$CC_FOR_BUILD -o $dummy $dummy.c &&
! 	  dummyarg=`echo "${UNAME_RELEASE}" | sed -n 's/\([0-9]*\).*/\1/p'` &&
! 	  SYSTEM_NAME=`$dummy $dummyarg` &&
! 	    { echo "$SYSTEM_NAME"; exit; }
  	echo mips-mips-riscos${UNAME_RELEASE}
! 	exit ;;
      Motorola:PowerMAX_OS:*:*)
  	echo powerpc-motorola-powermax
! 	exit ;;
      Motorola:*:4.3:PL8-*)
  	echo powerpc-harris-powermax
! 	exit ;;
      Night_Hawk:*:*:PowerMAX_OS | Synergy:PowerMAX_OS:*:*)
  	echo powerpc-harris-powermax
! 	exit ;;
      Night_Hawk:Power_UNIX:*:*)
  	echo powerpc-harris-powerunix
! 	exit ;;
      m88k:CX/UX:7*:*)
  	echo m88k-harris-cxux7
! 	exit ;;
      m88k:*:4*:R4*)
  	echo m88k-motorola-sysv4
! 	exit ;;
      m88k:*:3*:R3*)
  	echo m88k-motorola-sysv3
! 	exit ;;
      AViiON:dgux:*:*)
          # DG/UX returns AViiON for all architectures
          UNAME_PROCESSOR=`/usr/bin/uname -p`
***************
*** 499,527 ****
  	else
  	    echo i586-dg-dgux${UNAME_RELEASE}
  	fi
!  	exit 0 ;;
      M88*:DolphinOS:*:*)	# DolphinOS (SVR3)
  	echo m88k-dolphin-sysv3
! 	exit 0 ;;
      M88*:*:R3*:*)
  	# Delta 88k system running SVR3
  	echo m88k-motorola-sysv3
! 	exit 0 ;;
      XD88*:*:*:*) # Tektronix XD88 system running UTekV (SVR3)
  	echo m88k-tektronix-sysv3
! 	exit 0 ;;
      Tek43[0-9][0-9]:UTek:*:*) # Tektronix 4300 system running UTek (BSD)
  	echo m68k-tektronix-bsd
! 	exit 0 ;;
      *:IRIX*:*:*)
  	echo mips-sgi-irix`echo ${UNAME_RELEASE}|sed -e 's/-/_/g'`
! 	exit 0 ;;
      ????????:AIX?:[12].1:2)   # AIX 2.2.1 or AIX 2.1.1 is RT/PC AIX.
! 	echo romp-ibm-aix      # uname -m gives an 8 hex-code CPU id
! 	exit 0 ;;              # Note that: echo "'`uname -s`'" gives 'AIX '
      i*86:AIX:*:*)
  	echo i386-ibm-aix
! 	exit 0 ;;
      ia64:AIX:*:*)
  	if [ -x /usr/bin/oslevel ] ; then
  		IBM_REV=`/usr/bin/oslevel`
--- 491,519 ----
  	else
  	    echo i586-dg-dgux${UNAME_RELEASE}
  	fi
!  	exit ;;
      M88*:DolphinOS:*:*)	# DolphinOS (SVR3)
  	echo m88k-dolphin-sysv3
! 	exit ;;
      M88*:*:R3*:*)
  	# Delta 88k system running SVR3
  	echo m88k-motorola-sysv3
! 	exit ;;
      XD88*:*:*:*) # Tektronix XD88 system running UTekV (SVR3)
  	echo m88k-tektronix-sysv3
! 	exit ;;
      Tek43[0-9][0-9]:UTek:*:*) # Tektronix 4300 system running UTek (BSD)
  	echo m68k-tektronix-bsd
! 	exit ;;
      *:IRIX*:*:*)
  	echo mips-sgi-irix`echo ${UNAME_RELEASE}|sed -e 's/-/_/g'`
! 	exit ;;
      ????????:AIX?:[12].1:2)   # AIX 2.2.1 or AIX 2.1.1 is RT/PC AIX.
! 	echo romp-ibm-aix     # uname -m gives an 8 hex-code CPU id
! 	exit ;;               # Note that: echo "'`uname -s`'" gives 'AIX '
      i*86:AIX:*:*)
  	echo i386-ibm-aix
! 	exit ;;
      ia64:AIX:*:*)
  	if [ -x /usr/bin/oslevel ] ; then
  		IBM_REV=`/usr/bin/oslevel`
***************
*** 529,535 ****
  		IBM_REV=${UNAME_VERSION}.${UNAME_RELEASE}
  	fi
  	echo ${UNAME_MACHINE}-ibm-aix${IBM_REV}
! 	exit 0 ;;
      *:AIX:2:3)
  	if grep bos325 /usr/include/stdio.h >/dev/null 2>&1; then
  		eval $set_cc_for_build
--- 521,527 ----
  		IBM_REV=${UNAME_VERSION}.${UNAME_RELEASE}
  	fi
  	echo ${UNAME_MACHINE}-ibm-aix${IBM_REV}
! 	exit ;;
      *:AIX:2:3)
  	if grep bos325 /usr/include/stdio.h >/dev/null 2>&1; then
  		eval $set_cc_for_build
***************
*** 544,558 ****
  			exit(0);
  			}
  EOF
! 		$CC_FOR_BUILD -o $dummy $dummy.c && $dummy && exit 0
! 		echo rs6000-ibm-aix3.2.5
  	elif grep bos324 /usr/include/stdio.h >/dev/null 2>&1; then
  		echo rs6000-ibm-aix3.2.4
  	else
  		echo rs6000-ibm-aix3.2
  	fi
! 	exit 0 ;;
!     *:AIX:*:[45])
  	IBM_CPU_ID=`/usr/sbin/lsdev -C -c processor -S available | sed 1q | awk '{ print $1 }'`
  	if /usr/sbin/lsattr -El ${IBM_CPU_ID} | grep ' POWER' >/dev/null 2>&1; then
  		IBM_ARCH=rs6000
--- 536,554 ----
  			exit(0);
  			}
  EOF
! 		if $CC_FOR_BUILD -o $dummy $dummy.c && SYSTEM_NAME=`$dummy`
! 		then
! 			echo "$SYSTEM_NAME"
! 		else
! 			echo rs6000-ibm-aix3.2.5
! 		fi
  	elif grep bos324 /usr/include/stdio.h >/dev/null 2>&1; then
  		echo rs6000-ibm-aix3.2.4
  	else
  		echo rs6000-ibm-aix3.2
  	fi
! 	exit ;;
!     *:AIX:*:[456])
  	IBM_CPU_ID=`/usr/sbin/lsdev -C -c processor -S available | sed 1q | awk '{ print $1 }'`
  	if /usr/sbin/lsattr -El ${IBM_CPU_ID} | grep ' POWER' >/dev/null 2>&1; then
  		IBM_ARCH=rs6000
***************
*** 565,592 ****
  		IBM_REV=${UNAME_VERSION}.${UNAME_RELEASE}
  	fi
  	echo ${IBM_ARCH}-ibm-aix${IBM_REV}
! 	exit 0 ;;
      *:AIX:*:*)
  	echo rs6000-ibm-aix
! 	exit 0 ;;
      ibmrt:4.4BSD:*|romp-ibm:BSD:*)
  	echo romp-ibm-bsd4.4
! 	exit 0 ;;
      ibmrt:*BSD:*|romp-ibm:BSD:*)            # covers RT/PC BSD and
  	echo romp-ibm-bsd${UNAME_RELEASE}   # 4.3 with uname added to
! 	exit 0 ;;                           # report: romp-ibm BSD 4.3
      *:BOSX:*:*)
  	echo rs6000-bull-bosx
! 	exit 0 ;;
      DPX/2?00:B.O.S.:*:*)
  	echo m68k-bull-sysv3
! 	exit 0 ;;
      9000/[34]??:4.3bsd:1.*:*)
  	echo m68k-hp-bsd
! 	exit 0 ;;
      hp300:4.4BSD:*:* | 9000/[34]??:4.3bsd:2.*:*)
  	echo m68k-hp-bsd4.4
! 	exit 0 ;;
      9000/[34678]??:HP-UX:*:*)
  	HPUX_REV=`echo ${UNAME_RELEASE}|sed -e 's/[^.]*.[0B]*//'`
  	case "${UNAME_MACHINE}" in
--- 561,588 ----
  		IBM_REV=${UNAME_VERSION}.${UNAME_RELEASE}
  	fi
  	echo ${IBM_ARCH}-ibm-aix${IBM_REV}
! 	exit ;;
      *:AIX:*:*)
  	echo rs6000-ibm-aix
! 	exit ;;
      ibmrt:4.4BSD:*|romp-ibm:BSD:*)
  	echo romp-ibm-bsd4.4
! 	exit ;;
      ibmrt:*BSD:*|romp-ibm:BSD:*)            # covers RT/PC BSD and
  	echo romp-ibm-bsd${UNAME_RELEASE}   # 4.3 with uname added to
! 	exit ;;                             # report: romp-ibm BSD 4.3
      *:BOSX:*:*)
  	echo rs6000-bull-bosx
! 	exit ;;
      DPX/2?00:B.O.S.:*:*)
  	echo m68k-bull-sysv3
! 	exit ;;
      9000/[34]??:4.3bsd:1.*:*)
  	echo m68k-hp-bsd
! 	exit ;;
      hp300:4.4BSD:*:* | 9000/[34]??:4.3bsd:2.*:*)
  	echo m68k-hp-bsd4.4
! 	exit ;;
      9000/[34678]??:HP-UX:*:*)
  	HPUX_REV=`echo ${UNAME_RELEASE}|sed -e 's/[^.]*.[0B]*//'`
  	case "${UNAME_MACHINE}" in
***************
*** 648,656 ****
  	esac
  	if [ ${HP_ARCH} = "hppa2.0w" ]
  	then
! 	    # avoid double evaluation of $set_cc_for_build
! 	    test -n "$CC_FOR_BUILD" || eval $set_cc_for_build
! 	    if echo __LP64__ | (CCOPTS= $CC_FOR_BUILD -E -) | grep __LP64__ >/dev/null
  	    then
  		HP_ARCH="hppa2.0w"
  	    else
--- 644,662 ----
  	esac
  	if [ ${HP_ARCH} = "hppa2.0w" ]
  	then
! 	    eval $set_cc_for_build
! 
! 	    # hppa2.0w-hp-hpux* has a 64-bit kernel and a compiler generating
! 	    # 32-bit code.  hppa64-hp-hpux* has the same kernel and a compiler
! 	    # generating 64-bit code.  GNU and HP use different nomenclature:
! 	    #
! 	    # $ CC_FOR_BUILD=cc ./config.guess
! 	    # => hppa2.0w-hp-hpux11.23
! 	    # $ CC_FOR_BUILD="cc +DA2.0w" ./config.guess
! 	    # => hppa64-hp-hpux11.23
! 
! 	    if echo __LP64__ | (CCOPTS= $CC_FOR_BUILD -E - 2>/dev/null) |
! 		grep __LP64__ >/dev/null
  	    then
  		HP_ARCH="hppa2.0w"
  	    else
***************
*** 658,668 ****
  	    fi
  	fi
  	echo ${HP_ARCH}-hp-hpux${HPUX_REV}
! 	exit 0 ;;
      ia64:HP-UX:*:*)
  	HPUX_REV=`echo ${UNAME_RELEASE}|sed -e 's/[^.]*.[0B]*//'`
  	echo ia64-hp-hpux${HPUX_REV}
! 	exit 0 ;;
      3050*:HI-UX:*:*)
  	eval $set_cc_for_build
  	sed 's/^	//' << EOF >$dummy.c
--- 664,674 ----
  	    fi
  	fi
  	echo ${HP_ARCH}-hp-hpux${HPUX_REV}
! 	exit ;;
      ia64:HP-UX:*:*)
  	HPUX_REV=`echo ${UNAME_RELEASE}|sed -e 's/[^.]*.[0B]*//'`
  	echo ia64-hp-hpux${HPUX_REV}
! 	exit ;;
      3050*:HI-UX:*:*)
  	eval $set_cc_for_build
  	sed 's/^	//' << EOF >$dummy.c
***************
*** 690,850 ****
  	  exit (0);
  	}
  EOF
! 	$CC_FOR_BUILD -o $dummy $dummy.c && $dummy && exit 0
  	echo unknown-hitachi-hiuxwe2
! 	exit 0 ;;
      9000/7??:4.3bsd:*:* | 9000/8?[79]:4.3bsd:*:* )
  	echo hppa1.1-hp-bsd
! 	exit 0 ;;
      9000/8??:4.3bsd:*:*)
  	echo hppa1.0-hp-bsd
! 	exit 0 ;;
      *9??*:MPE/iX:*:* | *3000*:MPE/iX:*:*)
  	echo hppa1.0-hp-mpeix
! 	exit 0 ;;
      hp7??:OSF1:*:* | hp8?[79]:OSF1:*:* )
  	echo hppa1.1-hp-osf
! 	exit 0 ;;
      hp8??:OSF1:*:*)
  	echo hppa1.0-hp-osf
! 	exit 0 ;;
      i*86:OSF1:*:*)
  	if [ -x /usr/sbin/sysversion ] ; then
  	    echo ${UNAME_MACHINE}-unknown-osf1mk
  	else
  	    echo ${UNAME_MACHINE}-unknown-osf1
  	fi
! 	exit 0 ;;
      parisc*:Lites*:*:*)
  	echo hppa1.1-hp-lites
! 	exit 0 ;;
      C1*:ConvexOS:*:* | convex:ConvexOS:C1*:*)
  	echo c1-convex-bsd
!         exit 0 ;;
      C2*:ConvexOS:*:* | convex:ConvexOS:C2*:*)
  	if getsysinfo -f scalar_acc
  	then echo c32-convex-bsd
  	else echo c2-convex-bsd
  	fi
!         exit 0 ;;
      C34*:ConvexOS:*:* | convex:ConvexOS:C34*:*)
  	echo c34-convex-bsd
!         exit 0 ;;
      C38*:ConvexOS:*:* | convex:ConvexOS:C38*:*)
  	echo c38-convex-bsd
!         exit 0 ;;
      C4*:ConvexOS:*:* | convex:ConvexOS:C4*:*)
  	echo c4-convex-bsd
!         exit 0 ;;
      CRAY*Y-MP:*:*:*)
  	echo ymp-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit 0 ;;
      CRAY*[A-Z]90:*:*:*)
  	echo ${UNAME_MACHINE}-cray-unicos${UNAME_RELEASE} \
  	| sed -e 's/CRAY.*\([A-Z]90\)/\1/' \
  	      -e y/ABCDEFGHIJKLMNOPQRSTUVWXYZ/abcdefghijklmnopqrstuvwxyz/ \
  	      -e 's/\.[^.]*$/.X/'
! 	exit 0 ;;
      CRAY*TS:*:*:*)
  	echo t90-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit 0 ;;
      CRAY*T3E:*:*:*)
  	echo alphaev5-cray-unicosmk${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit 0 ;;
      CRAY*SV1:*:*:*)
  	echo sv1-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit 0 ;;
      *:UNICOS/mp:*:*)
  	echo craynv-cray-unicosmp${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit 0 ;;
      F30[01]:UNIX_System_V:*:* | F700:UNIX_System_V:*:*)
  	FUJITSU_PROC=`uname -m | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz'`
          FUJITSU_SYS=`uname -p | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz' | sed -e 's/\///'`
          FUJITSU_REL=`echo ${UNAME_RELEASE} | sed -e 's/ /_/'`
          echo "${FUJITSU_PROC}-fujitsu-${FUJITSU_SYS}${FUJITSU_REL}"
!         exit 0 ;;
      5000:UNIX_System_V:4.*:*)
          FUJITSU_SYS=`uname -p | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz' | sed -e 's/\///'`
          FUJITSU_REL=`echo ${UNAME_RELEASE} | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz' | sed -e 's/ /_/'`
          echo "sparc-fujitsu-${FUJITSU_SYS}${FUJITSU_REL}"
! 	exit 0 ;;
      i*86:BSD/386:*:* | i*86:BSD/OS:*:* | *:Ascend\ Embedded/OS:*:*)
  	echo ${UNAME_MACHINE}-pc-bsdi${UNAME_RELEASE}
! 	exit 0 ;;
      sparc*:BSD/OS:*:*)
  	echo sparc-unknown-bsdi${UNAME_RELEASE}
! 	exit 0 ;;
      *:BSD/OS:*:*)
  	echo ${UNAME_MACHINE}-unknown-bsdi${UNAME_RELEASE}
! 	exit 0 ;;
      *:FreeBSD:*:*)
! 	echo ${UNAME_MACHINE}-unknown-freebsd`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'`
! 	exit 0 ;;
      i*:CYGWIN*:*)
  	echo ${UNAME_MACHINE}-pc-cygwin
! 	exit 0 ;;
!     i*:MINGW*:*)
  	echo ${UNAME_MACHINE}-pc-mingw32
! 	exit 0 ;;
      i*:PW*:*)
  	echo ${UNAME_MACHINE}-pc-pw32
! 	exit 0 ;;
!     x86:Interix*:[34]*)
! 	echo i586-pc-interix${UNAME_RELEASE}|sed -e 's/\..*//'
! 	exit 0 ;;
      [345]86:Windows_95:* | [345]86:Windows_98:* | [345]86:Windows_NT:*)
  	echo i${UNAME_MACHINE}-pc-mks
! 	exit 0 ;;
      i*:Windows_NT*:* | Pentium*:Windows_NT*:*)
  	# How do we know it's Interix rather than the generic POSIX subsystem?
  	# It also conflicts with pre-2.0 versions of AT&T UWIN. Should we
  	# UNAME_MACHINE based on the output of uname instead of i386?
  	echo i586-pc-interix
! 	exit 0 ;;
      i*:UWIN*:*)
  	echo ${UNAME_MACHINE}-pc-uwin
! 	exit 0 ;;
!     amd64:CYGWIN*:*:*)
  	echo x86_64-unknown-cygwin
! 	exit 0 ;;
      p*:CYGWIN*:*)
  	echo powerpcle-unknown-cygwin
! 	exit 0 ;;
      prep*:SunOS:5.*:*)
  	echo powerpcle-unknown-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit 0 ;;
      *:GNU:*:*)
  	# the GNU system
  	echo `echo ${UNAME_MACHINE}|sed -e 's,[-/].*$,,'`-unknown-gnu`echo ${UNAME_RELEASE}|sed -e 's,/.*$,,'`
! 	exit 0 ;;
      *:GNU/*:*:*)
  	# other systems with GNU libc and userland
  	echo ${UNAME_MACHINE}-unknown-`echo ${UNAME_SYSTEM} | sed 's,^[^/]*/,,' | tr '[A-Z]' '[a-z]'``echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'`-gnu
! 	exit 0 ;;
      i*86:Minix:*:*)
  	echo ${UNAME_MACHINE}-pc-minix
! 	exit 0 ;;
      arm*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit 0 ;;
      cris:Linux:*:*)
  	echo cris-axis-linux-gnu
! 	exit 0 ;;
      crisv32:Linux:*:*)
  	echo crisv32-axis-linux-gnu
! 	exit 0 ;;
      frv:Linux:*:*)
      	echo frv-unknown-linux-gnu
! 	exit 0 ;;
      ia64:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit 0 ;;
      m32r*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit 0 ;;
      m68*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit 0 ;;
      mips:Linux:*:*)
  	eval $set_cc_for_build
  	sed 's/^	//' << EOF >$dummy.c
--- 696,887 ----
  	  exit (0);
  	}
  EOF
! 	$CC_FOR_BUILD -o $dummy $dummy.c && SYSTEM_NAME=`$dummy` &&
! 		{ echo "$SYSTEM_NAME"; exit; }
  	echo unknown-hitachi-hiuxwe2
! 	exit ;;
      9000/7??:4.3bsd:*:* | 9000/8?[79]:4.3bsd:*:* )
  	echo hppa1.1-hp-bsd
! 	exit ;;
      9000/8??:4.3bsd:*:*)
  	echo hppa1.0-hp-bsd
! 	exit ;;
      *9??*:MPE/iX:*:* | *3000*:MPE/iX:*:*)
  	echo hppa1.0-hp-mpeix
! 	exit ;;
      hp7??:OSF1:*:* | hp8?[79]:OSF1:*:* )
  	echo hppa1.1-hp-osf
! 	exit ;;
      hp8??:OSF1:*:*)
  	echo hppa1.0-hp-osf
! 	exit ;;
      i*86:OSF1:*:*)
  	if [ -x /usr/sbin/sysversion ] ; then
  	    echo ${UNAME_MACHINE}-unknown-osf1mk
  	else
  	    echo ${UNAME_MACHINE}-unknown-osf1
  	fi
! 	exit ;;
      parisc*:Lites*:*:*)
  	echo hppa1.1-hp-lites
! 	exit ;;
      C1*:ConvexOS:*:* | convex:ConvexOS:C1*:*)
  	echo c1-convex-bsd
!         exit ;;
      C2*:ConvexOS:*:* | convex:ConvexOS:C2*:*)
  	if getsysinfo -f scalar_acc
  	then echo c32-convex-bsd
  	else echo c2-convex-bsd
  	fi
!         exit ;;
      C34*:ConvexOS:*:* | convex:ConvexOS:C34*:*)
  	echo c34-convex-bsd
!         exit ;;
      C38*:ConvexOS:*:* | convex:ConvexOS:C38*:*)
  	echo c38-convex-bsd
!         exit ;;
      C4*:ConvexOS:*:* | convex:ConvexOS:C4*:*)
  	echo c4-convex-bsd
!         exit ;;
      CRAY*Y-MP:*:*:*)
  	echo ymp-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit ;;
      CRAY*[A-Z]90:*:*:*)
  	echo ${UNAME_MACHINE}-cray-unicos${UNAME_RELEASE} \
  	| sed -e 's/CRAY.*\([A-Z]90\)/\1/' \
  	      -e y/ABCDEFGHIJKLMNOPQRSTUVWXYZ/abcdefghijklmnopqrstuvwxyz/ \
  	      -e 's/\.[^.]*$/.X/'
! 	exit ;;
      CRAY*TS:*:*:*)
  	echo t90-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit ;;
      CRAY*T3E:*:*:*)
  	echo alphaev5-cray-unicosmk${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit ;;
      CRAY*SV1:*:*:*)
  	echo sv1-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit ;;
      *:UNICOS/mp:*:*)
  	echo craynv-cray-unicosmp${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
! 	exit ;;
      F30[01]:UNIX_System_V:*:* | F700:UNIX_System_V:*:*)
  	FUJITSU_PROC=`uname -m | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz'`
          FUJITSU_SYS=`uname -p | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz' | sed -e 's/\///'`
          FUJITSU_REL=`echo ${UNAME_RELEASE} | sed -e 's/ /_/'`
          echo "${FUJITSU_PROC}-fujitsu-${FUJITSU_SYS}${FUJITSU_REL}"
!         exit ;;
      5000:UNIX_System_V:4.*:*)
          FUJITSU_SYS=`uname -p | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz' | sed -e 's/\///'`
          FUJITSU_REL=`echo ${UNAME_RELEASE} | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz' | sed -e 's/ /_/'`
          echo "sparc-fujitsu-${FUJITSU_SYS}${FUJITSU_REL}"
! 	exit ;;
      i*86:BSD/386:*:* | i*86:BSD/OS:*:* | *:Ascend\ Embedded/OS:*:*)
  	echo ${UNAME_MACHINE}-pc-bsdi${UNAME_RELEASE}
! 	exit ;;
      sparc*:BSD/OS:*:*)
  	echo sparc-unknown-bsdi${UNAME_RELEASE}
! 	exit ;;
      *:BSD/OS:*:*)
  	echo ${UNAME_MACHINE}-unknown-bsdi${UNAME_RELEASE}
! 	exit ;;
      *:FreeBSD:*:*)
! 	case ${UNAME_MACHINE} in
! 	    pc98)
! 		echo i386-unknown-freebsd`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'` ;;
! 	    amd64)
! 		echo x86_64-unknown-freebsd`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'` ;;
! 	    *)
! 		echo ${UNAME_MACHINE}-unknown-freebsd`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'` ;;
! 	esac
! 	exit ;;
      i*:CYGWIN*:*)
  	echo ${UNAME_MACHINE}-pc-cygwin
! 	exit ;;
!     *:MINGW*:*)
  	echo ${UNAME_MACHINE}-pc-mingw32
! 	exit ;;
!     i*:windows32*:*)
!     	# uname -m includes "-pc" on this system.
!     	echo ${UNAME_MACHINE}-mingw32
! 	exit ;;
      i*:PW*:*)
  	echo ${UNAME_MACHINE}-pc-pw32
! 	exit ;;
!     *:Interix*:[3456]*)
!     	case ${UNAME_MACHINE} in
! 	    x86)
! 		echo i586-pc-interix${UNAME_RELEASE}
! 		exit ;;
! 	    EM64T | authenticamd | genuineintel)
! 		echo x86_64-unknown-interix${UNAME_RELEASE}
! 		exit ;;
! 	    IA64)
! 		echo ia64-unknown-interix${UNAME_RELEASE}
! 		exit ;;
! 	esac ;;
      [345]86:Windows_95:* | [345]86:Windows_98:* | [345]86:Windows_NT:*)
  	echo i${UNAME_MACHINE}-pc-mks
! 	exit ;;
      i*:Windows_NT*:* | Pentium*:Windows_NT*:*)
  	# How do we know it's Interix rather than the generic POSIX subsystem?
  	# It also conflicts with pre-2.0 versions of AT&T UWIN. Should we
  	# UNAME_MACHINE based on the output of uname instead of i386?
  	echo i586-pc-interix
! 	exit ;;
      i*:UWIN*:*)
  	echo ${UNAME_MACHINE}-pc-uwin
! 	exit ;;
!     amd64:CYGWIN*:*:* | x86_64:CYGWIN*:*:*)
  	echo x86_64-unknown-cygwin
! 	exit ;;
      p*:CYGWIN*:*)
  	echo powerpcle-unknown-cygwin
! 	exit ;;
      prep*:SunOS:5.*:*)
  	echo powerpcle-unknown-solaris2`echo ${UNAME_RELEASE}|sed -e 's/[^.]*//'`
! 	exit ;;
      *:GNU:*:*)
  	# the GNU system
  	echo `echo ${UNAME_MACHINE}|sed -e 's,[-/].*$,,'`-unknown-gnu`echo ${UNAME_RELEASE}|sed -e 's,/.*$,,'`
! 	exit ;;
      *:GNU/*:*:*)
  	# other systems with GNU libc and userland
  	echo ${UNAME_MACHINE}-unknown-`echo ${UNAME_SYSTEM} | sed 's,^[^/]*/,,' | tr '[A-Z]' '[a-z]'``echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'`-gnu
! 	exit ;;
      i*86:Minix:*:*)
  	echo ${UNAME_MACHINE}-pc-minix
! 	exit ;;
      arm*:Linux:*:*)
+ 	eval $set_cc_for_build
+ 	if echo __ARM_EABI__ | $CC_FOR_BUILD -E - 2>/dev/null \
+ 	    | grep -q __ARM_EABI__
+ 	then
+ 	    echo ${UNAME_MACHINE}-unknown-linux-gnu
+ 	else
+ 	    echo ${UNAME_MACHINE}-unknown-linux-gnueabi
+ 	fi
+ 	exit ;;
+     avr32*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
      cris:Linux:*:*)
  	echo cris-axis-linux-gnu
! 	exit ;;
      crisv32:Linux:*:*)
  	echo crisv32-axis-linux-gnu
! 	exit ;;
      frv:Linux:*:*)
      	echo frv-unknown-linux-gnu
! 	exit ;;
      ia64:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
      m32r*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
      m68*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
      mips:Linux:*:*)
  	eval $set_cc_for_build
  	sed 's/^	//' << EOF >$dummy.c
***************
*** 861,868 ****
  	#endif
  	#endif
  EOF
! 	eval `$CC_FOR_BUILD -E $dummy.c 2>/dev/null | grep ^CPU=`
! 	test x"${CPU}" != x && echo "${CPU}-unknown-linux-gnu" && exit 0
  	;;
      mips64:Linux:*:*)
  	eval $set_cc_for_build
--- 898,909 ----
  	#endif
  	#endif
  EOF
! 	eval "`$CC_FOR_BUILD -E $dummy.c 2>/dev/null | sed -n '
! 	    /^CPU/{
! 		s: ::g
! 		p
! 	    }'`"
! 	test x"${CPU}" != x && { echo "${CPU}-unknown-linux-gnu"; exit; }
  	;;
      mips64:Linux:*:*)
  	eval $set_cc_for_build
***************
*** 880,894 ****
  	#endif
  	#endif
  EOF
! 	eval `$CC_FOR_BUILD -E $dummy.c 2>/dev/null | grep ^CPU=`
! 	test x"${CPU}" != x && echo "${CPU}-unknown-linux-gnu" && exit 0
  	;;
      ppc:Linux:*:*)
  	echo powerpc-unknown-linux-gnu
! 	exit 0 ;;
      ppc64:Linux:*:*)
  	echo powerpc64-unknown-linux-gnu
! 	exit 0 ;;
      alpha:Linux:*:*)
  	case `sed -n '/^cpu model/s/^.*: \(.*\)/\1/p' < /proc/cpuinfo` in
  	  EV5)   UNAME_MACHINE=alphaev5 ;;
--- 921,942 ----
  	#endif
  	#endif
  EOF
! 	eval "`$CC_FOR_BUILD -E $dummy.c 2>/dev/null | sed -n '
! 	    /^CPU/{
! 		s: ::g
! 		p
! 	    }'`"
! 	test x"${CPU}" != x && { echo "${CPU}-unknown-linux-gnu"; exit; }
  	;;
+     or32:Linux:*:*)
+ 	echo or32-unknown-linux-gnu
+ 	exit ;;
      ppc:Linux:*:*)
  	echo powerpc-unknown-linux-gnu
! 	exit ;;
      ppc64:Linux:*:*)
  	echo powerpc64-unknown-linux-gnu
! 	exit ;;
      alpha:Linux:*:*)
  	case `sed -n '/^cpu model/s/^.*: \(.*\)/\1/p' < /proc/cpuinfo` in
  	  EV5)   UNAME_MACHINE=alphaev5 ;;
***************
*** 902,908 ****
  	objdump --private-headers /bin/sh | grep ld.so.1 >/dev/null
  	if test "$?" = 0 ; then LIBC="libc1" ; else LIBC="" ; fi
  	echo ${UNAME_MACHINE}-unknown-linux-gnu${LIBC}
! 	exit 0 ;;
      parisc:Linux:*:* | hppa:Linux:*:*)
  	# Look for CPU level
  	case `grep '^cpu[^a-z]*:' /proc/cpuinfo 2>/dev/null | cut -d' ' -f2` in
--- 950,959 ----
  	objdump --private-headers /bin/sh | grep ld.so.1 >/dev/null
  	if test "$?" = 0 ; then LIBC="libc1" ; else LIBC="" ; fi
  	echo ${UNAME_MACHINE}-unknown-linux-gnu${LIBC}
! 	exit ;;
!     padre:Linux:*:*)
! 	echo sparc-unknown-linux-gnu
! 	exit ;;
      parisc:Linux:*:* | hppa:Linux:*:*)
  	# Look for CPU level
  	case `grep '^cpu[^a-z]*:' /proc/cpuinfo 2>/dev/null | cut -d' ' -f2` in
***************
*** 910,934 ****
  	  PA8*) echo hppa2.0-unknown-linux-gnu ;;
  	  *)    echo hppa-unknown-linux-gnu ;;
  	esac
! 	exit 0 ;;
      parisc64:Linux:*:* | hppa64:Linux:*:*)
  	echo hppa64-unknown-linux-gnu
! 	exit 0 ;;
      s390:Linux:*:* | s390x:Linux:*:*)
  	echo ${UNAME_MACHINE}-ibm-linux
! 	exit 0 ;;
      sh64*:Linux:*:*)
      	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit 0 ;;
      sh*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit 0 ;;
      sparc:Linux:*:* | sparc64:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit 0 ;;
      x86_64:Linux:*:*)
  	echo x86_64-unknown-linux-gnu
! 	exit 0 ;;
      i*86:Linux:*:*)
  	# The BFD linker knows what the default object file format is, so
  	# first see if it will tell us. cd to the root directory to prevent
--- 961,991 ----
  	  PA8*) echo hppa2.0-unknown-linux-gnu ;;
  	  *)    echo hppa-unknown-linux-gnu ;;
  	esac
! 	exit ;;
      parisc64:Linux:*:* | hppa64:Linux:*:*)
  	echo hppa64-unknown-linux-gnu
! 	exit ;;
      s390:Linux:*:* | s390x:Linux:*:*)
  	echo ${UNAME_MACHINE}-ibm-linux
! 	exit ;;
      sh64*:Linux:*:*)
      	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
      sh*:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
      sparc:Linux:*:* | sparc64:Linux:*:*)
  	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
!     vax:Linux:*:*)
! 	echo ${UNAME_MACHINE}-dec-linux-gnu
! 	exit ;;
      x86_64:Linux:*:*)
  	echo x86_64-unknown-linux-gnu
! 	exit ;;
!     xtensa*:Linux:*:*)
!     	echo ${UNAME_MACHINE}-unknown-linux-gnu
! 	exit ;;
      i*86:Linux:*:*)
  	# The BFD linker knows what the default object file format is, so
  	# first see if it will tell us. cd to the root directory to prevent
***************
*** 946,960 ****
  		;;
  	  a.out-i386-linux)
  		echo "${UNAME_MACHINE}-pc-linux-gnuaout"
! 		exit 0 ;;
! 	  coff-i386)
! 		echo "${UNAME_MACHINE}-pc-linux-gnucoff"
! 		exit 0 ;;
  	  "")
  		# Either a pre-BFD a.out linker (linux-gnuoldld) or
  		# one that does not give us useful --help.
  		echo "${UNAME_MACHINE}-pc-linux-gnuoldld"
! 		exit 0 ;;
  	esac
  	# Determine whether the default compiler is a.out or elf
  	eval $set_cc_for_build
--- 1003,1014 ----
  		;;
  	  a.out-i386-linux)
  		echo "${UNAME_MACHINE}-pc-linux-gnuaout"
! 		exit ;;
  	  "")
  		# Either a pre-BFD a.out linker (linux-gnuoldld) or
  		# one that does not give us useful --help.
  		echo "${UNAME_MACHINE}-pc-linux-gnuoldld"
! 		exit ;;
  	esac
  	# Determine whether the default compiler is a.out or elf
  	eval $set_cc_for_build
***************
*** 971,977 ****
  	LIBC=gnulibc1
  	# endif
  	#else
! 	#ifdef __INTEL_COMPILER
  	LIBC=gnu
  	#else
  	LIBC=gnuaout
--- 1025,1031 ----
  	LIBC=gnulibc1
  	# endif
  	#else
! 	#if defined(__INTEL_COMPILER) || defined(__PGI) || defined(__SUNPRO_C) || defined(__SUNPRO_CC)
  	LIBC=gnu
  	#else
  	LIBC=gnuaout
***************
*** 981,996 ****
  	LIBC=dietlibc
  	#endif
  EOF
! 	eval `$CC_FOR_BUILD -E $dummy.c 2>/dev/null | grep ^LIBC=`
! 	test x"${LIBC}" != x && echo "${UNAME_MACHINE}-pc-linux-${LIBC}" && exit 0
! 	test x"${TENTATIVE}" != x && echo "${TENTATIVE}" && exit 0
  	;;
      i*86:DYNIX/ptx:4*:*)
  	# ptx 4.0 does uname -s correctly, with DYNIX/ptx in there.
  	# earlier versions are messed up and put the nodename in both
  	# sysname and nodename.
  	echo i386-sequent-sysv4
! 	exit 0 ;;
      i*86:UNIX_SV:4.2MP:2.*)
          # Unixware is an offshoot of SVR4, but it has its own version
          # number series starting with 2...
--- 1035,1057 ----
  	LIBC=dietlibc
  	#endif
  EOF
! 	eval "`$CC_FOR_BUILD -E $dummy.c 2>/dev/null | sed -n '
! 	    /^LIBC/{
! 		s: ::g
! 		p
! 	    }'`"
! 	test x"${LIBC}" != x && {
! 		echo "${UNAME_MACHINE}-pc-linux-${LIBC}"
! 		exit
! 	}
! 	test x"${TENTATIVE}" != x && { echo "${TENTATIVE}"; exit; }
  	;;
      i*86:DYNIX/ptx:4*:*)
  	# ptx 4.0 does uname -s correctly, with DYNIX/ptx in there.
  	# earlier versions are messed up and put the nodename in both
  	# sysname and nodename.
  	echo i386-sequent-sysv4
! 	exit ;;
      i*86:UNIX_SV:4.2MP:2.*)
          # Unixware is an offshoot of SVR4, but it has its own version
          # number series starting with 2...
***************
*** 998,1024 ****
  	# I just have to hope.  -- rms.
          # Use sysv4.2uw... so that sysv4* matches it.
  	echo ${UNAME_MACHINE}-pc-sysv4.2uw${UNAME_VERSION}
! 	exit 0 ;;
      i*86:OS/2:*:*)
  	# If we were able to find `uname', then EMX Unix compatibility
  	# is probably installed.
  	echo ${UNAME_MACHINE}-pc-os2-emx
! 	exit 0 ;;
      i*86:XTS-300:*:STOP)
  	echo ${UNAME_MACHINE}-unknown-stop
! 	exit 0 ;;
      i*86:atheos:*:*)
  	echo ${UNAME_MACHINE}-unknown-atheos
! 	exit 0 ;;
! 	i*86:syllable:*:*)
  	echo ${UNAME_MACHINE}-pc-syllable
! 	exit 0 ;;
      i*86:LynxOS:2.*:* | i*86:LynxOS:3.[01]*:* | i*86:LynxOS:4.0*:*)
  	echo i386-unknown-lynxos${UNAME_RELEASE}
! 	exit 0 ;;
      i*86:*DOS:*:*)
  	echo ${UNAME_MACHINE}-pc-msdosdjgpp
! 	exit 0 ;;
      i*86:*:4.*:* | i*86:SYSTEM_V:4.*:*)
  	UNAME_REL=`echo ${UNAME_RELEASE} | sed 's/\/MP$//'`
  	if grep Novell /usr/include/link.h >/dev/null 2>/dev/null; then
--- 1059,1085 ----
  	# I just have to hope.  -- rms.
          # Use sysv4.2uw... so that sysv4* matches it.
  	echo ${UNAME_MACHINE}-pc-sysv4.2uw${UNAME_VERSION}
! 	exit ;;
      i*86:OS/2:*:*)
  	# If we were able to find `uname', then EMX Unix compatibility
  	# is probably installed.
  	echo ${UNAME_MACHINE}-pc-os2-emx
! 	exit ;;
      i*86:XTS-300:*:STOP)
  	echo ${UNAME_MACHINE}-unknown-stop
! 	exit ;;
      i*86:atheos:*:*)
  	echo ${UNAME_MACHINE}-unknown-atheos
! 	exit ;;
!     i*86:syllable:*:*)
  	echo ${UNAME_MACHINE}-pc-syllable
! 	exit ;;
      i*86:LynxOS:2.*:* | i*86:LynxOS:3.[01]*:* | i*86:LynxOS:4.0*:*)
  	echo i386-unknown-lynxos${UNAME_RELEASE}
! 	exit ;;
      i*86:*DOS:*:*)
  	echo ${UNAME_MACHINE}-pc-msdosdjgpp
! 	exit ;;
      i*86:*:4.*:* | i*86:SYSTEM_V:4.*:*)
  	UNAME_REL=`echo ${UNAME_RELEASE} | sed 's/\/MP$//'`
  	if grep Novell /usr/include/link.h >/dev/null 2>/dev/null; then
***************
*** 1026,1040 ****
  	else
  		echo ${UNAME_MACHINE}-pc-sysv${UNAME_REL}
  	fi
! 	exit 0 ;;
!     i*86:*:5:[78]*)
  	case `/bin/uname -X | grep "^Machine"` in
  	    *486*)	     UNAME_MACHINE=i486 ;;
  	    *Pentium)	     UNAME_MACHINE=i586 ;;
  	    *Pent*|*Celeron) UNAME_MACHINE=i686 ;;
  	esac
  	echo ${UNAME_MACHINE}-unknown-sysv${UNAME_RELEASE}${UNAME_SYSTEM}${UNAME_VERSION}
! 	exit 0 ;;
      i*86:*:3.2:*)
  	if test -f /usr/options/cb.name; then
  		UNAME_REL=`sed -n 's/.*Version //p' </usr/options/cb.name`
--- 1087,1102 ----
  	else
  		echo ${UNAME_MACHINE}-pc-sysv${UNAME_REL}
  	fi
! 	exit ;;
!     i*86:*:5:[678]*)
!     	# UnixWare 7.x, OpenUNIX and OpenServer 6.
  	case `/bin/uname -X | grep "^Machine"` in
  	    *486*)	     UNAME_MACHINE=i486 ;;
  	    *Pentium)	     UNAME_MACHINE=i586 ;;
  	    *Pent*|*Celeron) UNAME_MACHINE=i686 ;;
  	esac
  	echo ${UNAME_MACHINE}-unknown-sysv${UNAME_RELEASE}${UNAME_SYSTEM}${UNAME_VERSION}
! 	exit ;;
      i*86:*:3.2:*)
  	if test -f /usr/options/cb.name; then
  		UNAME_REL=`sed -n 's/.*Version //p' </usr/options/cb.name`
***************
*** 1052,1124 ****
  	else
  		echo ${UNAME_MACHINE}-pc-sysv32
  	fi
! 	exit 0 ;;
      pc:*:*:*)
  	# Left here for compatibility:
          # uname -m prints for DJGPP always 'pc', but it prints nothing about
!         # the processor, so we play safe by assuming i386.
! 	echo i386-pc-msdosdjgpp
!         exit 0 ;;
      Intel:Mach:3*:*)
  	echo i386-pc-mach3
! 	exit 0 ;;
      paragon:*:*:*)
  	echo i860-intel-osf1
! 	exit 0 ;;
      i860:*:4.*:*) # i860-SVR4
  	if grep Stardent /usr/include/sys/uadmin.h >/dev/null 2>&1 ; then
  	  echo i860-stardent-sysv${UNAME_RELEASE} # Stardent Vistra i860-SVR4
  	else # Add other i860-SVR4 vendors below as they are discovered.
  	  echo i860-unknown-sysv${UNAME_RELEASE}  # Unknown i860-SVR4
  	fi
! 	exit 0 ;;
      mini*:CTIX:SYS*5:*)
  	# "miniframe"
  	echo m68010-convergent-sysv
! 	exit 0 ;;
      mc68k:UNIX:SYSTEM5:3.51m)
  	echo m68k-convergent-sysv
! 	exit 0 ;;
      M680?0:D-NIX:5.3:*)
  	echo m68k-diab-dnix
! 	exit 0 ;;
      M68*:*:R3V[5678]*:*)
! 	test -r /sysV68 && echo 'm68k-motorola-sysv' && exit 0 ;;
      3[345]??:*:4.0:3.0 | 3[34]??A:*:4.0:3.0 | 3[34]??,*:*:4.0:3.0 | 3[34]??/*:*:4.0:3.0 | 4400:*:4.0:3.0 | 4850:*:4.0:3.0 | SKA40:*:4.0:3.0 | SDS2:*:4.0:3.0 | SHG2:*:4.0:3.0 | S7501*:*:4.0:3.0)
  	OS_REL=''
  	test -r /etc/.relid \
  	&& OS_REL=.`sed -n 's/[^ ]* [^ ]* \([0-9][0-9]\).*/\1/p' < /etc/.relid`
  	/bin/uname -p 2>/dev/null | grep 86 >/dev/null \
! 	  && echo i486-ncr-sysv4.3${OS_REL} && exit 0
  	/bin/uname -p 2>/dev/null | /bin/grep entium >/dev/null \
! 	  && echo i586-ncr-sysv4.3${OS_REL} && exit 0 ;;
      3[34]??:*:4.0:* | 3[34]??,*:*:4.0:*)
          /bin/uname -p 2>/dev/null | grep 86 >/dev/null \
!           && echo i486-ncr-sysv4 && exit 0 ;;
      m68*:LynxOS:2.*:* | m68*:LynxOS:3.0*:*)
  	echo m68k-unknown-lynxos${UNAME_RELEASE}
! 	exit 0 ;;
      mc68030:UNIX_System_V:4.*:*)
  	echo m68k-atari-sysv4
! 	exit 0 ;;
      TSUNAMI:LynxOS:2.*:*)
  	echo sparc-unknown-lynxos${UNAME_RELEASE}
! 	exit 0 ;;
      rs6000:LynxOS:2.*:*)
  	echo rs6000-unknown-lynxos${UNAME_RELEASE}
! 	exit 0 ;;
      PowerPC:LynxOS:2.*:* | PowerPC:LynxOS:3.[01]*:* | PowerPC:LynxOS:4.0*:*)
  	echo powerpc-unknown-lynxos${UNAME_RELEASE}
! 	exit 0 ;;
      SM[BE]S:UNIX_SV:*:*)
  	echo mips-dde-sysv${UNAME_RELEASE}
! 	exit 0 ;;
      RM*:ReliantUNIX-*:*:*)
  	echo mips-sni-sysv4
! 	exit 0 ;;
      RM*:SINIX-*:*:*)
  	echo mips-sni-sysv4
! 	exit 0 ;;
      *:SINIX-*:*:*)
  	if uname -p 2>/dev/null >/dev/null ; then
  		UNAME_MACHINE=`(uname -p) 2>/dev/null`
--- 1114,1199 ----
  	else
  		echo ${UNAME_MACHINE}-pc-sysv32
  	fi
! 	exit ;;
      pc:*:*:*)
  	# Left here for compatibility:
          # uname -m prints for DJGPP always 'pc', but it prints nothing about
!         # the processor, so we play safe by assuming i586.
! 	# Note: whatever this is, it MUST be the same as what config.sub
! 	# prints for the "djgpp" host, or else GDB configury will decide that
! 	# this is a cross-build.
! 	echo i586-pc-msdosdjgpp
!         exit ;;
      Intel:Mach:3*:*)
  	echo i386-pc-mach3
! 	exit ;;
      paragon:*:*:*)
  	echo i860-intel-osf1
! 	exit ;;
      i860:*:4.*:*) # i860-SVR4
  	if grep Stardent /usr/include/sys/uadmin.h >/dev/null 2>&1 ; then
  	  echo i860-stardent-sysv${UNAME_RELEASE} # Stardent Vistra i860-SVR4
  	else # Add other i860-SVR4 vendors below as they are discovered.
  	  echo i860-unknown-sysv${UNAME_RELEASE}  # Unknown i860-SVR4
  	fi
! 	exit ;;
      mini*:CTIX:SYS*5:*)
  	# "miniframe"
  	echo m68010-convergent-sysv
! 	exit ;;
      mc68k:UNIX:SYSTEM5:3.51m)
  	echo m68k-convergent-sysv
! 	exit ;;
      M680?0:D-NIX:5.3:*)
  	echo m68k-diab-dnix
! 	exit ;;
      M68*:*:R3V[5678]*:*)
! 	test -r /sysV68 && { echo 'm68k-motorola-sysv'; exit; } ;;
      3[345]??:*:4.0:3.0 | 3[34]??A:*:4.0:3.0 | 3[34]??,*:*:4.0:3.0 | 3[34]??/*:*:4.0:3.0 | 4400:*:4.0:3.0 | 4850:*:4.0:3.0 | SKA40:*:4.0:3.0 | SDS2:*:4.0:3.0 | SHG2:*:4.0:3.0 | S7501*:*:4.0:3.0)
  	OS_REL=''
  	test -r /etc/.relid \
  	&& OS_REL=.`sed -n 's/[^ ]* [^ ]* \([0-9][0-9]\).*/\1/p' < /etc/.relid`
  	/bin/uname -p 2>/dev/null | grep 86 >/dev/null \
! 	  && { echo i486-ncr-sysv4.3${OS_REL}; exit; }
  	/bin/uname -p 2>/dev/null | /bin/grep entium >/dev/null \
! 	  && { echo i586-ncr-sysv4.3${OS_REL}; exit; } ;;
      3[34]??:*:4.0:* | 3[34]??,*:*:4.0:*)
          /bin/uname -p 2>/dev/null | grep 86 >/dev/null \
!           && { echo i486-ncr-sysv4; exit; } ;;
!     NCR*:*:4.2:* | MPRAS*:*:4.2:*)
! 	OS_REL='.3'
! 	test -r /etc/.relid \
! 	    && OS_REL=.`sed -n 's/[^ ]* [^ ]* \([0-9][0-9]\).*/\1/p' < /etc/.relid`
! 	/bin/uname -p 2>/dev/null | grep 86 >/dev/null \
! 	    && { echo i486-ncr-sysv4.3${OS_REL}; exit; }
! 	/bin/uname -p 2>/dev/null | /bin/grep entium >/dev/null \
! 	    && { echo i586-ncr-sysv4.3${OS_REL}; exit; }
! 	/bin/uname -p 2>/dev/null | /bin/grep pteron >/dev/null \
! 	    && { echo i586-ncr-sysv4.3${OS_REL}; exit; } ;;
      m68*:LynxOS:2.*:* | m68*:LynxOS:3.0*:*)
  	echo m68k-unknown-lynxos${UNAME_RELEASE}
! 	exit ;;
      mc68030:UNIX_System_V:4.*:*)
  	echo m68k-atari-sysv4
! 	exit ;;
      TSUNAMI:LynxOS:2.*:*)
  	echo sparc-unknown-lynxos${UNAME_RELEASE}
! 	exit ;;
      rs6000:LynxOS:2.*:*)
  	echo rs6000-unknown-lynxos${UNAME_RELEASE}
! 	exit ;;
      PowerPC:LynxOS:2.*:* | PowerPC:LynxOS:3.[01]*:* | PowerPC:LynxOS:4.0*:*)
  	echo powerpc-unknown-lynxos${UNAME_RELEASE}
! 	exit ;;
      SM[BE]S:UNIX_SV:*:*)
  	echo mips-dde-sysv${UNAME_RELEASE}
! 	exit ;;
      RM*:ReliantUNIX-*:*:*)
  	echo mips-sni-sysv4
! 	exit ;;
      RM*:SINIX-*:*:*)
  	echo mips-sni-sysv4
! 	exit ;;
      *:SINIX-*:*:*)
  	if uname -p 2>/dev/null >/dev/null ; then
  		UNAME_MACHINE=`(uname -p) 2>/dev/null`
***************
*** 1126,1198 ****
  	else
  		echo ns32k-sni-sysv
  	fi
! 	exit 0 ;;
      PENTIUM:*:4.0*:*) # Unisys `ClearPath HMP IX 4000' SVR4/MP effort
                        # says <Richard.M.Bartel@ccMail.Census.GOV>
          echo i586-unisys-sysv4
!         exit 0 ;;
      *:UNIX_System_V:4*:FTX*)
  	# From Gerald Hewes <hewes@openmarket.com>.
  	# How about differentiating between stratus architectures? -djm
  	echo hppa1.1-stratus-sysv4
! 	exit 0 ;;
      *:*:*:FTX*)
  	# From seanf@swdc.stratus.com.
  	echo i860-stratus-sysv4
! 	exit 0 ;;
      i*86:VOS:*:*)
  	# From Paul.Green@stratus.com.
  	echo ${UNAME_MACHINE}-stratus-vos
! 	exit 0 ;;
      *:VOS:*:*)
  	# From Paul.Green@stratus.com.
  	echo hppa1.1-stratus-vos
! 	exit 0 ;;
      mc68*:A/UX:*:*)
  	echo m68k-apple-aux${UNAME_RELEASE}
! 	exit 0 ;;
      news*:NEWS-OS:6*:*)
  	echo mips-sony-newsos6
! 	exit 0 ;;
      R[34]000:*System_V*:*:* | R4000:UNIX_SYSV:*:* | R*000:UNIX_SV:*:*)
  	if [ -d /usr/nec ]; then
  	        echo mips-nec-sysv${UNAME_RELEASE}
  	else
  	        echo mips-unknown-sysv${UNAME_RELEASE}
  	fi
!         exit 0 ;;
      BeBox:BeOS:*:*)	# BeOS running on hardware made by Be, PPC only.
  	echo powerpc-be-beos
! 	exit 0 ;;
      BeMac:BeOS:*:*)	# BeOS running on Mac or Mac clone, PPC only.
  	echo powerpc-apple-beos
! 	exit 0 ;;
      BePC:BeOS:*:*)	# BeOS running on Intel PC compatible.
  	echo i586-pc-beos
! 	exit 0 ;;
      SX-4:SUPER-UX:*:*)
  	echo sx4-nec-superux${UNAME_RELEASE}
! 	exit 0 ;;
      SX-5:SUPER-UX:*:*)
  	echo sx5-nec-superux${UNAME_RELEASE}
! 	exit 0 ;;
      SX-6:SUPER-UX:*:*)
  	echo sx6-nec-superux${UNAME_RELEASE}
! 	exit 0 ;;
      Power*:Rhapsody:*:*)
  	echo powerpc-apple-rhapsody${UNAME_RELEASE}
! 	exit 0 ;;
      *:Rhapsody:*:*)
  	echo ${UNAME_MACHINE}-apple-rhapsody${UNAME_RELEASE}
! 	exit 0 ;;
      *:Darwin:*:*)
  	UNAME_PROCESSOR=`uname -p` || UNAME_PROCESSOR=unknown
  	case $UNAME_PROCESSOR in
- 	    *86) UNAME_PROCESSOR=i686 ;;
  	    unknown) UNAME_PROCESSOR=powerpc ;;
  	esac
  	echo ${UNAME_PROCESSOR}-apple-darwin${UNAME_RELEASE}
! 	exit 0 ;;
      *:procnto*:*:* | *:QNX:[0123456789]*:*)
  	UNAME_PROCESSOR=`uname -p`
  	if test "$UNAME_PROCESSOR" = "x86"; then
--- 1201,1284 ----
  	else
  		echo ns32k-sni-sysv
  	fi
! 	exit ;;
      PENTIUM:*:4.0*:*) # Unisys `ClearPath HMP IX 4000' SVR4/MP effort
                        # says <Richard.M.Bartel@ccMail.Census.GOV>
          echo i586-unisys-sysv4
!         exit ;;
      *:UNIX_System_V:4*:FTX*)
  	# From Gerald Hewes <hewes@openmarket.com>.
  	# How about differentiating between stratus architectures? -djm
  	echo hppa1.1-stratus-sysv4
! 	exit ;;
      *:*:*:FTX*)
  	# From seanf@swdc.stratus.com.
  	echo i860-stratus-sysv4
! 	exit ;;
      i*86:VOS:*:*)
  	# From Paul.Green@stratus.com.
  	echo ${UNAME_MACHINE}-stratus-vos
! 	exit ;;
      *:VOS:*:*)
  	# From Paul.Green@stratus.com.
  	echo hppa1.1-stratus-vos
! 	exit ;;
      mc68*:A/UX:*:*)
  	echo m68k-apple-aux${UNAME_RELEASE}
! 	exit ;;
      news*:NEWS-OS:6*:*)
  	echo mips-sony-newsos6
! 	exit ;;
      R[34]000:*System_V*:*:* | R4000:UNIX_SYSV:*:* | R*000:UNIX_SV:*:*)
  	if [ -d /usr/nec ]; then
  	        echo mips-nec-sysv${UNAME_RELEASE}
  	else
  	        echo mips-unknown-sysv${UNAME_RELEASE}
  	fi
!         exit ;;
      BeBox:BeOS:*:*)	# BeOS running on hardware made by Be, PPC only.
  	echo powerpc-be-beos
! 	exit ;;
      BeMac:BeOS:*:*)	# BeOS running on Mac or Mac clone, PPC only.
  	echo powerpc-apple-beos
! 	exit ;;
      BePC:BeOS:*:*)	# BeOS running on Intel PC compatible.
  	echo i586-pc-beos
! 	exit ;;
!     BePC:Haiku:*:*)	# Haiku running on Intel PC compatible.
! 	echo i586-pc-haiku
! 	exit ;;
      SX-4:SUPER-UX:*:*)
  	echo sx4-nec-superux${UNAME_RELEASE}
! 	exit ;;
      SX-5:SUPER-UX:*:*)
  	echo sx5-nec-superux${UNAME_RELEASE}
! 	exit ;;
      SX-6:SUPER-UX:*:*)
  	echo sx6-nec-superux${UNAME_RELEASE}
! 	exit ;;
!     SX-7:SUPER-UX:*:*)
! 	echo sx7-nec-superux${UNAME_RELEASE}
! 	exit ;;
!     SX-8:SUPER-UX:*:*)
! 	echo sx8-nec-superux${UNAME_RELEASE}
! 	exit ;;
!     SX-8R:SUPER-UX:*:*)
! 	echo sx8r-nec-superux${UNAME_RELEASE}
! 	exit ;;
      Power*:Rhapsody:*:*)
  	echo powerpc-apple-rhapsody${UNAME_RELEASE}
! 	exit ;;
      *:Rhapsody:*:*)
  	echo ${UNAME_MACHINE}-apple-rhapsody${UNAME_RELEASE}
! 	exit ;;
      *:Darwin:*:*)
  	UNAME_PROCESSOR=`uname -p` || UNAME_PROCESSOR=unknown
  	case $UNAME_PROCESSOR in
  	    unknown) UNAME_PROCESSOR=powerpc ;;
  	esac
  	echo ${UNAME_PROCESSOR}-apple-darwin${UNAME_RELEASE}
! 	exit ;;
      *:procnto*:*:* | *:QNX:[0123456789]*:*)
  	UNAME_PROCESSOR=`uname -p`
  	if test "$UNAME_PROCESSOR" = "x86"; then
***************
*** 1200,1224 ****
  		UNAME_MACHINE=pc
  	fi
  	echo ${UNAME_PROCESSOR}-${UNAME_MACHINE}-nto-qnx${UNAME_RELEASE}
! 	exit 0 ;;
      *:QNX:*:4*)
  	echo i386-pc-qnx
! 	exit 0 ;;
      NSE-?:NONSTOP_KERNEL:*:*)
  	echo nse-tandem-nsk${UNAME_RELEASE}
! 	exit 0 ;;
      NSR-?:NONSTOP_KERNEL:*:*)
  	echo nsr-tandem-nsk${UNAME_RELEASE}
! 	exit 0 ;;
      *:NonStop-UX:*:*)
  	echo mips-compaq-nonstopux
! 	exit 0 ;;
      BS2000:POSIX*:*:*)
  	echo bs2000-siemens-sysv
! 	exit 0 ;;
      DS/*:UNIX_System_V:*:*)
  	echo ${UNAME_MACHINE}-${UNAME_SYSTEM}-${UNAME_RELEASE}
! 	exit 0 ;;
      *:Plan9:*:*)
  	# "uname -m" is not consistent, so use $cputype instead. 386
  	# is converted to i386 for consistency with other x86
--- 1286,1310 ----
  		UNAME_MACHINE=pc
  	fi
  	echo ${UNAME_PROCESSOR}-${UNAME_MACHINE}-nto-qnx${UNAME_RELEASE}
! 	exit ;;
      *:QNX:*:4*)
  	echo i386-pc-qnx
! 	exit ;;
      NSE-?:NONSTOP_KERNEL:*:*)
  	echo nse-tandem-nsk${UNAME_RELEASE}
! 	exit ;;
      NSR-?:NONSTOP_KERNEL:*:*)
  	echo nsr-tandem-nsk${UNAME_RELEASE}
! 	exit ;;
      *:NonStop-UX:*:*)
  	echo mips-compaq-nonstopux
! 	exit ;;
      BS2000:POSIX*:*:*)
  	echo bs2000-siemens-sysv
! 	exit ;;
      DS/*:UNIX_System_V:*:*)
  	echo ${UNAME_MACHINE}-${UNAME_SYSTEM}-${UNAME_RELEASE}
! 	exit ;;
      *:Plan9:*:*)
  	# "uname -m" is not consistent, so use $cputype instead. 386
  	# is converted to i386 for consistency with other x86
***************
*** 1229,1269 ****
  	    UNAME_MACHINE="$cputype"
  	fi
  	echo ${UNAME_MACHINE}-unknown-plan9
! 	exit 0 ;;
      *:TOPS-10:*:*)
  	echo pdp10-unknown-tops10
! 	exit 0 ;;
      *:TENEX:*:*)
  	echo pdp10-unknown-tenex
! 	exit 0 ;;
      KS10:TOPS-20:*:* | KL10:TOPS-20:*:* | TYPE4:TOPS-20:*:*)
  	echo pdp10-dec-tops20
! 	exit 0 ;;
      XKL-1:TOPS-20:*:* | TYPE5:TOPS-20:*:*)
  	echo pdp10-xkl-tops20
! 	exit 0 ;;
      *:TOPS-20:*:*)
  	echo pdp10-unknown-tops20
! 	exit 0 ;;
      *:ITS:*:*)
  	echo pdp10-unknown-its
! 	exit 0 ;;
      SEI:*:*:SEIUX)
          echo mips-sei-seiux${UNAME_RELEASE}
! 	exit 0 ;;
      *:DragonFly:*:*)
  	echo ${UNAME_MACHINE}-unknown-dragonfly`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'`
! 	exit 0 ;;
      *:*VMS:*:*)
      	UNAME_MACHINE=`(uname -p) 2>/dev/null`
  	case "${UNAME_MACHINE}" in
! 	    A*) echo alpha-dec-vms && exit 0 ;;
! 	    I*) echo ia64-dec-vms && exit 0 ;;
! 	    V*) echo vax-dec-vms && exit 0 ;;
  	esac ;;
      *:XENIX:*:SysV)
  	echo i386-pc-xenix
! 	exit 0 ;;
  esac
  
  #echo '(No uname command or uname output not recognized.)' 1>&2
--- 1315,1364 ----
  	    UNAME_MACHINE="$cputype"
  	fi
  	echo ${UNAME_MACHINE}-unknown-plan9
! 	exit ;;
      *:TOPS-10:*:*)
  	echo pdp10-unknown-tops10
! 	exit ;;
      *:TENEX:*:*)
  	echo pdp10-unknown-tenex
! 	exit ;;
      KS10:TOPS-20:*:* | KL10:TOPS-20:*:* | TYPE4:TOPS-20:*:*)
  	echo pdp10-dec-tops20
! 	exit ;;
      XKL-1:TOPS-20:*:* | TYPE5:TOPS-20:*:*)
  	echo pdp10-xkl-tops20
! 	exit ;;
      *:TOPS-20:*:*)
  	echo pdp10-unknown-tops20
! 	exit ;;
      *:ITS:*:*)
  	echo pdp10-unknown-its
! 	exit ;;
      SEI:*:*:SEIUX)
          echo mips-sei-seiux${UNAME_RELEASE}
! 	exit ;;
      *:DragonFly:*:*)
  	echo ${UNAME_MACHINE}-unknown-dragonfly`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'`
! 	exit ;;
      *:*VMS:*:*)
      	UNAME_MACHINE=`(uname -p) 2>/dev/null`
  	case "${UNAME_MACHINE}" in
! 	    A*) echo alpha-dec-vms ; exit ;;
! 	    I*) echo ia64-dec-vms ; exit ;;
! 	    V*) echo vax-dec-vms ; exit ;;
  	esac ;;
      *:XENIX:*:SysV)
  	echo i386-pc-xenix
! 	exit ;;
!     i*86:skyos:*:*)
! 	echo ${UNAME_MACHINE}-pc-skyos`echo ${UNAME_RELEASE}` | sed -e 's/ .*$//'
! 	exit ;;
!     i*86:rdos:*:*)
! 	echo ${UNAME_MACHINE}-pc-rdos
! 	exit ;;
!     i*86:AROS:*:*)
! 	echo ${UNAME_MACHINE}-pc-aros
! 	exit ;;
  esac
  
  #echo '(No uname command or uname output not recognized.)' 1>&2
***************
*** 1295,1301 ****
  #endif
  
  #if defined (__arm) && defined (__acorn) && defined (__unix)
!   printf ("arm-acorn-riscix"); exit (0);
  #endif
  
  #if defined (hp300) && !defined (hpux)
--- 1390,1396 ----
  #endif
  
  #if defined (__arm) && defined (__acorn) && defined (__unix)
!   printf ("arm-acorn-riscix\n"); exit (0);
  #endif
  
  #if defined (hp300) && !defined (hpux)
***************
*** 1384,1394 ****
  }
  EOF
  
! $CC_FOR_BUILD -o $dummy $dummy.c 2>/dev/null && $dummy && exit 0
  
  # Apollos put the system type in the environment.
  
! test -d /usr/apollo && { echo ${ISP}-apollo-${SYSTYPE}; exit 0; }
  
  # Convex versions that predate uname can use getsysinfo(1)
  
--- 1479,1490 ----
  }
  EOF
  
! $CC_FOR_BUILD -o $dummy $dummy.c 2>/dev/null && SYSTEM_NAME=`$dummy` &&
! 	{ echo "$SYSTEM_NAME"; exit; }
  
  # Apollos put the system type in the environment.
  
! test -d /usr/apollo && { echo ${ISP}-apollo-${SYSTYPE}; exit; }
  
  # Convex versions that predate uname can use getsysinfo(1)
  
***************
*** 1397,1418 ****
      case `getsysinfo -f cpu_type` in
      c1*)
  	echo c1-convex-bsd
! 	exit 0 ;;
      c2*)
  	if getsysinfo -f scalar_acc
  	then echo c32-convex-bsd
  	else echo c2-convex-bsd
  	fi
! 	exit 0 ;;
      c34*)
  	echo c34-convex-bsd
! 	exit 0 ;;
      c38*)
  	echo c38-convex-bsd
! 	exit 0 ;;
      c4*)
  	echo c4-convex-bsd
! 	exit 0 ;;
      esac
  fi
  
--- 1493,1514 ----
      case `getsysinfo -f cpu_type` in
      c1*)
  	echo c1-convex-bsd
! 	exit ;;
      c2*)
  	if getsysinfo -f scalar_acc
  	then echo c32-convex-bsd
  	else echo c2-convex-bsd
  	fi
! 	exit ;;
      c34*)
  	echo c34-convex-bsd
! 	exit ;;
      c38*)
  	echo c38-convex-bsd
! 	exit ;;
      c4*)
  	echo c4-convex-bsd
! 	exit ;;
      esac
  fi
  
***************
*** 1423,1431 ****
  the operating system you are using. It is advised that you
  download the most up to date version of the config scripts from
  
!   http://savannah.gnu.org/cgi-bin/viewcvs/*checkout*/config/config/config.guess
  and
!   http://savannah.gnu.org/cgi-bin/viewcvs/*checkout*/config/config/config.sub
  
  If the version you run ($0) is already up to date, please
  send the following data and any information you think might be
--- 1519,1527 ----
  the operating system you are using. It is advised that you
  download the most up to date version of the config scripts from
  
!   http://git.savannah.gnu.org/gitweb/?p=config.git;a=blob_plain;f=config.guess;hb=HEAD
  and
!   http://git.savannah.gnu.org/gitweb/?p=config.git;a=blob_plain;f=config.sub;hb=HEAD
  
  If the version you run ($0) is already up to date, please
  send the following data and any information you think might be
diff -c -a -r -P ../wwwoffle-2.9e/config.sub ./config.sub
*** ../wwwoffle-2.9e/config.sub	Sun Apr 24 21:01:25 2005
--- ./config.sub	Mon May  4 00:55:47 2009
***************
*** 1,9 ****
  #! /bin/sh
  # Configuration validation subroutine script.
  #   Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
! #   2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.
  
! timestamp='2005-04-22'
  
  # This file is (in principle) common to ALL GNU software.
  # The presence of a machine in this file suggests that SOME GNU software
--- 1,10 ----
  #! /bin/sh
  # Configuration validation subroutine script.
  #   Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
! #   2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008
! #   Free Software Foundation, Inc.
  
! timestamp='2009-04-17'
  
  # This file is (in principle) common to ALL GNU software.
  # The presence of a machine in this file suggests that SOME GNU software
***************
*** 21,34 ****
  #
  # You should have received a copy of the GNU General Public License
  # along with this program; if not, write to the Free Software
! # Foundation, Inc., 59 Temple Place - Suite 330,
! # Boston, MA 02111-1307, USA.
! 
  # As a special exception to the GNU General Public License, if you
  # distribute this file as part of a program that contains a
  # configuration script generated by Autoconf, you may include it under
  # the same distribution terms that you use for the rest of that program.
  
  # Please send patches to <config-patches@gnu.org>.  Submit a context
  # diff and a properly formatted ChangeLog entry.
  #
--- 22,36 ----
  #
  # You should have received a copy of the GNU General Public License
  # along with this program; if not, write to the Free Software
! # Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA
! # 02110-1301, USA.
! #
  # As a special exception to the GNU General Public License, if you
  # distribute this file as part of a program that contains a
  # configuration script generated by Autoconf, you may include it under
  # the same distribution terms that you use for the rest of that program.
  
+ 
  # Please send patches to <config-patches@gnu.org>.  Submit a context
  # diff and a properly formatted ChangeLog entry.
  #
***************
*** 70,77 ****
  version="\
  GNU config.sub ($timestamp)
  
! Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005
! Free Software Foundation, Inc.
  
  This is free software; see the source for copying conditions.  There is NO
  warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
--- 72,79 ----
  version="\
  GNU config.sub ($timestamp)
  
! Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001,
! 2002, 2003, 2004, 2005, 2006, 2007, 2008 Free Software Foundation, Inc.
  
  This is free software; see the source for copying conditions.  There is NO
  warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
***************
*** 83,93 ****
  while test $# -gt 0 ; do
    case $1 in
      --time-stamp | --time* | -t )
!        echo "$timestamp" ; exit 0 ;;
      --version | -v )
!        echo "$version" ; exit 0 ;;
      --help | --h* | -h )
!        echo "$usage"; exit 0 ;;
      -- )     # Stop option processing
         shift; break ;;
      - )	# Use stdin as input.
--- 85,95 ----
  while test $# -gt 0 ; do
    case $1 in
      --time-stamp | --time* | -t )
!        echo "$timestamp" ; exit ;;
      --version | -v )
!        echo "$version" ; exit ;;
      --help | --h* | -h )
!        echo "$usage"; exit ;;
      -- )     # Stop option processing
         shift; break ;;
      - )	# Use stdin as input.
***************
*** 99,105 ****
      *local*)
         # First pass through any local machine types.
         echo $1
!        exit 0;;
  
      * )
         break ;;
--- 101,107 ----
      *local*)
         # First pass through any local machine types.
         echo $1
!        exit ;;
  
      * )
         break ;;
***************
*** 118,125 ****
  # Here we must recognize all the valid KERNEL-OS combinations.
  maybe_os=`echo $1 | sed 's/^\(.*\)-\([^-]*-[^-]*\)$/\2/'`
  case $maybe_os in
!   nto-qnx* | linux-gnu* | linux-dietlibc | linux-uclibc* | uclinux-uclibc* | uclinux-gnu* | \
!   kfreebsd*-gnu* | knetbsd*-gnu* | netbsd*-gnu* | storm-chaos* | os2-emx* | rtmk-nova*)
      os=-$maybe_os
      basic_machine=`echo $1 | sed 's/^\(.*\)-\([^-]*-[^-]*\)$/\1/'`
      ;;
--- 120,129 ----
  # Here we must recognize all the valid KERNEL-OS combinations.
  maybe_os=`echo $1 | sed 's/^\(.*\)-\([^-]*-[^-]*\)$/\2/'`
  case $maybe_os in
!   nto-qnx* | linux-gnu* | linux-dietlibc | linux-newlib* | linux-uclibc* | \
!   uclinux-uclibc* | uclinux-gnu* | kfreebsd*-gnu* | knetbsd*-gnu* | netbsd*-gnu* | \
!   kopensolaris*-gnu* | \
!   storm-chaos* | os2-emx* | rtmk-nova*)
      os=-$maybe_os
      basic_machine=`echo $1 | sed 's/^\(.*\)-\([^-]*-[^-]*\)$/\1/'`
      ;;
***************
*** 170,175 ****
--- 174,183 ----
  	-hiux*)
  		os=-hiuxwe2
  		;;
+ 	-sco6)
+ 		os=-sco5v6
+ 		basic_machine=`echo $1 | sed -e 's/86-.*/86-pc/'`
+ 		;;
  	-sco5)
  		os=-sco3.2v5
  		basic_machine=`echo $1 | sed -e 's/86-.*/86-pc/'`
***************
*** 186,191 ****
--- 194,203 ----
  		# Don't forget version if it is 3.2v4 or newer.
  		basic_machine=`echo $1 | sed -e 's/86-.*/86-pc/'`
  		;;
+ 	-sco5v6*)
+ 		# Don't forget version if it is 3.2v4 or newer.
+ 		basic_machine=`echo $1 | sed -e 's/86-.*/86-pc/'`
+ 		;;
  	-sco*)
  		os=-sco3.2v2
  		basic_machine=`echo $1 | sed -e 's/86-.*/86-pc/'`
***************
*** 230,252 ****
  	| alpha | alphaev[4-8] | alphaev56 | alphaev6[78] | alphapca5[67] \
  	| alpha64 | alpha64ev[4-8] | alpha64ev56 | alpha64ev6[78] | alpha64pca5[67] \
  	| am33_2.0 \
! 	| arc | arm | arm[bl]e | arme[lb] | armv[2345] | armv[345][lb] | avr \
  	| bfin \
  	| c4x | clipper \
  	| d10v | d30v | dlx | dsp16xx \
! 	| fr30 | frv \
  	| h8300 | h8500 | hppa | hppa1.[01] | hppa2.0 | hppa2.0[nw] | hppa64 \
  	| i370 | i860 | i960 | ia64 \
  	| ip2k | iq2000 \
! 	| m32r | m32rle | m68000 | m68k | m88k | maxq | mcore \
  	| mips | mipsbe | mipseb | mipsel | mipsle \
  	| mips16 \
  	| mips64 | mips64el \
! 	| mips64vr | mips64vrel \
  	| mips64orion | mips64orionel \
  	| mips64vr4100 | mips64vr4100el \
  	| mips64vr4300 | mips64vr4300el \
  	| mips64vr5000 | mips64vr5000el \
  	| mipsisa32 | mipsisa32el \
  	| mipsisa32r2 | mipsisa32r2el \
  	| mipsisa64 | mipsisa64el \
--- 242,269 ----
  	| alpha | alphaev[4-8] | alphaev56 | alphaev6[78] | alphapca5[67] \
  	| alpha64 | alpha64ev[4-8] | alpha64ev56 | alpha64ev6[78] | alpha64pca5[67] \
  	| am33_2.0 \
! 	| arc | arm | arm[bl]e | arme[lb] | armv[2345] | armv[345][lb] | avr | avr32 \
  	| bfin \
  	| c4x | clipper \
  	| d10v | d30v | dlx | dsp16xx \
! 	| fido | fr30 | frv \
  	| h8300 | h8500 | hppa | hppa1.[01] | hppa2.0 | hppa2.0[nw] | hppa64 \
  	| i370 | i860 | i960 | ia64 \
  	| ip2k | iq2000 \
! 	| lm32 \
! 	| m32c | m32r | m32rle | m68000 | m68k | m88k \
! 	| maxq | mb | microblaze | mcore | mep | metag \
  	| mips | mipsbe | mipseb | mipsel | mipsle \
  	| mips16 \
  	| mips64 | mips64el \
! 	| mips64octeon | mips64octeonel \
  	| mips64orion | mips64orionel \
+ 	| mips64r5900 | mips64r5900el \
+ 	| mips64vr | mips64vrel \
  	| mips64vr4100 | mips64vr4100el \
  	| mips64vr4300 | mips64vr4300el \
  	| mips64vr5000 | mips64vr5000el \
+ 	| mips64vr5900 | mips64vr5900el \
  	| mipsisa32 | mipsisa32el \
  	| mipsisa32r2 | mipsisa32r2el \
  	| mipsisa64 | mipsisa64el \
***************
*** 255,276 ****
  	| mipsisa64sr71k | mipsisa64sr71kel \
  	| mipstx39 | mipstx39el \
  	| mn10200 | mn10300 \
  	| msp430 \
  	| ns16k | ns32k \
! 	| openrisc | or32 \
  	| pdp10 | pdp11 | pj | pjl \
  	| powerpc | powerpc64 | powerpc64le | powerpcle | ppcbe \
  	| pyramid \
! 	| sh | sh[1234] | sh[23]e | sh[34]eb | shbe | shle | sh[1234]le | sh3ele \
  	| sh64 | sh64le \
! 	| sparc | sparc64 | sparc64b | sparc86x | sparclet | sparclite \
! 	| sparcv8 | sparcv9 | sparcv9b \
! 	| strongarm \
  	| tahoe | thumb | tic4x | tic80 | tron \
  	| v850 | v850e \
  	| we32k \
! 	| x86 | xscale | xscalee[bl] | xstormy16 | xtensa \
! 	| z8k)
  		basic_machine=$basic_machine-unknown
  		;;
  	m6811 | m68hc11 | m6812 | m68hc12)
--- 272,297 ----
  	| mipsisa64sr71k | mipsisa64sr71kel \
  	| mipstx39 | mipstx39el \
  	| mn10200 | mn10300 \
+ 	| moxie \
+ 	| mt \
  	| msp430 \
+ 	| nios | nios2 \
  	| ns16k | ns32k \
! 	| or32 \
  	| pdp10 | pdp11 | pj | pjl \
  	| powerpc | powerpc64 | powerpc64le | powerpcle | ppcbe \
  	| pyramid \
! 	| score \
! 	| sh | sh[1234] | sh[24]a | sh[24]aeb | sh[23]e | sh[34]eb | sheb | shbe | shle | sh[1234]le | sh3ele \
  	| sh64 | sh64le \
! 	| sparc | sparc64 | sparc64b | sparc64v | sparc86x | sparclet | sparclite \
! 	| sparcv8 | sparcv9 | sparcv9b | sparcv9v \
! 	| spu | strongarm \
  	| tahoe | thumb | tic4x | tic80 | tron \
  	| v850 | v850e \
  	| we32k \
! 	| x86 | xc16x | xscale | xscalee[bl] | xstormy16 | xtensa \
! 	| z8k | z80)
  		basic_machine=$basic_machine-unknown
  		;;
  	m6811 | m68hc11 | m6812 | m68hc12)
***************
*** 280,285 ****
--- 301,309 ----
  		;;
  	m88110 | m680[12346]0 | m683?2 | m68360 | m5200 | v70 | w65 | z8k)
  		;;
+ 	ms1)
+ 		basic_machine=mt-unknown
+ 		;;
  
  	# We use `pc' rather than `unknown'
  	# because (1) that's what they normally are, and
***************
*** 299,326 ****
  	| alpha64-* | alpha64ev[4-8]-* | alpha64ev56-* | alpha64ev6[78]-* \
  	| alphapca5[67]-* | alpha64pca5[67]-* | arc-* \
  	| arm-*  | armbe-* | armle-* | armeb-* | armv*-* \
! 	| avr-* \
  	| bfin-* | bs2000-* \
  	| c[123]* | c30-* | [cjt]90-* | c4x-* | c54x-* | c55x-* | c6x-* \
  	| clipper-* | craynv-* | cydra-* \
  	| d10v-* | d30v-* | dlx-* \
  	| elxsi-* \
! 	| f30[01]-* | f700-* | fr30-* | frv-* | fx80-* \
  	| h8300-* | h8500-* \
  	| hppa-* | hppa1.[01]-* | hppa2.0-* | hppa2.0[nw]-* | hppa64-* \
  	| i*86-* | i860-* | i960-* | ia64-* \
  	| ip2k-* | iq2000-* \
! 	| m32r-* | m32rle-* \
  	| m68000-* | m680[012346]0-* | m68360-* | m683?2-* | m68k-* \
! 	| m88110-* | m88k-* | maxq-* | mcore-* \
  	| mips-* | mipsbe-* | mipseb-* | mipsel-* | mipsle-* \
  	| mips16-* \
  	| mips64-* | mips64el-* \
! 	| mips64vr-* | mips64vrel-* \
  	| mips64orion-* | mips64orionel-* \
  	| mips64vr4100-* | mips64vr4100el-* \
  	| mips64vr4300-* | mips64vr4300el-* \
  	| mips64vr5000-* | mips64vr5000el-* \
  	| mipsisa32-* | mipsisa32el-* \
  	| mipsisa32r2-* | mipsisa32r2el-* \
  	| mipsisa64-* | mipsisa64el-* \
--- 323,354 ----
  	| alpha64-* | alpha64ev[4-8]-* | alpha64ev56-* | alpha64ev6[78]-* \
  	| alphapca5[67]-* | alpha64pca5[67]-* | arc-* \
  	| arm-*  | armbe-* | armle-* | armeb-* | armv*-* \
! 	| avr-* | avr32-* \
  	| bfin-* | bs2000-* \
  	| c[123]* | c30-* | [cjt]90-* | c4x-* | c54x-* | c55x-* | c6x-* \
  	| clipper-* | craynv-* | cydra-* \
  	| d10v-* | d30v-* | dlx-* \
  	| elxsi-* \
! 	| f30[01]-* | f700-* | fido-* | fr30-* | frv-* | fx80-* \
  	| h8300-* | h8500-* \
  	| hppa-* | hppa1.[01]-* | hppa2.0-* | hppa2.0[nw]-* | hppa64-* \
  	| i*86-* | i860-* | i960-* | ia64-* \
  	| ip2k-* | iq2000-* \
! 	| lm32-* \
! 	| m32c-* | m32r-* | m32rle-* \
  	| m68000-* | m680[012346]0-* | m68360-* | m683?2-* | m68k-* \
! 	| m88110-* | m88k-* | maxq-* | mcore-* | metag-* \
  	| mips-* | mipsbe-* | mipseb-* | mipsel-* | mipsle-* \
  	| mips16-* \
  	| mips64-* | mips64el-* \
! 	| mips64octeon-* | mips64octeonel-* \
  	| mips64orion-* | mips64orionel-* \
+ 	| mips64r5900-* | mips64r5900el-* \
+ 	| mips64vr-* | mips64vrel-* \
  	| mips64vr4100-* | mips64vr4100el-* \
  	| mips64vr4300-* | mips64vr4300el-* \
  	| mips64vr5000-* | mips64vr5000el-* \
+ 	| mips64vr5900-* | mips64vr5900el-* \
  	| mipsisa32-* | mipsisa32el-* \
  	| mipsisa32r2-* | mipsisa32r2el-* \
  	| mipsisa64-* | mipsisa64el-* \
***************
*** 329,355 ****
  	| mipsisa64sr71k-* | mipsisa64sr71kel-* \
  	| mipstx39-* | mipstx39el-* \
  	| mmix-* \
  	| msp430-* \
  	| none-* | np1-* | ns16k-* | ns32k-* \
  	| orion-* \
  	| pdp10-* | pdp11-* | pj-* | pjl-* | pn-* | power-* \
  	| powerpc-* | powerpc64-* | powerpc64le-* | powerpcle-* | ppcbe-* \
  	| pyramid-* \
  	| romp-* | rs6000-* \
! 	| sh-* | sh[1234]-* | sh[23]e-* | sh[34]eb-* | shbe-* \
  	| shle-* | sh[1234]le-* | sh3ele-* | sh64-* | sh64le-* \
! 	| sparc-* | sparc64-* | sparc64b-* | sparc86x-* | sparclet-* \
  	| sparclite-* \
! 	| sparcv8-* | sparcv9-* | sparcv9b-* | strongarm-* | sv1-* | sx?-* \
  	| tahoe-* | thumb-* \
! 	| tic30-* | tic4x-* | tic54x-* | tic55x-* | tic6x-* | tic80-* \
  	| tron-* \
  	| v850-* | v850e-* | vax-* \
  	| we32k-* \
! 	| x86-* | x86_64-* | xps100-* | xscale-* | xscalee[bl]-* \
! 	| xstormy16-* | xtensa-* \
  	| ymp-* \
! 	| z8k-*)
  		;;
  	# Recognize the various machine names and aliases which stand
  	# for a CPU type and a company and sometimes even an OS.
--- 357,389 ----
  	| mipsisa64sr71k-* | mipsisa64sr71kel-* \
  	| mipstx39-* | mipstx39el-* \
  	| mmix-* \
+ 	| mt-* \
  	| msp430-* \
+ 	| nios-* | nios2-* \
  	| none-* | np1-* | ns16k-* | ns32k-* \
  	| orion-* \
  	| pdp10-* | pdp11-* | pj-* | pjl-* | pn-* | power-* \
  	| powerpc-* | powerpc64-* | powerpc64le-* | powerpcle-* | ppcbe-* \
  	| pyramid-* \
  	| romp-* | rs6000-* \
! 	| sh-* | sh[1234]-* | sh[24]a-* | sh[24]aeb-* | sh[23]e-* | sh[34]eb-* | sheb-* | shbe-* \
  	| shle-* | sh[1234]le-* | sh3ele-* | sh64-* | sh64le-* \
! 	| sparc-* | sparc64-* | sparc64b-* | sparc64v-* | sparc86x-* | sparclet-* \
  	| sparclite-* \
! 	| sparcv8-* | sparcv9-* | sparcv9b-* | sparcv9v-* | strongarm-* | sv1-* | sx?-* \
  	| tahoe-* | thumb-* \
! 	| tic30-* | tic4x-* | tic54x-* | tic55x-* | tic6x-* | tic80-* | tile-* \
  	| tron-* \
  	| v850-* | v850e-* | vax-* \
  	| we32k-* \
! 	| x86-* | x86_64-* | xc16x-* | xps100-* | xscale-* | xscalee[bl]-* \
! 	| xstormy16-* | xtensa*-* \
  	| ymp-* \
! 	| z8k-* | z80-*)
! 		;;
! 	# Recognize the basic CPU types without company name, with glob match.
! 	xtensa*)
! 		basic_machine=$basic_machine-unknown
  		;;
  	# Recognize the various machine names and aliases which stand
  	# for a CPU type and a company and sometimes even an OS.
***************
*** 413,418 ****
--- 447,456 ----
  		basic_machine=m68k-apollo
  		os=-bsd
  		;;
+ 	aros)
+ 		basic_machine=i386-pc
+ 		os=-aros
+ 		;;
  	aux)
  		basic_machine=m68k-apple
  		os=-aux
***************
*** 421,430 ****
--- 459,480 ----
  		basic_machine=ns32k-sequent
  		os=-dynix
  		;;
+ 	blackfin)
+ 		basic_machine=bfin-unknown
+ 		os=-linux
+ 		;;
+ 	blackfin-*)
+ 		basic_machine=bfin-`echo $basic_machine | sed 's/^[^-]*-//'`
+ 		os=-linux
+ 		;;
  	c90)
  		basic_machine=c90-cray
  		os=-unicos
  		;;
+         cegcc)
+ 		basic_machine=arm-unknown
+ 		os=-cegcc
+ 		;;
  	convex-c1)
  		basic_machine=c1-convex
  		os=-bsd
***************
*** 453,460 ****
  		basic_machine=craynv-cray
  		os=-unicosmp
  		;;
! 	cr16c)
! 		basic_machine=cr16c-unknown
  		os=-elf
  		;;
  	crds | unos)
--- 503,510 ----
  		basic_machine=craynv-cray
  		os=-unicosmp
  		;;
! 	cr16)
! 		basic_machine=cr16-unknown
  		os=-elf
  		;;
  	crds | unos)
***************
*** 492,497 ****
--- 542,551 ----
  		basic_machine=m88k-motorola
  		os=-sysv3
  		;;
+ 	dicos)
+ 		basic_machine=i686-pc
+ 		os=-dicos
+ 		;;
  	djgpp)
  		basic_machine=i586-pc
  		os=-msdosdjgpp
***************
*** 646,651 ****
--- 700,713 ----
  		basic_machine=m68k-isi
  		os=-sysv
  		;;
+ 	m68knommu)
+ 		basic_machine=m68k-unknown
+ 		os=-linux
+ 		;;
+ 	m68knommu-*)
+ 		basic_machine=m68k-`echo $basic_machine | sed 's/^[^-]*-//'`
+ 		os=-linux
+ 		;;
  	m88k-omron*)
  		basic_machine=m88k-omron
  		;;
***************
*** 661,666 ****
--- 723,732 ----
  		basic_machine=i386-pc
  		os=-mingw32
  		;;
+ 	mingw32ce)
+ 		basic_machine=arm-unknown
+ 		os=-mingw32ce
+ 		;;
  	miniframe)
  		basic_machine=m68000-convergent
  		;;
***************
*** 686,691 ****
--- 752,760 ----
  		basic_machine=i386-pc
  		os=-msdos
  		;;
+ 	ms1-*)
+ 		basic_machine=`echo $basic_machine | sed -e 's/ms1-/mt-/'`
+ 		;;
  	mvs)
  		basic_machine=i370-ibm
  		os=-mvs
***************
*** 761,769 ****
  		basic_machine=hppa1.1-oki
  		os=-proelf
  		;;
! 	or32 | or32-*)
  		basic_machine=or32-unknown
- 		os=-coff
  		;;
  	os400)
  		basic_machine=powerpc-ibm
--- 830,837 ----
  		basic_machine=hppa1.1-oki
  		os=-proelf
  		;;
! 	openrisc | openrisc-*)
  		basic_machine=or32-unknown
  		;;
  	os400)
  		basic_machine=powerpc-ibm
***************
*** 785,790 ****
--- 853,866 ----
  		basic_machine=i860-intel
  		os=-osf
  		;;
+ 	parisc)
+ 		basic_machine=hppa-unknown
+ 		os=-linux
+ 		;;
+ 	parisc-*)
+ 		basic_machine=hppa-`echo $basic_machine | sed 's/^[^-]*-//'`
+ 		os=-linux
+ 		;;
  	pbd)
  		basic_machine=sparc-tti
  		;;
***************
*** 794,799 ****
--- 870,881 ----
  	pc532 | pc532-*)
  		basic_machine=ns32k-pc532
  		;;
+ 	pc98)
+ 		basic_machine=i386-pc
+ 		;;
+ 	pc98-*)
+ 		basic_machine=i386-`echo $basic_machine | sed 's/^[^-]*-//'`
+ 		;;
  	pentium | p5 | k5 | k6 | nexgen | viac3)
  		basic_machine=i586-pc
  		;;
***************
*** 850,855 ****
--- 932,941 ----
  		basic_machine=i586-unknown
  		os=-pw32
  		;;
+ 	rdos)
+ 		basic_machine=i386-pc
+ 		os=-rdos
+ 		;;
  	rom68k)
  		basic_machine=m68k-rom68k
  		os=-coff
***************
*** 876,881 ****
--- 962,971 ----
  	sb1el)
  		basic_machine=mipsisa64sb1el-unknown
  		;;
+ 	sde)
+ 		basic_machine=mipsisa32-sde
+ 		os=-elf
+ 		;;
  	sei)
  		basic_machine=mips-sei
  		os=-seiux
***************
*** 887,892 ****
--- 977,985 ----
  		basic_machine=sh-hitachi
  		os=-hms
  		;;
+ 	sh5el)
+ 		basic_machine=sh5le-unknown
+ 		;;
  	sh64)
  		basic_machine=sh64-unknown
  		;;
***************
*** 976,981 ****
--- 1069,1078 ----
  		basic_machine=tic6x-unknown
  		os=-coff
  		;;
+ 	tile*)
+ 		basic_machine=tile-unknown
+ 		os=-linux-gnu
+ 		;;
  	tx39)
  		basic_machine=mipstx39-unknown
  		;;
***************
*** 1051,1056 ****
--- 1148,1157 ----
  		basic_machine=z8k-unknown
  		os=-sim
  		;;
+ 	z80-*-coff)
+ 		basic_machine=z80-unknown
+ 		os=-sim
+ 		;;
  	none)
  		basic_machine=none-none
  		os=-none
***************
*** 1089,1101 ****
  	we32k)
  		basic_machine=we32k-att
  		;;
! 	sh3 | sh4 | sh[34]eb | sh[1234]le | sh[23]ele)
  		basic_machine=sh-unknown
  		;;
! 	sh64)
! 		basic_machine=sh64-unknown
! 		;;
! 	sparc | sparcv8 | sparcv9 | sparcv9b)
  		basic_machine=sparc-sun
  		;;
  	cydra)
--- 1190,1199 ----
  	we32k)
  		basic_machine=we32k-att
  		;;
! 	sh[1234] | sh[24]a | sh[24]aeb | sh[34]eb | sh[1234]le | sh[23]ele)
  		basic_machine=sh-unknown
  		;;
! 	sparc | sparcv8 | sparcv9 | sparcv9b | sparcv9v)
  		basic_machine=sparc-sun
  		;;
  	cydra)
***************
*** 1164,1187 ****
  	-gnu* | -bsd* | -mach* | -minix* | -genix* | -ultrix* | -irix* \
  	      | -*vms* | -sco* | -esix* | -isc* | -aix* | -sunos | -sunos[34]*\
  	      | -hpux* | -unos* | -osf* | -luna* | -dgux* | -solaris* | -sym* \
  	      | -amigaos* | -amigados* | -msdos* | -newsos* | -unicos* | -aof* \
! 	      | -aos* \
  	      | -nindy* | -vxsim* | -vxworks* | -ebmon* | -hms* | -mvs* \
  	      | -clix* | -riscos* | -uniplus* | -iris* | -rtu* | -xenix* \
! 	      | -hiux* | -386bsd* | -knetbsd* | -mirbsd* | -netbsd* | -openbsd* \
  	      | -ekkobsd* | -kfreebsd* | -freebsd* | -riscix* | -lynxos* \
  	      | -bosx* | -nextstep* | -cxux* | -aout* | -elf* | -oabi* \
  	      | -ptx* | -coff* | -ecoff* | -winnt* | -domain* | -vsta* \
  	      | -udi* | -eabi* | -lites* | -ieee* | -go32* | -aux* \
! 	      | -chorusos* | -chorusrdb* \
  	      | -cygwin* | -pe* | -psos* | -moss* | -proelf* | -rtems* \
! 	      | -mingw32* | -linux-gnu* | -linux-uclibc* | -uxpv* | -beos* | -mpeix* | -udk* \
  	      | -interix* | -uwin* | -mks* | -rhapsody* | -darwin* | -opened* \
  	      | -openstep* | -oskit* | -conix* | -pw32* | -nonstopux* \
  	      | -storm-chaos* | -tops10* | -tenex* | -tops20* | -its* \
  	      | -os2* | -vos* | -palmos* | -uclinux* | -nucleus* \
  	      | -morphos* | -superux* | -rtmk* | -rtmk-nova* | -windiss* \
! 	      | -powermax* | -dnix* | -nx6 | -nx7 | -sei* | -dragonfly*)
  	# Remember, each alternative MUST END IN *, to match a version number.
  		;;
  	-qnx*)
--- 1262,1289 ----
  	-gnu* | -bsd* | -mach* | -minix* | -genix* | -ultrix* | -irix* \
  	      | -*vms* | -sco* | -esix* | -isc* | -aix* | -sunos | -sunos[34]*\
  	      | -hpux* | -unos* | -osf* | -luna* | -dgux* | -solaris* | -sym* \
+ 	      | -kopensolaris* \
  	      | -amigaos* | -amigados* | -msdos* | -newsos* | -unicos* | -aof* \
! 	      | -aos* | -aros* \
  	      | -nindy* | -vxsim* | -vxworks* | -ebmon* | -hms* | -mvs* \
  	      | -clix* | -riscos* | -uniplus* | -iris* | -rtu* | -xenix* \
! 	      | -hiux* | -386bsd* | -knetbsd* | -mirbsd* | -netbsd* \
! 	      | -openbsd* | -solidbsd* \
  	      | -ekkobsd* | -kfreebsd* | -freebsd* | -riscix* | -lynxos* \
  	      | -bosx* | -nextstep* | -cxux* | -aout* | -elf* | -oabi* \
  	      | -ptx* | -coff* | -ecoff* | -winnt* | -domain* | -vsta* \
  	      | -udi* | -eabi* | -lites* | -ieee* | -go32* | -aux* \
! 	      | -chorusos* | -chorusrdb* | -cegcc* \
  	      | -cygwin* | -pe* | -psos* | -moss* | -proelf* | -rtems* \
! 	      | -mingw32* | -linux-gnu* | -linux-newlib* | -linux-uclibc* \
! 	      | -uxpv* | -beos* | -mpeix* | -udk* \
  	      | -interix* | -uwin* | -mks* | -rhapsody* | -darwin* | -opened* \
  	      | -openstep* | -oskit* | -conix* | -pw32* | -nonstopux* \
  	      | -storm-chaos* | -tops10* | -tenex* | -tops20* | -its* \
  	      | -os2* | -vos* | -palmos* | -uclinux* | -nucleus* \
  	      | -morphos* | -superux* | -rtmk* | -rtmk-nova* | -windiss* \
! 	      | -powermax* | -dnix* | -nx6 | -nx7 | -sei* | -dragonfly* \
! 	      | -skyos* | -haiku* | -rdos* | -toppers* | -drops*)
  	# Remember, each alternative MUST END IN *, to match a version number.
  		;;
  	-qnx*)
***************
*** 1199,1205 ****
  		os=`echo $os | sed -e 's|nto|nto-qnx|'`
  		;;
  	-sim | -es1800* | -hms* | -xray | -os68k* | -none* | -v88r* \
! 	      | -windows* | -osx | -abug | -netware* | -os9* | -beos* \
  	      | -macos* | -mpw* | -magic* | -mmixware* | -mon960* | -lnews*)
  		;;
  	-mac*)
--- 1301,1307 ----
  		os=`echo $os | sed -e 's|nto|nto-qnx|'`
  		;;
  	-sim | -es1800* | -hms* | -xray | -os68k* | -none* | -v88r* \
! 	      | -windows* | -osx | -abug | -netware* | -os9* | -beos* | -haiku* \
  	      | -macos* | -mpw* | -magic* | -mmixware* | -mon960* | -lnews*)
  		;;
  	-mac*)
***************
*** 1311,1316 ****
--- 1413,1421 ----
  	-zvmoe)
  		os=-zvmoe
  		;;
+ 	-dicos*)
+ 		os=-dicos
+ 		;;
  	-none)
  		;;
  	*)
***************
*** 1333,1338 ****
--- 1438,1449 ----
  # system, and we'll never get to this point.
  
  case $basic_machine in
+         score-*)
+ 		os=-elf
+ 		;;
+         spu-*)
+ 		os=-elf
+ 		;;
  	*-acorn)
  		os=-riscix1.2
  		;;
***************
*** 1342,1350 ****
  	arm*-semi)
  		os=-aout
  		;;
!     c4x-* | tic4x-*)
!         os=-coff
!         ;;
  	# This must come before the *-dec entry.
  	pdp10-*)
  		os=-tops20
--- 1453,1461 ----
  	arm*-semi)
  		os=-aout
  		;;
!         c4x-* | tic4x-*)
!         	os=-coff
! 		;;
  	# This must come before the *-dec entry.
  	pdp10-*)
  		os=-tops20
***************
*** 1370,1375 ****
--- 1481,1489 ----
  	m68*-cisco)
  		os=-aout
  		;;
+         mep-*)
+ 		os=-elf
+ 		;;
  	mips*-cisco)
  		os=-elf
  		;;
***************
*** 1388,1393 ****
--- 1502,1510 ----
  	*-be)
  		os=-beos
  		;;
+ 	*-haiku)
+ 		os=-haiku
+ 		;;
  	*-ibm)
  		os=-aix
  		;;
***************
*** 1559,1565 ****
  esac
  
  echo $basic_machine$os
! exit 0
  
  # Local variables:
  # eval: (add-hook 'write-file-hooks 'time-stamp)
--- 1676,1682 ----
  esac
  
  echo $basic_machine$os
! exit
  
  # Local variables:
  # eval: (add-hook 'write-file-hooks 'time-stamp)
diff -c -a -r -P ../wwwoffle-2.9e/configure ./configure
*** ../wwwoffle-2.9e/configure	Fri Dec 15 19:48:56 2006
--- ./configure	Thu Jan 14 17:47:53 2010
***************
*** 1,56 ****
  #! /bin/sh
  # Guess values for system-dependent variables and create Makefiles.
! # Generated by GNU Autoconf 2.60a for wwwoffle 2.9.
  #
  # Copyright (C) 1992, 1993, 1994, 1995, 1996, 1998, 1999, 2000, 2001,
! # 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
  # This configure script is free software; the Free Software Foundation
  # gives unlimited permission to copy, distribute and modify it.
! ## --------------------- ##
! ## M4sh Initialization.  ##
! ## --------------------- ##
  
! # Be Bourne compatible
! if test -n "${ZSH_VERSION+set}" && (emulate sh) >/dev/null 2>&1; then
    emulate sh
    NULLCMD=:
!   # Zsh 3.x and 4.x performs word splitting on ${1+"$@"}, which
    # is contrary to our usage.  Disable this feature.
    alias -g '${1+"$@"}'='"$@"'
    setopt NO_GLOB_SUBST
  else
!   case `(set -o) 2>/dev/null` in *posix*) set -o posix;; esac
  fi
- BIN_SH=xpg4; export BIN_SH # for Tru64
- DUALCASE=1; export DUALCASE # for MKS sh
- 
  
- # PATH needs CR
- # Avoid depending upon Character Ranges.
- as_cr_letters='abcdefghijklmnopqrstuvwxyz'
- as_cr_LETTERS='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
- as_cr_Letters=$as_cr_letters$as_cr_LETTERS
- as_cr_digits='0123456789'
- as_cr_alnum=$as_cr_Letters$as_cr_digits
  
! # The user is always right.
! if test "${PATH_SEPARATOR+set}" != set; then
!   echo "#! /bin/sh" >conf$$.sh
!   echo  "exit 0"   >>conf$$.sh
!   chmod +x conf$$.sh
!   if (PATH="/nonexistent;."; conf$$.sh) >/dev/null 2>&1; then
!     PATH_SEPARATOR=';'
    else
!     PATH_SEPARATOR=:
    fi
!   rm -f conf$$.sh
  fi
  
! # Support unset when possible.
! if ( (MAIL=60; unset MAIL) || exit) >/dev/null 2>&1; then
!   as_unset=unset
! else
!   as_unset=false
  fi
  
  
--- 1,83 ----
  #! /bin/sh
  # Guess values for system-dependent variables and create Makefiles.
! # Generated by GNU Autoconf 2.65 for wwwoffle 2.9.
! #
  #
  # Copyright (C) 1992, 1993, 1994, 1995, 1996, 1998, 1999, 2000, 2001,
! # 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009 Free Software Foundation,
! # Inc.
! #
! #
  # This configure script is free software; the Free Software Foundation
  # gives unlimited permission to copy, distribute and modify it.
! ## -------------------- ##
! ## M4sh Initialization. ##
! ## -------------------- ##
  
! # Be more Bourne compatible
! DUALCASE=1; export DUALCASE # for MKS sh
! if test -n "${ZSH_VERSION+set}" && (emulate sh) >/dev/null 2>&1; then :
    emulate sh
    NULLCMD=:
!   # Pre-4.2 versions of Zsh do word splitting on ${1+"$@"}, which
    # is contrary to our usage.  Disable this feature.
    alias -g '${1+"$@"}'='"$@"'
    setopt NO_GLOB_SUBST
  else
!   case `(set -o) 2>/dev/null` in #(
!   *posix*) :
!     set -o posix ;; #(
!   *) :
!      ;;
! esac
  fi
  
  
! as_nl='
! '
! export as_nl
! # Printing a long string crashes Solaris 7 /usr/bin/printf.
! as_echo='\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\'
! as_echo=$as_echo$as_echo$as_echo$as_echo$as_echo
! as_echo=$as_echo$as_echo$as_echo$as_echo$as_echo$as_echo
! # Prefer a ksh shell builtin over an external printf program on Solaris,
! # but without wasting forks for bash or zsh.
! if test -z "$BASH_VERSION$ZSH_VERSION" \
!     && (test "X`print -r -- $as_echo`" = "X$as_echo") 2>/dev/null; then
!   as_echo='print -r --'
!   as_echo_n='print -rn --'
! elif (test "X`printf %s $as_echo`" = "X$as_echo") 2>/dev/null; then
!   as_echo='printf %s\n'
!   as_echo_n='printf %s'
! else
!   if test "X`(/usr/ucb/echo -n -n $as_echo) 2>/dev/null`" = "X-n $as_echo"; then
!     as_echo_body='eval /usr/ucb/echo -n "$1$as_nl"'
!     as_echo_n='/usr/ucb/echo -n'
    else
!     as_echo_body='eval expr "X$1" : "X\\(.*\\)"'
!     as_echo_n_body='eval
!       arg=$1;
!       case $arg in #(
!       *"$as_nl"*)
! 	expr "X$arg" : "X\\(.*\\)$as_nl";
! 	arg=`expr "X$arg" : ".*$as_nl\\(.*\\)"`;;
!       esac;
!       expr "X$arg" : "X\\(.*\\)" | tr -d "$as_nl"
!     '
!     export as_echo_n_body
!     as_echo_n='sh -c $as_echo_n_body as_echo'
    fi
!   export as_echo_body
!   as_echo='sh -c $as_echo_body as_echo'
  fi
  
! # The user is always right.
! if test "${PATH_SEPARATOR+set}" != set; then
!   PATH_SEPARATOR=:
!   (PATH='/bin;/bin'; FPATH=$PATH; sh -c :) >/dev/null 2>&1 && {
!     (PATH='/bin:/bin'; FPATH=$PATH; sh -c :) >/dev/null 2>&1 ||
!       PATH_SEPARATOR=';'
!   }
  fi
  
  
***************
*** 59,78 ****
  # there to prevent editors from complaining about space-tab.
  # (If _AS_PATH_WALK were called with IFS unset, it would disable word
  # splitting by setting IFS to empty value.)
- as_nl='
- '
  IFS=" ""	$as_nl"
  
  # Find who we are.  Look in the path if we contain no directory separator.
! case $0 in
    *[\\/]* ) as_myself=$0 ;;
    *) as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   test -r "$as_dir/$0" && as_myself=$as_dir/$0 && break
! done
  IFS=$as_save_IFS
  
       ;;
--- 86,103 ----
  # there to prevent editors from complaining about space-tab.
  # (If _AS_PATH_WALK were called with IFS unset, it would disable word
  # splitting by setting IFS to empty value.)
  IFS=" ""	$as_nl"
  
  # Find who we are.  Look in the path if we contain no directory separator.
! case $0 in #((
    *[\\/]* ) as_myself=$0 ;;
    *) as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     test -r "$as_dir/$0" && as_myself=$as_dir/$0 && break
!   done
  IFS=$as_save_IFS
  
       ;;
***************
*** 83,434 ****
    as_myself=$0
  fi
  if test ! -f "$as_myself"; then
!   echo "$as_myself: error: cannot find myself; rerun with an absolute file name" >&2
!   { (exit 1); exit 1; }
  fi
  
! # Work around bugs in pre-3.0 UWIN ksh.
! for as_var in ENV MAIL MAILPATH
! do ($as_unset $as_var) >/dev/null 2>&1 && $as_unset $as_var
  done
  PS1='$ '
  PS2='> '
  PS4='+ '
  
  # NLS nuisances.
! for as_var in \
!   LANG LANGUAGE LC_ADDRESS LC_ALL LC_COLLATE LC_CTYPE LC_IDENTIFICATION \
!   LC_MEASUREMENT LC_MESSAGES LC_MONETARY LC_NAME LC_NUMERIC LC_PAPER \
!   LC_TELEPHONE LC_TIME
! do
!   if (set +x; test -z "`(eval $as_var=C; export $as_var) 2>&1`"); then
!     eval $as_var=C; export $as_var
!   else
!     ($as_unset $as_var) >/dev/null 2>&1 && $as_unset $as_var
!   fi
! done
! 
! # Required to use basename.
! if expr a : '\(a\)' >/dev/null 2>&1 &&
!    test "X`expr 00001 : '.*\(...\)'`" = X001; then
!   as_expr=expr
! else
!   as_expr=false
! fi
! 
! if (basename -- /) >/dev/null 2>&1 && test "X`basename -- / 2>&1`" = "X/"; then
!   as_basename=basename
! else
!   as_basename=false
! fi
! 
! 
! # Name of the executable.
! as_me=`$as_basename -- "$0" ||
! $as_expr X/"$0" : '.*/\([^/][^/]*\)/*$' \| \
! 	 X"$0" : 'X\(//\)$' \| \
! 	 X"$0" : 'X\(/\)' \| . 2>/dev/null ||
! echo X/"$0" |
!     sed '/^.*\/\([^/][^/]*\)\/*$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\/\(\/\/\)$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\/\(\/\).*/{
! 	    s//\1/
! 	    q
! 	  }
! 	  s/.*/./; q'`
  
  # CDPATH.
! $as_unset CDPATH
! 
  
  if test "x$CONFIG_SHELL" = x; then
!   if (eval ":") 2>/dev/null; then
!   as_have_required=yes
  else
!   as_have_required=no
  fi
! 
!   if test $as_have_required = yes && 	 (eval ":
! (as_func_return () {
!   (exit \$1)
! }
! as_func_success () {
!   as_func_return 0
! }
! as_func_failure () {
!   as_func_return 1
! }
! as_func_ret_success () {
!   return 0
! }
! as_func_ret_failure () {
!   return 1
! }
  
  exitcode=0
! if as_func_success; then
!   :
! else
!   exitcode=1
!   echo as_func_success failed.
! fi
! 
! if as_func_failure; then
!   exitcode=1
!   echo as_func_failure succeeded.
! fi
! 
! if as_func_ret_success; then
!   :
! else
!   exitcode=1
!   echo as_func_ret_success failed.
! fi
! 
! if as_func_ret_failure; then
!   exitcode=1
!   echo as_func_ret_failure succeeded.
! fi
! 
! if ( set x; as_func_ret_success y && test x = \"\$1\" ); then
!   :
  else
!   exitcode=1
!   echo positional parameters were not saved.
  fi
  
- test \$exitcode = 0) || { (exit 1); exit 1; }
- 
- (
-   as_lineno_1=\$LINENO
-   as_lineno_2=\$LINENO
-   test \"x\$as_lineno_1\" != \"x\$as_lineno_2\" &&
-   test \"x\`expr \$as_lineno_1 + 1\`\" = \"x\$as_lineno_2\") || { (exit 1); exit 1; }
- ") 2> /dev/null; then
-   :
  else
!   as_candidate_shells=
!     as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
! for as_dir in /usr/bin/posix$PATH_SEPARATOR/bin$PATH_SEPARATOR/usr/bin$PATH_SEPARATOR$PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   case $as_dir in
  	 /*)
  	   for as_base in sh bash ksh sh5; do
! 	     as_candidate_shells="$as_candidate_shells $as_dir/$as_base"
  	   done;;
         esac
  done
  IFS=$as_save_IFS
  
  
!       for as_shell in $as_candidate_shells $SHELL; do
! 	 # Try only shells that exist, to save several forks.
! 	 if { test -f "$as_shell" || test -f "$as_shell.exe"; } &&
! 		{ ("$as_shell") 2> /dev/null <<\_ASEOF
! # Be Bourne compatible
! if test -n "${ZSH_VERSION+set}" && (emulate sh) >/dev/null 2>&1; then
!   emulate sh
!   NULLCMD=:
!   # Zsh 3.x and 4.x performs word splitting on ${1+"$@"}, which
!   # is contrary to our usage.  Disable this feature.
!   alias -g '${1+"$@"}'='"$@"'
!   setopt NO_GLOB_SUBST
! else
!   case `(set -o) 2>/dev/null` in *posix*) set -o posix;; esac
  fi
- BIN_SH=xpg4; export BIN_SH # for Tru64
- DUALCASE=1; export DUALCASE # for MKS sh
- 
- :
- _ASEOF
- }; then
-   CONFIG_SHELL=$as_shell
- 	       as_have_required=yes
- 	       if { "$as_shell" 2> /dev/null <<\_ASEOF
- # Be Bourne compatible
- if test -n "${ZSH_VERSION+set}" && (emulate sh) >/dev/null 2>&1; then
-   emulate sh
-   NULLCMD=:
-   # Zsh 3.x and 4.x performs word splitting on ${1+"$@"}, which
-   # is contrary to our usage.  Disable this feature.
-   alias -g '${1+"$@"}'='"$@"'
-   setopt NO_GLOB_SUBST
- else
-   case `(set -o) 2>/dev/null` in *posix*) set -o posix;; esac
  fi
! BIN_SH=xpg4; export BIN_SH # for Tru64
! DUALCASE=1; export DUALCASE # for MKS sh
  
! :
! (as_func_return () {
!   (exit $1)
! }
! as_func_success () {
!   as_func_return 0
! }
! as_func_failure () {
!   as_func_return 1
! }
! as_func_ret_success () {
!   return 0
! }
! as_func_ret_failure () {
!   return 1
  }
  
! exitcode=0
! if as_func_success; then
!   :
! else
!   exitcode=1
!   echo as_func_success failed.
! fi
  
! if as_func_failure; then
!   exitcode=1
!   echo as_func_failure succeeded.
! fi
  
! if as_func_ret_success; then
!   :
! else
!   exitcode=1
!   echo as_func_ret_success failed.
! fi
  
- if as_func_ret_failure; then
-   exitcode=1
-   echo as_func_ret_failure succeeded.
- fi
  
! if ( set x; as_func_ret_success y && test x = "$1" ); then
!   :
  else
!   exitcode=1
!   echo positional parameters were not saved.
! fi
! 
! test $exitcode = 0) || { (exit 1); exit 1; }
! 
! (
!   as_lineno_1=$LINENO
!   as_lineno_2=$LINENO
!   test "x$as_lineno_1" != "x$as_lineno_2" &&
!   test "x`expr $as_lineno_1 + 1`" = "x$as_lineno_2") || { (exit 1); exit 1; }
! 
! _ASEOF
! }; then
!   break
! fi
! 
! fi
! 
!       done
! 
!       if test "x$CONFIG_SHELL" != x; then
!   for as_var in BASH_ENV ENV
!         do ($as_unset $as_var) >/dev/null 2>&1 && $as_unset $as_var
!         done
!         export CONFIG_SHELL
!         exec "$CONFIG_SHELL" "$as_myself" ${1+"$@"}
! fi
! 
! 
!     if test $as_have_required = no; then
!   echo This script requires a shell more modern than all the
!       echo shells that I found on your system.  Please install a
!       echo modern shell, or manually run the script under such a
!       echo shell if you do have one.
!       { (exit 1); exit 1; }
! fi
! 
! 
! fi
! 
! fi
! 
  
  
! (eval "as_func_return () {
!   (exit \$1)
! }
! as_func_success () {
!   as_func_return 0
! }
! as_func_failure () {
!   as_func_return 1
! }
! as_func_ret_success () {
!   return 0
! }
! as_func_ret_failure () {
!   return 1
! }
  
! exitcode=0
! if as_func_success; then
!   :
  else
!   exitcode=1
!   echo as_func_success failed.
! fi
! 
! if as_func_failure; then
!   exitcode=1
!   echo as_func_failure succeeded.
  fi
  
! if as_func_ret_success; then
!   :
  else
!   exitcode=1
!   echo as_func_ret_success failed.
! fi
! 
! if as_func_ret_failure; then
!   exitcode=1
!   echo as_func_ret_failure succeeded.
  fi
  
! if ( set x; as_func_ret_success y && test x = \"\$1\" ); then
!   :
  else
!   exitcode=1
!   echo positional parameters were not saved.
  fi
  
! test \$exitcode = 0") || {
!   echo No shell found that supports shell functions.
!   echo Please tell autoconf@gnu.org about your system,
!   echo including any error possibly output before this
!   echo message
! }
  
  
  
!   as_lineno_1=$LINENO
!   as_lineno_2=$LINENO
!   test "x$as_lineno_1" != "x$as_lineno_2" &&
!   test "x`expr $as_lineno_1 + 1`" = "x$as_lineno_2" || {
! 
!   # Create $as_me.lineno as a copy of $as_myself, but with $LINENO
!   # uniformly replaced by the line number.  The first 'sed' inserts a
!   # line-number line after each line using $LINENO; the second 'sed'
!   # does the real work.  The second script uses 'N' to pair each
!   # line-number line with the line containing $LINENO, and appends
!   # trailing '-' during substitution so that $LINENO is not a special
!   # case at line end.
!   # (Raja R Harinath suggested sed '=', and Paul Eggert wrote the
!   # scripts with optimization help from Paolo Bonzini.  Blame Lee
!   # E. McMahon (1931-1989) for sed's syntax.  :-)
    sed -n '
      p
      /[$]LINENO/=
--- 108,428 ----
    as_myself=$0
  fi
  if test ! -f "$as_myself"; then
!   $as_echo "$as_myself: error: cannot find myself; rerun with an absolute file name" >&2
!   exit 1
  fi
  
! # Unset variables that we do not need and which cause bugs (e.g. in
! # pre-3.0 UWIN ksh).  But do not cause bugs in bash 2.01; the "|| exit 1"
! # suppresses any "Segmentation fault" message there.  '((' could
! # trigger a bug in pdksh 5.2.14.
! for as_var in BASH_ENV ENV MAIL MAILPATH
! do eval test x\${$as_var+set} = xset \
!   && ( (unset $as_var) || exit 1) >/dev/null 2>&1 && unset $as_var || :
  done
  PS1='$ '
  PS2='> '
  PS4='+ '
  
  # NLS nuisances.
! LC_ALL=C
! export LC_ALL
! LANGUAGE=C
! export LANGUAGE
  
  # CDPATH.
! (unset CDPATH) >/dev/null 2>&1 && unset CDPATH
  
  if test "x$CONFIG_SHELL" = x; then
!   as_bourne_compatible="if test -n \"\${ZSH_VERSION+set}\" && (emulate sh) >/dev/null 2>&1; then :
!   emulate sh
!   NULLCMD=:
!   # Pre-4.2 versions of Zsh do word splitting on \${1+\"\$@\"}, which
!   # is contrary to our usage.  Disable this feature.
!   alias -g '\${1+\"\$@\"}'='\"\$@\"'
!   setopt NO_GLOB_SUBST
  else
!   case \`(set -o) 2>/dev/null\` in #(
!   *posix*) :
!     set -o posix ;; #(
!   *) :
!      ;;
! esac
  fi
! "
!   as_required="as_fn_return () { (exit \$1); }
! as_fn_success () { as_fn_return 0; }
! as_fn_failure () { as_fn_return 1; }
! as_fn_ret_success () { return 0; }
! as_fn_ret_failure () { return 1; }
  
  exitcode=0
! as_fn_success || { exitcode=1; echo as_fn_success failed.; }
! as_fn_failure && { exitcode=1; echo as_fn_failure succeeded.; }
! as_fn_ret_success || { exitcode=1; echo as_fn_ret_success failed.; }
! as_fn_ret_failure && { exitcode=1; echo as_fn_ret_failure succeeded.; }
! if ( set x; as_fn_ret_success y && test x = \"\$1\" ); then :
! 
! else
!   exitcode=1; echo positional parameters were not saved.
! fi
! test x\$exitcode = x0 || exit 1"
!   as_suggested="  as_lineno_1=";as_suggested=$as_suggested$LINENO;as_suggested=$as_suggested" as_lineno_1a=\$LINENO
!   as_lineno_2=";as_suggested=$as_suggested$LINENO;as_suggested=$as_suggested" as_lineno_2a=\$LINENO
!   eval 'test \"x\$as_lineno_1'\$as_run'\" != \"x\$as_lineno_2'\$as_run'\" &&
!   test \"x\`expr \$as_lineno_1'\$as_run' + 1\`\" = \"x\$as_lineno_2'\$as_run'\"' || exit 1
! test \$(( 1 + 1 )) = 2 || exit 1"
!   if (eval "$as_required") 2>/dev/null; then :
!   as_have_required=yes
  else
!   as_have_required=no
  fi
+   if test x$as_have_required = xyes && (eval "$as_suggested") 2>/dev/null; then :
  
  else
!   as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
! as_found=false
! for as_dir in /bin$PATH_SEPARATOR/usr/bin$PATH_SEPARATOR$PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   as_found=:
!   case $as_dir in #(
  	 /*)
  	   for as_base in sh bash ksh sh5; do
! 	     # Try only shells that exist, to save several forks.
! 	     as_shell=$as_dir/$as_base
! 	     if { test -f "$as_shell" || test -f "$as_shell.exe"; } &&
! 		    { $as_echo "$as_bourne_compatible""$as_required" | as_run=a "$as_shell"; } 2>/dev/null; then :
!   CONFIG_SHELL=$as_shell as_have_required=yes
! 		   if { $as_echo "$as_bourne_compatible""$as_suggested" | as_run=a "$as_shell"; } 2>/dev/null; then :
!   break 2
! fi
! fi
  	   done;;
         esac
+   as_found=false
  done
+ $as_found || { if { test -f "$SHELL" || test -f "$SHELL.exe"; } &&
+ 	      { $as_echo "$as_bourne_compatible""$as_required" | as_run=a "$SHELL"; } 2>/dev/null; then :
+   CONFIG_SHELL=$SHELL as_have_required=yes
+ fi; }
  IFS=$as_save_IFS
  
  
!       if test "x$CONFIG_SHELL" != x; then :
!   # We cannot yet assume a decent shell, so we have to provide a
! 	# neutralization value for shells without unset; and this also
! 	# works around shells that cannot unset nonexistent variables.
! 	BASH_ENV=/dev/null
! 	ENV=/dev/null
! 	(unset BASH_ENV) >/dev/null 2>&1 && unset BASH_ENV ENV
! 	export CONFIG_SHELL
! 	exec "$CONFIG_SHELL" "$as_myself" ${1+"$@"}
! fi
! 
!     if test x$as_have_required = xno; then :
!   $as_echo "$0: This script requires a shell more modern than all"
!   $as_echo "$0: the shells that I found on your system."
!   if test x${ZSH_VERSION+set} = xset ; then
!     $as_echo "$0: In particular, zsh $ZSH_VERSION has bugs and should"
!     $as_echo "$0: be upgraded to zsh 4.3.4 or later."
!   else
!     $as_echo "$0: Please tell bug-autoconf@gnu.org about your system,
! $0: including any error possibly output before this
! $0: message. Then install a modern shell, or manually run
! $0: the script under such a shell if you do have one."
!   fi
!   exit 1
  fi
  fi
! fi
! SHELL=${CONFIG_SHELL-/bin/sh}
! export SHELL
! # Unset more variables known to interfere with behavior of common tools.
! CLICOLOR_FORCE= GREP_OPTIONS=
! unset CLICOLOR_FORCE GREP_OPTIONS
  
! ## --------------------- ##
! ## M4sh Shell Functions. ##
! ## --------------------- ##
! # as_fn_unset VAR
! # ---------------
! # Portably unset VAR.
! as_fn_unset ()
! {
!   { eval $1=; unset $1;}
  }
+ as_unset=as_fn_unset
  
! # as_fn_set_status STATUS
! # -----------------------
! # Set $? to STATUS, without forking.
! as_fn_set_status ()
! {
!   return $1
! } # as_fn_set_status
  
! # as_fn_exit STATUS
! # -----------------
! # Exit the shell with STATUS, even in a "trap 0" or "set -e" context.
! as_fn_exit ()
! {
!   set +e
!   as_fn_set_status $1
!   exit $1
! } # as_fn_exit
! 
! # as_fn_mkdir_p
! # -------------
! # Create "$as_dir" as a directory, including parents if necessary.
! as_fn_mkdir_p ()
! {
  
!   case $as_dir in #(
!   -*) as_dir=./$as_dir;;
!   esac
!   test -d "$as_dir" || eval $as_mkdir_p || {
!     as_dirs=
!     while :; do
!       case $as_dir in #(
!       *\'*) as_qdir=`$as_echo "$as_dir" | sed "s/'/'\\\\\\\\''/g"`;; #'(
!       *) as_qdir=$as_dir;;
!       esac
!       as_dirs="'$as_qdir' $as_dirs"
!       as_dir=`$as_dirname -- "$as_dir" ||
! $as_expr X"$as_dir" : 'X\(.*[^/]\)//*[^/][^/]*/*$' \| \
! 	 X"$as_dir" : 'X\(//\)[^/]' \| \
! 	 X"$as_dir" : 'X\(//\)$' \| \
! 	 X"$as_dir" : 'X\(/\)' \| . 2>/dev/null ||
! $as_echo X"$as_dir" |
!     sed '/^X\(.*[^/]\)\/\/*[^/][^/]*\/*$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\(\/\/\)[^/].*/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\(\/\/\)$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\(\/\).*/{
! 	    s//\1/
! 	    q
! 	  }
! 	  s/.*/./; q'`
!       test -d "$as_dir" && break
!     done
!     test -z "$as_dirs" || eval "mkdir $as_dirs"
!   } || test -d "$as_dir" || as_fn_error "cannot create directory $as_dir"
  
  
! } # as_fn_mkdir_p
! # as_fn_append VAR VALUE
! # ----------------------
! # Append the text in VALUE to the end of the definition contained in VAR. Take
! # advantage of any shell optimizations that allow amortized linear growth over
! # repeated appends, instead of the typical quadratic growth present in naive
! # implementations.
! if (eval "as_var=1; as_var+=2; test x\$as_var = x12") 2>/dev/null; then :
!   eval 'as_fn_append ()
!   {
!     eval $1+=\$2
!   }'
  else
!   as_fn_append ()
!   {
!     eval $1=\$$1\$2
!   }
! fi # as_fn_append
! 
! # as_fn_arith ARG...
! # ------------------
! # Perform arithmetic evaluation on the ARGs, and store the result in the
! # global $as_val. Take advantage of shells that can avoid forks. The arguments
! # must be portable across $(()) and expr.
! if (eval "test \$(( 1 + 1 )) = 2") 2>/dev/null; then :
!   eval 'as_fn_arith ()
!   {
!     as_val=$(( $* ))
!   }'
! else
!   as_fn_arith ()
!   {
!     as_val=`expr "$@" || test $? -eq 1`
!   }
! fi # as_fn_arith
  
  
! # as_fn_error ERROR [LINENO LOG_FD]
! # ---------------------------------
! # Output "`basename $0`: error: ERROR" to stderr. If LINENO and LOG_FD are
! # provided, also output the error to LOG_FD, referencing LINENO. Then exit the
! # script with status $?, using 1 if that was 0.
! as_fn_error ()
! {
!   as_status=$?; test $as_status -eq 0 && as_status=1
!   if test "$3"; then
!     as_lineno=${as_lineno-"$2"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!     $as_echo "$as_me:${as_lineno-$LINENO}: error: $1" >&$3
!   fi
!   $as_echo "$as_me: error: $1" >&2
!   as_fn_exit $as_status
! } # as_fn_error
  
! if expr a : '\(a\)' >/dev/null 2>&1 &&
!    test "X`expr 00001 : '.*\(...\)'`" = X001; then
!   as_expr=expr
  else
!   as_expr=false
  fi
  
! if (basename -- /) >/dev/null 2>&1 && test "X`basename -- / 2>&1`" = "X/"; then
!   as_basename=basename
  else
!   as_basename=false
  fi
  
! if (as_dir=`dirname -- /` && test "X$as_dir" = X/) >/dev/null 2>&1; then
!   as_dirname=dirname
  else
!   as_dirname=false
  fi
  
! as_me=`$as_basename -- "$0" ||
! $as_expr X/"$0" : '.*/\([^/][^/]*\)/*$' \| \
! 	 X"$0" : 'X\(//\)$' \| \
! 	 X"$0" : 'X\(/\)' \| . 2>/dev/null ||
! $as_echo X/"$0" |
!     sed '/^.*\/\([^/][^/]*\)\/*$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\/\(\/\/\)$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\/\(\/\).*/{
! 	    s//\1/
! 	    q
! 	  }
! 	  s/.*/./; q'`
  
+ # Avoid depending upon Character Ranges.
+ as_cr_letters='abcdefghijklmnopqrstuvwxyz'
+ as_cr_LETTERS='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
+ as_cr_Letters=$as_cr_letters$as_cr_LETTERS
+ as_cr_digits='0123456789'
+ as_cr_alnum=$as_cr_Letters$as_cr_digits
  
  
!   as_lineno_1=$LINENO as_lineno_1a=$LINENO
!   as_lineno_2=$LINENO as_lineno_2a=$LINENO
!   eval 'test "x$as_lineno_1'$as_run'" != "x$as_lineno_2'$as_run'" &&
!   test "x`expr $as_lineno_1'$as_run' + 1`" = "x$as_lineno_2'$as_run'"' || {
!   # Blame Lee E. McMahon (1931-1989) for sed's syntax.  :-)
    sed -n '
      p
      /[$]LINENO/=
***************
*** 445,452 ****
        s/-\n.*//
      ' >$as_me.lineno &&
    chmod +x "$as_me.lineno" ||
!     { echo "$as_me: error: cannot create $as_me.lineno; rerun with a POSIX shell" >&2
!    { (exit 1); exit 1; }; }
  
    # Don't try to exec as it changes $[0], causing all sort of problems
    # (the dirname of $[0] is not the place where we might find the
--- 439,445 ----
        s/-\n.*//
      ' >$as_me.lineno &&
    chmod +x "$as_me.lineno" ||
!     { $as_echo "$as_me: error: cannot create $as_me.lineno; rerun with a POSIX shell" >&2; as_fn_exit 1; }
  
    # Don't try to exec as it changes $[0], causing all sort of problems
    # (the dirname of $[0] is not the place where we might find the
***************
*** 456,504 ****
    exit
  }
  
- 
- if (as_dir=`dirname -- /` && test "X$as_dir" = X/) >/dev/null 2>&1; then
-   as_dirname=dirname
- else
-   as_dirname=false
- fi
- 
  ECHO_C= ECHO_N= ECHO_T=
! case `echo -n x` in
  -n*)
!   case `echo 'x\c'` in
    *c*) ECHO_T='	';;	# ECHO_T is single tab character.
!   *)   ECHO_C='\c';;
    esac;;
  *)
    ECHO_N='-n';;
  esac
  
- if expr a : '\(a\)' >/dev/null 2>&1 &&
-    test "X`expr 00001 : '.*\(...\)'`" = X001; then
-   as_expr=expr
- else
-   as_expr=false
- fi
- 
  rm -f conf$$ conf$$.exe conf$$.file
  if test -d conf$$.dir; then
    rm -f conf$$.dir/conf$$.file
  else
    rm -f conf$$.dir
!   mkdir conf$$.dir
  fi
! echo >conf$$.file
! if ln -s conf$$.file conf$$ 2>/dev/null; then
!   as_ln_s='ln -s'
!   # ... but there are two gotchas:
!   # 1) On MSYS, both `ln -s file dir' and `ln file dir' fail.
!   # 2) DJGPP < 2.04 has no symlinks; `ln -s' creates a wrapper executable.
!   # In both cases, we have to default to `cp -p'.
!   ln -s conf$$.file conf$$.dir 2>/dev/null && test ! -f conf$$.exe ||
      as_ln_s='cp -p'
! elif ln conf$$.file conf$$ 2>/dev/null; then
!   as_ln_s=ln
  else
    as_ln_s='cp -p'
  fi
--- 449,488 ----
    exit
  }
  
  ECHO_C= ECHO_N= ECHO_T=
! case `echo -n x` in #(((((
  -n*)
!   case `echo 'xy\c'` in
    *c*) ECHO_T='	';;	# ECHO_T is single tab character.
!   xy)  ECHO_C='\c';;
!   *)   echo `echo ksh88 bug on AIX 6.1` > /dev/null
!        ECHO_T='	';;
    esac;;
  *)
    ECHO_N='-n';;
  esac
  
  rm -f conf$$ conf$$.exe conf$$.file
  if test -d conf$$.dir; then
    rm -f conf$$.dir/conf$$.file
  else
    rm -f conf$$.dir
!   mkdir conf$$.dir 2>/dev/null
  fi
! if (echo >conf$$.file) 2>/dev/null; then
!   if ln -s conf$$.file conf$$ 2>/dev/null; then
!     as_ln_s='ln -s'
!     # ... but there are two gotchas:
!     # 1) On MSYS, both `ln -s file dir' and `ln file dir' fail.
!     # 2) DJGPP < 2.04 has no symlinks; `ln -s' creates a wrapper executable.
!     # In both cases, we have to default to `cp -p'.
!     ln -s conf$$.file conf$$.dir 2>/dev/null && test ! -f conf$$.exe ||
!       as_ln_s='cp -p'
!   elif ln conf$$.file conf$$ 2>/dev/null; then
!     as_ln_s=ln
!   else
      as_ln_s='cp -p'
!   fi
  else
    as_ln_s='cp -p'
  fi
***************
*** 506,530 ****
  rmdir conf$$.dir 2>/dev/null
  
  if mkdir -p . 2>/dev/null; then
!   as_mkdir_p=:
  else
    test -d ./-p && rmdir ./-p
    as_mkdir_p=false
  fi
  
! # Find out whether ``test -x'' works.  Don't use a zero-byte file, as
! # systems may use methods other than mode bits to determine executability.
! cat >conf$$.file <<_ASEOF
! #! /bin/sh
! exit 0
! _ASEOF
! chmod +x conf$$.file
! if test -x conf$$.file >/dev/null 2>&1; then
!   as_executable_p="test -x"
  else
!   as_executable_p=:
  fi
! rm -f conf$$.file
  
  # Sed expression to map a string onto a valid CPP name.
  as_tr_cpp="eval sed 'y%*$as_cr_letters%P$as_cr_LETTERS%;s%[^_$as_cr_alnum]%_%g'"
--- 490,523 ----
  rmdir conf$$.dir 2>/dev/null
  
  if mkdir -p . 2>/dev/null; then
!   as_mkdir_p='mkdir -p "$as_dir"'
  else
    test -d ./-p && rmdir ./-p
    as_mkdir_p=false
  fi
  
! if test -x / >/dev/null 2>&1; then
!   as_test_x='test -x'
  else
!   if ls -dL / >/dev/null 2>&1; then
!     as_ls_L_option=L
!   else
!     as_ls_L_option=
!   fi
!   as_test_x='
!     eval sh -c '\''
!       if test -d "$1"; then
! 	test -d "$1/.";
!       else
! 	case $1 in #(
! 	-*)set "./$1";;
! 	esac;
! 	case `ls -ld'$as_ls_L_option' "$1" 2>/dev/null` in #((
! 	???[sx]*):;;*)false;;esac;fi
!     '\'' sh
!   '
  fi
! as_executable_p=$as_test_x
  
  # Sed expression to map a string onto a valid CPP name.
  as_tr_cpp="eval sed 'y%*$as_cr_letters%P$as_cr_LETTERS%;s%[^_$as_cr_alnum]%_%g'"
***************
*** 533,540 ****
  as_tr_sh="eval sed 'y%*+%pp%;s%[^_$as_cr_alnum]%_%g'"
  
  
! 
! exec 7<&0 </dev/null 6>&1
  
  # Name of the host.
  # hostname on some systems (SVR3.2, Linux) returns a bogus exit status,
--- 526,533 ----
  as_tr_sh="eval sed 'y%*+%pp%;s%[^_$as_cr_alnum]%_%g'"
  
  
! test -n "$DJDIR" || exec 7<&0 </dev/null
! exec 6>&1
  
  # Name of the host.
  # hostname on some systems (SVR3.2, Linux) returns a bogus exit status,
***************
*** 552,558 ****
  subdirs=
  MFLAGS=
  MAKEFLAGS=
- SHELL=${CONFIG_SHELL-/bin/sh}
  
  # Identity of this package.
  PACKAGE_NAME='wwwoffle'
--- 545,550 ----
***************
*** 560,565 ****
--- 552,558 ----
  PACKAGE_VERSION='2.9'
  PACKAGE_STRING='wwwoffle 2.9'
  PACKAGE_BUGREPORT=''
+ PACKAGE_URL=''
  
  # Factoring default headers for most tests.
  ac_includes_default="\
***************
*** 597,691 ****
  # include <unistd.h>
  #endif"
  
! ac_subst_vars='SHELL
! PATH_SEPARATOR
! PACKAGE_NAME
! PACKAGE_TARNAME
! PACKAGE_VERSION
! PACKAGE_STRING
! PACKAGE_BUGREPORT
! exec_prefix
! prefix
! program_transform_name
! bindir
! sbindir
! libexecdir
! datarootdir
! datadir
! sysconfdir
! sharedstatedir
! localstatedir
! includedir
! oldincludedir
! docdir
! infodir
! htmldir
! dvidir
! pdfdir
! psdir
! libdir
! localedir
! mandir
! DEFS
! ECHO_C
! ECHO_N
! ECHO_T
! LIBS
! build_alias
! host_alias
! target_alias
! CC
! CFLAGS
! LDFLAGS
! CPPFLAGS
! ac_ct_CC
! EXEEXT
! OBJEXT
! LEX
! LEX_OUTPUT_ROOT
! LEXLIB
! INSTALL_PROGRAM
! INSTALL_SCRIPT
! INSTALL_DATA
! AWK
! SET_MAKE
! TAR
! PERL
! CPP
! GREP
! EGREP
! LIBOBJS
! ETR_SOCKET_LIBS
! ZLIB_LIB
! ZLIB_INC
! LIBGNUTLS_CONFIG
! GNUTLS_LIB
! GNUTLS_INC
! build
! build_cpu
! build_vendor
! build_os
! host
! host_cpu
! host_vendor
! host_os
! install_win32
! SPOOLDIR
! CONFDIR
! LOCALHOST
! HTTP_PORT
! HTTPS_PORT
! WWWOFFLE_PORT
! LANGUAGES
  DEFLANG
! LTLIBOBJS'
  ac_subst_files=''
        ac_precious_vars='build_alias
  host_alias
  target_alias
  CC
  CFLAGS
  LDFLAGS
  CPPFLAGS
  CPP'
  
--- 590,695 ----
  # include <unistd.h>
  #endif"
  
! ac_subst_vars='LTLIBOBJS
  DEFLANG
! LANGUAGES
! WWWOFFLE_PORT
! HTTPS_PORT
! HTTP_PORT
! LOCALHOST
! CONFDIR
! SPOOLDIR
! install_win32
! host_os
! host_vendor
! host_cpu
! host
! build_os
! build_vendor
! build_cpu
! build
! GNUTLS_INC
! GNUTLS_LIB
! ZLIB_INC
! ZLIB_LIB
! ETR_SOCKET_LIBS
! LIBOBJS
! EGREP
! GREP
! CPP
! PERL
! TAR
! SET_MAKE
! AWK
! INSTALL_DATA
! INSTALL_SCRIPT
! INSTALL_PROGRAM
! LEXLIB
! LEX_OUTPUT_ROOT
! LEX
! OBJEXT
! EXEEXT
! ac_ct_CC
! CPPFLAGS
! LDFLAGS
! CFLAGS
! CC
! target_alias
! host_alias
! build_alias
! LIBS
! ECHO_T
! ECHO_N
! ECHO_C
! DEFS
! mandir
! localedir
! libdir
! psdir
! pdfdir
! dvidir
! htmldir
! infodir
! docdir
! oldincludedir
! includedir
! localstatedir
! sharedstatedir
! sysconfdir
! datadir
! datarootdir
! libexecdir
! sbindir
! bindir
! program_transform_name
! prefix
! exec_prefix
! PACKAGE_URL
! PACKAGE_BUGREPORT
! PACKAGE_STRING
! PACKAGE_VERSION
! PACKAGE_TARNAME
! PACKAGE_NAME
! PATH_SEPARATOR
! SHELL'
  ac_subst_files=''
+ ac_user_opts='
+ enable_option_checking
+ with_zlib
+ with_gnutls
+ with_ipv6
+ with_spooldir
+ with_confdir
+ with_server
+ with_default_language
+ '
        ac_precious_vars='build_alias
  host_alias
  target_alias
  CC
  CFLAGS
  LDFLAGS
+ LIBS
  CPPFLAGS
  CPP'
  
***************
*** 693,698 ****
--- 697,704 ----
  # Initialize some variables set by options.
  ac_init_help=
  ac_init_version=false
+ ac_unrecognized_opts=
+ ac_unrecognized_sep=
  # The variables have the same names as the options, with
  # dashes changed to underlines.
  cache_file=/dev/null
***************
*** 791,803 ****
      datarootdir=$ac_optarg ;;
  
    -disable-* | --disable-*)
!     ac_feature=`expr "x$ac_option" : 'x-*disable-\(.*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_feature" : ".*[^-_$as_cr_alnum]" >/dev/null &&
!       { echo "$as_me: error: invalid feature name: $ac_feature" >&2
!    { (exit 1); exit 1; }; }
!     ac_feature=`echo $ac_feature | sed 's/-/_/g'`
!     eval enable_$ac_feature=no ;;
  
    -docdir | --docdir | --docdi | --doc | --do)
      ac_prev=docdir ;;
--- 797,816 ----
      datarootdir=$ac_optarg ;;
  
    -disable-* | --disable-*)
!     ac_useropt=`expr "x$ac_option" : 'x-*disable-\(.*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_useropt" : ".*[^-+._$as_cr_alnum]" >/dev/null &&
!       as_fn_error "invalid feature name: $ac_useropt"
!     ac_useropt_orig=$ac_useropt
!     ac_useropt=`$as_echo "$ac_useropt" | sed 's/[-+.]/_/g'`
!     case $ac_user_opts in
!       *"
! "enable_$ac_useropt"
! "*) ;;
!       *) ac_unrecognized_opts="$ac_unrecognized_opts$ac_unrecognized_sep--disable-$ac_useropt_orig"
! 	 ac_unrecognized_sep=', ';;
!     esac
!     eval enable_$ac_useropt=no ;;
  
    -docdir | --docdir | --docdi | --doc | --do)
      ac_prev=docdir ;;
***************
*** 810,822 ****
      dvidir=$ac_optarg ;;
  
    -enable-* | --enable-*)
!     ac_feature=`expr "x$ac_option" : 'x-*enable-\([^=]*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_feature" : ".*[^-_$as_cr_alnum]" >/dev/null &&
!       { echo "$as_me: error: invalid feature name: $ac_feature" >&2
!    { (exit 1); exit 1; }; }
!     ac_feature=`echo $ac_feature | sed 's/-/_/g'`
!     eval enable_$ac_feature=\$ac_optarg ;;
  
    -exec-prefix | --exec_prefix | --exec-prefix | --exec-prefi \
    | --exec-pref | --exec-pre | --exec-pr | --exec-p | --exec- \
--- 823,842 ----
      dvidir=$ac_optarg ;;
  
    -enable-* | --enable-*)
!     ac_useropt=`expr "x$ac_option" : 'x-*enable-\([^=]*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_useropt" : ".*[^-+._$as_cr_alnum]" >/dev/null &&
!       as_fn_error "invalid feature name: $ac_useropt"
!     ac_useropt_orig=$ac_useropt
!     ac_useropt=`$as_echo "$ac_useropt" | sed 's/[-+.]/_/g'`
!     case $ac_user_opts in
!       *"
! "enable_$ac_useropt"
! "*) ;;
!       *) ac_unrecognized_opts="$ac_unrecognized_opts$ac_unrecognized_sep--enable-$ac_useropt_orig"
! 	 ac_unrecognized_sep=', ';;
!     esac
!     eval enable_$ac_useropt=\$ac_optarg ;;
  
    -exec-prefix | --exec_prefix | --exec-prefix | --exec-prefi \
    | --exec-pref | --exec-pre | --exec-pr | --exec-p | --exec- \
***************
*** 1007,1028 ****
      ac_init_version=: ;;
  
    -with-* | --with-*)
!     ac_package=`expr "x$ac_option" : 'x-*with-\([^=]*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_package" : ".*[^-_$as_cr_alnum]" >/dev/null &&
!       { echo "$as_me: error: invalid package name: $ac_package" >&2
!    { (exit 1); exit 1; }; }
!     ac_package=`echo $ac_package| sed 's/-/_/g'`
!     eval with_$ac_package=\$ac_optarg ;;
  
    -without-* | --without-*)
!     ac_package=`expr "x$ac_option" : 'x-*without-\(.*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_package" : ".*[^-_$as_cr_alnum]" >/dev/null &&
!       { echo "$as_me: error: invalid package name: $ac_package" >&2
!    { (exit 1); exit 1; }; }
!     ac_package=`echo $ac_package | sed 's/-/_/g'`
!     eval with_$ac_package=no ;;
  
    --x)
      # Obsolete; use --with-x.
--- 1027,1062 ----
      ac_init_version=: ;;
  
    -with-* | --with-*)
!     ac_useropt=`expr "x$ac_option" : 'x-*with-\([^=]*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_useropt" : ".*[^-+._$as_cr_alnum]" >/dev/null &&
!       as_fn_error "invalid package name: $ac_useropt"
!     ac_useropt_orig=$ac_useropt
!     ac_useropt=`$as_echo "$ac_useropt" | sed 's/[-+.]/_/g'`
!     case $ac_user_opts in
!       *"
! "with_$ac_useropt"
! "*) ;;
!       *) ac_unrecognized_opts="$ac_unrecognized_opts$ac_unrecognized_sep--with-$ac_useropt_orig"
! 	 ac_unrecognized_sep=', ';;
!     esac
!     eval with_$ac_useropt=\$ac_optarg ;;
  
    -without-* | --without-*)
!     ac_useropt=`expr "x$ac_option" : 'x-*without-\(.*\)'`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_useropt" : ".*[^-+._$as_cr_alnum]" >/dev/null &&
!       as_fn_error "invalid package name: $ac_useropt"
!     ac_useropt_orig=$ac_useropt
!     ac_useropt=`$as_echo "$ac_useropt" | sed 's/[-+.]/_/g'`
!     case $ac_user_opts in
!       *"
! "with_$ac_useropt"
! "*) ;;
!       *) ac_unrecognized_opts="$ac_unrecognized_opts$ac_unrecognized_sep--without-$ac_useropt_orig"
! 	 ac_unrecognized_sep=', ';;
!     esac
!     eval with_$ac_useropt=no ;;
  
    --x)
      # Obsolete; use --with-x.
***************
*** 1042,1066 ****
    | --x-librar=* | --x-libra=* | --x-libr=* | --x-lib=* | --x-li=* | --x-l=*)
      x_libraries=$ac_optarg ;;
  
!   -*) { echo "$as_me: error: unrecognized option: $ac_option
! Try \`$0 --help' for more information." >&2
!    { (exit 1); exit 1; }; }
      ;;
  
    *=*)
      ac_envvar=`expr "x$ac_option" : 'x\([^=]*\)='`
      # Reject names that are not valid shell variable names.
!     expr "x$ac_envvar" : ".*[^_$as_cr_alnum]" >/dev/null &&
!       { echo "$as_me: error: invalid variable name: $ac_envvar" >&2
!    { (exit 1); exit 1; }; }
      eval $ac_envvar=\$ac_optarg
      export $ac_envvar ;;
  
    *)
      # FIXME: should be removed in autoconf 3.0.
!     echo "$as_me: WARNING: you should use --build, --host, --target" >&2
      expr "x$ac_option" : ".*[^-._$as_cr_alnum]" >/dev/null &&
!       echo "$as_me: WARNING: invalid host type: $ac_option" >&2
      : ${build_alias=$ac_option} ${host_alias=$ac_option} ${target_alias=$ac_option}
      ;;
  
--- 1076,1100 ----
    | --x-librar=* | --x-libra=* | --x-libr=* | --x-lib=* | --x-li=* | --x-l=*)
      x_libraries=$ac_optarg ;;
  
!   -*) as_fn_error "unrecognized option: \`$ac_option'
! Try \`$0 --help' for more information."
      ;;
  
    *=*)
      ac_envvar=`expr "x$ac_option" : 'x\([^=]*\)='`
      # Reject names that are not valid shell variable names.
!     case $ac_envvar in #(
!       '' | [0-9]* | *[!_$as_cr_alnum]* )
!       as_fn_error "invalid variable name: \`$ac_envvar'" ;;
!     esac
      eval $ac_envvar=\$ac_optarg
      export $ac_envvar ;;
  
    *)
      # FIXME: should be removed in autoconf 3.0.
!     $as_echo "$as_me: WARNING: you should use --build, --host, --target" >&2
      expr "x$ac_option" : ".*[^-._$as_cr_alnum]" >/dev/null &&
!       $as_echo "$as_me: WARNING: invalid host type: $ac_option" >&2
      : ${build_alias=$ac_option} ${host_alias=$ac_option} ${target_alias=$ac_option}
      ;;
  
***************
*** 1069,1091 ****
  
  if test -n "$ac_prev"; then
    ac_option=--`echo $ac_prev | sed 's/_/-/g'`
!   { echo "$as_me: error: missing argument to $ac_option" >&2
!    { (exit 1); exit 1; }; }
  fi
  
! # Be sure to have absolute directory names.
  for ac_var in	exec_prefix prefix bindir sbindir libexecdir datarootdir \
  		datadir sysconfdir sharedstatedir localstatedir includedir \
  		oldincludedir docdir infodir htmldir dvidir pdfdir psdir \
  		libdir localedir mandir
  do
    eval ac_val=\$$ac_var
    case $ac_val in
      [\\/$]* | ?:[\\/]* )  continue;;
      NONE | '' ) case $ac_var in *prefix ) continue;; esac;;
    esac
!   { echo "$as_me: error: expected an absolute directory name for --$ac_var: $ac_val" >&2
!    { (exit 1); exit 1; }; }
  done
  
  # There might be people who depend on the old broken behavior: `$host'
--- 1103,1138 ----
  
  if test -n "$ac_prev"; then
    ac_option=--`echo $ac_prev | sed 's/_/-/g'`
!   as_fn_error "missing argument to $ac_option"
! fi
! 
! if test -n "$ac_unrecognized_opts"; then
!   case $enable_option_checking in
!     no) ;;
!     fatal) as_fn_error "unrecognized options: $ac_unrecognized_opts" ;;
!     *)     $as_echo "$as_me: WARNING: unrecognized options: $ac_unrecognized_opts" >&2 ;;
!   esac
  fi
  
! # Check all directory arguments for consistency.
  for ac_var in	exec_prefix prefix bindir sbindir libexecdir datarootdir \
  		datadir sysconfdir sharedstatedir localstatedir includedir \
  		oldincludedir docdir infodir htmldir dvidir pdfdir psdir \
  		libdir localedir mandir
  do
    eval ac_val=\$$ac_var
+   # Remove trailing slashes.
+   case $ac_val in
+     */ )
+       ac_val=`expr "X$ac_val" : 'X\(.*[^/]\)' \| "X$ac_val" : 'X\(.*\)'`
+       eval $ac_var=\$ac_val;;
+   esac
+   # Be sure to have absolute directory names.
    case $ac_val in
      [\\/$]* | ?:[\\/]* )  continue;;
      NONE | '' ) case $ac_var in *prefix ) continue;; esac;;
    esac
!   as_fn_error "expected an absolute directory name for --$ac_var: $ac_val"
  done
  
  # There might be people who depend on the old broken behavior: `$host'
***************
*** 1099,1105 ****
  if test "x$host_alias" != x; then
    if test "x$build_alias" = x; then
      cross_compiling=maybe
!     echo "$as_me: WARNING: If you wanted to set the --build type, don't use --host.
      If a cross compiler is detected then cross compile mode will be used." >&2
    elif test "x$build_alias" != "x$host_alias"; then
      cross_compiling=yes
--- 1146,1152 ----
  if test "x$host_alias" != x; then
    if test "x$build_alias" = x; then
      cross_compiling=maybe
!     $as_echo "$as_me: WARNING: If you wanted to set the --build type, don't use --host.
      If a cross compiler is detected then cross compile mode will be used." >&2
    elif test "x$build_alias" != "x$host_alias"; then
      cross_compiling=yes
***************
*** 1115,1137 ****
  ac_pwd=`pwd` && test -n "$ac_pwd" &&
  ac_ls_di=`ls -di .` &&
  ac_pwd_ls_di=`cd "$ac_pwd" && ls -di .` ||
!   { echo "$as_me: error: Working directory cannot be determined" >&2
!    { (exit 1); exit 1; }; }
  test "X$ac_ls_di" = "X$ac_pwd_ls_di" ||
!   { echo "$as_me: error: pwd does not report name of working directory" >&2
!    { (exit 1); exit 1; }; }
  
  
  # Find the source files, if location was not specified.
  if test -z "$srcdir"; then
    ac_srcdir_defaulted=yes
    # Try the directory containing this script, then the parent directory.
!   ac_confdir=`$as_dirname -- "$0" ||
! $as_expr X"$0" : 'X\(.*[^/]\)//*[^/][^/]*/*$' \| \
! 	 X"$0" : 'X\(//\)[^/]' \| \
! 	 X"$0" : 'X\(//\)$' \| \
! 	 X"$0" : 'X\(/\)' \| . 2>/dev/null ||
! echo X"$0" |
      sed '/^X\(.*[^/]\)\/\/*[^/][^/]*\/*$/{
  	    s//\1/
  	    q
--- 1162,1182 ----
  ac_pwd=`pwd` && test -n "$ac_pwd" &&
  ac_ls_di=`ls -di .` &&
  ac_pwd_ls_di=`cd "$ac_pwd" && ls -di .` ||
!   as_fn_error "working directory cannot be determined"
  test "X$ac_ls_di" = "X$ac_pwd_ls_di" ||
!   as_fn_error "pwd does not report name of working directory"
  
  
  # Find the source files, if location was not specified.
  if test -z "$srcdir"; then
    ac_srcdir_defaulted=yes
    # Try the directory containing this script, then the parent directory.
!   ac_confdir=`$as_dirname -- "$as_myself" ||
! $as_expr X"$as_myself" : 'X\(.*[^/]\)//*[^/][^/]*/*$' \| \
! 	 X"$as_myself" : 'X\(//\)[^/]' \| \
! 	 X"$as_myself" : 'X\(//\)$' \| \
! 	 X"$as_myself" : 'X\(/\)' \| . 2>/dev/null ||
! $as_echo X"$as_myself" |
      sed '/^X\(.*[^/]\)\/\/*[^/][^/]*\/*$/{
  	    s//\1/
  	    q
***************
*** 1158,1170 ****
  fi
  if test ! -r "$srcdir/$ac_unique_file"; then
    test "$ac_srcdir_defaulted" = yes && srcdir="$ac_confdir or .."
!   { echo "$as_me: error: cannot find sources ($ac_unique_file) in $srcdir" >&2
!    { (exit 1); exit 1; }; }
  fi
  ac_msg="sources are in $srcdir, but \`cd $srcdir' does not work"
  ac_abs_confdir=`(
! 	cd "$srcdir" && test -r "./$ac_unique_file" || { echo "$as_me: error: $ac_msg" >&2
!    { (exit 1); exit 1; }; }
  	pwd)`
  # When building in place, set srcdir=.
  if test "$ac_abs_confdir" = "$ac_pwd"; then
--- 1203,1213 ----
  fi
  if test ! -r "$srcdir/$ac_unique_file"; then
    test "$ac_srcdir_defaulted" = yes && srcdir="$ac_confdir or .."
!   as_fn_error "cannot find sources ($ac_unique_file) in $srcdir"
  fi
  ac_msg="sources are in $srcdir, but \`cd $srcdir' does not work"
  ac_abs_confdir=`(
! 	cd "$srcdir" && test -r "./$ac_unique_file" || as_fn_error "$ac_msg"
  	pwd)`
  # When building in place, set srcdir=.
  if test "$ac_abs_confdir" = "$ac_pwd"; then
***************
*** 1212,1220 ****
  
  Installation directories:
    --prefix=PREFIX         install architecture-independent files in PREFIX
! 			  [$ac_default_prefix]
    --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
! 			  [PREFIX]
  
  By default, \`make install' will install all the files in
  \`$ac_default_prefix/bin', \`$ac_default_prefix/lib' etc.  You can specify
--- 1255,1263 ----
  
  Installation directories:
    --prefix=PREFIX         install architecture-independent files in PREFIX
!                           [$ac_default_prefix]
    --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
!                           [PREFIX]
  
  By default, \`make install' will install all the files in
  \`$ac_default_prefix/bin', \`$ac_default_prefix/lib' etc.  You can specify
***************
*** 1224,1248 ****
  For better control, use the options below.
  
  Fine tuning of the installation directories:
!   --bindir=DIR           user executables [EPREFIX/bin]
!   --sbindir=DIR          system admin executables [EPREFIX/sbin]
!   --libexecdir=DIR       program executables [EPREFIX/libexec]
!   --sysconfdir=DIR       read-only single-machine data [PREFIX/etc]
!   --sharedstatedir=DIR   modifiable architecture-independent data [PREFIX/com]
!   --localstatedir=DIR    modifiable single-machine data [PREFIX/var]
!   --libdir=DIR           object code libraries [EPREFIX/lib]
!   --includedir=DIR       C header files [PREFIX/include]
!   --oldincludedir=DIR    C header files for non-gcc [/usr/include]
!   --datarootdir=DIR      read-only arch.-independent data root [PREFIX/share]
!   --datadir=DIR          read-only architecture-independent data [DATAROOTDIR]
!   --infodir=DIR          info documentation [DATAROOTDIR/info]
!   --localedir=DIR        locale-dependent data [DATAROOTDIR/locale]
!   --mandir=DIR           man documentation [DATAROOTDIR/man]
!   --docdir=DIR           documentation root [DATAROOTDIR/doc/wwwoffle]
!   --htmldir=DIR          html documentation [DOCDIR]
!   --dvidir=DIR           dvi documentation [DOCDIR]
!   --pdfdir=DIR           pdf documentation [DOCDIR]
!   --psdir=DIR            ps documentation [DOCDIR]
  _ACEOF
  
    cat <<\_ACEOF
--- 1267,1291 ----
  For better control, use the options below.
  
  Fine tuning of the installation directories:
!   --bindir=DIR            user executables [EPREFIX/bin]
!   --sbindir=DIR           system admin executables [EPREFIX/sbin]
!   --libexecdir=DIR        program executables [EPREFIX/libexec]
!   --sysconfdir=DIR        read-only single-machine data [PREFIX/etc]
!   --sharedstatedir=DIR    modifiable architecture-independent data [PREFIX/com]
!   --localstatedir=DIR     modifiable single-machine data [PREFIX/var]
!   --libdir=DIR            object code libraries [EPREFIX/lib]
!   --includedir=DIR        C header files [PREFIX/include]
!   --oldincludedir=DIR     C header files for non-gcc [/usr/include]
!   --datarootdir=DIR       read-only arch.-independent data root [PREFIX/share]
!   --datadir=DIR           read-only architecture-independent data [DATAROOTDIR]
!   --infodir=DIR           info documentation [DATAROOTDIR/info]
!   --localedir=DIR         locale-dependent data [DATAROOTDIR/locale]
!   --mandir=DIR            man documentation [DATAROOTDIR/man]
!   --docdir=DIR            documentation root [DATAROOTDIR/doc/wwwoffle]
!   --htmldir=DIR           html documentation [DOCDIR]
!   --dvidir=DIR            dvi documentation [DOCDIR]
!   --pdfdir=DIR            pdf documentation [DOCDIR]
!   --psdir=DIR             ps documentation [DOCDIR]
  _ACEOF
  
    cat <<\_ACEOF
***************
*** 1275,1287 ****
    CFLAGS      C compiler flags
    LDFLAGS     linker flags, e.g. -L<lib dir> if you have libraries in a
                nonstandard directory <lib dir>
!   CPPFLAGS    C/C++/Objective C preprocessor flags, e.g. -I<include dir> if
                you have headers in a nonstandard directory <include dir>
    CPP         C preprocessor
  
  Use these variables to override the choices made by `configure' or to help
  it to find libraries and programs with nonstandard names/locations.
  
  _ACEOF
  ac_status=$?
  fi
--- 1318,1332 ----
    CFLAGS      C compiler flags
    LDFLAGS     linker flags, e.g. -L<lib dir> if you have libraries in a
                nonstandard directory <lib dir>
!   LIBS        libraries to pass to the linker, e.g. -l<library>
!   CPPFLAGS    (Objective) C/C++ preprocessor flags, e.g. -I<include dir> if
                you have headers in a nonstandard directory <include dir>
    CPP         C preprocessor
  
  Use these variables to override the choices made by `configure' or to help
  it to find libraries and programs with nonstandard names/locations.
  
+ Report bugs to the package provider.
  _ACEOF
  ac_status=$?
  fi
***************
*** 1289,1303 ****
  if test "$ac_init_help" = "recursive"; then
    # If there are subdirs, report their specific --help.
    for ac_dir in : $ac_subdirs_all; do test "x$ac_dir" = x: && continue
!     test -d "$ac_dir" || continue
      ac_builddir=.
  
  case "$ac_dir" in
  .) ac_dir_suffix= ac_top_builddir_sub=. ac_top_build_prefix= ;;
  *)
!   ac_dir_suffix=/`echo "$ac_dir" | sed 's,^\.[\\/],,'`
    # A ".." for each directory in $ac_dir_suffix.
!   ac_top_builddir_sub=`echo "$ac_dir_suffix" | sed 's,/[^\\/]*,/..,g;s,/,,'`
    case $ac_top_builddir_sub in
    "") ac_top_builddir_sub=. ac_top_build_prefix= ;;
    *)  ac_top_build_prefix=$ac_top_builddir_sub/ ;;
--- 1334,1350 ----
  if test "$ac_init_help" = "recursive"; then
    # If there are subdirs, report their specific --help.
    for ac_dir in : $ac_subdirs_all; do test "x$ac_dir" = x: && continue
!     test -d "$ac_dir" ||
!       { cd "$srcdir" && ac_pwd=`pwd` && srcdir=. && test -d "$ac_dir"; } ||
!       continue
      ac_builddir=.
  
  case "$ac_dir" in
  .) ac_dir_suffix= ac_top_builddir_sub=. ac_top_build_prefix= ;;
  *)
!   ac_dir_suffix=/`$as_echo "$ac_dir" | sed 's|^\.[\\/]||'`
    # A ".." for each directory in $ac_dir_suffix.
!   ac_top_builddir_sub=`$as_echo "$ac_dir_suffix" | sed 's|/[^\\/]*|/..|g;s|/||'`
    case $ac_top_builddir_sub in
    "") ac_top_builddir_sub=. ac_top_build_prefix= ;;
    *)  ac_top_build_prefix=$ac_top_builddir_sub/ ;;
***************
*** 1333,1339 ****
        echo &&
        $SHELL "$ac_srcdir/configure" --help=recursive
      else
!       echo "$as_me: WARNING: no configuration information is in $ac_dir" >&2
      fi || ac_status=$?
      cd "$ac_pwd" || { ac_status=$?; break; }
    done
--- 1380,1386 ----
        echo &&
        $SHELL "$ac_srcdir/configure" --help=recursive
      else
!       $as_echo "$as_me: WARNING: no configuration information is in $ac_dir" >&2
      fi || ac_status=$?
      cd "$ac_pwd" || { ac_status=$?; break; }
    done
***************
*** 1343,1403 ****
  if $ac_init_version; then
    cat <<\_ACEOF
  wwwoffle configure 2.9
! generated by GNU Autoconf 2.60a
  
! Copyright (C) 1992, 1993, 1994, 1995, 1996, 1998, 1999, 2000, 2001,
! 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
  This configure script is free software; the Free Software Foundation
  gives unlimited permission to copy, distribute and modify it.
  _ACEOF
    exit
  fi
- cat >config.log <<_ACEOF
- This file contains any messages produced by compilers while
- running configure, to aid debugging if configure makes a mistake.
  
! It was created by wwwoffle $as_me 2.9, which was
! generated by GNU Autoconf 2.60a.  Invocation command line was
! 
!   $ $0 $@
! 
! _ACEOF
! exec 5>>config.log
  {
! cat <<_ASUNAME
! ## --------- ##
! ## Platform. ##
! ## --------- ##
  
! hostname = `(hostname || uname -n) 2>/dev/null | sed 1q`
! uname -m = `(uname -m) 2>/dev/null || echo unknown`
! uname -r = `(uname -r) 2>/dev/null || echo unknown`
! uname -s = `(uname -s) 2>/dev/null || echo unknown`
! uname -v = `(uname -v) 2>/dev/null || echo unknown`
  
! /usr/bin/uname -p = `(/usr/bin/uname -p) 2>/dev/null || echo unknown`
! /bin/uname -X     = `(/bin/uname -X) 2>/dev/null     || echo unknown`
  
! /bin/arch              = `(/bin/arch) 2>/dev/null              || echo unknown`
! /usr/bin/arch -k       = `(/usr/bin/arch -k) 2>/dev/null       || echo unknown`
! /usr/convex/getsysinfo = `(/usr/convex/getsysinfo) 2>/dev/null || echo unknown`
! /usr/bin/hostinfo      = `(/usr/bin/hostinfo) 2>/dev/null      || echo unknown`
! /bin/machine           = `(/bin/machine) 2>/dev/null           || echo unknown`
! /usr/bin/oslevel       = `(/usr/bin/oslevel) 2>/dev/null       || echo unknown`
! /bin/universe          = `(/bin/universe) 2>/dev/null          || echo unknown`
  
! _ASUNAME
  
! as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
! for as_dir in $PATH
! do
!   IFS=$as_save_IFS
!   test -z "$as_dir" && as_dir=.
!   echo "PATH: $as_dir"
! done
! IFS=$as_save_IFS
  
! } >&5
  
  cat >&5 <<_ACEOF
  
--- 1390,1897 ----
  if $ac_init_version; then
    cat <<\_ACEOF
  wwwoffle configure 2.9
! generated by GNU Autoconf 2.65
  
! Copyright (C) 2009 Free Software Foundation, Inc.
  This configure script is free software; the Free Software Foundation
  gives unlimited permission to copy, distribute and modify it.
  _ACEOF
    exit
  fi
  
! ## ------------------------ ##
! ## Autoconf initialization. ##
! ## ------------------------ ##
! 
! # ac_fn_c_try_compile LINENO
! # --------------------------
! # Try to compile conftest.$ac_ext, and return whether this succeeded.
! ac_fn_c_try_compile ()
  {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   rm -f conftest.$ac_objext
!   if { { ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_compile") 2>conftest.err
!   ac_status=$?
!   if test -s conftest.err; then
!     grep -v '^ *+' conftest.err >conftest.er1
!     cat conftest.er1 >&5
!     mv -f conftest.er1 conftest.err
!   fi
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; } && {
! 	 test -z "$ac_c_werror_flag" ||
! 	 test ! -s conftest.err
!        } && test -s conftest.$ac_objext; then :
!   ac_retval=0
! else
!   $as_echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
! 	ac_retval=1
! fi
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
!   as_fn_set_status $ac_retval
  
! } # ac_fn_c_try_compile
  
! # ac_fn_c_try_link LINENO
! # -----------------------
! # Try to link conftest.$ac_ext, and return whether this succeeded.
! ac_fn_c_try_link ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   rm -f conftest.$ac_objext conftest$ac_exeext
!   if { { ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_link") 2>conftest.err
!   ac_status=$?
!   if test -s conftest.err; then
!     grep -v '^ *+' conftest.err >conftest.er1
!     cat conftest.er1 >&5
!     mv -f conftest.er1 conftest.err
!   fi
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; } && {
! 	 test -z "$ac_c_werror_flag" ||
! 	 test ! -s conftest.err
!        } && test -s conftest$ac_exeext && {
! 	 test "$cross_compiling" = yes ||
! 	 $as_test_x conftest$ac_exeext
!        }; then :
!   ac_retval=0
! else
!   $as_echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
! 	ac_retval=1
! fi
!   # Delete the IPA/IPO (Inter Procedural Analysis/Optimization) information
!   # created by the PGI compiler (conftest_ipa8_conftest.oo), as it would
!   # interfere with the next link command; also delete a directory that is
!   # left behind by Apple's compiler.  We do this before executing the actions.
!   rm -rf conftest.dSYM conftest_ipa8_conftest.oo
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
!   as_fn_set_status $ac_retval
! 
! } # ac_fn_c_try_link
! 
! # ac_fn_c_try_cpp LINENO
! # ----------------------
! # Try to preprocess conftest.$ac_ext, and return whether this succeeded.
! ac_fn_c_try_cpp ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   if { { ac_try="$ac_cpp conftest.$ac_ext"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_cpp conftest.$ac_ext") 2>conftest.err
!   ac_status=$?
!   if test -s conftest.err; then
!     grep -v '^ *+' conftest.err >conftest.er1
!     cat conftest.er1 >&5
!     mv -f conftest.er1 conftest.err
!   fi
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; } >/dev/null && {
! 	 test -z "$ac_c_preproc_warn_flag$ac_c_werror_flag" ||
! 	 test ! -s conftest.err
!        }; then :
!   ac_retval=0
! else
!   $as_echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
!     ac_retval=1
! fi
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
!   as_fn_set_status $ac_retval
  
! } # ac_fn_c_try_cpp
! 
! # ac_fn_c_try_run LINENO
! # ----------------------
! # Try to link conftest.$ac_ext, and return whether this succeeded. Assumes
! # that executables *can* be run.
! ac_fn_c_try_run ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   if { { ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_link") 2>&5
!   ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; } && { ac_try='./conftest$ac_exeext'
!   { { case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }; }; then :
!   ac_retval=0
! else
!   $as_echo "$as_me: program exited with status $ac_status" >&5
!        $as_echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
!        ac_retval=$ac_status
! fi
!   rm -rf conftest.dSYM conftest_ipa8_conftest.oo
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
!   as_fn_set_status $ac_retval
! 
! } # ac_fn_c_try_run
! 
! # ac_fn_c_check_header_mongrel LINENO HEADER VAR INCLUDES
! # -------------------------------------------------------
! # Tests whether HEADER exists, giving a warning if it cannot be compiled using
! # the include files in INCLUDES and setting the cache variable VAR
! # accordingly.
! ac_fn_c_check_header_mongrel ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   if { as_var=$3; eval "test \"\${$as_var+set}\" = set"; }; then :
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $2" >&5
! $as_echo_n "checking for $2... " >&6; }
! if { as_var=$3; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
! fi
! eval ac_res=\$$3
! 	       { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_res" >&5
! $as_echo "$ac_res" >&6; }
! else
!   # Is the header compilable?
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking $2 usability" >&5
! $as_echo_n "checking $2 usability... " >&6; }
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! $4
! #include <$2>
! _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
!   ac_header_compiler=yes
! else
!   ac_header_compiler=no
! fi
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_header_compiler" >&5
! $as_echo "$ac_header_compiler" >&6; }
! 
! # Is the header present?
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking $2 presence" >&5
! $as_echo_n "checking $2 presence... " >&6; }
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! #include <$2>
! _ACEOF
! if ac_fn_c_try_cpp "$LINENO"; then :
!   ac_header_preproc=yes
! else
!   ac_header_preproc=no
! fi
! rm -f conftest.err conftest.$ac_ext
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_header_preproc" >&5
! $as_echo "$ac_header_preproc" >&6; }
! 
! # So?  What about this header?
! case $ac_header_compiler:$ac_header_preproc:$ac_c_preproc_warn_flag in #((
!   yes:no: )
!     { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $2: accepted by the compiler, rejected by the preprocessor!" >&5
! $as_echo "$as_me: WARNING: $2: accepted by the compiler, rejected by the preprocessor!" >&2;}
!     { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $2: proceeding with the compiler's result" >&5
! $as_echo "$as_me: WARNING: $2: proceeding with the compiler's result" >&2;}
!     ;;
!   no:yes:* )
!     { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $2: present but cannot be compiled" >&5
! $as_echo "$as_me: WARNING: $2: present but cannot be compiled" >&2;}
!     { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $2:     check for missing prerequisite headers?" >&5
! $as_echo "$as_me: WARNING: $2:     check for missing prerequisite headers?" >&2;}
!     { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $2: see the Autoconf documentation" >&5
! $as_echo "$as_me: WARNING: $2: see the Autoconf documentation" >&2;}
!     { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $2:     section \"Present But Cannot Be Compiled\"" >&5
! $as_echo "$as_me: WARNING: $2:     section \"Present But Cannot Be Compiled\"" >&2;}
!     { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $2: proceeding with the compiler's result" >&5
! $as_echo "$as_me: WARNING: $2: proceeding with the compiler's result" >&2;}
!     ;;
! esac
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $2" >&5
! $as_echo_n "checking for $2... " >&6; }
! if { as_var=$3; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
! else
!   eval "$3=\$ac_header_compiler"
! fi
! eval ac_res=\$$3
! 	       { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_res" >&5
! $as_echo "$ac_res" >&6; }
! fi
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
! 
! } # ac_fn_c_check_header_mongrel
! 
! # ac_fn_c_check_header_compile LINENO HEADER VAR INCLUDES
! # -------------------------------------------------------
! # Tests whether HEADER exists and can be compiled using the include files in
! # INCLUDES, setting the cache variable VAR accordingly.
! ac_fn_c_check_header_compile ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $2" >&5
! $as_echo_n "checking for $2... " >&6; }
! if { as_var=$3; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
! else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! $4
! #include <$2>
! _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
!   eval "$3=yes"
! else
!   eval "$3=no"
! fi
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! eval ac_res=\$$3
! 	       { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_res" >&5
! $as_echo "$ac_res" >&6; }
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
! 
! } # ac_fn_c_check_header_compile
! 
! # ac_fn_c_check_member LINENO AGGR MEMBER VAR INCLUDES
! # ----------------------------------------------------
! # Tries to find if the field MEMBER exists in type AGGR, after including
! # INCLUDES, setting cache variable VAR accordingly.
! ac_fn_c_check_member ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $2.$3" >&5
! $as_echo_n "checking for $2.$3... " >&6; }
! if { as_var=$4; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
! else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! $5
! int
! main ()
! {
! static $2 ac_aggr;
! if (ac_aggr.$3)
! return 0;
!   ;
!   return 0;
! }
! _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
!   eval "$4=yes"
! else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! $5
! int
! main ()
! {
! static $2 ac_aggr;
! if (sizeof ac_aggr.$3)
! return 0;
!   ;
!   return 0;
! }
! _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
!   eval "$4=yes"
! else
!   eval "$4=no"
! fi
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! eval ac_res=\$$4
! 	       { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_res" >&5
! $as_echo "$ac_res" >&6; }
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
! 
! } # ac_fn_c_check_member
! 
! # ac_fn_c_check_decl LINENO SYMBOL VAR
! # ------------------------------------
! # Tests whether SYMBOL is declared, setting cache variable VAR accordingly.
! ac_fn_c_check_decl ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether $2 is declared" >&5
! $as_echo_n "checking whether $2 is declared... " >&6; }
! if { as_var=$3; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
! else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! $4
! int
! main ()
! {
! #ifndef $2
!   (void) $2;
! #endif
! 
!   ;
!   return 0;
! }
! _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
!   eval "$3=yes"
! else
!   eval "$3=no"
! fi
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! eval ac_res=\$$3
! 	       { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_res" >&5
! $as_echo "$ac_res" >&6; }
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
! 
! } # ac_fn_c_check_decl
! 
! # ac_fn_c_check_func LINENO FUNC VAR
! # ----------------------------------
! # Tests whether FUNC exists, setting the cache variable VAR accordingly
! ac_fn_c_check_func ()
! {
!   as_lineno=${as_lineno-"$1"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $2" >&5
! $as_echo_n "checking for $2... " >&6; }
! if { as_var=$3; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
! else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! /* Define $2 to an innocuous variant, in case <limits.h> declares $2.
!    For example, HP-UX 11i <limits.h> declares gettimeofday.  */
! #define $2 innocuous_$2
! 
! /* System header to define __stub macros and hopefully few prototypes,
!     which can conflict with char $2 (); below.
!     Prefer <limits.h> to <assert.h> if __STDC__ is defined, since
!     <limits.h> exists even on freestanding compilers.  */
! 
! #ifdef __STDC__
! # include <limits.h>
! #else
! # include <assert.h>
! #endif
! 
! #undef $2
! 
! /* Override any GCC internal prototype to avoid an error.
!    Use char because int might match the return type of a GCC
!    builtin and then its argument prototype would still apply.  */
! #ifdef __cplusplus
! extern "C"
! #endif
! char $2 ();
! /* The GNU C library defines this for functions which it implements
!     to always fail with ENOSYS.  Some functions are actually named
!     something starting with __ and the normal name is an alias.  */
! #if defined __stub_$2 || defined __stub___$2
! choke me
! #endif
! 
! int
! main ()
! {
! return $2 ();
!   ;
!   return 0;
! }
! _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
!   eval "$3=yes"
! else
!   eval "$3=no"
! fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
! fi
! eval ac_res=\$$3
! 	       { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_res" >&5
! $as_echo "$ac_res" >&6; }
!   eval $as_lineno_stack; test "x$as_lineno_stack" = x && { as_lineno=; unset as_lineno;}
! 
! } # ac_fn_c_check_func
! cat >config.log <<_ACEOF
! This file contains any messages produced by compilers while
! running configure, to aid debugging if configure makes a mistake.
! 
! It was created by wwwoffle $as_me 2.9, which was
! generated by GNU Autoconf 2.65.  Invocation command line was
! 
!   $ $0 $@
! 
! _ACEOF
! exec 5>>config.log
! {
! cat <<_ASUNAME
! ## --------- ##
! ## Platform. ##
! ## --------- ##
! 
! hostname = `(hostname || uname -n) 2>/dev/null | sed 1q`
! uname -m = `(uname -m) 2>/dev/null || echo unknown`
! uname -r = `(uname -r) 2>/dev/null || echo unknown`
! uname -s = `(uname -s) 2>/dev/null || echo unknown`
! uname -v = `(uname -v) 2>/dev/null || echo unknown`
! 
! /usr/bin/uname -p = `(/usr/bin/uname -p) 2>/dev/null || echo unknown`
! /bin/uname -X     = `(/bin/uname -X) 2>/dev/null     || echo unknown`
! 
! /bin/arch              = `(/bin/arch) 2>/dev/null              || echo unknown`
! /usr/bin/arch -k       = `(/usr/bin/arch -k) 2>/dev/null       || echo unknown`
! /usr/convex/getsysinfo = `(/usr/convex/getsysinfo) 2>/dev/null || echo unknown`
! /usr/bin/hostinfo      = `(/usr/bin/hostinfo) 2>/dev/null      || echo unknown`
! /bin/machine           = `(/bin/machine) 2>/dev/null           || echo unknown`
! /usr/bin/oslevel       = `(/usr/bin/oslevel) 2>/dev/null       || echo unknown`
! /bin/universe          = `(/bin/universe) 2>/dev/null          || echo unknown`
! 
! _ASUNAME
! 
! as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
! for as_dir in $PATH
! do
!   IFS=$as_save_IFS
!   test -z "$as_dir" && as_dir=.
!     $as_echo "PATH: $as_dir"
!   done
! IFS=$as_save_IFS
! 
! } >&5
  
  cat >&5 <<_ACEOF
  
***************
*** 1428,1439 ****
      | -silent | --silent | --silen | --sile | --sil)
        continue ;;
      *\'*)
!       ac_arg=`echo "$ac_arg" | sed "s/'/'\\\\\\\\''/g"` ;;
      esac
      case $ac_pass in
!     1) ac_configure_args0="$ac_configure_args0 '$ac_arg'" ;;
      2)
!       ac_configure_args1="$ac_configure_args1 '$ac_arg'"
        if test $ac_must_keep_next = true; then
  	ac_must_keep_next=false # Got value, back to normal.
        else
--- 1922,1933 ----
      | -silent | --silent | --silen | --sile | --sil)
        continue ;;
      *\'*)
!       ac_arg=`$as_echo "$ac_arg" | sed "s/'/'\\\\\\\\''/g"` ;;
      esac
      case $ac_pass in
!     1) as_fn_append ac_configure_args0 " '$ac_arg'" ;;
      2)
!       as_fn_append ac_configure_args1 " '$ac_arg'"
        if test $ac_must_keep_next = true; then
  	ac_must_keep_next=false # Got value, back to normal.
        else
***************
*** 1449,1461 ****
  	  -* ) ac_must_keep_next=true ;;
  	esac
        fi
!       ac_configure_args="$ac_configure_args '$ac_arg'"
        ;;
      esac
    done
  done
! $as_unset ac_configure_args0 || test "${ac_configure_args0+set}" != set || { ac_configure_args0=; export ac_configure_args0; }
! $as_unset ac_configure_args1 || test "${ac_configure_args1+set}" != set || { ac_configure_args1=; export ac_configure_args1; }
  
  # When interrupted or exit'd, cleanup temporary files, and complete
  # config.log.  We remove comments because anyway the quotes in there
--- 1943,1955 ----
  	  -* ) ac_must_keep_next=true ;;
  	esac
        fi
!       as_fn_append ac_configure_args " '$ac_arg'"
        ;;
      esac
    done
  done
! { ac_configure_args0=; unset ac_configure_args0;}
! { ac_configure_args1=; unset ac_configure_args1;}
  
  # When interrupted or exit'd, cleanup temporary files, and complete
  # config.log.  We remove comments because anyway the quotes in there
***************
*** 1480,1491 ****
      case $ac_val in #(
      *${as_nl}*)
        case $ac_var in #(
!       *_cv_*) { echo "$as_me:$LINENO: WARNING: Cache variable $ac_var contains a newline." >&5
! echo "$as_me: WARNING: Cache variable $ac_var contains a newline." >&2;} ;;
        esac
        case $ac_var in #(
        _ | IFS | as_nl) ;; #(
!       *) $as_unset $ac_var ;;
        esac ;;
      esac
    done
--- 1974,1986 ----
      case $ac_val in #(
      *${as_nl}*)
        case $ac_var in #(
!       *_cv_*) { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: cache variable $ac_var contains a newline" >&5
! $as_echo "$as_me: WARNING: cache variable $ac_var contains a newline" >&2;} ;;
        esac
        case $ac_var in #(
        _ | IFS | as_nl) ;; #(
!       BASH_ARGV | BASH_SOURCE) eval $ac_var= ;; #(
!       *) { eval $ac_var=; unset $ac_var;} ;;
        esac ;;
      esac
    done
***************
*** 1514,1522 ****
      do
        eval ac_val=\$$ac_var
        case $ac_val in
!       *\'\''*) ac_val=`echo "$ac_val" | sed "s/'\''/'\''\\\\\\\\'\'''\''/g"`;;
        esac
!       echo "$ac_var='\''$ac_val'\''"
      done | sort
      echo
  
--- 2009,2017 ----
      do
        eval ac_val=\$$ac_var
        case $ac_val in
!       *\'\''*) ac_val=`$as_echo "$ac_val" | sed "s/'\''/'\''\\\\\\\\'\'''\''/g"`;;
        esac
!       $as_echo "$ac_var='\''$ac_val'\''"
      done | sort
      echo
  
***************
*** 1531,1539 ****
        do
  	eval ac_val=\$$ac_var
  	case $ac_val in
! 	*\'\''*) ac_val=`echo "$ac_val" | sed "s/'\''/'\''\\\\\\\\'\'''\''/g"`;;
  	esac
! 	echo "$ac_var='\''$ac_val'\''"
        done | sort
        echo
      fi
--- 2026,2034 ----
        do
  	eval ac_val=\$$ac_var
  	case $ac_val in
! 	*\'\''*) ac_val=`$as_echo "$ac_val" | sed "s/'\''/'\''\\\\\\\\'\'''\''/g"`;;
  	esac
! 	$as_echo "$ac_var='\''$ac_val'\''"
        done | sort
        echo
      fi
***************
*** 1549,1631 ****
        echo
      fi
      test "$ac_signal" != 0 &&
!       echo "$as_me: caught signal $ac_signal"
!     echo "$as_me: exit $exit_status"
    } >&5
    rm -f core *.core core.conftest.* &&
      rm -f -r conftest* confdefs* conf$$* $ac_clean_files &&
      exit $exit_status
  ' 0
  for ac_signal in 1 2 13 15; do
!   trap 'ac_signal='$ac_signal'; { (exit 1); exit 1; }' $ac_signal
  done
  ac_signal=0
  
  # confdefs.h avoids OS command line length limits that DEFS can exceed.
  rm -f -r conftest* confdefs.h
  
  # Predefined preprocessor variables.
  
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_NAME "$PACKAGE_NAME"
  _ACEOF
  
- 
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_TARNAME "$PACKAGE_TARNAME"
  _ACEOF
  
- 
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_VERSION "$PACKAGE_VERSION"
  _ACEOF
  
- 
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_STRING "$PACKAGE_STRING"
  _ACEOF
  
- 
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_BUGREPORT "$PACKAGE_BUGREPORT"
  _ACEOF
  
  
  # Let the site file select an alternate cache file if it wants to.
! # Prefer explicitly selected file to automatically selected ones.
  if test -n "$CONFIG_SITE"; then
!   set x "$CONFIG_SITE"
  elif test "x$prefix" != xNONE; then
!   set x "$prefix/share/config.site" "$prefix/etc/config.site"
  else
!   set x "$ac_default_prefix/share/config.site" \
! 	"$ac_default_prefix/etc/config.site"
  fi
! shift
! for ac_site_file
  do
!   if test -r "$ac_site_file"; then
!     { echo "$as_me:$LINENO: loading site script $ac_site_file" >&5
! echo "$as_me: loading site script $ac_site_file" >&6;}
      sed 's/^/| /' "$ac_site_file" >&5
      . "$ac_site_file"
    fi
  done
  
  if test -r "$cache_file"; then
!   # Some versions of bash will fail to source /dev/null (special
!   # files actually), so we avoid doing that.
!   if test -f "$cache_file"; then
!     { echo "$as_me:$LINENO: loading cache $cache_file" >&5
! echo "$as_me: loading cache $cache_file" >&6;}
      case $cache_file in
        [\\/]* | ?:[\\/]* ) . "$cache_file";;
        *)                      . "./$cache_file";;
      esac
    fi
  else
!   { echo "$as_me:$LINENO: creating cache $cache_file" >&5
! echo "$as_me: creating cache $cache_file" >&6;}
    >$cache_file
  fi
  
--- 2044,2131 ----
        echo
      fi
      test "$ac_signal" != 0 &&
!       $as_echo "$as_me: caught signal $ac_signal"
!     $as_echo "$as_me: exit $exit_status"
    } >&5
    rm -f core *.core core.conftest.* &&
      rm -f -r conftest* confdefs* conf$$* $ac_clean_files &&
      exit $exit_status
  ' 0
  for ac_signal in 1 2 13 15; do
!   trap 'ac_signal='$ac_signal'; as_fn_exit 1' $ac_signal
  done
  ac_signal=0
  
  # confdefs.h avoids OS command line length limits that DEFS can exceed.
  rm -f -r conftest* confdefs.h
  
+ $as_echo "/* confdefs.h */" > confdefs.h
+ 
  # Predefined preprocessor variables.
  
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_NAME "$PACKAGE_NAME"
  _ACEOF
  
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_TARNAME "$PACKAGE_TARNAME"
  _ACEOF
  
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_VERSION "$PACKAGE_VERSION"
  _ACEOF
  
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_STRING "$PACKAGE_STRING"
  _ACEOF
  
  cat >>confdefs.h <<_ACEOF
  #define PACKAGE_BUGREPORT "$PACKAGE_BUGREPORT"
  _ACEOF
  
+ cat >>confdefs.h <<_ACEOF
+ #define PACKAGE_URL "$PACKAGE_URL"
+ _ACEOF
+ 
  
  # Let the site file select an alternate cache file if it wants to.
! # Prefer an explicitly selected file to automatically selected ones.
! ac_site_file1=NONE
! ac_site_file2=NONE
  if test -n "$CONFIG_SITE"; then
!   ac_site_file1=$CONFIG_SITE
  elif test "x$prefix" != xNONE; then
!   ac_site_file1=$prefix/share/config.site
!   ac_site_file2=$prefix/etc/config.site
  else
!   ac_site_file1=$ac_default_prefix/share/config.site
!   ac_site_file2=$ac_default_prefix/etc/config.site
  fi
! for ac_site_file in "$ac_site_file1" "$ac_site_file2"
  do
!   test "x$ac_site_file" = xNONE && continue
!   if test /dev/null != "$ac_site_file" && test -r "$ac_site_file"; then
!     { $as_echo "$as_me:${as_lineno-$LINENO}: loading site script $ac_site_file" >&5
! $as_echo "$as_me: loading site script $ac_site_file" >&6;}
      sed 's/^/| /' "$ac_site_file" >&5
      . "$ac_site_file"
    fi
  done
  
  if test -r "$cache_file"; then
!   # Some versions of bash will fail to source /dev/null (special files
!   # actually), so we avoid doing that.  DJGPP emulates it as a regular file.
!   if test /dev/null != "$cache_file" && test -f "$cache_file"; then
!     { $as_echo "$as_me:${as_lineno-$LINENO}: loading cache $cache_file" >&5
! $as_echo "$as_me: loading cache $cache_file" >&6;}
      case $cache_file in
        [\\/]* | ?:[\\/]* ) . "$cache_file";;
        *)                      . "./$cache_file";;
      esac
    fi
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: creating cache $cache_file" >&5
! $as_echo "$as_me: creating cache $cache_file" >&6;}
    >$cache_file
  fi
  
***************
*** 1639,1706 ****
    eval ac_new_val=\$ac_env_${ac_var}_value
    case $ac_old_set,$ac_new_set in
      set,)
!       { echo "$as_me:$LINENO: error: \`$ac_var' was set to \`$ac_old_val' in the previous run" >&5
! echo "$as_me: error: \`$ac_var' was set to \`$ac_old_val' in the previous run" >&2;}
        ac_cache_corrupted=: ;;
      ,set)
!       { echo "$as_me:$LINENO: error: \`$ac_var' was not set in the previous run" >&5
! echo "$as_me: error: \`$ac_var' was not set in the previous run" >&2;}
        ac_cache_corrupted=: ;;
      ,);;
      *)
        if test "x$ac_old_val" != "x$ac_new_val"; then
! 	{ echo "$as_me:$LINENO: error: \`$ac_var' has changed since the previous run:" >&5
! echo "$as_me: error: \`$ac_var' has changed since the previous run:" >&2;}
! 	{ echo "$as_me:$LINENO:   former value:  $ac_old_val" >&5
! echo "$as_me:   former value:  $ac_old_val" >&2;}
! 	{ echo "$as_me:$LINENO:   current value: $ac_new_val" >&5
! echo "$as_me:   current value: $ac_new_val" >&2;}
! 	ac_cache_corrupted=:
        fi;;
    esac
    # Pass precious variables to config.status.
    if test "$ac_new_set" = set; then
      case $ac_new_val in
!     *\'*) ac_arg=$ac_var=`echo "$ac_new_val" | sed "s/'/'\\\\\\\\''/g"` ;;
      *) ac_arg=$ac_var=$ac_new_val ;;
      esac
      case " $ac_configure_args " in
        *" '$ac_arg' "*) ;; # Avoid dups.  Use of quotes ensures accuracy.
!       *) ac_configure_args="$ac_configure_args '$ac_arg'" ;;
      esac
    fi
  done
  if $ac_cache_corrupted; then
!   { echo "$as_me:$LINENO: error: changes in the environment can compromise the build" >&5
! echo "$as_me: error: changes in the environment can compromise the build" >&2;}
!   { { echo "$as_me:$LINENO: error: run \`make distclean' and/or \`rm $cache_file' and start over" >&5
! echo "$as_me: error: run \`make distclean' and/or \`rm $cache_file' and start over" >&2;}
!    { (exit 1); exit 1; }; }
! fi
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
  
  ac_ext=c
  ac_cpp='$CPP $CPPFLAGS'
--- 2139,2194 ----
    eval ac_new_val=\$ac_env_${ac_var}_value
    case $ac_old_set,$ac_new_set in
      set,)
!       { $as_echo "$as_me:${as_lineno-$LINENO}: error: \`$ac_var' was set to \`$ac_old_val' in the previous run" >&5
! $as_echo "$as_me: error: \`$ac_var' was set to \`$ac_old_val' in the previous run" >&2;}
        ac_cache_corrupted=: ;;
      ,set)
!       { $as_echo "$as_me:${as_lineno-$LINENO}: error: \`$ac_var' was not set in the previous run" >&5
! $as_echo "$as_me: error: \`$ac_var' was not set in the previous run" >&2;}
        ac_cache_corrupted=: ;;
      ,);;
      *)
        if test "x$ac_old_val" != "x$ac_new_val"; then
! 	# differences in whitespace do not lead to failure.
! 	ac_old_val_w=`echo x $ac_old_val`
! 	ac_new_val_w=`echo x $ac_new_val`
! 	if test "$ac_old_val_w" != "$ac_new_val_w"; then
! 	  { $as_echo "$as_me:${as_lineno-$LINENO}: error: \`$ac_var' has changed since the previous run:" >&5
! $as_echo "$as_me: error: \`$ac_var' has changed since the previous run:" >&2;}
! 	  ac_cache_corrupted=:
! 	else
! 	  { $as_echo "$as_me:${as_lineno-$LINENO}: warning: ignoring whitespace changes in \`$ac_var' since the previous run:" >&5
! $as_echo "$as_me: warning: ignoring whitespace changes in \`$ac_var' since the previous run:" >&2;}
! 	  eval $ac_var=\$ac_old_val
! 	fi
! 	{ $as_echo "$as_me:${as_lineno-$LINENO}:   former value:  \`$ac_old_val'" >&5
! $as_echo "$as_me:   former value:  \`$ac_old_val'" >&2;}
! 	{ $as_echo "$as_me:${as_lineno-$LINENO}:   current value: \`$ac_new_val'" >&5
! $as_echo "$as_me:   current value: \`$ac_new_val'" >&2;}
        fi;;
    esac
    # Pass precious variables to config.status.
    if test "$ac_new_set" = set; then
      case $ac_new_val in
!     *\'*) ac_arg=$ac_var=`$as_echo "$ac_new_val" | sed "s/'/'\\\\\\\\''/g"` ;;
      *) ac_arg=$ac_var=$ac_new_val ;;
      esac
      case " $ac_configure_args " in
        *" '$ac_arg' "*) ;; # Avoid dups.  Use of quotes ensures accuracy.
!       *) as_fn_append ac_configure_args " '$ac_arg'" ;;
      esac
    fi
  done
  if $ac_cache_corrupted; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
! $as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
!   { $as_echo "$as_me:${as_lineno-$LINENO}: error: changes in the environment can compromise the build" >&5
! $as_echo "$as_me: error: changes in the environment can compromise the build" >&2;}
!   as_fn_error "run \`make distclean' and/or \`rm $cache_file' and start over" "$LINENO" 5
! fi
! ## -------------------- ##
! ## Main body of script. ##
! ## -------------------- ##
  
  ac_ext=c
  ac_cpp='$CPP $CPPFLAGS'
***************
*** 1725,1734 ****
  if test -n "$ac_tool_prefix"; then
    # Extract the first word of "${ac_tool_prefix}gcc", so it can be a program name with args.
  set dummy ${ac_tool_prefix}gcc; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
--- 2213,2222 ----
  if test -n "$ac_tool_prefix"; then
    # Extract the first word of "${ac_tool_prefix}gcc", so it can be a program name with args.
  set dummy ${ac_tool_prefix}gcc; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
***************
*** 1738,1762 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_CC="${ac_tool_prefix}gcc"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { echo "$as_me:$LINENO: result: $CC" >&5
! echo "${ECHO_T}$CC" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 2226,2250 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_CC="${ac_tool_prefix}gcc"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $CC" >&5
! $as_echo "$CC" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 1765,1774 ****
    ac_ct_CC=$CC
    # Extract the first word of "gcc", so it can be a program name with args.
  set dummy gcc; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_ac_ct_CC+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$ac_ct_CC"; then
    ac_cv_prog_ac_ct_CC="$ac_ct_CC" # Let the user override the test.
--- 2253,2262 ----
    ac_ct_CC=$CC
    # Extract the first word of "gcc", so it can be a program name with args.
  set dummy gcc; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_ac_ct_CC+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$ac_ct_CC"; then
    ac_cv_prog_ac_ct_CC="$ac_ct_CC" # Let the user override the test.
***************
*** 1778,1802 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_ac_ct_CC="gcc"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  ac_ct_CC=$ac_cv_prog_ac_ct_CC
  if test -n "$ac_ct_CC"; then
!   { echo "$as_me:$LINENO: result: $ac_ct_CC" >&5
! echo "${ECHO_T}$ac_ct_CC" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
    if test "x$ac_ct_CC" = x; then
--- 2266,2290 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_ac_ct_CC="gcc"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  ac_ct_CC=$ac_cv_prog_ac_ct_CC
  if test -n "$ac_ct_CC"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_ct_CC" >&5
! $as_echo "$ac_ct_CC" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
    if test "x$ac_ct_CC" = x; then
***************
*** 1804,1815 ****
    else
      case $cross_compiling:$ac_tool_warned in
  yes:)
! { echo "$as_me:$LINENO: WARNING: In the future, Autoconf will not detect cross-tools
! whose name does not start with the host triplet.  If you think this
! configuration is useful to you, please write to autoconf@gnu.org." >&5
! echo "$as_me: WARNING: In the future, Autoconf will not detect cross-tools
! whose name does not start with the host triplet.  If you think this
! configuration is useful to you, please write to autoconf@gnu.org." >&2;}
  ac_tool_warned=yes ;;
  esac
      CC=$ac_ct_CC
--- 2292,2299 ----
    else
      case $cross_compiling:$ac_tool_warned in
  yes:)
! { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: using cross tools not prefixed with host triplet" >&5
! $as_echo "$as_me: WARNING: using cross tools not prefixed with host triplet" >&2;}
  ac_tool_warned=yes ;;
  esac
      CC=$ac_ct_CC
***************
*** 1822,1831 ****
            if test -n "$ac_tool_prefix"; then
      # Extract the first word of "${ac_tool_prefix}cc", so it can be a program name with args.
  set dummy ${ac_tool_prefix}cc; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
--- 2306,2315 ----
            if test -n "$ac_tool_prefix"; then
      # Extract the first word of "${ac_tool_prefix}cc", so it can be a program name with args.
  set dummy ${ac_tool_prefix}cc; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
***************
*** 1835,1859 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_CC="${ac_tool_prefix}cc"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { echo "$as_me:$LINENO: result: $CC" >&5
! echo "${ECHO_T}$CC" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 2319,2343 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_CC="${ac_tool_prefix}cc"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $CC" >&5
! $as_echo "$CC" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 1862,1871 ****
  if test -z "$CC"; then
    # Extract the first word of "cc", so it can be a program name with args.
  set dummy cc; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
--- 2346,2355 ----
  if test -z "$CC"; then
    # Extract the first word of "cc", so it can be a program name with args.
  set dummy cc; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
***************
*** 1876,1893 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      if test "$as_dir/$ac_word$ac_exec_ext" = "/usr/ucb/cc"; then
         ac_prog_rejected=yes
         continue
       fi
      ac_cv_prog_CC="cc"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  if test $ac_prog_rejected = yes; then
--- 2360,2377 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      if test "$as_dir/$ac_word$ac_exec_ext" = "/usr/ucb/cc"; then
         ac_prog_rejected=yes
         continue
       fi
      ac_cv_prog_CC="cc"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  if test $ac_prog_rejected = yes; then
***************
*** 1906,1916 ****
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { echo "$as_me:$LINENO: result: $CC" >&5
! echo "${ECHO_T}$CC" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 2390,2400 ----
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $CC" >&5
! $as_echo "$CC" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 1921,1930 ****
    do
      # Extract the first word of "$ac_tool_prefix$ac_prog", so it can be a program name with args.
  set dummy $ac_tool_prefix$ac_prog; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
--- 2405,2414 ----
    do
      # Extract the first word of "$ac_tool_prefix$ac_prog", so it can be a program name with args.
  set dummy $ac_tool_prefix$ac_prog; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_CC+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$CC"; then
    ac_cv_prog_CC="$CC" # Let the user override the test.
***************
*** 1934,1958 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_CC="$ac_tool_prefix$ac_prog"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { echo "$as_me:$LINENO: result: $CC" >&5
! echo "${ECHO_T}$CC" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 2418,2442 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_CC="$ac_tool_prefix$ac_prog"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  CC=$ac_cv_prog_CC
  if test -n "$CC"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $CC" >&5
! $as_echo "$CC" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 1965,1974 ****
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_ac_ct_CC+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$ac_ct_CC"; then
    ac_cv_prog_ac_ct_CC="$ac_ct_CC" # Let the user override the test.
--- 2449,2458 ----
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_ac_ct_CC+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$ac_ct_CC"; then
    ac_cv_prog_ac_ct_CC="$ac_ct_CC" # Let the user override the test.
***************
*** 1978,2002 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_ac_ct_CC="$ac_prog"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  ac_ct_CC=$ac_cv_prog_ac_ct_CC
  if test -n "$ac_ct_CC"; then
!   { echo "$as_me:$LINENO: result: $ac_ct_CC" >&5
! echo "${ECHO_T}$ac_ct_CC" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 2462,2486 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_ac_ct_CC="$ac_prog"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  ac_ct_CC=$ac_cv_prog_ac_ct_CC
  if test -n "$ac_ct_CC"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_ct_CC" >&5
! $as_echo "$ac_ct_CC" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 2008,2019 ****
    else
      case $cross_compiling:$ac_tool_warned in
  yes:)
! { echo "$as_me:$LINENO: WARNING: In the future, Autoconf will not detect cross-tools
! whose name does not start with the host triplet.  If you think this
! configuration is useful to you, please write to autoconf@gnu.org." >&5
! echo "$as_me: WARNING: In the future, Autoconf will not detect cross-tools
! whose name does not start with the host triplet.  If you think this
! configuration is useful to you, please write to autoconf@gnu.org." >&2;}
  ac_tool_warned=yes ;;
  esac
      CC=$ac_ct_CC
--- 2492,2499 ----
    else
      case $cross_compiling:$ac_tool_warned in
  yes:)
! { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: using cross tools not prefixed with host triplet" >&5
! $as_echo "$as_me: WARNING: using cross tools not prefixed with host triplet" >&2;}
  ac_tool_warned=yes ;;
  esac
      CC=$ac_ct_CC
***************
*** 2023,2073 ****
  fi
  
  
! test -z "$CC" && { { echo "$as_me:$LINENO: error: no acceptable C compiler found in \$PATH
! See \`config.log' for more details." >&5
! echo "$as_me: error: no acceptable C compiler found in \$PATH
! See \`config.log' for more details." >&2;}
!    { (exit 1); exit 1; }; }
  
  # Provide some information about the compiler.
! echo "$as_me:$LINENO: checking for C compiler version" >&5
! ac_compiler=`set X $ac_compile; echo $2`
! { (ac_try="$ac_compiler --version >&5"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compiler --version >&5") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }
! { (ac_try="$ac_compiler -v >&5"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compiler -v >&5") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }
! { (ac_try="$ac_compiler -V >&5"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compiler -V >&5") 2>&5
    ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }
  
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  int
--- 2503,2539 ----
  fi
  
  
! test -z "$CC" && { { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
! $as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
! as_fn_error "no acceptable C compiler found in \$PATH
! See \`config.log' for more details." "$LINENO" 5; }
  
  # Provide some information about the compiler.
! $as_echo "$as_me:${as_lineno-$LINENO}: checking for C compiler version" >&5
! set X $ac_compile
! ac_compiler=$2
! for ac_option in --version -v -V -qversion; do
!   { { ac_try="$ac_compiler $ac_option >&5"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_compiler $ac_option >&5") 2>conftest.err
    ac_status=$?
!   if test -s conftest.err; then
!     sed '10a\
! ... rest of stderr output deleted ...
!          10q' conftest.err >conftest.er1
!     cat conftest.er1 >&5
!   fi
!   rm -f conftest.er1 conftest.err
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }
! done
  
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  int
***************
*** 2079,2120 ****
  }
  _ACEOF
  ac_clean_files_save=$ac_clean_files
! ac_clean_files="$ac_clean_files a.out a.exe b.out"
  # Try to create an executable without -o first, disregard a.out.
  # It will help us diagnose broken compilers, and finding out an intuition
  # of exeext.
! { echo "$as_me:$LINENO: checking for C compiler default output file name" >&5
! echo $ECHO_N "checking for C compiler default output file name... $ECHO_C" >&6; }
! ac_link_default=`echo "$ac_link" | sed 's/ -o *conftest[^ ]*//'`
! #
! # List of possible output files, starting from the most likely.
! # The algorithm is not robust to junk in `.', hence go to wildcards (a.*)
! # only as a last resort.  b.out is created by i960 compilers.
! ac_files='a_out.exe a.exe conftest.exe a.out conftest a.* conftest.* b.out'
! #
! # The IRIX 6 linker writes into existing files which may not be
! # executable, retaining their permissions.  Remove them first so a
! # subsequent execution test works.
  ac_rmfiles=
  for ac_file in $ac_files
  do
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf | *.o | *.obj ) ;;
      * ) ac_rmfiles="$ac_rmfiles $ac_file";;
    esac
  done
  rm -f $ac_rmfiles
  
! if { (ac_try="$ac_link_default"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
    (eval "$ac_link_default") 2>&5
    ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; then
    # Autoconf-2.13 could set the ac_cv_exeext variable to `no'.
  # So ignore a value of `no', otherwise this would lead to `EXEEXT = no'
  # in a Makefile.  We should not override ac_cv_exeext if it was cached,
--- 2545,2582 ----
  }
  _ACEOF
  ac_clean_files_save=$ac_clean_files
! ac_clean_files="$ac_clean_files a.out a.out.dSYM a.exe b.out"
  # Try to create an executable without -o first, disregard a.out.
  # It will help us diagnose broken compilers, and finding out an intuition
  # of exeext.
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether the C compiler works" >&5
! $as_echo_n "checking whether the C compiler works... " >&6; }
! ac_link_default=`$as_echo "$ac_link" | sed 's/ -o *conftest[^ ]*//'`
! 
! # The possible output files:
! ac_files="a.out conftest.exe conftest a.exe a_out.exe b.out conftest.*"
! 
  ac_rmfiles=
  for ac_file in $ac_files
  do
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf | *.dSYM | *.o | *.obj ) ;;
      * ) ac_rmfiles="$ac_rmfiles $ac_file";;
    esac
  done
  rm -f $ac_rmfiles
  
! if { { ac_try="$ac_link_default"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
    (eval "$ac_link_default") 2>&5
    ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }; then :
    # Autoconf-2.13 could set the ac_cv_exeext variable to `no'.
  # So ignore a value of `no', otherwise this would lead to `EXEEXT = no'
  # in a Makefile.  We should not override ac_cv_exeext if it was cached,
***************
*** 2124,2137 ****
  do
    test -f "$ac_file" || continue
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf | *.o | *.obj )
  	;;
      [ab].out )
  	# We found the default executable, but exeext='' is most
  	# certainly right.
  	break;;
      *.* )
!         if test "${ac_cv_exeext+set}" = set && test "$ac_cv_exeext" != no;
  	then :; else
  	   ac_cv_exeext=`expr "$ac_file" : '[^.]*\(\..*\)'`
  	fi
--- 2586,2599 ----
  do
    test -f "$ac_file" || continue
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf | *.dSYM | *.o | *.obj )
  	;;
      [ab].out )
  	# We found the default executable, but exeext='' is most
  	# certainly right.
  	break;;
      *.* )
! 	if test "${ac_cv_exeext+set}" = set && test "$ac_cv_exeext" != no;
  	then :; else
  	   ac_cv_exeext=`expr "$ac_file" : '[^.]*\(\..*\)'`
  	fi
***************
*** 2150,2227 ****
  else
    ac_file=''
  fi
! 
! { echo "$as_me:$LINENO: result: $ac_file" >&5
! echo "${ECHO_T}$ac_file" >&6; }
! if test -z "$ac_file"; then
!   echo "$as_me: failed program was:" >&5
  sed 's/^/| /' conftest.$ac_ext >&5
  
! { { echo "$as_me:$LINENO: error: C compiler cannot create executables
! See \`config.log' for more details." >&5
! echo "$as_me: error: C compiler cannot create executables
! See \`config.log' for more details." >&2;}
!    { (exit 77); exit 77; }; }
! fi
! 
  ac_exeext=$ac_cv_exeext
  
! # Check that the compiler produces executables we can run.  If not, either
! # the compiler is broken, or we cross compile.
! { echo "$as_me:$LINENO: checking whether the C compiler works" >&5
! echo $ECHO_N "checking whether the C compiler works... $ECHO_C" >&6; }
! # FIXME: These cross compiler hacks should be removed for Autoconf 3.0
! # If not cross compiling, check that we can run a simple program.
! if test "$cross_compiling" != yes; then
!   if { ac_try='./$ac_file'
!   { (case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
    ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!     cross_compiling=no
!   else
!     if test "$cross_compiling" = maybe; then
! 	cross_compiling=yes
!     else
! 	{ { echo "$as_me:$LINENO: error: cannot run C compiled programs.
! If you meant to cross compile, use \`--host'.
! See \`config.log' for more details." >&5
! echo "$as_me: error: cannot run C compiled programs.
! If you meant to cross compile, use \`--host'.
! See \`config.log' for more details." >&2;}
!    { (exit 1); exit 1; }; }
!     fi
!   fi
! fi
! { echo "$as_me:$LINENO: result: yes" >&5
! echo "${ECHO_T}yes" >&6; }
! 
! rm -f a.out a.exe conftest$ac_cv_exeext b.out
! ac_clean_files=$ac_clean_files_save
! # Check that the compiler produces executables we can run.  If not, either
! # the compiler is broken, or we cross compile.
! { echo "$as_me:$LINENO: checking whether we are cross compiling" >&5
! echo $ECHO_N "checking whether we are cross compiling... $ECHO_C" >&6; }
! { echo "$as_me:$LINENO: result: $cross_compiling" >&5
! echo "${ECHO_T}$cross_compiling" >&6; }
! 
! { echo "$as_me:$LINENO: checking for suffix of executables" >&5
! echo $ECHO_N "checking for suffix of executables... $ECHO_C" >&6; }
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; then
    # If both `conftest.exe' and `conftest' are `present' (well, observable)
  # catch `conftest.exe'.  For instance with Cygwin, `ls conftest' will
  # work properly (i.e., refer to `conftest.exe'), while it won't with
--- 2612,2653 ----
  else
    ac_file=''
  fi
! if test -z "$ac_file"; then :
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
! $as_echo "$as_me: failed program was:" >&5
  sed 's/^/| /' conftest.$ac_ext >&5
  
! { { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
! $as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
! { as_fn_set_status 77
! as_fn_error "C compiler cannot create executables
! See \`config.log' for more details." "$LINENO" 5; }; }
! else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: yes" >&5
! $as_echo "yes" >&6; }
! fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for C compiler default output file name" >&5
! $as_echo_n "checking for C compiler default output file name... " >&6; }
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_file" >&5
! $as_echo "$ac_file" >&6; }
  ac_exeext=$ac_cv_exeext
  
! rm -f -r a.out a.out.dSYM a.exe conftest$ac_cv_exeext b.out
! ac_clean_files=$ac_clean_files_save
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for suffix of executables" >&5
! $as_echo_n "checking for suffix of executables... " >&6; }
! if { { ac_try="$ac_link"
! case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_link") 2>&5
    ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }; then :
    # If both `conftest.exe' and `conftest' are `present' (well, observable)
  # catch `conftest.exe'.  For instance with Cygwin, `ls conftest' will
  # work properly (i.e., refer to `conftest.exe'), while it won't with
***************
*** 2229,2265 ****
  for ac_file in conftest.exe conftest conftest.*; do
    test -f "$ac_file" || continue
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf | *.o | *.obj ) ;;
      *.* ) ac_cv_exeext=`expr "$ac_file" : '[^.]*\(\..*\)'`
  	  break;;
      * ) break;;
    esac
  done
  else
!   { { echo "$as_me:$LINENO: error: cannot compute suffix of executables: cannot compile and link
! See \`config.log' for more details." >&5
! echo "$as_me: error: cannot compute suffix of executables: cannot compile and link
! See \`config.log' for more details." >&2;}
!    { (exit 1); exit 1; }; }
! fi
! 
! rm -f conftest$ac_cv_exeext
! { echo "$as_me:$LINENO: result: $ac_cv_exeext" >&5
! echo "${ECHO_T}$ac_cv_exeext" >&6; }
  
  rm -f conftest.$ac_ext
  EXEEXT=$ac_cv_exeext
  ac_exeext=$EXEEXT
! { echo "$as_me:$LINENO: checking for suffix of object files" >&5
! echo $ECHO_N "checking for suffix of object files... $ECHO_C" >&6; }
! if test "${ac_cv_objext+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
  _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  int
--- 2655,2744 ----
  for ac_file in conftest.exe conftest conftest.*; do
    test -f "$ac_file" || continue
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf | *.dSYM | *.o | *.obj ) ;;
      *.* ) ac_cv_exeext=`expr "$ac_file" : '[^.]*\(\..*\)'`
  	  break;;
      * ) break;;
    esac
  done
  else
!   { { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
! $as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
! as_fn_error "cannot compute suffix of executables: cannot compile and link
! See \`config.log' for more details." "$LINENO" 5; }
! fi
! rm -f conftest conftest$ac_cv_exeext
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_exeext" >&5
! $as_echo "$ac_cv_exeext" >&6; }
  
  rm -f conftest.$ac_ext
  EXEEXT=$ac_cv_exeext
  ac_exeext=$EXEEXT
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! #include <stdio.h>
! int
! main ()
! {
! FILE *f = fopen ("conftest.out", "w");
!  return ferror (f) || fclose (f) != 0;
! 
!   ;
!   return 0;
! }
  _ACEOF
! ac_clean_files="$ac_clean_files conftest.out"
! # Check that the compiler produces executables we can run.  If not, either
! # the compiler is broken, or we cross compile.
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether we are cross compiling" >&5
! $as_echo_n "checking whether we are cross compiling... " >&6; }
! if test "$cross_compiling" != yes; then
!   { { ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_link") 2>&5
!   ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }
!   if { ac_try='./conftest$ac_cv_exeext'
!   { { case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }; }; then
!     cross_compiling=no
!   else
!     if test "$cross_compiling" = maybe; then
! 	cross_compiling=yes
!     else
! 	{ { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
! $as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
! as_fn_error "cannot run C compiled programs.
! If you meant to cross compile, use \`--host'.
! See \`config.log' for more details." "$LINENO" 5; }
!     fi
!   fi
! fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $cross_compiling" >&5
! $as_echo "$cross_compiling" >&6; }
! 
! rm -f conftest.$ac_ext conftest$ac_cv_exeext conftest.out
! ac_clean_files=$ac_clean_files_save
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for suffix of object files" >&5
! $as_echo_n "checking for suffix of object files... " >&6; }
! if test "${ac_cv_objext+set}" = set; then :
!   $as_echo_n "(cached) " >&6
! else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  int
***************
*** 2271,2321 ****
  }
  _ACEOF
  rm -f conftest.o conftest.obj
! if { (ac_try="$ac_compile"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
    (eval "$ac_compile") 2>&5
    ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; then
    for ac_file in conftest.o conftest.obj conftest.*; do
    test -f "$ac_file" || continue;
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf ) ;;
      *) ac_cv_objext=`expr "$ac_file" : '.*\.\(.*\)'`
         break;;
    esac
  done
  else
!   echo "$as_me: failed program was:" >&5
  sed 's/^/| /' conftest.$ac_ext >&5
  
! { { echo "$as_me:$LINENO: error: cannot compute suffix of object files: cannot compile
! See \`config.log' for more details." >&5
! echo "$as_me: error: cannot compute suffix of object files: cannot compile
! See \`config.log' for more details." >&2;}
!    { (exit 1); exit 1; }; }
  fi
- 
  rm -f conftest.$ac_cv_objext conftest.$ac_ext
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_objext" >&5
! echo "${ECHO_T}$ac_cv_objext" >&6; }
  OBJEXT=$ac_cv_objext
  ac_objext=$OBJEXT
! { echo "$as_me:$LINENO: checking whether we are using the GNU C compiler" >&5
! echo $ECHO_N "checking whether we are using the GNU C compiler... $ECHO_C" >&6; }
! if test "${ac_cv_c_compiler_gnu+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  int
--- 2750,2795 ----
  }
  _ACEOF
  rm -f conftest.o conftest.obj
! if { { ac_try="$ac_compile"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
    (eval "$ac_compile") 2>&5
    ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }; then :
    for ac_file in conftest.o conftest.obj conftest.*; do
    test -f "$ac_file" || continue;
    case $ac_file in
!     *.$ac_ext | *.xcoff | *.tds | *.d | *.pdb | *.xSYM | *.bb | *.bbg | *.map | *.inf | *.dSYM ) ;;
      *) ac_cv_objext=`expr "$ac_file" : '.*\.\(.*\)'`
         break;;
    esac
  done
  else
!   $as_echo "$as_me: failed program was:" >&5
  sed 's/^/| /' conftest.$ac_ext >&5
  
! { { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
! $as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
! as_fn_error "cannot compute suffix of object files: cannot compile
! See \`config.log' for more details." "$LINENO" 5; }
  fi
  rm -f conftest.$ac_cv_objext conftest.$ac_ext
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_objext" >&5
! $as_echo "$ac_cv_objext" >&6; }
  OBJEXT=$ac_cv_objext
  ac_objext=$OBJEXT
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether we are using the GNU C compiler" >&5
! $as_echo_n "checking whether we are using the GNU C compiler... " >&6; }
! if test "${ac_cv_c_compiler_gnu+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  int
***************
*** 2329,2399 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_compiler_gnu=yes
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_compiler_gnu=no
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  ac_cv_c_compiler_gnu=$ac_compiler_gnu
  
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_c_compiler_gnu" >&5
! echo "${ECHO_T}$ac_cv_c_compiler_gnu" >&6; }
! GCC=`test $ac_compiler_gnu = yes && echo yes`
  ac_test_CFLAGS=${CFLAGS+set}
  ac_save_CFLAGS=$CFLAGS
! { echo "$as_me:$LINENO: checking whether $CC accepts -g" >&5
! echo $ECHO_N "checking whether $CC accepts -g... $ECHO_C" >&6; }
! if test "${ac_cv_prog_cc_g+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_save_c_werror_flag=$ac_c_werror_flag
     ac_c_werror_flag=yes
     ac_cv_prog_cc_g=no
     CFLAGS="-g"
!    cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  int
--- 2803,2836 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
    ac_compiler_gnu=yes
  else
!   ac_compiler_gnu=no
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  ac_cv_c_compiler_gnu=$ac_compiler_gnu
  
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_c_compiler_gnu" >&5
! $as_echo "$ac_cv_c_compiler_gnu" >&6; }
! if test $ac_compiler_gnu = yes; then
!   GCC=yes
! else
!   GCC=
! fi
  ac_test_CFLAGS=${CFLAGS+set}
  ac_save_CFLAGS=$CFLAGS
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether $CC accepts -g" >&5
! $as_echo_n "checking whether $CC accepts -g... " >&6; }
! if test "${ac_cv_prog_cc_g+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    ac_save_c_werror_flag=$ac_c_werror_flag
     ac_c_werror_flag=yes
     ac_cv_prog_cc_g=no
     CFLAGS="-g"
!    cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  int
***************
*** 2404,2454 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_prog_cc_g=yes
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	CFLAGS=""
!       cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  int
--- 2841,2851 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
    ac_cv_prog_cc_g=yes
  else
!   CFLAGS=""
!       cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  int
***************
*** 2459,2510 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   :
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
! 	ac_c_werror_flag=$ac_save_c_werror_flag
  	 CFLAGS="-g"
! 	 cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  int
--- 2856,2867 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
  
! else
!   ac_c_werror_flag=$ac_save_c_werror_flag
  	 CFLAGS="-g"
! 	 cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  int
***************
*** 2515,2573 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_prog_cc_g=yes
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
- 
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
     ac_c_werror_flag=$ac_save_c_werror_flag
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_prog_cc_g" >&5
! echo "${ECHO_T}$ac_cv_prog_cc_g" >&6; }
  if test "$ac_test_CFLAGS" = set; then
    CFLAGS=$ac_save_CFLAGS
  elif test $ac_cv_prog_cc_g = yes; then
--- 2872,2889 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
    ac_cv_prog_cc_g=yes
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
     ac_c_werror_flag=$ac_save_c_werror_flag
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_prog_cc_g" >&5
! $as_echo "$ac_cv_prog_cc_g" >&6; }
  if test "$ac_test_CFLAGS" = set; then
    CFLAGS=$ac_save_CFLAGS
  elif test $ac_cv_prog_cc_g = yes; then
***************
*** 2583,2600 ****
      CFLAGS=
    fi
  fi
! { echo "$as_me:$LINENO: checking for $CC option to accept ISO C89" >&5
! echo $ECHO_N "checking for $CC option to accept ISO C89... $ECHO_C" >&6; }
! if test "${ac_cv_prog_cc_c89+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_cv_prog_cc_c89=no
  ac_save_CC=$CC
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <stdarg.h>
  #include <stdio.h>
--- 2899,2912 ----
      CFLAGS=
    fi
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $CC option to accept ISO C89" >&5
! $as_echo_n "checking for $CC option to accept ISO C89... " >&6; }
! if test "${ac_cv_prog_cc_c89+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    ac_cv_prog_cc_c89=no
  ac_save_CC=$CC
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <stdarg.h>
  #include <stdio.h>
***************
*** 2651,2698 ****
  	-Ae "-Aa -D_HPUX_SOURCE" "-Xc -D__EXTENSIONS__"
  do
    CC="$ac_save_CC $ac_arg"
!   rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_prog_cc_c89=$ac_arg
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
- 
  fi
- 
  rm -f core conftest.err conftest.$ac_objext
    test "x$ac_cv_prog_cc_c89" != "xno" && break
  done
--- 2963,2971 ----
  	-Ae "-Aa -D_HPUX_SOURCE" "-Xc -D__EXTENSIONS__"
  do
    CC="$ac_save_CC $ac_arg"
!   if ac_fn_c_try_compile "$LINENO"; then :
    ac_cv_prog_cc_c89=$ac_arg
  fi
  rm -f core conftest.err conftest.$ac_objext
    test "x$ac_cv_prog_cc_c89" != "xno" && break
  done
***************
*** 2703,2719 ****
  # AC_CACHE_VAL
  case "x$ac_cv_prog_cc_c89" in
    x)
!     { echo "$as_me:$LINENO: result: none needed" >&5
! echo "${ECHO_T}none needed" >&6; } ;;
    xno)
!     { echo "$as_me:$LINENO: result: unsupported" >&5
! echo "${ECHO_T}unsupported" >&6; } ;;
    *)
      CC="$CC $ac_cv_prog_cc_c89"
!     { echo "$as_me:$LINENO: result: $ac_cv_prog_cc_c89" >&5
! echo "${ECHO_T}$ac_cv_prog_cc_c89" >&6; } ;;
  esac
  
  
  ac_ext=c
  ac_cpp='$CPP $CPPFLAGS'
--- 2976,2994 ----
  # AC_CACHE_VAL
  case "x$ac_cv_prog_cc_c89" in
    x)
!     { $as_echo "$as_me:${as_lineno-$LINENO}: result: none needed" >&5
! $as_echo "none needed" >&6; } ;;
    xno)
!     { $as_echo "$as_me:${as_lineno-$LINENO}: result: unsupported" >&5
! $as_echo "unsupported" >&6; } ;;
    *)
      CC="$CC $ac_cv_prog_cc_c89"
!     { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_prog_cc_c89" >&5
! $as_echo "$ac_cv_prog_cc_c89" >&6; } ;;
  esac
+ if test "x$ac_cv_prog_cc_c89" != xno; then :
  
+ fi
  
  ac_ext=c
  ac_cpp='$CPP $CPPFLAGS'
***************
*** 2726,2735 ****
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_LEX+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$LEX"; then
    ac_cv_prog_LEX="$LEX" # Let the user override the test.
--- 3001,3010 ----
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_LEX+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$LEX"; then
    ac_cv_prog_LEX="$LEX" # Let the user override the test.
***************
*** 2739,2763 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_LEX="$ac_prog"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  LEX=$ac_cv_prog_LEX
  if test -n "$LEX"; then
!   { echo "$as_me:$LINENO: result: $LEX" >&5
! echo "${ECHO_T}$LEX" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 3014,3038 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_LEX="$ac_prog"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  LEX=$ac_cv_prog_LEX
  if test -n "$LEX"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $LEX" >&5
! $as_echo "$LEX" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 2785,2804 ****
    return ! yylex () + ! yywrap ();
  }
  _ACEOF
! { (ac_try="$LEX conftest.l"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
    (eval "$LEX conftest.l") 2>&5
    ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }
! { echo "$as_me:$LINENO: checking lex output file root" >&5
! echo $ECHO_N "checking lex output file root... $ECHO_C" >&6; }
! if test "${ac_cv_prog_lex_root+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
  
  if test -f lex.yy.c; then
--- 3060,3080 ----
    return ! yylex () + ! yywrap ();
  }
  _ACEOF
! { { ac_try="$LEX conftest.l"
  case "(($ac_try" in
    *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
    *) ac_try_echo=$ac_try;;
  esac
! eval ac_try_echo="\"\$as_me:${as_lineno-$LINENO}: $ac_try_echo\""
! $as_echo "$ac_try_echo"; } >&5
    (eval "$LEX conftest.l") 2>&5
    ac_status=$?
!   $as_echo "$as_me:${as_lineno-$LINENO}: \$? = $ac_status" >&5
!   test $ac_status = 0; }
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking lex output file root" >&5
! $as_echo_n "checking lex output file root... " >&6; }
! if test "${ac_cv_prog_lex_root+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
  
  if test -f lex.yy.c; then
***************
*** 2806,2893 ****
  elif test -f lexyy.c; then
    ac_cv_prog_lex_root=lexyy
  else
!   { { echo "$as_me:$LINENO: error: cannot find output from $LEX; giving up" >&5
! echo "$as_me: error: cannot find output from $LEX; giving up" >&2;}
!    { (exit 1); exit 1; }; }
  fi
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_prog_lex_root" >&5
! echo "${ECHO_T}$ac_cv_prog_lex_root" >&6; }
  LEX_OUTPUT_ROOT=$ac_cv_prog_lex_root
  
  if test -z "${LEXLIB+set}"; then
!   { echo "$as_me:$LINENO: checking lex library" >&5
! echo $ECHO_N "checking lex library... $ECHO_C" >&6; }
! if test "${ac_cv_lib_lex+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
  
      ac_save_LIBS=$LIBS
      ac_cv_lib_lex='none needed'
      for ac_lib in '' -lfl -ll; do
        LIBS="$ac_lib $ac_save_LIBS"
!       cat >conftest.$ac_ext <<_ACEOF
  `cat $LEX_OUTPUT_ROOT.c`
  _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_lib_lex=$ac_lib
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
- 
  fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
        test "$ac_cv_lib_lex" != 'none needed' && break
      done
      LIBS=$ac_save_LIBS
  
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_lib_lex" >&5
! echo "${ECHO_T}$ac_cv_lib_lex" >&6; }
    test "$ac_cv_lib_lex" != 'none needed' && LEXLIB=$ac_cv_lib_lex
  fi
  
  
! { echo "$as_me:$LINENO: checking whether yytext is a pointer" >&5
! echo $ECHO_N "checking whether yytext is a pointer... $ECHO_C" >&6; }
! if test "${ac_cv_prog_lex_yytext_pointer+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    # POSIX says lex can declare yytext either as a pointer or an array; the
  # default is implementation-dependent.  Figure out which it is, since
--- 3082,3129 ----
  elif test -f lexyy.c; then
    ac_cv_prog_lex_root=lexyy
  else
!   as_fn_error "cannot find output from $LEX; giving up" "$LINENO" 5
  fi
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_prog_lex_root" >&5
! $as_echo "$ac_cv_prog_lex_root" >&6; }
  LEX_OUTPUT_ROOT=$ac_cv_prog_lex_root
  
  if test -z "${LEXLIB+set}"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking lex library" >&5
! $as_echo_n "checking lex library... " >&6; }
! if test "${ac_cv_lib_lex+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
  
      ac_save_LIBS=$LIBS
      ac_cv_lib_lex='none needed'
      for ac_lib in '' -lfl -ll; do
        LIBS="$ac_lib $ac_save_LIBS"
!       cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
  `cat $LEX_OUTPUT_ROOT.c`
  _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
    ac_cv_lib_lex=$ac_lib
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
        test "$ac_cv_lib_lex" != 'none needed' && break
      done
      LIBS=$ac_save_LIBS
  
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_lib_lex" >&5
! $as_echo "$ac_cv_lib_lex" >&6; }
    test "$ac_cv_lib_lex" != 'none needed' && LEXLIB=$ac_cv_lib_lex
  fi
  
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether yytext is a pointer" >&5
! $as_echo_n "checking whether yytext is a pointer... " >&6; }
! if test "${ac_cv_prog_lex_yytext_pointer+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    # POSIX says lex can declare yytext either as a pointer or an array; the
  # default is implementation-dependent.  Figure out which it is, since
***************
*** 2895,2958 ****
  ac_cv_prog_lex_yytext_pointer=no
  ac_save_LIBS=$LIBS
  LIBS="$LEXLIB $ac_save_LIBS"
! cat >conftest.$ac_ext <<_ACEOF
  #define YYTEXT_POINTER 1
  `cat $LEX_OUTPUT_ROOT.c`
  _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_prog_lex_yytext_pointer=yes
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
- 
  fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
  LIBS=$ac_save_LIBS
  
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_prog_lex_yytext_pointer" >&5
! echo "${ECHO_T}$ac_cv_prog_lex_yytext_pointer" >&6; }
  if test $ac_cv_prog_lex_yytext_pointer = yes; then
  
! cat >>confdefs.h <<\_ACEOF
! #define YYTEXT_POINTER 1
! _ACEOF
  
  fi
  rm -f conftest.l $LEX_OUTPUT_ROOT.c
--- 3131,3154 ----
  ac_cv_prog_lex_yytext_pointer=no
  ac_save_LIBS=$LIBS
  LIBS="$LEXLIB $ac_save_LIBS"
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
  #define YYTEXT_POINTER 1
  `cat $LEX_OUTPUT_ROOT.c`
  _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
    ac_cv_prog_lex_yytext_pointer=yes
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
  LIBS=$ac_save_LIBS
  
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_prog_lex_yytext_pointer" >&5
! $as_echo "$ac_cv_prog_lex_yytext_pointer" >&6; }
  if test $ac_cv_prog_lex_yytext_pointer = yes; then
  
! $as_echo "#define YYTEXT_POINTER 1" >>confdefs.h
  
  fi
  rm -f conftest.l $LEX_OUTPUT_ROOT.c
***************
*** 2960,2983 ****
  fi
  ac_aux_dir=
  for ac_dir in "$srcdir" "$srcdir/.." "$srcdir/../.."; do
!   if test -f "$ac_dir/install-sh"; then
!     ac_aux_dir=$ac_dir
!     ac_install_sh="$ac_aux_dir/install-sh -c"
!     break
!   elif test -f "$ac_dir/install.sh"; then
!     ac_aux_dir=$ac_dir
!     ac_install_sh="$ac_aux_dir/install.sh -c"
!     break
!   elif test -f "$ac_dir/shtool"; then
!     ac_aux_dir=$ac_dir
!     ac_install_sh="$ac_aux_dir/shtool install -c"
!     break
!   fi
  done
  if test -z "$ac_aux_dir"; then
!   { { echo "$as_me:$LINENO: error: cannot find install-sh or install.sh in \"$srcdir\" \"$srcdir/..\" \"$srcdir/../..\"" >&5
! echo "$as_me: error: cannot find install-sh or install.sh in \"$srcdir\" \"$srcdir/..\" \"$srcdir/../..\"" >&2;}
!    { (exit 1); exit 1; }; }
  fi
  
  # These three variables are undocumented and unsupported,
--- 3156,3171 ----
  fi
  ac_aux_dir=
  for ac_dir in "$srcdir" "$srcdir/.." "$srcdir/../.."; do
!   for ac_t in install-sh install.sh shtool; do
!     if test -f "$ac_dir/$ac_t"; then
!       ac_aux_dir=$ac_dir
!       ac_install_sh="$ac_aux_dir/$ac_t -c"
!       break 2
!     fi
!   done
  done
  if test -z "$ac_aux_dir"; then
!   as_fn_error "cannot find install-sh, install.sh, or shtool in \"$srcdir\" \"$srcdir/..\" \"$srcdir/../..\"" "$LINENO" 5
  fi
  
  # These three variables are undocumented and unsupported,
***************
*** 3002,3023 ****
  # SVR4 /usr/ucb/install, which tries to use the nonexistent group "staff"
  # OS/2's system install, which has a completely different semantic
  # ./install, which can be erroneously created by make from ./install.sh.
! { echo "$as_me:$LINENO: checking for a BSD-compatible install" >&5
! echo $ECHO_N "checking for a BSD-compatible install... $ECHO_C" >&6; }
  if test -z "$INSTALL"; then
! if test "${ac_cv_path_install+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   # Account for people who put trailing slashes in PATH elements.
! case $as_dir/ in
!   ./ | .// | /cC/* | \
    /etc/* | /usr/sbin/* | /usr/etc/* | /sbin/* | /usr/afsws/bin/* | \
!   ?:\\/os2\\/install\\/* | ?:\\/OS2\\/INSTALL\\/* | \
    /usr/ucb/* ) ;;
    *)
      # OSF1 and SCO ODT 3.0 have their own names for install.
--- 3190,3212 ----
  # SVR4 /usr/ucb/install, which tries to use the nonexistent group "staff"
  # OS/2's system install, which has a completely different semantic
  # ./install, which can be erroneously created by make from ./install.sh.
! # Reject install programs that cannot install multiple files.
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for a BSD-compatible install" >&5
! $as_echo_n "checking for a BSD-compatible install... " >&6; }
  if test -z "$INSTALL"; then
! if test "${ac_cv_path_install+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     # Account for people who put trailing slashes in PATH elements.
! case $as_dir/ in #((
!   ./ | .// | /[cC]/* | \
    /etc/* | /usr/sbin/* | /usr/etc/* | /sbin/* | /usr/afsws/bin/* | \
!   ?:[\\/]os2[\\/]install[\\/]* | ?:[\\/]OS2[\\/]INSTALL[\\/]* | \
    /usr/ucb/* ) ;;
    *)
      # OSF1 and SCO ODT 3.0 have their own names for install.
***************
*** 3025,3031 ****
      # by default.
      for ac_prog in ginstall scoinst install; do
        for ac_exec_ext in '' $ac_executable_extensions; do
! 	if { test -f "$as_dir/$ac_prog$ac_exec_ext" && $as_executable_p "$as_dir/$ac_prog$ac_exec_ext"; }; then
  	  if test $ac_prog = install &&
  	    grep dspmsg "$as_dir/$ac_prog$ac_exec_ext" >/dev/null 2>&1; then
  	    # AIX install.  It has an incompatible calling convention.
--- 3214,3220 ----
      # by default.
      for ac_prog in ginstall scoinst install; do
        for ac_exec_ext in '' $ac_executable_extensions; do
! 	if { test -f "$as_dir/$ac_prog$ac_exec_ext" && $as_test_x "$as_dir/$ac_prog$ac_exec_ext"; }; then
  	  if test $ac_prog = install &&
  	    grep dspmsg "$as_dir/$ac_prog$ac_exec_ext" >/dev/null 2>&1; then
  	    # AIX install.  It has an incompatible calling convention.
***************
*** 3035,3051 ****
  	    # program-specific install script used by HP pwplus--don't use.
  	    :
  	  else
! 	    ac_cv_path_install="$as_dir/$ac_prog$ac_exec_ext -c"
! 	    break 3
  	  fi
  	fi
        done
      done
      ;;
  esac
! done
  IFS=$as_save_IFS
  
  
  fi
    if test "${ac_cv_path_install+set}" = set; then
--- 3224,3252 ----
  	    # program-specific install script used by HP pwplus--don't use.
  	    :
  	  else
! 	    rm -rf conftest.one conftest.two conftest.dir
! 	    echo one > conftest.one
! 	    echo two > conftest.two
! 	    mkdir conftest.dir
! 	    if "$as_dir/$ac_prog$ac_exec_ext" -c conftest.one conftest.two "`pwd`/conftest.dir" &&
! 	      test -s conftest.one && test -s conftest.two &&
! 	      test -s conftest.dir/conftest.one &&
! 	      test -s conftest.dir/conftest.two
! 	    then
! 	      ac_cv_path_install="$as_dir/$ac_prog$ac_exec_ext -c"
! 	      break 3
! 	    fi
  	  fi
  	fi
        done
      done
      ;;
  esac
! 
!   done
  IFS=$as_save_IFS
  
+ rm -rf conftest.one conftest.two conftest.dir
  
  fi
    if test "${ac_cv_path_install+set}" = set; then
***************
*** 3058,3065 ****
      INSTALL=$ac_install_sh
    fi
  fi
! { echo "$as_me:$LINENO: result: $INSTALL" >&5
! echo "${ECHO_T}$INSTALL" >&6; }
  
  # Use test -z because SunOS4 sh mishandles braces in ${var-val}.
  # It thinks the first close brace ends the variable substitution.
--- 3259,3266 ----
      INSTALL=$ac_install_sh
    fi
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $INSTALL" >&5
! $as_echo "$INSTALL" >&6; }
  
  # Use test -z because SunOS4 sh mishandles braces in ${var-val}.
  # It thinks the first close brace ends the variable substitution.
***************
*** 3073,3082 ****
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_AWK+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$AWK"; then
    ac_cv_prog_AWK="$AWK" # Let the user override the test.
--- 3274,3283 ----
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_AWK+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$AWK"; then
    ac_cv_prog_AWK="$AWK" # Let the user override the test.
***************
*** 3086,3121 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_AWK="$ac_prog"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  AWK=$ac_cv_prog_AWK
  if test -n "$AWK"; then
!   { echo "$as_me:$LINENO: result: $AWK" >&5
! echo "${ECHO_T}$AWK" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
    test -n "$AWK" && break
  done
  
! { echo "$as_me:$LINENO: checking whether ${MAKE-make} sets \$(MAKE)" >&5
! echo $ECHO_N "checking whether ${MAKE-make} sets \$(MAKE)... $ECHO_C" >&6; }
! set x ${MAKE-make}; ac_make=`echo "$2" | sed 's/+/p/g; s/[^a-zA-Z0-9_]/_/g'`
! if { as_var=ac_cv_prog_make_${ac_make}_set; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    cat >conftest.make <<\_ACEOF
  SHELL = /bin/sh
--- 3287,3323 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_AWK="$ac_prog"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  AWK=$ac_cv_prog_AWK
  if test -n "$AWK"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $AWK" >&5
! $as_echo "$AWK" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
    test -n "$AWK" && break
  done
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether ${MAKE-make} sets \$(MAKE)" >&5
! $as_echo_n "checking whether ${MAKE-make} sets \$(MAKE)... " >&6; }
! set x ${MAKE-make}
! ac_make=`$as_echo "$2" | sed 's/+/p/g; s/[^a-zA-Z0-9_]/_/g'`
! if { as_var=ac_cv_prog_make_${ac_make}_set; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
  else
    cat >conftest.make <<\_ACEOF
  SHELL = /bin/sh
***************
*** 3132,3143 ****
  rm -f conftest.make
  fi
  if eval test \$ac_cv_prog_make_${ac_make}_set = yes; then
!   { echo "$as_me:$LINENO: result: yes" >&5
! echo "${ECHO_T}yes" >&6; }
    SET_MAKE=
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
    SET_MAKE="MAKE=${MAKE-make}"
  fi
  
--- 3334,3345 ----
  rm -f conftest.make
  fi
  if eval test \$ac_cv_prog_make_${ac_make}_set = yes; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: yes" >&5
! $as_echo "yes" >&6; }
    SET_MAKE=
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
    SET_MAKE="MAKE=${MAKE-make}"
  fi
  
***************
*** 3146,3155 ****
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_TAR+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$TAR"; then
    ac_cv_prog_TAR="$TAR" # Let the user override the test.
--- 3348,3357 ----
  do
    # Extract the first word of "$ac_prog", so it can be a program name with args.
  set dummy $ac_prog; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_TAR+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$TAR"; then
    ac_cv_prog_TAR="$TAR" # Let the user override the test.
***************
*** 3159,3183 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_TAR="$ac_prog"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  TAR=$ac_cv_prog_TAR
  if test -n "$TAR"; then
!   { echo "$as_me:$LINENO: result: $TAR" >&5
! echo "${ECHO_T}$TAR" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 3361,3385 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_TAR="$ac_prog"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  TAR=$ac_cv_prog_TAR
  if test -n "$TAR"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $TAR" >&5
! $as_echo "$TAR" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 3187,3196 ****
  
  # Extract the first word of "perl", so it can be a program name with args.
  set dummy perl; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_PERL+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test -n "$PERL"; then
    ac_cv_prog_PERL="$PERL" # Let the user override the test.
--- 3389,3398 ----
  
  # Extract the first word of "perl", so it can be a program name with args.
  set dummy perl; ac_word=$2
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_word" >&5
! $as_echo_n "checking for $ac_word... " >&6; }
! if test "${ac_cv_prog_PERL+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test -n "$PERL"; then
    ac_cv_prog_PERL="$PERL" # Let the user override the test.
***************
*** 3200,3224 ****
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_PERL="perl"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
! done
  IFS=$as_save_IFS
  
  fi
  fi
  PERL=$ac_cv_prog_PERL
  if test -n "$PERL"; then
!   { echo "$as_me:$LINENO: result: $PERL" >&5
! echo "${ECHO_T}$PERL" >&6; }
  else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
--- 3402,3426 ----
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_test_x "$as_dir/$ac_word$ac_exec_ext"; }; then
      ac_cv_prog_PERL="perl"
!     $as_echo "$as_me:${as_lineno-$LINENO}: found $as_dir/$ac_word$ac_exec_ext" >&5
      break 2
    fi
  done
!   done
  IFS=$as_save_IFS
  
  fi
  fi
  PERL=$ac_cv_prog_PERL
  if test -n "$PERL"; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: $PERL" >&5
! $as_echo "$PERL" >&6; }
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
! $as_echo "no" >&6; }
  fi
  
  
***************
*** 3230,3244 ****
  ac_compile='$CC -c $CFLAGS $CPPFLAGS conftest.$ac_ext >&5'
  ac_link='$CC -o conftest$ac_exeext $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS >&5'
  ac_compiler_gnu=$ac_cv_c_compiler_gnu
! { echo "$as_me:$LINENO: checking how to run the C preprocessor" >&5
! echo $ECHO_N "checking how to run the C preprocessor... $ECHO_C" >&6; }
  # On Suns, sometimes $CPP names a directory.
  if test -n "$CPP" && test -d "$CPP"; then
    CPP=
  fi
  if test -z "$CPP"; then
!   if test "${ac_cv_prog_CPP+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
        # Double quotes because CPP needs to be expanded
      for CPP in "$CC -E" "$CC -E -traditional-cpp" "/lib/cpp"
--- 3432,3446 ----
  ac_compile='$CC -c $CFLAGS $CPPFLAGS conftest.$ac_ext >&5'
  ac_link='$CC -o conftest$ac_exeext $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS >&5'
  ac_compiler_gnu=$ac_cv_c_compiler_gnu
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking how to run the C preprocessor" >&5
! $as_echo_n "checking how to run the C preprocessor... " >&6; }
  # On Suns, sometimes $CPP names a directory.
  if test -n "$CPP" && test -d "$CPP"; then
    CPP=
  fi
  if test -z "$CPP"; then
!   if test "${ac_cv_prog_CPP+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
        # Double quotes because CPP needs to be expanded
      for CPP in "$CC -E" "$CC -E -traditional-cpp" "/lib/cpp"
***************
*** 3252,3262 ****
    # <limits.h> exists even on freestanding compilers.
    # On the NeXT, cc -E runs the code through the compiler's parser,
    # not just through cpp. "Syntax error" is here to catch this case.
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #ifdef __STDC__
  # include <limits.h>
--- 3454,3460 ----
    # <limits.h> exists even on freestanding compilers.
    # On the NeXT, cc -E runs the code through the compiler's parser,
    # not just through cpp. "Syntax error" is here to catch this case.
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #ifdef __STDC__
  # include <limits.h>
***************
*** 3265,3354 ****
  #endif
  		     Syntax error
  _ACEOF
! if { (ac_try="$ac_cpp conftest.$ac_ext"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_cpp conftest.$ac_ext") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } >/dev/null; then
!   if test -s conftest.err; then
!     ac_cpp_err=$ac_c_preproc_warn_flag
!     ac_cpp_err=$ac_cpp_err$ac_c_werror_flag
!   else
!     ac_cpp_err=
!   fi
! else
!   ac_cpp_err=yes
! fi
! if test -z "$ac_cpp_err"; then
!   :
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
    # Broken: fails on valid input.
  continue
  fi
- 
  rm -f conftest.err conftest.$ac_ext
  
    # OK, works on sane cases.  Now check whether nonexistent headers
    # can be detected and how.
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <ac_nonexistent.h>
  _ACEOF
! if { (ac_try="$ac_cpp conftest.$ac_ext"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_cpp conftest.$ac_ext") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } >/dev/null; then
!   if test -s conftest.err; then
!     ac_cpp_err=$ac_c_preproc_warn_flag
!     ac_cpp_err=$ac_cpp_err$ac_c_werror_flag
!   else
!     ac_cpp_err=
!   fi
! else
!   ac_cpp_err=yes
! fi
! if test -z "$ac_cpp_err"; then
    # Broken: success on invalid input.
  continue
  else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
    # Passes both tests.
  ac_preproc_ok=:
  break
  fi
- 
  rm -f conftest.err conftest.$ac_ext
  
  done
  # Because of `break', _AC_PREPROC_IFELSE's cleaning code was skipped.
  rm -f conftest.err conftest.$ac_ext
! if $ac_preproc_ok; then
    break
  fi
  
--- 3463,3496 ----
  #endif
  		     Syntax error
  _ACEOF
! if ac_fn_c_try_cpp "$LINENO"; then :
  
+ else
    # Broken: fails on valid input.
  continue
  fi
  rm -f conftest.err conftest.$ac_ext
  
    # OK, works on sane cases.  Now check whether nonexistent headers
    # can be detected and how.
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <ac_nonexistent.h>
  _ACEOF
! if ac_fn_c_try_cpp "$LINENO"; then :
    # Broken: success on invalid input.
  continue
  else
    # Passes both tests.
  ac_preproc_ok=:
  break
  fi
  rm -f conftest.err conftest.$ac_ext
  
  done
  # Because of `break', _AC_PREPROC_IFELSE's cleaning code was skipped.
  rm -f conftest.err conftest.$ac_ext
! if $ac_preproc_ok; then :
    break
  fi
  
***************
*** 3360,3367 ****
  else
    ac_cv_prog_CPP=$CPP
  fi
! { echo "$as_me:$LINENO: result: $CPP" >&5
! echo "${ECHO_T}$CPP" >&6; }
  ac_preproc_ok=false
  for ac_c_preproc_warn_flag in '' yes
  do
--- 3502,3509 ----
  else
    ac_cv_prog_CPP=$CPP
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $CPP" >&5
! $as_echo "$CPP" >&6; }
  ac_preproc_ok=false
  for ac_c_preproc_warn_flag in '' yes
  do
***************
*** 3371,3381 ****
    # <limits.h> exists even on freestanding compilers.
    # On the NeXT, cc -E runs the code through the compiler's parser,
    # not just through cpp. "Syntax error" is here to catch this case.
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #ifdef __STDC__
  # include <limits.h>
--- 3513,3519 ----
    # <limits.h> exists even on freestanding compilers.
    # On the NeXT, cc -E runs the code through the compiler's parser,
    # not just through cpp. "Syntax error" is here to catch this case.
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #ifdef __STDC__
  # include <limits.h>
***************
*** 3384,3480 ****
  #endif
  		     Syntax error
  _ACEOF
! if { (ac_try="$ac_cpp conftest.$ac_ext"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_cpp conftest.$ac_ext") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } >/dev/null; then
!   if test -s conftest.err; then
!     ac_cpp_err=$ac_c_preproc_warn_flag
!     ac_cpp_err=$ac_cpp_err$ac_c_werror_flag
!   else
!     ac_cpp_err=
!   fi
! else
!   ac_cpp_err=yes
! fi
! if test -z "$ac_cpp_err"; then
!   :
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
    # Broken: fails on valid input.
  continue
  fi
- 
  rm -f conftest.err conftest.$ac_ext
  
    # OK, works on sane cases.  Now check whether nonexistent headers
    # can be detected and how.
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <ac_nonexistent.h>
  _ACEOF
! if { (ac_try="$ac_cpp conftest.$ac_ext"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_cpp conftest.$ac_ext") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } >/dev/null; then
!   if test -s conftest.err; then
!     ac_cpp_err=$ac_c_preproc_warn_flag
!     ac_cpp_err=$ac_cpp_err$ac_c_werror_flag
!   else
!     ac_cpp_err=
!   fi
! else
!   ac_cpp_err=yes
! fi
! if test -z "$ac_cpp_err"; then
    # Broken: success on invalid input.
  continue
  else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
    # Passes both tests.
  ac_preproc_ok=:
  break
  fi
- 
  rm -f conftest.err conftest.$ac_ext
  
  done
  # Because of `break', _AC_PREPROC_IFELSE's cleaning code was skipped.
  rm -f conftest.err conftest.$ac_ext
! if $ac_preproc_ok; then
!   :
  else
!   { { echo "$as_me:$LINENO: error: C preprocessor \"$CPP\" fails sanity check
! See \`config.log' for more details." >&5
! echo "$as_me: error: C preprocessor \"$CPP\" fails sanity check
! See \`config.log' for more details." >&2;}
!    { (exit 1); exit 1; }; }
  fi
  
  ac_ext=c
--- 3522,3561 ----
  #endif
  		     Syntax error
  _ACEOF
! if ac_fn_c_try_cpp "$LINENO"; then :
  
+ else
    # Broken: fails on valid input.
  continue
  fi
  rm -f conftest.err conftest.$ac_ext
  
    # OK, works on sane cases.  Now check whether nonexistent headers
    # can be detected and how.
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <ac_nonexistent.h>
  _ACEOF
! if ac_fn_c_try_cpp "$LINENO"; then :
    # Broken: success on invalid input.
  continue
  else
    # Passes both tests.
  ac_preproc_ok=:
  break
  fi
  rm -f conftest.err conftest.$ac_ext
  
  done
  # Because of `break', _AC_PREPROC_IFELSE's cleaning code was skipped.
  rm -f conftest.err conftest.$ac_ext
! if $ac_preproc_ok; then :
! 
  else
!   { { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
! $as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
! as_fn_error "C preprocessor \"$CPP\" fails sanity check
! See \`config.log' for more details." "$LINENO" 5; }
  fi
  
  ac_ext=c
***************
*** 3484,3528 ****
  ac_compiler_gnu=$ac_cv_c_compiler_gnu
  
  
! { echo "$as_me:$LINENO: checking for grep that handles long lines and -e" >&5
! echo $ECHO_N "checking for grep that handles long lines and -e... $ECHO_C" >&6; }
! if test "${ac_cv_path_GREP+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   # Extract the first word of "grep ggrep" to use in msg output
! if test -z "$GREP"; then
! set dummy grep ggrep; ac_prog_name=$2
! if test "${ac_cv_path_GREP+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_path_GREP_found=false
! # Loop through the user's path and test for each of PROGNAME-LIST
! as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH$PATH_SEPARATOR/usr/xpg4/bin
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_prog in grep ggrep; do
!   for ac_exec_ext in '' $ac_executable_extensions; do
!     ac_path_GREP="$as_dir/$ac_prog$ac_exec_ext"
!     { test -f "$ac_path_GREP" && $as_executable_p "$ac_path_GREP"; } || continue
!     # Check for GNU ac_path_GREP and select it if it is found.
    # Check for GNU $ac_path_GREP
  case `"$ac_path_GREP" --version 2>&1` in
  *GNU*)
    ac_cv_path_GREP="$ac_path_GREP" ac_path_GREP_found=:;;
  *)
    ac_count=0
!   echo $ECHO_N "0123456789$ECHO_C" >"conftest.in"
    while :
    do
      cat "conftest.in" "conftest.in" >"conftest.tmp"
      mv "conftest.tmp" "conftest.in"
      cp "conftest.in" "conftest.nl"
!     echo 'GREP' >> "conftest.nl"
      "$ac_path_GREP" -e 'GREP$' -e '-(cannot match)-' < "conftest.nl" >"conftest.out" 2>/dev/null || break
      diff "conftest.out" "conftest.nl" >/dev/null 2>&1 || break
!     ac_count=`expr $ac_count + 1`
      if test $ac_count -gt ${ac_path_GREP_max-0}; then
        # Best one so far, save it but keep looking for a better one
        ac_cv_path_GREP="$ac_path_GREP"
--- 3565,3604 ----
  ac_compiler_gnu=$ac_cv_c_compiler_gnu
  
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for grep that handles long lines and -e" >&5
! $as_echo_n "checking for grep that handles long lines and -e... " >&6; }
! if test "${ac_cv_path_GREP+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
+   if test -z "$GREP"; then
    ac_path_GREP_found=false
!   # Loop through the user's path and test for each of PROGNAME-LIST
!   as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH$PATH_SEPARATOR/usr/xpg4/bin
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_prog in grep ggrep; do
!     for ac_exec_ext in '' $ac_executable_extensions; do
!       ac_path_GREP="$as_dir/$ac_prog$ac_exec_ext"
!       { test -f "$ac_path_GREP" && $as_test_x "$ac_path_GREP"; } || continue
! # Check for GNU ac_path_GREP and select it if it is found.
    # Check for GNU $ac_path_GREP
  case `"$ac_path_GREP" --version 2>&1` in
  *GNU*)
    ac_cv_path_GREP="$ac_path_GREP" ac_path_GREP_found=:;;
  *)
    ac_count=0
!   $as_echo_n 0123456789 >"conftest.in"
    while :
    do
      cat "conftest.in" "conftest.in" >"conftest.tmp"
      mv "conftest.tmp" "conftest.in"
      cp "conftest.in" "conftest.nl"
!     $as_echo 'GREP' >> "conftest.nl"
      "$ac_path_GREP" -e 'GREP$' -e '-(cannot match)-' < "conftest.nl" >"conftest.out" 2>/dev/null || break
      diff "conftest.out" "conftest.nl" >/dev/null 2>&1 || break
!     as_fn_arith $ac_count + 1 && ac_count=$as_val
      if test $ac_count -gt ${ac_path_GREP_max-0}; then
        # Best one so far, save it but keep looking for a better one
        ac_cv_path_GREP="$ac_path_GREP"
***************
*** 3534,3610 ****
    rm -f conftest.in conftest.tmp conftest.nl conftest.out;;
  esac
  
! 
!     $ac_path_GREP_found && break 3
    done
- done
- 
- done
  IFS=$as_save_IFS
! 
! 
! fi
! 
! GREP="$ac_cv_path_GREP"
! if test -z "$GREP"; then
!   { { echo "$as_me:$LINENO: error: no acceptable $ac_prog_name could be found in $PATH$PATH_SEPARATOR/usr/xpg4/bin" >&5
! echo "$as_me: error: no acceptable $ac_prog_name could be found in $PATH$PATH_SEPARATOR/usr/xpg4/bin" >&2;}
!    { (exit 1); exit 1; }; }
! fi
! 
  else
    ac_cv_path_GREP=$GREP
  fi
  
- 
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_path_GREP" >&5
! echo "${ECHO_T}$ac_cv_path_GREP" >&6; }
   GREP="$ac_cv_path_GREP"
  
  
! { echo "$as_me:$LINENO: checking for egrep" >&5
! echo $ECHO_N "checking for egrep... $ECHO_C" >&6; }
! if test "${ac_cv_path_EGREP+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if echo a | $GREP -E '(a|b)' >/dev/null 2>&1
     then ac_cv_path_EGREP="$GREP -E"
     else
!      # Extract the first word of "egrep" to use in msg output
! if test -z "$EGREP"; then
! set dummy egrep; ac_prog_name=$2
! if test "${ac_cv_path_EGREP+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
    ac_path_EGREP_found=false
! # Loop through the user's path and test for each of PROGNAME-LIST
! as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH$PATH_SEPARATOR/usr/xpg4/bin
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   for ac_prog in egrep; do
!   for ac_exec_ext in '' $ac_executable_extensions; do
!     ac_path_EGREP="$as_dir/$ac_prog$ac_exec_ext"
!     { test -f "$ac_path_EGREP" && $as_executable_p "$ac_path_EGREP"; } || continue
!     # Check for GNU ac_path_EGREP and select it if it is found.
    # Check for GNU $ac_path_EGREP
  case `"$ac_path_EGREP" --version 2>&1` in
  *GNU*)
    ac_cv_path_EGREP="$ac_path_EGREP" ac_path_EGREP_found=:;;
  *)
    ac_count=0
!   echo $ECHO_N "0123456789$ECHO_C" >"conftest.in"
    while :
    do
      cat "conftest.in" "conftest.in" >"conftest.tmp"
      mv "conftest.tmp" "conftest.in"
      cp "conftest.in" "conftest.nl"
!     echo 'EGREP' >> "conftest.nl"
      "$ac_path_EGREP" 'EGREP$' < "conftest.nl" >"conftest.out" 2>/dev/null || break
      diff "conftest.out" "conftest.nl" >/dev/null 2>&1 || break
!     ac_count=`expr $ac_count + 1`
      if test $ac_count -gt ${ac_path_EGREP_max-0}; then
        # Best one so far, save it but keep looking for a better one
        ac_cv_path_EGREP="$ac_path_EGREP"
--- 3610,3670 ----
    rm -f conftest.in conftest.tmp conftest.nl conftest.out;;
  esac
  
!       $ac_path_GREP_found && break 3
!     done
!   done
    done
  IFS=$as_save_IFS
!   if test -z "$ac_cv_path_GREP"; then
!     as_fn_error "no acceptable grep could be found in $PATH$PATH_SEPARATOR/usr/xpg4/bin" "$LINENO" 5
!   fi
  else
    ac_cv_path_GREP=$GREP
  fi
  
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_path_GREP" >&5
! $as_echo "$ac_cv_path_GREP" >&6; }
   GREP="$ac_cv_path_GREP"
  
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for egrep" >&5
! $as_echo_n "checking for egrep... " >&6; }
! if test "${ac_cv_path_EGREP+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if echo a | $GREP -E '(a|b)' >/dev/null 2>&1
     then ac_cv_path_EGREP="$GREP -E"
     else
!      if test -z "$EGREP"; then
    ac_path_EGREP_found=false
!   # Loop through the user's path and test for each of PROGNAME-LIST
!   as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH$PATH_SEPARATOR/usr/xpg4/bin
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     for ac_prog in egrep; do
!     for ac_exec_ext in '' $ac_executable_extensions; do
!       ac_path_EGREP="$as_dir/$ac_prog$ac_exec_ext"
!       { test -f "$ac_path_EGREP" && $as_test_x "$ac_path_EGREP"; } || continue
! # Check for GNU ac_path_EGREP and select it if it is found.
    # Check for GNU $ac_path_EGREP
  case `"$ac_path_EGREP" --version 2>&1` in
  *GNU*)
    ac_cv_path_EGREP="$ac_path_EGREP" ac_path_EGREP_found=:;;
  *)
    ac_count=0
!   $as_echo_n 0123456789 >"conftest.in"
    while :
    do
      cat "conftest.in" "conftest.in" >"conftest.tmp"
      mv "conftest.tmp" "conftest.in"
      cp "conftest.in" "conftest.nl"
!     $as_echo 'EGREP' >> "conftest.nl"
      "$ac_path_EGREP" 'EGREP$' < "conftest.nl" >"conftest.out" 2>/dev/null || break
      diff "conftest.out" "conftest.nl" >/dev/null 2>&1 || break
!     as_fn_arith $ac_count + 1 && ac_count=$as_val
      if test $ac_count -gt ${ac_path_EGREP_max-0}; then
        # Best one so far, save it but keep looking for a better one
        ac_cv_path_EGREP="$ac_path_EGREP"
***************
*** 3616,3661 ****
    rm -f conftest.in conftest.tmp conftest.nl conftest.out;;
  esac
  
! 
!     $ac_path_EGREP_found && break 3
    done
- done
- 
- done
  IFS=$as_save_IFS
! 
! 
! fi
! 
! EGREP="$ac_cv_path_EGREP"
! if test -z "$EGREP"; then
!   { { echo "$as_me:$LINENO: error: no acceptable $ac_prog_name could be found in $PATH$PATH_SEPARATOR/usr/xpg4/bin" >&5
! echo "$as_me: error: no acceptable $ac_prog_name could be found in $PATH$PATH_SEPARATOR/usr/xpg4/bin" >&2;}
!    { (exit 1); exit 1; }; }
! fi
! 
  else
    ac_cv_path_EGREP=$EGREP
  fi
  
- 
     fi
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_path_EGREP" >&5
! echo "${ECHO_T}$ac_cv_path_EGREP" >&6; }
   EGREP="$ac_cv_path_EGREP"
  
  
! { echo "$as_me:$LINENO: checking for ANSI C header files" >&5
! echo $ECHO_N "checking for ANSI C header files... $ECHO_C" >&6; }
! if test "${ac_cv_header_stdc+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <stdlib.h>
  #include <stdarg.h>
--- 3676,3706 ----
    rm -f conftest.in conftest.tmp conftest.nl conftest.out;;
  esac
  
!       $ac_path_EGREP_found && break 3
!     done
!   done
    done
  IFS=$as_save_IFS
!   if test -z "$ac_cv_path_EGREP"; then
!     as_fn_error "no acceptable egrep could be found in $PATH$PATH_SEPARATOR/usr/xpg4/bin" "$LINENO" 5
!   fi
  else
    ac_cv_path_EGREP=$EGREP
  fi
  
     fi
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_path_EGREP" >&5
! $as_echo "$ac_cv_path_EGREP" >&6; }
   EGREP="$ac_cv_path_EGREP"
  
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for ANSI C header files" >&5
! $as_echo_n "checking for ANSI C header files... " >&6; }
! if test "${ac_cv_header_stdc+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <stdlib.h>
  #include <stdarg.h>
***************
*** 3670,3733 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_header_stdc=yes
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_header_stdc=no
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  
  if test $ac_cv_header_stdc = yes; then
    # SunOS 4.x string.h does not declare mem*, contrary to ANSI.
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <string.h>
  
  _ACEOF
  if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
!   $EGREP "memchr" >/dev/null 2>&1; then
!   :
  else
    ac_cv_header_stdc=no
  fi
--- 3715,3737 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
    ac_cv_header_stdc=yes
  else
!   ac_cv_header_stdc=no
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  
  if test $ac_cv_header_stdc = yes; then
    # SunOS 4.x string.h does not declare mem*, contrary to ANSI.
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <string.h>
  
  _ACEOF
  if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
!   $EGREP "memchr" >/dev/null 2>&1; then :
! 
  else
    ac_cv_header_stdc=no
  fi
***************
*** 3737,3754 ****
  
  if test $ac_cv_header_stdc = yes; then
    # ISC 2.0.2 stdlib.h does not declare free, contrary to ANSI.
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <stdlib.h>
  
  _ACEOF
  if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
!   $EGREP "free" >/dev/null 2>&1; then
!   :
  else
    ac_cv_header_stdc=no
  fi
--- 3741,3754 ----
  
  if test $ac_cv_header_stdc = yes; then
    # ISC 2.0.2 stdlib.h does not declare free, contrary to ANSI.
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <stdlib.h>
  
  _ACEOF
  if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
!   $EGREP "free" >/dev/null 2>&1; then :
! 
  else
    ac_cv_header_stdc=no
  fi
***************
*** 3758,3771 ****
  
  if test $ac_cv_header_stdc = yes; then
    # /bin/cc in Irix-4.0.5 gets non-ANSI ctype macros unless using -ansi.
!   if test "$cross_compiling" = yes; then
    :
  else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <ctype.h>
  #include <stdlib.h>
--- 3758,3767 ----
  
  if test $ac_cv_header_stdc = yes; then
    # /bin/cc in Irix-4.0.5 gets non-ANSI ctype macros unless using -ansi.
!   if test "$cross_compiling" = yes; then :
    :
  else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <ctype.h>
  #include <stdlib.h>
***************
*** 3792,3860 ****
    return 0;
  }
  _ACEOF
! rm -f conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   :
! else
!   echo "$as_me: program exited with status $ac_status" >&5
! echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
! ( exit $ac_status )
! ac_cv_header_stdc=no
  fi
! rm -f core *.core core.conftest.* gmon.out bb.out conftest$ac_exeext conftest.$ac_objext conftest.$ac_ext
  fi
  
- 
  fi
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_header_stdc" >&5
! echo "${ECHO_T}$ac_cv_header_stdc" >&6; }
  if test $ac_cv_header_stdc = yes; then
  
! cat >>confdefs.h <<\_ACEOF
! #define STDC_HEADERS 1
! _ACEOF
  
  fi
  
- 
- 
- 
- 
- 
  ac_header_dirent=no
  for ac_hdr in dirent.h sys/ndir.h sys/dir.h ndir.h; do
!   as_ac_Header=`echo "ac_cv_header_dirent_$ac_hdr" | $as_tr_sh`
! { echo "$as_me:$LINENO: checking for $ac_hdr that defines DIR" >&5
! echo $ECHO_N "checking for $ac_hdr that defines DIR... $ECHO_C" >&6; }
! if { as_var=$as_ac_Header; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <sys/types.h>
  #include <$ac_hdr>
--- 3788,3821 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_run "$LINENO"; then :
  
! else
!   ac_cv_header_stdc=no
  fi
! rm -f core *.core core.conftest.* gmon.out bb.out conftest$ac_exeext \
!   conftest.$ac_objext conftest.beam conftest.$ac_ext
  fi
  
  fi
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_header_stdc" >&5
! $as_echo "$ac_cv_header_stdc" >&6; }
  if test $ac_cv_header_stdc = yes; then
  
! $as_echo "#define STDC_HEADERS 1" >>confdefs.h
  
  fi
  
  ac_header_dirent=no
  for ac_hdr in dirent.h sys/ndir.h sys/dir.h ndir.h; do
!   as_ac_Header=`$as_echo "ac_cv_header_dirent_$ac_hdr" | $as_tr_sh`
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for $ac_hdr that defines DIR" >&5
! $as_echo_n "checking for $ac_hdr that defines DIR... " >&6; }
! if { as_var=$as_ac_Header; eval "test \"\${$as_var+set}\" = set"; }; then :
!   $as_echo_n "(cached) " >&6
  else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <sys/types.h>
  #include <$ac_hdr>
***************
*** 3868,3923 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    eval "$as_ac_Header=yes"
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	eval "$as_ac_Header=no"
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
! ac_res=`eval echo '${'$as_ac_Header'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
! if test `eval echo '${'$as_ac_Header'}'` = yes; then
    cat >>confdefs.h <<_ACEOF
! #define `echo "HAVE_$ac_hdr" | $as_tr_cpp` 1
  _ACEOF
  
  ac_header_dirent=$ac_hdr; break
--- 3829,3848 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
    eval "$as_ac_Header=yes"
  else
!   eval "$as_ac_Header=no"
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
! eval ac_res=\$$as_ac_Header
! 	       { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_res" >&5
! $as_echo "$ac_res" >&6; }
! eval as_val=\$$as_ac_Header
!    if test "x$as_val" = x""yes; then :
    cat >>confdefs.h <<_ACEOF
! #define `$as_echo "HAVE_$ac_hdr" | $as_tr_cpp` 1
  _ACEOF
  
  ac_header_dirent=$ac_hdr; break
***************
*** 3926,3942 ****
  done
  # Two versions of opendir et al. are in -ldir and -lx on SCO Xenix.
  if test $ac_header_dirent = dirent.h; then
!   { echo "$as_me:$LINENO: checking for library containing opendir" >&5
! echo $ECHO_N "checking for library containing opendir... $ECHO_C" >&6; }
! if test "${ac_cv_search_opendir+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_func_search_save_LIBS=$LIBS
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
--- 3851,3863 ----
  done
  # Two versions of opendir et al. are in -ldir and -lx on SCO Xenix.
  if test $ac_header_dirent = dirent.h; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for library containing opendir" >&5
! $as_echo_n "checking for library containing opendir... " >&6; }
! if test "${ac_cv_search_opendir+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    ac_func_search_save_LIBS=$LIBS
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
***************
*** 3961,4042 ****
      ac_res=-l$ac_lib
      LIBS="-l$ac_lib  $ac_func_search_save_LIBS"
    fi
!   rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_search_opendir=$ac_res
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
- 
  fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext
!   if test "${ac_cv_search_opendir+set}" = set; then
    break
  fi
  done
! if test "${ac_cv_search_opendir+set}" = set; then
!   :
  else
    ac_cv_search_opendir=no
  fi
  rm conftest.$ac_ext
  LIBS=$ac_func_search_save_LIBS
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_search_opendir" >&5
! echo "${ECHO_T}$ac_cv_search_opendir" >&6; }
  ac_res=$ac_cv_search_opendir
! if test "$ac_res" != no; then
    test "$ac_res" = "none required" || LIBS="$ac_res $LIBS"
  
  fi
  
  else
!   { echo "$as_me:$LINENO: checking for library containing opendir" >&5
! echo $ECHO_N "checking for library containing opendir... $ECHO_C" >&6; }
! if test "${ac_cv_search_opendir+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_func_search_save_LIBS=$LIBS
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
--- 3882,3920 ----
      ac_res=-l$ac_lib
      LIBS="-l$ac_lib  $ac_func_search_save_LIBS"
    fi
!   if ac_fn_c_try_link "$LINENO"; then :
    ac_cv_search_opendir=$ac_res
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext
!   if test "${ac_cv_search_opendir+set}" = set; then :
    break
  fi
  done
! if test "${ac_cv_search_opendir+set}" = set; then :
! 
  else
    ac_cv_search_opendir=no
  fi
  rm conftest.$ac_ext
  LIBS=$ac_func_search_save_LIBS
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_search_opendir" >&5
! $as_echo "$ac_cv_search_opendir" >&6; }
  ac_res=$ac_cv_search_opendir
! if test "$ac_res" != no; then :
    test "$ac_res" = "none required" || LIBS="$ac_res $LIBS"
  
  fi
  
  else
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for library containing opendir" >&5
! $as_echo_n "checking for library containing opendir... " >&6; }
! if test "${ac_cv_search_opendir+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    ac_func_search_save_LIBS=$LIBS
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
***************
*** 4061,4142 ****
      ac_res=-l$ac_lib
      LIBS="-l$ac_lib  $ac_func_search_save_LIBS"
    fi
!   rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_search_opendir=$ac_res
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
- 
- 
  fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext
!   if test "${ac_cv_search_opendir+set}" = set; then
    break
  fi
  done
! if test "${ac_cv_search_opendir+set}" = set; then
!   :
  else
    ac_cv_search_opendir=no
  fi
  rm conftest.$ac_ext
  LIBS=$ac_func_search_save_LIBS
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_search_opendir" >&5
! echo "${ECHO_T}$ac_cv_search_opendir" >&6; }
  ac_res=$ac_cv_search_opendir
! if test "$ac_res" != no; then
    test "$ac_res" = "none required" || LIBS="$ac_res $LIBS"
  
  fi
  
  fi
  
! { echo "$as_me:$LINENO: checking whether time.h and sys/time.h may both be included" >&5
! echo $ECHO_N "checking whether time.h and sys/time.h may both be included... $ECHO_C" >&6; }
! if test "${ac_cv_header_time+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  #include <sys/types.h>
  #include <sys/time.h>
--- 3939,3977 ----
      ac_res=-l$ac_lib
      LIBS="-l$ac_lib  $ac_func_search_save_LIBS"
    fi
!   if ac_fn_c_try_link "$LINENO"; then :
    ac_cv_search_opendir=$ac_res
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext
!   if test "${ac_cv_search_opendir+set}" = set; then :
    break
  fi
  done
! if test "${ac_cv_search_opendir+set}" = set; then :
! 
  else
    ac_cv_search_opendir=no
  fi
  rm conftest.$ac_ext
  LIBS=$ac_func_search_save_LIBS
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_search_opendir" >&5
! $as_echo "$ac_cv_search_opendir" >&6; }
  ac_res=$ac_cv_search_opendir
! if test "$ac_res" != no; then :
    test "$ac_res" = "none required" || LIBS="$ac_res $LIBS"
  
  fi
  
  fi
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether time.h and sys/time.h may both be included" >&5
! $as_echo_n "checking whether time.h and sys/time.h may both be included... " >&6; }
! if test "${ac_cv_header_time+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  #include <sys/types.h>
  #include <sys/time.h>
***************
*** 4151,5821 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_header_time=yes
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_header_time=no
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_header_time" >&5
! echo "${ECHO_T}$ac_cv_header_time" >&6; }
  if test $ac_cv_header_time = yes; then
  
! cat >>confdefs.h <<\_ACEOF
! #define TIME_WITH_SYS_TIME 1
! _ACEOF
  
  fi
  
  # On IRIX 5.3, sys/types and inttypes.h are conflicting.
- 
- 
- 
- 
- 
- 
- 
- 
- 
  for ac_header in sys/types.h sys/stat.h stdlib.h string.h memory.h strings.h \
  		  inttypes.h stdint.h unistd.h
! do
! as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
! { echo "$as_me:$LINENO: checking for $ac_header" >&5
! echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6; }
! if { as_var=$as_ac_Header; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! $ac_includes_default
! 
! #include <$ac_header>
  _ACEOF
- rm -f conftest.$ac_objext
- if { (ac_try="$ac_compile"
- case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_compile") 2>conftest.er1
-   ac_status=$?
-   grep -v '^ *+' conftest.er1 >conftest.err
-   rm -f conftest.er1
-   cat conftest.err >&5
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); } &&
- 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; } &&
- 	 { ac_try='test -s conftest.$ac_objext'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; }; then
-   eval "$as_ac_Header=yes"
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
  
- 	eval "$as_ac_Header=no"
  fi
  
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! ac_res=`eval echo '${'$as_ac_Header'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
! if test `eval echo '${'$as_ac_Header'}'` = yes; then
    cat >>confdefs.h <<_ACEOF
! #define `echo "HAVE_$ac_header" | $as_tr_cpp` 1
  _ACEOF
  
  fi
  
  done
  
  
  
  
  
  
! for ac_header in sys/time.h sys/param.h sys/statvfs.h sys/vfs.h
! do
! as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
! if { as_var=$as_ac_Header; eval "test \"\${$as_var+set}\" = set"; }; then
!   { echo "$as_me:$LINENO: checking for $ac_header" >&5
! echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6; }
! if { as_var=$as_ac_Header; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! fi
! ac_res=`eval echo '${'$as_ac_Header'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
  else
!   # Is the header compilable?
! { echo "$as_me:$LINENO: checking $ac_header usability" >&5
! echo $ECHO_N "checking $ac_header usability... $ECHO_C" >&6; }
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
! $ac_includes_default
! #include <$ac_header>
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_header_compiler=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_header_compiler=no
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! { echo "$as_me:$LINENO: result: $ac_header_compiler" >&5
! echo "${ECHO_T}$ac_header_compiler" >&6; }
! 
! # Is the header present?
! { echo "$as_me:$LINENO: checking $ac_header presence" >&5
! echo $ECHO_N "checking $ac_header presence... $ECHO_C" >&6; }
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! #include <$ac_header>
! _ACEOF
! if { (ac_try="$ac_cpp conftest.$ac_ext"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_cpp conftest.$ac_ext") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } >/dev/null; then
!   if test -s conftest.err; then
!     ac_cpp_err=$ac_c_preproc_warn_flag
!     ac_cpp_err=$ac_cpp_err$ac_c_werror_flag
!   else
!     ac_cpp_err=
!   fi
! else
!   ac_cpp_err=yes
! fi
! if test -z "$ac_cpp_err"; then
!   ac_header_preproc=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
!   ac_header_preproc=no
! fi
! 
! rm -f conftest.err conftest.$ac_ext
! { echo "$as_me:$LINENO: result: $ac_header_preproc" >&5
! echo "${ECHO_T}$ac_header_preproc" >&6; }
! 
! # So?  What about this header?
! case $ac_header_compiler:$ac_header_preproc:$ac_c_preproc_warn_flag in
!   yes:no: )
!     { echo "$as_me:$LINENO: WARNING: $ac_header: accepted by the compiler, rejected by the preprocessor!" >&5
! echo "$as_me: WARNING: $ac_header: accepted by the compiler, rejected by the preprocessor!" >&2;}
!     { echo "$as_me:$LINENO: WARNING: $ac_header: proceeding with the compiler's result" >&5
! echo "$as_me: WARNING: $ac_header: proceeding with the compiler's result" >&2;}
!     ac_header_preproc=yes
!     ;;
!   no:yes:* )
!     { echo "$as_me:$LINENO: WARNING: $ac_header: present but cannot be compiled" >&5
! echo "$as_me: WARNING: $ac_header: present but cannot be compiled" >&2;}
!     { echo "$as_me:$LINENO: WARNING: $ac_header:     check for missing prerequisite headers?" >&5
! echo "$as_me: WARNING: $ac_header:     check for missing prerequisite headers?" >&2;}
!     { echo "$as_me:$LINENO: WARNING: $ac_header: see the Autoconf documentation" >&5
! echo "$as_me: WARNING: $ac_header: see the Autoconf documentation" >&2;}
!     { echo "$as_me:$LINENO: WARNING: $ac_header:     section \"Present But Cannot Be Compiled\"" >&5
! echo "$as_me: WARNING: $ac_header:     section \"Present But Cannot Be Compiled\"" >&2;}
!     { echo "$as_me:$LINENO: WARNING: $ac_header: proceeding with the preprocessor's result" >&5
! echo "$as_me: WARNING: $ac_header: proceeding with the preprocessor's result" >&2;}
!     { echo "$as_me:$LINENO: WARNING: $ac_header: in the future, the compiler will take precedence" >&5
! echo "$as_me: WARNING: $ac_header: in the future, the compiler will take precedence" >&2;}
! 
!     ;;
! esac
! { echo "$as_me:$LINENO: checking for $ac_header" >&5
! echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6; }
! if { as_var=$as_ac_Header; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   eval "$as_ac_Header=\$ac_header_preproc"
! fi
! ac_res=`eval echo '${'$as_ac_Header'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
! 
! fi
! if test `eval echo '${'$as_ac_Header'}'` = yes; then
!   cat >>confdefs.h <<_ACEOF
! #define `echo "HAVE_$ac_header" | $as_tr_cpp` 1
! _ACEOF
! 
! fi
! 
! done
! 
! 
! for ac_header in sys/mount.h
! do
! as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
! { echo "$as_me:$LINENO: checking for $ac_header" >&5
! echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6; }
! if { as_var=$as_ac_Header; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! 
! #if SYS_PARAM_H
! #include <sys/param.h>
! #endif
! 
! 
! #include <$ac_header>
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   eval "$as_ac_Header=yes"
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	eval "$as_ac_Header=no"
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! ac_res=`eval echo '${'$as_ac_Header'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
! if test `eval echo '${'$as_ac_Header'}'` = yes; then
!   cat >>confdefs.h <<_ACEOF
! #define `echo "HAVE_$ac_header" | $as_tr_cpp` 1
! _ACEOF
! 
! fi
! 
! done
! 
! 
! 
! 
! { echo "$as_me:$LINENO: checking whether struct tm is in sys/time.h or time.h" >&5
! echo $ECHO_N "checking whether struct tm is in sys/time.h or time.h... $ECHO_C" >&6; }
! if test "${ac_cv_struct_tm+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! #include <sys/types.h>
! #include <time.h>
! 
! int
! main ()
! {
! struct tm *tp; tp->tm_sec;
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_struct_tm=time.h
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_struct_tm=sys/time.h
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! { echo "$as_me:$LINENO: result: $ac_cv_struct_tm" >&5
! echo "${ECHO_T}$ac_cv_struct_tm" >&6; }
! if test $ac_cv_struct_tm = sys/time.h; then
! 
! cat >>confdefs.h <<\_ACEOF
! #define TM_IN_SYS_TIME 1
! _ACEOF
! 
! fi
! 
! { echo "$as_me:$LINENO: checking for struct tm.tm_zone" >&5
! echo $ECHO_N "checking for struct tm.tm_zone... $ECHO_C" >&6; }
! if test "${ac_cv_member_struct_tm_tm_zone+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! #include <sys/types.h>
! #include <$ac_cv_struct_tm>
! 
! 
! int
! main ()
! {
! static struct tm ac_aggr;
! if (ac_aggr.tm_zone)
! return 0;
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_member_struct_tm_tm_zone=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! #include <sys/types.h>
! #include <$ac_cv_struct_tm>
! 
! 
! int
! main ()
! {
! static struct tm ac_aggr;
! if (sizeof ac_aggr.tm_zone)
! return 0;
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_member_struct_tm_tm_zone=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_member_struct_tm_tm_zone=no
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! { echo "$as_me:$LINENO: result: $ac_cv_member_struct_tm_tm_zone" >&5
! echo "${ECHO_T}$ac_cv_member_struct_tm_tm_zone" >&6; }
! if test $ac_cv_member_struct_tm_tm_zone = yes; then
! 
! cat >>confdefs.h <<_ACEOF
! #define HAVE_STRUCT_TM_TM_ZONE 1
! _ACEOF
! 
! 
! fi
! 
! if test "$ac_cv_member_struct_tm_tm_zone" = yes; then
! 
! cat >>confdefs.h <<\_ACEOF
! #define HAVE_TM_ZONE 1
! _ACEOF
! 
! else
!   { echo "$as_me:$LINENO: checking whether tzname is declared" >&5
! echo $ECHO_N "checking whether tzname is declared... $ECHO_C" >&6; }
! if test "${ac_cv_have_decl_tzname+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! #include <time.h>
! 
! int
! main ()
! {
! #ifndef tzname
!   char *p = (char *) tzname;
!   return !p;
! #endif
! 
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_have_decl_tzname=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_have_decl_tzname=no
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! { echo "$as_me:$LINENO: result: $ac_cv_have_decl_tzname" >&5
! echo "${ECHO_T}$ac_cv_have_decl_tzname" >&6; }
! if test $ac_cv_have_decl_tzname = yes; then
! 
! cat >>confdefs.h <<_ACEOF
! #define HAVE_DECL_TZNAME 1
! _ACEOF
! 
! 
! else
!   cat >>confdefs.h <<_ACEOF
! #define HAVE_DECL_TZNAME 0
! _ACEOF
! 
! 
! fi
! 
! 
!   { echo "$as_me:$LINENO: checking for tzname" >&5
! echo $ECHO_N "checking for tzname... $ECHO_C" >&6; }
! if test "${ac_cv_var_tzname+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! #include <time.h>
! #if !HAVE_DECL_TZNAME
! extern char *tzname[];
! #endif
! 
! int
! main ()
! {
! return tzname[0][0];
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_var_tzname=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_var_tzname=no
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
! fi
! { echo "$as_me:$LINENO: result: $ac_cv_var_tzname" >&5
! echo "${ECHO_T}$ac_cv_var_tzname" >&6; }
!   if test $ac_cv_var_tzname = yes; then
! 
! cat >>confdefs.h <<\_ACEOF
! #define HAVE_TZNAME 1
! _ACEOF
! 
!   fi
! fi
! 
! { echo "$as_me:$LINENO: checking for struct stat.st_blocks" >&5
! echo $ECHO_N "checking for struct stat.st_blocks... $ECHO_C" >&6; }
! if test "${ac_cv_member_struct_stat_st_blocks+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! $ac_includes_default
! int
! main ()
! {
! static struct stat ac_aggr;
! if (ac_aggr.st_blocks)
! return 0;
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_member_struct_stat_st_blocks=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! $ac_includes_default
! int
! main ()
! {
! static struct stat ac_aggr;
! if (sizeof ac_aggr.st_blocks)
! return 0;
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_member_struct_stat_st_blocks=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_member_struct_stat_st_blocks=no
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
! fi
! { echo "$as_me:$LINENO: result: $ac_cv_member_struct_stat_st_blocks" >&5
! echo "${ECHO_T}$ac_cv_member_struct_stat_st_blocks" >&6; }
! if test $ac_cv_member_struct_stat_st_blocks = yes; then
! 
! cat >>confdefs.h <<_ACEOF
! #define HAVE_STRUCT_STAT_ST_BLOCKS 1
! _ACEOF
! 
! 
! cat >>confdefs.h <<\_ACEOF
! #define HAVE_ST_BLOCKS 1
! _ACEOF
! 
! else
!   case " $LIBOBJS " in
!   *" fileblocks.$ac_objext "* ) ;;
!   *) LIBOBJS="$LIBOBJS fileblocks.$ac_objext"
!  ;;
! esac
! 
! fi
! 
! 
! { echo "$as_me:$LINENO: checking for struct stat.st_blksize" >&5
! echo $ECHO_N "checking for struct stat.st_blksize... $ECHO_C" >&6; }
! if test "${ac_cv_member_struct_stat_st_blksize+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! $ac_includes_default
! int
! main ()
! {
! static struct stat ac_aggr;
! if (ac_aggr.st_blksize)
! return 0;
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_member_struct_stat_st_blksize=yes
! else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
- 	cat >conftest.$ac_ext <<_ACEOF
- /* confdefs.h.  */
- _ACEOF
- cat confdefs.h >>conftest.$ac_ext
- cat >>conftest.$ac_ext <<_ACEOF
- /* end confdefs.h.  */
- $ac_includes_default
  int
  main ()
  {
! static struct stat ac_aggr;
! if (sizeof ac_aggr.st_blksize)
! return 0;
    ;
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext
! if { (ac_try="$ac_compile"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_compile") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest.$ac_objext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_member_struct_stat_st_blksize=yes
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_member_struct_stat_st_blksize=no
  fi
- 
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
  
- rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
- { echo "$as_me:$LINENO: result: $ac_cv_member_struct_stat_st_blksize" >&5
- echo "${ECHO_T}$ac_cv_member_struct_stat_st_blksize" >&6; }
- if test $ac_cv_member_struct_stat_st_blksize = yes; then
  
! cat >>confdefs.h <<_ACEOF
! #define HAVE_STRUCT_STAT_ST_BLKSIZE 1
! _ACEOF
  
  
! cat >>confdefs.h <<\_ACEOF
! #define HAVE_ST_BLKSIZE 1
  _ACEOF
  
- fi
- 
- 
  
  
  
  
- { echo "$as_me:$LINENO: checking for libraries containing socket functions" >&5
- echo $ECHO_N "checking for libraries containing socket functions... $ECHO_C" >&6; }
- if test "${ac_cv_socket_libs+set}" = set; then
-   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
! 
!         oCFLAGS=$CFLAGS
! 
!         cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! 
! #include <sys/types.h>
! #include <sys/socket.h>
! #include <netinet/in.h>
! #include <arpa/inet.h>
! 
! int
! main ()
! {
! 
!                         struct in_addr add;
!                         int sd = socket(AF_INET, SOCK_STREAM, 0);
!                         inet_ntoa(add);
! 
!   ;
!   return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_socket_libs=-lc
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_socket_libs=no
  fi
  
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
! 
!         if test x"$ac_cv_socket_libs" = "xno"
!         then
!                 CFLAGS="$oCFLAGS -lsocket"
!                 cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
  _ACEOF
- cat confdefs.h >>conftest.$ac_ext
- cat >>conftest.$ac_ext <<_ACEOF
- /* end confdefs.h.  */
  
! #include <sys/types.h>
! #include <sys/socket.h>
! #include <netinet/in.h>
! #include <arpa/inet.h>
  
  int
  main ()
  {
! 
!                                 struct in_addr add;
!                                 int sd = socket(AF_INET, SOCK_STREAM, 0);
!                                 inet_ntoa(add);
! 
    ;
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   ac_cv_socket_libs=-lsocket
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
! 	ac_cv_socket_libs=no
  fi
  
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
!         fi
  
!         if test x"$ac_cv_socket_libs" = "xno"
!         then
!                 CFLAGS="$oCFLAGS -lsocket -lnsl"
!                 cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
  _ACEOF
- cat confdefs.h >>conftest.$ac_ext
- cat >>conftest.$ac_ext <<_ACEOF
- /* end confdefs.h.  */
- 
- #include <sys/types.h>
- #include <sys/socket.h>
- #include <netinet/in.h>
- #include <arpa/inet.h>
  
- int
- main ()
- {
  
!                                 struct in_addr add;
!                                 int sd = socket(AF_INET, SOCK_STREAM, 0);
!                                 inet_ntoa(add);
  
-   ;
-   return 0;
- }
- _ACEOF
- rm -f conftest.$ac_objext conftest$ac_exeext
- if { (ac_try="$ac_link"
- case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_link") 2>conftest.er1
-   ac_status=$?
-   grep -v '^ *+' conftest.er1 >conftest.err
-   rm -f conftest.er1
-   cat conftest.err >&5
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); } &&
- 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; } &&
- 	 { ac_try='test -s conftest$ac_exeext'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; }; then
-   ac_cv_socket_libs="-lsocket -lnsl"
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
  
- 	ac_cv_socket_libs=no
  fi
  
- rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
-       conftest$ac_exeext conftest.$ac_ext
-         fi
- 
-         CFLAGS=$oCFLAGS
  
! fi
! { echo "$as_me:$LINENO: result: $ac_cv_socket_libs" >&5
! echo "${ECHO_T}$ac_cv_socket_libs" >&6; }
  
!         if test x"$ac_cv_socket_libs" = "xno"
!         then
!                 { { echo "$as_me:$LINENO: error: Cannot find socket libraries" >&5
! echo "$as_me: error: Cannot find socket libraries" >&2;}
!    { (exit 1); exit 1; }; }
!         elif test x"$ac_cv_socket_libs" = "x-lc"
!         then
!                 ETR_SOCKET_LIBS=""
!         else
!                 ETR_SOCKET_LIBS="$ac_cv_socket_libs"
!         fi
  
  
  
  
- LIBS="$LIBS $ETR_SOCKET_LIBS"
  
  
  
  
  
! for ac_func in getaddrinfo getnameinfo
! do
! as_ac_var=`echo "ac_cv_func_$ac_func" | $as_tr_sh`
! { echo "$as_me:$LINENO: checking for $ac_func" >&5
! echo $ECHO_N "checking for $ac_func... $ECHO_C" >&6; }
! if { as_var=$as_ac_var; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
-   cat >conftest.$ac_ext <<_ACEOF
- /* confdefs.h.  */
- _ACEOF
- cat confdefs.h >>conftest.$ac_ext
- cat >>conftest.$ac_ext <<_ACEOF
- /* end confdefs.h.  */
- /* Define $ac_func to an innocuous variant, in case <limits.h> declares $ac_func.
-    For example, HP-UX 11i <limits.h> declares gettimeofday.  */
- #define $ac_func innocuous_$ac_func
- 
- /* System header to define __stub macros and hopefully few prototypes,
-     which can conflict with char $ac_func (); below.
-     Prefer <limits.h> to <assert.h> if __STDC__ is defined, since
-     <limits.h> exists even on freestanding compilers.  */
  
! #ifdef __STDC__
! # include <limits.h>
! #else
! # include <assert.h>
! #endif
  
! #undef $ac_func
  
! /* Override any GCC internal prototype to avoid an error.
!    Use char because int might match the return type of a GCC
!    builtin and then its argument prototype would still apply.  */
! #ifdef __cplusplus
! extern "C"
! #endif
! char $ac_func ();
! /* The GNU C library defines this for functions which it implements
!     to always fail with ENOSYS.  Some functions are actually named
!     something starting with __ and the normal name is an alias.  */
! #if defined __stub_$ac_func || defined __stub___$ac_func
! choke me
! #endif
  
  int
  main ()
  {
- return $ac_func ();
-   ;
-   return 0;
- }
- _ACEOF
- rm -f conftest.$ac_objext conftest$ac_exeext
- if { (ac_try="$ac_link"
- case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_link") 2>conftest.er1
-   ac_status=$?
-   grep -v '^ *+' conftest.er1 >conftest.err
-   rm -f conftest.er1
-   cat conftest.err >&5
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); } &&
- 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; } &&
- 	 { ac_try='test -s conftest$ac_exeext'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; }; then
-   eval "$as_ac_var=yes"
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
  
! 	eval "$as_ac_var=no"
! fi
  
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
! fi
! ac_res=`eval echo '${'$as_ac_var'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
! if test `eval echo '${'$as_ac_var'}'` = yes; then
!   cat >>confdefs.h <<_ACEOF
! #define `echo "HAVE_$ac_func" | $as_tr_cpp` 1
  _ACEOF
! 
  fi
! done
! 
  
  
  
! for ac_func in statfs statvfs
! do
! as_ac_var=`echo "ac_cv_func_$ac_func" | $as_tr_sh`
! { echo "$as_me:$LINENO: checking for $ac_func" >&5
! echo $ECHO_N "checking for $ac_func... $ECHO_C" >&6; }
! if { as_var=$as_ac_var; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
! /* end confdefs.h.  */
! /* Define $ac_func to an innocuous variant, in case <limits.h> declares $ac_func.
!    For example, HP-UX 11i <limits.h> declares gettimeofday.  */
! #define $ac_func innocuous_$ac_func
  
! /* System header to define __stub macros and hopefully few prototypes,
!     which can conflict with char $ac_func (); below.
!     Prefer <limits.h> to <assert.h> if __STDC__ is defined, since
!     <limits.h> exists even on freestanding compilers.  */
  
! #ifdef __STDC__
! # include <limits.h>
! #else
! # include <assert.h>
! #endif
  
! #undef $ac_func
  
! /* Override any GCC internal prototype to avoid an error.
!    Use char because int might match the return type of a GCC
!    builtin and then its argument prototype would still apply.  */
! #ifdef __cplusplus
! extern "C"
! #endif
! char $ac_func ();
! /* The GNU C library defines this for functions which it implements
!     to always fail with ENOSYS.  Some functions are actually named
!     something starting with __ and the normal name is an alias.  */
! #if defined __stub_$ac_func || defined __stub___$ac_func
! choke me
! #endif
  
  int
  main ()
  {
! return $ac_func ();
    ;
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
!   eval "$as_ac_var=yes"
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	eval "$as_ac_var=no"
! fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
! fi
! ac_res=`eval echo '${'$as_ac_var'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
! if test `eval echo '${'$as_ac_var'}'` = yes; then
!   cat >>confdefs.h <<_ACEOF
! #define `echo "HAVE_$ac_func" | $as_tr_cpp` 1
! _ACEOF
! 
  fi
! done
  
  
- if test "$ac_cv_func_statfs" = "no"; then
-     if test "$ac_cv_func_statvfs" = "no"; then
-         { { echo "$as_me:$LINENO: error: Neither of the two functions statfs or statvfs are available" >&5
- echo "$as_me: error: Neither of the two functions statfs or statvfs are available" >&2;}
-    { (exit 1); exit 1; }; }
-     fi
  fi
  
  
  
  
  
  
  
  
! for ac_func in setresuid setresgid getresuid getresgid setreuid setregid setgroups
! do
! as_ac_var=`echo "ac_cv_func_$ac_func" | $as_tr_sh`
! { echo "$as_me:$LINENO: checking for $ac_func" >&5
! echo $ECHO_N "checking for $ac_func... $ECHO_C" >&6; }
! if { as_var=$as_ac_var; eval "test \"\${$as_var+set}\" = set"; }; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
  _ACEOF
- cat confdefs.h >>conftest.$ac_ext
- cat >>conftest.$ac_ext <<_ACEOF
- /* end confdefs.h.  */
- /* Define $ac_func to an innocuous variant, in case <limits.h> declares $ac_func.
-    For example, HP-UX 11i <limits.h> declares gettimeofday.  */
- #define $ac_func innocuous_$ac_func
- 
- /* System header to define __stub macros and hopefully few prototypes,
-     which can conflict with char $ac_func (); below.
-     Prefer <limits.h> to <assert.h> if __STDC__ is defined, since
-     <limits.h> exists even on freestanding compilers.  */
- 
- #ifdef __STDC__
- # include <limits.h>
- #else
- # include <assert.h>
- #endif
  
! #undef $ac_func
  
- /* Override any GCC internal prototype to avoid an error.
-    Use char because int might match the return type of a GCC
-    builtin and then its argument prototype would still apply.  */
- #ifdef __cplusplus
- extern "C"
- #endif
- char $ac_func ();
- /* The GNU C library defines this for functions which it implements
-     to always fail with ENOSYS.  Some functions are actually named
-     something starting with __ and the normal name is an alias.  */
- #if defined __stub_$ac_func || defined __stub___$ac_func
- choke me
- #endif
  
! int
! main ()
! {
! return $ac_func ();
!   ;
!   return 0;
! }
  _ACEOF
- rm -f conftest.$ac_objext conftest$ac_exeext
- if { (ac_try="$ac_link"
- case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_link") 2>conftest.er1
-   ac_status=$?
-   grep -v '^ *+' conftest.er1 >conftest.err
-   rm -f conftest.er1
-   cat conftest.err >&5
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); } &&
- 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; } &&
- 	 { ac_try='test -s conftest$ac_exeext'
-   { (case "(($ac_try" in
-   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
-   *) ac_try_echo=$ac_try;;
- esac
- eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
-   (eval "$ac_try") 2>&5
-   ac_status=$?
-   echo "$as_me:$LINENO: \$? = $ac_status" >&5
-   (exit $ac_status); }; }; then
-   eval "$as_ac_var=yes"
- else
-   echo "$as_me: failed program was:" >&5
- sed 's/^/| /' conftest.$ac_ext >&5
  
- 	eval "$as_ac_var=no"
  fi
  
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
  fi
! ac_res=`eval echo '${'$as_ac_var'}'`
! 	       { echo "$as_me:$LINENO: result: $ac_res" >&5
! echo "${ECHO_T}$ac_res" >&6; }
! if test `eval echo '${'$as_ac_var'}'` = yes; then
    cat >>confdefs.h <<_ACEOF
! #define `echo "HAVE_$ac_func" | $as_tr_cpp` 1
  _ACEOF
  
  fi
--- 3986,4362 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
    ac_cv_header_time=yes
  else
!   ac_cv_header_time=no
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_header_time" >&5
! $as_echo "$ac_cv_header_time" >&6; }
  if test $ac_cv_header_time = yes; then
  
! $as_echo "#define TIME_WITH_SYS_TIME 1" >>confdefs.h
  
  fi
  
  # On IRIX 5.3, sys/types and inttypes.h are conflicting.
  for ac_header in sys/types.h sys/stat.h stdlib.h string.h memory.h strings.h \
  		  inttypes.h stdint.h unistd.h
! do :
!   as_ac_Header=`$as_echo "ac_cv_header_$ac_header" | $as_tr_sh`
! ac_fn_c_check_header_compile "$LINENO" "$ac_header" "$as_ac_Header" "$ac_includes_default
! "
! eval as_val=\$$as_ac_Header
!    if test "x$as_val" = x""yes; then :
!   cat >>confdefs.h <<_ACEOF
! #define `$as_echo "HAVE_$ac_header" | $as_tr_cpp` 1
  _ACEOF
  
  fi
  
! done
! 
! 
! for ac_header in sys/time.h sys/param.h sys/statvfs.h sys/vfs.h
! do :
!   as_ac_Header=`$as_echo "ac_cv_header_$ac_header" | $as_tr_sh`
! ac_fn_c_check_header_mongrel "$LINENO" "$ac_header" "$as_ac_Header" "$ac_includes_default"
! eval as_val=\$$as_ac_Header
!    if test "x$as_val" = x""yes; then :
    cat >>confdefs.h <<_ACEOF
! #define `$as_echo "HAVE_$ac_header" | $as_tr_cpp` 1
  _ACEOF
  
  fi
  
  done
  
+ for ac_header in sys/mount.h
+ do :
+   ac_fn_c_check_header_compile "$LINENO" "sys/mount.h" "ac_cv_header_sys_mount_h" "
+ #if SYS_PARAM_H
+ #include <sys/param.h>
+ #endif
+ 
+ "
+ if test "x$ac_cv_header_sys_mount_h" = x""yes; then :
+   cat >>confdefs.h <<_ACEOF
+ #define HAVE_SYS_MOUNT_H 1
+ _ACEOF
  
+ fi
  
+ done
  
  
  
! 
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking whether struct tm is in sys/time.h or time.h" >&5
! $as_echo_n "checking whether struct tm is in sys/time.h or time.h... " >&6; }
! if test "${ac_cv_struct_tm+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
! #include <sys/types.h>
! #include <time.h>
  
  int
  main ()
  {
! struct tm tm;
! 				     int *p = &tm.tm_sec;
! 				     return !p;
    ;
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_compile "$LINENO"; then :
!   ac_cv_struct_tm=time.h
  else
!   ac_cv_struct_tm=sys/time.h
  fi
  rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
  fi
+ { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_struct_tm" >&5
+ $as_echo "$ac_cv_struct_tm" >&6; }
+ if test $ac_cv_struct_tm = sys/time.h; then
+ 
+ $as_echo "#define TM_IN_SYS_TIME 1" >>confdefs.h
  
  fi
  
! ac_fn_c_check_member "$LINENO" "struct tm" "tm_zone" "ac_cv_member_struct_tm_tm_zone" "#include <sys/types.h>
! #include <$ac_cv_struct_tm>
  
+ "
+ if test "x$ac_cv_member_struct_tm_tm_zone" = x""yes; then :
  
! cat >>confdefs.h <<_ACEOF
! #define HAVE_STRUCT_TM_TM_ZONE 1
  _ACEOF
  
  
+ fi
  
+ if test "$ac_cv_member_struct_tm_tm_zone" = yes; then
  
+ $as_echo "#define HAVE_TM_ZONE 1" >>confdefs.h
  
  else
!   ac_fn_c_check_decl "$LINENO" "tzname" "ac_cv_have_decl_tzname" "#include <time.h>
! "
! if test "x$ac_cv_have_decl_tzname" = x""yes; then :
!   ac_have_decl=1
  else
!   ac_have_decl=0
  fi
  
! cat >>confdefs.h <<_ACEOF
! #define HAVE_DECL_TZNAME $ac_have_decl
  _ACEOF
  
!   { $as_echo "$as_me:${as_lineno-$LINENO}: checking for tzname" >&5
! $as_echo_n "checking for tzname... " >&6; }
! if test "${ac_cv_var_tzname+set}" = set; then :
!   $as_echo_n "(cached) " >&6
! else
!   cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
! #include <time.h>
! #if !HAVE_DECL_TZNAME
! extern char *tzname[];
! #endif
  
  int
  main ()
  {
! return tzname[0][0];
    ;
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
!   ac_cv_var_tzname=yes
  else
!   ac_cv_var_tzname=no
! fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
! fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_var_tzname" >&5
! $as_echo "$ac_cv_var_tzname" >&6; }
!   if test $ac_cv_var_tzname = yes; then
! 
! $as_echo "#define HAVE_TZNAME 1" >>confdefs.h
  
!   fi
  fi
  
! ac_fn_c_check_member "$LINENO" "struct stat" "st_blocks" "ac_cv_member_struct_stat_st_blocks" "$ac_includes_default"
! if test "x$ac_cv_member_struct_stat_st_blocks" = x""yes; then :
  
! cat >>confdefs.h <<_ACEOF
! #define HAVE_STRUCT_STAT_ST_BLOCKS 1
  _ACEOF
  
  
! $as_echo "#define HAVE_ST_BLOCKS 1" >>confdefs.h
  
  else
!   case " $LIBOBJS " in
!   *" fileblocks.$ac_objext "* ) ;;
!   *) LIBOBJS="$LIBOBJS fileblocks.$ac_objext"
!  ;;
! esac
  
  fi
  
  
! ac_fn_c_check_member "$LINENO" "struct stat" "st_blksize" "ac_cv_member_struct_stat_st_blksize" "$ac_includes_default"
! if test "x$ac_cv_member_struct_stat_st_blksize" = x""yes; then :
  
! cat >>confdefs.h <<_ACEOF
! #define HAVE_STRUCT_STAT_ST_BLKSIZE 1
! _ACEOF
  
  
+ $as_echo "#define HAVE_ST_BLKSIZE 1" >>confdefs.h
  
+ fi
  
  
  
  
  
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking for libraries containing socket functions" >&5
! $as_echo_n "checking for libraries containing socket functions... " >&6; }
! if test "${ac_cv_socket_libs+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
  
!         oCFLAGS=$CFLAGS
  
!         cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
  
! #include <sys/types.h>
! #include <sys/socket.h>
! #include <netinet/in.h>
! #include <arpa/inet.h>
  
  int
  main ()
  {
  
!                         struct in_addr add;
!                         int sd = socket(AF_INET, SOCK_STREAM, 0);
!                         inet_ntoa(add);
  
!   ;
!   return 0;
! }
  _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
!   ac_cv_socket_libs=-lc
! else
!   ac_cv_socket_libs=no
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
  
+         if test x"$ac_cv_socket_libs" = "xno"
+         then
+                 CFLAGS="$oCFLAGS -lsocket"
+                 cat confdefs.h - <<_ACEOF >conftest.$ac_ext
+ /* end confdefs.h.  */
  
+ #include <sys/types.h>
+ #include <sys/socket.h>
+ #include <netinet/in.h>
+ #include <arpa/inet.h>
  
! int
! main ()
! {
  
!                                 struct in_addr add;
!                                 int sd = socket(AF_INET, SOCK_STREAM, 0);
!                                 inet_ntoa(add);
  
!   ;
!   return 0;
! }
! _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
!   ac_cv_socket_libs=-lsocket
! else
!   ac_cv_socket_libs=no
! fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
!         fi
  
!         if test x"$ac_cv_socket_libs" = "xno"
!         then
!                 CFLAGS="$oCFLAGS -lsocket -lnsl"
!                 cat confdefs.h - <<_ACEOF >conftest.$ac_ext
! /* end confdefs.h.  */
  
! #include <sys/types.h>
! #include <sys/socket.h>
! #include <netinet/in.h>
! #include <arpa/inet.h>
  
  int
  main ()
  {
! 
!                                 struct in_addr add;
!                                 int sd = socket(AF_INET, SOCK_STREAM, 0);
!                                 inet_ntoa(add);
! 
    ;
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
!   ac_cv_socket_libs="-lsocket -lnsl"
  else
!   ac_cv_socket_libs=no
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
!         fi
  
+         CFLAGS=$oCFLAGS
  
  fi
+ { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_socket_libs" >&5
+ $as_echo "$ac_cv_socket_libs" >&6; }
  
+         if test x"$ac_cv_socket_libs" = "xno"
+         then
+                 as_fn_error "Cannot find socket libraries" "$LINENO" 5
+         elif test x"$ac_cv_socket_libs" = "x-lc"
+         then
+                 ETR_SOCKET_LIBS=""
+         else
+                 ETR_SOCKET_LIBS="$ac_cv_socket_libs"
+         fi
  
  
  
  
+ LIBS="$LIBS $ETR_SOCKET_LIBS"
  
  
  
! for ac_func in getaddrinfo getnameinfo
! do :
!   as_ac_var=`$as_echo "ac_cv_func_$ac_func" | $as_tr_sh`
! ac_fn_c_check_func "$LINENO" "$ac_func" "$as_ac_var"
! eval as_val=\$$as_ac_var
!    if test "x$as_val" = x""yes; then :
!   cat >>confdefs.h <<_ACEOF
! #define `$as_echo "HAVE_$ac_func" | $as_tr_cpp` 1
  _ACEOF
  
! fi
! done
  
  
! for ac_func in statfs statvfs
! do :
!   as_ac_var=`$as_echo "ac_cv_func_$ac_func" | $as_tr_sh`
! ac_fn_c_check_func "$LINENO" "$ac_func" "$as_ac_var"
! eval as_val=\$$as_ac_var
!    if test "x$as_val" = x""yes; then :
!   cat >>confdefs.h <<_ACEOF
! #define `$as_echo "HAVE_$ac_func" | $as_tr_cpp` 1
  _ACEOF
  
  fi
+ done
+ 
  
! if test "$ac_cv_func_statfs" = "no"; then
!     if test "$ac_cv_func_statvfs" = "no"; then
!         as_fn_error "Neither of the two functions statfs or statvfs are available" "$LINENO" 5
!     fi
  fi
! 
! for ac_func in setresuid setresgid getresuid getresgid setreuid setregid setgroups
! do :
!   as_ac_var=`$as_echo "ac_cv_func_$ac_func" | $as_tr_sh`
! ac_fn_c_check_func "$LINENO" "$ac_func" "$as_ac_var"
! eval as_val=\$$as_ac_var
!    if test "x$as_val" = x""yes; then :
    cat >>confdefs.h <<_ACEOF
! #define `$as_echo "HAVE_$ac_func" | $as_tr_cpp` 1
  _ACEOF
  
  fi
***************
*** 5826,5832 ****
  
  
  # Check whether --with-zlib was given.
! if test "${with_zlib+set}" = set; then
    withval=$with_zlib; WITH_ZLIB=$withval
  else
    WITH_ZLIB=yes
--- 4367,4373 ----
  
  
  # Check whether --with-zlib was given.
! if test "${with_zlib+set}" = set; then :
    withval=$with_zlib; WITH_ZLIB=$withval
  else
    WITH_ZLIB=yes
***************
*** 5850,5867 ****
        USE_ZLIB=1
     fi
  
!    { echo "$as_me:$LINENO: checking for zlibVersion in -lz" >&5
! echo $ECHO_N "checking for zlibVersion in -lz... $ECHO_C" >&6; }
! if test "${ac_cv_lib_z_zlibVersion+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_check_lib_save_LIBS=$LIBS
  LIBS="-lz $ZLIB_LIB $LIBS"
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
--- 4391,4424 ----
        USE_ZLIB=1
     fi
  
!    for ac_header in zlib.h
! do :
!   ac_fn_c_check_header_mongrel "$LINENO" "zlib.h" "ac_cv_header_zlib_h" "$ac_includes_default"
! if test "x$ac_cv_header_zlib_h" = x""yes; then :
!   cat >>confdefs.h <<_ACEOF
! #define HAVE_ZLIB_H 1
! _ACEOF
!  HAVE_ZLIB_H=yes
! fi
! 
! done
! 
! 
!    if test "$HAVE_ZLIB_H" = ""; then
!       { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: Cannot find zlib.h header file; configuring without compression support" >&5
! $as_echo "$as_me: WARNING: Cannot find zlib.h header file; configuring without compression support" >&2;}
!       ZLIB_LIB=
!       ZLIB_INC=
!       USE_ZLIB=0
!    else
!       { $as_echo "$as_me:${as_lineno-$LINENO}: checking for zlibVersion in -lz" >&5
! $as_echo_n "checking for zlibVersion in -lz... " >&6; }
! if test "${ac_cv_lib_z_zlibVersion+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    ac_check_lib_save_LIBS=$LIBS
  LIBS="-lz $ZLIB_LIB $LIBS"
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
***************
*** 5879,5945 ****
    return 0;
  }
  _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_lib_z_zlibVersion=yes
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_lib_z_zlibVersion=no
  fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
  LIBS=$ac_check_lib_save_LIBS
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_lib_z_zlibVersion" >&5
! echo "${ECHO_T}$ac_cv_lib_z_zlibVersion" >&6; }
! if test $ac_cv_lib_z_zlibVersion = yes; then
    WITH_ZLIB=yes
  else
    WITH_ZLIB=no
  fi
  
  
!    if test "$WITH_ZLIB" = "no"; then
!       { echo "$as_me:$LINENO: WARNING: Cannot find working libz library, configuring without compression support" >&5
! echo "$as_me: WARNING: Cannot find working libz library, configuring without compression support" >&2;}
!       ZLIB_LIB=
!       ZLIB_INC=
!       USE_ZLIB=0
     fi
  fi
  
--- 4436,4466 ----
    return 0;
  }
  _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
    ac_cv_lib_z_zlibVersion=yes
  else
!   ac_cv_lib_z_zlibVersion=no
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
  LIBS=$ac_check_lib_save_LIBS
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_lib_z_zlibVersion" >&5
! $as_echo "$ac_cv_lib_z_zlibVersion" >&6; }
! if test "x$ac_cv_lib_z_zlibVersion" = x""yes; then :
    WITH_ZLIB=yes
  else
    WITH_ZLIB=no
  fi
  
  
!       if test "$WITH_ZLIB" = "no"; then
!          { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: Cannot find working libz library; configuring without compression support" >&5
! $as_echo "$as_me: WARNING: Cannot find working libz library; configuring without compression support" >&2;}
!          ZLIB_LIB=
!          ZLIB_INC=
!          USE_ZLIB=0
!       fi
     fi
  fi
  
***************
*** 5955,5961 ****
  
  
  # Check whether --with-gnutls was given.
! if test "${with_gnutls+set}" = set; then
    withval=$with_gnutls; WITH_GNUTLS=$withval
  else
    WITH_GNUTLS=no
--- 4476,4482 ----
  
  
  # Check whether --with-gnutls was given.
! if test "${with_gnutls+set}" = set; then :
    withval=$with_gnutls; WITH_GNUTLS=$withval
  else
    WITH_GNUTLS=no
***************
*** 5968,6047 ****
     USE_GNUTLS=0
  else
     if test "$WITH_GNUTLS" = "yes"; then
!       # Extract the first word of "libgnutls-config", so it can be a program name with args.
! set dummy libgnutls-config; ac_word=$2
! { echo "$as_me:$LINENO: checking for $ac_word" >&5
! echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6; }
! if test "${ac_cv_prog_LIBGNUTLS_CONFIG+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
! else
!   if test -n "$LIBGNUTLS_CONFIG"; then
!   ac_cv_prog_LIBGNUTLS_CONFIG="$LIBGNUTLS_CONFIG" # Let the user override the test.
! else
! as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
! for as_dir in $PATH
! do
!   IFS=$as_save_IFS
!   test -z "$as_dir" && as_dir=.
!   for ac_exec_ext in '' $ac_executable_extensions; do
!   if { test -f "$as_dir/$ac_word$ac_exec_ext" && $as_executable_p "$as_dir/$ac_word$ac_exec_ext"; }; then
!     ac_cv_prog_LIBGNUTLS_CONFIG="libgnutls-config"
!     echo "$as_me:$LINENO: found $as_dir/$ac_word$ac_exec_ext" >&5
!     break 2
!   fi
! done
! done
! IFS=$as_save_IFS
  
! fi
! fi
! LIBGNUTLS_CONFIG=$ac_cv_prog_LIBGNUTLS_CONFIG
! if test -n "$LIBGNUTLS_CONFIG"; then
!   { echo "$as_me:$LINENO: result: $LIBGNUTLS_CONFIG" >&5
! echo "${ECHO_T}$LIBGNUTLS_CONFIG" >&6; }
! else
!   { echo "$as_me:$LINENO: result: no" >&5
! echo "${ECHO_T}no" >&6; }
  fi
  
  
  
!       if test "$LIBGNUTLS_CONFIG" = ""; then
!          { echo "$as_me:$LINENO: WARNING: Cannot find libgnutls-config program, configuring without SSL/https support" >&5
! echo "$as_me: WARNING: Cannot find libgnutls-config program, configuring without SSL/https support" >&2;}
!          WITH_LIBGNUTLS_CONFIG=0
!       else
!          WITH_LIBGNUTLS_CONFIG=1
!       fi
     else
!       LIBGNUTLS_CONFIG="$WITH_GNUTLS/bin/libgnutls-config"
! 
!       if test -x "$LIBGNUTLS_CONFIG" ; then
!          WITH_LIBGNUTLS_CONFIG=1
!       else
!          { echo "$as_me:$LINENO: WARNING: Cannot find $WITH_GNUTLS/bin/libgnutls-config program, configuring without SSL/https support" >&5
! echo "$as_me: WARNING: Cannot find $WITH_GNUTLS/bin/libgnutls-config program, configuring without SSL/https support" >&2;}
!          WITH_LIBGNUTLS_CONFIG=0
!       fi
!    fi
! 
!    if test "$WITH_LIBGNUTLS_CONFIG" = "1"; then
!       GNUTLS_LIB=`$LIBGNUTLS_CONFIG --libs`
!       GNUTLS_INC=`$LIBGNUTLS_CONFIG --cflags`
!       USE_GNUTLS=1
! 
!       { echo "$as_me:$LINENO: checking for gnutls_check_version in -lgnutls" >&5
! echo $ECHO_N "checking for gnutls_check_version in -lgnutls... $ECHO_C" >&6; }
! if test "${ac_cv_lib_gnutls_gnutls_check_version+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_check_lib_save_LIBS=$LIBS
  LIBS="-lgnutls $GNUTLS_LIB $LIBS"
! cat >conftest.$ac_ext <<_ACEOF
! /* confdefs.h.  */
! _ACEOF
! cat confdefs.h >>conftest.$ac_ext
! cat >>conftest.$ac_ext <<_ACEOF
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
--- 4489,4529 ----
     USE_GNUTLS=0
  else
     if test "$WITH_GNUTLS" = "yes"; then
!       GNUTLS_INC=
!       GNUTLS_LIB=-lgnutls
!    else
!       GNUTLS_INC="$WITH_GNUTLS/include"
!       GNUTLS_LIB="$WITH_GNUTLS/lib"
!    fi
  
!    for ac_header in gnutls/gnutls.h
! do :
!   ac_fn_c_check_header_mongrel "$LINENO" "gnutls/gnutls.h" "ac_cv_header_gnutls_gnutls_h" "$ac_includes_default"
! if test "x$ac_cv_header_gnutls_gnutls_h" = x""yes; then :
!   cat >>confdefs.h <<_ACEOF
! #define HAVE_GNUTLS_GNUTLS_H 1
! _ACEOF
!  HAVE_GNUTLS_GNUTLS_H=yes
  fi
  
+ done
  
  
!    if test "$HAVE_GNUTLS_GNUTLS_H" = ""; then
!       { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: Cannot find gnutls/gnutls.h header file; configuring without SSL/https support" >&5
! $as_echo "$as_me: WARNING: Cannot find gnutls/gnutls.h header file; configuring without SSL/https support" >&2;}
!       GNUTLS_LIB=
!       GNUTLS_INC=
!       USE_GNUTLS=0
     else
!       { $as_echo "$as_me:${as_lineno-$LINENO}: checking for gnutls_check_version in -lgnutls" >&5
! $as_echo_n "checking for gnutls_check_version in -lgnutls... " >&6; }
! if test "${ac_cv_lib_gnutls_gnutls_check_version+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    ac_check_lib_save_LIBS=$LIBS
  LIBS="-lgnutls $GNUTLS_LIB $LIBS"
! cat confdefs.h - <<_ACEOF >conftest.$ac_ext
  /* end confdefs.h.  */
  
  /* Override any GCC internal prototype to avoid an error.
***************
*** 6057,6113 ****
  return gnutls_check_version ();
    ;
    return 0;
! }
! _ACEOF
! rm -f conftest.$ac_objext conftest$ac_exeext
! if { (ac_try="$ac_link"
! case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_link") 2>conftest.er1
!   ac_status=$?
!   grep -v '^ *+' conftest.er1 >conftest.err
!   rm -f conftest.er1
!   cat conftest.err >&5
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); } &&
! 	 { ac_try='test -z "$ac_c_werror_flag" || test ! -s conftest.err'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; } &&
! 	 { ac_try='test -s conftest$ac_exeext'
!   { (case "(($ac_try" in
!   *\"* | *\`* | *\\*) ac_try_echo=\$ac_try;;
!   *) ac_try_echo=$ac_try;;
! esac
! eval "echo \"\$as_me:$LINENO: $ac_try_echo\"") >&5
!   (eval "$ac_try") 2>&5
!   ac_status=$?
!   echo "$as_me:$LINENO: \$? = $ac_status" >&5
!   (exit $ac_status); }; }; then
    ac_cv_lib_gnutls_gnutls_check_version=yes
  else
!   echo "$as_me: failed program was:" >&5
! sed 's/^/| /' conftest.$ac_ext >&5
! 
! 	ac_cv_lib_gnutls_gnutls_check_version=no
  fi
! 
! rm -f core conftest.err conftest.$ac_objext conftest_ipa8_conftest.oo \
!       conftest$ac_exeext conftest.$ac_ext
  LIBS=$ac_check_lib_save_LIBS
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_lib_gnutls_gnutls_check_version" >&5
! echo "${ECHO_T}$ac_cv_lib_gnutls_gnutls_check_version" >&6; }
! if test $ac_cv_lib_gnutls_gnutls_check_version = yes; then
    WITH_GNUTLS=yes
  else
    WITH_GNUTLS=no
--- 4539,4558 ----
  return gnutls_check_version ();
    ;
    return 0;
! }
! _ACEOF
! if ac_fn_c_try_link "$LINENO"; then :
    ac_cv_lib_gnutls_gnutls_check_version=yes
  else
!   ac_cv_lib_gnutls_gnutls_check_version=no
  fi
! rm -f core conftest.err conftest.$ac_objext \
!     conftest$ac_exeext conftest.$ac_ext
  LIBS=$ac_check_lib_save_LIBS
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_lib_gnutls_gnutls_check_version" >&5
! $as_echo "$ac_cv_lib_gnutls_gnutls_check_version" >&6; }
! if test "x$ac_cv_lib_gnutls_gnutls_check_version" = x""yes; then :
    WITH_GNUTLS=yes
  else
    WITH_GNUTLS=no
***************
*** 6115,6130 ****
  
  
        if test "$WITH_GNUTLS" = "no"; then
!          { echo "$as_me:$LINENO: WARNING: Cannot find working libgnutls library, configuring without SSL/https support" >&5
! echo "$as_me: WARNING: Cannot find working libgnutls library, configuring without SSL/https support" >&2;}
           GNUTLS_LIB=
           GNUTLS_INC=
           USE_GNUTLS=0
        fi
-    else
-       GNUTLS_LIB=
-       GNUTLS_INC=
-       USE_GNUTLS=0
     fi
  fi
  
--- 4560,4573 ----
  
  
        if test "$WITH_GNUTLS" = "no"; then
!          { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: Cannot find working libgnutls library, configuring without SSL/https support" >&5
! $as_echo "$as_me: WARNING: Cannot find working libgnutls library, configuring without SSL/https support" >&2;}
           GNUTLS_LIB=
           GNUTLS_INC=
           USE_GNUTLS=0
+       else
+          USE_GNUTLS=1
        fi
     fi
  fi
  
***************
*** 6140,6146 ****
  
  
  # Check whether --with-ipv6 was given.
! if test "${with_ipv6+set}" = set; then
    withval=$with_ipv6; WITH_IPV6=$withval
  else
    WITH_IPV6=yes
--- 4583,4589 ----
  
  
  # Check whether --with-ipv6 was given.
! if test "${with_ipv6+set}" = set; then :
    withval=$with_ipv6; WITH_IPV6=$withval
  else
    WITH_IPV6=yes
***************
*** 6152,6171 ****
  else
     USE_IPV6=1
  
!    { echo "$as_me:$LINENO: checking for IPv6 support" >&5
! echo $ECHO_N "checking for IPv6 support... $ECHO_C" >&6; }
  
     if test "$ac_cv_func_getnameinfo" = "no"; then
!       { echo "$as_me:$LINENO: result: no, cannot find getnameinfo() function" >&5
! echo "${ECHO_T}no, cannot find getnameinfo() function" >&6; }
        USE_IPV6=0
     elif test "$ac_cv_func_getaddrinfo" = "no"; then
!       { echo "$as_me:$LINENO: result: no, cannot find getaddrinfo() function" >&5
! echo "${ECHO_T}no, cannot find getaddrinfo() function" >&6; }
        USE_IPV6=0
     else
!       { echo "$as_me:$LINENO: result: yes" >&5
! echo "${ECHO_T}yes" >&6; }
     fi
  fi
  
--- 4595,4614 ----
  else
     USE_IPV6=1
  
!    { $as_echo "$as_me:${as_lineno-$LINENO}: checking for IPv6 support" >&5
! $as_echo_n "checking for IPv6 support... " >&6; }
  
     if test "$ac_cv_func_getnameinfo" = "no"; then
!       { $as_echo "$as_me:${as_lineno-$LINENO}: result: no, cannot find getnameinfo() function" >&5
! $as_echo "no, cannot find getnameinfo() function" >&6; }
        USE_IPV6=0
     elif test "$ac_cv_func_getaddrinfo" = "no"; then
!       { $as_echo "$as_me:${as_lineno-$LINENO}: result: no, cannot find getaddrinfo() function" >&5
! $as_echo "no, cannot find getaddrinfo() function" >&6; }
        USE_IPV6=0
     else
!       { $as_echo "$as_me:${as_lineno-$LINENO}: result: yes" >&5
! $as_echo "yes" >&6; }
     fi
  fi
  
***************
*** 6178,6212 ****
  
  # Make sure we can run config.sub.
  $SHELL "$ac_aux_dir/config.sub" sun4 >/dev/null 2>&1 ||
!   { { echo "$as_me:$LINENO: error: cannot run $SHELL $ac_aux_dir/config.sub" >&5
! echo "$as_me: error: cannot run $SHELL $ac_aux_dir/config.sub" >&2;}
!    { (exit 1); exit 1; }; }
! 
! { echo "$as_me:$LINENO: checking build system type" >&5
! echo $ECHO_N "checking build system type... $ECHO_C" >&6; }
! if test "${ac_cv_build+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    ac_build_alias=$build_alias
  test "x$ac_build_alias" = x &&
    ac_build_alias=`$SHELL "$ac_aux_dir/config.guess"`
  test "x$ac_build_alias" = x &&
!   { { echo "$as_me:$LINENO: error: cannot guess build type; you must specify one" >&5
! echo "$as_me: error: cannot guess build type; you must specify one" >&2;}
!    { (exit 1); exit 1; }; }
  ac_cv_build=`$SHELL "$ac_aux_dir/config.sub" $ac_build_alias` ||
!   { { echo "$as_me:$LINENO: error: $SHELL $ac_aux_dir/config.sub $ac_build_alias failed" >&5
! echo "$as_me: error: $SHELL $ac_aux_dir/config.sub $ac_build_alias failed" >&2;}
!    { (exit 1); exit 1; }; }
  
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_build" >&5
! echo "${ECHO_T}$ac_cv_build" >&6; }
  case $ac_cv_build in
  *-*-*) ;;
! *) { { echo "$as_me:$LINENO: error: invalid value of canonical build" >&5
! echo "$as_me: error: invalid value of canonical build" >&2;}
!    { (exit 1); exit 1; }; };;
  esac
  build=$ac_cv_build
  ac_save_IFS=$IFS; IFS='-'
--- 4621,4647 ----
  
  # Make sure we can run config.sub.
  $SHELL "$ac_aux_dir/config.sub" sun4 >/dev/null 2>&1 ||
!   as_fn_error "cannot run $SHELL $ac_aux_dir/config.sub" "$LINENO" 5
! 
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking build system type" >&5
! $as_echo_n "checking build system type... " >&6; }
! if test "${ac_cv_build+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    ac_build_alias=$build_alias
  test "x$ac_build_alias" = x &&
    ac_build_alias=`$SHELL "$ac_aux_dir/config.guess"`
  test "x$ac_build_alias" = x &&
!   as_fn_error "cannot guess build type; you must specify one" "$LINENO" 5
  ac_cv_build=`$SHELL "$ac_aux_dir/config.sub" $ac_build_alias` ||
!   as_fn_error "$SHELL $ac_aux_dir/config.sub $ac_build_alias failed" "$LINENO" 5
  
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_build" >&5
! $as_echo "$ac_cv_build" >&6; }
  case $ac_cv_build in
  *-*-*) ;;
! *) as_fn_error "invalid value of canonical build" "$LINENO" 5;;
  esac
  build=$ac_cv_build
  ac_save_IFS=$IFS; IFS='-'
***************
*** 6222,6249 ****
  case $build_os in *\ *) build_os=`echo "$build_os" | sed 's/ /-/g'`;; esac
  
  
! { echo "$as_me:$LINENO: checking host system type" >&5
! echo $ECHO_N "checking host system type... $ECHO_C" >&6; }
! if test "${ac_cv_host+set}" = set; then
!   echo $ECHO_N "(cached) $ECHO_C" >&6
  else
    if test "x$host_alias" = x; then
    ac_cv_host=$ac_cv_build
  else
    ac_cv_host=`$SHELL "$ac_aux_dir/config.sub" $host_alias` ||
!     { { echo "$as_me:$LINENO: error: $SHELL $ac_aux_dir/config.sub $host_alias failed" >&5
! echo "$as_me: error: $SHELL $ac_aux_dir/config.sub $host_alias failed" >&2;}
!    { (exit 1); exit 1; }; }
  fi
  
  fi
! { echo "$as_me:$LINENO: result: $ac_cv_host" >&5
! echo "${ECHO_T}$ac_cv_host" >&6; }
  case $ac_cv_host in
  *-*-*) ;;
! *) { { echo "$as_me:$LINENO: error: invalid value of canonical host" >&5
! echo "$as_me: error: invalid value of canonical host" >&2;}
!    { (exit 1); exit 1; }; };;
  esac
  host=$ac_cv_host
  ac_save_IFS=$IFS; IFS='-'
--- 4657,4680 ----
  case $build_os in *\ *) build_os=`echo "$build_os" | sed 's/ /-/g'`;; esac
  
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking host system type" >&5
! $as_echo_n "checking host system type... " >&6; }
! if test "${ac_cv_host+set}" = set; then :
!   $as_echo_n "(cached) " >&6
  else
    if test "x$host_alias" = x; then
    ac_cv_host=$ac_cv_build
  else
    ac_cv_host=`$SHELL "$ac_aux_dir/config.sub" $host_alias` ||
!     as_fn_error "$SHELL $ac_aux_dir/config.sub $host_alias failed" "$LINENO" 5
  fi
  
  fi
! { $as_echo "$as_me:${as_lineno-$LINENO}: result: $ac_cv_host" >&5
! $as_echo "$ac_cv_host" >&6; }
  case $ac_cv_host in
  *-*-*) ;;
! *) as_fn_error "invalid value of canonical host" "$LINENO" 5;;
  esac
  host=$ac_cv_host
  ac_save_IFS=$IFS; IFS='-'
***************
*** 6259,6264 ****
--- 4690,4696 ----
  case $host_os in *\ *) host_os=`echo "$host_os" | sed 's/ /-/g'`;; esac
  
  
+ 
  case $host_os in
    *cygwin* ) CYGWIN=yes;;
  	 * ) CYGWIN=no;;
***************
*** 6277,6283 ****
  
  
  # Check whether --with-spooldir was given.
! if test "${with_spooldir+set}" = set; then
    withval=$with_spooldir; SPOOLDIR=$withval
  fi
  
--- 4709,4715 ----
  
  
  # Check whether --with-spooldir was given.
! if test "${with_spooldir+set}" = set; then :
    withval=$with_spooldir; SPOOLDIR=$withval
  fi
  
***************
*** 6295,6301 ****
  
  
  # Check whether --with-confdir was given.
! if test "${with_confdir+set}" = set; then
    withval=$with_confdir; CONFDIR=$withval
  fi
  
--- 4727,4733 ----
  
  
  # Check whether --with-confdir was given.
! if test "${with_confdir+set}" = set; then :
    withval=$with_confdir; CONFDIR=$withval
  fi
  
***************
*** 6313,6319 ****
  
  
  # Check whether --with-server was given.
! if test "${with_server+set}" = set; then
    withval=$with_server; SERVER=$withval
  fi
  
--- 4745,4751 ----
  
  
  # Check whether --with-server was given.
! if test "${with_server+set}" = set; then :
    withval=$with_server; SERVER=$withval
  fi
  
***************
*** 6353,6360 ****
  
  
  
! { echo "$as_me:$LINENO: checking the default language" >&5
! echo $ECHO_N "checking the default language... $ECHO_C" >&6; }
  
  LANGUAGES="de en es fr it nl pl ru"
  
--- 4785,4792 ----
  
  
  
! { $as_echo "$as_me:${as_lineno-$LINENO}: checking the default language" >&5
! $as_echo_n "checking the default language... " >&6; }
  
  LANGUAGES="de en es fr it nl pl ru"
  
***************
*** 6362,6368 ****
  
  
  # Check whether --with-default-language was given.
! if test "${with_default_language+set}" = set; then
    withval=$with_default_language; WITH_LANG=$withval
  else
    WITH_LANG=en
--- 4794,4800 ----
  
  
  # Check whether --with-default-language was given.
! if test "${with_default_language+set}" = set; then :
    withval=$with_default_language; WITH_LANG=$withval
  else
    WITH_LANG=en
***************
*** 6377,6388 ****
  done
  
  if test "x$DEFLANG" = "x"; then
!     { { echo "$as_me:$LINENO: error: Invalid value $WITH_LANG for default language, choose from: $LANGUAGES." >&5
! echo "$as_me: error: Invalid value $WITH_LANG for default language, choose from: $LANGUAGES." >&2;}
!    { (exit 1); exit 1; }; }
  else
!     { echo "$as_me:$LINENO: result: $DEFLANG" >&5
! echo "${ECHO_T}$DEFLANG" >&6; }
  fi
  
  
--- 4809,4818 ----
  done
  
  if test "x$DEFLANG" = "x"; then
!     as_fn_error "Invalid value $WITH_LANG for default language, choose from: $LANGUAGES." "$LINENO" 5
  else
!     { $as_echo "$as_me:${as_lineno-$LINENO}: result: $DEFLANG" >&5
! $as_echo "$DEFLANG" >&6; }
  fi
  
  
***************
*** 6420,6431 ****
      case $ac_val in #(
      *${as_nl}*)
        case $ac_var in #(
!       *_cv_*) { echo "$as_me:$LINENO: WARNING: Cache variable $ac_var contains a newline." >&5
! echo "$as_me: WARNING: Cache variable $ac_var contains a newline." >&2;} ;;
        esac
        case $ac_var in #(
        _ | IFS | as_nl) ;; #(
!       *) $as_unset $ac_var ;;
        esac ;;
      esac
    done
--- 4850,4862 ----
      case $ac_val in #(
      *${as_nl}*)
        case $ac_var in #(
!       *_cv_*) { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: cache variable $ac_var contains a newline" >&5
! $as_echo "$as_me: WARNING: cache variable $ac_var contains a newline" >&2;} ;;
        esac
        case $ac_var in #(
        _ | IFS | as_nl) ;; #(
!       BASH_ARGV | BASH_SOURCE) eval $ac_var= ;; #(
!       *) { eval $ac_var=; unset $ac_var;} ;;
        esac ;;
      esac
    done
***************
*** 6433,6440 ****
    (set) 2>&1 |
      case $as_nl`(ac_space=' '; set) 2>&1` in #(
      *${as_nl}ac_space=\ *)
!       # `set' does not quote correctly, so add quotes (double-quote
!       # substitution turns \\\\ into \\, and sed turns \\ into \).
        sed -n \
  	"s/'/'\\\\''/g;
  	  s/^\\([_$as_cr_alnum]*_cv_[_$as_cr_alnum]*\\)=\\(.*\\)/\\1='\\2'/p"
--- 4864,4871 ----
    (set) 2>&1 |
      case $as_nl`(ac_space=' '; set) 2>&1` in #(
      *${as_nl}ac_space=\ *)
!       # `set' does not quote correctly, so add quotes: double-quote
!       # substitution turns \\\\ into \\, and sed turns \\ into \.
        sed -n \
  	"s/'/'\\\\''/g;
  	  s/^\\([_$as_cr_alnum]*_cv_[_$as_cr_alnum]*\\)=\\(.*\\)/\\1='\\2'/p"
***************
*** 6457,6468 ****
  if diff "$cache_file" confcache >/dev/null 2>&1; then :; else
    if test -w "$cache_file"; then
      test "x$cache_file" != "x/dev/null" &&
!       { echo "$as_me:$LINENO: updating cache $cache_file" >&5
! echo "$as_me: updating cache $cache_file" >&6;}
      cat confcache >$cache_file
    else
!     { echo "$as_me:$LINENO: not updating unwritable cache $cache_file" >&5
! echo "$as_me: not updating unwritable cache $cache_file" >&6;}
    fi
  fi
  rm -f confcache
--- 4888,4899 ----
  if diff "$cache_file" confcache >/dev/null 2>&1; then :; else
    if test -w "$cache_file"; then
      test "x$cache_file" != "x/dev/null" &&
!       { $as_echo "$as_me:${as_lineno-$LINENO}: updating cache $cache_file" >&5
! $as_echo "$as_me: updating cache $cache_file" >&6;}
      cat confcache >$cache_file
    else
!     { $as_echo "$as_me:${as_lineno-$LINENO}: not updating unwritable cache $cache_file" >&5
! $as_echo "$as_me: not updating unwritable cache $cache_file" >&6;}
    fi
  fi
  rm -f confcache
***************
*** 6478,6488 ****
  for ac_i in : $LIBOBJS; do test "x$ac_i" = x: && continue
    # 1. Remove the extension, and $U if already installed.
    ac_script='s/\$U\././;s/\.o$//;s/\.obj$//'
!   ac_i=`echo "$ac_i" | sed "$ac_script"`
    # 2. Prepend LIBOBJDIR.  When used with automake>=1.10 LIBOBJDIR
    #    will be set to the directory where LIBOBJS objects are built.
!   ac_libobjs="$ac_libobjs \${LIBOBJDIR}$ac_i\$U.$ac_objext"
!   ac_ltlibobjs="$ac_ltlibobjs \${LIBOBJDIR}$ac_i"'$U.lo'
  done
  LIBOBJS=$ac_libobjs
  
--- 4909,4919 ----
  for ac_i in : $LIBOBJS; do test "x$ac_i" = x: && continue
    # 1. Remove the extension, and $U if already installed.
    ac_script='s/\$U\././;s/\.o$//;s/\.obj$//'
!   ac_i=`$as_echo "$ac_i" | sed "$ac_script"`
    # 2. Prepend LIBOBJDIR.  When used with automake>=1.10 LIBOBJDIR
    #    will be set to the directory where LIBOBJS objects are built.
!   as_fn_append ac_libobjs " \${LIBOBJDIR}$ac_i\$U.$ac_objext"
!   as_fn_append ac_ltlibobjs " \${LIBOBJDIR}$ac_i"'$U.lo'
  done
  LIBOBJS=$ac_libobjs
  
***************
*** 6491,6501 ****
  
  
  : ${CONFIG_STATUS=./config.status}
  ac_clean_files_save=$ac_clean_files
  ac_clean_files="$ac_clean_files $CONFIG_STATUS"
! { echo "$as_me:$LINENO: creating $CONFIG_STATUS" >&5
! echo "$as_me: creating $CONFIG_STATUS" >&6;}
! cat >$CONFIG_STATUS <<_ACEOF
  #! $SHELL
  # Generated by $as_me.
  # Run this file to recreate the current configuration.
--- 4922,4934 ----
  
  
  : ${CONFIG_STATUS=./config.status}
+ ac_write_fail=0
  ac_clean_files_save=$ac_clean_files
  ac_clean_files="$ac_clean_files $CONFIG_STATUS"
! { $as_echo "$as_me:${as_lineno-$LINENO}: creating $CONFIG_STATUS" >&5
! $as_echo "$as_me: creating $CONFIG_STATUS" >&6;}
! as_write_fail=0
! cat >$CONFIG_STATUS <<_ASEOF || as_write_fail=1
  #! $SHELL
  # Generated by $as_me.
  # Run this file to recreate the current configuration.
***************
*** 6505,6559 ****
  debug=false
  ac_cs_recheck=false
  ac_cs_silent=false
- SHELL=\${CONFIG_SHELL-$SHELL}
- _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF
! ## --------------------- ##
! ## M4sh Initialization.  ##
! ## --------------------- ##
  
! # Be Bourne compatible
! if test -n "${ZSH_VERSION+set}" && (emulate sh) >/dev/null 2>&1; then
    emulate sh
    NULLCMD=:
!   # Zsh 3.x and 4.x performs word splitting on ${1+"$@"}, which
    # is contrary to our usage.  Disable this feature.
    alias -g '${1+"$@"}'='"$@"'
    setopt NO_GLOB_SUBST
  else
!   case `(set -o) 2>/dev/null` in *posix*) set -o posix;; esac
  fi
- BIN_SH=xpg4; export BIN_SH # for Tru64
- DUALCASE=1; export DUALCASE # for MKS sh
  
  
! # PATH needs CR
! # Avoid depending upon Character Ranges.
! as_cr_letters='abcdefghijklmnopqrstuvwxyz'
! as_cr_LETTERS='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
! as_cr_Letters=$as_cr_letters$as_cr_LETTERS
! as_cr_digits='0123456789'
! as_cr_alnum=$as_cr_Letters$as_cr_digits
! 
! # The user is always right.
! if test "${PATH_SEPARATOR+set}" != set; then
!   echo "#! /bin/sh" >conf$$.sh
!   echo  "exit 0"   >>conf$$.sh
!   chmod +x conf$$.sh
!   if (PATH="/nonexistent;."; conf$$.sh) >/dev/null 2>&1; then
!     PATH_SEPARATOR=';'
    else
!     PATH_SEPARATOR=:
    fi
!   rm -f conf$$.sh
  fi
  
! # Support unset when possible.
! if ( (MAIL=60; unset MAIL) || exit) >/dev/null 2>&1; then
!   as_unset=unset
! else
!   as_unset=false
  fi
  
  
--- 4938,5016 ----
  debug=false
  ac_cs_recheck=false
  ac_cs_silent=false
  
! SHELL=\${CONFIG_SHELL-$SHELL}
! export SHELL
! _ASEOF
! cat >>$CONFIG_STATUS <<\_ASEOF || as_write_fail=1
! ## -------------------- ##
! ## M4sh Initialization. ##
! ## -------------------- ##
  
! # Be more Bourne compatible
! DUALCASE=1; export DUALCASE # for MKS sh
! if test -n "${ZSH_VERSION+set}" && (emulate sh) >/dev/null 2>&1; then :
    emulate sh
    NULLCMD=:
!   # Pre-4.2 versions of Zsh do word splitting on ${1+"$@"}, which
    # is contrary to our usage.  Disable this feature.
    alias -g '${1+"$@"}'='"$@"'
    setopt NO_GLOB_SUBST
  else
!   case `(set -o) 2>/dev/null` in #(
!   *posix*) :
!     set -o posix ;; #(
!   *) :
!      ;;
! esac
  fi
  
  
! as_nl='
! '
! export as_nl
! # Printing a long string crashes Solaris 7 /usr/bin/printf.
! as_echo='\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\'
! as_echo=$as_echo$as_echo$as_echo$as_echo$as_echo
! as_echo=$as_echo$as_echo$as_echo$as_echo$as_echo$as_echo
! # Prefer a ksh shell builtin over an external printf program on Solaris,
! # but without wasting forks for bash or zsh.
! if test -z "$BASH_VERSION$ZSH_VERSION" \
!     && (test "X`print -r -- $as_echo`" = "X$as_echo") 2>/dev/null; then
!   as_echo='print -r --'
!   as_echo_n='print -rn --'
! elif (test "X`printf %s $as_echo`" = "X$as_echo") 2>/dev/null; then
!   as_echo='printf %s\n'
!   as_echo_n='printf %s'
! else
!   if test "X`(/usr/ucb/echo -n -n $as_echo) 2>/dev/null`" = "X-n $as_echo"; then
!     as_echo_body='eval /usr/ucb/echo -n "$1$as_nl"'
!     as_echo_n='/usr/ucb/echo -n'
    else
!     as_echo_body='eval expr "X$1" : "X\\(.*\\)"'
!     as_echo_n_body='eval
!       arg=$1;
!       case $arg in #(
!       *"$as_nl"*)
! 	expr "X$arg" : "X\\(.*\\)$as_nl";
! 	arg=`expr "X$arg" : ".*$as_nl\\(.*\\)"`;;
!       esac;
!       expr "X$arg" : "X\\(.*\\)" | tr -d "$as_nl"
!     '
!     export as_echo_n_body
!     as_echo_n='sh -c $as_echo_n_body as_echo'
    fi
!   export as_echo_body
!   as_echo='sh -c $as_echo_body as_echo'
  fi
  
! # The user is always right.
! if test "${PATH_SEPARATOR+set}" != set; then
!   PATH_SEPARATOR=:
!   (PATH='/bin;/bin'; FPATH=$PATH; sh -c :) >/dev/null 2>&1 && {
!     (PATH='/bin:/bin'; FPATH=$PATH; sh -c :) >/dev/null 2>&1 ||
!       PATH_SEPARATOR=';'
!   }
  fi
  
  
***************
*** 6562,6581 ****
  # there to prevent editors from complaining about space-tab.
  # (If _AS_PATH_WALK were called with IFS unset, it would disable word
  # splitting by setting IFS to empty value.)
- as_nl='
- '
  IFS=" ""	$as_nl"
  
  # Find who we are.  Look in the path if we contain no directory separator.
! case $0 in
    *[\\/]* ) as_myself=$0 ;;
    *) as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!   test -r "$as_dir/$0" && as_myself=$as_dir/$0 && break
! done
  IFS=$as_save_IFS
  
       ;;
--- 5019,5036 ----
  # there to prevent editors from complaining about space-tab.
  # (If _AS_PATH_WALK were called with IFS unset, it would disable word
  # splitting by setting IFS to empty value.)
  IFS=" ""	$as_nl"
  
  # Find who we are.  Look in the path if we contain no directory separator.
! case $0 in #((
    *[\\/]* ) as_myself=$0 ;;
    *) as_save_IFS=$IFS; IFS=$PATH_SEPARATOR
  for as_dir in $PATH
  do
    IFS=$as_save_IFS
    test -z "$as_dir" && as_dir=.
!     test -r "$as_dir/$0" && as_myself=$as_dir/$0 && break
!   done
  IFS=$as_save_IFS
  
       ;;
***************
*** 6586,6617 ****
    as_myself=$0
  fi
  if test ! -f "$as_myself"; then
!   echo "$as_myself: error: cannot find myself; rerun with an absolute file name" >&2
!   { (exit 1); exit 1; }
  fi
  
! # Work around bugs in pre-3.0 UWIN ksh.
! for as_var in ENV MAIL MAILPATH
! do ($as_unset $as_var) >/dev/null 2>&1 && $as_unset $as_var
  done
  PS1='$ '
  PS2='> '
  PS4='+ '
  
  # NLS nuisances.
! for as_var in \
!   LANG LANGUAGE LC_ADDRESS LC_ALL LC_COLLATE LC_CTYPE LC_IDENTIFICATION \
!   LC_MEASUREMENT LC_MESSAGES LC_MONETARY LC_NAME LC_NUMERIC LC_PAPER \
!   LC_TELEPHONE LC_TIME
! do
!   if (set +x; test -z "`(eval $as_var=C; export $as_var) 2>&1`"); then
!     eval $as_var=C; export $as_var
!   else
!     ($as_unset $as_var) >/dev/null 2>&1 && $as_unset $as_var
!   fi
! done
  
- # Required to use basename.
  if expr a : '\(a\)' >/dev/null 2>&1 &&
     test "X`expr 00001 : '.*\(...\)'`" = X001; then
    as_expr=expr
--- 5041,5151 ----
    as_myself=$0
  fi
  if test ! -f "$as_myself"; then
!   $as_echo "$as_myself: error: cannot find myself; rerun with an absolute file name" >&2
!   exit 1
  fi
  
! # Unset variables that we do not need and which cause bugs (e.g. in
! # pre-3.0 UWIN ksh).  But do not cause bugs in bash 2.01; the "|| exit 1"
! # suppresses any "Segmentation fault" message there.  '((' could
! # trigger a bug in pdksh 5.2.14.
! for as_var in BASH_ENV ENV MAIL MAILPATH
! do eval test x\${$as_var+set} = xset \
!   && ( (unset $as_var) || exit 1) >/dev/null 2>&1 && unset $as_var || :
  done
  PS1='$ '
  PS2='> '
  PS4='+ '
  
  # NLS nuisances.
! LC_ALL=C
! export LC_ALL
! LANGUAGE=C
! export LANGUAGE
! 
! # CDPATH.
! (unset CDPATH) >/dev/null 2>&1 && unset CDPATH
! 
! 
! # as_fn_error ERROR [LINENO LOG_FD]
! # ---------------------------------
! # Output "`basename $0`: error: ERROR" to stderr. If LINENO and LOG_FD are
! # provided, also output the error to LOG_FD, referencing LINENO. Then exit the
! # script with status $?, using 1 if that was 0.
! as_fn_error ()
! {
!   as_status=$?; test $as_status -eq 0 && as_status=1
!   if test "$3"; then
!     as_lineno=${as_lineno-"$2"} as_lineno_stack=as_lineno_stack=$as_lineno_stack
!     $as_echo "$as_me:${as_lineno-$LINENO}: error: $1" >&$3
!   fi
!   $as_echo "$as_me: error: $1" >&2
!   as_fn_exit $as_status
! } # as_fn_error
! 
! 
! # as_fn_set_status STATUS
! # -----------------------
! # Set $? to STATUS, without forking.
! as_fn_set_status ()
! {
!   return $1
! } # as_fn_set_status
! 
! # as_fn_exit STATUS
! # -----------------
! # Exit the shell with STATUS, even in a "trap 0" or "set -e" context.
! as_fn_exit ()
! {
!   set +e
!   as_fn_set_status $1
!   exit $1
! } # as_fn_exit
! 
! # as_fn_unset VAR
! # ---------------
! # Portably unset VAR.
! as_fn_unset ()
! {
!   { eval $1=; unset $1;}
! }
! as_unset=as_fn_unset
! # as_fn_append VAR VALUE
! # ----------------------
! # Append the text in VALUE to the end of the definition contained in VAR. Take
! # advantage of any shell optimizations that allow amortized linear growth over
! # repeated appends, instead of the typical quadratic growth present in naive
! # implementations.
! if (eval "as_var=1; as_var+=2; test x\$as_var = x12") 2>/dev/null; then :
!   eval 'as_fn_append ()
!   {
!     eval $1+=\$2
!   }'
! else
!   as_fn_append ()
!   {
!     eval $1=\$$1\$2
!   }
! fi # as_fn_append
! 
! # as_fn_arith ARG...
! # ------------------
! # Perform arithmetic evaluation on the ARGs, and store the result in the
! # global $as_val. Take advantage of shells that can avoid forks. The arguments
! # must be portable across $(()) and expr.
! if (eval "test \$(( 1 + 1 )) = 2") 2>/dev/null; then :
!   eval 'as_fn_arith ()
!   {
!     as_val=$(( $* ))
!   }'
! else
!   as_fn_arith ()
!   {
!     as_val=`expr "$@" || test $? -eq 1`
!   }
! fi # as_fn_arith
! 
  
  if expr a : '\(a\)' >/dev/null 2>&1 &&
     test "X`expr 00001 : '.*\(...\)'`" = X001; then
    as_expr=expr
***************
*** 6625,6637 ****
    as_basename=false
  fi
  
  
- # Name of the executable.
  as_me=`$as_basename -- "$0" ||
  $as_expr X/"$0" : '.*/\([^/][^/]*\)/*$' \| \
  	 X"$0" : 'X\(//\)$' \| \
  	 X"$0" : 'X\(/\)' \| . 2>/dev/null ||
! echo X/"$0" |
      sed '/^.*\/\([^/][^/]*\)\/*$/{
  	    s//\1/
  	    q
--- 5159,5175 ----
    as_basename=false
  fi
  
+ if (as_dir=`dirname -- /` && test "X$as_dir" = X/) >/dev/null 2>&1; then
+   as_dirname=dirname
+ else
+   as_dirname=false
+ fi
  
  as_me=`$as_basename -- "$0" ||
  $as_expr X/"$0" : '.*/\([^/][^/]*\)/*$' \| \
  	 X"$0" : 'X\(//\)$' \| \
  	 X"$0" : 'X\(/\)' \| . 2>/dev/null ||
! $as_echo X/"$0" |
      sed '/^.*\/\([^/][^/]*\)\/*$/{
  	    s//\1/
  	    q
***************
*** 6646,6767 ****
  	  }
  	  s/.*/./; q'`
  
! # CDPATH.
! $as_unset CDPATH
! 
! 
! 
!   as_lineno_1=$LINENO
!   as_lineno_2=$LINENO
!   test "x$as_lineno_1" != "x$as_lineno_2" &&
!   test "x`expr $as_lineno_1 + 1`" = "x$as_lineno_2" || {
! 
!   # Create $as_me.lineno as a copy of $as_myself, but with $LINENO
!   # uniformly replaced by the line number.  The first 'sed' inserts a
!   # line-number line after each line using $LINENO; the second 'sed'
!   # does the real work.  The second script uses 'N' to pair each
!   # line-number line with the line containing $LINENO, and appends
!   # trailing '-' during substitution so that $LINENO is not a special
!   # case at line end.
!   # (Raja R Harinath suggested sed '=', and Paul Eggert wrote the
!   # scripts with optimization help from Paolo Bonzini.  Blame Lee
!   # E. McMahon (1931-1989) for sed's syntax.  :-)
!   sed -n '
!     p
!     /[$]LINENO/=
!   ' <$as_myself |
!     sed '
!       s/[$]LINENO.*/&-/
!       t lineno
!       b
!       :lineno
!       N
!       :loop
!       s/[$]LINENO\([^'$as_cr_alnum'_].*\n\)\(.*\)/\2\1\2/
!       t loop
!       s/-\n.*//
!     ' >$as_me.lineno &&
!   chmod +x "$as_me.lineno" ||
!     { echo "$as_me: error: cannot create $as_me.lineno; rerun with a POSIX shell" >&2
!    { (exit 1); exit 1; }; }
! 
!   # Don't try to exec as it changes $[0], causing all sort of problems
!   # (the dirname of $[0] is not the place where we might find the
!   # original and so on.  Autoconf is especially sensitive to this).
!   . "./$as_me.lineno"
!   # Exit status is that of the last command.
!   exit
! }
! 
! 
! if (as_dir=`dirname -- /` && test "X$as_dir" = X/) >/dev/null 2>&1; then
!   as_dirname=dirname
! else
!   as_dirname=false
! fi
  
  ECHO_C= ECHO_N= ECHO_T=
! case `echo -n x` in
  -n*)
!   case `echo 'x\c'` in
    *c*) ECHO_T='	';;	# ECHO_T is single tab character.
!   *)   ECHO_C='\c';;
    esac;;
  *)
    ECHO_N='-n';;
  esac
  
- if expr a : '\(a\)' >/dev/null 2>&1 &&
-    test "X`expr 00001 : '.*\(...\)'`" = X001; then
-   as_expr=expr
- else
-   as_expr=false
- fi
- 
  rm -f conf$$ conf$$.exe conf$$.file
  if test -d conf$$.dir; then
    rm -f conf$$.dir/conf$$.file
  else
    rm -f conf$$.dir
!   mkdir conf$$.dir
  fi
! echo >conf$$.file
! if ln -s conf$$.file conf$$ 2>/dev/null; then
!   as_ln_s='ln -s'
!   # ... but there are two gotchas:
!   # 1) On MSYS, both `ln -s file dir' and `ln file dir' fail.
!   # 2) DJGPP < 2.04 has no symlinks; `ln -s' creates a wrapper executable.
!   # In both cases, we have to default to `cp -p'.
!   ln -s conf$$.file conf$$.dir 2>/dev/null && test ! -f conf$$.exe ||
      as_ln_s='cp -p'
! elif ln conf$$.file conf$$ 2>/dev/null; then
!   as_ln_s=ln
  else
    as_ln_s='cp -p'
  fi
  rm -f conf$$ conf$$.exe conf$$.dir/conf$$.file conf$$.file
  rmdir conf$$.dir 2>/dev/null
  
  if mkdir -p . 2>/dev/null; then
!   as_mkdir_p=:
  else
    test -d ./-p && rmdir ./-p
    as_mkdir_p=false
  fi
  
! # Find out whether ``test -x'' works.  Don't use a zero-byte file, as
! # systems may use methods other than mode bits to determine executability.
! cat >conf$$.file <<_ASEOF
! #! /bin/sh
! exit 0
! _ASEOF
! chmod +x conf$$.file
! if test -x conf$$.file >/dev/null 2>&1; then
!   as_executable_p="test -x"
  else
!   as_executable_p=:
  fi
! rm -f conf$$.file
  
  # Sed expression to map a string onto a valid CPP name.
  as_tr_cpp="eval sed 'y%*$as_cr_letters%P$as_cr_LETTERS%;s%[^_$as_cr_alnum]%_%g'"
--- 5184,5313 ----
  	  }
  	  s/.*/./; q'`
  
! # Avoid depending upon Character Ranges.
! as_cr_letters='abcdefghijklmnopqrstuvwxyz'
! as_cr_LETTERS='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
! as_cr_Letters=$as_cr_letters$as_cr_LETTERS
! as_cr_digits='0123456789'
! as_cr_alnum=$as_cr_Letters$as_cr_digits
  
  ECHO_C= ECHO_N= ECHO_T=
! case `echo -n x` in #(((((
  -n*)
!   case `echo 'xy\c'` in
    *c*) ECHO_T='	';;	# ECHO_T is single tab character.
!   xy)  ECHO_C='\c';;
!   *)   echo `echo ksh88 bug on AIX 6.1` > /dev/null
!        ECHO_T='	';;
    esac;;
  *)
    ECHO_N='-n';;
  esac
  
  rm -f conf$$ conf$$.exe conf$$.file
  if test -d conf$$.dir; then
    rm -f conf$$.dir/conf$$.file
  else
    rm -f conf$$.dir
!   mkdir conf$$.dir 2>/dev/null
  fi
! if (echo >conf$$.file) 2>/dev/null; then
!   if ln -s conf$$.file conf$$ 2>/dev/null; then
!     as_ln_s='ln -s'
!     # ... but there are two gotchas:
!     # 1) On MSYS, both `ln -s file dir' and `ln file dir' fail.
!     # 2) DJGPP < 2.04 has no symlinks; `ln -s' creates a wrapper executable.
!     # In both cases, we have to default to `cp -p'.
!     ln -s conf$$.file conf$$.dir 2>/dev/null && test ! -f conf$$.exe ||
!       as_ln_s='cp -p'
!   elif ln conf$$.file conf$$ 2>/dev/null; then
!     as_ln_s=ln
!   else
      as_ln_s='cp -p'
!   fi
  else
    as_ln_s='cp -p'
  fi
  rm -f conf$$ conf$$.exe conf$$.dir/conf$$.file conf$$.file
  rmdir conf$$.dir 2>/dev/null
  
+ 
+ # as_fn_mkdir_p
+ # -------------
+ # Create "$as_dir" as a directory, including parents if necessary.
+ as_fn_mkdir_p ()
+ {
+ 
+   case $as_dir in #(
+   -*) as_dir=./$as_dir;;
+   esac
+   test -d "$as_dir" || eval $as_mkdir_p || {
+     as_dirs=
+     while :; do
+       case $as_dir in #(
+       *\'*) as_qdir=`$as_echo "$as_dir" | sed "s/'/'\\\\\\\\''/g"`;; #'(
+       *) as_qdir=$as_dir;;
+       esac
+       as_dirs="'$as_qdir' $as_dirs"
+       as_dir=`$as_dirname -- "$as_dir" ||
+ $as_expr X"$as_dir" : 'X\(.*[^/]\)//*[^/][^/]*/*$' \| \
+ 	 X"$as_dir" : 'X\(//\)[^/]' \| \
+ 	 X"$as_dir" : 'X\(//\)$' \| \
+ 	 X"$as_dir" : 'X\(/\)' \| . 2>/dev/null ||
+ $as_echo X"$as_dir" |
+     sed '/^X\(.*[^/]\)\/\/*[^/][^/]*\/*$/{
+ 	    s//\1/
+ 	    q
+ 	  }
+ 	  /^X\(\/\/\)[^/].*/{
+ 	    s//\1/
+ 	    q
+ 	  }
+ 	  /^X\(\/\/\)$/{
+ 	    s//\1/
+ 	    q
+ 	  }
+ 	  /^X\(\/\).*/{
+ 	    s//\1/
+ 	    q
+ 	  }
+ 	  s/.*/./; q'`
+       test -d "$as_dir" && break
+     done
+     test -z "$as_dirs" || eval "mkdir $as_dirs"
+   } || test -d "$as_dir" || as_fn_error "cannot create directory $as_dir"
+ 
+ 
+ } # as_fn_mkdir_p
  if mkdir -p . 2>/dev/null; then
!   as_mkdir_p='mkdir -p "$as_dir"'
  else
    test -d ./-p && rmdir ./-p
    as_mkdir_p=false
  fi
  
! if test -x / >/dev/null 2>&1; then
!   as_test_x='test -x'
  else
!   if ls -dL / >/dev/null 2>&1; then
!     as_ls_L_option=L
!   else
!     as_ls_L_option=
!   fi
!   as_test_x='
!     eval sh -c '\''
!       if test -d "$1"; then
! 	test -d "$1/.";
!       else
! 	case $1 in #(
! 	-*)set "./$1";;
! 	esac;
! 	case `ls -ld'$as_ls_L_option' "$1" 2>/dev/null` in #((
! 	???[sx]*):;;*)false;;esac;fi
!     '\'' sh
!   '
  fi
! as_executable_p=$as_test_x
  
  # Sed expression to map a string onto a valid CPP name.
  as_tr_cpp="eval sed 'y%*$as_cr_letters%P$as_cr_LETTERS%;s%[^_$as_cr_alnum]%_%g'"
***************
*** 6771,6783 ****
  
  
  exec 6>&1
  
! # Save the log message, to keep $[0] and so on meaningful, and to
  # report actual input values of CONFIG_FILES etc. instead of their
  # values after options handling.
  ac_log="
  This file was extended by wwwoffle $as_me 2.9, which was
! generated by GNU Autoconf 2.60a.  Invocation command line was
  
    CONFIG_FILES    = $CONFIG_FILES
    CONFIG_HEADERS  = $CONFIG_HEADERS
--- 5317,5335 ----
  
  
  exec 6>&1
+ ## ----------------------------------- ##
+ ## Main body of $CONFIG_STATUS script. ##
+ ## ----------------------------------- ##
+ _ASEOF
+ test $as_write_fail = 0 && chmod +x $CONFIG_STATUS || ac_write_fail=1
  
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
! # Save the log message, to keep $0 and so on meaningful, and to
  # report actual input values of CONFIG_FILES etc. instead of their
  # values after options handling.
  ac_log="
  This file was extended by wwwoffle $as_me 2.9, which was
! generated by GNU Autoconf 2.65.  Invocation command line was
  
    CONFIG_FILES    = $CONFIG_FILES
    CONFIG_HEADERS  = $CONFIG_HEADERS
***************
*** 6790,6818 ****
  
  _ACEOF
  
! cat >>$CONFIG_STATUS <<_ACEOF
  # Files that config.status was made for.
  config_files="$ac_config_files"
  config_headers="$ac_config_headers"
  
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF
  ac_cs_usage="\
! \`$as_me' instantiates files from templates according to the
! current configuration.
  
! Usage: $0 [OPTIONS] [FILE]...
  
    -h, --help       print this help, then exit
    -V, --version    print version number and configuration settings, then exit
!   -q, --quiet      do not print progress messages
    -d, --debug      don't remove temporary files
        --recheck    update $as_me by reconfiguring in the same conditions
!   --file=FILE[:TEMPLATE]
! 		   instantiate the configuration file FILE
!   --header=FILE[:TEMPLATE]
! 		   instantiate the configuration header FILE
  
  Configuration files:
  $config_files
--- 5342,5382 ----
  
  _ACEOF
  
! case $ac_config_files in *"
! "*) set x $ac_config_files; shift; ac_config_files=$*;;
! esac
! 
! case $ac_config_headers in *"
! "*) set x $ac_config_headers; shift; ac_config_headers=$*;;
! esac
! 
! 
! cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
  # Files that config.status was made for.
  config_files="$ac_config_files"
  config_headers="$ac_config_headers"
  
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
  ac_cs_usage="\
! \`$as_me' instantiates files and other configuration actions
! from templates according to the current configuration.  Unless the files
! and actions are specified as TAGs, all are instantiated by default.
  
! Usage: $0 [OPTION]... [TAG]...
  
    -h, --help       print this help, then exit
    -V, --version    print version number and configuration settings, then exit
!       --config     print configuration, then exit
!   -q, --quiet, --silent
!                    do not print progress messages
    -d, --debug      don't remove temporary files
        --recheck    update $as_me by reconfiguring in the same conditions
!       --file=FILE[:TEMPLATE]
!                    instantiate the configuration file FILE
!       --header=FILE[:TEMPLATE]
!                    instantiate the configuration header FILE
  
  Configuration files:
  $config_files
***************
*** 6820,6846 ****
  Configuration headers:
  $config_headers
  
! Report bugs to <bug-autoconf@gnu.org>."
  
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF
  ac_cs_version="\\
  wwwoffle config.status 2.9
! configured by $0, generated by GNU Autoconf 2.60a,
!   with options \\"`echo "$ac_configure_args" | sed 's/^ //; s/[\\""\`\$]/\\\\&/g'`\\"
  
! Copyright (C) 2006 Free Software Foundation, Inc.
  This config.status script is free software; the Free Software Foundation
  gives unlimited permission to copy, distribute and modify it."
  
  ac_pwd='$ac_pwd'
  srcdir='$srcdir'
  INSTALL='$INSTALL'
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF
! # If no file are specified by the user, then we need to provide default
! # value.  By we need to know if files were specified by the user.
  ac_need_defaults=:
  while test $# != 0
  do
--- 5384,5412 ----
  Configuration headers:
  $config_headers
  
! Report bugs to the package provider."
  
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
! ac_cs_config="`$as_echo "$ac_configure_args" | sed 's/^ //; s/[\\""\`\$]/\\\\&/g'`"
  ac_cs_version="\\
  wwwoffle config.status 2.9
! configured by $0, generated by GNU Autoconf 2.65,
!   with options \\"\$ac_cs_config\\"
  
! Copyright (C) 2009 Free Software Foundation, Inc.
  This config.status script is free software; the Free Software Foundation
  gives unlimited permission to copy, distribute and modify it."
  
  ac_pwd='$ac_pwd'
  srcdir='$srcdir'
  INSTALL='$INSTALL'
+ AWK='$AWK'
+ test -n "\$AWK" || AWK=awk
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
! # The default lists apply if the user does not specify any file.
  ac_need_defaults=:
  while test $# != 0
  do
***************
*** 6862,6895 ****
    -recheck | --recheck | --rechec | --reche | --rech | --rec | --re | --r)
      ac_cs_recheck=: ;;
    --version | --versio | --versi | --vers | --ver | --ve | --v | -V )
!     echo "$ac_cs_version"; exit ;;
    --debug | --debu | --deb | --de | --d | -d )
      debug=: ;;
    --file | --fil | --fi | --f )
      $ac_shift
!     CONFIG_FILES="$CONFIG_FILES $ac_optarg"
      ac_need_defaults=false;;
    --header | --heade | --head | --hea )
      $ac_shift
!     CONFIG_HEADERS="$CONFIG_HEADERS $ac_optarg"
      ac_need_defaults=false;;
    --he | --h)
      # Conflict between --help and --header
!     { echo "$as_me: error: ambiguous option: $1
! Try \`$0 --help' for more information." >&2
!    { (exit 1); exit 1; }; };;
    --help | --hel | -h )
!     echo "$ac_cs_usage"; exit ;;
    -q | -quiet | --quiet | --quie | --qui | --qu | --q \
    | -silent | --silent | --silen | --sile | --sil | --si | --s)
      ac_cs_silent=: ;;
  
    # This is an error.
!   -*) { echo "$as_me: error: unrecognized option: $1
! Try \`$0 --help' for more information." >&2
!    { (exit 1); exit 1; }; } ;;
  
!   *) ac_config_targets="$ac_config_targets $1"
       ac_need_defaults=false ;;
  
    esac
--- 5428,5467 ----
    -recheck | --recheck | --rechec | --reche | --rech | --rec | --re | --r)
      ac_cs_recheck=: ;;
    --version | --versio | --versi | --vers | --ver | --ve | --v | -V )
!     $as_echo "$ac_cs_version"; exit ;;
!   --config | --confi | --conf | --con | --co | --c )
!     $as_echo "$ac_cs_config"; exit ;;
    --debug | --debu | --deb | --de | --d | -d )
      debug=: ;;
    --file | --fil | --fi | --f )
      $ac_shift
!     case $ac_optarg in
!     *\'*) ac_optarg=`$as_echo "$ac_optarg" | sed "s/'/'\\\\\\\\''/g"` ;;
!     esac
!     as_fn_append CONFIG_FILES " '$ac_optarg'"
      ac_need_defaults=false;;
    --header | --heade | --head | --hea )
      $ac_shift
!     case $ac_optarg in
!     *\'*) ac_optarg=`$as_echo "$ac_optarg" | sed "s/'/'\\\\\\\\''/g"` ;;
!     esac
!     as_fn_append CONFIG_HEADERS " '$ac_optarg'"
      ac_need_defaults=false;;
    --he | --h)
      # Conflict between --help and --header
!     as_fn_error "ambiguous option: \`$1'
! Try \`$0 --help' for more information.";;
    --help | --hel | -h )
!     $as_echo "$ac_cs_usage"; exit ;;
    -q | -quiet | --quiet | --quie | --qui | --qu | --q \
    | -silent | --silent | --silen | --sile | --sil | --si | --s)
      ac_cs_silent=: ;;
  
    # This is an error.
!   -*) as_fn_error "unrecognized option: \`$1'
! Try \`$0 --help' for more information." ;;
  
!   *) as_fn_append ac_config_targets " $1"
       ac_need_defaults=false ;;
  
    esac
***************
*** 6904,6933 ****
  fi
  
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF
  if \$ac_cs_recheck; then
!   echo "running CONFIG_SHELL=$SHELL $SHELL $0 "$ac_configure_args \$ac_configure_extra_args " --no-create --no-recursion" >&6
!   CONFIG_SHELL=$SHELL
    export CONFIG_SHELL
!   exec $SHELL "$0"$ac_configure_args \$ac_configure_extra_args --no-create --no-recursion
  fi
  
  _ACEOF
! cat >>$CONFIG_STATUS <<\_ACEOF
  exec 5>>config.log
  {
    echo
    sed 'h;s/./-/g;s/^.../## /;s/...$/ ##/;p;x;p;x' <<_ASBOX
  ## Running $as_me. ##
  _ASBOX
!   echo "$ac_log"
  } >&5
  
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF
  
  # Handling of arguments.
  for ac_config_target in $ac_config_targets
--- 5476,5507 ----
  fi
  
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
  if \$ac_cs_recheck; then
!   set X '$SHELL' '$0' $ac_configure_args \$ac_configure_extra_args --no-create --no-recursion
!   shift
!   \$as_echo "running CONFIG_SHELL=$SHELL \$*" >&6
!   CONFIG_SHELL='$SHELL'
    export CONFIG_SHELL
!   exec "\$@"
  fi
  
  _ACEOF
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
  exec 5>>config.log
  {
    echo
    sed 'h;s/./-/g;s/^.../## /;s/...$/ ##/;p;x;p;x' <<_ASBOX
  ## Running $as_me. ##
  _ASBOX
!   $as_echo "$ac_log"
  } >&5
  
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
  
  # Handling of arguments.
  for ac_config_target in $ac_config_targets
***************
*** 6942,6950 ****
      "src/testprogs/Makefile") CONFIG_FILES="$CONFIG_FILES src/testprogs/Makefile" ;;
      "src/autoconfig.h.in") CONFIG_FILES="$CONFIG_FILES src/autoconfig.h.in" ;;
  
!   *) { { echo "$as_me:$LINENO: error: invalid argument: $ac_config_target" >&5
! echo "$as_me: error: invalid argument: $ac_config_target" >&2;}
!    { (exit 1); exit 1; }; };;
    esac
  done
  
--- 5516,5522 ----
      "src/testprogs/Makefile") CONFIG_FILES="$CONFIG_FILES src/testprogs/Makefile" ;;
      "src/autoconfig.h.in") CONFIG_FILES="$CONFIG_FILES src/autoconfig.h.in" ;;
  
!   *) as_fn_error "invalid argument: \`$ac_config_target'" "$LINENO" 5;;
    esac
  done
  
***************
*** 6970,6976 ****
    trap 'exit_status=$?
    { test -z "$tmp" || test ! -d "$tmp" || rm -fr "$tmp"; } && exit $exit_status
  ' 0
!   trap '{ (exit 1); exit 1; }' 1 2 13 15
  }
  # Create a (secure) tmp directory for tmp files.
  
--- 5542,5548 ----
    trap 'exit_status=$?
    { test -z "$tmp" || test ! -d "$tmp" || rm -fr "$tmp"; } && exit $exit_status
  ' 0
!   trap 'as_fn_exit 1' 1 2 13 15
  }
  # Create a (secure) tmp directory for tmp files.
  
***************
*** 6981,7128 ****
  {
    tmp=./conf$$-$RANDOM
    (umask 077 && mkdir "$tmp")
! } ||
! {
!    echo "$me: cannot create a temporary directory in ." >&2
!    { (exit 1); exit 1; }
! }
! 
! #
! # Set up the sed scripts for CONFIG_FILES section.
! #
  
! # No need to generate the scripts if there are no CONFIG_FILES.
! # This happens for instance when ./config.status config.h
  if test -n "$CONFIG_FILES"; then
  
- _ACEOF
  
  
  
  ac_delim='%!_!# '
  for ac_last_try in false false false false false :; do
!   cat >conf$$subs.sed <<_ACEOF
! SHELL!$SHELL$ac_delim
! PATH_SEPARATOR!$PATH_SEPARATOR$ac_delim
! PACKAGE_NAME!$PACKAGE_NAME$ac_delim
! PACKAGE_TARNAME!$PACKAGE_TARNAME$ac_delim
! PACKAGE_VERSION!$PACKAGE_VERSION$ac_delim
! PACKAGE_STRING!$PACKAGE_STRING$ac_delim
! PACKAGE_BUGREPORT!$PACKAGE_BUGREPORT$ac_delim
! exec_prefix!$exec_prefix$ac_delim
! prefix!$prefix$ac_delim
! program_transform_name!$program_transform_name$ac_delim
! bindir!$bindir$ac_delim
! sbindir!$sbindir$ac_delim
! libexecdir!$libexecdir$ac_delim
! datarootdir!$datarootdir$ac_delim
! datadir!$datadir$ac_delim
! sysconfdir!$sysconfdir$ac_delim
! sharedstatedir!$sharedstatedir$ac_delim
! localstatedir!$localstatedir$ac_delim
! includedir!$includedir$ac_delim
! oldincludedir!$oldincludedir$ac_delim
! docdir!$docdir$ac_delim
! infodir!$infodir$ac_delim
! htmldir!$htmldir$ac_delim
! dvidir!$dvidir$ac_delim
! pdfdir!$pdfdir$ac_delim
! psdir!$psdir$ac_delim
! libdir!$libdir$ac_delim
! localedir!$localedir$ac_delim
! mandir!$mandir$ac_delim
! DEFS!$DEFS$ac_delim
! ECHO_C!$ECHO_C$ac_delim
! ECHO_N!$ECHO_N$ac_delim
! ECHO_T!$ECHO_T$ac_delim
! LIBS!$LIBS$ac_delim
! build_alias!$build_alias$ac_delim
! host_alias!$host_alias$ac_delim
! target_alias!$target_alias$ac_delim
! CC!$CC$ac_delim
! CFLAGS!$CFLAGS$ac_delim
! LDFLAGS!$LDFLAGS$ac_delim
! CPPFLAGS!$CPPFLAGS$ac_delim
! ac_ct_CC!$ac_ct_CC$ac_delim
! EXEEXT!$EXEEXT$ac_delim
! OBJEXT!$OBJEXT$ac_delim
! LEX!$LEX$ac_delim
! LEX_OUTPUT_ROOT!$LEX_OUTPUT_ROOT$ac_delim
! LEXLIB!$LEXLIB$ac_delim
! INSTALL_PROGRAM!$INSTALL_PROGRAM$ac_delim
! INSTALL_SCRIPT!$INSTALL_SCRIPT$ac_delim
! INSTALL_DATA!$INSTALL_DATA$ac_delim
! AWK!$AWK$ac_delim
! SET_MAKE!$SET_MAKE$ac_delim
! TAR!$TAR$ac_delim
! PERL!$PERL$ac_delim
! CPP!$CPP$ac_delim
! GREP!$GREP$ac_delim
! EGREP!$EGREP$ac_delim
! LIBOBJS!$LIBOBJS$ac_delim
! ETR_SOCKET_LIBS!$ETR_SOCKET_LIBS$ac_delim
! ZLIB_LIB!$ZLIB_LIB$ac_delim
! ZLIB_INC!$ZLIB_INC$ac_delim
! LIBGNUTLS_CONFIG!$LIBGNUTLS_CONFIG$ac_delim
! GNUTLS_LIB!$GNUTLS_LIB$ac_delim
! GNUTLS_INC!$GNUTLS_INC$ac_delim
! build!$build$ac_delim
! build_cpu!$build_cpu$ac_delim
! build_vendor!$build_vendor$ac_delim
! build_os!$build_os$ac_delim
! host!$host$ac_delim
! host_cpu!$host_cpu$ac_delim
! host_vendor!$host_vendor$ac_delim
! host_os!$host_os$ac_delim
! install_win32!$install_win32$ac_delim
! SPOOLDIR!$SPOOLDIR$ac_delim
! CONFDIR!$CONFDIR$ac_delim
! LOCALHOST!$LOCALHOST$ac_delim
! HTTP_PORT!$HTTP_PORT$ac_delim
! HTTPS_PORT!$HTTPS_PORT$ac_delim
! WWWOFFLE_PORT!$WWWOFFLE_PORT$ac_delim
! LANGUAGES!$LANGUAGES$ac_delim
! DEFLANG!$DEFLANG$ac_delim
! LTLIBOBJS!$LTLIBOBJS$ac_delim
! _ACEOF
  
!   if test `sed -n "s/.*$ac_delim\$/X/p" conf$$subs.sed | grep -c X` = 82; then
      break
    elif $ac_last_try; then
!     { { echo "$as_me:$LINENO: error: could not make $CONFIG_STATUS" >&5
! echo "$as_me: error: could not make $CONFIG_STATUS" >&2;}
!    { (exit 1); exit 1; }; }
    else
      ac_delim="$ac_delim!$ac_delim _$ac_delim!! "
    fi
  done
  
! ac_eof=`sed -n '/^CEOF[0-9]*$/s/CEOF/0/p' conf$$subs.sed`
! if test -n "$ac_eof"; then
!   ac_eof=`echo "$ac_eof" | sort -nru | sed 1q`
!   ac_eof=`expr $ac_eof + 1`
! fi
! 
! cat >>$CONFIG_STATUS <<_ACEOF
! cat >"\$tmp/subs-1.sed" <<\CEOF$ac_eof
! /@[a-zA-Z_][a-zA-Z_0-9]*@/!b end
! _ACEOF
! sed '
! s/[,\\&]/\\&/g; s/@/@|#_!!_#|/g
! s/^/s,@/; s/!/@,|#_!!_#|/
! :n
! t n
! s/'"$ac_delim"'$/,g/; t
! s/$/\\/; p
! N; s/^.*\n//; s/[,\\&]/\\&/g; s/@/@|#_!!_#|/g; b n
! ' >>$CONFIG_STATUS <conf$$subs.sed
! rm -f conf$$subs.sed
! cat >>$CONFIG_STATUS <<_ACEOF
! :end
! s/|#_!!_#|//g
! CEOF$ac_eof
  _ACEOF
  
  
  # VPATH may cause trouble with some makes, so we remove $(srcdir),
  # ${srcdir} and @srcdir@ from VPATH if srcdir is ".", strip leading and
--- 5553,5691 ----
  {
    tmp=./conf$$-$RANDOM
    (umask 077 && mkdir "$tmp")
! } || as_fn_error "cannot create a temporary directory in ." "$LINENO" 5
  
! # Set up the scripts for CONFIG_FILES section.
! # No need to generate them if there are no CONFIG_FILES.
! # This happens for instance with `./config.status config.h'.
  if test -n "$CONFIG_FILES"; then
  
  
+ ac_cr=`echo X | tr X '\015'`
+ # On cygwin, bash can eat \r inside `` if the user requested igncr.
+ # But we know of no other shell where ac_cr would be empty at this
+ # point, so we can use a bashism as a fallback.
+ if test "x$ac_cr" = x; then
+   eval ac_cr=\$\'\\r\'
+ fi
+ ac_cs_awk_cr=`$AWK 'BEGIN { print "a\rb" }' </dev/null 2>/dev/null`
+ if test "$ac_cs_awk_cr" = "a${ac_cr}b"; then
+   ac_cs_awk_cr='\r'
+ else
+   ac_cs_awk_cr=$ac_cr
+ fi
+ 
+ echo 'BEGIN {' >"$tmp/subs1.awk" &&
+ _ACEOF
  
  
+ {
+   echo "cat >conf$$subs.awk <<_ACEOF" &&
+   echo "$ac_subst_vars" | sed 's/.*/&!$&$ac_delim/' &&
+   echo "_ACEOF"
+ } >conf$$subs.sh ||
+   as_fn_error "could not make $CONFIG_STATUS" "$LINENO" 5
+ ac_delim_num=`echo "$ac_subst_vars" | grep -c '$'`
  ac_delim='%!_!# '
  for ac_last_try in false false false false false :; do
!   . ./conf$$subs.sh ||
!     as_fn_error "could not make $CONFIG_STATUS" "$LINENO" 5
  
!   ac_delim_n=`sed -n "s/.*$ac_delim\$/X/p" conf$$subs.awk | grep -c X`
!   if test $ac_delim_n = $ac_delim_num; then
      break
    elif $ac_last_try; then
!     as_fn_error "could not make $CONFIG_STATUS" "$LINENO" 5
    else
      ac_delim="$ac_delim!$ac_delim _$ac_delim!! "
    fi
  done
+ rm -f conf$$subs.sh
  
! cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
! cat >>"\$tmp/subs1.awk" <<\\_ACAWK &&
  _ACEOF
+ sed -n '
+ h
+ s/^/S["/; s/!.*/"]=/
+ p
+ g
+ s/^[^!]*!//
+ :repl
+ t repl
+ s/'"$ac_delim"'$//
+ t delim
+ :nl
+ h
+ s/\(.\{148\}\)..*/\1/
+ t more1
+ s/["\\]/\\&/g; s/^/"/; s/$/\\n"\\/
+ p
+ n
+ b repl
+ :more1
+ s/["\\]/\\&/g; s/^/"/; s/$/"\\/
+ p
+ g
+ s/.\{148\}//
+ t nl
+ :delim
+ h
+ s/\(.\{148\}\)..*/\1/
+ t more2
+ s/["\\]/\\&/g; s/^/"/; s/$/"/
+ p
+ b
+ :more2
+ s/["\\]/\\&/g; s/^/"/; s/$/"\\/
+ p
+ g
+ s/.\{148\}//
+ t delim
+ ' <conf$$subs.awk | sed '
+ /^[^""]/{
+   N
+   s/\n//
+ }
+ ' >>$CONFIG_STATUS || ac_write_fail=1
+ rm -f conf$$subs.awk
+ cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
+ _ACAWK
+ cat >>"\$tmp/subs1.awk" <<_ACAWK &&
+   for (key in S) S_is_set[key] = 1
+   FS = ""
  
+ }
+ {
+   line = $ 0
+   nfields = split(line, field, "@")
+   substed = 0
+   len = length(field[1])
+   for (i = 2; i < nfields; i++) {
+     key = field[i]
+     keylen = length(key)
+     if (S_is_set[key]) {
+       value = S[key]
+       line = substr(line, 1, len) "" value "" substr(line, len + keylen + 3)
+       len += length(value) + length(field[++i])
+       substed = 1
+     } else
+       len += 1 + keylen
+   }
+ 
+   print line
+ }
+ 
+ _ACAWK
+ _ACEOF
+ cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
+ if sed "s/$ac_cr//" < /dev/null > /dev/null 2>&1; then
+   sed "s/$ac_cr\$//; s/$ac_cr/$ac_cs_awk_cr/g"
+ else
+   cat
+ fi < "$tmp/subs1.awk" > "$tmp/subs.awk" \
+   || as_fn_error "could not setup config files machinery" "$LINENO" 5
+ _ACEOF
  
  # VPATH may cause trouble with some makes, so we remove $(srcdir),
  # ${srcdir} and @srcdir@ from VPATH if srcdir is ".", strip leading and
***************
*** 7139,7158 ****
  }'
  fi
  
! cat >>$CONFIG_STATUS <<\_ACEOF
  fi # test -n "$CONFIG_FILES"
  
  
! for ac_tag in  :F $CONFIG_FILES  :H $CONFIG_HEADERS
  do
    case $ac_tag in
    :[FHLC]) ac_mode=$ac_tag; continue;;
    esac
    case $ac_mode$ac_tag in
    :[FHL]*:*);;
!   :L* | :C*:*) { { echo "$as_me:$LINENO: error: Invalid tag $ac_tag." >&5
! echo "$as_me: error: Invalid tag $ac_tag." >&2;}
!    { (exit 1); exit 1; }; };;
    :[FH]-) ac_tag=-:-;;
    :[FH]*) ac_tag=$ac_tag:$ac_tag.in;;
    esac
--- 5702,5829 ----
  }'
  fi
  
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
  fi # test -n "$CONFIG_FILES"
  
+ # Set up the scripts for CONFIG_HEADERS section.
+ # No need to generate them if there are no CONFIG_HEADERS.
+ # This happens for instance with `./config.status Makefile'.
+ if test -n "$CONFIG_HEADERS"; then
+ cat >"$tmp/defines.awk" <<\_ACAWK ||
+ BEGIN {
+ _ACEOF
+ 
+ # Transform confdefs.h into an awk script `defines.awk', embedded as
+ # here-document in config.status, that substitutes the proper values into
+ # config.h.in to produce config.h.
+ 
+ # Create a delimiter string that does not exist in confdefs.h, to ease
+ # handling of long lines.
+ ac_delim='%!_!# '
+ for ac_last_try in false false :; do
+   ac_t=`sed -n "/$ac_delim/p" confdefs.h`
+   if test -z "$ac_t"; then
+     break
+   elif $ac_last_try; then
+     as_fn_error "could not make $CONFIG_HEADERS" "$LINENO" 5
+   else
+     ac_delim="$ac_delim!$ac_delim _$ac_delim!! "
+   fi
+ done
+ 
+ # For the awk script, D is an array of macro values keyed by name,
+ # likewise P contains macro parameters if any.  Preserve backslash
+ # newline sequences.
+ 
+ ac_word_re=[_$as_cr_Letters][_$as_cr_alnum]*
+ sed -n '
+ s/.\{148\}/&'"$ac_delim"'/g
+ t rset
+ :rset
+ s/^[	 ]*#[	 ]*define[	 ][	 ]*/ /
+ t def
+ d
+ :def
+ s/\\$//
+ t bsnl
+ s/["\\]/\\&/g
+ s/^ \('"$ac_word_re"'\)\(([^()]*)\)[	 ]*\(.*\)/P["\1"]="\2"\
+ D["\1"]=" \3"/p
+ s/^ \('"$ac_word_re"'\)[	 ]*\(.*\)/D["\1"]=" \2"/p
+ d
+ :bsnl
+ s/["\\]/\\&/g
+ s/^ \('"$ac_word_re"'\)\(([^()]*)\)[	 ]*\(.*\)/P["\1"]="\2"\
+ D["\1"]=" \3\\\\\\n"\\/p
+ t cont
+ s/^ \('"$ac_word_re"'\)[	 ]*\(.*\)/D["\1"]=" \2\\\\\\n"\\/p
+ t cont
+ d
+ :cont
+ n
+ s/.\{148\}/&'"$ac_delim"'/g
+ t clear
+ :clear
+ s/\\$//
+ t bsnlc
+ s/["\\]/\\&/g; s/^/"/; s/$/"/p
+ d
+ :bsnlc
+ s/["\\]/\\&/g; s/^/"/; s/$/\\\\\\n"\\/p
+ b cont
+ ' <confdefs.h | sed '
+ s/'"$ac_delim"'/"\\\
+ "/g' >>$CONFIG_STATUS || ac_write_fail=1
+ 
+ cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
+   for (key in D) D_is_set[key] = 1
+   FS = ""
+ }
+ /^[\t ]*#[\t ]*(define|undef)[\t ]+$ac_word_re([\t (]|\$)/ {
+   line = \$ 0
+   split(line, arg, " ")
+   if (arg[1] == "#") {
+     defundef = arg[2]
+     mac1 = arg[3]
+   } else {
+     defundef = substr(arg[1], 2)
+     mac1 = arg[2]
+   }
+   split(mac1, mac2, "(") #)
+   macro = mac2[1]
+   prefix = substr(line, 1, index(line, defundef) - 1)
+   if (D_is_set[macro]) {
+     # Preserve the white space surrounding the "#".
+     print prefix "define", macro P[macro] D[macro]
+     next
+   } else {
+     # Replace #undef with comments.  This is necessary, for example,
+     # in the case of _POSIX_SOURCE, which is predefined and required
+     # on some systems where configure will not decide to define it.
+     if (defundef == "undef") {
+       print "/*", prefix defundef, macro, "*/"
+       next
+     }
+   }
+ }
+ { print }
+ _ACAWK
+ _ACEOF
+ cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
+   as_fn_error "could not setup config headers machinery" "$LINENO" 5
+ fi # test -n "$CONFIG_HEADERS"
  
! 
! eval set X "  :F $CONFIG_FILES  :H $CONFIG_HEADERS    "
! shift
! for ac_tag
  do
    case $ac_tag in
    :[FHLC]) ac_mode=$ac_tag; continue;;
    esac
    case $ac_mode$ac_tag in
    :[FHL]*:*);;
!   :L* | :C*:*) as_fn_error "invalid tag \`$ac_tag'" "$LINENO" 5;;
    :[FH]-) ac_tag=-:-;;
    :[FH]*) ac_tag=$ac_tag:$ac_tag.in;;
    esac
***************
*** 7180,7205 ****
  	   [\\/$]*) false;;
  	   *) test -f "$srcdir/$ac_f" && ac_f="$srcdir/$ac_f";;
  	   esac ||
! 	   { { echo "$as_me:$LINENO: error: cannot find input file: $ac_f" >&5
! echo "$as_me: error: cannot find input file: $ac_f" >&2;}
!    { (exit 1); exit 1; }; };;
        esac
!       ac_file_inputs="$ac_file_inputs $ac_f"
      done
  
      # Let's still pretend it is `configure' which instantiates (i.e., don't
      # use $as_me), people would be surprised to read:
      #    /* config.h.  Generated by config.status.  */
!     configure_input="Generated from "`IFS=:
! 	  echo $* | sed 's|^[^:]*/||;s|:[^:]*/|, |g'`" by configure."
      if test x"$ac_file" != x-; then
        configure_input="$ac_file.  $configure_input"
!       { echo "$as_me:$LINENO: creating $ac_file" >&5
! echo "$as_me: creating $ac_file" >&6;}
      fi
  
      case $ac_tag in
!     *:-:* | *:-) cat >"$tmp/stdin";;
      esac
      ;;
    esac
--- 5851,5884 ----
  	   [\\/$]*) false;;
  	   *) test -f "$srcdir/$ac_f" && ac_f="$srcdir/$ac_f";;
  	   esac ||
! 	   as_fn_error "cannot find input file: \`$ac_f'" "$LINENO" 5;;
        esac
!       case $ac_f in *\'*) ac_f=`$as_echo "$ac_f" | sed "s/'/'\\\\\\\\''/g"`;; esac
!       as_fn_append ac_file_inputs " '$ac_f'"
      done
  
      # Let's still pretend it is `configure' which instantiates (i.e., don't
      # use $as_me), people would be surprised to read:
      #    /* config.h.  Generated by config.status.  */
!     configure_input='Generated from '`
! 	  $as_echo "$*" | sed 's|^[^:]*/||;s|:[^:]*/|, |g'
! 	`' by configure.'
      if test x"$ac_file" != x-; then
        configure_input="$ac_file.  $configure_input"
!       { $as_echo "$as_me:${as_lineno-$LINENO}: creating $ac_file" >&5
! $as_echo "$as_me: creating $ac_file" >&6;}
      fi
+     # Neutralize special characters interpreted by sed in replacement strings.
+     case $configure_input in #(
+     *\&* | *\|* | *\\* )
+        ac_sed_conf_input=`$as_echo "$configure_input" |
+        sed 's/[\\\\&|]/\\\\&/g'`;; #(
+     *) ac_sed_conf_input=$configure_input;;
+     esac
  
      case $ac_tag in
!     *:-:* | *:-) cat >"$tmp/stdin" \
!       || as_fn_error "could not create $ac_file" "$LINENO" 5 ;;
      esac
      ;;
    esac
***************
*** 7209,7250 ****
  	 X"$ac_file" : 'X\(//\)[^/]' \| \
  	 X"$ac_file" : 'X\(//\)$' \| \
  	 X"$ac_file" : 'X\(/\)' \| . 2>/dev/null ||
! echo X"$ac_file" |
!     sed '/^X\(.*[^/]\)\/\/*[^/][^/]*\/*$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\(\/\/\)[^/].*/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\(\/\/\)$/{
! 	    s//\1/
! 	    q
! 	  }
! 	  /^X\(\/\).*/{
! 	    s//\1/
! 	    q
! 	  }
! 	  s/.*/./; q'`
!   { as_dir="$ac_dir"
!   case $as_dir in #(
!   -*) as_dir=./$as_dir;;
!   esac
!   test -d "$as_dir" || { $as_mkdir_p && mkdir -p "$as_dir"; } || {
!     as_dirs=
!     while :; do
!       case $as_dir in #(
!       *\'*) as_qdir=`echo "$as_dir" | sed "s/'/'\\\\\\\\''/g"`;; #(
!       *) as_qdir=$as_dir;;
!       esac
!       as_dirs="'$as_qdir' $as_dirs"
!       as_dir=`$as_dirname -- "$as_dir" ||
! $as_expr X"$as_dir" : 'X\(.*[^/]\)//*[^/][^/]*/*$' \| \
! 	 X"$as_dir" : 'X\(//\)[^/]' \| \
! 	 X"$as_dir" : 'X\(//\)$' \| \
! 	 X"$as_dir" : 'X\(/\)' \| . 2>/dev/null ||
! echo X"$as_dir" |
      sed '/^X\(.*[^/]\)\/\/*[^/][^/]*\/*$/{
  	    s//\1/
  	    q
--- 5888,5894 ----
  	 X"$ac_file" : 'X\(//\)[^/]' \| \
  	 X"$ac_file" : 'X\(//\)$' \| \
  	 X"$ac_file" : 'X\(/\)' \| . 2>/dev/null ||
! $as_echo X"$ac_file" |
      sed '/^X\(.*[^/]\)\/\/*[^/][^/]*\/*$/{
  	    s//\1/
  	    q
***************
*** 7262,7281 ****
  	    q
  	  }
  	  s/.*/./; q'`
!       test -d "$as_dir" && break
!     done
!     test -z "$as_dirs" || eval "mkdir $as_dirs"
!   } || test -d "$as_dir" || { { echo "$as_me:$LINENO: error: cannot create directory $as_dir" >&5
! echo "$as_me: error: cannot create directory $as_dir" >&2;}
!    { (exit 1); exit 1; }; }; }
    ac_builddir=.
  
  case "$ac_dir" in
  .) ac_dir_suffix= ac_top_builddir_sub=. ac_top_build_prefix= ;;
  *)
!   ac_dir_suffix=/`echo "$ac_dir" | sed 's,^\.[\\/],,'`
    # A ".." for each directory in $ac_dir_suffix.
!   ac_top_builddir_sub=`echo "$ac_dir_suffix" | sed 's,/[^\\/]*,/..,g;s,/,,'`
    case $ac_top_builddir_sub in
    "") ac_top_builddir_sub=. ac_top_build_prefix= ;;
    *)  ac_top_build_prefix=$ac_top_builddir_sub/ ;;
--- 5906,5920 ----
  	    q
  	  }
  	  s/.*/./; q'`
!   as_dir="$ac_dir"; as_fn_mkdir_p
    ac_builddir=.
  
  case "$ac_dir" in
  .) ac_dir_suffix= ac_top_builddir_sub=. ac_top_build_prefix= ;;
  *)
!   ac_dir_suffix=/`$as_echo "$ac_dir" | sed 's|^\.[\\/]||'`
    # A ".." for each directory in $ac_dir_suffix.
!   ac_top_builddir_sub=`$as_echo "$ac_dir_suffix" | sed 's|/[^\\/]*|/..|g;s|/||'`
    case $ac_top_builddir_sub in
    "") ac_top_builddir_sub=. ac_top_build_prefix= ;;
    *)  ac_top_build_prefix=$ac_top_builddir_sub/ ;;
***************
*** 7315,7326 ****
    esac
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF
  # If the template does not know about datarootdir, expand it.
  # FIXME: This hack should be removed a few years after 2.60.
  ac_datarootdir_hack=; ac_datarootdir_seen=
! 
! case `sed -n '/datarootdir/ {
    p
    q
  }
--- 5954,5965 ----
    esac
  _ACEOF
  
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
  # If the template does not know about datarootdir, expand it.
  # FIXME: This hack should be removed a few years after 2.60.
  ac_datarootdir_hack=; ac_datarootdir_seen=
! ac_sed_dataroot='
! /datarootdir/ {
    p
    q
  }
***************
*** 7328,7363 ****
  /@docdir@/p
  /@infodir@/p
  /@localedir@/p
! /@mandir@/p
! ' $ac_file_inputs` in
  *datarootdir*) ac_datarootdir_seen=yes;;
  *@datadir@*|*@docdir@*|*@infodir@*|*@localedir@*|*@mandir@*)
!   { echo "$as_me:$LINENO: WARNING: $ac_file_inputs seems to ignore the --datarootdir setting" >&5
! echo "$as_me: WARNING: $ac_file_inputs seems to ignore the --datarootdir setting" >&2;}
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF
    ac_datarootdir_hack='
    s&@datadir@&$datadir&g
    s&@docdir@&$docdir&g
    s&@infodir@&$infodir&g
    s&@localedir@&$localedir&g
    s&@mandir@&$mandir&g
!     s&\\\${datarootdir}&$datarootdir&g' ;;
  esac
  _ACEOF
  
  # Neutralize VPATH when `$srcdir' = `.'.
  # Shell code in configure.ac might set extrasub.
  # FIXME: do we really want to maintain this feature?
! cat >>$CONFIG_STATUS <<_ACEOF
!   sed "$ac_vpsub
  $extrasub
  _ACEOF
! cat >>$CONFIG_STATUS <<\_ACEOF
  :t
  /@[a-zA-Z_][a-zA-Z_0-9]*@/!b
! s&@configure_input@&$configure_input&;t t
  s&@top_builddir@&$ac_top_builddir_sub&;t t
  s&@srcdir@&$ac_srcdir&;t t
  s&@abs_srcdir@&$ac_abs_srcdir&;t t
  s&@top_srcdir@&$ac_top_srcdir&;t t
--- 5967,6003 ----
  /@docdir@/p
  /@infodir@/p
  /@localedir@/p
! /@mandir@/p'
! case `eval "sed -n \"\$ac_sed_dataroot\" $ac_file_inputs"` in
  *datarootdir*) ac_datarootdir_seen=yes;;
  *@datadir@*|*@docdir@*|*@infodir@*|*@localedir@*|*@mandir@*)
!   { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $ac_file_inputs seems to ignore the --datarootdir setting" >&5
! $as_echo "$as_me: WARNING: $ac_file_inputs seems to ignore the --datarootdir setting" >&2;}
  _ACEOF
! cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
    ac_datarootdir_hack='
    s&@datadir@&$datadir&g
    s&@docdir@&$docdir&g
    s&@infodir@&$infodir&g
    s&@localedir@&$localedir&g
    s&@mandir@&$mandir&g
!   s&\\\${datarootdir}&$datarootdir&g' ;;
  esac
  _ACEOF
  
  # Neutralize VPATH when `$srcdir' = `.'.
  # Shell code in configure.ac might set extrasub.
  # FIXME: do we really want to maintain this feature?
! cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
! ac_sed_extra="$ac_vpsub
  $extrasub
  _ACEOF
! cat >>$CONFIG_STATUS <<\_ACEOF || ac_write_fail=1
  :t
  /@[a-zA-Z_][a-zA-Z_0-9]*@/!b
! s|@configure_input@|$ac_sed_conf_input|;t t
  s&@top_builddir@&$ac_top_builddir_sub&;t t
+ s&@top_build_prefix@&$ac_top_build_prefix&;t t
  s&@srcdir@&$ac_srcdir&;t t
  s&@abs_srcdir@&$ac_abs_srcdir&;t t
  s&@top_srcdir@&$ac_top_srcdir&;t t
***************
*** 7367,7485 ****
  s&@abs_top_builddir@&$ac_abs_top_builddir&;t t
  s&@INSTALL@&$ac_INSTALL&;t t
  $ac_datarootdir_hack
! " $ac_file_inputs | sed -f "$tmp/subs-1.sed" >$tmp/out
  
  test -z "$ac_datarootdir_hack$ac_datarootdir_seen" &&
    { ac_out=`sed -n '/\${datarootdir}/p' "$tmp/out"`; test -n "$ac_out"; } &&
    { ac_out=`sed -n '/^[	 ]*datarootdir[	 ]*:*=/p' "$tmp/out"`; test -z "$ac_out"; } &&
!   { echo "$as_me:$LINENO: WARNING: $ac_file contains a reference to the variable \`datarootdir'
  which seems to be undefined.  Please make sure it is defined." >&5
! echo "$as_me: WARNING: $ac_file contains a reference to the variable \`datarootdir'
  which seems to be undefined.  Please make sure it is defined." >&2;}
  
    rm -f "$tmp/stdin"
    case $ac_file in
!   -) cat "$tmp/out"; rm -f "$tmp/out";;
!   *) rm -f "$ac_file"; mv "$tmp/out" $ac_file;;
!   esac
   ;;
    :H)
    #
    # CONFIG_HEADER
    #
- _ACEOF
- 
- # Transform confdefs.h into a sed script `conftest.defines', that
- # substitutes the proper values into config.h.in to produce config.h.
- rm -f conftest.defines conftest.tail
- # First, append a space to every undef/define line, to ease matching.
- echo 's/$/ /' >conftest.defines
- # Then, protect against being on the right side of a sed subst, or in
- # an unquoted here document, in config.status.  If some macros were
- # called several times there might be several #defines for the same
- # symbol, which is useless.  But do not sort them, since the last
- # AC_DEFINE must be honored.
- ac_word_re=[_$as_cr_Letters][_$as_cr_alnum]*
- # These sed commands are passed to sed as "A NAME B PARAMS C VALUE D", where
- # NAME is the cpp macro being defined, VALUE is the value it is being given.
- # PARAMS is the parameter list in the macro definition--in most cases, it's
- # just an empty string.
- ac_dA='s,^\\([	 #]*\\)[^	 ]*\\([	 ]*'
- ac_dB='\\)[	 (].*,\\1define\\2'
- ac_dC=' '
- ac_dD=' ,'
- 
- uniq confdefs.h |
-   sed -n '
- 	t rset
- 	:rset
- 	s/^[	 ]*#[	 ]*define[	 ][	 ]*//
- 	t ok
- 	d
- 	:ok
- 	s/[\\&,]/\\&/g
- 	s/^\('"$ac_word_re"'\)\(([^()]*)\)[	 ]*\(.*\)/ '"$ac_dA"'\1'"$ac_dB"'\2'"${ac_dC}"'\3'"$ac_dD"'/p
- 	s/^\('"$ac_word_re"'\)[	 ]*\(.*\)/'"$ac_dA"'\1'"$ac_dB$ac_dC"'\2'"$ac_dD"'/p
-   ' >>conftest.defines
- 
- # Remove the space that was appended to ease matching.
- # Then replace #undef with comments.  This is necessary, for
- # example, in the case of _POSIX_SOURCE, which is predefined and required
- # on some systems where configure will not decide to define it.
- # (The regexp can be short, since the line contains either #define or #undef.)
- echo 's/ $//
- s,^[	 #]*u.*,/* & */,' >>conftest.defines
- 
- # Break up conftest.defines:
- ac_max_sed_lines=50
- 
- # First sed command is:	 sed -f defines.sed $ac_file_inputs >"$tmp/out1"
- # Second one is:	 sed -f defines.sed "$tmp/out1" >"$tmp/out2"
- # Third one will be:	 sed -f defines.sed "$tmp/out2" >"$tmp/out1"
- # et cetera.
- ac_in='$ac_file_inputs'
- ac_out='"$tmp/out1"'
- ac_nxt='"$tmp/out2"'
- 
- while :
- do
-   # Write a here document:
-     cat >>$CONFIG_STATUS <<_ACEOF
-     # First, check the format of the line:
-     cat >"\$tmp/defines.sed" <<\\CEOF
- /^[	 ]*#[	 ]*undef[	 ][	 ]*$ac_word_re[	 ]*\$/b def
- /^[	 ]*#[	 ]*define[	 ][	 ]*$ac_word_re[(	 ]/b def
- b
- :def
- _ACEOF
-   sed ${ac_max_sed_lines}q conftest.defines >>$CONFIG_STATUS
-   echo 'CEOF
-     sed -f "$tmp/defines.sed"' "$ac_in >$ac_out" >>$CONFIG_STATUS
-   ac_in=$ac_out; ac_out=$ac_nxt; ac_nxt=$ac_in
-   sed 1,${ac_max_sed_lines}d conftest.defines >conftest.tail
-   grep . conftest.tail >/dev/null || break
-   rm -f conftest.defines
-   mv conftest.tail conftest.defines
- done
- rm -f conftest.defines conftest.tail
- 
- echo "ac_result=$ac_in" >>$CONFIG_STATUS
- cat >>$CONFIG_STATUS <<\_ACEOF
    if test x"$ac_file" != x-; then
!     echo "/* $configure_input  */" >"$tmp/config.h"
!     cat "$ac_result" >>"$tmp/config.h"
!     if diff $ac_file "$tmp/config.h" >/dev/null 2>&1; then
!       { echo "$as_me:$LINENO: $ac_file is unchanged" >&5
! echo "$as_me: $ac_file is unchanged" >&6;}
      else
!       rm -f $ac_file
!       mv "$tmp/config.h" $ac_file
      fi
    else
!     echo "/* $configure_input  */"
!     cat "$ac_result"
    fi
-   rm -f "$tmp/out12"
   ;;
  
  
--- 6007,6054 ----
  s&@abs_top_builddir@&$ac_abs_top_builddir&;t t
  s&@INSTALL@&$ac_INSTALL&;t t
  $ac_datarootdir_hack
! "
! eval sed \"\$ac_sed_extra\" "$ac_file_inputs" | $AWK -f "$tmp/subs.awk" >$tmp/out \
!   || as_fn_error "could not create $ac_file" "$LINENO" 5
  
  test -z "$ac_datarootdir_hack$ac_datarootdir_seen" &&
    { ac_out=`sed -n '/\${datarootdir}/p' "$tmp/out"`; test -n "$ac_out"; } &&
    { ac_out=`sed -n '/^[	 ]*datarootdir[	 ]*:*=/p' "$tmp/out"`; test -z "$ac_out"; } &&
!   { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: $ac_file contains a reference to the variable \`datarootdir'
  which seems to be undefined.  Please make sure it is defined." >&5
! $as_echo "$as_me: WARNING: $ac_file contains a reference to the variable \`datarootdir'
  which seems to be undefined.  Please make sure it is defined." >&2;}
  
    rm -f "$tmp/stdin"
    case $ac_file in
!   -) cat "$tmp/out" && rm -f "$tmp/out";;
!   *) rm -f "$ac_file" && mv "$tmp/out" "$ac_file";;
!   esac \
!   || as_fn_error "could not create $ac_file" "$LINENO" 5
   ;;
    :H)
    #
    # CONFIG_HEADER
    #
    if test x"$ac_file" != x-; then
!     {
!       $as_echo "/* $configure_input  */" \
!       && eval '$AWK -f "$tmp/defines.awk"' "$ac_file_inputs"
!     } >"$tmp/config.h" \
!       || as_fn_error "could not create $ac_file" "$LINENO" 5
!     if diff "$ac_file" "$tmp/config.h" >/dev/null 2>&1; then
!       { $as_echo "$as_me:${as_lineno-$LINENO}: $ac_file is unchanged" >&5
! $as_echo "$as_me: $ac_file is unchanged" >&6;}
      else
!       rm -f "$ac_file"
!       mv "$tmp/config.h" "$ac_file" \
! 	|| as_fn_error "could not create $ac_file" "$LINENO" 5
      fi
    else
!     $as_echo "/* $configure_input  */" \
!       && eval '$AWK -f "$tmp/defines.awk"' "$ac_file_inputs" \
!       || as_fn_error "could not create -" "$LINENO" 5
    fi
   ;;
  
  
***************
*** 7488,7498 ****
  done # for ac_tag
  
  
! { (exit 0); exit 0; }
  _ACEOF
- chmod +x $CONFIG_STATUS
  ac_clean_files=$ac_clean_files_save
  
  
  # configure is writing to config.log, and then calls config.status.
  # config.status does its own redirection, appending to config.log.
--- 6057,6069 ----
  done # for ac_tag
  
  
! as_fn_exit 0
  _ACEOF
  ac_clean_files=$ac_clean_files_save
  
+ test $ac_write_fail = 0 ||
+   as_fn_error "write failure creating $CONFIG_STATUS" "$LINENO" 5
+ 
  
  # configure is writing to config.log, and then calls config.status.
  # config.status does its own redirection, appending to config.log.
***************
*** 7512,7517 ****
    exec 5>>config.log
    # Use ||, not &&, to avoid exiting from the if with $? = 1, which
    # would make configure fail if this is the last instruction.
!   $ac_cs_success || { (exit 1); exit 1; }
  fi
  
--- 6083,6092 ----
    exec 5>>config.log
    # Use ||, not &&, to avoid exiting from the if with $? = 1, which
    # would make configure fail if this is the last instruction.
!   $ac_cs_success || as_fn_exit $?
! fi
! if test -n "$ac_unrecognized_opts" && test "$enable_option_checking" != no; then
!   { $as_echo "$as_me:${as_lineno-$LINENO}: WARNING: unrecognized options: $ac_unrecognized_opts" >&5
! $as_echo "$as_me: WARNING: unrecognized options: $ac_unrecognized_opts" >&2;}
  fi
  
diff -c -a -r -P ../wwwoffle-2.9e/configure.in ./configure.in
*** ../wwwoffle-2.9e/configure.in	Sat Dec  3 17:37:05 2005
--- ./configure.in	Thu May 28 17:11:17 2009
***************
*** 86,99 ****
        USE_ZLIB=1
     fi
  
!    AC_CHECK_LIB(z, zlibVersion,
!                 WITH_ZLIB=yes,WITH_ZLIB=no,$ZLIB_LIB)
  
!    if test "$WITH_ZLIB" = "no"; then
!       AC_MSG_WARN([Cannot find working libz library, configuring without compression support])
        ZLIB_LIB=
        ZLIB_INC=
        USE_ZLIB=0
     fi
  fi
  
--- 86,109 ----
        USE_ZLIB=1
     fi
  
!    AC_CHECK_HEADERS(zlib.h,
!                     HAVE_ZLIB_H=yes)
  
!    if test "$HAVE_ZLIB_H" = ""; then
!       AC_MSG_WARN([Cannot find zlib.h header file; configuring without compression support])
        ZLIB_LIB=
        ZLIB_INC=
        USE_ZLIB=0
+    else
+       AC_CHECK_LIB(z, zlibVersion,
+                    WITH_ZLIB=yes,WITH_ZLIB=no,$ZLIB_LIB)
+ 
+       if test "$WITH_ZLIB" = "no"; then
+          AC_MSG_WARN([Cannot find working libz library; configuring without compression support])
+          ZLIB_LIB=
+          ZLIB_INC=
+          USE_ZLIB=0
+       fi
     fi
  fi
  
***************
*** 115,144 ****
     USE_GNUTLS=0
  else
     if test "$WITH_GNUTLS" = "yes"; then
!       AC_CHECK_PROG(LIBGNUTLS_CONFIG,libgnutls-config,libgnutls-config)
! 
!       if test "$LIBGNUTLS_CONFIG" = ""; then
!          AC_MSG_WARN([Cannot find libgnutls-config program, configuring without SSL/https support])
!          WITH_LIBGNUTLS_CONFIG=0
!       else
!          WITH_LIBGNUTLS_CONFIG=1
!       fi
     else
!       LIBGNUTLS_CONFIG="$WITH_GNUTLS/bin/libgnutls-config"
! 
!       if test -x "$LIBGNUTLS_CONFIG" ; then
!          WITH_LIBGNUTLS_CONFIG=1
!       else
!          AC_MSG_WARN([Cannot find $WITH_GNUTLS/bin/libgnutls-config program, configuring without SSL/https support])
!          WITH_LIBGNUTLS_CONFIG=0
!       fi
     fi
  
!    if test "$WITH_LIBGNUTLS_CONFIG" = "1"; then
!       GNUTLS_LIB=`$LIBGNUTLS_CONFIG --libs`
!       GNUTLS_INC=`$LIBGNUTLS_CONFIG --cflags`
!       USE_GNUTLS=1
  
        AC_CHECK_LIB(gnutls, gnutls_check_version,
                     WITH_GNUTLS=yes,WITH_GNUTLS=no,$GNUTLS_LIB)
  
--- 125,146 ----
     USE_GNUTLS=0
  else
     if test "$WITH_GNUTLS" = "yes"; then
!       GNUTLS_INC=
!       GNUTLS_LIB=-lgnutls
     else
!       GNUTLS_INC="$WITH_GNUTLS/include"
!       GNUTLS_LIB="$WITH_GNUTLS/lib"
     fi
  
!    AC_CHECK_HEADERS(gnutls/gnutls.h,
!                     HAVE_GNUTLS_GNUTLS_H=yes)
  
+    if test "$HAVE_GNUTLS_GNUTLS_H" = ""; then
+       AC_MSG_WARN([Cannot find gnutls/gnutls.h header file; configuring without SSL/https support])
+       GNUTLS_LIB=
+       GNUTLS_INC=
+       USE_GNUTLS=0
+    else
        AC_CHECK_LIB(gnutls, gnutls_check_version,
                     WITH_GNUTLS=yes,WITH_GNUTLS=no,$GNUTLS_LIB)
  
***************
*** 147,157 ****
           GNUTLS_LIB=
           GNUTLS_INC=
           USE_GNUTLS=0
        fi
-    else
-       GNUTLS_LIB=
-       GNUTLS_INC=
-       USE_GNUTLS=0
     fi
  fi
  
--- 149,157 ----
           GNUTLS_LIB=
           GNUTLS_INC=
           USE_GNUTLS=0
+       else
+          USE_GNUTLS=1
        fi
     fi
  fi
  
diff -c -a -r -P ../wwwoffle-2.9e/doc/ANNOUNCE ./doc/ANNOUNCE
*** ../wwwoffle-2.9e/doc/ANNOUNCE	Sun Jan 25 16:05:14 2009
--- ./doc/ANNOUNCE	Sun Jan 31 19:07:52 2010
***************
*** 1,4 ****
!           WWWOFFLE - World Wide Web Offline Explorer - Version 2.9e
            =========================================================
  
  
--- 1,4 ----
!           WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f
            =========================================================
  
  
***************
*** 136,159 ****
  Changes
  -------
  
! Since version 2.9d:
  
  Bug Fixes:
!  Handle deflate compression errors.  Don't allow wwwoffle program to make
!  requests that won't be got.  Handle various encodings of URLs in HTML documents
!  better.  Display a note on the monitor form if the page is already monitored.
!  Stopped an error message when refreshing while online.
  
  Documentation:
   Several small fixes to documentation.
  
  
  Availability
  ------------
  
! Version 2.9e uploaded
  
! HTTP server: http://www.gedanken.demon.co.uk/download-wwwoffle/wwwoffle-2.9e.tgz
  
  Web page: http://www.gedanken.demon.co.uk/wwwoffle/
  
--- 136,172 ----
  Changes
  -------
  
! Since version 2.9e:
  
  Bug Fixes:
!  Some compilation warnings caused by flex have been removed.
!  When making a HEAD request use the cached version if possible.
!  Don't use the libgnutls-config program in the configure script.
!  Only remove "authorization" header if it is "basic" authentication.
!  Send a 304 header when online if cached page won't be refreshed.
!  Clarify SSL/HTTPS error messages and documentation.
!  Clarify last online/offline messages from 'wwwoffle -status'.
!  Perform MIME type tests case insensitively.
! 
! New Features:
!  A new option to the wwwoffle program closes and re-opens the server log file.
  
  Documentation:
   Several small fixes to documentation.
  
+ New SSL Features [*]:
+  A faster but less cryptographically secure key generation option is provided.
+  The expiration time of the SSL certificates can be increased from one year.
+ 
+ *NOTE* *These only apply if WWWOFFLE is compiled with SSL/https support*
+ 
  
  Availability
  ------------
  
! Version 2.9f uploaded
  
! HTTP server: http://www.gedanken.demon.co.uk/download-wwwoffle/wwwoffle-2.9f.tgz
  
  Web page: http://www.gedanken.demon.co.uk/wwwoffle/
  
***************
*** 161,167 ****
  Author & Copyright
  ------------------
  
! This program is copyright Andrew M. Bishop 1996-2009 (amb@gedanken.demon.co.uk)
  and distributed under GPL.
  
  email: amb@gedanken.demon.co.uk
--- 174,180 ----
  Author & Copyright
  ------------------
  
! This program is copyright Andrew M. Bishop 1996-2010 (amb@gedanken.demon.co.uk)
  and distributed under GPL.
  
  email: amb@gedanken.demon.co.uk
diff -c -a -r -P ../wwwoffle-2.9e/doc/CHANGES.CONF ./doc/CHANGES.CONF
*** ../wwwoffle-2.9e/doc/CHANGES.CONF	Tue Apr  4 18:48:04 2006
--- ./doc/CHANGES.CONF	Fri Mar 13 19:10:25 2009
***************
*** 28,33 ****
--- 28,47 ----
  file, otherwise no comments are used as they would be wrong and confusing.
  
  
+ Changes From Version 2.9e to Version 2.9f
+ =========================================
+ 
+ SSLOptions
+ ----------
+ 
+     New in version 2.9f
+     -------------------
+ 
+ quick-key-gen   = yes | no
+ expiration-time = 1y
+ 
+ 
+ 
  Changes From Version 2.9 to Version 2.9a
  ========================================
  
diff -c -a -r -P ../wwwoffle-2.9e/doc/FAQ ./doc/FAQ
*** ../wwwoffle-2.9e/doc/FAQ	Sun Jan 25 16:02:08 2009
--- ./doc/FAQ	Sat Apr 25 11:33:01 2009
***************
*** 1095,1103 ****
  Q 6.3   How do I report bugs in WWWOFFLE?
  
  By e-mail, send them to me at <amb@gedanken.demon.co.uk> and put WWWOFFLE
! somewhere in the subject line.  You can also report bugs or provide comments via
! the feedback form on the WWWOFFLE home-page on the World Wide Web accessible via
! http://www.gedanken.demon.co.uk/ .
  
  Before doing this, you should check the FAQ and the WWWOFFLE web-page to see if
  the answer is there.  If it is not and you want to report it to me then it helps
--- 1095,1101 ----
  Q 6.3   How do I report bugs in WWWOFFLE?
  
  By e-mail, send them to me at <amb@gedanken.demon.co.uk> and put WWWOFFLE
! somewhere in the subject line.
  
  Before doing this, you should check the FAQ and the WWWOFFLE web-page to see if
  the answer is there.  If it is not and you want to report it to me then it helps
diff -c -a -r -P ../wwwoffle-2.9e/doc/INSTALL ./doc/INSTALL
*** ../wwwoffle-2.9e/doc/INSTALL	Sun Nov 20 14:04:52 2005
--- ./doc/INSTALL	Wed May 27 19:34:20 2009
***************
*** 26,33 ****
  
          --with-gnutls, --without-gnutls - Enable or disable SSL/https support
                                            (default is disabled).  Requires
!                                           version 1.2.2 of libgcrypt and version
!                                           1.2.8 of libgnutls.
  
          --with-default-language=<lang>  - Set the default language for the
                                            installation (default is en).
--- 26,32 ----
  
          --with-gnutls, --without-gnutls - Enable or disable SSL/https support
                                            (default is disabled).  Requires
!                                           libgcrypt and libgnutls.
  
          --with-default-language=<lang>  - Set the default language for the
                                            installation (default is en).
diff -c -a -r -P ../wwwoffle-2.9e/doc/NEWS ./doc/NEWS
*** ../wwwoffle-2.9e/doc/NEWS	Sun Jan 25 16:03:30 2009
--- ./doc/NEWS	Sun Jan 31 18:43:14 2010
***************
*** 1,3 ****
--- 1,29 ----
+ Version 2.9f of WWWOFFLE released : Sun Jan 31 19:00:00 2010
+ ------------------------------------------------------------
+ 
+ Bug Fixes:
+  Some compilation warnings caused by flex have been removed.
+  When making a HEAD request use the cached version if possible.
+  Don't use the libgnutls-config program in the configure script.
+  Only remove "authorization" header if it is "basic" authentication.
+  Send a 304 header when online if cached page won't be refreshed.
+  Clarify SSL/HTTPS error messages and documentation.
+  Clarify last online/offline messages from 'wwwoffle -status'.
+  Perform MIME type tests case insensitively.
+ 
+ New Features:
+  A new option to the wwwoffle program closes and re-opens the server log file.
+ 
+ Documentation:
+  Several small fixes to documentation.
+ 
+ New SSL Features [*]:
+  A faster but less cryptographically secure key generation option is provided.
+  The expiration time of the SSL certificates can be increased from one year.
+ 
+ *NOTE* *These only apply if WWWOFFLE is compiled with SSL/https support*
+ 
+ 
  Version 2.9e of WWWOFFLE released : Sun Jan 25 16:00:00 2009
  ------------------------------------------------------------
  
diff -c -a -r -P ../wwwoffle-2.9e/doc/README.CONF ./doc/README.CONF
*** ../wwwoffle-2.9e/doc/README.CONF	Sat May  3 18:50:52 2008
--- ./doc/README.CONF	Mon Jan 18 19:48:01 2010
***************
*** 241,253 ****
  
  [<URL-SPEC>] request-conditional = yes | no
          While online pages that are requested from the server will be
!         conditional requests so that server only sends data if the page has
!         changed (default=yes).
  
  [<URL-SPEC>] validate-with-etag = yes | no
          When making a conditional request to a server enable the use of the
          HTTP/1.1 cache validator 'Etag' as well as modification time
!         (default=yes).
  
  [<URL-SPEC>] try-without-password = yes | no
          If a request is made for a URL that contains a username and password
--- 241,254 ----
  
  [<URL-SPEC>] request-conditional = yes | no
          While online pages that are requested from the server will be
!         conditional requests so that the server only sends data if the page
!         has changed (default=yes).
  
  [<URL-SPEC>] validate-with-etag = yes | no
          When making a conditional request to a server enable the use of the
          HTTP/1.1 cache validator 'Etag' as well as modification time
!         'If-Modified-Since' (default=yes).  The request-conditional option
!         must also be selected for this option to take effect.
  
  [<URL-SPEC>] try-without-password = yes | no
          If a request is made for a URL that contains a username and password
***************
*** 324,375 ****
  SSLOptions
  ----------
  
! Options that control how WWWOFFLE behaves when a connection is made to it for
! a Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no
! decryption or caching of the data) is possible.  When WWWOFFLE is compiled
! with the gnutls library it is possible configure WWWOFFLE to decrypt, cache
! and re-encrypt the connections.
  
  enable-caching = yes | no
!         If caching (involving decryption and re-encryption) of Secure Sockets
!         Layer (SSL) server connections is allowed (default = no).
  
  allow-tunnel = (host[:port])
!         A hostname and port number (a WILDCARD match) for an SSL server that
!         can be connected to using WWWOFFLE as a tunnelling proxy (no caching
!         or decryption of the data) (default is no hosts or ports allowed).
!         This option should be set to *:443 to allow https to the default port
!         number.  There can be more than one option for other ports or hosts as
!         required.  This option takes precedence over the allow-cache option.
          The host value is matched against the URL as presented, no hostname to
          IP or IP to hostname lookups are performed to find alternative
          equivalent names.
  
- disallow-tunnel = (host[:port])
-         A hostname and port number (a WILDCARD match) for an SSL server that
-         can not be connected to using WWWOFFLE as a tunnelling proxy.  There
-         can be more than one option for other ports or hosts as required.
-         This option takes precedence over the allow-tunnel option.  The host
-         value is matched against the URL as presented, no hostname to IP or IP
-         to hostname lookups are performed to find alternative equivalent
-         names.
- 
  allow-cache = (host[:port])
!         A hostname and port number (a WILDCARD match) for an SSL server that
!         can be connected to using WWWOFFLE as a caching proxy (decryption of
!         the data) (default is no hosts or ports allowed).  This option should
!         be set to *:443 to allow https to the default port number.  There can
!         be more than one option for other ports or hosts as required.  The
!         host value is matched against the URL as presented, no hostname to IP
!         or IP to hostname lookups are performed to find alternative equivalent
!         names.
  
  disallow-cache = (host[:port])
!         A hostname and port number (a WILDCARD match) for an SSL server that
!         can not be connected to using WWWOFFLE as a caching proxy.  This
          option takes precedence over the allow-cache option.  The host value
          is matched against the URL as presented, no hostname to IP or IP to
          hostname lookups are performed to find alternative equivalent names.
  
  --------------------------------------------------------------------------------
  
--- 325,388 ----
  SSLOptions
  ----------
  
! Options that control how WWWOFFLE behaves when a connection is made to it for an
! https or Secure Sockets Layer (SSL) server.  Normally only tunnelling (with no
! decryption or caching of the data) is possible.  When WWWOFFLE is compiled with
! the gnutls library it is possible configure WWWOFFLE to decrypt, cache and
! re-encrypt the connections.
! 
! quick-key-gen = yes | no
!         Normally generation of secret keys for the SSL/https functions uses the
!         default GnuTLS option for random number source.  This can be slow on
!         some machines so this option selects a quicker but less secure random
!         number source (default = no).  Requires GnuTLS compilation option.
! 
! expiration-time = (age)
!         The length of time after creation that each certificate will expire
!         (default = 1y).  Requires GnuTLS compilation option.
  
  enable-caching = yes | no
!         If caching (involving decryption and re-encryption) of SSL/https
!         server connections is allowed (default = no).  Requires GnuTLS
!         compilation option.
  
  allow-tunnel = (host[:port])
!         A hostname and port number (a WILDCARD match) for an https/SSL server
!         that can be connected to using WWWOFFLE as a tunnelling proxy (no
!         caching or decryption of the data) (default is no hosts or ports
!         allowed).  This option should be set to *:443 to allow https to the
!         default port number.  There can be more than one option for other
!         ports or hosts as required.  This option takes precedence over the
!         allow-cache option.  The host value is matched against the URL as
!         presented, no hostname to IP or IP to hostname lookups are performed
!         to find alternative equivalent names.
! 
! disallow-tunnel = (host[:port])
!         A hostname and port number (a WILDCARD match) for an https/SSL server
!         that can not be connected to using WWWOFFLE as a tunnelling proxy.
!         There can be more than one option for other ports or hosts as
!         required.  This option takes precedence over the allow-tunnel option.
          The host value is matched against the URL as presented, no hostname to
          IP or IP to hostname lookups are performed to find alternative
          equivalent names.
  
  allow-cache = (host[:port])
!         A hostname and port number (a WILDCARD match) for an https/SSL server
!         that can be connected to using WWWOFFLE as a caching proxy (decryption
!         of the data) (default is no hosts or ports allowed).  This option
!         should be set to *:443 to allow https to the default port number.
!         There can be more than one option for other ports or hosts as
!         required.  The host value is matched against the URL as presented, no
!         hostname to IP or IP to hostname lookups are performed to find
!         alternative equivalent names.  Requires GnuTLS compilation option.
  
  disallow-cache = (host[:port])
!         A hostname and port number (a WILDCARD match) for an https/SSL server
!         that can not be connected to using WWWOFFLE as a caching proxy.  This
          option takes precedence over the allow-cache option.  The host value
          is matched against the URL as presented, no hostname to IP or IP to
          hostname lookups are performed to find alternative equivalent names.
+         Requires GnuTLS compilation option.
  
  --------------------------------------------------------------------------------
  
***************
*** 386,395 ****
          If images are to be fetched (default=no).
  
  [<URL-SPEC>] webbug-images = yes | no
!         If images that are 1 pixel square are also to be fetched, requires the
!         images option to also be selected. (default=yes).  If these images are
!         not fetched then the replace-webbug-images option in the ModifyHTML
!         section can be used to stop browsers requesting them.
  
  [<URL-SPEC>] icon-images = yes | no
          If icons (also called favourite icons or shortcut icons) as used by
--- 399,409 ----
          If images are to be fetched (default=no).
  
  [<URL-SPEC>] webbug-images = yes | no
!         If images that are declared in the HTML to be 1 pixel square are also to
!         be fetched, requires the images option to also be selected
!         (default=yes).  If these images are not fetched then the
!         replace-webbug-images option in the ModifyHTML section can be used to
!         stop browsers requesting them.
  
  [<URL-SPEC>] icon-images = yes | no
          If icons (also called favourite icons or shortcut icons) as used by
***************
*** 678,689 ****
  ------------
  
  A list of MIME types and file extensions that are not to be compressed by
! WWWOFFLE (because they are already compressed or not not worth compressing).
  Requires zlib compilation option.
  
  mime-type = (mime-type)/(subtype)
!         The MIME type of a URL that is not to be compressed in the cache or
!         when providing compressed pages to clients.
  
  file-ext = .(file-ext)
          The file extension of a URL that is not to be requested compressed
--- 692,703 ----
  ------------
  
  A list of MIME types and file extensions that are not to be compressed by
! WWWOFFLE (because they are already compressed or not worth compressing).
  Requires zlib compilation option.
  
  mime-type = (mime-type)/(subtype)
!         The MIME type of a URL that is not to be compressed in the cache (when
!         purging) or when providing pages to clients.
  
  file-ext = .(file-ext)
          The file extension of a URL that is not to be requested compressed
***************
*** 790,798 ****
          retrieved.
  
  [<URL-SPEC>] ssl = (host[:port])
!         A proxy server that should be used for Secure Socket Layer (SSL)
!         connections e.g. https.  Note that for the <URL-SPEC> that only the
!         host is checked and that the other parts must be '*' WILDCARDs.
  
  --------------------------------------------------------------------------------
  
--- 804,812 ----
          retrieved.
  
  [<URL-SPEC>] ssl = (host[:port])
!         A proxy server that should be used for https or Secure Socket Layer
!         (SSL) connections.  Note that for the <URL-SPEC> that only the host is
!         checked and that the other parts must be '*' WILDCARDs.
  
  --------------------------------------------------------------------------------
  
diff -c -a -r -P ../wwwoffle-2.9e/doc/wwwoffle.conf.man ./doc/wwwoffle.conf.man
*** ../wwwoffle-2.9e/doc/wwwoffle.conf.man	Sun Jan 25 15:37:49 2009
--- ./doc/wwwoffle.conf.man	Sun Jan 31 19:14:42 2010
***************
*** 262,274 ****
  .TP
  .B [<URL\-SPEC>] request\-conditional = yes | no
  While online pages that are requested from the server will be
! conditional requests so that server only sends data if the page has
! changed (default=yes)\.
  .TP
  .B [<URL\-SPEC>] validate\-with\-etag = yes | no
  When making a conditional request to a server enable the use of the
  HTTP/1\.1 cache validator \'Etag\' as well as modification time
! (default=yes)\.
  .TP
  .B [<URL\-SPEC>] try\-without\-password = yes | no
  If a request is made for a URL that contains a username and password
--- 262,275 ----
  .TP
  .B [<URL\-SPEC>] request\-conditional = yes | no
  While online pages that are requested from the server will be
! conditional requests so that the server only sends data if the page
! has changed (default=yes)\.
  .TP
  .B [<URL\-SPEC>] validate\-with\-etag = yes | no
  When making a conditional request to a server enable the use of the
  HTTP/1\.1 cache validator \'Etag\' as well as modification time
! \'If\-Modified\-Since\' (default=yes)\.  The request\-conditional option
! must also be selected for this option to take effect\.
  .TP
  .B [<URL\-SPEC>] try\-without\-password = yes | no
  If a request is made for a URL that contains a username and password
***************
*** 339,398 ****
  
  .SH SSLOptions
  
! Options that control how WWWOFFLE behaves when a connection is made to it for
! a Secure Sockets Layer (SSL) server\.  Normally only tunnelling (with no
! decryption or caching of the data) is possible\.  When WWWOFFLE is compiled
! with the gnutls library it is possible configure WWWOFFLE to decrypt, cache
! and re\-encrypt the connections\.
  .TP
  .B enable\-caching = yes | no
! If caching (involving decryption and re\-encryption) of Secure Sockets
! Layer (SSL) server connections is allowed (default = no)\.
  .TP
  .B allow\-tunnel = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an SSL server that
! can be connected to using WWWOFFLE as a tunnelling proxy (no caching
! or decryption of the data) (default is no hosts or ports allowed)\.
! This option should be set to *:443 to allow https to the default port
! number\.  There can be more than one option for other ports or hosts as
! required\.  This option takes precedence over the allow\-cache option\.
! The host value is matched against the URL as presented, no hostname to
! IP or IP to hostname lookups are performed to find alternative
! equivalent names\.
  .TP
  .B disallow\-tunnel = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an SSL server that
! can not be connected to using WWWOFFLE as a tunnelling proxy\.  There
! can be more than one option for other ports or hosts as required\.
! This option takes precedence over the allow\-tunnel option\.  The host
! value is matched against the URL as presented, no hostname to IP or IP
! to hostname lookups are performed to find alternative equivalent
! names\.
  .TP
  .B allow\-cache = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an SSL server that
! can be connected to using WWWOFFLE as a caching proxy (decryption of
! the data) (default is no hosts or ports allowed)\.  This option should
! be set to *:443 to allow https to the default port number\.  There can
! be more than one option for other ports or hosts as required\.  The
! host value is matched against the URL as presented, no hostname to IP
! or IP to hostname lookups are performed to find alternative equivalent
! names\.
  .TP
  .B disallow\-cache = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an SSL server that
! can not be connected to using WWWOFFLE as a caching proxy\.  This
  option takes precedence over the allow\-cache option\.  The host value
  is matched against the URL as presented, no hostname to IP or IP to
  hostname lookups are performed to find alternative equivalent names\.
  
  .SH FetchOptions
  
--- 340,411 ----
  
  .SH SSLOptions
  
! Options that control how WWWOFFLE behaves when a connection is made to it for an
! https or Secure Sockets Layer (SSL) server\.  Normally only tunnelling (with no
! decryption or caching of the data) is possible\.  When WWWOFFLE is compiled with
! the gnutls library it is possible configure WWWOFFLE to decrypt, cache and
! re\-encrypt the connections\.
! .TP
! .B quick\-key\-gen = yes | no
! Normally generation of secret keys for the SSL/https functions uses the
! default GnuTLS option for random number source\.  This can be slow on
! some machines so this option selects a quicker but less secure random
! number source (default = no)\.  Requires GnuTLS compilation option\.
! .TP
! .B expiration\-time = (age)
! The length of time after creation that each certificate will expire
! (default = 1y)\.  Requires GnuTLS compilation option\.
  .TP
  .B enable\-caching = yes | no
! If caching (involving decryption and re\-encryption) of SSL/https
! server connections is allowed (default = no)\.  Requires GnuTLS
! compilation option\.
  .TP
  .B allow\-tunnel = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an https/SSL server
! that can be connected to using WWWOFFLE as a tunnelling proxy (no
! caching or decryption of the data) (default is no hosts or ports
! allowed)\.  This option should be set to *:443 to allow https to the
! default port number\.  There can be more than one option for other
! ports or hosts as required\.  This option takes precedence over the
! allow\-cache option\.  The host value is matched against the URL as
! presented, no hostname to IP or IP to hostname lookups are performed
! to find alternative equivalent names\.
  .TP
  .B disallow\-tunnel = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an https/SSL server
! that can not be connected to using WWWOFFLE as a tunnelling proxy\.
! There can be more than one option for other ports or hosts as
! required\.  This option takes precedence over the allow\-tunnel option\.
! The host value is matched against the URL as presented, no hostname to
! IP or IP to hostname lookups are performed to find alternative
! equivalent names\.
  .TP
  .B allow\-cache = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an https/SSL server
! that can be connected to using WWWOFFLE as a caching proxy (decryption
! of the data) (default is no hosts or ports allowed)\.  This option
! should be set to *:443 to allow https to the default port number\.
! There can be more than one option for other ports or hosts as
! required\.  The host value is matched against the URL as presented, no
! hostname to IP or IP to hostname lookups are performed to find
! alternative equivalent names\.  Requires GnuTLS compilation option\.
  .TP
  .B disallow\-cache = (host[:port])
  A hostname and port number (a 
  .I WILDCARD
! match) for an https/SSL server
! that can not be connected to using WWWOFFLE as a caching proxy\.  This
  option takes precedence over the allow\-cache option\.  The host value
  is matched against the URL as presented, no hostname to IP or IP to
  hostname lookups are performed to find alternative equivalent names\.
+ Requires GnuTLS compilation option\.
  
  .SH FetchOptions
  
***************
*** 406,415 ****
  If images are to be fetched (default=no)\.
  .TP
  .B [<URL\-SPEC>] webbug\-images = yes | no
! If images that are 1 pixel square are also to be fetched, requires the
! images option to also be selected\. (default=yes)\.  If these images are
! not fetched then the replace\-webbug\-images option in the ModifyHTML
! section can be used to stop browsers requesting them\.
  .TP
  .B [<URL\-SPEC>] icon\-images = yes | no
  If icons (also called favourite icons or shortcut icons) as used by
--- 419,429 ----
  If images are to be fetched (default=no)\.
  .TP
  .B [<URL\-SPEC>] webbug\-images = yes | no
! If images that are declared in the HTML to be 1 pixel square are also to
! be fetched, requires the images option to also be selected
! (default=yes)\.  If these images are not fetched then the
! replace\-webbug\-images option in the ModifyHTML section can be used to
! stop browsers requesting them\.
  .TP
  .B [<URL\-SPEC>] icon\-images = yes | no
  If icons (also called favourite icons or shortcut icons) as used by
***************
*** 683,694 ****
  .SH DontCompress
  
  A list of MIME types and file extensions that are not to be compressed by
! WWWOFFLE (because they are already compressed or not not worth compressing)\.
  Requires zlib compilation option\.
  .TP
  .B mime\-type = (mime\-type)/(subtype)
! The MIME type of a URL that is not to be compressed in the cache or
! when providing compressed pages to clients\.
  .TP
  .B file\-ext = \.(file\-ext)
  The file extension of a URL that is not to be requested compressed
--- 697,708 ----
  .SH DontCompress
  
  A list of MIME types and file extensions that are not to be compressed by
! WWWOFFLE (because they are already compressed or not worth compressing)\.
  Requires zlib compilation option\.
  .TP
  .B mime\-type = (mime\-type)/(subtype)
! The MIME type of a URL that is not to be compressed in the cache (when
! purging) or when providing pages to clients\.
  .TP
  .B file\-ext = \.(file\-ext)
  The file extension of a URL that is not to be requested compressed
***************
*** 787,797 ****
  retrieved\.
  .TP
  .B [<URL\-SPEC>] ssl = (host[:port])
! A proxy server that should be used for Secure Socket Layer (SSL)
! connections e\.g\. https\.  Note that for the 
  .I <URL\-SPEC>
! that only the
! host is checked and that the other parts must be \'*\' 
  .I WILDCARD
  s\.
  
--- 801,811 ----
  retrieved\.
  .TP
  .B [<URL\-SPEC>] ssl = (host[:port])
! A proxy server that should be used for https or Secure Socket Layer
! (SSL) connections\.  Note that for the 
  .I <URL\-SPEC>
! that only the host is
! checked and that the other parts must be \'*\' 
  .I WILDCARD
  s\.
  
diff -c -a -r -P ../wwwoffle-2.9e/doc/wwwoffle.man ./doc/wwwoffle.man
*** ../wwwoffle-2.9e/doc/wwwoffle.man	Sun Feb 12 14:20:03 2006
--- ./doc/wwwoffle.man	Fri Mar 13 19:32:02 2009
***************
*** 1,17 ****
! .\" $Header: /home/amb/wwwoffle/doc/RCS/wwwoffle.man 2.20 2006/02/12 14:20:03 amb Exp $
  .\"
! .\"  WWWOFFLE - World Wide Web Offline Explorer - Version 2.9.
  .\"
  .\"  Manual page for wwwoffle
  .\"
  .\"  Written by Andrew M. Bishop
  .\"
! .\"  This file Copyright 1997,98,99,2000,01,02,03,04,05,06 Andrew M. Bishop
  .\"  It may be distributed under the GNU Public License, version 2, or
  .\"  any higher version.  See section COPYING of the GNU Public license
  .\"  for conditions under which this file may be redistributed.
  .\"
! .TH wwwoffle 1 "February 12, 2006"
  
  .SH NAME
  
--- 1,17 ----
! .\" $Header: /home/amb/wwwoffle/doc/RCS/wwwoffle.man 2.21 2009/03/13 19:32:02 amb Exp $
  .\"
! .\"  WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
  .\"
  .\"  Manual page for wwwoffle
  .\"
  .\"  Written by Andrew M. Bishop
  .\"
! .\"  This file Copyright 1997-2009 Andrew M. Bishop
  .\"  It may be distributed under the GNU Public License, version 2, or
  .\"  any higher version.  See section COPYING of the GNU Public license
  .\"  for conditions under which this file may be redistributed.
  .\"
! .TH wwwoffle 1 "March 13, 2009"
  
  .SH NAME
  
***************
*** 48,53 ****
--- 48,57 ----
  .B [\-p <host>[:<port>] | \-c <config-file>]
  .P
  .B wwwoffle
+ .B \-cyclelog
+ .B [\-p <host>[:<port>] | \-c <config-file>]
+ .P
+ .B wwwoffle
  .B \-purge
  .B [\-p <host>[:<port>] | \-c <config-file>]
  .P
***************
*** 139,144 ****
--- 143,151 ----
  This is equivalent to the most recently read configuration file and the built-in
  default options.
  .TP
+ .B \-cyclelog
+ Tell the wwwoffled proxy server to close and then re-open the log file.
+ .TP
  .B \-purge
  Tell the wwwoffled proxy server that the cache is to be purged.  The
  configuration file wwwoffle.conf(5) specifies the maximum age of the pages to
***************
*** 287,290 ****
  
  .SH AUTHOR
  
! Andrew M. Bishop 1996,97,98,99,2000,01,02,03,04,05,06 (amb@gedanken.demon.co.uk)
--- 294,297 ----
  
  .SH AUTHOR
  
! Andrew M. Bishop 1996-2009 (amb@gedanken.demon.co.uk)
diff -c -a -r -P ../wwwoffle-2.9e/src/certificates.c ./src/certificates.c
*** ../wwwoffle-2.9e/src/certificates.c	Sun Jul  8 18:52:39 2007
--- ./src/certificates.c	Sat Mar 14 19:16:01 2009
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/certificates.c 1.32 2007/07/08 17:52:39 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9c.
    Certificate handling functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 2005,06 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/certificates.c 1.34 2009/03/13 19:28:37 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Certificate handling functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 2005-09 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 43,48 ****
--- 43,49 ----
  #if USE_GNUTLS
  #include <gnutls/gnutls.h>
  #include <gnutls/x509.h>
+ #include <gcrypt.h>
  #endif
  
  #include "wwwoffle.h"
***************
*** 125,130 ****
--- 126,136 ----
      gnutls_global_init();
   initialised=1;
  
+  /* Use faster but less secure key generation. */
+ 
+  if(ConfigBoolean(SSLQuickKeyGen))
+     gcry_control(GCRYCTL_ENABLE_QUICK_RANDOM,0);
+ 
   /* Create the certificates directory if needed */
  
   if(stat("certificates",&buf))
***************
*** 1024,1030 ****
   if(err<0)
     {PrintMessage(Warning,"Could not set the certificate activation time for '%s' [%s].",errmsg_hostname,gnutls_strerror(err));return(11);}
  
!  err=gnutls_x509_crt_set_expiration_time(crt,time(NULL)+365*24*3600);
   if(err<0)
     {PrintMessage(Warning,"Could not set the certificate expiration time for '%s' [%s].",errmsg_hostname,gnutls_strerror(err));return(12);}
  
--- 1030,1036 ----
   if(err<0)
     {PrintMessage(Warning,"Could not set the certificate activation time for '%s' [%s].",errmsg_hostname,gnutls_strerror(err));return(11);}
  
!  err=gnutls_x509_crt_set_expiration_time(crt,time(NULL)+ConfigInteger(SSLCertExpiry)*24*3600);
   if(err<0)
     {PrintMessage(Warning,"Could not set the certificate expiration time for '%s' [%s].",errmsg_hostname,gnutls_strerror(err));return(12);}
  
diff -c -a -r -P ../wwwoffle-2.9e/src/config.h ./src/config.h
*** ../wwwoffle-2.9e/src/config.h	Sat Sep 29 19:54:08 2007
--- ./src/config.h	Fri Mar 13 19:28:37 2009
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/config.h 2.117 2007/09/29 18:54:08 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
    Configuration file management functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997-2007 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/config.h 2.119 2009/03/13 19:28:37 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Configuration file management functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 200,205 ****
--- 200,211 ----
  
  /* SSLOptions section */
  
+ /*+ The option to use weaker but faster key generation. +*/
+ extern /*@null@*/ ConfigItem SSLQuickKeyGen;
+ 
+ /*+ The expiration time of generated certificates. +*/
+ extern /*@null@*/ ConfigItem SSLCertExpiry;
+ 
  /*+ The option to allow caching of SSL connections. +*/
  extern /*@null@*/ ConfigItem SSLEnableCaching;
  
Only in ../wwwoffle-2.9e/src: config.h.orig
diff -c -a -r -P ../wwwoffle-2.9e/src/configdata.c ./src/configdata.c
*** ../wwwoffle-2.9e/src/configdata.c	Sat Sep 29 19:54:08 2007
--- ./src/configdata.c	Fri Mar 13 19:28:37 2009
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/configdata.c 2.162 2007/09/29 18:54:08 amb Exp $
  
    WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
    Configuration data functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997-2007 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/configdata.c 2.164 2009/03/13 19:28:37 amb Exp $
  
    WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
    Configuration data functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 278,283 ****
--- 278,289 ----
  
  /* SSLOptions section */
  
+ /*+ The option to use weaker but faster key generation. +*/
+ ConfigItem SSLQuickKeyGen;
+ 
+ /*+ The expiration time of generated certificates. +*/
+ ConfigItem SSLCertExpiry;
+ 
  /*+ The option to allow caching of SSL connections. +*/
  ConfigItem SSLEnableCaching;
  
***************
*** 295,301 ****
  
  /*+ The item definitions in the SSLOptions section. +*/
  static ConfigItemDef ssloptions_itemdefs[]={
!  {"enable-caching" ,&SSLEnableCaching ,0,0,Fixed,Boolean        ,NULL},
   {"allow-tunnel"   ,&SSLAllowTunnel   ,0,1,Fixed,HostAndPortWild,NULL},
   {"disallow-tunnel",&SSLDisallowTunnel,0,1,Fixed,HostAndPortWild,NULL},
   {"allow-cache"    ,&SSLAllowCache    ,0,1,Fixed,HostAndPortWild,NULL},
--- 301,309 ----
  
  /*+ The item definitions in the SSLOptions section. +*/
  static ConfigItemDef ssloptions_itemdefs[]={
!  {"quick-key-gen"  ,&SSLQuickKeyGen   ,0,0,Fixed,Boolean        ,"no"},
!  {"expiration-time",&SSLCertExpiry    ,0,0,Fixed,AgeDays        ,"1y"},
!  {"enable-caching" ,&SSLEnableCaching ,0,0,Fixed,Boolean        ,"no"},
   {"allow-tunnel"   ,&SSLAllowTunnel   ,0,1,Fixed,HostAndPortWild,NULL},
   {"disallow-tunnel",&SSLDisallowTunnel,0,1,Fixed,HostAndPortWild,NULL},
   {"allow-cache"    ,&SSLAllowCache    ,0,1,Fixed,HostAndPortWild,NULL},
Only in ../wwwoffle-2.9e/src: configdata.c.orig
diff -c -a -r -P ../wwwoffle-2.9e/src/connect.c ./src/connect.c
*** ../wwwoffle-2.9e/src/connect.c	Fri Apr 20 17:04:29 2007
--- ./src/connect.c	Fri Jan 22 19:00:53 2010
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/connect.c 2.52 2007/04/20 16:04:29 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9c.
    Handle WWWOFFLE connections received by the demon.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996,97,98,99,2000,01,02,03,05,07 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/connect.c 2.54 2010/01/22 19:00:53 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Handle WWWOFFLE connections received by the demon.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996-2010 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 86,91 ****
--- 86,94 ----
  /*+ True if the -f option was passed on the command line. +*/
  extern int nofork;
  
+ /*+ The name of the log file specified. +*/
+ extern char *log_file;
+ 
  
  /*++++++++++++++++++++++++++++++++++++++
    Parse a request that comes from wwwoffle.
***************
*** 232,237 ****
--- 235,252 ----
  
      PrintMessage(Important,"WWWOFFLE Finished Dumping Configuration File.");
     }
+  else if(!strncmp(&line[9],"CYCLELOG",(size_t)8))
+    {
+     if(log_file)
+       {
+        write_string(client,"WWWOFFLE Cycling Log File.\n");
+        PrintMessage(Important,"Closing and opening log file.");
+ 
+        OpenErrorLog(log_file);
+       }
+     else
+        write_string(client,"WWWOFFLE Has No Log File.\n"); /* Used in wwwoffle.c */
+    }
   else if(!strncmp(&line[9],"PURGE",(size_t)5))
     {
      pid_t pid;
***************
*** 318,329 ****
      if(OnlineTime)
         write_formatted(client,"Last-Online  : %s\n",RFC822Date(OnlineTime,0));
      else
!        write_formatted(client,"Last-Online  : unknown\n");
  
      if(OfflineTime)
         write_formatted(client,"Last-Offline : %s\n",RFC822Date(OfflineTime,0));
      else
!        write_formatted(client,"Last-Offline : unknown\n");
  
      write_formatted(client,"Total-Servers: %d\n",n_servers);
      write_formatted(client,"Fetch-Servers: %d\n",n_fetch_servers);
--- 333,344 ----
      if(OnlineTime)
         write_formatted(client,"Last-Online  : %s\n",RFC822Date(OnlineTime,0));
      else
!        write_formatted(client,"Last-Online  : not since started\n");
  
      if(OfflineTime)
         write_formatted(client,"Last-Offline : %s\n",RFC822Date(OfflineTime,0));
      else
!        write_formatted(client,"Last-Offline : not since started\n");
  
      write_formatted(client,"Total-Servers: %d\n",n_servers);
      write_formatted(client,"Fetch-Servers: %d\n",n_fetch_servers);
diff -c -a -r -P ../wwwoffle-2.9e/src/css.l ./src/css.l
*** ../wwwoffle-2.9e/src/css.l	Sun Feb 27 10:16:25 2005
--- ./src/css.l	Fri Mar 13 19:29:50 2009
***************
*** 16,31 ****
  
  %{
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/css.l 1.12 2005/02/27 10:16:25 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.8f.
    Parse the CSS and look for the images and stylesheets.
    ******************/ /******************
    Written by Andrew M. Bishop
  
    Some parts of the lex scanner based on the CSS2 specification from W3C.
  
!   This file Copyright 1997,98,99,2000,01,02,03,04,05 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 16,31 ----
  
  %{
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/css.l 1.13 2009/03/13 19:29:50 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Parse the CSS and look for the images and stylesheets.
    ******************/ /******************
    Written by Andrew M. Bishop
  
    Some parts of the lex scanner based on the CSS2 specification from W3C.
  
!   This file Copyright 1997-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 140,145 ****
--- 140,148 ----
  #define css_yywrap() 1
  #endif
  
+ /*+ Don't include the yyinput() or input() function in the lexer. +*/
+ #define YY_NO_INPUT
+ 
  /*+ A macro to read data that can be used by the lexer. +*/
  #define YY_INPUT(buf,result,max_size) \
          if((result=read_data(css_yyfd,buf,max_size))==-1) \
diff -c -a -r -P ../wwwoffle-2.9e/src/document.c ./src/document.c
*** ../wwwoffle-2.9e/src/document.c	Thu Oct  9 19:22:03 2008
--- ./src/document.c	Fri Jan 22 20:03:41 2010
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/document.c 1.29 2008/10/09 18:22:03 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9e.
    Document parsing functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1998-2008 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/document.c 1.31 2010/01/22 20:03:41 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Document parsing functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1998-2010 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 147,153 ****
   unsigned i;
  
   for(i = 0; i < sizeof(docTypeList)/sizeof(docTypeList[0]); i++)
!     if(!strcmp(mimetype,docTypeList[i].mimetype))
         return(docTypeList[i].doctype);
  
   return(DocUnknown);
--- 147,153 ----
   unsigned i;
  
   for(i = 0; i < sizeof(docTypeList)/sizeof(docTypeList[0]); i++)
!     if(!strcasecmp(mimetype,docTypeList[i].mimetype))
         return(docTypeList[i].doctype);
  
   return(DocUnknown);
***************
*** 326,333 ****
  
      reference_Urls[type]=(URL**)malloc(reference_num[type]*sizeof(URL*));
  
!     for(i=0;reference_links[type][i];i++)
!        reference_Urls[type][i]=LinkURL(baseUrl,reference_links[type][i]);
  
      reference_Urls[type][i]=NULL;
  
--- 326,336 ----
  
      reference_Urls[type]=(URL**)malloc(reference_num[type]*sizeof(URL*));
  
!     for(i=0;i<reference_num[type] && reference_links[type][i];i++)
!        if(baseUrl)
!           reference_Urls[type][i]=LinkURL(baseUrl,reference_links[type][i]);
!        else
!           reference_Urls[type][i]=SplitURL(reference_links[type][i]);
  
      reference_Urls[type][i]=NULL;
  
diff -c -a -r -P ../wwwoffle-2.9e/src/html.l ./src/html.l
*** ../wwwoffle-2.9e/src/html.l	Wed Dec  5 19:29:59 2007
--- ./src/html.l	Fri Mar 13 19:29:50 2009
***************
*** 27,41 ****
  
  %{
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/html.l 2.94 2007/12/05 19:29:59 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
    Parse the HTML and look for the images, links and other things.
    ******************/ /******************
    Written by Andrew M. Bishop
    Object and Parameter handling by Walter Pfannenmller
  
!   This file Copyright 1997-2007 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 27,41 ----
  
  %{
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/html.l 2.95 2009/03/13 19:29:50 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Parse the HTML and look for the images, links and other things.
    ******************/ /******************
    Written by Andrew M. Bishop
    Object and Parameter handling by Walter Pfannenmller
  
!   This file Copyright 1997-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 874,879 ****
--- 874,882 ----
   strcpy(string+stringused,xx); \
   stringused+=newlen;
  
+ /*+ Don't include the yyinput() or input() function in the lexer. +*/
+ #define YY_NO_INPUT
+ 
  /*+ A macro to read data that can be used by the lexer. +*/
  #define YY_INPUT(buf,result,max_size) \
          if((result=read_data(html_yyfd,buf,max_size))==-1) \
diff -c -a -r -P ../wwwoffle-2.9e/src/htmlmodify.l ./src/htmlmodify.l
*** ../wwwoffle-2.9e/src/htmlmodify.l	Sat Jul 21 14:23:53 2007
--- ./src/htmlmodify.l	Fri Mar 13 19:29:50 2009
***************
*** 19,32 ****
  
  %{
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/htmlmodify.l 1.96 2007/07/21 13:23:54 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9d.
    Parse the HTML and modify the source.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997,98,99,2000,01,02,03,04,05,06,07 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 19,32 ----
  
  %{
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/htmlmodify.l 1.97 2009/03/13 19:29:50 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Parse the HTML and modify the source.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 1744,1749 ****
--- 1744,1752 ----
   strcpy(string+stringused,xx); \
   stringused+=newlen;
  
+ /*+ Don't include the yyinput() or input() function in the lexer. +*/
+ #define YY_NO_INPUT
+ 
  /*+ A macro to read data that can be used by the lexer. +*/
  #define YY_INPUT(buf,result,max_size) \
          if((result=wwwoffles_read_data(buf,max_size))==-1) \
diff -c -a -r -P ../wwwoffle-2.9e/src/https.c ./src/https.c
*** ../wwwoffle-2.9e/src/https.c	Mon Jun 25 19:25:45 2007
--- ./src/https.c	Tue Jan 19 19:53:23 2010
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/https.c 1.5 2007/06/25 18:25:45 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9c.
    Functions for getting URLs using HTTPS.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997,98,99,2000,01,02,03,04,05,06 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/https.c 1.6 2010/01/19 19:53:23 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Functions for getting URLs using HTTPS.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1997-2010 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 88,94 ****
  
   if(server==-1)
     {
!     msg=GetPrintMessage(Warning,"Cannot open the HTTPS connection to %s port %d; [%!s].",server_host,server_port);
      return(msg);
     }
   else
--- 88,94 ----
  
   if(server==-1)
     {
!     msg=GetPrintMessage(Warning,"Cannot open the https (SSL) connection to %s port %d; [%!s].",server_host,server_port);
      return(msg);
     }
   else
***************
*** 121,130 ****
  
      head=HeaderString(connect_request);
  
!     PrintMessage(ExtraDebug,"Outgoing Request Head (to SSL proxy)\n%s",head);
  
      if(write_string(server,head)==-1)
!        msg=GetPrintMessage(Warning,"Failed to write to remote SSL proxy; [%!s].");
  
      if(Url->port==-1)
         free(hostport);
--- 121,130 ----
  
      head=HeaderString(connect_request);
  
!     PrintMessage(ExtraDebug,"Outgoing Request Head (to https (SSL) proxy)\n%s",head);
  
      if(write_string(server,head)==-1)
!        msg=GetPrintMessage(Warning,"Failed to write to remote https (SSL) proxy; [%!s].");
  
      if(Url->port==-1)
         free(hostport);
***************
*** 139,150 ****
      if(StderrLevel==ExtraDebug)
        {
         head=HeaderString(connect_reply);
!        PrintMessage(ExtraDebug,"Incoming Reply Head (from SSL proxy)\n%s",head);
         free(head);    
        }
  
      if(connect_status!=200)
!        msg=GetPrintMessage(Warning,"Received error message from SSL proxy; code=%d.",connect_status);
  
      FreeHeader(connect_reply);
  
--- 139,150 ----
      if(StderrLevel==ExtraDebug)
        {
         head=HeaderString(connect_reply);
!        PrintMessage(ExtraDebug,"Incoming Reply Head (from https (SSL) proxy)\n%s",head);
         free(head);    
        }
  
      if(connect_status!=200)
!        msg=GetPrintMessage(Warning,"Received error message from https (SSL) proxy; code=%d.",connect_status);
  
      FreeHeader(connect_reply);
  
***************
*** 153,159 ****
     }
  
   if(configure_io_gnutls(server,Url->hostport,0))
!     msg=GetPrintMessage(Warning,"Cannot secure the HTTPS connection to %s port %d; [%!s].",server_host,server_port);
  
   return(msg);
  }
--- 153,159 ----
     }
  
   if(configure_io_gnutls(server,Url->hostport,0))
!     msg=GetPrintMessage(Warning,"Cannot secure the https (SSL) connection to %s port %d; [%!s].",server_host,server_port);
  
   return(msg);
  }
***************
*** 192,201 ****
      PrintMessage(ExtraDebug,"Outgoing Request Head (to server)\n%s",head);
  
   if(write_string(server,head)==-1)
!     msg=GetPrintMessage(Warning,"Failed to write head to remote HTTPS %s; [%!s].",proxyUrl?"proxy":"server");
   if(request_body)
      if(write_data(server,request_body->content,request_body->length)==-1)
!        msg=GetPrintMessage(Warning,"Failed to write body to remote HTTPS %s; [%!s].",proxyUrl?"proxy":"server");
  
   free(head);
  
--- 192,201 ----
      PrintMessage(ExtraDebug,"Outgoing Request Head (to server)\n%s",head);
  
   if(write_string(server,head)==-1)
!     msg=GetPrintMessage(Warning,"Failed to write head to remote https (SSL) %s; [%!s].",proxyUrl?"proxy":"server");
   if(request_body)
      if(write_data(server,request_body->content,request_body->length)==-1)
!        msg=GetPrintMessage(Warning,"Failed to write body to remote https (SSL) %s; [%!s].",proxyUrl?"proxy":"server");
  
   free(head);
  
diff -c -a -r -P ../wwwoffle-2.9e/src/parse.c ./src/parse.c
*** ../wwwoffle-2.9e/src/parse.c	Sat Sep  8 19:56:08 2007
--- ./src/parse.c	Mon Jun 22 19:07:30 2009
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/parse.c 2.135 2007/09/08 18:56:08 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9.
    Functions to parse the HTTP requests.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996,97,98,99,2000,01,02,03,04,05,06 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/parse.c 2.136 2009/06/07 18:36:37 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    Functions to parse the HTTP requests.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 139,147 ****
      FreeURL(oldUrl);
     }
  
!  /* Check for passwords */
  
!  if((val=GetHeader(*request_head,"Authorization")))
     {
      char *p,*userpass,*user,*pass;
      size_t l;
--- 139,147 ----
      FreeURL(oldUrl);
     }
  
!  /* Check for authentication using the 'Basic' scheme */
  
!  if((val=GetHeader(*request_head,"Authorization")) && !strncmp(val,"Basic",5))
     {
      char *p,*userpass,*user,*pass;
      size_t l;
***************
*** 645,651 ****
  {
   int i;
   unsigned j;
!  char *referer=NULL;
  
   /* Modify the top line of the header. */
  
--- 645,651 ----
  {
   int i;
   unsigned j;
!  char *referer=NULL,*val;
  
   /* Modify the top line of the header. */
  
***************
*** 676,682 ****
  
   /* Check the authorisation header. */
  
!  RemoveFromHeader(request_head,"Authorization");
  
   if(Url->user)
     {
--- 676,683 ----
  
   /* Check the authorisation header. */
  
!  if((val=GetHeader(request_head,"Authorization")) && !strncmp(val,"Basic",5))
!     RemoveFromHeader(request_head,"Authorization");
  
   if(Url->user)
     {
diff -c -a -r -P ../wwwoffle-2.9e/src/ssl.c ./src/ssl.c
*** ../wwwoffle-2.9e/src/ssl.c	Tue Jan 10 19:25:38 2006
--- ./src/ssl.c	Tue Jan 19 19:53:29 2010
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/ssl.c 1.32 2006/01/10 19:25:38 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9.
    SSL (Secure Socket Layer) Tunneling functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1998,99,2000,01,02,03,04,05,06 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/ssl.c 1.33 2010/01/19 19:53:29 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    SSL (Secure Socket Layer) Tunneling functions.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1998-2010 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 98,104 ****
      server=OpenClientSocket(server_host,server_port);
  
      if(server==-1)
!        msg=GetPrintMessage(Warning,"Cannot open the SSL connection to %s port %d; [%!s].",server_host,server_port);
      else
        {
         init_io(server);
--- 98,104 ----
      server=OpenClientSocket(server_host,server_port);
  
      if(server==-1)
!        msg=GetPrintMessage(Warning,"Cannot open the https (SSL) connection to %s port %d; [%!s].",server_host,server_port);
      else
        {
         init_io(server);
***************
*** 106,112 ****
        }
     }
   else
!     msg=GetPrintMessage(Warning,"No port given for the SSL connection to %s.",server_host);
  
   return(msg);
  }
--- 106,112 ----
        }
     }
   else
!     msg=GetPrintMessage(Warning,"No port given for the https (SSL) connection to %s.",server_host);
  
   return(msg);
  }
***************
*** 140,149 ****
  
      head=HeaderString(request_head);
  
!     PrintMessage(ExtraDebug,"Outgoing Request Head (to SSL proxy)\n%s",head);
  
      if(write_string(server,head)==-1)
!        msg=GetPrintMessage(Warning,"Failed to write to remote SSL proxy; [%!s].");
  
      free(head);
     }
--- 140,149 ----
  
      head=HeaderString(request_head);
  
!     PrintMessage(ExtraDebug,"Outgoing Request Head (to https (SSL) proxy)\n%s",head);
  
      if(write_string(server,head)==-1)
!        msg=GetPrintMessage(Warning,"Failed to write to remote https (SSL) proxy; [%!s].");
  
      free(head);
     }
diff -c -a -r -P ../wwwoffle-2.9e/src/version.h ./src/version.h
*** ../wwwoffle-2.9e/src/version.h	Sun Jan 25 16:00:03 2009
--- ./src/version.h	Sun Jan 31 18:42:02 2010
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/version.h 1.59 2009/01/25 16:00:03 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9e.
    The current version number.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1998-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/version.h 1.60 2010/01/31 18:42:02 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    The current version number.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1998-2010 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 17,22 ****
  #define VERSION_H    /*+ To stop multiple inclusions. +*/
  
  /*+ The version number as a string. +*/
! #define WWWOFFLE_VERSION "2.9e"
  
  #endif /* VERSION_H */
--- 17,22 ----
  #define VERSION_H    /*+ To stop multiple inclusions. +*/
  
  /*+ The version number as a string. +*/
! #define WWWOFFLE_VERSION "2.9f"
  
  #endif /* VERSION_H */
diff -c -a -r -P ../wwwoffle-2.9e/src/wwwoffle.c ./src/wwwoffle.c
*** ../wwwoffle-2.9e/src/wwwoffle.c	Thu Mar  6 17:53:43 2008
--- ./src/wwwoffle.c	Fri Jan 22 19:23:16 2010
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/wwwoffle.c 2.84 2008/03/06 17:53:43 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9e.
    A user level program to interact with the server.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996-2008 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/wwwoffle.c 2.85 2009/03/13 19:30:39 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    A user level program to interact with the server.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 55,60 ****
--- 55,62 ----
  
   Dump,                          /*+ Tell the server to dump the configuration file. +*/
  
+  CycleLog,                      /*+ Tell the server to close and re-open the log file. +*/
+ 
   Purge,                         /*+ Tell the server to purge pages. +*/
  
   Status,                        /*+ Find out from the server the current status. +*/
***************
*** 212,217 ****
--- 214,228 ----
         continue;
        }
  
+     if(!strcmp(argv[i],"-cyclelog"))
+       {
+        if(action!=None)
+          {fprintf(stderr,"wwwoffle: Only one command at a time.\n\n");usage(0);}
+        action=CycleLog;
+        argv[i]=NULL;
+        continue;
+       }
+ 
      if(!strcmp(argv[i],"-purge"))
        {
         if(action!=None)
***************
*** 424,431 ****
     }
   else if(action!=Get && action!=Output && action!=OutputWithHeader && n_url_file_list!=0)
     {
!     fprintf(stderr,"wwwoffle: The -online, -autodial, -offline, -fetch, -config, -dump, -purge,\n"
!                    "          -status and -kill options require no other command line arguments.\n\n");
      usage(0);
     }
  
--- 435,442 ----
     }
   else if(action!=Get && action!=Output && action!=OutputWithHeader && n_url_file_list!=0)
     {
!     fprintf(stderr,"wwwoffle: The -online, -autodial, -offline, -fetch, -config, -dump, -cyclelog,\n"
!                    "          -purge, -status and -kill options must have no other arguments.\n\n");
      usage(0);
     }
  
***************
*** 535,540 ****
--- 546,553 ----
         write_string(socket,"WWWOFFLE CONFIG\r\n");
      else if(action==Dump)
         write_string(socket,"WWWOFFLE DUMP\r\n");
+     else if(action==CycleLog)
+        write_string(socket,"WWWOFFLE CYCLELOG\r\n");
      else if(action==Purge)
         write_string(socket,"WWWOFFLE PURGE\r\n");
      else if(action==Status)
***************
*** 559,568 ****
         else if(action==Offline && !strncmp("WWWOFFLE Already Offline",line,(size_t)24))
            exitval=1;
         else if(action==Fetch && (!strncmp("WWWOFFLE Already Fetching",line,(size_t)25) ||
!                             !strncmp("WWWOFFLE Must be online or autodial to fetch",line,(size_t)44)))
            exitval=1;
         else if(action==Config && !strncmp("Configuration file syntax error",line,(size_t)31))
            exitval=1;
        }
  
      finish_io(socket);
--- 572,583 ----
         else if(action==Offline && !strncmp("WWWOFFLE Already Offline",line,(size_t)24))
            exitval=1;
         else if(action==Fetch && (!strncmp("WWWOFFLE Already Fetching",line,(size_t)25) ||
!                                  !strncmp("WWWOFFLE Must be online or autodial to fetch",line,(size_t)44)))
            exitval=1;
         else if(action==Config && !strncmp("Configuration file syntax error",line,(size_t)31))
            exitval=1;
+        else if(action==CycleLog && !strncmp("WWWOFFLE Has No Log File",line,(size_t)24))
+           exitval=1;
        }
  
      finish_io(socket);
***************
*** 986,992 ****
   fprintf(stderr,
           "Usage: wwwoffle -h | --help | --version\n"
           "       wwwoffle -online | -autodial | -offline | -fetch\n"
!          "       wwwoffle -config | -dump | -purge | -status | -kill\n"
           "       wwwoffle [-o|-O] <url>\n"
           "       wwwoffle [-post|-put] <url>\n"
           "       wwwoffle [-g[Sisfo]] [-F] [-(d|r|R)[<depth>]] <url> ...\n"
--- 1001,1007 ----
   fprintf(stderr,
           "Usage: wwwoffle -h | --help | --version\n"
           "       wwwoffle -online | -autodial | -offline | -fetch\n"
!          "       wwwoffle -config | -dump | -cyclelog | -purge | -status | -kill\n"
           "       wwwoffle [-o|-O] <url>\n"
           "       wwwoffle [-post|-put] <url>\n"
           "       wwwoffle [-g[Sisfo]] [-F] [-(d|r|R)[<depth>]] <url> ...\n"
***************
*** 1018,1023 ****
--- 1033,1040 ----
              "\n"
              "wwwoffle -dump       : Force the server to dump the current configuration.\n"
              "\n"
+             "wwwoffle -cyclelog   : Force the server to close and re-open the log file.\n"
+             "\n"
              "wwwoffle -status     : Query the server about its current status.\n"
              "\n"
              "wwwoffle -purge      : Force the server to purge pages from the cache.\n"
diff -c -a -r -P ../wwwoffle-2.9e/src/wwwoffled.c ./src/wwwoffled.c
*** ../wwwoffle-2.9e/src/wwwoffled.c	Sun May 27 12:20:56 2007
--- ./src/wwwoffled.c	Fri Mar 13 19:30:39 2009
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/wwwoffled.c 2.82 2007/03/25 11:06:21 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9.
    A demon program to maintain the database and spawn the servers.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996,97,98,99,2000,01,02,03,04,05 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/wwwoffled.c 2.83 2009/03/13 19:30:39 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    A demon program to maintain the database and spawn the servers.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 108,113 ****
--- 108,119 ----
  /*+ True if the pid of the daemon should be printed at startup +*/
  static int print_pid=0;
  
+ /*+ The name of the configuration file specified. +*/
+ static char *config_file=NULL;
+ 
+ /*+ The name of the log file specified. +*/
+ char *log_file=NULL;
+ 
  /*+ True if the -f option was passed on the command line. +*/
  int nofork=0;
  
***************
*** 121,127 ****
   int i;
   int err;
   struct stat buf;
-  char *config_file=NULL,*log_file=NULL;
   int uid,gid;
  
   /* Parse the command line options */
--- 127,132 ----
diff -c -a -r -P ../wwwoffle-2.9e/src/wwwoffles.c ./src/wwwoffles.c
*** ../wwwoffle-2.9e/src/wwwoffles.c	Wed Jan 14 19:52:55 2009
--- ./src/wwwoffles.c	Tue Jan 19 19:53:33 2010
***************
*** 1,12 ****
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/wwwoffles.c 2.322 2009/01/14 19:52:55 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9e.
    A server to fetch the required pages.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996-2009 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
--- 1,12 ----
  /***************************************
!   $Header: /home/amb/wwwoffle/src/RCS/wwwoffles.c 2.325 2010/01/19 19:53:33 amb Exp $
  
!   WWWOFFLE - World Wide Web Offline Explorer - Version 2.9f.
    A server to fetch the required pages.
    ******************/ /******************
    Written by Andrew M. Bishop
  
!   This file Copyright 1996-2010 Andrew M. Bishop
    It may be distributed under the GNU Public License, version 2, or
    any higher version.  See section COPYING of the GNU Public license
    for conditions under which this file may be redistributed.
***************
*** 172,178 ****
  
         if(port==ConfigInteger(HTTPS_Port))
            if(configure_io_gnutls(client,host,1))
!              PrintMessage(Fatal,"Cannot start SSL/TLS connection");
        }
     }
  
--- 172,178 ----
  
         if(port==ConfigInteger(HTTPS_Port))
            if(configure_io_gnutls(client,host,1))
!              PrintMessage(Fatal,"Cannot start SSL/TLS connection for https port.");
        }
     }
  
***************
*** 345,351 ****
         PrintMessage(Warning,"A 'CONNECT' method request for '%s' cannot be handled in Spool mode.",Url->hostport);
  
         HTMLMessage(client,500,"WWWOFFLE Server Error",NULL,"ServerError",
!                    "error","SSL proxy connection while offline is not allowed.",
                     NULL);
         mode=InternalPage; goto internalpage;
        }
--- 345,351 ----
         PrintMessage(Warning,"A 'CONNECT' method request for '%s' cannot be handled in Spool mode.",Url->hostport);
  
         HTMLMessage(client,500,"WWWOFFLE Server Error",NULL,"ServerError",
!                    "error","An https (SSL) connection while offline is not allowed.",
                     NULL);
         mode=InternalPage; goto internalpage;
        }
***************
*** 424,430 ****
            err=configure_io_gnutls(client,Url->host,2);
  
         if(err)
!           PrintMessage(Fatal,"Could not initialise SSL connection to client.");
  
         SetLocalPort(ConfigInteger(HTTPS_Port));
  
--- 424,430 ----
            err=configure_io_gnutls(client,Url->host,2);
  
         if(err)
!           PrintMessage(Fatal,"Could not initialise https (SSL) connection to client.");
  
         SetLocalPort(ConfigInteger(HTTPS_Port));
  
***************
*** 436,451 ****
  
         goto checkrequest;
        }
- #endif
      else
        {
!        PrintMessage(Warning,"A SSL proxy connection for %s was received but is not allowed.",Url->hostport);
  
         HTMLMessage(client,500,"WWWOFFLE Server Error",NULL,"ServerError",
!                    "error","SSL proxy connection to specified host and port is not allowed.",
                     NULL);
         mode=InternalPage; goto internalpage;
        }
     }
   else if(strcmp(request_head->method,"GET") &&
           strcmp(request_head->method,"HEAD") &&
--- 436,461 ----
  
         goto checkrequest;
        }
      else
        {
!        PrintMessage(Warning,"An https (SSL) cached proxy connection for %s was received but is not allowed.",Url->hostport);
! 
!        HTMLMessage(client,500,"WWWOFFLE Server Error",NULL,"ServerError",
!                    "error","An https (SSL) cached proxy connection to specified host (and port) is not allowed.",
!                    NULL);
!        mode=InternalPage; goto internalpage;
!       }
! #else
!     else
!       {
!        PrintMessage(Warning,"An https (SSL) non-tunneled proxy connection for %s was received but is not supported.",Url->hostport);
  
         HTMLMessage(client,500,"WWWOFFLE Server Error",NULL,"ServerError",
!                    "error","An https (SSL) non-tunneled proxy connection is not supported.",
                     NULL);
         mode=InternalPage; goto internalpage;
        }
+ #endif
     }
   else if(strcmp(request_head->method,"GET") &&
           strcmp(request_head->method,"HEAD") &&
***************
*** 489,498 ****
     {
      if(IsSSLAllowed(Url,0)) /* tunnel SSL connection */
        {
!        PrintMessage(Warning,"A SSL request for %s was received but tunnelling only is allowed.",Url->hostport);
  
         if(client!=-1)
!           write_formatted(client,"Cannot fetch %s [HTTPS tunnelling not supported in this mode]\n",Url->name);
  
         /*@-mustfreefresh@*/
         return(1); /* We don't bother to free memory because return() is exit() in child. */
--- 499,508 ----
     {
      if(IsSSLAllowed(Url,0)) /* tunnel SSL connection */
        {
!        PrintMessage(Warning,"An https (SSL) tunneled request for %s was received but is not allowed when fetching.",Url->hostport);
  
         if(client!=-1)
!           write_formatted(client,"Cannot fetch %s [https (SSL) tunnelling not allowed]\n",Url->name);
  
         /*@-mustfreefresh@*/
         return(1); /* We don't bother to free memory because return() is exit() in child. */
***************
*** 501,518 ****
  #if USE_GNUTLS
      else if(ConfigBoolean(SSLEnableCaching) && IsSSLAllowed(Url,1)) /* cache SSL connection */
         ;
- #endif
      else
        {
!        PrintMessage(Warning,"A SSL request for %s was received but not allowed.",Url->hostport);
  
         if(client!=-1)
!           write_formatted(client,"Cannot fetch %s [HTTPS not allowed for this host]\n",Url->name);
  
         /*@-mustfreefresh@*/
         return(1); /* We don't bother to free memory because return() is exit() in child. */
         /*@=mustfreefresh@*/
        }
     }
  
  
--- 511,540 ----
  #if USE_GNUTLS
      else if(ConfigBoolean(SSLEnableCaching) && IsSSLAllowed(Url,1)) /* cache SSL connection */
         ;
      else
        {
!        PrintMessage(Warning,"An https (SSL) request for %s was received but is not allowed.",Url->hostport);
  
         if(client!=-1)
!           write_formatted(client,"Cannot fetch %s [https (SSL) not allowed for this host]\n",Url->name);
  
         /*@-mustfreefresh@*/
         return(1); /* We don't bother to free memory because return() is exit() in child. */
         /*@=mustfreefresh@*/
        }
+ #else
+     else
+       {
+        PrintMessage(Warning,"An https (SSL) request for %s was received but is not supported when fetching.",Url->hostport);
+ 
+        if(client!=-1)
+           write_formatted(client,"Cannot fetch %s [https (SSL) not supported]\n",Url->name);
+ 
+        /*@-mustfreefresh@*/
+        return(1); /* We don't bother to free memory because return() is exit() in child. */
+        /*@=mustfreefresh@*/
+       }
+ #endif
     }
  
  
***************
*** 1246,1258 ****
        }
     }
  
-  /* If a HEAD request when online then don't cache */
- 
-  if((mode==Real || mode==RealRefresh) && head_only)
-    {
-     mode=RealNoCache;
-    }
- 
   /* If not caching then only use the password version. */
  
   if(mode==RealNoCache && Urlpw)
--- 1268,1273 ----
***************
*** 1484,1493 ****
  
   else if(mode==Real)
     {
!     if(conditional_request_ims)
!        RemoveFromHeader(request_head,"If-Modified-Since");
!     if(conditional_request_inm)
!        RemoveFromHeader(request_head,"If-None-Match");
  
      spool=-1;
  
--- 1499,1505 ----
  
   else if(mode==Real)
     {
!     int not_modified=0;
  
      spool=-1;
  
***************
*** 1500,1505 ****
--- 1512,1533 ----
            init_io(spool);
        }
  
+     /* Check if the page has been modified in case of a conditional request */
+ 
+     if(spool!=-1 && (conditional_request_inm || conditional_request_ims))
+       {
+        if(!IsModified(spool,request_head))
+           not_modified=1;
+ 
+        lseek(spool,(off_t)0,SEEK_SET);
+        reinit_io(spool);
+       }
+ 
+     if(conditional_request_ims)
+        RemoveFromHeader(request_head,"If-Modified-Since");
+     if(conditional_request_inm)
+        RemoveFromHeader(request_head,"If-None-Match");
+ 
      /* if not cached or not openable then don't do anything else. */
  
      if(spool==-1)
***************
*** 1510,1515 ****
--- 1538,1554 ----
      else if(RequireChanges(spool,request_head,Url))
         ;
  
+     /* Return a not-modified header if it isn't modified. */
+ 
+     else if(not_modified)
+       {
+        DeleteLockWebpageSpoolFile(Url);
+ 
+        HTMLMessageHead(client,304,"WWWOFFLE Not Modified",
+                        NULL);
+        mode=InternalPage; goto internalpage;
+       }
+ 
      /* Otherwise just use the spooled version. */
  
      else
***************
*** 1619,1624 ****
--- 1658,1671 ----
      request_head->size-=1;
     }
  
+  /* If a HEAD request when online then don't cache */
+ 
+  if((mode==Real || mode==RealRefresh) && head_only)
+    {
+     DeleteLockWebpageSpoolFile(Url);
+     mode=RealNoCache;
+    }
+ 
  
   /*----------------------------------------
     mode = Spool, SpoolGet, SpoolPragma, SpoolRefresh, Real, RealRefresh, RealNoCache or Fetch
