/***************************************
  $Header: /home/amb/wwwoffle/src/RCS/io.h 1.2 2003/02/17 17:48:22 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.8.
  Miscellaneous HTTP / HTML functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99,2000,01,02,03 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef IO_H
#define IO_H    /*+ To stop multiple inclusions. +*/

/*+ The size of the buffer to use when reading from the cache or a socket. +*/
#define READ_BUFFER_SIZE 4096


/* In io.c */

void init_io(int fd);
void reinit_io(int fd);

void configure_io_read(int fd,int timeout,int zlib,int chunked);
void configure_io_write(int fd,int timeout,int zlib,int chunked);

int read_data(int fd,/*@out@*/ char *buffer,int n);

char /*@null@*/ *read_line(int fd,/*@out@*/ /*@returned@*/ /*@null@*/ char *line);

int /*@alt void@*/ write_data(int fd,const char *data,int n);

int /*@alt void@*/ write_string(int fd,const char *str);

#ifdef __GNUC__
int /*@alt void@*/ write_formatted(int fd,const char *fmt,...) /*@printflike@*/ __attribute__ ((format (printf,2,3)));
#else
int /*@alt void@*/ write_formatted(int fd,const char *fmt,...) /*@printflike@*/;
#endif

int empty_io(int fd);
void finish_io(int fd);

#endif /* IO_H */
