/***************************************
  $Header: /home/amb/wwwoffle/RCS/uncompress-cache.c 1.4 2001/03/31 19:39:47 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.6c.
  Uncompress the cache.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1998,99,2000,01 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <utime.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "wwwoffle.h"
#include "misc.h"
#include "errors.h"
#include "config.h"

/*+ Need this for Win32 to use binary mode +*/
#ifndef O_BINARY
#define O_BINARY 0
#endif

/*+ Set this to 0 for debugging so that nothing is changed. +*/
#define DO_RENAME 1

#if USE_ZLIB
static void UncompressProto(char *proto);
static void UncompressHost(char *proto,char *host);
#endif


/*+ A file descriptor for the spool directory. +*/
int fSpoolDir=-1;


/*++++++++++++++++++++++++++++++++++++++
  The main program
  ++++++++++++++++++++++++++++++++++++++*/

int main(int argc,char** argv)
{
#if USE_ZLIB

 int i;
 struct stat buf;

 /* Initialise */

 if(argc!=2 || argv[1][0]!='/')
   {fprintf(stderr,"Usage: uncompress-cache <full-path-to-spool-dir>\n");exit(1);}

 InitErrorHandler("uncompress-cache",0,1);

 InitConfigurationFile(argv[1]);

 umask(0);

 /* Change to the spool directory. */

 if(chdir(argv[1]))
    PrintMessage(Fatal,"Cannot change to the spool directory '%s' [%!s]; uncompression failed.",argv[1]);

#if !defined(__CYGWIN__)
 fSpoolDir=open(".",O_RDONLY);
 if(fSpoolDir==-1)
    PrintMessage(Fatal,"Cannot open the spool directory '%s' [%!s]; uncompression failed.",argv[1]);
#endif

 /* Create the new spool directory. */

 for(i=0;i<3;i++)
   {
    char *proto;

    if(i==0)
       proto="http";
    else if(i==1)
       proto="ftp";
    else
       proto="finger";

    if(stat(proto,&buf))
       PrintMessage(Inform,"Cannot stat the '%s' directory [%!s]; not uncompressed.",proto);
    else
      {
       printf("Uncompressing %s\n",proto);

       if(chdir(proto))
          PrintMessage(Warning,"Cannot change to the '%s' directory [%!s]; uncompression failed.",proto);
       else
         {
          UncompressProto(proto);

          fchdir(fSpoolDir);
         }
      }
   }

 close(fSpoolDir);

 return(0);

#else

 fprintf(stderr,"Error: uncompress-cache was compiled without zlib, no uncompression possible.\n");

 return(1);

#endif /* USE_ZLIB */
}


#if USE_ZLIB

/*++++++++++++++++++++++++++++++++++++++
  Uncompress a complete protocol directory.

  char *proto The protocol of the spool directory we are in.
  ++++++++++++++++++++++++++++++++++++++*/

static void UncompressProto(char *proto)
{
 DIR *dir;
 struct dirent* ent;
 struct stat buf;

 /* Open the spool directory. */

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open spool directory '%s' [%!s]; uncompression failed.",proto);return;}

 ent=readdir(dir);  /* skip .  */
 if(!ent)
   {PrintMessage(Warning,"Cannot read spool directory '%s' [%!s]; uncompression failed.",proto);closedir(dir);return;}
 ent=readdir(dir);  /* skip .. */

 /* Go through each entry. */

 while((ent=readdir(dir)))
   {
    if(stat(ent->d_name,&buf))
       PrintMessage(Warning,"Cannot stat file '%s/%s' [%!s] not uncompressed.",proto,ent->d_name);
    else if(S_ISDIR(buf.st_mode))
      {
       if(chdir(ent->d_name))
          PrintMessage(Warning,"Cannot change to the '%s/%s' directory [%!s]; uncompression failed.",proto,ent->d_name);
       else
         {
          printf("  Uncompressing %s\n",ent->d_name);

          UncompressHost(proto,ent->d_name);

          fchdir(fSpoolDir);
          chdir(proto);
         }
      }
   }

 closedir(dir);
}


/*++++++++++++++++++++++++++++++++++++++
  Uncompress a complete host directory.

  char *proto The protocol of the spool directory we are in.

  char *host The hostname of the spool directory we are in.
  ++++++++++++++++++++++++++++++++++++++*/

static void UncompressHost(char *proto,char *host)
{
 DIR *dir;
 struct dirent* ent;
 int ifd,ofd;
 char *zfile;
 Header *spool_head;
 char *head,buffer[READ_BUFFER_SIZE];
 int n;
 struct stat buf;
 struct utimbuf ubuf;

 /* Open the spool directory. */

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open spool directory '%s/%s' [%!s]; uncompression failed.",proto,host);return;}

 ent=readdir(dir);  /* skip .  */
 if(!ent)
   {PrintMessage(Warning,"Cannot read spool directory '%s/%s' [%!s]; uncompression failed.",proto,host);closedir(dir);return;}
 ent=readdir(dir);  /* skip .. */

 /* Go through each entry. */

 while((ent=readdir(dir)))
   {
    if(!stat(ent->d_name,&buf) && *ent->d_name=='D' && S_ISREG(buf.st_mode))
      {
       ubuf.actime=buf.st_atime;
       ubuf.modtime=buf.st_mtime;

       ifd=open(ent->d_name,O_RDONLY|O_BINARY);
       init_buffer(ifd);

       if(ifd==-1)
         {
          PrintMessage(Inform,"Cannot open file '%s/%s/%s' to uncompress it [%!s]; race condition?",proto,host,ent->d_name);
          continue;
         }

       ParseReply(ifd,NULL,&spool_head);

       if(GetHeader(spool_head,"Pragma","wwwoffle-compressed"))
         {
          printf("    %s\n",ent->d_name);

          init_zlib_buffer(ifd,2);

          zfile=(char*)malloc(strlen(ent->d_name)+4);
          strcpy(zfile,ent->d_name);
          strcat(zfile,".z");

          ofd=open(zfile,O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,buf.st_mode&07777);
          init_buffer(ofd);

          if(ofd==-1)
            {
             PrintMessage(Inform,"Cannot open file '%s/%s/%s' to uncompress to [%!s].",proto,host,zfile);
             FreeHeader(spool_head);
             close(ifd);
             utime(ent->d_name,&ubuf);
             continue;
            }

          RemoveFromHeader(spool_head,"Content-Encoding",NULL);
          RemoveFromHeader(spool_head,"Pragma","wwwoffle-compressed");

          head=HeaderString(spool_head);

          write_string(ofd,head);
          free(head);

          while((n=read_data(ifd,buffer,READ_BUFFER_SIZE))>0)
             write_data(ofd,buffer,n);

          finish_zlib_buffer(ifd);

          close(ofd);

#if DO_RENAME
          if(rename(zfile,ent->d_name))
            {
             PrintMessage(Inform,"Cannot rename file '%s/%s/%s' to '%s/%s/%s' [%!s].",proto,host,zfile,proto,host,ent->d_name);
             unlink(zfile);
            }
          else
#endif
             utime(zfile,&ubuf);

          free(zfile);
         }

       FreeHeader(spool_head);
       close(ifd);
       utime(ent->d_name,&ubuf);
      }
   }

 closedir(dir);
}

#endif /* USE_ZLIB */
