#include <stdio.h>

extern char *getcwd();
extern char *malloc();
extern char *index();
extern char *strstr();

char *thiscwd, *cygdir, *datadir, *dospath;
char drivestr[4];

main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp, *fp_old;
	char *s;
	char confline[1024];

	thiscwd = getcwd(NULL, 256);
	cygdir = malloc(256);
	datadir = malloc(256);
	dospath = malloc(256);

	/* delete leading 'cygdrive' */
	sprintf(cygdir, "/%s", &thiscwd[9]);
	sprintf(drivestr, "%c:\n", thiscwd[10]);
	sprintf(datadir, "%s/data", cygdir);
	strcpy(dospath, &thiscwd[11]);

	/* Convert slashes in dos path */
	for (s = dospath; *s; s++)
		if (*s == '/')
			*s = '\\';

	printf("cygdir = '%s'\n", cygdir);
	printf("drivestr = %s", drivestr);
	printf("datadir = '%s'\n", datadir);
	printf("dospath = '%s'\n", dospath);

	/* Write out start.bat */
	printf("Rewriting start.bat\n");
	fp = fopen("start.bat", "w");
	fprintf(fp, "@echo off\n");
	fprintf(fp, "rem generated by inst-patch.exe\n");
	fprintf(fp, drivestr);
	fprintf(fp, "cd \"%s\"\n", dospath);
	fprintf(fp, "bin\\wwwoffled -d -c wwwoffle.conf\n");
	fclose(fp);
	printf("Done\n");

	/* Write out stop.bat */
	printf("Rewriting stop.bat\n");
	fp = fopen("stop.bat", "w");
	fprintf(fp, "@echo off\n");
	fprintf(fp, "rem generated by inst-patch.exe\n");
	fprintf(fp, drivestr);
	fprintf(fp, "cd \"%s\"\n", dospath);
	fprintf(fp, "bin\\wwwoffle -kill\n");
	fclose(fp);
	printf("Done\n");

	/* Write out online.bat */
	printf("Rewriting online.bat\n");
	fp = fopen("online.bat", "w");
	fprintf(fp, "@echo off\n");
	fprintf(fp, "rem generated by inst-patch.exe\n");
	fprintf(fp, drivestr);
	fprintf(fp, "cd \"%s\"\n", dospath);
	fprintf(fp, "bin\\wwwoffle -online\n");
	fprintf(fp, "bin\\wwwoffle -fetch\n");
	fclose(fp);
	printf("Done\n");


	/* Write out offline.bat */
	printf("Rewriting offline.bat\n");
	fp = fopen("offline.bat", "w");
	fprintf(fp, "@echo off\n");
	fprintf(fp, "rem generated by inst-patch.exe\n");
	fprintf(fp, drivestr);
	fprintf(fp, "cd \"%s\"\n", dospath);
	fprintf(fp, "bin\\wwwoffle -offline\n");
	fclose(fp);
	printf("Done\n");

	/*
	 * Patch wwwoffle.conf
	 */

	printf("Patching wwwoffle.conf...\n");

	/* delete any old backup */
	if (unlink("wwwoffle.conf.prev") == -1)
		printf("Error deleting wwwoffle.conf\n");

	/* back it up */
	if (rename("wwwoffle.conf", "wwwoffle.conf.prev") == -1)
		printf("Error backing up wwwoffle.conf\n");

	fp_old = fopen("wwwoffle.conf.prev", "r");		/* open old file */
	fp = fopen("wwwoffle.conf", "w");				/* open new file */

	/* put marker into wwwoffle.conf */
	fprintf(fp, "# Patched at install-time by inst-patch.exe\n");

	/* The big wwwoffle.conf hack loop */
	while (fgets(confline, 1024, fp_old) != NULL)
	{
		/* test for the spool dir dec */
		if (index(confline, '#') != NULL)
		{
			/* this is a comment line - echo it */
			fputs(confline, fp);
			continue;
		}

		/* test for "spool-dir" dec */
		if (strstr(confline, "spool-dir") == NULL)
		{
			/* not a spool-dir dec - echo it */
			fputs(confline, fp);
			continue;
		}

		/* write out the doctored dec */
		fputs("# patched at install time\n", fp);
		fputs("# if you move the data dir, then change this declaration\n", fp);
		fputs("# to the new directory.\n", fp);
		fputs("#\n# NOTE: directory path must be given in Cygwin notation\n", fp);
		fprintf(fp, "spool-dir         = %s\n", datadir);
	}

	fclose(fp_old);
	fclose(fp);
	printf("Successfully generated bat files\n");
	printf("Successfully patched spool-dir in wwwoffle.conf\n");
	printf("Post-install successfully completed\n");
}
