/***************************************
  $Header: /home/amb/wwwoffle/RCS/configfile.h 1.2 2001/05/23 18:54:59 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.6d.
  Configuration file management functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99,2000,01 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef CONFIGFILE_H
#define CONFIGFILE_H    /*+ To stop multiple inclusions. +*/

#define CONFIG_VERIFY_ABORT 1

/* Type definitions */

/*+ The type of value to expect for a value. +*/
typedef enum _ConfigType
{
 Fixed,                         /*+ When the left hand side is fixed. +*/
 None,                          /*+ When there is no right hand side. +*/

 CfgMaxServers,                 /*+ Max number of servers to fork (>0, <MAX_SERVERS). +*/
 CfgMaxFetchServers,            /*+ Max number of servers for fetching pages (>0, <MAX_FETCH_SERVERS). +*/

 CfgLogLevel,                   /*+ A log level (debug, info, important, warning or fatal). +*/

 Boolean,                       /*+ A boolean response (yes/no 1/0 true/false). +*/

 PortNumber,                    /*+ For port numbers (>0). +*/

 AgeDays,                       /*+ An age in days (can be -ve). +*/
 TimeSecs,                      /*+ A time in seconds (can be -ve). +*/

 CacheSize,                     /*+ The cache size (must be >=0). +*/
 FileSize,                      /*+ A file size (must be >=0) +*/

 Percentage,                    /*+ A percentage (must be >=0 and <=100) +*/

 UserId,                        /*+ For user IDs, (numeric or string). +*/
 GroupId,                       /*+ For group IDs, (numeric or string). +*/

 String,                        /*+ For an arbitrary string. +*/

 PathName,                      /*+ For pathname values (string starting with '/'). +*/
 FileExt,                       /*+ A file extension (.string). +*/
 FileMode,                      /*+ The mode for dir/file creation. +*/

 MIMEType,                      /*+ A MIME type (string/string). +*/

 Host,                          /*+ For host names (string). +*/
 HostOrNone,                    /*+ For host names (string) or nothing. +*/
 HostAndPort,                   /*+ For host name and port numbers (string[:port]). +*/
 HostAndPortOrNone,             /*+ For host name and port numbers (string[:port]) or nothing. +*/

 UserPass,                      /*+ A username and password (string:string) +*/

 Url,                           /*+ For a URL ([proto://host[:port]]/path). +*/
 UrlSpecification               /*+ A URL specification as described in README.CONF. +*/
}
ConfigType;

/*+ A description of one item of an entry in a section of the config file. +*/
typedef struct _ConfigItem* ConfigItem;

/*+ A description of an entry in a section of the config file. +*/
typedef struct _ConfigEntry
{
 char *name;                    /*+ The name of the entry. +*/
 ConfigItem *item;              /*+ A pointer to the item containing the values for the entry. +*/
 int        url_type;           /*+ Set to true if there is the option of having a URL present. +*/
 ConfigType key_type;           /*+ The type of the key on the left side of the equals sign. +*/
 ConfigType val_type;           /*+ The type of the value on the right side of the equals sign. +*/
 char       *defval;            /*+ The default value if no other is specified. +*/
}
ConfigEntry;

/*+ A description of a section in the config file. +*/
typedef struct _ConfigSection
{
 char *name;                    /*+ The name of the section. +*/
 int nentries;                  /*+ The number of entries in the section. +*/
 ConfigEntry *entries;          /*+ The entries in the section. +*/
}
ConfigSection;

/*+ A description of a whole config file. +*/
typedef struct _ConfigFile
{
 char *name;                    /*+ The name of the file. +*/
 int nsections;                 /*+ The number of sections in the file. +*/
 ConfigSection **sections;      /*+ The sections in the file. +*/
}
ConfigFile;

/*+ A URL-SPECIFICATION as described in README.CONF. +*/
typedef struct _UrlSpec
{
 int negated;                   /*+ Set to true if this is a negated URL-SPECIFICATION +*/
 char *proto;                   /*+ The protocol (or NULL). +*/
 char *host;                    /*+ The hostname (or NULL). +*/
 int port;                      /*+ The port number (or 0 or -1). +*/
 char *path;                    /*+ The pathname (or NULL). +*/
 char *args;                    /*+ The arguments (or NULL) +*/
}
UrlSpec;

/*+ A key or a value. +*/
typedef union _KeyOrValue
{
 char    *string;               /*+ A string value. +*/
 int      integer;              /*+ An integer value. +*/
 UrlSpec *urlspec;              /*+ A URL-SPECIFICATION +*/
}
KeyOrValue;

/*+ A configuration file item. +*/
struct _ConfigItem
{
 ConfigEntry *entry;            /*+ The corresponding entry. +*/
 int nitems;                    /*+ The number of items in the lists. +*/
 UrlSpec   **url;               /*+ The list of URL-SPECIFICATIONs if present. +*/
 KeyOrValue *key;               /*+ The list of keys. +*/
 KeyOrValue *val;               /*+ The list of values. +*/
 KeyOrValue *defval;            /*+ The default value. +*/
};


/* Function definitions */

void DefaultConfigFile(ConfigFile *config);
char *ReadConfigFile(ConfigFile *config);

int MatchUrlSpecification(UrlSpec *spec,char *proto,char *host,char *path,char *args);
int WildcardMatch(char *string,char *pattern);

#endif /* CONFIGFILE_H */
