/***************************************
  $Header: /home/amb/wwwoffle/RCS/config.h 2.71 2001/05/23 18:54:59 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.6d.
  Configuration file management functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99,2000,01 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef CONFIG_H
#define CONFIG_H    /*+ To stop multiple inclusions. +*/

#include <sys/types.h>

#include "misc.h"

#ifndef CONFIGFILE_H

/*+ A description of an entry in a section of the config file. +*/
typedef struct _ConfigItem *ConfigItem;

#endif

/* Global functions for accessing the configuration file information. */

char *ConfigurationFileName(void);
void InitConfigurationFile(char *name);
int ReadConfigurationFile(int fd);

int ConfigInteger(ConfigItem item);
#define ConfigBoolean ConfigInteger
char *ConfigString(ConfigItem item);

int ConfigIntegerURL(ConfigItem item,URL *Url);
#define ConfigBooleanURL ConfigIntegerURL
char *ConfigStringURL(ConfigItem item,URL *Url);

int ConfigBooleanMatchURL(ConfigItem item,URL *Url);


/* StartUp section */

/*+ The IP address to bind for IPv4. +*/
extern ConfigItem Bind_IPv4;

/*+ The IP address to bind for IPv6. +*/
extern ConfigItem Bind_IPv6;

/*+ The port number to use for the HTTP proxy port. +*/
extern ConfigItem HTTP_Port;

/*+ The port number to use for the wwwoffle port. +*/
extern ConfigItem WWWOFFLE_Port;

/*+ The spool directory. +*/
extern ConfigItem SpoolDir;

/*+ The user id for wwwoffled or -1 for none. +*/
extern ConfigItem WWWOFFLE_Uid;

/*+ The group id for wwwoffled or -1 for none. +*/
extern ConfigItem WWWOFFLE_Gid;

/*+ Whether to use the syslog facility or not. +*/
extern ConfigItem UseSyslog;

/*+ The password required for demon configuration. +*/
extern ConfigItem PassWord;

/*+ Maximum number of servers  +*/
extern ConfigItem MaxServers;          /*+ in total. +*/
extern ConfigItem MaxFetchServers;     /*+ for fetching. +*/


/* Options Section */

/*+ The level of error logging +*/
extern ConfigItem _LogLevel;

/*+ The amount of time that a socket connection will wait for data. +*/
extern ConfigItem SocketTimeout;

/*+ The amount of time that a DNS loookup will wait. +*/
extern ConfigItem DNSTimeout;

/*+ The amount of time that a socket will wait for the intial connection. +*/
extern ConfigItem ConnectTimeout;

/*+ The option to retry a failed connection. +*/
extern ConfigItem ConnectRetry;

/*+ The list of allowed SSL port numbers. +*/
extern ConfigItem SSLAllowPort;

/*+ The permissions for creation of +*/
extern ConfigItem DirPerm;             /*+ directories. +*/
extern ConfigItem FilePerm;            /*+ files. +*/

/*+ The name of a progam to run when changing mode to +*/
extern ConfigItem RunOnline;           /*+ online. +*/
extern ConfigItem RunOffline;          /*+ offline. +*/
extern ConfigItem RunAutodial;         /*+ auto dial. +*/
extern ConfigItem RunFetch;            /*+ fetch (start or stop). +*/

/*+ The option to have lock files to stop some problems. +*/
extern ConfigItem LockFiles;

/*+ The option to reply with compressed content encoding. +*/
extern ConfigItem ReplyCompressedData;


/* OnlineOptions section. */

/*+ The maximum age of a cached page to use in preference while online. +*/
extern ConfigItem RequestChanged;

/*+ The option to only request changes to a page once per session online. +*/
extern ConfigItem RequestChangedOnce;

/*+ The option to re-request pages that have expired. +*/
extern ConfigItem RequestExpired;

/*+ The option to re-request pages that have the no-cache flag set. +*/
extern ConfigItem RequestNoCache;

/*+ The option to try and get the requested URL without a password as well as with. +*/
extern ConfigItem TryWithoutPassword;

/*+ The option to keep downloads that are interrupted by the user. +*/
extern ConfigItem IntrDownloadKeep;

/*+ The option to keep on downloading interrupted pages if +*/
extern ConfigItem IntrDownloadSize;           /*+ smaller than a given size. +*/
extern ConfigItem IntrDownloadPercent;        /*+ more than a given percentage complete. +*/

/*+ The option to keep downloads that time out. +*/
extern ConfigItem TimeoutDownloadKeep;

/*+ The option to request compressed content encoding. +*/
extern ConfigItem RequestCompressedData;


/* OfflineOptions section */

/*+ The option to allow or ignore the 'Pragma: no-cache' request. +*/
extern ConfigItem PragmaNoCache;

/*+ The option to not automatically make requests while offline but to need confirmation. +*/
extern ConfigItem ConfirmRequests;

/*+ The list of URLs not to request. +*/
extern ConfigItem DontRequestOffline;


/* FetchOptions section */

/*+ The option to also fetch style sheets. +*/
extern ConfigItem FetchStyleSheets;

/*+ The option to also fetch images. +*/
extern ConfigItem FetchImages;

/*+ The option to also fetch webbug images. +*/
extern ConfigItem FetchWebbugImages;

/*+ The option to also fetch frames. +*/
extern ConfigItem FetchFrames;

/*+ The option to also fetch scripts. +*/
extern ConfigItem FetchScripts;

/*+ The option to also fetch objects. +*/
extern ConfigItem FetchObjects;


/* IndexOptions section */

/*+ The option to disable the lasttime/prevtime indexes. +*/
extern ConfigItem NoLasttimeIndex;

/*+ The choice of URLs to list in the outgoing index. +*/
extern ConfigItem IndexListOutgoing;

/*+ The choice of URLs to list in the lastime/prevtime and lastout/prevout indexes. +*/
extern ConfigItem IndexListLatest;

/*+ The choice of URLs to list in the monitor index. +*/
extern ConfigItem IndexListMonitor;

/*+ The choice of URLs to list in the host indexes. +*/
extern ConfigItem IndexListHost;

/*+ The choice of URLs to list in any index. +*/
extern ConfigItem IndexListAny;


/* ModifyHTML section */

/*+ The option to turn on the modifications in this section. +*/
extern ConfigItem EnableHTMLModifications;

/*+ The option to turn on the modifications when online. +*/
extern ConfigItem EnableModificationsOnline;

/*+ The option of a tag that can be added to the bottom of the spooled pages with the date and some buttons. +*/
extern ConfigItem AddCacheInfo;

/*+ The options to modify the anchor tags in the HTML. +*/
extern ConfigItem AnchorModifyBegin[3];
extern ConfigItem AnchorModifyEnd[3];

/*+ The option to disable scripts and scripted actions. +*/
extern ConfigItem DisableHTMLScript;

/*+ The option to disable Java applets. +*/
extern ConfigItem DisableHTMLApplet;

/*+ The option to disable stylesheets and style references. +*/
extern ConfigItem DisableHTMLStyle;

/*+ The option to disable the <blink> tag. +*/
extern ConfigItem DisableHTMLBlink;

/*+ The option to disable any <meta http-equiv=refresh content=""> tags. +*/
extern ConfigItem DisableHTMLMetaRefresh;

/*+ The option to disable any <meta http-equiv=refresh content=""> tags that refer to the same URL. +*/
extern ConfigItem DisableHTMLMetaRefreshSelf;

/*+ The option to disable links to pages in the DontGet list. +*/
extern ConfigItem DisableHTMLDontGetLinks;

/*+ The option to replace images that are in the DontGet list. +*/
extern ConfigItem ReplaceHTMLDontGetImages;

/*+ The URL to use as a replacement for the images that are in the DontGet list. +*/
extern ConfigItem ReplacementHTMLDontGetImage;

/*+ The option to replace images that are 1 pixel square. +*/
extern ConfigItem ReplaceHTMLWebbugImages;

/*+ The URL to use as a replacement for the images that are 1 pixel square. +*/
extern ConfigItem ReplacementHTMLWebbugImage;

/*+ The option to demoronise MS characters. +*/
extern ConfigItem DemoroniseMSChars;

/*+ The option to disable animated GIFs. +*/
extern ConfigItem DisableAnimatedGIF;


/* LocalHost section */

/*+ The list of localhost hostnames. +*/
extern ConfigItem LocalHost;


/* LocalNet section */

/*+ The list of local network hostnames. +*/
extern ConfigItem LocalNet;


/* AllowedConnectHosts section */

/*+ The list of allowed hostnames. +*/
extern ConfigItem AllowedConnectHosts;


/* AllowedConnectUsers section */

/*+ The list of allowed usernames and paswords. +*/
extern ConfigItem AllowedConnectUsers;


/* DontCache section */

/*+ The list of URLs not to cache. +*/
extern ConfigItem DontCache;


/* DontGet section */

/*+ The list of URLs not to get. +*/
extern ConfigItem DontGet;

/*+ The replacement URL. +*/
extern ConfigItem DontGetReplacementURL;

/*+ The list of URLs not to get recursively. +*/
extern ConfigItem DontGetRecursive;

/*+ The option to treat location headers to not got pages as errors. +*/
extern ConfigItem DontGetLocation;


/* CensorHeader section */

/*+ The list of censored headers. +*/
extern ConfigItem CensorHeader;

/*+ Flags to cause the referer header to be mangled. +*/
extern ConfigItem RefererSelf;
extern ConfigItem RefererSelfDir;


/* FTPOptions section */

/*+ The anon-ftp username. +*/
extern ConfigItem FTPUserName;

/*+ The anon-ftp password. +*/
extern ConfigItem FTPPassWord;

/*+ The information that is needed to allow non-anonymous access, +*/
extern ConfigItem FTPAuthUser;         /*+ username +*/
extern ConfigItem FTPAuthPass;         /*+ password +*/


/* MIMETypes section */

/*+ The default MIME type. +*/
extern ConfigItem DefaultMIMEType;

/*+ The list of MIME types. +*/
extern ConfigItem MIMETypes;


/* Proxy section */

/*+ The list of hostnames and proxies. +*/
extern ConfigItem Proxies;

/*+ The information that is needed to allow authorisation headers to be added, +*/
extern ConfigItem ProxyAuthUser;       /*+ username +*/
extern ConfigItem ProxyAuthPass;       /*+ password +*/

/*+ The SSL proxy to use. +*/
extern ConfigItem SSLProxy;


/* Alias section */

/*+ The list of protocols/hostnames and their aliases. +*/
extern ConfigItem Aliases;


/* Purge section */

/*+ A flag to indicate that the modification time is used instead of the access time. +*/
extern ConfigItem PurgeUseMTime;

/*+ The maximum allowed size of the cache. +*/
extern ConfigItem PurgeCacheSize;

/*+ The minimum allowed free disk space. +*/
extern ConfigItem PurgeDiskFree;

/*+ A flag to indicate if the whole URL is used to choose the purge age. +*/
extern ConfigItem PurgeUseURL;

/*+ A flag to indicate if the DontGet hosts are to be purged. +*/
extern ConfigItem PurgeDontGet;

/*+ A flag to indicate if the DontCache hosts are to be purged. +*/
extern ConfigItem PurgeDontCache;

/*+ The list of hostnames and purge ages. +*/
extern ConfigItem PurgeAges;

/*+ The list of hostnames and purge compress ages. +*/
extern ConfigItem PurgeCompressAges;


/* Options Section */

int IsSSLAllowedPort(char *host);


/* LocalHost Section */

char *GetLocalHost(int port);
int IsLocalHost(char *host,int port);


/* LocalNet Section */

int IsLocalNetHost(char *host);


/* AllowedConnectHosts Section */

int IsAllowedConnectHost(char *host);


/* AllowedConnectUsers Section */

char *IsAllowedConnectUser(char *userpass);


/* DontCompress section */

int NotCompressed(char *mime_type,char *path);


/* CensorHeader Section */

char *CensoredHeader(URL *Url,char *key,char *val);


/* MIMETypes Section */

char *WhatMIMEType(char *path);


/* Alias Section */

int IsAliased(char *proto,char *host,char *path,char **new_proto,char **new_host,char **new_path);


#endif /* CONFIG_H */
