/***************************************
  $Header: /home/amb/wwwoffle/RCS/finger.c 1.12 2001/03/21 19:15:51 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.6b.
  Functions for getting URLs using Finger.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1998,99,2000 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"
#include "misc.h"
#include "config.h"
#include "sockets.h"
#include "proto.h"

/*+ Set to the name of the proxy if there is one. +*/
static char *proxy=NULL;

/*+ The file descriptor of the server. +*/
static int server=-1;

/*+ A buffer to contain the reply head. +*/
static char *bufferhead=NULL;

/*+ The number of characters in the buffer +*/
static int nbufferhead=0,       /*+ in total for the head . +*/
           nreadhead=0;         /*+ that have been read from the head. +*/


/*++++++++++++++++++++++++++++++++++++++
  Open a connection to get a URL using Finger.

  char *Finger_Open Returns NULL on success, a useful message on error.

  URL *Url The URL to open.
  ++++++++++++++++++++++++++++++++++++++*/

char *Finger_Open(URL *Url)
{
 char *msg=NULL;
 char *colon;
 char *server_host=NULL;
 int server_port=Protocols[Protocol_Finger].defport;

 proxy=ConfigStringURL(Proxies,Url);
 if(IsLocalNetHost(Url->host))
    proxy=NULL;

 if(proxy)
   {
    server_host=(char*)malloc(strlen(proxy)+1);
    strcpy(server_host,proxy);
   }
 else
   {
    server_host=(char*)malloc(strlen(Url->host)+1);
    strcpy(server_host,Url->host);
   }

 if((colon=strchr(server_host,':')))
   {
    *colon++=0;
    if(*colon)
       server_port=atoi(colon);
   }

 /* Open the connection. */

 server=OpenClientSocket(server_host,server_port);
 init_buffer(server);

 if(server==-1)
    msg=PrintMessage(Warning,"Cannot open the Finger connection to %s port %d; [%!s].",server_host,server_port);

 free(server_host);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Write to the server to request the URL.

  char *Finger_Request Returns NULL on success, a useful message on error.

  URL *Url The URL to get.

  Header *request_head The head of the Finger request for the URL.

  Body *request_body The body of the Finger request for the URL.
  ++++++++++++++++++++++++++++++++++++++*/

char *Finger_Request(URL *Url,Header *request_head,Body *request_body)
{
 char *user,*slash;
 char *msg=NULL;

 /* Take a simple route if it is proxied. */

 if(proxy)
   {
    char *head;

    MakeRequestProxyAuthorised(proxy,request_head);

    head=HeaderString(request_head);

    if(write_string(server,head)==-1)
       msg=PrintMessage(Warning,"Failed to write to remote Finger proxy; [%!s].");

    free(head);

    return(msg);
   }

 /* Else Sort out the path. */

 user=(char*)malloc(strlen(Url->path));
 strcpy(user,Url->path+1);

 if((slash=strchr(user,'/')))
    *slash=0;

 if(*user)
   {
    if(write_formatted(server,"/W %s\r\n",user)==-1)
       msg=PrintMessage(Warning,"Failed to write to remote Finger server; [%!s].");
   }
 else
   {
    if(write_string(server,"/W\r\n")==-1)
       msg=PrintMessage(Warning,"Failed to write to remote Finger server; [%!s].");
   }

 free(user);


 bufferhead=HTMLMessageHead(-1,200,"Finger OK",
                            "Content-Type","text/plain",
                            NULL);

 nbufferhead=strlen(bufferhead);
 nreadhead=0;

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Read a line from the header of the reply for the URL.

  char *Finger_ReadHead Returns the next line of data, NULL on EOF.

  char *line The previous line read.
  ++++++++++++++++++++++++++++++++++++++*/

char *Finger_ReadHead(char *line)
{
 char *l=line;
 int m;

 /* Take a simple route if it is proxied. */

 if(proxy)
    return(read_line_or_timeout(server,line));
 
 /* Else send the header. */

 if(nreadhead==nbufferhead)
    return(NULL);

 for(m=nreadhead;m<nbufferhead;m++)
    if(bufferhead[m]=='\n')
       break;

 m++;
 l=(char*)realloc((void*)l,m-nreadhead+1);
 strncpy(l,&bufferhead[nreadhead],m-nreadhead);
 l[m-nreadhead]=0;

 nreadhead=m;

 return(l);
}


/*++++++++++++++++++++++++++++++++++++++
  Read bytes from the body of the reply for the URL.

  int Finger_ReadBody Returns the number of bytes read on success, -1 on error.

  char *s A string to fill in with the information.

  int n The number of bytes to read.
  ++++++++++++++++++++++++++++++++++++++*/

int Finger_ReadBody(char *s,int n)
{
 return(read_data_or_timeout(server,s,n));
}


/*++++++++++++++++++++++++++++++++++++++
  Close a connection opened using Finger.

  int Finger_Close Return 0 on success, -1 on error.
  ++++++++++++++++++++++++++++++++++++++*/

int Finger_Close(void)
{
 if(bufferhead)
    free(bufferhead);

 return(CloseSocket(server));
}
