/***************************************
  $Header: /home/amb/wwwoffle/RCS/http.c 1.26 2001/03/17 21:07:32 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.6b.
  Functions for getting URLs using HTTP.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99,2000,01 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"
#include "misc.h"
#include "config.h"
#include "sockets.h"
#include "proto.h"

/*+ Set to the name of the proxy if there is one. +*/
static char *proxy=NULL;

/*+ The file descriptor of the server. +*/
static int server=-1;

#if USE_ZLIB
/*+ A flag to indicate that a compressed page was requested. +*/
static int request_compressed=0;
#endif


/*++++++++++++++++++++++++++++++++++++++
  Open a connection to get a URL using HTTP.

  char *HTTP_Open Returns NULL on success, a useful message on error.

  URL *Url The URL to open.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_Open(URL *Url)
{
 char *msg=NULL;
 char *colon;
 char *server_host=NULL;
 int server_port=Protocols[Protocol_HTTP].defport;

 proxy=ConfigStringURL(Proxies,Url);
 if(IsLocalNetHost(Url->host))
    proxy=NULL;

 if(proxy)
   {
    server_host=(char*)malloc(strlen(proxy)+1);
    strcpy(server_host,proxy);
   }
 else
   {
    server_host=(char*)malloc(strlen(Url->host)+1);
    strcpy(server_host,Url->host);
   }

 if((colon=strchr(server_host,':')))
   {
    *colon++=0;
    if(*colon)
       server_port=atoi(colon);
   }

 /* Open the connection. */

 server=OpenClientSocket(server_host,server_port);
 init_buffer(server);

 if(server==-1)
    msg=PrintMessage(Warning,"Cannot open the HTTP connection to %s port %d; [%!s].",server_host,server_port);

 free(server_host);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Write to the server to request the URL.

  char *HTTP_Request Returns NULL on success, a useful message on error.

  URL *Url The URL to get.

  Header *request_head The head of the HTTP request for the URL.

  Body *request_body The body of the HTTP request for the URL.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_Request(URL *Url,Header *request_head,Body *request_body)
{
 char *msg=NULL,*head;

 /* Make the request OK for a proxy or not. */

 if(proxy)
    MakeRequestProxyAuthorised(proxy,request_head);
 else
    MakeRequestNonProxy(request_head);

 /* Add the compression header */

#if USE_ZLIB
 if(ConfigBooleanURL(RequestCompressedData,Url) && !NotCompressed(NULL,Url->path))
   {
    request_compressed=1;
    AddToHeader(request_head,"Accept-Encoding","deflate; q=1.0, x-gzip; q=0.9, gzip; q=0.9, identity; q=0.1");
   }
#endif

 /* Send the request. */

 head=HeaderString(request_head);

 if(proxy)
    PrintMessage(ExtraDebug,"Outgoing Request Head (to proxy)\n%s",head);
 else
    PrintMessage(ExtraDebug,"Outgoing Request Head (to server)\n%s",head);

 if(write_string(server,head)==-1)
    msg=PrintMessage(Warning,"Failed to write head to remote HTTP %s; [%!s].",proxy?"proxy":"server");
 if(request_body)
   {
#if 0
    if(request_body->content[request_body->length-1]!='\n')
      {
       request_body->content[request_body->length++]='\r';
       request_body->content[request_body->length++]='\n';
      }
#endif

    if(write_data(server,request_body->content,request_body->length)==-1)
       msg=PrintMessage(Warning,"Failed to write body to remote HTTP %s; [%!s].",proxy?"proxy":"server");
   }

 free(head);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Read a line from the header of the reply for the URL.

  char *HTTP_ReadHead Returns the next line of data, NULL on EOF.

  char *line The previous line read.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_ReadHead(char *line)
{
 char *newline;

#if USE_ZLIB
repeat:
#endif

 newline=read_line_or_timeout(server,line);

#if USE_ZLIB
 if(newline && request_compressed && !strncmp(newline,"Content-Encoding:",17))
   {
    int compression=WhichCompression(newline+17);

    if(compression)
      {
       char *p=newline+17,*q=newline+strlen(newline)-1;
       while(isspace(*p))
          p++;
       while(isspace(*q))
          *q--=0;
       PrintMessage(Inform,"Server has used 'Content-Encoding: %s'.",p); /* Used in audit-usage.pl */
       init_zlib_buffer(server,compression);
       line=newline;
       goto repeat;
      }
   }
#endif

 return(newline);
}


/*++++++++++++++++++++++++++++++++++++++
  Read bytes from the body of the reply for the URL.

  int HTTP_ReadBody Returns the number of bytes read on success, -1 on error.

  char *s A string to fill in with the information.

  int n The number of bytes to read.
  ++++++++++++++++++++++++++++++++++++++*/

int HTTP_ReadBody(char *s,int n)
{
 return(read_data_or_timeout(server,s,n));
}


/*++++++++++++++++++++++++++++++++++++++
  Close a connection opened using HTTP.

  int HTTP_Close Return 0 on success, -1 on error.
  ++++++++++++++++++++++++++++++++++++++*/

int HTTP_Close(void)
{
#if USE_ZLIB
 finish_zlib_buffer(server);
#endif

 return(CloseSocket(server));
}
