W               [ \t\r\n]
F               [-a-z0-9$_.!*(),%;/?:@&=+~|#]
K               [a-z0-9-]

%x DOCTYPE
%x COMMENT COMMENT_BAD
%x TAG_START TAG TAG_ATTR_KEY TAG_ATTR_VAL
%x DQUOTED SQUOTED

%{
/***************************************
  $Header: /home/amb/wwwoffle/RCS/htmlmodify.l 1.22 2001/01/20 14:12:08 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.6a.
  Parse the HTML and modify the source.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99,2000,01 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>

#include "wwwoffle.h"
#include "document.h"
#include "config.h"
#include "misc.h"


/* Parser outputs */

#define LEX_PLAINTEXT  1
#define LEX_COMMENT    2
#define LEX_DOCTYPE    3

#define LEX_TAG_BEGIN  4
#define LEX_TAG_END    5

#define LEX_ATTR_KEY   6
#define LEX_ATTR_VAL   7

/* Tag types */

typedef enum _HTMLTags
{
 tag_a         = 0  /* "a"         */ ,
 tag__a        = 1  /* "/a"        */ ,
 tag_base      = 2  /* "base"      */ ,
 tag_blink     = 3  /* "blink"     */ ,
 tag__blink    = 4  /* "/blink"    */ ,
 tag__body     = 5  /* "/body"     */ ,
 tag__html     = 6  /* "/html"     */ ,
 tag_meta      = 7  /* "meta"      */ ,
 tag_noscript  = 8  /* "noscript"  */ ,
 tag__noscript = 9  /* "/noscript" */ ,
 tag_script    =10  /* "script"    */ ,
 tag__script   =11  /* "/script"   */ ,
 tag_ntags     =12
}
HTMLTags;

/* Tag strings */

static char *tags[]=
{
 /* tag_a         = 0  */  "a"         ,
 /* tag__a        = 1  */  "/a"        ,
 /* tag_base      = 2  */  "base"      ,
 /* tag_blink     = 3  */  "blink"     ,
 /* tag__blink    = 4  */  "/blink"    ,
 /* tag__body     = 5  */  "/body"     ,
 /* tag__html     = 6  */  "/html"     ,
 /* tag_meta      = 7  */  "meta"      ,
 /* tag_noscript  = 8  */  "noscript"  ,
 /* tag__noscript = 9  */  "/noscript" ,
 /* tag_script    =10  */  "script"    ,
 /* tag__script   =11  */  "/script"   ,
};

/* Attribute types */

typedef enum _HTMLAttributes
{
 att_content     = 0  /* "content"     */ ,
 att_href        = 1  /* "href"        */ ,
 att_http_equiv  = 2  /* "http-equiv"  */ ,
 att_onblur      = 3  /* "onblur"      */ ,
 att_onchange    = 4  /* "onchange"    */ ,
 att_onclick     = 5  /* "onclick"     */ ,
 att_ondblclick  = 6  /* "ondblclick"  */ ,
 att_onfocus     = 7  /* "onfocus"     */ ,
 att_onkeydown   = 8  /* "onkeydown"   */ ,
 att_onkeypress  = 9  /* "onkeypress"  */ ,
 att_onload      =10  /* "onload"      */ ,
 att_onmousedown =11  /* "onmousedown" */ ,
 att_onmousemove =12  /* "onmousemove" */ ,
 att_onmouseout  =13  /* "onmouseout"  */ ,
 att_onmouseover =14  /* "onmouseover" */ ,
 att_onmouseup   =15  /* "onmouseup"   */ ,
 att_onreset     =16  /* "onreset"     */ ,
 att_onselect    =17  /* "onselect"    */ ,
 att_onsubmit    =18  /* "onsubmit"    */ ,
 att_onunload    =19  /* "onunload"    */ ,
 att_natts       =20
}
HTMLAttributes;

/* Attribute strings. */

static char *attributes[]=
{
 /* att_content     = 0 */ "content"     ,
 /* att_href        = 1 */ "href"        ,
 /* att_http_equiv  = 2 */ "http-equiv"  ,
 /* att_onblur      = 3 */ "onblur"      ,
 /* att_onchange    = 4 */ "onchange"    ,
 /* att_onclick     = 5 */ "onclick"     ,
 /* att_ondblclick  = 6 */ "ondblclick"  ,
 /* att_onfocus     = 7 */ "onfocus"     ,
 /* att_onkeydown   = 8 */ "onkeydown"   ,
 /* att_onkeypress  = 9 */ "onkeypress"  ,
 /* att_onload      =10 */ "onload"      ,
 /* att_onmousedown =11 */ "onmousedown" ,
 /* att_onmousemove =12 */ "onmousemove" ,
 /* att_onmouseout  =13 */ "onmouseout"  ,
 /* att_onmouseover =14 */ "onmouseover" ,
 /* att_onmouseup   =15 */ "onmouseup"   ,
 /* att_onreset     =16 */ "onreset"     ,
 /* att_onselect    =17 */ "onselect"    ,
 /* att_onsubmit    =18 */ "onsubmit"    ,
 /* att_onunload    =19 */ "onunload"
};

/* Ideas taken from the public domain Demoroniser perl script */

/*************************************************/
/* De-moron-ise Text from Microsoft Applications */
/*         by John Walker -- January 1998        */
/*            http://www.fourmilab.ch/           */
/*************************************************/

/* Microsoft Character mapping */

static int demoronise_ms_chars;

static char *demoronise_ms_chars_list[]={/* 0x80 */ "\200",
                                         /* 0x81 */ "\201",
                                         /* 0x82 */ ",",
                                         /* 0x83 */ "<em>f</em>",
                                         /* 0x84 */ ",,",
                                         /* 0x85 */ "...",
                                         /* 0x86 */ "\206",
                                         /* 0x87 */ "\207",
                                         /* 0x88 */ "^",
                                         /* 0x89 */ " /",
                                         /* 0x8A */ "\212",
                                         /* 0x8B */ "<",
                                         /* 0x8C */ "Oe",
                                         /* 0x8D */ "\215",
                                         /* 0x8E */ "\216",
                                         /* 0x8F */ "\217",
                                         /* 0x90 */ "\220",
                                         /* 0x91 */ "`",
                                         /* 0x92 */ "'",
                                         /* 0x93 */ "\"",
                                         /* 0x94 */ "\"",
                                         /* 0x95 */ "*",
                                         /* 0x96 */ "-",
                                         /* 0x97 */ "--",
                                         /* 0x98 */ "<sup>~</sup>",
                                         /* 0x99 */ "<sup>TM</sup>",
                                         /* 0x9A */ "\232",
                                         /* 0x9B */ ">",
                                         /* 0x9C */ "oe",
                                         /* 0x9D */ "\235",
                                         /* 0x9E */ "\236",
                                         /* 0x9F */ "\237"};

/* Definitions of why the output is disabled. */

#define DISABLE_NONE   0
#define DISABLE_SCRIPT 1
#define DISABLE_BLINK  2
#define DISABLE_META   3

static void modify_html(URL *Url);

static char *htmlmodify_yylval=NULL;
extern int htmlmodify_yylex(void);

/*+ The file descriptor to output to. +*/
static int output_fd=-1;

/*+ The add-cache-info optional footer. +*/
static char *cache_info=NULL;

/*+ The file descriptor that we are reading from. +*/
static int htmlmodify_yyfd=-1;

/*+ The base URL of this page. +*/
static URL *baseUrl=NULL;

/*+ The quote character used. +*/
static char *quote="";

/*+ Set this to disable the output. +*/
static int disable_output=DISABLE_NONE;


/*++++++++++++++++++++++++++++++++++++++
  Output the file with the modificatons if it is HTML, else just output.

  int client The file to write to.

  int spool The file to read from.

  URL *Url The URL that we are parsing.
  ++++++++++++++++++++++++++++++++++++++*/

void OutputHTMLWithModifications(int client,int spool,URL *Url)
{
 static int first=1;

 if(ConfigBooleanURL(AddCacheInfo,Url))
   {
    struct stat buf;
    time_t t_ago;
    char *date,*timeunit,timeago[8];

    fstat(spool,&buf);

    t_ago=time(NULL)-buf.st_mtime;
    date=RFC822Date(buf.st_mtime,0);
    
    if(t_ago<0)
      {strcpy(timeago,"?");timeunit="";}
    else if(t_ago<3600)
      {sprintf(timeago,"%ld",t_ago/60);timeunit="m";}
    else if(t_ago<(24*3600))
      {sprintf(timeago,"%ld",t_ago/3600);timeunit="h";}
    else if(t_ago<(14*24*3600))
      {sprintf(timeago,"%ld",t_ago/(24*3600));timeunit="d";}
    else if(t_ago<(30*24*3600))
      {sprintf(timeago,"%ld",t_ago/(7*24*3600));timeunit="w";}
    else
      {sprintf(timeago,"%ld",t_ago/(30*24*3600));timeunit="M";}

    cache_info=HTMLMessageBody(-1,"AddCacheInfo",
                               "url",Url->name,
                               "date",date,
                               "time",timeago,
                               "unit",timeunit,
                               NULL);
   }

 baseUrl=Url;

 output_fd=client;
 htmlmodify_yyfd=spool;
 if(!first)
    htmlmodify_yyrestart(NULL);

 modify_html(Url);

 if(cache_info)
    free(cache_info);
 cache_info=NULL;

 first=0;
}


/*+ A macro to output the data if valid to do so. +*/
#define YY_OUTPUT(text) \
           if(!disable_output) \
              write_string(output_fd,text)

/*++++++++++++++++++++++++++++++++++++++
  Modify the HTML looking for all of the things to be changed.

  URL *Url The URL that this page comes from.
  ++++++++++++++++++++++++++++++++++++++*/

static void modify_html(URL *Url)
{
 HTMLTags tag=tag_ntags;
 HTMLAttributes key=att_natts;
 int url_cached=0;
 int yychar;
 int disable_key_val;
 char *key_string=NULL;
 int meta_http_equiv_refresh=0;
 char *meta_string=NULL;

 char *anchor_modify_begin[3];
 char *anchor_modify_end[3];
 int disable_html_script=ConfigBooleanURL(DisableHTMLScript,Url);
 int disable_html_blink=ConfigBooleanURL(DisableHTMLBlink,Url);
 int disable_html_metarefresh=ConfigBooleanURL(DisableHTMLMetaRefresh,Url);
 int disable_html_metarefresh_self=ConfigBooleanURL(DisableHTMLMetaRefreshSelf,Url);

 demoronise_ms_chars=ConfigBooleanURL(DemoroniseMSChars,Url);

 anchor_modify_begin[0]=ConfigStringURL(AnchorModifyBegin[0],Url);
 anchor_modify_begin[1]=ConfigStringURL(AnchorModifyBegin[1],Url);
 anchor_modify_begin[2]=ConfigStringURL(AnchorModifyBegin[2],Url);
 anchor_modify_end[0]=ConfigStringURL(AnchorModifyEnd[0],Url);
 anchor_modify_end[1]=ConfigStringURL(AnchorModifyEnd[1],Url);
 anchor_modify_end[2]=ConfigStringURL(AnchorModifyEnd[2],Url);

 /* The actual parser. */

 while((yychar=htmlmodify_yylex()))
    switch(yychar)
      {
      case LEX_PLAINTEXT:
       break;

      case LEX_COMMENT:
       break;

      case LEX_DOCTYPE:
       break;

      case LEX_TAG_BEGIN:
       for(tag=0;tag<tag_ntags;tag++)
          if(!strcasecmp(htmlmodify_yylval,tags[tag]))
             break;

       if(tag==tag__a)
         {
          if(url_cached==1)
            {if(anchor_modify_end[0]) YY_OUTPUT(anchor_modify_end[0]);}
          else if(url_cached==2)
            {if(anchor_modify_end[1]) YY_OUTPUT(anchor_modify_end[1]);}
          else if(url_cached==-1)
            {if(anchor_modify_end[2]) YY_OUTPUT(anchor_modify_end[2]);}
          url_cached=0;
         }
       else if(tag==tag__body && cache_info)
         {YY_OUTPUT(cache_info); free(cache_info); cache_info=NULL;}
       else if(tag==tag__html && cache_info)
         {YY_OUTPUT(cache_info); free(cache_info); cache_info=NULL;}
       else if((tag==tag_blink || tag==tag__blink) && disable_html_blink)
          disable_output|=DISABLE_BLINK;
       else if(tag==tag_script && disable_html_script)
          disable_output|=DISABLE_SCRIPT;
       else if((tag==tag_noscript || tag==tag__noscript) && disable_html_script)
         disable_output|=DISABLE_SCRIPT;
       else if(tag==tag_meta && (disable_html_metarefresh_self || disable_html_metarefresh))
         {
          disable_output|=DISABLE_META;
          meta_string=(char*)malloc(strlen(htmlmodify_yylval)+1);
          strcpy(meta_string,htmlmodify_yylval);
         }

       YY_OUTPUT("<");
       YY_OUTPUT(htmlmodify_yylval);
       break;

      case LEX_TAG_END:
       if(tag==tag_meta && (disable_html_metarefresh_self || disable_html_metarefresh))
         {
          disable_output&=~DISABLE_META;

          YY_OUTPUT("<");

          if(meta_http_equiv_refresh==2)
             YY_OUTPUT("!-- WWWOFFLE (disable-meta-refresh) ");

          if(meta_string)
            {
             YY_OUTPUT(meta_string);
             free(meta_string);
             meta_string=NULL;
            }

          if(meta_http_equiv_refresh==2)
             YY_OUTPUT(" --");

          meta_http_equiv_refresh=0;
         }

       YY_OUTPUT(">");

       if(tag==tag_a)
         {
          if(url_cached==1)
            {if(anchor_modify_begin[0]) YY_OUTPUT(anchor_modify_begin[0]);}
          else if(url_cached==2)
            {if(anchor_modify_begin[1]) YY_OUTPUT(anchor_modify_begin[1]);}
          else if(url_cached==-1)
            {if(anchor_modify_begin[2]) YY_OUTPUT(anchor_modify_begin[2]);}
         }
       else if((tag==tag_blink || tag==tag__blink) && disable_html_blink)
          disable_output&=~DISABLE_BLINK;
       else if(tag==tag__script && disable_html_script)
          disable_output&=~DISABLE_SCRIPT;
       else if((tag==tag_noscript || tag==tag__noscript) && disable_html_script)
          disable_output&=~DISABLE_SCRIPT;

       tag=tag_ntags;
       key=att_natts;
       break;

      case LEX_ATTR_KEY:
       key_string=(char*)realloc((void*)key_string,strlen(htmlmodify_yylval)+1);
       strcpy(key_string,htmlmodify_yylval);

       for(key=0;key<att_natts;key++)
          if(!strcasecmp(htmlmodify_yylval,attributes[key]))
             break;
      break;

      case LEX_ATTR_VAL:
       disable_key_val=0;

       /* Links */

       if(key==att_href && tag==tag_a && htmlmodify_yylval && *htmlmodify_yylval)
         {
          char *link=NULL,*p,oldp=0;
          URL *Url=NULL;

          for(p=htmlmodify_yylval;*p;p++)
             if(*p=='#')
               {
                oldp=*p;
                *p=0;
                break;
               }

          if(*htmlmodify_yylval)
            {
             link=LinkURL(baseUrl,htmlmodify_yylval);
             Url=SplitURL(link);
            }

          if(!Url || !Url->Protocol)
             url_cached=0;
          else if(ExistsWebpageSpoolFile(Url) || IsLocalNetHost(Url->host))
             url_cached=1;
          else if(ExistsOutgoingSpoolFile(Url))
             url_cached=2;
          else
             url_cached=-1;

          if(link!=htmlmodify_yylval)
             free(link);
          if(Url)
             FreeURL(Url);

          *p=oldp;
         }

       /* Base tag */

       else if(key==att_href && htmlmodify_yylval && tag==tag_base)
          baseUrl=SplitURL(htmlmodify_yylval);

       /* Script events */

       else if(disable_html_script &&
               (key==att_onblur || key==att_onchange || key==att_onclick || key==att_ondblclick || key==att_onfocus ||
                key==att_onkeydown || key==att_onkeypress || key==att_onload || key==att_onmousedown ||
                key==att_onmousemove || key==att_onmouseout || key==att_onmouseover || key==att_onmouseup ||
                key==att_onreset || key==att_onselect || key==att_onsubmit || key==att_onunload))
          disable_key_val=1;

       /* Meta tag */

       else if((disable_html_metarefresh_self || disable_html_metarefresh) && tag==tag_meta)
         {
          if(htmlmodify_yylval)
            {
             meta_string=(char*)realloc((void*)meta_string,strlen(meta_string)+strlen(key_string)+strlen(htmlmodify_yylval)+8);
             sprintf(meta_string+strlen(meta_string)," %s=%s%s%s",key_string,quote,htmlmodify_yylval,quote);
            }
          else
            {
             meta_string=(char*)realloc((void*)meta_string,strlen(meta_string)+strlen(key_string)+4);
             sprintf(meta_string+strlen(meta_string)," %s",key_string);
            }

          if(key==att_http_equiv && htmlmodify_yylval && !strncasecmp(htmlmodify_yylval,"Refresh",7))
             meta_http_equiv_refresh++;
          else if(key==att_content && disable_html_metarefresh)
             meta_http_equiv_refresh++;
          else if(key==att_content && htmlmodify_yylval && disable_html_metarefresh_self)
            {
             char *p;

             /* ' *[0-9].?[0-9]* *[;,] *(URL *= *|)http://...' */

             p=htmlmodify_yylval;
             while(isspace(*p)) p++;
             if(!isdigit(*p))
                ; /* unparseable */
             else
               {
                while(isdigit(*p)) p++;
                if(*p=='.')
                  {p++; while(isdigit(*p)) p++;}
                while(isspace(*p)) p++;
                if(!*p)
                   meta_http_equiv_refresh++; /* just a number, invalid, but refers to self. */
                else if(*p!=';' && *p!=',')
                   ; /* unparseable */
                else
                  {
                   p++;
                   while(isspace(*p)) p++;
                   if(!strncasecmp(p,"URL",3))
                     {
                      p+=3;
                      while(isspace(*p)) p++;
                      if(*p!='=')
                         ; /* unparseable */
                      else
                        {
                         p++;
                         while(isspace(*p)) p++;
                        }
                     }
                   if(!*p)
                      ; /* unparseable */
                   else
                     {
                      char *link=LinkURL(baseUrl,p);
                      URL* linkUrl=SplitURL(link);

                      if(!strcmp(baseUrl->name,linkUrl->name))
                         meta_http_equiv_refresh++;

                      free(link);
                      FreeURL(linkUrl);
                     }
                  }
               }
            }
         }

       if(!disable_key_val)
         {
          YY_OUTPUT(key_string);
          if(htmlmodify_yylval)
            {
             YY_OUTPUT("=");
             if(*quote)
                YY_OUTPUT(quote);
             YY_OUTPUT(htmlmodify_yylval);
             if(*quote)
                YY_OUTPUT(quote);
            }
         }

       key=att_natts;
       break;

      default:
      }

 if(cache_info)
   {YY_OUTPUT(cache_info); free(cache_info); cache_info=NULL;}

 if(key_string)
    free(key_string);
}


#ifndef htmlmodify_yywrap
/*+ Needed in lex but does nothing. +*/
#define htmlmodify_yywrap() 1
#endif

/*+ Reset the current string. +*/
#define reset_string \
 *string=0; \
 stringused=0;

/*+ append information to the current string. +*/
#define append_string(xx) \
 newlen=strlen(xx); \
 if((stringused+newlen)>=stringlen) \
    string=(char*)realloc((void*)string,stringlen=(stringused+newlen+1)); \
 strcpy(string+stringused,xx); \
 stringused+=newlen;

/*+ A macro to read data that can be used by the lexer. +*/
#define YY_INPUT(buf,result,max_size) \
        if((result=read_data(htmlmodify_yyfd,buf,max_size))==-1) \
           result=0;

%}

%%
 char *string=malloc(128);
 int stringlen=128,stringused=0,newlen;

 /* Handle comments and other tags */

[\200-\237]                 { YY_OUTPUT(demoronise_ms_chars?demoronise_ms_chars_list[*(unsigned char*)htmlmodify_yytext-0x80]:htmlmodify_yytext); }
[^<\200-\237]+              { YY_OUTPUT(htmlmodify_yytext); /* htmlmodify_yylval=htmlmodify_yytext; return(LEX_PLAINTEXT); */ }
"<!DOCTYPE"                 { YY_OUTPUT(htmlmodify_yytext); BEGIN(DOCTYPE); reset_string; }
"<!--"                      { YY_OUTPUT(htmlmodify_yytext); BEGIN(COMMENT); reset_string; }
"<!"{W}*"-"*                { YY_OUTPUT(htmlmodify_yytext); BEGIN(COMMENT_BAD); reset_string; }
"<"{W}*                     { BEGIN(TAG_START); reset_string; append_string(htmlmodify_yytext); }

 /* Doctype (DTD) */

<DOCTYPE>">"                { YY_OUTPUT(htmlmodify_yytext); BEGIN(INITIAL); /* htmlmodify_yylval=string; return(LEX_DOCTYPE); */ }
<DOCTYPE>[^>]+              { YY_OUTPUT(htmlmodify_yytext); /* append_string(htmlmodify_yytext); */ }

 /* Comments - COMMENT_BAD is not a legal comment format (except <!>) but people use it as one.
               COMMENT is not strictly correct, but works better than the real thing. */

<COMMENT>"--"{W}*">"        { YY_OUTPUT(htmlmodify_yytext); BEGIN(INITIAL); /* htmlmodify_yylval=string; return(LEX_COMMENT); */ }
<COMMENT>">"                { YY_OUTPUT(htmlmodify_yytext); /* append_string(htmlmodify_yytext); */ }
<COMMENT>"-"                { YY_OUTPUT(htmlmodify_yytext); /* append_string(htmlmodify_yytext); */ }
<COMMENT>[^->]+             { YY_OUTPUT(htmlmodify_yytext); /* append_string(htmlmodify_yytext); */ }

<COMMENT_BAD>">"            { YY_OUTPUT(htmlmodify_yytext); BEGIN(INITIAL); /* htmlmodify_yylval=string; return(LEX_COMMENT); */ }
<COMMENT_BAD>[^>]+          { YY_OUTPUT(htmlmodify_yytext); /* append_string(htmlmodify_yytext); */ }

 /* Tags */

<TAG_START>"/"?{K}+/" "     { BEGIN(TAG); htmlmodify_yylval=htmlmodify_yytext; return(LEX_TAG_BEGIN); }
<TAG_START>"/"?{K}+/\t      { BEGIN(TAG); htmlmodify_yylval=htmlmodify_yytext; return(LEX_TAG_BEGIN); }
<TAG_START>"/"?{K}+/\n      { BEGIN(TAG); htmlmodify_yylval=htmlmodify_yytext; return(LEX_TAG_BEGIN); }
<TAG_START>"/"?{K}+/\r      { BEGIN(TAG); htmlmodify_yylval=htmlmodify_yytext; return(LEX_TAG_BEGIN); }
<TAG_START>"/"?{K}+/">"     { BEGIN(TAG); htmlmodify_yylval=htmlmodify_yytext; return(LEX_TAG_BEGIN); }
<TAG_START>(.|\n)           { BEGIN(INITIAL); YY_OUTPUT(string); YY_OUTPUT(htmlmodify_yytext); }

<TAG>">"                    { BEGIN(INITIAL); htmlmodify_yylval=""; return(LEX_TAG_END); }
<TAG>"<"                    { BEGIN(INITIAL); unput(htmlmodify_yytext[0]); htmlmodify_yylval=""; return(LEX_TAG_END); }
<TAG>{K}+                   { BEGIN(TAG_ATTR_KEY); htmlmodify_yylval=htmlmodify_yytext; return(LEX_ATTR_KEY); }
<TAG>(.|\n)                 { YY_OUTPUT(htmlmodify_yytext); }

<TAG_ATTR_KEY>{W}*=         { BEGIN(TAG_ATTR_VAL); }
<TAG_ATTR_KEY>(.|\n)        { BEGIN(TAG); unput(htmlmodify_yytext[0]); htmlmodify_yylval=NULL; return(LEX_ATTR_VAL); }

<TAG_ATTR_VAL>\"            { BEGIN(DQUOTED); reset_string; }
<TAG_ATTR_VAL>\'            { BEGIN(SQUOTED); reset_string; }
<TAG_ATTR_VAL>{W}+          { }
<TAG_ATTR_VAL>{F}+          { BEGIN(TAG); htmlmodify_yylval=htmlmodify_yytext; quote=""; return(LEX_ATTR_VAL); }
<TAG_ATTR_VAL>(.|\n)        { BEGIN(TAG); unput(htmlmodify_yytext[0]); htmlmodify_yylval=""; quote=""; return(LEX_ATTR_VAL); }

 /* Quoted strings */

<DQUOTED>\\\"               { append_string(htmlmodify_yytext); }
<DQUOTED>\\                 { append_string(htmlmodify_yytext); }
<DQUOTED>\"                 { BEGIN(TAG); htmlmodify_yylval=string; quote="\""; return(LEX_ATTR_VAL); }
<DQUOTED>(\r|\n)+           { }
<DQUOTED>[^\\\"\r\n]+       { append_string(htmlmodify_yytext); }

<SQUOTED>\\\'               { append_string(htmlmodify_yytext); }
<SQUOTED>\\                 { append_string(htmlmodify_yytext); }
<SQUOTED>\'                 { BEGIN(TAG); htmlmodify_yylval=string; quote="'"; return(LEX_ATTR_VAL); }
<SQUOTED>(\r|\n)+           { }
<SQUOTED>[^\\\'\r\n]+       { append_string(htmlmodify_yytext); }

 /* End of file */

<<EOF>>                     { free(string); BEGIN(INITIAL); return(0); }
%%
