/***************************************
  $Header: /home/amb/wwwoffle/RCS/wwwoffle.h 2.65 1999/10/10 10:32:45 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.5a.
  A header file for all of the programs wwwoffle, wwwoffled.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97,98,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef WWWOFFLE_H
#define WWWOFFLE_H    /*+ To stop multiple inclusions. +*/


/* ------------------------------------------------------------
   The values in the section below can be changed if required, see INSTALL. */

/*+ The default port number to use for the http proxy demon. +*/
#define DEF_HTTP_PORT 8080

/*+ The default port number to use for the wwwoffle control. +*/
#define DEF_WWWOFFLE_PORT 8081

/*+ The default spool directory. +*/
#define DEF_SPOOL "/var/spool/wwwoffle"

/*+ The default configuration file directory. +*/
#define DEF_CONF "/var/spool/wwwoffle"

/*+ The absolute maximum number of servers to fork in total. +*/
#define MAX_SERVERS 64
/*+ The default total number of servers to fork. +*/
#define DEF_MAX_SERVERS 8

/*+ The absolute maximum number of servers to fork for fetching previously requested pages. +*/
#define MAX_FETCH_SERVERS 48
/*+ The default number of servers to fork for fetching pages. +*/
#define DEF_MAX_FETCH_SERVERS 4

/*+ The number of pretime directories to create (lasttime history). +*/
#define NUM_PREVTIME_DIR 3
/* If this is changed then to see the links to them you will need to edit
   /var/spool/wwwoffle/html/messages/IndexLastTime-Tail.html. */

/*+ The size of the buffer to use when reading from the cache or a socket. +*/
#define READ_BUFFER_SIZE 1024

/*+ The default permission for creating directories. +*/
#define DEF_DIR_PERM  0755
/*+ The default permission for creating files. +*/
#define DEF_FILE_PERM 0644

/* The values in the section above can be changed if required, see INSTALL.
   ------------------------------------------------------------ */

#include <time.h>

#include "misc.h"

/* In connect.c */

void CommandConnect(int client);
void ForkServer(int client,int browser);

/* In purge.c */

void PurgeCache(int fd);

/* In spool.c */

int OpenOutgoingSpoolFile(int rw);
void CloseOutgoingSpoolFile(int fd,URL *Url);
int ExistsOutgoingSpoolFile(URL *Url);
char *HashOutgoingSpoolFile(URL *Url);
char *DeleteOutgoingSpoolFile(URL *Url);

int OpenWebpageSpoolFile(int rw,URL *Url);
char *DeleteWebpageSpoolFile(URL *Url,int all);
void TouchWebpageSpoolFile(URL *Url,time_t when);
time_t ExistsWebpageSpoolFile(URL *Url);

void CreateBackupWebpageSpoolFile(URL *Url);
void RestoreBackupWebpageSpoolFile(URL *Url);
void DeleteBackupWebpageSpoolFile(URL *Url);

void CreateLockWebpageSpoolFile(URL *Url);
void DeleteLockWebpageSpoolFile(URL *Url);
int ExistsLockWebpageSpoolFile(URL *Url);

int CreateLastTimeSpoolFile(URL *Url);
char *DeleteLastTimeSpoolFile(URL *Url);
int ExistsLastTimeSpoolFile(URL *Url);
void CycleLastTimeSpoolFile(void);

int CreateMonitorSpoolFile(URL *Url,char MofY[13],char DofM[32],char DofW[8],char HofD[25]);
long ReadMonitorTimesSpoolFile(URL *Url,char MofY[13],char DofM[32],char DofW[8],char HofD[25]);
char *DeleteMonitorSpoolFile(URL *Url);

int CreateTempSpoolFile(void);
void CloseTempSpoolFile(int fd);

char *FileNameToURL(char *file);
char *URLToFileName(URL *Url);

/* In parse.c */

char *ParseRequest(int fd,Header **request_head,Body **request_body);

int RequestChanges(int fd,Header *request_head);
char *MovedLocation(URL *Url,Header *reply_head);
Header *RequestURL(URL *Url,char *referer);

void ModifyRequest(URL *Url,Header *request_head);

void MakeRequestAuthorised(char *proxy,Header *request_head);
void MakeRequestNonProxy(Header *request_head);

int ParseReply(int fd,URL *Url,Header **reply_head);

int SpooledPageStatus(URL *Url);

void ModifyReply(Header *reply_head);

Header *CreateHeader(char *top,int type);
void AddToHeader(Header *head,char *key,char *val);
void RemoveFromHeader(Header *head,char* key,char *val);
char *GetHeader(Header *head,char* key,char *val);
char *HeaderString(Header *head);
void FreeHeader(Header *head);

Body *CreateBody(int length);
void FreeBody(Body *body);

/* In messages.c (messages.l) */

void LocalPage(int fd,char *path,Header *request_head);
char *HTMLMessage(int fd,int status_val,char *status_str,char *location,char *template, ...);
char *HTMLMessageHead(int fd,int status_val,char *status_str, ...);
char *HTMLMessageBody(int fd,char *template, ...);

/* In index.c */

void IndexPage(int fd,URL *Url);

/* In control.c */

void ControlPage(int fd,URL *Url,Header *request_head,Body *request_body);

/* In configedit.c */

void ConfigEditPage(int fd,char *args,Body *request_body);

/* In refresh.c */

char *RefreshPage(int fd,URL *Url,Body *request_body,int *recurse);
void ParseRecurseOptions(char *method);
int RecurseFetch(URL *Url,int new);
int RecurseFetchRelocation(URL *Url,char *location);
char *CreateRefreshPath(int recursive_depth,int recursive_mode,int force,
                        int stylesheets,int images,int frames,int scripts,int objects);
int RefreshForced(void);

/* In monitor.c */

void MonitorPage(int fd,URL *Url,Body *request_body);
void RequestMonitoredPages(void);
void MonitorTimes(URL *Url,int *last,int *next);

/* In wwwoffles.c */

int wwwoffles(int online,int browser,int client);

/* In htdig.c */

void HTDigPage(int fd,URL *Url,Header *head);

#endif /* WWWOFFLE_H */
