/***************************************
  $Header: /home/amb/wwwoffle/RCS/upgrade-cache.c 1.4 1998/11/30 20:20:40 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.4.
  Upgrade the cache for version 2.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <time.h>
#include <utime.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "misc.h"
#include "errors.h"
#include "config.h"


#define PATH_SEP '%'


char *URLToFileName(URL *Url);


int main(int argc,char** argv)
{
 DIR *dir;
 struct dirent* ent;
 struct stat buf;
 int rootp;

 /* Initialise */

 if(argc!=2)
   {fprintf(stderr,"Usage: upgrade-cache <spool-dir>\n");exit(0);}

 InitErrorHandler("upgrade-cache",0,1);

 rootp=!geteuid();

 /* Change to the spool directory. */

 if(chdir(argv[1]))
    PrintMessage(Fatal,"Cannot change to the spool directory [%!s]; upgrade failed.");

 /* Create the new http spool directory. */

 if(stat(".",&buf))
    PrintMessage(Fatal,"Cannot stat spool directory [%!s] not upgraded.");

 if(mkdir("http",buf.st_mode&07777))
    if(errno==EEXIST)
       PrintMessage(Warning,"The 'http' spool directory already exists.");
    else
       PrintMessage(Fatal,"Cannot create 'http' spool directory [%!s]; upgrade failed.");
 if(rootp && chown("http",buf.st_uid,buf.st_gid))
    PrintMessage(Important,"Cannot change owner of 'http' spool directory [%!s]; check it.");

 /* Open the spool directory. */

 dir=opendir(".");
 if(!dir)
    PrintMessage(Fatal,"Cannot open spool directory [%!s]; upgrade failed.");

 ent=readdir(dir);  /* skip .  */
 if(!ent)
    PrintMessage(Fatal,"Cannot read spool directory [%!s]; upgrade failed.");
 ent=readdir(dir);  /* skip .. */

 /* Go through each entry. */

 while((ent=readdir(dir)))
   {
    if(lstat(ent->d_name,&buf))
       PrintMessage(Warning,"Cannot stat file '%s' [%!s] not upgraded.",ent->d_name);
    else if(S_ISLNK(buf.st_mode))
      {
       char link[257];
       struct stat buf2;
       int n;

       n=readlink(ent->d_name,link,256);
       if(n==-1)
         {PrintMessage(Warning,"Cannot readlink file '%s' [%!s] not upgraded.",ent->d_name);continue;}
       link[n]=0;
       if(stat(link,&buf2))
         {PrintMessage(Warning,"Cannot stat file '%s'->'%s' [%!s] not upgraded.",ent->d_name,link);continue;}
       else if(S_ISDIR(buf2.st_mode))
         {
          char *new_name=(char*)malloc(strlen(ent->d_name)+8);

          PrintMessage(Inform,"Processing link '%s'",ent->d_name);

          strcpy(new_name,"http/");
          strcat(new_name,ent->d_name);
          if(rename(ent->d_name,new_name))
             PrintMessage(Warning,"Cannot rename '%s' to '%s' [%!s] not upgraded.",ent->d_name,new_name);
          free(new_name);
         }
      }
    else if(S_ISDIR(buf.st_mode) && !strcmp(ent->d_name,"outgoing"))
      {
       DIR *dir2;
       struct dirent* ent2;

       PrintMessage(Inform,"Processing outgoing directory.");

       if(chdir(ent->d_name))
         {PrintMessage(Warning,"Cannot change to outgoing directory [%!s]; not upgraded.");continue;}

       dir2=opendir(".");
       if(!dir2)
         {PrintMessage(Warning,"Cannot open outgoing directory [%!s]; not upgraded.");chdir("..");continue;}

       ent2=readdir(dir2);  /* skip .  */
       if(!ent2)
         {PrintMessage(Warning,"Cannot read outgoing directory [%!s]; not upgraded.");closedir(dir2);chdir("..");continue;}
       ent2=readdir(dir2);  /* skip .. */

       while((ent2=readdir(dir2)))
         {
          struct stat buf2;

          if(!isdigit(ent2->d_name[0]))
            {
             unlink(ent2->d_name);
             continue;
            }

          if(stat(ent2->d_name,&buf2))
             PrintMessage(Warning,"Cannot stat file 'outgoing/%s' [%!s]; not upgraded.",ent2->d_name);
          else if(S_ISREG(buf2.st_mode))
            {
             int ufd;
             char *url,*new_name2,*ptr;
             URL *Url;
             FILE *file;

             file=fopen(ent2->d_name,"r");
             ptr=fgets_realloc(NULL,file);
             url=(char*)malloc(strlen(ptr));
             sscanf(ptr,"%*s %s",url);
             free(ptr);
             fclose(file);

             Url=SplitURL(url);
             new_name2=URLToFileName(Url);

             *new_name2='O';
             if(rename(ent2->d_name,new_name2))
                PrintMessage(Warning,"Cannot rename outgoing request 'outgoing/%s' to 'outgoing/%s' [%!s] not upgraded.",ent2->d_name,new_name2);

             *new_name2='U';
             ufd=open(new_name2,O_WRONLY|O_CREAT|O_TRUNC,0644);

             if(ufd!=-1)
               {
                write_string(ufd,Url->name);
                close(ufd);
               }

             free(new_name2);
            }
         }

       closedir(dir2);
       chdir("..");
      }
    else if(S_ISDIR(buf.st_mode) && strcmp(ent->d_name,"http"))
      {
       DIR *dir2;
       struct dirent* ent2;
       struct utimbuf utbuf;
       char *new_name=(char*)malloc(strlen(ent->d_name)+8);
       char *url;
       URL *Url;

       PrintMessage(Inform,"Processing directory '%s'",ent->d_name);

       strcpy(new_name,"http/");
       strcat(new_name,ent->d_name);

       if(mkdir(new_name,buf.st_mode&07777))
         {PrintMessage(Warning,"Cannot create '%s' spool directory [%!s]; not upgraded.",new_name);continue;}
       if(rootp && chown(new_name,buf.st_uid,buf.st_gid))
          PrintMessage(Important,"Cannot change owner of '%s' spool directory [%!s]; check it.",new_name);

       if(chdir(ent->d_name))
         {PrintMessage(Warning,"Cannot change to directory '%s' [%!s]; not upgraded.",ent->d_name);continue;}

       dir2=opendir(".");
       if(!dir2)
         {PrintMessage(Warning,"Cannot open directory '%s' [%!s]; not upgraded.",ent->d_name);chdir("..");continue;}

       ent2=readdir(dir2);  /* skip .  */
       if(!ent2)
         {PrintMessage(Warning,"Cannot read directory '%s' [%!s]; not upgraded.",ent->d_name);closedir(dir2);chdir("..");continue;}
       ent2=readdir(dir2);  /* skip .. */

       while((ent2=readdir(dir2)))
         {
          struct stat buf2;

          if(ent2->d_name[0] && ent2->d_name[0]==PATH_SEP &&
             ent2->d_name[1] && ent2->d_name[1]==PATH_SEP)
             continue;

          if(stat(ent2->d_name,&buf2))
             PrintMessage(Warning,"Cannot stat file '%s/%s' [%!s]; not upgraded.",ent->d_name,ent2->d_name);
          else if(S_ISREG(buf2.st_mode))
            {
             char *path=(char*)malloc(strlen(ent2->d_name)+2),*ext,*args=NULL;
             char *new_name2,*new_file;

             if(*ent2->d_name==PATH_SEP)
                strcpy(path,ent2->d_name);
             else
               {
                *path='/';
                strcpy(path+1,ent2->d_name);
               }

             for(ext=path;*ext;ext++)
                if(*ext==PATH_SEP)
                   if(*(ext+1)==PATH_SEP && *(ext+2)!=PATH_SEP)
                      break;
                   else
                      *ext='/';

             if(*ext)
               {
                int r=0,rr;
                int afd=open(ext,O_RDONLY);

                if(afd==-1)
                  {PrintMessage(Warning,"Cannot open '%s/%s' to read arguments for '%s/%s' [%!s] not upgraded.",ent->d_name,ext,ent->d_name,ent2->d_name);continue;}

                args=(char*)malloc(256+1);

                while((rr=read(afd,&args[r],256)))
                  {
                   r+=rr;
                   args=(char*)realloc(args,r+256+1);
                  }

                args[r]=0;
                close(afd);

                if(unlink(ext))
                  {PrintMessage(Warning,"Cannot delete '%s/%s' [%!s] not upgraded.",ent->d_name,ent2->d_name);continue;}

                *ext=0;
               }

             url=(char*)malloc(strlen(ent->d_name)+strlen(path)+(args?strlen(args):0)+16);
             if(args)
                sprintf(url,"http://%s/%s?%s",ent->d_name,*path=='/'?path+1:path,args);
             else
                sprintf(url,"http://%s/%s",ent->d_name,*path=='/'?path+1:path);
             Url=SplitURL(url);

             new_file=URLToFileName(Url);
             *new_file='D';

             new_name2=(char*)malloc(strlen(ent->d_name)+strlen(new_file)+16);
             strcpy(new_name2,"../http/");
             strcat(new_name2,ent->d_name);
             strcat(new_name2,"/");
             strcat(new_name2,new_file);
             free(new_file);

             if(rename(ent2->d_name,new_name2))
               {PrintMessage(Warning,"Cannot rename '%s/%s' to '%s' [%!s] not upgraded.",ent->d_name,ent2->d_name,new_name2+3);continue;}
             else
               {
                int ufd;

                *(new_name2+9+strlen(ent->d_name))='U';
                ufd=open(new_name2,O_WRONLY|O_CREAT|O_TRUNC,0644);

                if(ufd!=-1)
                  {
                   write_string(ufd,Url->name);
                   close(ufd);
                  }
               }

             if(args)
                free(args);
             free(new_name2);

             FreeURL(Url);
             free(url);
            }
         }

       closedir(dir2);
       chdir("..");

       utbuf.actime=buf.st_atime;
       utbuf.modtime=buf.st_mtime;
       utime(new_name,&utbuf);

       if(rmdir(ent->d_name))
          PrintMessage(Warning,"Cannot unlink directory '%s' [%!s]; check it is empty.",ent->d_name);

       free(new_name);
      }
   }

 closedir(dir);

 return(0);
}


/*++++++++++++++++++++++++++++++++++++++
  Convert a URL to a filename

  char *URLToFileName Returns the filename.

  URL *Url The URL to convert to a filename.
  ++++++++++++++++++++++++++++++++++++++*/

char *URLToFileName(URL *Url)
{
 char *hash;
 char *file;

 hash=MakeHash(Url->name);

 file=(char*)malloc(strlen(hash)+2);

 sprintf(file,"X%s",hash);

 return(file);
}
