/***************************************
  $Header: /home/amb/wwwoffle/RCS/monitor.c 1.24 1999/02/06 17:31:09 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.4c.
  A header file for all of the programs wwwoffle, wwwoffled.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1998,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>

#include "wwwoffle.h"
#include "misc.h"
#include "config.h"
#include "errors.h"

/*+ Need this for Win32 to use binary mode +*/
#ifndef O_BINARY
#define O_BINARY 0
#endif

static void MonitorFormParse(int fd,char *request_body);


/*++++++++++++++++++++++++++++++++++++++
  Send to the client a page to allow monitoring using HTML.

  int fd The file descriptor of the client.

  URL *Url The URL that was used to request this page.

  char *request_body The body of the HTTP request.
  ++++++++++++++++++++++++++++++++++++++*/

void MonitorPage(int fd,URL *Url,char *request_body)
{
 if(!strcmp("/monitor-options/",Url->path))
   {
    char MofY[13],DofM[32],DofW[8],HofD[25];
    char dofmstr[128],hofdstr[64],*p;
    int i;
    URL *monUrl=NULL;

    if(Url->args && (monUrl=SplitURL(Url->args)))
       ReadMonitorTimesSpoolFile(monUrl,MofY,DofM,DofW,HofD);
    else
      {
       strcpy(MofY,"111111111111");
       strcpy(DofM,"1111111111111111111111111111111");
       strcpy(DofW,"1111111");
       strcpy(HofD,"100000000000000000000000");
      }

    if(!strcmp(DofM,"1111111111111111111111111111111"))
       strcpy(dofmstr,"");
    else
      {
       *dofmstr=0;
       p=dofmstr;
       for(i=0;i<31;i++)
          if(DofM[i]=='1')
            {
             sprintf(p,"%d ",i+1);
             p+=strlen(p);
            }
      }

    if(!strcmp(HofD,"100000000000000000000000"))
       strcpy(hofdstr,"");
    else
      {
       *hofdstr=0;
       p=hofdstr;
       for(i=0;i<24;i++)
          if(HofD[i]=='1')
            {
             sprintf(p,"%d ",i);
             p+=strlen(p);
            }
      }

    HTMLMessage(fd,200,"WWWOFFLE Monitor Page",NULL,"MonitorPage",
                "url",Url->args,
                "mofy1",MofY[0]=='1'?"Yes":NULL,
                "mofy2",MofY[1]=='1'?"Yes":NULL,
                "mofy3",MofY[2]=='1'?"Yes":NULL,
                "mofy4",MofY[3]=='1'?"Yes":NULL,
                "mofy5",MofY[4]=='1'?"Yes":NULL,
                "mofy6",MofY[5]=='1'?"Yes":NULL,
                "mofy7",MofY[6]=='1'?"Yes":NULL,
                "mofy8",MofY[7]=='1'?"Yes":NULL,
                "mofy9",MofY[8]=='1'?"Yes":NULL,
                "mofy10",MofY[9]=='1'?"Yes":NULL,
                "mofy11",MofY[10]=='1'?"Yes":NULL,
                "mofy12",MofY[11]=='1'?"Yes":NULL,
                "dofm",dofmstr,
                "dofw0",DofW[0]=='1'?"Yes":NULL,
                "dofw1",DofW[1]=='1'?"Yes":NULL,
                "dofw2",DofW[2]=='1'?"Yes":NULL,
                "dofw3",DofW[3]=='1'?"Yes":NULL,
                "dofw4",DofW[4]=='1'?"Yes":NULL,
                "dofw5",DofW[5]=='1'?"Yes":NULL,
                "dofw6",DofW[6]=='1'?"Yes":NULL,
                "hofd",hofdstr,
                NULL);
   }
 else if(!strcmp("/monitor-request/",Url->path))
    MonitorFormParse(fd,request_body);
 else
   {
    char *page=(char*)malloc(strlen(Url->path)+(Url->args?strlen(Url->args):0)+4);
    if(Url->args)
       sprintf(page,"%s?%s",Url->path,Url->args);
    else
       sprintf(page,"%s",Url->path);

    HTMLMessage(fd,404,"WWWOFFLE Illegal Monitor Page",NULL,"MonitorIllegal",
                "url",page,
                NULL);
    free(page);
   }
}


/*++++++++++++++++++++++++++++++++++++++
  Parse the reply from the form.

  int fd The file descriptor of the client.

  char *request_body The body of the HTTP request sent by the browser.
  ++++++++++++++++++++++++++++++++++++++*/

static void MonitorFormParse(int fd,char *request_body)
{
 int i,mfd=-1;
 char *copy,*url=NULL;
 URL *Url;
 char mofy[12]="NNNNNNNNNNNN",*dofm=NULL,dofw[7]="NNNNNNN",*hofd=NULL;
 char MofY[13],DofM[32],DofW[8],HofD[25];

 if(!request_body)
   {
    HTMLMessage(fd,404,"WWWOFFLE Monitor Form Error",NULL,"MonitorFormError",
                "body",NULL,
                NULL);
    return;
   }

 copy=(char*)malloc(strlen(request_body)+1);
 strcpy(copy,request_body);

 for(i=0;copy[i];i++)
   {
    if(i!=0 && copy[i-1]=='&')
       copy[i-1]=0;
    if(i==0 || copy[i-1]==0)
      {
       if(!strncmp("url=",&copy[i],4))
          url=&copy[i+4];
       if(!strncmp("mofy1=",&copy[i],6))
          mofy[0]=copy[i+6];
       if(!strncmp("mofy2=",&copy[i],6))
          mofy[1]=copy[i+6];
       if(!strncmp("mofy3=",&copy[i],6))
          mofy[2]=copy[i+6];
       if(!strncmp("mofy4=",&copy[i],6))
          mofy[3]=copy[i+6];
       if(!strncmp("mofy5=",&copy[i],6))
          mofy[4]=copy[i+6];
       if(!strncmp("mofy6=",&copy[i],6))
          mofy[5]=copy[i+6];
       if(!strncmp("mofy7=",&copy[i],6))
          mofy[6]=copy[i+6];
       if(!strncmp("mofy8=",&copy[i],6))
          mofy[7]=copy[i+6];
       if(!strncmp("mofy9=",&copy[i],6))
          mofy[8]=copy[i+6];
       if(!strncmp("mofy10=",&copy[i],7))
          mofy[9]=copy[i+7];
       if(!strncmp("mofy11=",&copy[i],7))
          mofy[10]=copy[i+7];
       if(!strncmp("mofy12=",&copy[i],7))
          mofy[11]=copy[i+7];
       if(!strncmp("dofm=",&copy[i],5))
          dofm=&copy[i+5];
       if(!strncmp("dofw0=",&copy[i],6))
          dofw[0]=copy[i+6];
       if(!strncmp("dofw1=",&copy[i],6))
          dofw[1]=copy[i+6];
       if(!strncmp("dofw2=",&copy[i],6))
          dofw[2]=copy[i+6];
       if(!strncmp("dofw3=",&copy[i],6))
          dofw[3]=copy[i+6];
       if(!strncmp("dofw4=",&copy[i],6))
          dofw[4]=copy[i+6];
       if(!strncmp("dofw5=",&copy[i],6))
          dofw[5]=copy[i+6];
       if(!strncmp("dofw6=",&copy[i],6))
          dofw[6]=copy[i+6];
       if(!strncmp("hofd=",&copy[i],5))
          hofd=&copy[i+5];
      }
   }

 if(url==NULL || *url==0)
   {
    HTMLMessage(fd,404,"WWWOFFLE Monitor Form Error",NULL,"MonitorFormError",
                "body",request_body,
                NULL);
    free(copy);
    return;
   }

 url=URLDecode(url,1);
 Url=SplitURL(url);

 /* Parse the requested time */

 strcpy(MofY,"000000000000");
 for(i=0;i<12;i++)
    if(mofy[i]=='Y')
       MofY[i]='1';

 if(!*dofm)
    strcpy(DofM,"1111111111111111111111111111111");
 else
   {
    int d,any=0;
    char *p=dofm;
    strcpy(DofM,"0000000000000000000000000000000");

    while(*p)
      {
       while(*p && !isdigit(*p))
          p++;
       if(!*p)
          break;
       d=atoi(p)-1;
       if(d>=0 && d<31)
         {
          DofM[d]='1';
          any++;
         }
       while(isdigit(*p))
          p++;
      }

    if(!any)
       strcpy(DofM,"1111111111111111111111111111111");
   }

 strcpy(DofW,"0000000");
 for(i=0;i<7;i++)
    if(dofw[i]=='Y')
       DofW[i]='1';

 if(!*hofd)
    strcpy(HofD,"100000000000000000000000");
 else
   {
    int h,any=0;
    char *p=hofd;
    strcpy(HofD,"000000000000000000000000");

    while(*p)
      {
       while(*p && !isdigit(*p))
          p++;
       if(!*p)
          break;
       h=atoi(p);
       if(h>=0 && h<24)
         {
          HofD[h]='1';
          any++;
         }
       while(isdigit(*p))
          p++;
      }

    if(!any)
       strcpy(HofD,"100000000000000000000000");
   }

 mfd=CreateMonitorSpoolFile(Url,MofY,DofM,DofW,HofD);
 if(mfd==-1)
    HTMLMessage(fd,500,"WWWOFFLE Server Error",NULL,"ServerError",
                "error","Cannot open file to store monitor request",
                NULL);
 else
   {
    int ofd;
    char *req=RequestURL(Url,NULL);

    write_string(mfd,req);

    close(mfd);

    ofd=OpenOutgoingSpoolFile(0);

    if(ofd==-1)
       PrintMessage(Warning,"Cannot open outgoing spool file for monitored URL '%s' [%!s].",url);
    else
      {
       write_string(ofd,req);

       CloseOutgoingSpoolFile(ofd,Url);
      }

    HTMLMessage(fd,200,"WWWOFFLE Monitor Will Get",NULL,"MonitorWillGet",
                "url",Url->name,
                NULL);

    free(req);
   }

 free(copy);

 FreeURL(Url);
}


/*++++++++++++++++++++++++++++++++++++++
  Convert monitor requests into outgoing requests.
  ++++++++++++++++++++++++++++++++++++++*/

void RequestMonitoredPages(void)
{
 DIR *dir;
 struct dirent* ent;

 /* Open the monitor subdirectory. */

 if(chdir("monitor"))
   {PrintMessage(Warning,"Cannot change to directory 'monitor' [%!s]; no files monitored.");return;}

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open directory 'monitor' [%!s]; no files monitored.");chdir("..");return;}

 ent=readdir(dir);  /* skip .  */
 if(!ent)
   {PrintMessage(Warning,"Cannot read directory 'monitor' [%!s]; no files monitored.");closedir(dir);chdir("..");return;}
 ent=readdir(dir);  /* skip .. */

 /* Scan through all of the files. */

 while((ent=readdir(dir)))
   {
    struct stat buf;

    if(lstat(ent->d_name,&buf))
      {PrintMessage(Inform,"Cannot stat file 'monitor/%s' [%!s]; race condition?",ent->d_name);return;}
    else if(S_ISREG(buf.st_mode) && *ent->d_name=='O')
      {
       char *url=FileNameToURL(ent->d_name);
       URL *Url=SplitURL(url);
       int last,next;

       chdir("..");

       MonitorTimes(Url,&last,&next);

       PrintMessage(Debug,"Monitoring %s; last=%dh next=%dh =>%s",Url->name,last,next,next?"No":"Yes");

       chdir("monitor");

       if(next==0)
         {
          int ifd=open(ent->d_name,O_RDONLY|O_BINARY);
          init_buffer(ifd);

          if(ifd==-1)
             PrintMessage(Warning,"Cannot open monitored file 'monitor/%s' to read [%!s].",ent->d_name);
          else
            {
             int ofd;

             chdir("..");

             ofd=OpenOutgoingSpoolFile(0);

             if(ofd==-1)
                PrintMessage(Warning,"Cannot open outgoing spool file for monitored URL '%s' [%!s].",url);
             else
               {
                char *contents=(char*)malloc(buf.st_size);
                URL *Url=SplitURL(url);

                read_data(ifd,contents,buf.st_size);
                write_data(ofd,contents,buf.st_size);

                CloseOutgoingSpoolFile(ofd,Url);

                free(contents);
                FreeURL(Url);
               }

             chdir("monitor");

             close(ifd);
             free(url);
            }
         }

       FreeURL(Url);
      }
   }

 chdir("..");

 closedir(dir);
}


/*++++++++++++++++++++++++++++++++++++++
  Calculate the monitoring interval and times of previous and next monitoring.

  URL *Url The URL of the file to check for.

  int *last The time in hours ago that the file was last monitored.

  int *next The time in hours from now that it should next be monitored.
  ++++++++++++++++++++++++++++++++++++++*/

void MonitorTimes(URL *Url,int *last,int *next)
{
 time_t now=time(NULL),then,when;
 char MofY[13],DofM[32],DofW[8],HofD[25];
 int mofy,dofm,dofw,hofd;
 struct tm *tim;

 then=ReadMonitorTimesSpoolFile(Url,MofY,DofM,DofW,HofD);

 if(!then)
    then=now;

 now =3600*(now/3600);
 then=3600*(then/3600);

 mofy=dofm=dofw=hofd=0;
 for(when=then;when<now;when+=3600)
   {
    if(hofd==0)
      {
       tim=localtime(&when);
       mofy=tim->tm_mon;
       dofm=tim->tm_mday-1;
       dofw=tim->tm_wday;
       hofd=tim->tm_hour;
      }

    if(MofY[mofy]=='1' && DofM[dofm]=='1' && DofW[dofw]=='1' && HofD[hofd]=='1')
      {*next=0;break;}

    hofd=(hofd+1)%24;
   }

 if(when==now)
   {
    hofd=0;
    for(when=now;when<(now+31*24*3600);when+=3600)
      {
       if(hofd==0)
         {
          tim=localtime(&when);
          mofy=tim->tm_mon;
          dofm=tim->tm_mday-1;
          dofw=tim->tm_wday;
          hofd=tim->tm_hour;
         }

       if(MofY[mofy]=='1' && DofM[dofm]=='1' && DofW[dofw]=='1' && HofD[hofd]=='1')
          break;

       hofd=(hofd+1)%24;
      }

    *next=(when-now)/3600;
   }

 *last=(now-then)/3600;
}
