/***************************************
  $Header: /home/amb/wwwoffle/RCS/config.h 2.36 1999/03/20 17:34:25 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.4c.
  Configuration file management functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef CONFIG_H
#define CONFIG_H    /*+ To stop multiple inclusions. +*/

/* In config.c */

int ReadConfigFile(int fd);


/*+ The name of the configuration file. +*/
extern char *ConfigFile;


/* StartUp Section */

/*+ The port number to use for the HTTP proxy port. +*/
extern int HTTP_Port;

/*+ The port number to use for the wwwoffle port. +*/
extern int WWWOFFLE_Port;

/*+ The spool directory. +*/
extern char *SpoolDir;

/*+ The user id for wwwoffled or -1 for none. +*/
extern int WWWOFFLE_Uid;

/*+ The group id for wwwoffled or -1 for none. +*/
extern int WWWOFFLE_Gid;

/*+ Whether to use the syslog facility or not. +*/
extern int UseSyslog;

/*+ The password required for demon configuration. +*/
extern char *PassWord;

/*+ Maximum number of servers  +*/
extern int MaxServers;          /*+ in total. +*/
extern int MaxFetchServers;     /*+ for fetching. +*/


/* Options Section */

/*+ The level of error logging (see ErrorLevel in errors.h) +*/
extern int LogLevel,            /*+ in the config file for syslog and stderr. +*/
           DebugLevel;          /*+ on the command line for stderr. +*/

/*+ The number of days to display in the index of the latest pages. +*/
extern int IndexLatestDays;

/*+ The option of a tag that can be added to the bottom of the spooled pages with the date and a refresh button. +*/
extern int AddInfoRefresh;

/*+ The maximum age of a cached page to use in preference while online. +*/
extern int RequestChanged;

/*+ The option to only request changes to a page once per session online. +*/
extern int RequestChangedOnce;

/*+ The option to allow or ignore the 'Pragma: no-cache' request. +*/
extern int PragmaNoCache;

/*+ The option to not automatically make requests while offline but to need confirmation. +*/
extern int ConfirmRequests;

/*+ The amount of time that a socket connection will wait for data. +*/
extern int SocketTimeout;

/*+ The option to retry a failed connection. +*/
extern int ConnectRetry;

/*+ The option to disable the lasttime/prevtime indexs. +*/
extern int NoLasttimeIndex;


/* FetchOptions Section */

/*+ The option to also fetch style sheets. +*/
extern int FetchStyleSheets;

/*+ The option to also fetch images. +*/
extern int FetchImages;

/*+ The option to also fetch frames. +*/
extern int FetchFrames;

/*+ The option to also fetch scripts. +*/
extern int FetchScripts;

/*+ The option to also fetch objects. +*/
extern int FetchObjects;


/* ModifyHTML Section */

/*+ The option to turn on the modifications in this section. +*/
extern int EnableHTMLModifications;

/*+ The option of a tag that can be added to the bottom of the spooled pages with the date and some buttons. +*/
extern int AddCacheInfo;

/*+ The options to modify the anchor tags in the HTML. +*/
extern char *AnchorModifyBegin[3],
            *AnchorModifyEnd[3];


/* DontGet Section */

/*+ The replacement URL. +*/
extern char *DontGetReplacementURL;


/* Proxy Section */

/*+ The SSL proxy to use. +*/
extern char *SSLProxy;


/* Purge Section */

/*+ If true then use modification time instead of access time. +*/
extern int PurgeUseMTime;

/*+ The default age for purging files. +*/
extern int DefaultPurgeAge;

/*+ The maximum allowed size of the cache. +*/
extern int PurgeCacheSize;

/*+ The minimum allowed free disk space. +*/
extern int PurgeDiskFree;

/*+ A flag to indicate it the whole URL is used to choose the purge age. +*/
extern int PurgeUseURL;


/* Options Section */

int IsSSLAllowedPort(char *host);


/* LocalHost Section */

char *GetLocalHost(int port);
int IsLocalHost(char *host,int port);


/* LocalNet Section */

int IsLocalNetHost(char *host);


/* AllowedConnectHosts Section */

int IsAllowedConnectHost(char *host);


/* AllowedConnectUsers Section */

char *IsAllowedConnectUser(char *userpass);


/* DontCache Section */

int IsNotCached(char *proto,char *host,char *path);


/* DontGet Section */

int IsNotGot(char *proto,char *host,char *path);


/* DontGetRecursive Section */

int IsNotGotRecursive(char *proto,char *host,char *path);


/* DontRequestOffline Section */

int IsNotRequestedOffline(char *proto,char *host,char *path);


/* CensorHeader Section */

char *CensoredHeader(char *url,char *line);


/* FTPOptions Section */

int WhatFTPUserPass(char *host,char **user,char **pass);


/* MIMETypes Section */

char *WhatMIMEType(char *path);


/* Proxy Section */

char *WhichProxy(char *proto,char *host);
char *WhatProxyAuth(char *proxy);


/* DontIndex Section */

int IsNotIndexed(char *proto,char *host,char *path,char *index);


/* Alias Section */

int IsAliased(char *proto,char *host,char *path,char **new_proto,char **new_host,char **new_path);


/* Purge Section */

int WhatPurgeAge(char *proto,char *host,char *path);


#endif /* CONFIG_H */
