/***************************************
  $Header: /home/amb/wwwoffle/RCS/wwwoffle.h 2.57 1999/03/14 08:53:58 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.4c.
  A header file for all of the programs wwwoffle, wwwoffled.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97,98,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef WWWOFFLE_H
#define WWWOFFLE_H    /*+ To stop multiple inclusions. +*/


/* ------------------------------------------------------------
   The values in the section below can be changed if required, see INSTALL. */

/*+ The default port number to use for the http proxy demon. +*/
#define DEF_HTTP_PORT 8080

/*+ The default port number to use for the wwwoffle control. +*/
#define DEF_WWWOFFLE_PORT 8081

/*+ The default spool directory. +*/
#define DEF_SPOOL "/var/spool/wwwoffle"

/*+ The default configuration file directory. +*/
#define DEF_CONF "/var/spool/wwwoffle"

/*+ The absolute maximum number of servers to fork in total. +*/
#define MAX_SERVERS 64
/*+ The default total number of servers to fork. +*/
#define DEF_MAX_SERVERS 8

/*+ The absolute maximum number of servers to fork for fetching previously requested pages. +*/
#define MAX_FETCH_SERVERS 48
/*+ The default number of servers to fork for fetching pages. +*/
#define DEF_MAX_FETCH_SERVERS 4

/*+ The number of pretime directories to create (lasttime history). +*/
#define NUM_PREVTIME_DIR 3

/* The values in the section above can be changed if required, see INSTALL.
   ------------------------------------------------------------ */

#include "misc.h"

/* In connect.c */

void CommandConnect(int client);
void ForkServer(int client,int browser);

/* In purge.c */

void PurgeCache(int fd);

/* In spool.c */

int OpenOutgoingSpoolFile(int rw);
void CloseOutgoingSpoolFile(int fd,URL *Url);
int ExistsOutgoingSpoolFile(URL *Url);
char *HashOutgoingSpoolFile(URL *Url);
char *DeleteOutgoingSpoolFile(URL *Url);

int OpenWebpageSpoolFile(int rw,URL *Url);
char *DeleteWebpageSpoolFile(URL *Url,int all);
void TouchWebpageSpoolFile(URL *Url);
int ExistsWebpageSpoolFile(URL *Url);

void CreateBackupWebpageSpoolFile(URL *Url);
void RestoreBackupWebpageSpoolFile(URL *Url);
void DeleteBackupWebpageSpoolFile(URL *Url);

void CreateLockWebpageSpoolFile(URL *Url);
void DeleteLockWebpageSpoolFile(URL *Url);
int ExistsLockWebpageSpoolFile(URL *Url);

int CreateLastTimeSpoolFile(URL *Url);
char *DeleteLastTimeSpoolFile(URL *Url);
int ExistsLastTimeSpoolFile(URL *Url);
void CycleLastTimeSpoolFile(void);

int CreateMonitorSpoolFile(URL *Url,char MofY[13],char DofM[32],char DofW[8],char HofD[25]);
long ReadMonitorTimesSpoolFile(URL *Url,char MofY[13],char DofM[32],char DofW[8],char HofD[25]);
char *DeleteMonitorSpoolFile(URL *Url);

char *FileNameToURL(char *file);
char *URLToFileName(URL *Url);

/* In parse.c */

char *ParseRequest(int fd,char **request_head,char **request_body);

int RequestChanges(int fd,char **request_head);
char *MovedLocation(URL *Url,char *reply_head);
char *RequestURL(URL *Url,char *referer);

char *ModifyRequest(URL *Url,char *request_head);

char *MakeRequestAuthorised(char *proxy,char *request_head);
char *MakeRequestNonProxy(char *request_head);

int ParseReply(int fd,URL *Url,char **reply_head);

int SpooledPageStatus(URL *Url);

char *GetHTTPHeader(char *head,char* line);

/* In messages.c (messages.l) */

void LocalPage(int fd,char *path,char *request_head);
char *HTMLMessage(int fd,int status_val,char *status_str,char *location,char *template, ...);
char *HTMLMessageHead(int fd,int status_val,char *status_str, ...);
char *HTMLMessageBody(int fd,char *template, ...);

/* In index.c */

void IndexPage(int fd,URL *Url);

/* In control.c */

void ControlPage(int fd,URL *Url,char *request_head,char *request_body);

/* In configedit.c */

void ConfigEditPage(int fd,char *args,char *request_body);

/* In refresh.c */

char *RefreshPage(int fd,URL *Url,char *request_body,int *recurse);
void ParseRecurseOptions(char *method);
int RecurseFetch(URL *Url,int new);
int RecurseFetchRelocation(URL *Url,char *location);
char *CreateRefreshPath(int recursive_depth,int recursive_mode,int force,
                        int stylesheets,int images,int frames,int scripts,int objects);
int RefreshForced(void);

/* In monitor.c */

void MonitorPage(int fd,URL *Url,char *request_body);
void RequestMonitoredPages(void);
void MonitorTimes(URL *Url,int *last,int *next);

/* In wwwoffles.c */

int wwwoffles(int online,int browser,int client);

/* In htdig.c */

void HTDigPage(int fd,URL *Url,char *head);

#endif /* WWWOFFLE_H */
