/***************************************
  $Header: /home/amb/wwwoffle/v2.4/RCS/proto.h 1.8 1998/10/04 13:10:39 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.4.
  Information about the protocols that wwwoffle supports.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef PROTO_H
#define PROTO_H    /*+ To stop multiple inclusions. +*/

#include "misc.h"

/*+ A type to contain the information that is required for a particular protocol. +*/
typedef struct _Protocol
{
 int number;                    /*+ The protocol number. +*/
 char *name;                    /*+ The protocol name. +*/

 int defport;                   /*+ The default port number. +*/

 int proxyable;                 /*+ Set to true if any known proxies can understand this. +*/

 char*(*open)(URL*);            /*+ A function to open a connection to a remote server. +*/
 char*(*request)(URL*,char*,char*); /*+ A function to make a request to the remote server. +*/
 char*(*readhead)(char*);       /*+ A function to read a line of data from the reply header. +*/
 int(*readbody)(char*,int);     /*+ A function to read the data from the reply body. +*/
 int(*close)(void);             /*+ A function to close the connection to the remote server. +*/
}
Protocol;

#define Protocol_HTTP    0      /*+ The http protocol. +*/
#define Protocol_FTP     1      /*+ The ftp protocol. +*/
#define Protocol_Finger  2      /*+ The finger protocol. +*/

/* In proto.c */

/*+ The list of protocols. +*/
extern Protocol Protocols[];

/*+ The number of protocols. +*/
extern int NProtocols;

/* In http.c */

char *HTTP_Open(URL *Url);
char *HTTP_Request(URL *Url,char *request_head,char *request_body);
char *HTTP_ReadHead(char *line);
int   HTTP_ReadBody(char *s,int n);
int   HTTP_Close(void);

/* In ftp.c */

char *FTP_Open(URL *Url);
char *FTP_Request(URL *Url,char *request_head,char *request_body);
char *FTP_ReadHead(char *line);
int   FTP_ReadBody(char *s,int n);
int   FTP_Close(void);

/* In finger.c */

char *Finger_Open(URL *Url);
char *Finger_Request(URL *Url,char *request_head,char *request_body);
char *Finger_ReadHead(char *line);
int   Finger_ReadBody(char *s,int n);
int   Finger_Close(void);

/* In ssl.c */

char *SSL_Open(URL *Url);
char *SSL_Request(int client,URL *Url,char *request_head);
void SSL_Transfer(int client);
int SSL_Close(void);

#endif /* PROTO_H */
