/***************************************
  $Header: /home/amb/wwwoffle/v2.4/RCS/misc.h 2.13 1998/07/18 13:10:09 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.3.
  Miscellaneous HTTP / HTML functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef MISC_H
#define MISC_H    /*+ To stop multiple inclusions. +*/

#include <stdio.h>

/*+ A forward definition of the protocol type. +*/
typedef struct _Protocol *ProtocolP;

/*+ A URL data type. +*/
typedef struct _URL
{
 char *name;                    /*+ The canonical URL for the object. +*/

 char *link;                    /*+ A URL that will work for browsers (may point to name). +*/

 char *file;                    /*+ The URL that is used for generating the filename (may point to name). +*/

 char *hostp;                   /*+ A pointer to the host in the url. +*/
 char *pathp;                   /*+ A pointer to the path in the url. +*/

 char *proto;                   /*+ The protocol. +*/
 char *host;                    /*+ The host. +*/
 char *path;                    /*+ The path. +*/
 char *args;                    /*+ The arguments. +*/

 ProtocolP Protocol;            /*+ The protocol. +*/

 char *user;                    /*+ The username if supplied. +*/
 char *pass;                    /*+ The password if supplied. +*/

 char local;                    /*+ Set to true if the host is the localhost. +*/
}
URL;

/* in misc.c */

URL *SplitURL(char *url);
void AddURLPassword(URL *Url,char *user,char *pass);
void FreeURL(URL *Url);

char *LinkURL(URL *Url,char *link);

char *MakeHash(const char *args);

char *RFC822Date(long t,int utc);
long DateToTimeT(const char *date);

char *URLDecode(const char *str, int isform);
char *URLEncode(const char *str);

char *Base64Decode(const char *str,int *l);
char *Base64Encode(const char *str,int l);

char* HTMLString(const char* c);

/* In io.c */

char *fgets_realloc(char *buffer,FILE *file);

void init_buffer(int fd);
int empty_buffer(int fd);

int read_data(int fd,char *buffer,int n);
int read_data_or_timeout(int fd,char *buffer,int n);

char *read_line(int fd,char *line);
char *read_line_or_timeout(int fd,char *line);

int write_data(int fd,const char *data,int n);

int write_string(int fd,const char *str);

#ifdef __GNUC__
int write_formatted(int fd,const char *fmt,...) __attribute__ ((format (printf,2,3)));
#else
int write_formatted(int fd,const char *fmt,...);
#endif

#endif /* MISC_H */
