W               [ \t\r\n]
Q               [\"\']
F               [-a-z0-9$_.!*(),%;/?:@&=+~|]
FA              [-a-z0-9$_.!*()%;/?:@&=+~|]

%x HEADER

%x NOT_HTML

%x ANGLE_START ANGLE
%x ANCHOR ANCHOR_HREF
%x AREA AREA_HREF
%x BASE BASE_HREF
%x BODY BODY_BACK
%x COMMENT
%x FRAME FRAME_SRC
%x IMAGE IMAGE_SRC
%x INPUT INPUT_SRC
%x LINK LINK_STYLE LINK_STYLE_HREF
%x META META_REFRESH META_REFRESH_URL
%x OBJECT OBJECT_PART ARCHIVE
%x PARAM PARAM_VALUE
%x SCRIPT SCRIPT_SRC

%{
/***************************************
  $Header: /home/amb/wwwoffle/RCS/html.l 2.28 1998/12/04 19:42:43 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.4.
  Parse the HTML and look for the images, links and other things.
  ******************/ /******************
  Written by Andrew M. Bishop
  Object handling by Walter Pfannenmller

  This file Copyright 1997,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#define DEBUG_HTML 0

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>

#include "wwwoffle.h"
#include "document.h"
#include "config.h"
#include "misc.h"

#if DEBUG_HTML
#include "errors.h"
#endif

extern int html_yylex(void);
#define html_yywrap() 1


/*+ The file descriptor to output to. +*/
static int output_fd=-1;

/*+ The add-cache-info optional footer. +*/
static char *cache_info=NULL;

/*+ The refresh content of a Meta tag. +*/
static char *meta_refresh=NULL;

/*+ The content of a Base tag. +*/
static char *base_url=NULL;

/*+ The file descriptor that we are reading from. +*/
static int html_yyfd=-1;

/*+ The base URL of this page. +*/
static URL *baseUrl=NULL;


/*++++++++++++++++++++++++++++++++++++++
  Reset the HTML parser.

  URL *Url the URL that we are parsing.
  ++++++++++++++++++++++++++++++++++++++*/

static void reset_html(URL *Url)
{
 baseUrl=Url;
 base_url=NULL;

 if(meta_refresh)
    free(meta_refresh);
 meta_refresh=NULL;

 ResetReferences();
}


/*++++++++++++++++++++++++++++++++++++++
  Parse the HTML and look for references to image/links/frames.

  int fd The file descriptor of the file to parse.

  URL *Url The reference URL to use.
  ++++++++++++++++++++++++++++++++++++++*/

void ParseHTML(int fd,URL *Url)
{
 reset_html(Url);

 output_fd=-1;
 html_yyfd=fd;
 html_yyrestart(NULL);
 html_yylex();

 if(base_url)
    baseUrl=SplitURL(base_url);

 FinishReferences(baseUrl);
}


/*++++++++++++++++++++++++++++++++++++++
  Output the file with the modificatons if it is HTML, else just output.

  int client The file to write to.

  int spool The file to read from.

  URL *Url The URL that we are parsing.
  ++++++++++++++++++++++++++++++++++++++*/

void OutputHTMLWithModifications(int client,int spool,URL *Url)
{
 char *line=NULL;

 while((line=read_line(spool,line)))
   {
    if(strncasecmp("Content-Length:",line,15))
       write_string(client,line);

    if(*line=='\r' || *line=='\n')
       break;
   }

 if(AddCacheInfo)
   {
    struct stat buf;
    time_t t_ago;
    char *date,*timeunit,timeago[8];

    fstat(spool,&buf);

    t_ago=time(NULL)-buf.st_mtime;
    date=RFC822Date(buf.st_mtime,0);
    
    if(t_ago<0)
      {strcpy(timeago,"?");timeunit="";}
    else if(t_ago<3600)
      {sprintf(timeago,"%ld",t_ago/60);timeunit=(t_ago/60==1?"min":"mins");}
    else if(t_ago<(24*3600))
      {sprintf(timeago,"%ld",t_ago/3600);timeunit=(t_ago/3600==1?"hour":"hours");}
    else if(t_ago<(14*24*3600))
      {sprintf(timeago,"%ld",t_ago/(24*3600));timeunit=(t_ago/(24*3600)==1?"day":"days");}
    else if(t_ago<(30*24*3600))
      {sprintf(timeago,"%ld",t_ago/(7*24*3600));timeunit=(t_ago/(7*24*3600)==1?"week":"weeks");}
    else
      {sprintf(timeago,"%ld",t_ago/(30*24*3600));timeunit=(t_ago/(30*24*3600)==1?"month":"months");}

    cache_info=HTMLMessageBody(-1,"AddCacheInfo",
                               "url",Url->name,
                               "date",date,
                               "time",timeago,
                               "unit",timeunit,
                               NULL);
   }

 reset_html(Url);

 output_fd=client;
 html_yyfd=spool;
 html_yyrestart(NULL);
 html_yylex();

 if(cache_info)
    free(cache_info);
 cache_info=NULL;
}


/*++++++++++++++++++++++++++++++++++++++
  Return the URL from the Meta Refresh tag if there is one.

  char *MetaRefresh Returns the new URL or NULL if none.
  ++++++++++++++++++++++++++++++++++++++*/

char *MetaRefresh(void)
{
 if(meta_refresh)
   {
    char *new=LinkURL(baseUrl,meta_refresh);
    if(new!=meta_refresh)
      {
       free(meta_refresh);
       meta_refresh=new;
      }
   }

 return(meta_refresh);
}


/*++++++++++++++++++++++++++++++++++++++
  Object and Param treatment:
  this is the attempt to extract all 
  valid URIs from the OBJECT or PARAM tag
  defined in HTML 4.0.

  usemap, cite, longdesc URIs are not yet supported.

  (c) Walter Pfannenmller
  ++++++++++++++++++++++++++++++++++++++*/

/* no more than obj_archives_max are accepted: seems enough */
#define obj_archives_max 32

/* Object */
enum {
    obj_classid = 0,
    obj_codetype,
    obj_codebase,
    obj_code,
    obj_object,
    obj_data,
    obj_usemap,
    obj_type,

    obj_archives_start,
    obj_archives_end = obj_archives_start + obj_archives_max,
    obj_parts_size
};

static int obj_codetype_Type = RefObject; 
static int obj_type_Type = RefObject; 
static int obj_narchives = 0;

static char *obj_parts[obj_parts_size] = { NULL, }; 

/* Param */

enum {
   param_type = 0,
   param_value,
   param_parts_size
};

static int param_valuetype_is_ref = 0;
static char *param_parts[param_parts_size] = { NULL, }; 

static char **op_ = NULL;
static void op_free()
{
    if(*op_ != NULL)
    {
       free(*op_);
       *op_ = NULL;
    }
}

static void op_malloc(char *text)
{
    op_free();
    *op_ = (char *)malloc(strlen(text) + 1);
    strcpy(*op_,text); 
} 

/*+++++++++++++++++++++++++++++++++++++++++++++++
  turn dots to slash and add .class to Applets
  +++++++++++++++++++++++++++++++++++++++++++++++*/
static const char class_suffix[] = ".class";
static char *norm_applet_class(int part)
{
    char *dots;
    char *applet = obj_parts[part];
    if(strcmp(&applet[strlen(applet) - strlen(class_suffix)],class_suffix))
    {
        applet = (char *)malloc(strlen(applet) + sizeof(class_suffix));
        strcpy(applet,obj_parts[part]); 
        strcat(applet,class_suffix); 
        op_ = &obj_parts[part];
        op_free();
        *op_ = applet;
    }
    dots = applet;
    while((dots = strchr(dots,'.')) < (applet + strlen(applet) - sizeof(class_suffix)))
    {
       *dots = '/';
    }
    return applet;
}
 
/*+++++++++++++++++++++++++++++++++++++++++++++++
  add codebase
  +++++++++++++++++++++++++++++++++++++++++++++++*/
static char *add_obj_codebase(int part)
{
    if(obj_parts[obj_codebase])
    {
        char *url = (char *)malloc(strlen(obj_parts[obj_codebase]) + 
                                   sizeof("/") +
                                   strlen(obj_parts[part]));
        strcpy(url,obj_parts[obj_codebase]); 
        if(url[strlen(url) - 1] != '/')
        {
            strcat(url,"/"); 
        }
        strcat(url,obj_parts[part]);
        op_ = &obj_parts[part];
        op_free();
        *op_ = url;
    }
    return obj_parts[part];
}
 
/*++++++++++++++++++++++++++++++++++++++
  take the object's info and build an applet url
  ++++++++++++++++++++++++++++++++++++++*/
static void applet_url(int part)
{
    if(obj_parts[part])
    {
        norm_applet_class(part);
        add_obj_codebase(part); 
        AddReference(obj_parts[part],RefObject);
    }
}

/*++++++++++++++++++++++++++++++++++++++
  take the object's info and add codebase
  ++++++++++++++++++++++++++++++++++++++*/
static void codebase_url(int part)
{
    if(obj_parts[part])
    {
        add_obj_codebase(part); 
        AddReference(obj_parts[part],RefObject);
    }
}

/*++++++++++++++++++++++++++++++++++++++
  take the object's info and build urls
  ++++++++++++++++++++++++++++++++++++++*/
static void build_obj_urls()
{
    int i;
    if(obj_codetype_Type == RefImage)
    {
        add_obj_codebase(obj_classid); 
        AddReference(obj_parts[obj_classid],RefImage);
    }
    else
    {
        applet_url(obj_classid);
    }
    if(obj_type_Type == RefImage)
    {
        add_obj_codebase(obj_data); 
        AddReference(obj_parts[obj_data],RefImage);
    }
    else
    {
        applet_url(obj_classid);
    }
    applet_url(obj_code);
    applet_url(obj_object);
    for(i = 0; i < obj_narchives; i++)
    {
        codebase_url(i + obj_archives_start);
    }
    
#if DEBUG_HTML
    for(i = 0; i < obj_parts_size; i++)
    {
       op_ = &obj_parts[i];
       if(*op_)
       {
           PrintMessage(Debug,"object %d: %s",i,*op_);
       }
    }
#endif
    for(i = 0; i < obj_parts_size; i++)
    {
       op_ = &obj_parts[i];
       op_free();
    }
    obj_codetype_Type = RefObject; 
    obj_type_Type = RefObject; 
    obj_narchives = 0;
}

/*+++++++++++++++
  storing archives  
  +++++++++++++++*/
static void add_obj_archive(char *text)
{
    if(obj_narchives < obj_archives_max)
    {
        op_ = &obj_parts[obj_archives_start + obj_narchives++];
        op_malloc(text);
    }
}

/*+++++++++++++++++++++++++++++++++++++++++
  take the param's info and build urls
  +++++++++++++++++++++++++++++++++++++++++*/
static void build_param_urls()
{
    int i;
    if(param_valuetype_is_ref && param_parts[param_value])
    {
        AddReference(param_parts[param_value],RefObject);
    } 
    param_valuetype_is_ref = 0;
#if DEBUG_HTML
    for(i = 0; i < param_parts_size; i++)
    {
       op_ = &param_parts[i];
       if(*op_)
       {
           PrintMessage(Debug,"param %d: %s",i,*op_);
       }
    }
#endif
    for(i = 0; i < param_parts_size; i++)
    {
       op_ = &param_parts[i];
       op_free();
    }
}


/*+ A macro to read data that can be used by the lexer. +*/
#define YY_INPUT(buf,result,max_size) \
        if((result=read_data(html_yyfd,buf,max_size))==-1) \
           result=0;

/*+ A macro to output the data if valid to do so. +*/
#define YY_OUTPUT_STRING(text) \
        if(output_fd!=-1) \
           write_string(output_fd,text)

%}

%%
 int open_angle=0;
 int url_cached=0;

 /* Handle comments and other angle brackets */

[^<]+                                   { YY_OUTPUT_STRING(html_yytext); }
"<!--"                                  { YY_OUTPUT_STRING(html_yytext); BEGIN(COMMENT); }
"<"{W}*                                 { BEGIN(ANGLE_START); open_angle=html_yyleng; }

 /* Comments */

<COMMENT>"-->"                          { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<COMMENT>">"                            { YY_OUTPUT_STRING(html_yytext); }
<COMMENT>"-"                            { YY_OUTPUT_STRING(html_yytext); }
<COMMENT>[^->]+                         { YY_OUTPUT_STRING(html_yytext); }

 /* Angle brackets */

<ANGLE_START>">"                        { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<ANGLE_START>"a"{W}                     { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(ANCHOR); }
<ANGLE_START>"area"{W}                  { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(AREA); }
<ANGLE_START>"base"{W}                  { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(BASE); }
<ANGLE_START>"body"{W}                  { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(BODY); }
<ANGLE_START>"frame"|"iframe"{W}        { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(FRAME); }
<ANGLE_START>"img"{W}                   { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(IMAGE); }
<ANGLE_START>"input"{W}                 { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(INPUT); }
<ANGLE_START>"link"{W}                  { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(LINK); }
<ANGLE_START>"meta"{W}                  { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(META); }
<ANGLE_START>"object"|"applet"|"embed"{W} { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT); }
<ANGLE_START>"param"{W}                 { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(PARAM); } 
<ANGLE_START>"script"{W}                { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(SCRIPT); }
<ANGLE_START>"/a"                       { if(output_fd!=-1)
                                            {if(url_cached==1) {if(AnchorCachedEnd[1]) YY_OUTPUT_STRING(AnchorCachedEnd[1]);}
                                             else if(url_cached==-1) {if(AnchorCachedEnd[0]) YY_OUTPUT_STRING(AnchorCachedEnd[0]);}
                                             url_cached=0;}
                                          YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(ANGLE); }
<ANGLE_START>"/body"                    { if(output_fd!=-1 && cache_info)
                                            {write_string(output_fd,cache_info); free(cache_info); cache_info=NULL;}
                                          YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(ANGLE); }
<ANGLE_START>"/html"                    { if(output_fd!=-1 && cache_info)
                                            {write_string(output_fd,cache_info); free(cache_info); cache_info=NULL;}
                                          YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(ANGLE); }
<ANGLE_START>.|\r|\n                    { YY_OUTPUT_STRING("<"); YY_OUTPUT_STRING(html_yytext); BEGIN(ANGLE); }

<ANGLE>">"                              { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<ANGLE>[^>]+                            { YY_OUTPUT_STRING(html_yytext); }

 /* Base */

<BASE>">"                               { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<BASE>"href"{W}*"="{W}*{Q}*             { YY_OUTPUT_STRING(html_yytext); BEGIN(BASE_HREF); }
<BASE>.|\r|\n                           { YY_OUTPUT_STRING(html_yytext); }

<BASE_HREF>">"                          { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<BASE_HREF>{F}+                         { YY_OUTPUT_STRING(html_yytext); BEGIN(BASE);
                                          base_url=(char*)malloc(strlen(html_yytext)+1); strcpy(base_url,html_yytext);
                                          baseUrl=SplitURL(base_url); }
<BASE_HREF>.|\r|\n                      { YY_OUTPUT_STRING(html_yytext); BEGIN(BASE); }

 /* Meta refresh */

<META>">"                               { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<META>"HTTP-EQUIV"{W}*"="{W}*{Q}*"Refresh"{Q}* { YY_OUTPUT_STRING(html_yytext); BEGIN(META_REFRESH); }
<META>.|\r|\n                           { YY_OUTPUT_STRING(html_yytext); }

<META_REFRESH>">"                       { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<META_REFRESH>"URL"{W}*"="{W}*{Q}*      { YY_OUTPUT_STRING(html_yytext); BEGIN(META_REFRESH_URL); }
<META_REFRESH>.|\r|\n                   { YY_OUTPUT_STRING(html_yytext); }

<META_REFRESH_URL>{F}+                  { YY_OUTPUT_STRING(html_yytext); BEGIN(META);
                                          if(output_fd==-1)
                                            { meta_refresh=(char*)malloc(strlen(html_yytext)+1); strcpy(meta_refresh,html_yytext); } }
<META_REFRESH_URL>.|\r|\n               { YY_OUTPUT_STRING(html_yytext); BEGIN(META); }

 /* Stylesheets */

<LINK>">"                               { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<LINK>"REL"{W}*"="{W}*{Q}*"Stylesheet"{Q}* { YY_OUTPUT_STRING(html_yytext); BEGIN(LINK_STYLE); }
<LINK>.|\r|\n                           { YY_OUTPUT_STRING(html_yytext); }

<LINK_STYLE>">"                         { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<LINK_STYLE>"href"{W}*"="{W}*{Q}*       { YY_OUTPUT_STRING(html_yytext); BEGIN(LINK_STYLE_HREF); }
<LINK_STYLE>.|\r|\n                     { YY_OUTPUT_STRING(html_yytext); }

<LINK_STYLE_HREF>{F}+                   { YY_OUTPUT_STRING(html_yytext); BEGIN(LINK);
                                          if(output_fd==-1) AddReference(html_yytext,RefStyleSheet); }
<LINK_STYLE_HREF>.|\r|\n                { YY_OUTPUT_STRING(html_yytext); BEGIN(LINK); }

 /* Images */

<IMAGE>">"                              { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<IMAGE>"src"{W}*"="{W}*{Q}*             { YY_OUTPUT_STRING(html_yytext); BEGIN(IMAGE_SRC); }
<IMAGE>.|\r|\n                          { YY_OUTPUT_STRING(html_yytext); }

<IMAGE_SRC>">"                          { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<IMAGE_SRC>{F}+                         { YY_OUTPUT_STRING(html_yytext); BEGIN(IMAGE);
                                          if(output_fd==-1) AddReference(html_yytext,RefImage); }
<IMAGE_SRC>.|\r|\n                      { YY_OUTPUT_STRING(html_yytext); BEGIN(IMAGE); }

<INPUT>">"                              { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<INPUT>"src"{W}*"="{W}*{Q}*             { YY_OUTPUT_STRING(html_yytext); BEGIN(INPUT_SRC); }
<INPUT>.|\r|\n                          { YY_OUTPUT_STRING(html_yytext); }

<INPUT_SRC>">"                          { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<INPUT_SRC>{F}+                         { YY_OUTPUT_STRING(html_yytext); BEGIN(INPUT);
                                          if(output_fd==-1) AddReference(html_yytext,RefImage); }
<INPUT_SRC>.|\r|\n                      { YY_OUTPUT_STRING(html_yytext); BEGIN(INPUT); }

<BODY>">"                               { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<BODY>"background"{W}*"="{W}*{Q}*       { YY_OUTPUT_STRING(html_yytext); BEGIN(BODY_BACK); }
<BODY>.|\r|\n                           { YY_OUTPUT_STRING(html_yytext); }

<BODY_BACK>">"                          { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<BODY_BACK>{F}+                         { YY_OUTPUT_STRING(html_yytext); BEGIN(BODY);
                                          if(output_fd==-1) AddReference(html_yytext,RefImage); }
<BODY_BACK>.|\r|\n                      { YY_OUTPUT_STRING(html_yytext); BEGIN(BODY); }

 /* Frames */

<FRAME>">"                              { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<FRAME>"src"{W}*"="{W}*{Q}*             { YY_OUTPUT_STRING(html_yytext); BEGIN(FRAME_SRC); }
<FRAME>.|\r|\n                          { YY_OUTPUT_STRING(html_yytext); }

<FRAME_SRC>">"                          { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<FRAME_SRC>{F}+                         { YY_OUTPUT_STRING(html_yytext); BEGIN(FRAME);
                                          if(output_fd==-1) AddReference(html_yytext,RefFrame); }
<FRAME_SRC>.|\r|\n                      { YY_OUTPUT_STRING(html_yytext); BEGIN(FRAME); }

 /* Scripts */

<SCRIPT>">"                             { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<SCRIPT>"src"{W}*"="{W}*{Q}*            { YY_OUTPUT_STRING(html_yytext); BEGIN(SCRIPT_SRC); }
<SCRIPT>.|\r|\n                         { YY_OUTPUT_STRING(html_yytext); }

<SCRIPT_SRC>">"                         { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<SCRIPT_SRC>{F}+                        { YY_OUTPUT_STRING(html_yytext); BEGIN(SCRIPT);
                                          if(output_fd==-1) AddReference(html_yytext,RefScript); }
<SCRIPT_SRC>.|\r|\n                     { YY_OUTPUT_STRING(html_yytext); BEGIN(SCRIPT); }

 /* Objects */

<OBJECT>">"                             { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); build_obj_urls(); }
<OBJECT>"code"{W}*"="{W}*{Q}*           { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_code]; }
<OBJECT>"classid"{W}*"="{W}*{Q}*        { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_classid]; }
<OBJECT>"codetype"{W}*"="{W}*{Q}*"image" { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_codetype]; 
                                          obj_codetype_Type = RefImage; }
<OBJECT>"codetype"{W}*"="{W}*{Q}*       { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_codetype]; }
<OBJECT>"codebase"{W}*"="{W}*{Q}*       { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_codebase]; }
<OBJECT>"object"{W}*"="{W}*{Q}*         { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_object]; }
<OBJECT>"data"{W}*"="{W}*{Q}*           { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_data]; }
<OBJECT>"type"{W}*"="{W}*{Q}*"image"    { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_type];
                                          obj_type_Type = RefImage; }
<OBJECT>"type"{W}*"="{W}*{Q}*           { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_type]; }
<OBJECT>"usemap"{W}*"="{W}*{Q}*         { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT_PART); op_ = &obj_parts[obj_usemap]; }
<OBJECT>"archive"{W}*"="{W}*{Q}*        { YY_OUTPUT_STRING(html_yytext); BEGIN(ARCHIVE); }
<OBJECT>.|\r|\n                         { YY_OUTPUT_STRING(html_yytext); }

<OBJECT_PART>{F}+                       { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT); op_malloc(html_yytext); }
<OBJECT_PART>.|\r|\n                    { YY_OUTPUT_STRING(html_yytext); }

<ARCHIVE>">"                            { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); build_obj_urls(); }
<ARCHIVE>{W}*","{W}*                    { YY_OUTPUT_STRING(html_yytext); }
<ARCHIVE>{W}+                           { YY_OUTPUT_STRING(html_yytext); }
<ARCHIVE>{FA}+                          { YY_OUTPUT_STRING(html_yytext); add_obj_archive(html_yytext); }
<ARCHIVE>{W}*|{Q}                       { YY_OUTPUT_STRING(html_yytext); BEGIN(OBJECT); }

<PARAM>">"                              { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); build_param_urls(); }
<PARAM>"type"{W}*"="{W}*{Q}*            { YY_OUTPUT_STRING(html_yytext); BEGIN(PARAM_VALUE); op_ = &param_parts[param_type]; }
<PARAM>"valuetype"{W}*"="{W}*{Q}*"ref"  { YY_OUTPUT_STRING(html_yytext); param_valuetype_is_ref = 1; } 
<PARAM>"value"{W}*"="{W}*{Q}*           { YY_OUTPUT_STRING(html_yytext); BEGIN(PARAM_VALUE); op_ = &param_parts[param_value]; }
<PARAM>"name"{W}*"="{W}*{Q}*"href"|"file"|"ref" { YY_OUTPUT_STRING(html_yytext); param_valuetype_is_ref = 1; } 
<PARAM>.|\r|\n                          { YY_OUTPUT_STRING(html_yytext); }

<PARAM_VALUE>{F}+                       { YY_OUTPUT_STRING(html_yytext); BEGIN(PARAM); op_malloc(html_yytext); }
<PARAM_VALUE>.|\r|\n                    { YY_OUTPUT_STRING(html_yytext); }

 /* Links */

<ANCHOR>">"                             { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL);
                                          if(output_fd!=-1)
                                            {if(url_cached==1) {if(AnchorCachedBegin[1]) YY_OUTPUT_STRING(AnchorCachedBegin[1]);}
                                             else if(url_cached==-1) {if(AnchorCachedBegin[0]) YY_OUTPUT_STRING(AnchorCachedBegin[0]);} } }
<ANCHOR>"href"{W}*"="{W}*{Q}*           { YY_OUTPUT_STRING(html_yytext); BEGIN(ANCHOR_HREF); }
<ANCHOR>.|\r|\n                         { YY_OUTPUT_STRING(html_yytext); }

<ANCHOR_HREF>">"                        { unput('>'); BEGIN(ANCHOR); }
<ANCHOR_HREF>{F}*                       { if(output_fd!=-1)
                                            {char *link=LinkURL(baseUrl,html_yytext);
                                             URL *Url=SplitURL(link);
                                             if(!strncasecmp("mailto:",html_yytext,7) || !strncasecmp("news:",html_yytext,5) ||
                                                !Url || !Url->Protocol) url_cached=0;
                                             else if(ExistsWebpageSpoolFile(Url)) url_cached=1;
                                             else url_cached=-1;
                                             if(link!=html_yytext) free(link); if(Url) FreeURL(Url); }
                                          YY_OUTPUT_STRING(html_yytext); BEGIN(ANCHOR);
                                          if(output_fd==-1) AddReference(html_yytext,RefLink); }
<ANCHOR_HREF>"#"                        { if(output_fd!=-1)
                                             url_cached=1;
                                          YY_OUTPUT_STRING(html_yytext); BEGIN(ANCHOR); }
<ANCHOR_HREF>.|\r|\n                    { YY_OUTPUT_STRING(html_yytext); BEGIN(ANCHOR); }

<AREA>">"                               { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<AREA>"href"{W}*"="{W}*{Q}*             { YY_OUTPUT_STRING(html_yytext); BEGIN(AREA_HREF); }
<AREA>.|\r|\n                           { YY_OUTPUT_STRING(html_yytext); }

<AREA_HREF>">"                          { YY_OUTPUT_STRING(html_yytext); BEGIN(INITIAL); }
<AREA_HREF>{F}+                         { YY_OUTPUT_STRING(html_yytext); BEGIN(AREA);
                                          if(output_fd==-1) AddReference(html_yytext,RefLink); }
<AREA_HREF>.|\r|\n                      { YY_OUTPUT_STRING(html_yytext); BEGIN(AREA); }

 /* End of file */

<<EOF>>                                 { if(output_fd!=-1 && cache_info)
                                            {write_string(output_fd,cache_info); free(cache_info); cache_info=NULL;}
                                          return(EOF); }

%%
