.\" $Header: /home/amb/wwwoffle/RCS/wwwoffle.conf.man 2.17 1998/06/06 12:43:31 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 2.2.
.\"
.\"  Manual page for wwwoffle.conf
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997,98 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffle.conf 5 "May 31, 1998"
.SH NAME
wwwoffle.conf \- The configuration file for the proxy server for the World Wide Web Offline Explorer.
.SH DESCRIPTION
The
.I wwwoffle.conf
file contains the configuration for the wwwoffled proxy HTTP server part of the
.I
World Wide Web Offline Explorer
program.
.LP
The file is split into sections, each of which has a format similar to a C
function (see the example below).  The section has a name, followed on the next
line by an open brace '{', followed on the next lines by a list of names and
values separated by an equals sign '=', the section ends with a close brace
'}' on a line.  Comments are marked by a '#' at the start of the line.
.LP
The
.B StartUp
section can contain the following:
.TP
.B http-port = <port>
The port number to use on the local host as the HTTP proxy (default=8080).
.TP
.B wwwoffle-port = <port>
The port number to use on the local host as the wwwoffle control port
(default=8081).
.TP
.B spool-dir = <dirname>
The name of the spool directory to use for the cache. A subdirectory is created
in this for each new web server that is contacted (default=/var/spool/wwwoffle).
.TP
.B run-uid = <username> | <uid> | none |
The username of numeric uid to run the wwwoffle server with.  To use this
option, the program must be started by root.
.TP
.B run-gid = <groupname> | <gid> | none |
The groupname of numeric gid to run the wwwoffle server with.  To use this
option, the program must be started by root.
.TP
.B use-syslog = yes | no
The syslog facility can be used to log the important error messages.
(default=yes).
.TP
.B password = <word> | none |
The authorisation password that is required to use the wwwoffle program to
configure the server or use the interactive control page (default=none).  If
this is not present, or set to an empty string or 'none' then there is no
password required.  If there is a password set, then the -c option to wwwoffle
must be used, and the file wwwoffle.conf should be made readable only by
authorised users.
.TP
.B max-servers = <integer>
.B max-fetch-servers = <integer>
The maximum number of servers processes that are started (default=8).  The
maximum number of server processes that are forked to fetch pages that were
requested in offline mode (default = 4).  The
.I max-fetch-servers
value must be less than
.I max-servers
or you will not be able to use wwwoffle interactively online while fetching.
.LP
The
.B Options
section contains other options that configure the server.
.TP
.B log-level = debug | info | important | warning | fatal
The error messages that have a priority the same as that specified or greater
are recorded on the output, either syslog or stderr (see wwwoffled(1)).
.TP
.B index-latest-days = <age>
The maximum age in days of pages to show in the index of the latest pages
(default=7).
.TP
.B add-info-refresh = yes | no
The option to add into the bottom of all of the spooled pages the date that the
page was cached and a refresh button (default=no).  This uses the first entry in
the LocalHost section as the server name.
.TP
.B request-changed = <time>
While online pages will only be fetched if the cached version is older than this
specified time in seconds (default=600).  A negative value will force the cache
to always be used in preference.
.TP
.B pragma-no-cache = yes | no
Whether to request a new copy of a page if the request has 'Pragma: no-cache'
(default=yes).  This option should be set to 'no' if when browsing offline all
pages are re-requested by a 'broken' browser.
.TP
.B offline-requests  = yes | no
Whether to record requests that are made while offline or to return an error
(default=yes).
.TP
.B monitor-interval = <age>
The default interval in days between monitoring of the specified URLs if no
other value is specified (default=7 days).  When this option is set to 0 it
means to check each time wwwoffle is online, 1 means once per day, etc.
.TP
.B socket-timeout = <time>
The time in seconds that wwwoffle will wait for data to arrive on a socket
connection before timing out and giving an error (default=120 seconds).
.LP
The
.B FetchOptions
section contains options that configure the automated downloading of pages.
When pages are requested offline and downloaded later, there is a choice of
whether to fetch stylesheets, images, frames, scripts or other objects
referenced in the HTML.
.TP
.B stylesheets = yes | no
Fetch the style sheets from these pages as well (default=no).
.TP
.B images = yes | no
Fetch the images from these pages as well (default=no).
.TP
.B frames = yes | no
Fetch the frames from these pages as well (default=no).
.TP
.B scripts = yes | no
Fetch the scripts from these pages as well (default=no).
.TP
.B objects = yes | no
Fetch the objects (e.g. Java class files) from these pages as well (default=no).
.LP
The
.B LocalHost
section contains a list of possible names or IP addresses that the host running
wwwoffled may be known as.
.TP
.I hostname
The server may be known as
.I hostname
so does not need to contact itself to get pages.  All of the entries here are
also used as if they were in the LocalNet and AllowConnect sections.  None of
the entries here are fetched via a proxy.
.LP
The
.B LocalNet
section contains a list of host names or IP addresses that are not to be cached
because they are on the local network.
.TP
.I hostname
A server that matches
.I hostname
is on the local network and not to be cached.  The match is done from the right
so that domain names can be used to match all hosts in the domain, IP addresses
match from the left.  All entries here are assumed to be reachable even when
offline.  All of the entries in the LocalHost section are also not cached as if
they were here also.  None of the entries here are fetched via a proxy.
.LP
The
.B AllowedConnect
section contains a list of host names or IP addresses that are allowed to
connect to the server.
.TP
.I hostname
A server that matches
.I hostname
is allowed to connect to the server.  The match is done from the right so that
domain names can be used to match all hosts in the domain, IP addresses match
from the left.  All of the entries in the LocalHost section are also allowed to
connect.
.LP
The
.B DontCache
section contains a way of recognising URLs not to be cached.  They will still
be cached however if it is fetched non-interactively.
.TP
.B default = ...
By default don't cache files that match the right hand side.  Note that
.I default
can occur more than once with different right hand sides.
.TP
.I HOST-SPECIFICATION = ...
For URLs that match
.I HOST-SPECIFICATION
don't cache files that match the right hand side.
See the HOST SPECIFICATION section for details of the
.B HOST-SPECIFICATION
option.
.TP
=
.I FILE-SPECIFICATION
When getting files from the specified left hand side servers don't cache any
that match
.I FILE-SPECIFICATION
See the FILE SPECIFICATION section for details of the
.B FILE-SPECIFICATION
option.
.LP
The
.B DontGet
section contains a way of recognising URLs not to be got.  This can be used to
reject junk adverts for example.
.TP
See the DontCache section for a description of the options in this section.
.LP
The
.B DontGetRecursive
section contains a way of recognising URLs not to be got when getting
recursively.
.TP
See the DontCache section for a description of the options in this section.
.LP
The
.B CensorHeader
section contains a list of the header lines that are to be removed from the
request sent from the browser to the server.
.TP
.I header = <string> | none |
The lines in the request that start with
.I header
, followed by a ':' are removed before being passed to the server if there is no
string on the right hand side, else that string replaces the one from the
browser.  This option does not allow you to add headers that were not present in
the browser request.
.LP
The
.B FTPOptions
section contains the information that is required to be able to do anonymous ftp.
.TP
.B anon-username = <string>
Specifies the username to use to fetch files using ftp (default is "anonymous",
"ftp" is another option).
.TP
.B anon-password = <string>
Specifies the password to use to fetch files using ftp (default is determined
from the user running wwwoffled and the hostname, this may not work reliably
especially if you are behind a firewall).
.TP
.B auth-hostname = <host[:port]>
.B auth-username = <string>
.B auth-password = <string>
Specifies a triplet of hostname, username and password that allow non-anonymous
access to a specific server. (These options must come in groups of three.)
.LP
The
.B MIMETypes
section is a list of the mime type to associate with files that are not fetched
using HTTP.  This is required by browsers, most browsers come with a list that
can be used here.
.TP
.B default = <mime-type>/<subtype>
The default MIME type to use for files that do not match any of the other rules.
.TP
.I .<file-ext> = <mime-type>/<subtype>
The MIME type to use for files that match the file extension.
.LP
The
.B Proxy
section contains a list of the hosts that are to be served via specified proxy
servers.  If no proxy is required then use 'none' or leave the proxy name blank.
.TP
.B default = <hostname:[port]> | none |
Specifies the default proxy that all requests are to use.
.TP
.I HOST-SPECIFICATION = ...
For URLs that match
.I HOST-SPECIFICATION
use the specified proxy.
See the HOST SPECIFICATION section for details of the
.B HOST-SPECIFICATION
option.
.TP
.B auth-hostname = <host[:port]>
.B auth-username = <string>
.B auth-password = <string>
Specifies a proxy server host that requires proxy authentication by username and
password to use it.  (These options must come in groups of three.)
.LP
None of the entries in the LocalHost or LocalNet section are fetched using a
proxy.
.LP
The
.B Mirror
section allows alternate servers to be specified that are to be used in
preference to the one specified in a URL.  This also allows multiple names for
the same server to be linked together so that a single spool directory is used.
.TP
.I protocol1/hostname1 = protocol2/hostname2
When
.I protocol1
is used to access
.I hostname1
the request is modified into a request for
.I hostname2
using
.I protocol2
, the two are also considered identical for the purposes of indexing, purging
and recursive fetching.
.TP
.I hostname1 = hostname2
When
.I hostname1
is accessed the request is modified into a request for
.I hostname2
for any of the protcols, the two are also considered identical for the purposes
of indexing, purging and recursive fetching.
.LP
A symbolic link in the cache between 
.I protocol1/hostname1
and
.I protocol2/hostname2
will have the same effect as specifying them in the config file.  The links are
only checked when wwwoffle starts or when 'wwwoffle -config' is run.
.LP
The
.B Purge
section controls how the cache is purged.  The method to determine which pages
to purge, the default age, the host specific maximum age of the pages in days,
and a maximum allowed cache size.  An age of zero means to always delete when a
purge is done, a negative age means never purge.  The maximum cache size
excludes the files that are from hosts that are marked never to be purged.
.TP
.B use-mtime = yes | no
The decision of which pages to purge can be made on last access time (atime) or
last modification time (mtime) (default=no).
.TP
.B max-size = <size>
The maximum size of the cache in MB, excluding the hosts that are never to be
purged, if this is zero then it does not apply (default=0).
.TP
.B default = <age>
The age to purge hosts that are not otherwise specified here (default=28).
.TP
.I HOST-SPECIFICATION = ...
The age to purge hosts with URLs that match
.I HOST-SPECIFICATION
See the HOST SPECIFICATION section for details of the
.B HOST-SPECIFICATION
option.
.LP
.SH HOST SPECIFICATION
When specifying a host and protocol in many of the sections a
.B HOST-SPECIFICATION
can be used, this is a way of recognising a URL.
.LP
For the purposes of this explanation a URL is considered to be made up of three
parts.
.TP
.B proto
The protocol that is used (e.g. http, ftp)
.TP
.B host
The server hostname (e.g. www.gedanken.demon.co.uk) or a domain
name (e.g. demon.co.uk) or an IP address (e.g. 1.2.3.4) or a
subnet (e.g. 1.2.3).
.TP
.B port
The port number on the host (e.g. default of 80 for HTTP).
.LP
For example the wwwoffle homepage: http://www.gedanken.demon.co.uk/wwwoffle/
The protocol is 'http', the host is 'www.gedanken.demon.co.uk', the port is the
default (in this case 80).
.LP
A
.B HOST-SPECIFICATION
can be any one of the following
.TP
.B /
Any protocol, Any host, Default port
.TP
.B /:
Any protocol, Any host, Any port (same as using 'default')
.TP
.B [/]<host>
Any protocol, Named host, Default port
.TP
.B [/]<host>:<port>
Any protocol, Named host, Specified port
.TP
.B [/]<host>:
Any protocol, Named host, Any port
.TP
.B <proto>/
Named protocol, Any host, Any port
.TP
.B <proto>/<host>
Named protocol, Named host, Default port
.TP
.B <proto>/<host>:<port>
Named protocol, Named host, Specified port
.TP
.B <proto>/<host>:
Named protocol, Named host, Any port
.LP
Where [] indicates an optional feature, and <> indicate a user supplied name or
number.
.LP
Several of the sections allow a
.B FILE-SPECIFICATION
to be entered, this is a way of recognising the path part of a URL.
.LP
A
.B FILE-SPECIFICATION
can be either of the following:
.TP
.B /<path>
Any file with a path that start with the specified one.
.TP
.B .<file-ext>
Any file that ends with the specified file extension.
.LP
Where <> indicate a user supplied name or number.
(The '/' or '.' at the start is not optional.)
.LP
.SH EXAMPLE
 StartUp
 {
  http-port     = 8080
  wwwoffle-port = 8081
  spool-dir     = /var/spool/wwwoffle
  use-syslog    = yes
  password      =
 }

 Options
 {
  index-latest-days = 14
  add-info-refresh  = no
  request-changed   = 3600
 }

 FetchOptions
 {
  images      = yes
  frames      = yes
 }

 LocalHost
 {
  localhost
  127.0.0.1
  wwwoffle.foo.com
 }

 LocalNet
 {
  foo.com
 }

 AllowedConnect
 {
  foo.com
 }

 Proxy
 {
  http/foo.com = www-cache.foo.com:8080
 }

 Purge
 {
  default  = 28
  max-size = 10
  bar.com  = 7
 }
.SH FILES
CONFDIR/wwwoffle.conf The wwwoffled(8) configuration file.
.LP
SPOOLDIR The wwwoffle spool directory.
.SH SEE ALSO
wwwoffle(1), wwwoffled(8).
.SH AUTHOR
Andrew M. Bishop 1996,1997,1998 (amb@gedanken.demon.co.uk)
