#!/bin/sh
#
# WWWOFFLE - World Wide Web Offline Explorer - Version 2.2.
#
# A Perl script to update the configuration file to version 2.2 standard.
#
# Written by Andrew M. Bishop
#
# This file Copyright 1998 Andrew M. Bishop
# It may be distributed under the GNU Public License, version 2, or
# any higher version.  See section COPYING of the GNU Public license
# for conditions under which this file may be redistributed.
#

exec perl -x $0 $1

exit 1

#!perl

$#ARGV==0 || die "Usage: $0 wwwoffle.conf\n";

$conf=$ARGV[0];

#

system "mv $conf $conf.old" || die "Cannot rename config file $conf to $conf.old\n";

open(OLD,"<$conf.old") || die "Cannot open old config file $conf.old to read\n";

open(NEW,">$conf") || die "Cannot open new config file $conf to write\n";

#

if(open(INST,"<wwwoffle.conf.install") || open(INST,"<$conf.install"))
  {
   $section=$comment='';

   while(<INST>)
       {
        if(!$section && (/^[ \t]*[\#{]/ || /^[ \t\r\n]*$/))
             {
              $comment.=$_;
              next;
             }

       if(/^[ \t]*}/)
            {
             $section=$comment='';
             next;
            }

        if(!$section && /^[ \t]*([a-zA-Z]+)[ \t\r\n]*$/)
            {
             $section=$1;
             $comment{$section}=$comment;
             $comment='';
            }
       }

   close(INST);
  }
else
  {
   print "Cannot open wwwoffle.conf.install or $conf.install - no new format comments\n";
  }

$comment{"TAIL"}=$comment;

#

$prevsection='';
$section='';

while(<OLD>)
  {
   next if(!$section && (/^[ \t]*[\#{]/ || /^[ \t\r\n]*$/));

   if(/^[ \t]*{/)
       {
        print NEW $_;
        next;
       }

   if(/^[ \t]*}/)
       {
        $prevsection=$section;
        $section='';

        if($prevsection eq "MIMETypes" && !$gotpac)
            {
             print "New MIME Type - application/x-ns-proxy-autoconfig\n";
             print NEW " .pac = application/x-ns-proxy-autoconfig\n";
            }

        print NEW $_;
        next;
       }

   if(!$section && /^[ \t]*([a-zA-Z]+)[ \t\r\n]*$/)
       {
        $section=$1;
        $line=$_;

        if($prevsection eq "Options" && $section ne "FetchOptions")
            {
             print "New Section - FetchOptions\n";
             print NEW $comment{"FetchOptions"};
             print NEW "FetchOptions\n";
             print NEW "{\n";
             print NEW " images = $fetch_images\n" if($fetch_images);
             print NEW " frames = $fetch_frames\n" if($fetch_frames);
             print NEW "}\n";
            }

        print "Section - $section\n";
        print NEW $comment{$section};
        print NEW $line;
        next;
       }

   $line=$_;

   if($section eq "Options") # Changed in version 2.1
       {
        if($line =~ /fetch-images[ \t]*=[ \t]*(yes|no|0|1)/)
            {
             $fetch_images=$1;
             print "Removed Options: fetch-images\n";
            }
        elsif($line =~ /fetch-frames[ \t]*=[ \t]*(yes|no|0|1)/)
            {
             $fetch_frames=$1;
             print "Removed Options: fetch-frames\n";
            }
        elsif($line =~ /request-changed[ \t]*=[ \t]*(yes|no|0|1)/)
            {
             $rhs=-1;
             $rhs=600 if($1 eq "yes" || $1 eq "1");
             print NEW " request-changed = $rhs\n";
             print "Changed Options: request-changed\n";
            }
        else
            {
             print NEW $line;
            }
       }
   elsif($section eq "CensorHeader") # Changed in Version 2.2
       {
        if($line =~ /^[ \t]*([-a-zA-Z0-9]+)[ \t\r\n]*$/)
            {
             print NEW " $1 = \n";
             print "Changed CensorHeader: header line '$1'\n";
            }
        else
            {
             print NEW $line;
            }
       }
   elsif($section eq "MIMETypes") # Added new one in Version 2.2
       {
        $gotpac=1 if($line =~ /^[ \t]*.pac[ \t]*=/);
        print NEW $line;
       }
   else
       {
        print NEW $line;
       }
  }

print NEW $comment{"TAIL"};

#

close(NEW);
close(OLD);
