.\" $Header: /home/amb/wwwoffle/RCS/wwwoffle.man 2.3 1997/12/04 19:55:58 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0.
.\"
.\"  Manual page for wwwoffle
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffle 1 "December 4, 1997"
.SH NAME
wwwoffle \- A program to control the World Wide Web Offline Explorer.
.SH SYNOPSIS
.B wwwoffle
.B \-h
.P
.B wwwoffle
.B \-online
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-offline
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-fetch
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-config
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-purge
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-kill
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-o
.B url
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B url1 [url2 ... url3]
.B [\-d[<depth>] | \-r[<depth>] | \-R[<depth>]]
.B [\-i]
.B [\-f]
.B [\-F]
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B file1 [file2 ... file3]
.B [\-d[<depth>] | \-r[<depth>] | \-R[<depth>]]
.B [\-i]
.B [\-f]
.B [\-F]
.B [\-p <host>[:<port>] | \-c <config-file>]
.SH DESCRIPTION
.I wwwoffle
controls the
.I
World Wide Web Offline Explorer proxy HTTP server.
.LP
The wwwoffle program is used to control the wwwoffled program, to tell it when
the computer is online or offline, and which URLs to get and when to fetch them.
.LP
The control options are also available from the server on an interactive control
web page at http://localhost:8080/control/.
.SH OPTIONS
The command line options available for the program are described below.
.TP
.B \-h
A help message is printed giving a brief description of the usage of the
program.
.TP
.B \-online
Tell the wwwoffled proxy server that the computer is online to the internet and
that requests are to be fetched immediately.
.TP
.B \-offline
Tell the wwwoffled proxy server that the computer is not online to the internet
and that requests are to be cached until they are fetched later.
.TP
.B \-fetch
Tell the wwwoffled proxy server to fetch all of the requests that have been
cached.  (The proxy server must be online for this to work.)  The program will
wait until all of the requests have been met before exiting.
.TP
.B \-config
Tell the wwwoffled proxy server to re-read the configuration file.
.TP
.B \-purge
Tell the wwwoffled proxy server that the cache is to be purged.  The
configuration file wwwoffle.conf(5) specifies the maximum age of the pages to
keep.  If a maximum cache size is specified then the oldest pages are deleted
until the size is not exceeded.
.TP
.B \-kill
Tell the wwwoffled proxy server to exit cleanly at the next convenient point.
.TP
.B url
The URL of a web page that is to be fetched.  This is the same as using a
browser and entering the URL if not already in the cache or pressing the refresh
button in the index if it is in the cache.
.TP
.B file
The name of an HTML file that is to be parsed and the links in it are to be
fetched as if the URLs had been specified on the command line.
.TP
.B \-o
Fetch the specified URL (from the cache or request it if not already cached when
offline, or get it when online) and output it on standard output.  This is an easy
way of getting an image out of the cache to be used in other programs.
.TP
.B \-F
Force the specified URLs to be refreshed.  Without this option, the page will
not be fetched if not newer than the version on the server.
.TP
.B \-r[<depth>]
Causes the pages linked to by the specified URLs also to be fetched if they are
on the same host.
.TP
.B \-R[<depth>]
The same as
.B \-r
above, but it also works for links that are not on the same host.
.TP
.B \-d[<depth>]
The same as
.B \-r
above, but is limited to links in the same directory or a sub-directory.
.TP
.B \-i
Also fetches the images that are included in the specified URLs.
.TP
.B \-f
Also fetches the frames that are included in the specified URLs.
.TP
.B \-c <config-file>
Specifies the name of the configuration file that contains the server host name,
port number and authorisation password.  This is required for the -online,
-offline, -fetch, -config and -purge options if a password is set.  The user
must have read access to the configuration file to be able to use the command if
a password is set.
(See the StartUp and LocalHost section of wwwoffle.conf(5) for more information
on setting the server host name, ports and password.)
.TP
.B \-p <host>[:<port>]
Sets the hostname and port number that is to be ued for the connection to the
proxy server.  For the -online, -offline, -fetch, -config and -purge option this
must be the wwwoffle demon port, for the url options it must be the http proxy
server port.  If no -p option is specified then the compiled in defaults are
used.
.SH SEE ALSO
wwwoffled(8), wwwoffle.conf(5).
.SH AUTHOR
Andrew M. Bishop 1996,1997 (amb@gedanken.demon.co.uk)
