.\" $Header: /home/amb/wwwoffle/RCS/wwwoffle.conf.man 2.7 1997/12/19 20:31:07 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0.
.\"
.\"  Manual page for wwwoffle.conf
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffle.conf 5 "November 25, 1997"
.SH NAME
wwwoffle.conf \- The configuration file for the proxy server for the World Wide Web Offline Explorer.
.SH DESCRIPTION
The
.I wwwoffle.conf
file contains the configuration for the wwwoffled proxy HTTP server part of the
.I
World Wide Web Offline Explorer
program.
.LP
The file is split into sections, each of which has a format similar to a C
function (see the example below).  The section has a name, followed on the next
line by an open brace '{', followed on the next lines by a list of names and
values separated by an equals sign '=', the section ends with a close brace
'}' on a line.  Comments are marked by a '#' at the start of the line.
.LP
The
.B StartUp
section can contain the following:
.TP
.B http-port = <port>
The port number to use on the local host as the HTTP proxy (default=8080).
.TP
.B wwwoffle-port = <port>
The port number to use on the local host as the wwwoffle control port
(default=8081).
.TP
.B spool-dir = <dirname>
The name of the spool directory to use for the cache. A subdirectory is created
in this for each new web server that is contacted (default=/var/spool/wwwoffle).
.TP
.B run-uid = <username> | <uid> | none |
The username of numeric uid to run the wwwoffle server with.  To use this
option, the program must be started by root.
.TP
.B run-gid = <groupname> | <gid> | none |
The groupname of numeric gid to run the wwwoffle server with.  To use this
option, the program must be started by root.
.TP
.B use-syslog = yes | no
The syslog facility can be used to log the important error messages.
(default=yes).
.TP
.B password = <word> | none |
The authorisation password that is required to use the wwwoffle program to
configure the server or use the interactive control page (default=none).  If
this is not present, or set to an empty string or 'none' then there is no
password required.  If there is a password set, then the -c option to wwwoffle
must be used, and the file wwwoffle.conf should be made readable only by
authorised users.
.TP
.B max-servers = <integer>
.B max-fetch-servers = <integer>
The maximum number of servers processes that are started (default=8).  The
maximum number of server processes that are forked to fetch pages that were
requested in offline mode (default = 4).  The
.I max-fetch-servers
value must be less than
.I max-servers
or you will not be able to use wwwoffle interactively online while fetching.
.LP
The
.B Options
section contains other options that configure the server.
.TP
.B log-level = debug | info | important | warning | fatal
The error messages that have a priority the same as that specified or greater
are recorded on the output, either syslog or stderr (see wwwoffled(1)).
.TP
.B fetch-images = yes | no
When pages are requested while offline and downloaded later, there is a choice
of whether to fetch the images from these pages as well (default=no).
.TP
.B fetch-frames = yes | no
When pages are requested while offline and downloaded later, there is a choice
of whether to fetch the frames from these pages as well (default=no).
.TP
.B index-latest-days = <age>
The maximum age in days of pages to show in the index of the latest pages
(default=7).
.TP
.B add-info-refresh = yes | no
The option to add into the bottom of all of the spooled pages the date that the
page was cached and a refresh button (default=no).  This uses the first entry in
the LocalHost section as the server name.
.TP
.B request-changed = yes | no
The option to request changes to pages that are requested while online even if
the page is already in the cache (default=yes).
.TP
.B pragma-no-cache = yes | no
Whether to request a new copy of a page if the request has 'Pragma: no-cache'
(default=yes).  This option should be set to 'no' if when browsing offline all
pages are re-requested by a 'broken' browser.
.LP
The
.B LocalHost
section contains a list of possible names or IP addresses that the host running
wwwoffled may be known as.
.TP
.I hostname
The server may be known as
.I hostname
so does not need to contact itself to get pages.  All of the entries here are
also used as if they were in the LocalNet and AllowConnect sections.  None of
the entries here are fetched via a proxy.
.LP
The
.B LocalNet
section contains a list of host names or IP addresses that are not to be cached
because they are on the local network.
.TP
.I hostname
A server that matches
.I hostname
is on the local network and not to be cached.  The match is done from the right
so that domain names can be used to match all hosts in the domain, IP addresses
match from the left.  All entries here are assumed to be reachable even when
offline.  All of the entries in the LocalHost section are also not cached as if
they were here also.  None of the entries here are fetched via a proxy.
.LP
The
.B AllowedConnect
section contains a list of host names or IP addresses that are allowed to
connect to the server.
.TP
.I hostname
A server that matches
.I hostname
is allowed to connect to the server.  The match is done from the right so that
domain names can be used to match all hosts in the domain, IP addresses match
from the left.  All of the entries in the LocalHost section are also allowed to
connect.
.LP
The
.B DontCache
section contains a way of recognising URLs not to be cached.  They will still
be cached however if it is fetched non-interactively.
.TP
.B default = ...
By default don't cache files that match the right hand side.  Note that
.I default
can occur more than once with different right hand sides.
.TP
.I protocol/ = ...
When using
.I protocol
to access files don't cache files that match the right hand side.
.TP
.I protocol/hostname = ...
When using
.I protocol
to access files from
.I hostname
don't cache files that match the right hand side.  The hostname match is done
from the right so that domain names can be used to match all hosts in the
domain, IP addresses match from the left.
.TP
.I hostname = ...
When getting files from
.I hostname
don't cache files that match the right hand side.  The hostname match is done
from the right so that domain names can be used to match all hosts in the
domain, IP addresses match from the left.
.TP
...  =
.I .file-ext
When getting files from the specified left hand side servers don't cache any
that have
.I file-ext
as the file extension.  The '.' must be specified.
.TP
...  =
.I /path
When getting files from the specified left hand side servers don't cache any
that are in
.I path
or any subdirectory.  The leading '/' must be specified.
.LP
The
.B DontGet
section contains a way of recognising URLs not to be got.  This can be used to
reject junk adverts for example.
.TP
See the DontCache section for a description of the options in this section.
.LP
The
.B DontGetRecursive
section contains a way of recognising URLs not to be got when getting
recursively.
.TP
See the DontCache section for a description of the options in this section.
.LP
The
.B CensorHeader
section contains a list of the header lines that are to be removed from the
request sent from the browser to the server.
.TP
.I header
The lines in the request that start with
.I header
, followed by a ':' are removed before being passed to the server.
.LP
The
.B FTPOptions
section contains the information that is required to be able to do anonymous ftp.
.TP
.B anon-username = <string>
Specifies the username to use to fetch files using ftp (default is "anonymous",
"ftp" is another option).
.TP
.B anon-password = <string>
Specifies the password to use to fetch files using ftp (default is determined
from the user running wwwoffled and the hostname, this may not work reliably
especially if you are behind a firewall).
.LP
The
.B MIMETypes
section is a list of the mime type to associate with files that are not fetched
using HTTP.  This is required by browsers, most browsers come with a list that
can be used here.
.TP
.B default = <mime-type>/<subtype>
The default MIME type to use for files that do not match any of the other rules.
.TP
.I .<file-ext> = <mime-type>/<subtype>
The MIME type to use for files that match the file extension.
.LP
The
.B Proxy
section contains a list of the hosts that are to be served via specified proxy
servers.  If no proxy is required then use 'none' or leave the proxy name blank.
.TP
.B default = <hostname:[port]> | none |
Specifies the default proxy that all requests are to use.
.TP
.I protocol/ = <hostname:[port]> | none |
All servers using accessed using
.I protocol
are to use the specified proxy (unless 'none' is specified).
.TP
.I protocol/hostname = <hostname:[port]> | none |
The server called
.I hostname
accessed using
.I protocol
is to use the specified proxy (unless 'none' is specified).
.TP
.I hostname = <hostname:[port]> | none |
The server called
.I hostname
is to use the specified proxy for all protocols (unless 'none' is specified).
.LP
The hostname match is done from the right so that domain names can be used to
match all hosts in the domain, IP addresses match from the left.
.LP
None of the entries in the LocalHost or LocalNet section are fetched using a
proxy.
.LP
The
.B Mirror
section allows alternate servers to be specified that are to be used in
preference to the one specified in a URL.  This also allows multiple names for
the same server to be linked together so that a single spool directory is used.
.TP
.I protocol1/hostname1 = protocol2/hostname2
When
.I protocol1
is used to access
.I hostname1
the request is modified into a request for
.I hostname2
using
.I protocol2
, the two are also considered identical for the purposes of indexing, purging
and recursive fetching.
.TP
.I hostname1 = hostname2
When
.I hostname1
is accessed the request is modified into a request for
.I hostname2
for any of the protcols, the two are also considered identical for the purposes
of indexing, purging and recursive fetching.
.LP
A symbolic link in the cache between 
.I protocol1/hostname1
and
.I protocol2/hostname2
will have the same effect as specifying them in the config file.  The links are
only checked when wwwoffle starts or when 'wwwoffle -config' is run.
.LP
The
.B Purge
section controls how the cache is purged.  The method to determine which pages
to purge, the default age, the host specific maximum age of the pages in days,
and a maximum allowed cache size.  An age of zero means to always delete when a
purge is done, a negative age means never purge.  The maximum cache size
excludes the files that are from hosts that are marked with a negative maximum
age.
.TP
.B use-mtime = yes | no
The decision of which pages to purge can be made on last access time (atime) or
last modification time (mtime) (default=no).
.TP
.B max-size = <size>
The maximum size of the cache in MB, excluding the hosts that are never to be
purged, if this is zero then it does not apply (default=0).
.TP
.B default = <age>
The age to purge hosts that are not otherwise specified here (default=28).
.TP
.I protocol/ = <age>
The age to purge hosts that use
.I protocol.
.TP
.I hostname = <age>
The age to purge hosts that match
.I hostname.
.TP
.I protocol/hostname = <age>
The age to purge hosts that match
.I hostname
and use
.I protocol.
.LP
The hostname match is done from the right so that domain names can be used to
match all hosts in the domain, IP addresses match from the left.
.LP
.SH EXAMPLE
 StartUp
 {
  http-port     = 8080
  wwwoffle-port = 8081
  spool-dir     = /var/spool/wwwoffle
  use-syslog    = yes
  password      =
 }

 Options
 {
  fetch-images      = yes
  index-latest-days = 14
  add-info-refresh  = no
  request-changed   = yes
 }

 LocalHost
 {
  localhost
  127.0.0.1
  wwwoffle.foo.com
 }

 LocalNet
 {
  foo.com
 }

 AllowedConnect
 {
  foo.com
 }

 Proxy
 {
  http/foo.com = www-cache.foo.com:8080
 }

 Purge
 {
  default  = 28
  max-size = 10
  bar.com  = 7
 }
.SH FILES
CONFDIR/wwwoffle.conf The wwwoffled(8) configuration file.
.LP
SPOOLDIR The wwwoffle spool directory.
.SH SEE ALSO
wwwoffle(1), wwwoffled(8).
.SH AUTHOR
Andrew M. Bishop 1996,1997 (amb@gedanken.demon.co.uk)
