/***************************************
  $Header: /home/amb/wwwoffle/RCS/proto.h 1.4 1997/12/15 19:04:56 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0.
  Information about the protocols that wwwoffle supports.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef PROTO_H
#define PROTO_H    /*+ To stop multiple inclusions. +*/

#include "misc.h"

/*+ A type to contain the information that is required for a particular protocol. +*/
typedef struct _Protocol
{
 int number;                    /*+ The protocol number. +*/
 char *name;                    /*+ The protocol name. +*/

 int defport;                   /*+ The default port number. +*/

 int proxyable;                 /*+ Set to true if any known proxies can understand this. +*/

 char*(*open)(URL*);            /*+ A function to open a connection to a remote server. +*/
 char*(*request)(URL*,char*);   /*+ A function to make a request to the remote server. +*/
 int(*read)(char*,int);         /*+ A function to read the data from the remote server. +*/
 char*(*readline)(char*);       /*+ A function to read a line of data from the remote server. +*/
 int(*close)(void);             /*+ A function to close the connection to the remote server. +*/
}
Protocol;

#define Protocol_HTTP 0         /*+ The http protocol. +*/
#define Protocol_FTP  1         /*+ The ftp protocol. +*/

/* In proto.c */

/*+ The list of protocols. +*/
extern Protocol Protocols[];

/*+ The number of protocols. +*/
extern int NProtocols;

/* In http.c */

char *HTTP_Open(URL *Url);
char *HTTP_Request(URL *Url,char *request);
int   HTTP_Read(char *s,int n);
char *HTTP_ReadLine(char *line);
int   HTTP_Close(void);

/* In ftp.c */

char *FTP_Open(URL *Url);
char *FTP_Request(URL *Url,char *request);
int   FTP_Read(char *s,int n);
char *FTP_ReadLine(char *line);
int   FTP_Close(void);

#endif /* PROTO_H */
