/***************************************
  $Header: /home/amb/wwwoffle/RCS/proto.c 1.5 1997/12/15 19:04:56 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0.
  Information about the protocols that wwwoffle supports.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

#include <stdlib.h>

#include "misc.h"
#include "proto.h"

/* For upgrade-cache and wwwoffle we don't want to link with all
   of the different protocols so we keep them SIMPLE. */

#ifdef SIMPLE

/*+ The list of protocols. +*/
Protocol Protocols[1];

/*+ The number of protocols. +*/
int NProtocols=0;

#else

/*+ The list of protocols. +*/
Protocol Protocols[]={
 {
  Protocol_HTTP,                /* number */
  "http",                       /* name */
  80,                           /* defport */
  1,                            /* proxyable */
  HTTP_Open,                    /* open */
  HTTP_Request,                 /* request */
  HTTP_Read,                    /* read */
  HTTP_ReadLine,                /* readline */
  HTTP_Close                    /* close */
 },
 {
  Protocol_FTP,                 /* number */
  "ftp",                        /* name */
  21,                           /* defport */
  1,                            /* proxyable */
  FTP_Open,                     /* open */
  FTP_Request,                  /* request */
  FTP_Read,                     /* read */
  FTP_ReadLine,                 /* readline */
  FTP_Close                     /* close */
 }
};

/*+ The number of protocols. +*/
int NProtocols=sizeof(Protocols)/sizeof(Protocol);

#endif
