/***************************************
  $Header: /home/amb/wwwoffle/RCS/messages.c 2.12 1998/01/03 09:56:45 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0c.
  Messages that the program sends in reply to requests from browsers
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>

#include "wwwoffle.h"
#include "misc.h"
#include "config.h"


/*++++++++++++++++++++++++++++++++++++++
  A fatal server error occured.

  int fd The file descriptor to report the error to.

  char *string The message string of the error.
  ++++++++++++++++++++++++++++++++++++++*/

void ServerError(int fd,char *string)
{
 char *head=
 "HTTP/1.0 500 WWWOFFLE Server Error\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE - Server Error</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Server Error</H1>\n"
 "<p align=center>\n"
 "The WWWOFFLE server encountered a fatal error\n"
 "<br><b><tt>\n";
 char *tail=
 "\n"
 "</tt></b>\n"
 "</BODY>\n"
 "</HTML>\n";

 write_string(fd,head);
 write_string(fd,string);
 write_string(fd,tail);
}


/*++++++++++++++++++++++++++++++++++++++
  The connection to the remote host failed.

  int fd The file descriptor to send the message to.

  char *url The url that failed.

  char *reason The reason for the error.
  ++++++++++++++++++++++++++++++++++++++*/

void RemoteHostError(int fd,char *url,char *reason)
{
 char *head=
 "HTTP/1.0 503 WWWOFFLE Remote Host Error\r\n" /* This line must not be changed (see wwwoffles.c). */
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE - Remote Host Error</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Remote Host Error</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle=
 "\n"
 "</tt></b><br>\n"
 "failed because\n"
 "<br><b>\n";
 char *tail=
 "</b>\n"
 "</BODY>\n"
 "</HTML>\n";

 write_string(fd,head);
 write_string(fd,url);
 write_string(fd,middle);
 write_string(fd,reason);
 write_string(fd,tail);
}


/*++++++++++++++++++++++++++++++++++++++
  Print the message stating that we will get the URL.

  int fd The file descriptor to send the message to.

  char *url The url we were asked to refresh.
  ++++++++++++++++++++++++++++++++++++++*/

void CantRefreshPosted(int fd,char *url)
{
 char *head=
 "HTTP/1.0 404 WWWOFFLE Cant Refresh Posted\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE - Can't Refresh Posted</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Can't Refresh Posted</H1>\n"
 "<p align=center>\n"
 "Your request to refresh URL\n"
 "<br><b><tt>\n";
 char *tail=
 "\n"
 "</tt></b><br>\n"
 "failed because it is not possible to refresh pages that result from using the POST method.\n"
 "</BODY>\n"
 "</HTML>\n";

 write_string(fd,head);
 write_string(fd,url );
 write_string(fd,tail);
}


/*++++++++++++++++++++++++++++++++++++++
  Print the message stating that we will get the URL.

  int fd The file descriptor to send the message to.

  char *url The url we are going to get.

  int already Set to true if we have already marked this for getting.
  ++++++++++++++++++++++++++++++++++++++*/

void WillGetURL(int fd,char *url,int already)
{
 char *head1=
 "HTTP/1.0 404 WWWOFFLE Will Get\r\n" /* This line must not be changed (see wwwoffle.c, spool.c). */
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE - Will Get ";
 char *head2=
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n";
 char *middle1a=
 "<H1 align=center>WWWOFFLE Request Recorded</H1>\n";
 char *middle1b=
 "<H1 align=center>WWWOFFLE Request Already Recorded</H1>\n";
 char *middle2=
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle3=
 "\n"
 "</tt></b><br>\n";
 char *middle4a=
 "has been recorded for download.\n";
 char *middle4b=
 "has already been recorded for download.\n";
 char *middle5=
 "<p align=center>"
 "[<a href=\"http://%s/control/delete?req=%s\">Cancel</a>"
 "|Refresh|"
 "<a href=\"http://%s/refresh/?%s\">Options</a>]</p>\n";
 char *tail=
 "</BODY>\n"
 "</HTML>\n";
 char *localhost=GetLocalHost(1);

 write_string(fd,head1);
 write_string(fd,url);
 write_string(fd,head2);
 if(!already)
    write_string(fd,middle1a);
 else
    write_string(fd,middle1b);
 write_string(fd,middle2);
 write_string(fd,url);
 write_string(fd,middle3);
 if(!already)
    write_string(fd,middle4a);
 else
    write_string(fd,middle4b);
 write_formatted(fd,middle5,
                 localhost,url,
                 localhost,url);
 write_string(fd,tail);

 free(localhost);
}


/*++++++++++++++++++++++++++++++++++++++
  Print the message redirecting the user to the real URL.

  int fd The file descriptor to send the message to.

  char *url The url we are going to get.
  ++++++++++++++++++++++++++++++++++++++*/

void RefreshRedirect(int fd,char *url)
{
 char *head=
 "HTTP/1.0 301 WWWOFFLE Refresh Redirect\r\n"
 "Content-type: text/html\r\n";
 char *head2=
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE - Refresh Redirect</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Refresh</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle=
 "\n"
 "</tt></b><br>\n"
 "will be refreshed by selecting the link below.\n"
 "<br>\n";
 char *tail=
 "\n"
 "</BODY>\n"
 "</HTML>\n";

 write_string(fd,head);
 write_formatted(fd,"Location: %s\r\n",url);
 write_string(fd,head2);
 write_string(fd,url);
 write_string(fd,middle);
 write_formatted(fd,"<a href=\"%s\">%s</a>",url,url);
 write_string(fd,tail);
}


/*++++++++++++++++++++++++++++++++++++++
  Print the welcome message for the proxy server.

  int fd The file descriptor to send the message to.
  ++++++++++++++++++++++++++++++++++++++*/

void WelcomePage(int fd)
{
 char *head=
 "HTTP/1.0 200 WWWOFFLE Welcome Page\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE Version 2.0 - Proxy Welcome Page</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<p align=center>\n"
 "[Top]&nbsp;\n"
 "<a href=\"#description\">[Description]</a>&nbsp;\n"
 "<a href=\"#indexes\">[Cache&nbsp;Indexes]&nbsp;</a>\n"
 "<a href=\"#request\">[Request&nbsp;Pages]&nbsp;</a>\n"
 "<a href=\"#control\">[Control&nbsp;Program]&nbsp;</a>\n"
 "<a href=\"#links\">[Internet&nbsp;Links]</a>\n"
 "</p>\n"
 "<hr>\n"
 "<H1 align=center><a name=\"top\">WWWOFFLE Proxy Welcome Page</a></H1>\n"
 "The WWWOFFLE programs simplify World Wide Web browsing from computers that use\n"
 "intermittent (dial-up) connections to the internet.\n"
 "<h2><a name=\"description\">Description</a></h2>\n"
 "The wwwoffled program is a simple proxy server with special features for use\n"
 "with dial-up internet links.  This means that it is possible to browse web pages\n"
 "and read them without having to remain connected.\n"
 "<br>\n"
 "While Online\n"
 "<ul>\n"
 "<li>Caching of pages that are viewed for review later.\n"
 "<li>Conditional fetching to only get pages that have changed.\n"
 "</ul>\n"
 "While Offline\n"
 "<ul>\n"
 "<li>The ability to follow links and mark other pages for download.\n"
 "<li>Browser or command line interface to select pages for downloading.\n"
 "<li>Optional info on bottom of pages showing cached date and allowing refresh.\n"
 "<li>Works with pages containing forms.\n"
 "</ul>\n"
 "Automated Download\n"
 "<ul>\n"
 "<li>Downloading of specified pages non-interactively.\n"
 "<li>Can automatically fetch inlined images in pages fetched this way.\n"
 "<li>Can automatically fetch contents of all frames on pages fetched this way.\n"
 "<li>Automatically follows links for pages that have been moved.\n"
 "</ul>\n"
 "Provides\n"
 "<ul>\n"
 "<li>Caching of web pages (http) or ftp sites.\n"
 "<li>An introductory page with information and links to the built-in pages.\n"
 "<li>Multiple indexes of pages stored in cache for easy selection.\n"
 "<li>Interactive or command line control of online/offline status.\n"
 "<li>User selectable purging of pages from cache based on hostname.\n"
 "<li>Interactive or command line option to fetch pages and links recursively.\n"
 "<li>Interactive web page to allow editing of the configuration file.\n"
 "</ul>\n"
 "General\n"
 "<ul>\n"
 "<li>Can be used with one or more external proxies based on hostname.\n"
 "<li>Configurable to still allow use on intranets while offline.\n"
 "<li>Can be configured to block or not cache URLs based on file type or host.\n"
 "<li>Can censor outgoing HTTP headers to maintain user privacy.\n"
 "<li>All options controlled using a simple configuration file.\n"
 "<li>Optional password control for management functions.\n"
 "</ul>\n"
 "<h2><a name=\"indexes\">WWWOFFLE Cache Indexes</a></h2>\n"
 "The index of all of the pages stored in the WWWOFFLE cache is available in a number of formats.\n"
 "<br>\n"
 "The indexes are organised by hostname with a separate list for each host.\n"
 "The basic URL is /index/, but this can be modified with a path as follows.\n"
 "<dl compact>\n"
 "<dt><a href=\"/index/\">/index/</a>\n"
 "<dd>The main index that has links to all of the other indexes.\n"
 "<dt><a href=\"/index/http/?none\">/index/<i>http</i>/</a>\n"
 "<dd>A list of the http pages that are cached (or any other protocol).\n"
 "<dt><a href=\"/index/http/www.gedanken.demon.co.uk/?none\">/index/<i>http</i>/<i>www.gedanken.demon.co.uk</i>/</a>\n"
 "<dd>A list of the http pages that are cached from the host www.gedanken.demon.co.uk (or any other protocol and host).\n"
 "<dt><a href=\"/index/outgoing/?none\">/index/outgoing/</a>\n"
 "<dd>The list of requests waiting to be fetched.\n"
 "<dt><a href=\"/index/latest/\">/index/latest/</a>\n"
 "<dd>An index of all files modified in the last few days sorted by modification time.\n"
 "</dl>\n"
 "<h2><a name=\"request\">WWWOFFLE Single and Recursive Page Requests</a></h2>\n"
 "Pages that are wanted can be fetched by entering them into the browser's own page selector.\n"
 "Or alternatively by using the command line interface or interactively from a web page.\n"
 "<dl compact>\n"
 "<dt><a href=\"/refresh/\">/refresh/</a>\n"
 "<dd>An interactive page for fetching pages.\n"
 "</dl>\n"
 "<h2><a name=\"control\">WWWOFFLE Interactive Control</a></h2>\n"
 "The WWWOFFLE proxy can be controlled either through a command line interface, or interactively from a web page.\n"
 "<dl compact>\n"
 "<dt><a href=\"/control/\">/control/</a>\n"
 "<dd>An interactive page to control the proxy program.\n";
 char *middle=
 "[Requires the password from the configuration file, but any user name.]\n";
 char *tail=
 "</dl>\n"
 "<h2><a name=\"links\">Further WWWOFFLE Links</a></h2>\n"
 "The WWWOFFLE homepage on the internet is available at\n"
 "<a href=\"http://www.gedanken.demon.co.uk/wwwoffle/index.html\">http://www.gedanken.demon.co.uk/wwwoffle/index.html</a>\n"
 "and contains the latest information about the program in general.\n"
 "<p>\n"
 "The latest information about using this version of WWWOFFLE is on the WWWOFFLE Version 2.0 Users Page at\n"
 "<a href=\"http://www.gedanken.demon.co.uk/wwwoffle/version-2.0/user.html\">http://www.gedanken.demon.co.uk/wwwoffle/version-2.0/user.html</a>\n"
 "and contains more information about using this version of the program.\n"
 "<p>\n"
 "You can e-mail the author at <a href=\"mailto:amb@gedanken.demon.co.uk\">amb@gedanken.demon.co.uk</a>,\n"
 "<i>this is helped if you put wwwoffle in the subject line</i>.\n"
 "<hr>\n"
 "<p align=center>\n"
 "<a href=\"#top\">[Top]</a>&nbsp;\n"
 "<a href=\"#description\">[Description]</a>&nbsp;\n"
 "<a href=\"#indexes\">[Cache&nbsp;Indexes]&nbsp;</a>\n"
 "<a href=\"#request\">[Request&nbsp;Pages]&nbsp;</a>\n"
 "<a href=\"#control\">[Control&nbsp;Program]&nbsp;</a>\n"
 "<a href=\"#links\">[Internet&nbsp;Links]</a>\n"
 "</p>\n"
 "</BODY>\n"
 "</HTML>\n";

 write_string(fd,head);
 if(PassWord)
    write_string(fd,middle);
 write_string(fd,tail);
}


/*++++++++++++++++++++++++++++++++++++++
  Print a message that an illegal page has been requested on the proxy server.

  int fd The file descriptor to send the message to.

  char *pathargs The path and args that were specified.
  ++++++++++++++++++++++++++++++++++++++*/

void IllegalPage(int fd,char *pathargs)
{
 char *head=
 "HTTP/1.0 404 WWWOFFLE Illegal Page\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE - Illegal Page</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Illegal Page</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *tail=
 "\n"
 "</tt></b><br>\n"
 "is not a legal URL on the wwwoffle proxy server.\n"
 "<br>\n"
 "<a href=\"/\">WWWOFFLE Proxy Welcome Page</a>\n"
 "</BODY>\n"
 "</HTML>\n";

 write_string(fd,head);
 write_string(fd,pathargs);
 write_string(fd,tail);
}


/*++++++++++++++++++++++++++++++++++++++
  Print a message that an illegal protocol has been requested on the proxy server.

  int fd The file descriptor to send the message to.

  char *url The URL that was requested.

  char *proto The protocol that was specified.
  ++++++++++++++++++++++++++++++++++++++*/

void IllegalProto(int fd,char *url,char *proto)
{
 char *head=
 "HTTP/1.0 404 WWWOFFLE Illegal Protocol\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>WWWOFFLE - Illegal Protocol</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Illegal Page</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle=
 "\n"
 "</tt></b><br>\n"
 "uses the <b><tt>";
 char *tail=
 "</tt></b> protocol which is not supported by the wwwoffle proxy server.\n"
 "</BODY>\n"
 "</HTML>\n";

 write_string(fd,head);
 write_string(fd,url);
 write_string(fd,middle);
 write_string(fd,proto);
 write_string(fd,tail);
}


/*++++++++++++++++++++++++++++++++++++++
  Return a page stating that the requested page has not been modified.

  int fd The file descriptor to write to.
  ++++++++++++++++++++++++++++++++++++++*/

void NotModified(int fd)
{
 char *page=
 "HTTP/1.0 304 WWWOFFLE Not Modified\r\n"
 "\r\n";

 write_string(fd,page);
}
