/***************************************
  $Header: /home/amb/wwwoffle/RCS/http.c 1.7 1997/12/30 16:05:21 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0a.
  Functions for getting URLs using HTTP.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"
#include "misc.h"
#include "config.h"
#include "sockets.h"
#include "proto.h"

/*+ Set to true if we are using a proxy. +*/
static int proxied=0;

/*+ The file descriptor of the server. +*/
static int server=-1;


/*++++++++++++++++++++++++++++++++++++++
  Open a connection to get a URL using HTTP.

  char *HTTP_Open Returns NULL on success, a useful message on error.

  URL *Url The URL to open.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_Open(URL *Url)
{
 char *msg=NULL;
 char *colon;
 char *proxy=WhichProxy(Url->proto,Url->host);
 char *server_host=NULL;
 int server_port=Protocols[Protocol_HTTP].defport;

 proxied=proxy && !IsLocalNetHost(Url->host);

 if(proxied)
   {
    server_host=(char*)malloc(strlen(proxy)+1);
    strcpy(server_host,proxy);
   }
 else
   {
    server_host=(char*)malloc(strlen(Url->host)+1);
    strcpy(server_host,Url->host);
   }

 if((colon=strchr(server_host,':')))
   {
    *colon++=0;
    if(*colon)
       server_port=atoi(colon);
   }

 /* Open the connection. */

 server=OpenClientSocket(server_host,server_port);
 init_buffer(server);

 if(server==-1)
    msg=PrintMessage(Warning,"Cannot open the HTTP connection to %s port %d; [%!s].",server_host,server_port);

 free(server_host);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Write to the server to request the URL.

  char *HTTP_Request Returns NULL on success, a useful message on error.

  URL *Url The URL to get.

  char *request The HTTP request for the URL.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_Request(URL *Url,char *request)
{
 char *msg=NULL;
 char *new_request=request;

 if(!proxied)
    new_request=MakeRequestNonProxy(request);

 if(write_string(server,new_request)==-1)
    msg=PrintMessage(Warning,"Failed to write to remote HTTP %s [%!s].",proxied?"proxy":"server");

 if(!proxied)
    free(new_request);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Read bytes from the source of information for the URL.

  int HTTP_Read Returns the number of bytes read on success, -1 on error.

  char *s A string to fill in with the information.

  int n The number of bytes to read.
  ++++++++++++++++++++++++++++++++++++++*/

int HTTP_Read(char *s,int n)
{
 return(read_data_or_timeout(server,s,n));
}


/*++++++++++++++++++++++++++++++++++++++
  Read a line from the source of information for the URL.

  char *HTTP_ReadLine Returns the next line of data, NULL on EOF.

  char *line The previous line read.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_ReadLine(char *line)
{
 return(read_line_or_timeout(server,line));
}


/*++++++++++++++++++++++++++++++++++++++
  Close a connection opened using HTTP.

  int HTTP_Close Return 0 on success, -1 on error.
  ++++++++++++++++++++++++++++++++++++++*/

int HTTP_Close(void)
{
 return(CloseSocket(server));
}
