/***************************************
  $Header: /home/amb/wwwoffle/RCS/connect.c 2.5 1997/12/14 10:01:19 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0.
  Handle WWWOFFLE connections received by the demon.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <string.h>

#include <signal.h>
#include <unistd.h>

#include "wwwoffle.h"
#include "misc.h"
#include "config.h"
#include "errors.h"


/*+ The server sockets that we listen on +*/
extern int http_fd,             /*+ for the HTTP connections. +*/
           wwwoffle_fd;         /*+ for the WWWOFFLE connections. +*/

/*+ The proxy server that we use. +*/
extern char *proxy;

/*+ The online / offline status. +*/
extern int online;

/*+ The current number active servers +*/
extern int n_servers,           /*+ in total. +*/
           n_fetch_servers;     /*+ fetching a previously requested page. +*/

/*+ The wwwoffle client file descriptor when fetching. +*/
extern int fetch_fd;

/*+ The pids of the servers that are fetching. +*/
extern int fetch_pids[MAX_FETCH_SERVERS];

/*+ The current status, fetching or not. +*/
extern int fetching;


/*++++++++++++++++++++++++++++++++++++++
  Parse a request that comes from wwwoffle.

  int client The file descriptor that corresponds to the wwwoffle connection.
  ++++++++++++++++++++++++++++++++++++++*/

void CommandConnect(int client)
{
 char *line=NULL;

 if(!(line=read_line_or_timeout(client,line)))
   {PrintMessage(Warning,"Nothing to read from the wwwoffle control socket [%!s]."); return;}

 if(strncmp(line,"WWWOFFLE ",9))
   {
    PrintMessage(Warning,"Not a WWWOFFLE command.");
    return;
   }

 if(PassWord || !strncmp(&line[9],"PASSWORD ",9))
   {
    char *password;

    if(strlen(line)<18)
       password="";
    else
      {
       int i;

       for(i=18;line[i];i++)
          if(line[i]=='\r' || line[i]=='\n')
             line[i]=0;

       password=&line[18];
      }

    if(strcmp(password,PassWord))
      {
       write_string(client,"WWWOFFLE Incorrect Password\n");
       PrintMessage(Warning,"Incorrect Password.");
       return;
      }

    if(!(line=read_line_or_timeout(client,line)))
      {PrintMessage(Warning,"Unexpected end of wwwoffle control command [%!s]."); return;}

    if(strncmp(line,"WWWOFFLE ",9))
      {
       PrintMessage(Warning,"Not a WWWOFFLE command.");
       return;
      }
   }

 if(!strncmp(&line[9],"ONLINE",6))
   {
    if(online)
       write_string(client,"WWWOFFLE Already Online\n");
    else
      {
       write_string(client,"WWWOFFLE Now Online\n");
       PrintMessage(Important,"WWWOFFLE Online.");
      }

    online=1;
   }
 else if(!strncmp(&line[9],"OFFLINE",7))
   {
    if(!online)
       write_string(client,"WWWOFFLE Already Offline\n");
    else
      {
       write_string(client,"WWWOFFLE Now Offline\n");
       PrintMessage(Important,"WWWOFFLE Offline.");
      }

    online=0;
   }
 else if(!strncmp(&line[9],"FETCH",5))
   {
    if(fetch_fd!=-1)
       write_string(client,"WWWOFFLE Already fetching.\n");
    else if(!online)
       write_string(client,"WWWOFFLE Must be online to fetch.\n");
    else
       write_string(client,"WWWOFFLE Now Fetching.\n");

    PrintMessage(Important,"WWWOFFLE Fetch.");

    if(fetch_fd==-1 && online)
      {
       fetch_fd=client;
       fetching=1;

       while(n_fetch_servers<MaxFetchServers && n_servers<MaxServers)
          ForkServer(fetch_fd,0);
      }
   }
 else if(!strncmp(&line[9],"CONFIG",6))
   {
    write_string(client,"WWWOFFLE Reading Configuration File.\n");
    PrintMessage(Important,"WWWOFFLE Re-reading Configuration File.");

    if(ReadConfigFile(client))
      {
       PrintMessage(Warning,"Error in configuration file; keeping old values.");
       write_string(client,"WWWOFFLE Error Reading Configuration File.\n");
      }
    else
       write_string(client,"WWWOFFLE Read Configuration File.\n");

    PrintMessage(Important,"WWWOFFLE Finished Re-reading Configuration File.");
   }
 else if(!strncmp(&line[9],"PURGE",5))
   {
    write_string(client,"WWWOFFLE Purge Starting.\n");
    PrintMessage(Important,"WWWOFFLE Purge.");

    PurgeCache(client);

    write_string(client,"WWWOFFLE Purge Finished.\n");
    PrintMessage(Important,"WWWOFFLE Purge finished.");
   }
 else if(!strncmp(&line[9],"KILL",4))
   {
    write_string(client,"WWWOFFLE Kill Signalled.\n");
    PrintMessage(Important,"WWWOFFLE Kill.");

    kill(getpid(),SIGTERM);
   }
 else
   {
    while(line[strlen(line)-1]=='\r' || line[strlen(line)-1]=='\n')
       line[strlen(line)-1]=0;

    write_formatted(client,"WWWOFFLE Unknown Command '%s'.",line);
    PrintMessage(Warning,"Unknown WWWOFFLE control command '%s'.",line);
   }
}


/*++++++++++++++++++++++++++++++++++++++
  Fork a wwwoffles server.

  int client The file descriptor that the data comes in on.

  int browser Set to true if there is a browser connection.
  ++++++++++++++++++++++++++++++++++++++*/

void ForkServer(int client,int browser)
{
 int pid;

 if((pid=fork())==-1)
    PrintMessage(Warning,"Cannot fork a server [%!s].");
 else
   {
    if(pid)                      /* The parent */
      {
       n_servers++;

       if(online && !browser)
         {
          int i;

          for(i=0;i<MaxFetchServers;i++)
             if(fetch_pids[i]==0)
               {fetch_pids[i]=pid;break;}

          n_fetch_servers++;
         }

       PrintMessage(Inform,"Forked wwwoffles -%s (pid=%d).",online?browser?"real":"fetch":"spool",pid);
      }
    else                         /* The child */
      {
       int status;

       if(fetch_fd!=-1 && fetch_fd!=client)
          close(fetch_fd);

       close(http_fd);
       close(wwwoffle_fd);

       status=wwwoffles(online,browser,client);

       exit(status);
      }
   }
}
