/***************************************
  $Header: /home/amb/wwwoffle/RCS/configedit.c 1.3 1997/09/23 18:08:50 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.3.
  Configuration file management via a web-page.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/stat.h>
#include <unistd.h>

#include "config.h"
#include "errors.h"
#include "wwwoffle.h"

static void ConfigEditForms(int fd,char ***sections);
static void ConfigEditUpdate(int fd,char *section,char ***sections);
static void ConfigEditError(int fd,char *msg);

static char ***read_config_file(void);
static int write_config_file(char ***sections);
static void free_sections(char ***sections);


/*++++++++++++++++++++++++++++++++++++++
  The control page that allows editing of the configuration file.

  int fd The file descriptor to write the file to.

  char *args The arguments to the page.

  char *request The complete request for the page.
  ++++++++++++++++++++++++++++++++++++++*/

void ConfigEditPage(int fd,char *args,char *request)
{
 char *newargs=NULL;
 char ***sections;

 if(args)
   {
    if(*args=='!' && strchr(args+1,'!'))
      {
       char *pling;
       newargs=(char*)malloc(strlen(args)+1);
       strcpy(newargs,args+1);
       pling=strchr(newargs,'!');
       *pling=0;
      }
    else if(*args!='!')
      {
       newargs=(char*)malloc(strlen(args)+1);
       strcpy(newargs,args);
      }
   }

 sections=read_config_file();

 if(!sections)
   {
    char *error=
    "Could not open the configuration file <tt>%s</tt> for reading.\n"
    "<p>\n"
    "<b>OR</b>\n"
    "<p>\n"
    "There was a parse error in reading the configuration file <tt>%s</tt>.";
    char *message;
    message=(char*)malloc(strlen(error)+2*strlen(ConfigFile)+1);
    sprintf(message,error,ConfigFile,ConfigFile);
    ConfigEditError(fd,message);
    free(message);
   }
 else if(newargs && *newargs)
   {
    int i=0;
    char *section=NULL;

    while(sections[i])
      {
       if(sections[i][1] && !strcmp(sections[i][1],newargs))
         {section=newargs;break;}
       i++;
      }

    if(!section)
      {
       char *error=
       "The specfied URL <tt>/control/edit?%s</tt> does not correspond to a section in the configuration file <tt>%s</tt>.\n";
       char *message;
       message=(char*)malloc(strlen(error)+strlen(newargs)+strlen(ConfigFile)+1);
       sprintf(message,error,newargs,ConfigFile);
       ConfigEditError(fd,message);
       free(message);
      }
    else
      {
       char *new,*bol=request,*p,*q;

       while((bol=strchr(bol,'\n')))
         {
          bol++;
          if(*bol=='\n' || *bol=='\r')
            {bol=strstr(bol,"value=")+6;break;}
         }

       new=UrlDecode(bol,1);
       for(p=q=new;*p;p++)
          if(*p!='\r')
             *q++=*p;
       *q=0;

       sections[i][2]=new;

       ConfigEditUpdate(fd,section,sections);
      }
   }
 else
    ConfigEditForms(fd,sections);

 if(sections)
    free_sections(sections);

 if(newargs)
    free(newargs);
}


/*++++++++++++++++++++++++++++++++++++++
  The page that contains the forms making up the config file.

  int fd The file descriptor to write to.

  char ***sections The sections of the file.
  ++++++++++++++++++++++++++++++++++++++*/

static void ConfigEditForms(int fd,char ***sections)
{
 char *head=
 "HTTP/1.0 200 WWWOFFLE Configuration Page\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Interactive Configuration Page\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Interactive Configuration Page</H1>\n\n";
 char *sectionhead=
 "\n<h2>%s Section</h2>\n\n";
 char *commenthead=
 "\n<h2>Body Comment</h2>\n\n";
 char *formhead=
 "<form action=\"/control/edit?%s\" method=post>\n"
 "<textarea name=\"value\" cols=60 rows=10>";
 char *formtail=
 "</textarea>\n"
 "<br>\n"
 "<input type=\"submit\" value=\"Update\"><input type=\"reset\" value=\"Reset\">\n"
 "</form>\n";
 char *tail=
 "<h1>Re-Read Configuration File</h1>\n\n"
 "<form action=\"/control/config\" method=post>\n"
 "<input type=\"hidden\" name=action value=\"config\">\n"
 "<input type=\"submit\" value=\"Config\"> Force <b>wwwoffled</b> to re-read the configuration file.\n"
 "</form>\n"
 "</BODY>\n"
 "</HTML>\n";
 int i=0;

 write(fd,head,strlen(head));

 if(sections[i] && sections[i][0])
   {
    char *safe=HTMLString(sections[i][0]);
    write(fd,"<pre>\n",6);
    write(fd,safe,strlen(safe));
    write(fd,"</pre>\n\n",7);
    free(safe);
   }

 while(sections[++i])
   {
    if(sections[i][1])
      {
       char *message;

       message=(char*)malloc(strlen(sectionhead)+strlen(sections[i][1])+1);
       sprintf(message,sectionhead,sections[i][1]);
       write(fd,message,strlen(message));
       free(message);

       if(sections[i][0])
         {
          char *safe=HTMLString(sections[i][0]);
          write(fd,"<pre>\n",6);
          write(fd,safe,strlen(safe));
          write(fd,"</pre>\n\n",7);
          free(safe);
         }

       message=(char*)malloc(strlen(formhead)+strlen(sections[i][1])+1);
       sprintf(message,formhead,sections[i][1]);
       write(fd,message,strlen(message));
       free(message);

       write(fd,sections[i][2],strlen(sections[i][2]));

       write(fd,formtail,strlen(formtail));
      }
    else
      {
       char *safe=HTMLString(sections[i][0]);

       write(fd,commenthead,strlen(commenthead));

       write(fd,"<pre>\n",6);
       write(fd,safe,strlen(safe));
       write(fd,"</pre>\n\n",7);
       free(safe);
      }
   }

 write(fd,tail,strlen(tail));
}


/*++++++++++++++++++++++++++++++++++++++
  Update the configuration file.

  int fd The file descriptor to write the message to.

  char *section The section that was updated.

  char ***sections The sections including the updated one.
  ++++++++++++++++++++++++++++++++++++++*/

static void ConfigEditUpdate(int fd,char *section,char ***sections)
{
 char *head=
 "HTTP/1.0 200 WWWOFFLE Configuration Update Page\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Interactive Configuration Update Page\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Interactive Configuration Update Page</H1>\n\n";
 char *middle=
 "The <b>%s</b> section of the configuration file <tt>%s</tt> has been updated.";
 char *tail=
 "<p align=center>\n"
 "<a href=\"/control/edit/\">[Back to the Configuration edit page]</a>\n"
 "</BODY>\n"
 "</HTML>\n";

 if(write_config_file(sections))
   {
    char *error="Could not open the configuration file <tt>%s</tt> for writing";
    char *message;
    message=(char*)malloc(strlen(error)+strlen(ConfigFile)+1);
    sprintf(message,error,ConfigFile);
    ConfigEditError(fd,message);
    free(message);
   }
 else
   {
    char *message;
    write(fd,head,strlen(head));

    message=(char*)malloc(strlen(middle)+strlen(section)+strlen(ConfigFile)+1);
    sprintf(message,middle,section,ConfigFile);
    write(fd,message,strlen(message));
    free(message);

    write(fd,tail,strlen(tail));
   }
}


/*++++++++++++++++++++++++++++++++++++++
  The error message if the ConfigFile cannot be parsed.

  int fd The file descriptor to write to.

  char *msg The message to print on the error page.
  ++++++++++++++++++++++++++++++++++++++*/

static void ConfigEditError(int fd,char *msg)
{
 char *head=
 "HTTP/1.0 404 WWWOFFLE Configuration Edit Error\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Interactive Configuration Error Page\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Interactive Configuration Error Page</H1>\n\n";
 char *tail=
 "<p align=center>\n"
 "<a href=\"/control/edit/\">[Back to the configuration file editing page]</a>\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 write(fd,msg,strlen(msg));
 write(fd,tail,strlen(tail));
}


/*++++++++++++++++++++++++++++++++++++++
  Read in the config file into a set of sections.

  char ***read_config_file Returns the sections of the file.
                           x[i][0]=comment, x[i][1]=section name, x[i][2]=section contents,
                           the last x[i] is a NULL.
  ++++++++++++++++++++++++++++++++++++++*/

static char ***read_config_file(void)
{
 int sec_num=0,in_comment=0,in_sectionhead=0,in_section=0;
 FILE *conf;
 char ***sections,*text=NULL;
 char *line=NULL;

 conf=fopen(ConfigFile,"r");
 if(!conf)
   {PrintMessage(Warning,"Cannot open the config file '%s' for reading.",ConfigFile); return(NULL);}

 sections=(char***)calloc(1,sizeof(char**));

 while((line=fgets_realloc(line,conf)))
   {
    char *l=line;
    char *r=line+strlen(line)-1;

    while(*l==' ' || *l=='\t' || *l=='\r' || *l=='\n')
       l++;

    if(*l=='#' && !in_comment && !in_section && (in_sectionhead==0 || in_sectionhead==1))
      {
       text=(char*)malloc(strlen(l)+1);
       strcpy(text,l);
       in_sectionhead=0;
       in_comment=1;
       sections=(char***)realloc((void*)sections,sizeof(char**)*(sec_num+2));
       sections[sec_num]=(char**)calloc(3,sizeof(char*));
       sections[++sec_num]=NULL;
      }
    else if(*l=='#' && in_comment)
      {
       text=(char*)realloc((void*)text,strlen(text)+strlen(l)+1);
       strcat(text,l);
      }
    else if(in_comment)
      {
       in_comment=0;
       in_sectionhead=1;
       sections[sec_num-1][0]=text;
       text=NULL;
      }
    else if(!*l && !in_comment && !in_sectionhead && !in_section)
      ;
    else if(!in_comment && !in_sectionhead && !in_section)
      {
       in_sectionhead=1;
      }
    else if(*l=='{' && in_sectionhead==2)
      {
       in_sectionhead=0;
       in_section=1;
       if(!text)
          text=(char*)calloc(1,sizeof(char));
      }
    else if(in_sectionhead && !*l)
      ;
    else if(in_sectionhead==1 && *l=='#')
      {
       text=(char*)malloc(strlen(line)+1);
       strcpy(text,line);
      }
    else if(in_sectionhead==1 && *l!='{')
      {
       while(r>l && (*r==' ' || *r=='\t' || *r=='\r' || *r=='\n'))
          *r--=0;
       in_sectionhead=2;
       sections[sec_num-1][1]=(char*)malloc(strlen(l)+1);
       strcpy(sections[sec_num-1][1],l);
      }
    else if(*l=='}' && in_section)
      {
       in_section=0;
       sections[sec_num-1][2]=text;
       text=NULL;
      }
    else if(in_section && *l!='{')
      {
       text=(char*)realloc((void*)text,strlen(text)+strlen(line)+1);
       strcat(text,line);
      }
    else
      {
       line[strlen(line)-1]=0;
       PrintMessage(Warning,"Error parsing config file, line='%s' [%d,%d,%d]",line,in_comment,in_sectionhead,in_section);
       free_sections(sections);
       return(NULL);
      }
   }

 fclose(conf);

 return(sections);
}


/*++++++++++++++++++++++++++++++++++++++
  Write out a set of sections to the config file.

  int write_config_file Returns 1 if in error.

  char ***sections The sections to write out.
  ++++++++++++++++++++++++++++++++++++++*/

static int write_config_file(char ***sections)
{
 char *conf_file_backup=(char*)malloc(strlen(ConfigFile)+5);
 int renamed=0,i=0;
 struct stat buf;
 FILE *conf;

 /* Rename the old file as a backup. */

 strcpy(conf_file_backup,ConfigFile);
 strcat(conf_file_backup,".old");

 if(rename(ConfigFile,conf_file_backup))
    PrintMessage(Warning,"Cannot rename the config file '%s' to '%s'.",ConfigFile,conf_file_backup);
 else
   {
    renamed=1;
    if(stat(conf_file_backup,&buf))
       PrintMessage(Warning,"Cannot stat the config file '%s'.",ConfigFile);
   }

 conf=fopen(ConfigFile,"w");
 if(!conf)
   {PrintMessage(Warning,"Cannot open the config file '%s' for writing.",ConfigFile); return(1);}

 if(renamed)
   {
    chown(ConfigFile,buf.st_uid,buf.st_gid);
    chmod(ConfigFile,buf.st_mode&(~S_IFMT));
   }

 while(sections[i])
   {
    if(sections[i][0])
      {
       fprintf(conf,sections[i][0]);
       fprintf(conf,"\n");
      }
    if(sections[i][1])
      {
       fprintf(conf,"%s\n",sections[i][1]);
       fprintf(conf,"{\n");
       if(sections[i][2])
          fprintf(conf,sections[i][2]);
       if(sections[i][2][strlen(sections[i][2])-1]!='\n')
          fprintf(conf,"\n");
       fprintf(conf,"}\n\n");
      }
    i++;
   }

 fclose(conf);

 free(conf_file_backup);

 return(0);
}


/*++++++++++++++++++++++++++++++++++++++
  Free up a set of sections.

  char ***sections The sections that are to be freed up.
  ++++++++++++++++++++++++++++++++++++++*/

static void free_sections(char ***sections)
{
 int i=0;

 while(sections[i])
   {
    if(sections[i][0])
       free(sections[i][0]);
    if(sections[i][1])
       free(sections[i][1]);
    if(sections[i][2])
       free(sections[i][2]);
    free(sections[i]);
    i++;
   }

 free(sections);
}
