/***************************************
  $Header: /home/amb/wwwoffle/RCS/config.h 1.21 1997/08/23 15:56:57 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.2e.
  Configuration file management functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef CONFIG_H
#define CONFIG_H    /*+ To stop multiple inclusions. +*/

/*+ The name of the configuration file. +*/
extern char *ConfigFile;

/* StartUp section */

/*+ The port number to use for the HTTP proxy port. +*/
extern int HTTP_Port;

/*+ The port number to use for the wwwoffle port. +*/
extern int WWWOFFLE_Port;

/*+ The spool directory. +*/
extern char *SpoolDir;

/*+ The user id for wwwoffled or -1 for none. +*/
extern int WWWOFFLE_Uid;

/*+ The group id for wwwoffled or -1 for none. +*/
extern int WWWOFFLE_Gid;

/*+ Whether to use the syslog facility or not. +*/
extern int UseSyslog;

/*+ The password required for demon configuration. +*/
extern char *PassWord;

/*+ Maximum number of servers  +*/
extern int MaxServers;          /*+ in total. +*/
extern int MaxFetchServers;     /*+ for fetching. +*/

/* Options Section */

/*+ The level of error logging, see ErrorLevel in errors.h +*/
extern int LogLevel;

/*+ The option to also fetch images. +*/
extern int FetchImages;

/*+ The option to also fetch frames. +*/
extern int FetchFrames;

/*+ The number of days to display in the index of the latest pages. +*/
extern int IndexLatestDays;

/*+ The option of a tag that can be added to the bottom of the spooled pages with the date and a refresh button. +*/
extern int AddInfoRefresh;

/*+ The option to always request the server for changes when it is the cache and online. +*/
extern int RequestChanged;

/* Purge section */

/*+ If true then use modification time instead of access time. +*/
extern int PurgeUseMTime;

/*+ The default age for purging files. +*/
extern int DefaultPurgeAge;

/*+ The maximum allowed size of the cache. +*/
extern int PurgeCacheSize;


/* In config.h */

int ReadConfigFile(int fd);

/* LocalHost section */

char *GetLocalHost(void);
int IsLocalHost(char *host);

/* LocalNet section */

int IsLocalNetHost(char *host);

/* AllowedConnect section */

int IsAllowedConnect(char *host);

/* DontCache section */

int IsNotCached(char *host,char *path);

/* DontGet section */

int IsNotGot(char *host,char *path);

/* CensorHeader section */

int IsCensoredHeader(char *line);

/* Proxy section */

char *WhichProxy(char *host);

/* Purge section */

int WhatPurgeAge(char *host);

#endif /* CONFIG_H */
