.\" $Header: /home/amb/wwwoffle/RCS/wwwoffle.conf.man 1.27 1997/07/09 18:59:22 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 1.2c.
.\"
.\"  Manual page for wwwoffle.conf
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffle.conf 5 "July 9, 1997"
.SH NAME
wwwoffle.conf \- The configuration file for the proxy server for the World Wide Web Offline Explorer.
.SH DESCRIPTION
The
.I wwwoffle.conf
file contains the configuration for the wwwoffled proxy HTTP server part of the
.I
World Wide Web Offline Explorer
program.
.LP
The file is split into sections, each of which has a format similar to a C
function (see the example below).  The section has a name, followed on the next
line by an open brace '{', followed on the next lines by a list of names and
values separated by an equals sign '=', the section ends with a close brace
'}' on a line.  Comments are marked by a '#' at the start of the line.
.LP
The
.B StartUp
section can contain the following:
.TP
.B http-port = <port>
The port number to use on the local host as the HTTP proxy (default=8080).
.TP
.B wwwoffle-port = <port>
The port number to use on the local host as the wwwoffle control port
(default=8081).
.TP
.B spool-dir = <dirname>
The name of the spool directory to use for the cache. A subdirectory is created
in this for each new web server that is contacted (default=/var/spool/wwwoffle).
.TP
.B run-uid = <username> | <uid> | none |
The username of numeric uid to run the wwwoffle server with.  To use this
option, the program must be started by root.
.TP
.B run-gid = <groupname> | <gid> | none |
The groupname of numeric gid to run the wwwoffle server with.  To use this
option, the program must be started by root.
.TP
.B use-syslog = yes | no
The syslog facility can be used to log the important error messages.
(default=yes).
.TP
.B password = <word> | none |
The authorisation password that is required to use the wwwoffle program to
configure the server or use the interactive control page (default=none).  If
this is not present, or set to an empty string or 'none' then there is no
password required.  If there is a password set, then the -c option to wwwoffle
must be used, and the file wwwoffle.conf should be made readable only by
authorised users.
.LP
The
.B Options
section contains other options that configure the server.
.TP
.B fetch-images = yes | no
When pages are requested while offline and downloaded later, there is a choice
of whether to fetch the images from these pages as well (default=no).
.TP
.B fetch-frames = yes | no
When pages are requested while offline and downloaded later, there is a choice
of whether to fetch the frames from these pages as well (default=no).
.TP
.B index-latest-days = <age>
The maximum age in days of pages to show in the index of the latest pages
(default=7).
.TP
.B add-info-refresh = yes | no
The option to add into the bottom of all of the spooled pages the date that the
page was cached and a refresh button (default=no).  This uses the first entry in
the LocalHost section as the server name.
.TP
.B request-changed = yes | no
The option to request changes to pages that are requested while online even if
the page is already in the cache (default=yes).
.LP
The
.B LocalHost
section contains a list of possible names or IP addresses that the host running
wwwoffled may be known as.
.TP
.I hostname
The server may be known as
.I hostname
so does not need to contact itself to get pages.  All of the entries here are
also used as if they were in the LocalNet and AllowConnect sections.  None of
the entries here are fetched via a proxy.
.LP
The
.B LocalNet
section contains a list of host names or IP addresses that are not to be cached
because they are on the local network.
.TP
.I hostname
A server that matches
.I hostname
is on the local network and not to be cached.  The match is done from the right
so that domain names can be used to match all hosts in the domain, IP addresses
match from the left.  All entries here are assumed to be reachable even when
offline.  All of the entries in the LocalHost section are also not cached as if
they were here also.  None of the entries here are fetched via a proxy.
.LP
The
.B AllowedConnect
section contains a list of host names or IP addresses that are allowed to
connect to the server.
.TP
.I hostname
A server that matches
.I hostname
is allowed to connect to the server.  The match is done from the right so that
domain names can be used to match all hosts in the domain, IP addresses match
from the left.  All of the entries in the LocalHost section are also allowed to
connect.
.LP
The
.B DontCache
section contains a way of recognising URLs not to be cached.  They will still
be cached however if it is fetched non-interactively.
.TP
.I host = <host>
All pages from the specified hostname are not cached.
The match is done from the right so that domain names can be used to
match all hosts in the domain, IP addresses match from the left.
.TP
.I file-ext = <ext>
A file that has an extension that matches the one specified is not cached.
.TP
.I hostname = <path>
All pages from the specified path on the specified host are not cached.
The match is done from the right so that domain names can be used to
match all hosts in the domain, IP addresses match from the left.  The path
matches the start of the specified URL path.
.LP
The
.B DontGet
section contains a way of recognising URLs not to be got.
.TP
.I host = <host>
All pages from the specified hostname are not got.
The match is done from the right so that domain names can be used to
match all hosts in the domain, IP addresses match from the left.
.TP
.I file-ext = <ext>
A file that has an extension that matches the one specified is not got.
.TP
.I hostname = <path>
All pages from the specified path on the specified host are not got.
The match is done from the right so that domain names can be used to
match all hosts in the domain, IP addresses match from the left.  The path
matches the start of the specified URL path.  This allows sites that provide
only junk adverts to be ignored.
.LP
The
.B CensorHeader
section contains a list of the header lines that are to be removed from the
request sent from the browser to the server.
.TP
.I header
The lines in the request that start with
.I header
, followed by a ':' are removed before being passed to the server.
.LP
The
.B Proxy
section contains a list of the hosts that are to be served via specified proxy
servers.  If no proxy is required then use 'none' or leave the proxy name blank.
.TP
.B default = <hostname:[port]> | none |
The name of a default external proxy server to route all requests through unless
a specific proxy applies (default=none).
.TP
.I host = <hostname:[port]> | none |
The server called
.I host
is to use the specified proxy instead of the default.  The match is done from
the right so that domain names can be used to match all hosts in the domain, IP
addresses match from the left.  None of the entries in the LocalHost or LocalNet
section are fetched using a proxy.
.LP
The
.B Purge
section controls how the cache is purged.  The method to determine which pages
to purge, the default age, the host specific maximum age of the pages in days,
and a maximum allowed cache size.  An age of zero means to always delete when a
purge is done, a negative age means never purge.  The maximum cache size
excludes the files that are from hosts that are marked with a negative maximum
age.
.TP
.B use-mtime = yes | no
The decision of which pages to purge can be made on last access time (atime) or
last modification time (mtime) (default=no).
.TP
.B default = <age>
The age to purge hosts that are not otherwise specified here (default=28).
.TP
.I hostname = <age>
The age to purge hosts that match
.I hostname.
The match is done from the right so that domain names can be used to match all
hosts in the domain, IP addresses match from the left.
.TP
.B max-size = <size>
The maximum size of the cache in MB, excluding the hosts that are never to be
purged, if this is zero then it does not apply (default=0).
.LP
.SH EXAMPLE
 StartUp
 {
  http-port     = 8080
  wwwoffle-port = 8081
  spool-dir     = /var/spool/wwwoffle
  use-syslog    = yes
  password      =
 }

 Options
 {
  fetch-images      = yes
  index-latest-days = 14
  add-info-refresh  = no
  request-changed   = yes
 }

 LocalHost
 {
  localhost
  127.0.0.1
  bar.foo.com
 }

 LocalNet
 {
  foo.com
 }

 AllowedConnect
 {
  foo.com
 }

 Proxy
 {
  default = none
  foo.com = www-cache.foo.com:8080
 }

 Purge
 {
  default  = 28
  bar.com  = 7
  max-size = 10
 }
.SH FILES
/var/spool/wwwoffle/wwwoffle.conf The wwwoffled(8) configuration file.
.SH SEE ALSO
wwwoffle(1), wwwoffled(8).
.SH AUTHOR
Andrew M. Bishop 1996,1997 (amb@gedanken.demon.co.uk)
