W               [ \t\r\n]
F               [-a-z0-9$_.!*''(),%;/?:@&=+~]

%x HEADER
%x COMMENT
%x ANGLE_START ANGLE
%x IMAGE IMAGE_SRC
%x BODY BODY_BACK
%x ANCHOR ANCHOR_HREF
%x LINK LINK_HREF
%x FRAME FRAME_SRC

%{
/***************************************
  $Header: /home/amb/wwwoffle/RCS/html.l 1.14 1997/07/17 06:22:38 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.2c.
  Parse the HTML and look for the images, links and end of body.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "wwwoffle.h"

#if 0
int main()
{
 char **list=NULL;
 int i;

 ParseHTML(stdin,"foo","bar/");

 if((list=ListImages()))
    for(i=0;list[i];i++)
       printf("Image: %s\n",list[i]);

 if((list=ListLinks()))
    for(i=0;list[i];i++)
       printf("Link : %s\n",list[i]);

 if((list=ListFrames()))
    for(i=0;list[i];i++)
       printf("Frame: %s\n",list[i]);
}
#endif

extern FILE* yyin;
extern int yylex(void);
#define yywrap() 1

/*+ The type of reference that has been found. +*/
typedef enum _RefType
{
 Image,                         /*+ An inlined image. +*/
 Link,                          /*+ A link to another page. +*/
 Frame                          /*+ The contents of a frame. +*/
}
RefType;

static void free_list(RefType type);
static char **get_list(RefType type);
static void add_reference(char* name,RefType type);
static void canonicalise_references(RefType type);

/*+ If the file is parsed as an HTML file. +*/
static int is_html=0;

/*+ The list of images. +*/
static char **images=NULL;

/*+ The number of images. +*/
static int nimages=0;

/*+ The list of links. +*/
static char **links=NULL;

/*+ The number of links. +*/
static int nlinks=0;

/*+ The list of frames. +*/
static char **frames=NULL;

/*+ The number of frames. +*/
static int nframes=0;

/*+ Just before the end of body tag (or the end of html tag (or end of file)). +*/
static int body_or_html_end=0;

/*+ The host that this is referenced from. +*/
static char *refhost=NULL;

/*+ The path that this is referenced from. +*/
static char *refpath=NULL;


/*++++++++++++++++++++++++++++++++++++++
  Parse the HTML and look for references to image/links/frames.

  int ParseHTML Returns 1 if it was parsed as an HTML file.

  FILE *file The file to parse.

  char *host The name of the host.

  char *path The name of the path.
  ++++++++++++++++++++++++++++++++++++++*/

int ParseHTML(FILE *file,char *host,char *path)
{
 refhost=host;
 refpath=path;

 is_html=0;
 body_or_html_end=0;

 free_list(Image);
 free_list(Link);
 free_list(Frame);

 yyin=file;
 yyrestart(yyin);
 yylex();

 add_reference(NULL,Image);
 add_reference(NULL,Link);
 add_reference(NULL,Frame);

 return(is_html);
}


/*++++++++++++++++++++++++++++++++++++++
  Return the list of references.

  char **ListImages Returns a null terminated list of images.
  ++++++++++++++++++++++++++++++++++++++*/

char **ListImages(void)
{
 return(get_list(Image));
}


/*++++++++++++++++++++++++++++++++++++++
  List the links found in the HTML file.

  char **ListLinks Returns a null terminated list of links.
  ++++++++++++++++++++++++++++++++++++++*/

char **ListLinks(void)
{
 return(get_list(Link));
}


/*++++++++++++++++++++++++++++++++++++++
  List the frames found in the HTML file.

  char **ListFrames Returns a null terminated list of frames.
  ++++++++++++++++++++++++++++++++++++++*/

char **ListFrames(void)
{
 return(get_list(Frame));
}


/*++++++++++++++++++++++++++++++++++++++
  Return the position of the end of the html in the document.

  int GetHTMLEnd Returns the position of the end of the html.
  ++++++++++++++++++++++++++++++++++++++*/

int GetHTMLEnd(void)
{
 return(body_or_html_end);
}


/*++++++++++++++++++++++++++++++++++++++
  Free up a list of references.

  RefType type The type of list that is to be freed.
  ++++++++++++++++++++++++++++++++++++++*/

static void free_list(RefType type)
{
 char ***list=NULL;
 int *nlist=0;

 switch(type)
   {
   case Image:
    list=&images;
    nlist=&nimages;
    break;
   case Link:
    list=&links;
    nlist=&nlinks;
    break;
   case Frame:
    list=&frames;
    nlist=&nframes;
    break;
   }

 if(*list)
   {
    int i;
    for(i=0;(*list)[i];i++)
       free((*list)[i]);
    free(*list);
   }

 *list=NULL;
 *nlist=0;
}


/*++++++++++++++++++++++++++++++++++++++
  Get a list of the references of the specified type.

  char **get_list Returns the list of URLs.

  RefType type The type of list that is required.
  ++++++++++++++++++++++++++++++++++++++*/

static char **get_list(RefType type)
{
 char ***list=NULL;

 switch(type)
   {
   case Image:
    list=&images;
    break;
   case Link:
    list=&links;
    break;
   case Frame:
    list=&frames;
    break;
   }

 if(*list)
    canonicalise_references(type);

 return(*list);
}


/*++++++++++++++++++++++++++++++++++++++
  A function to add a name to the list of references.

  char* name The name to add.

  RefType type The type of reference.
  ++++++++++++++++++++++++++++++++++++++*/

static void add_reference(char* name,RefType type)
{
 char ***list=NULL;
 int *nlist=0;

 if(name)
   {
    char *colon=strchr(name,':');

    if(colon)
      {
       char *slash=strchr(name,'/');

       if((!slash || slash>colon) && strncasecmp("http:",name,5))
          return;
      }
   }

 switch(type)
   {
   case Image:
    list=&images;
    nlist=&nimages;
    break;
   case Link:
    list=&links;
    nlist=&nlinks;
    break;
   case Frame:
    list=&frames;
    nlist=&nframes;
    break;
   }

 if((*nlist)==0)
    (*list)=(char**)malloc(16*sizeof(char*));
 else if(((*nlist)%16)==0)
    (*list)=(char**)realloc((*list),((*nlist)+16)*sizeof(char*));

 if(name)
   {
    (*list)[(*nlist)]=(char*)malloc(strlen(name)+1);
    strcpy((*list)[(*nlist)],name);
   }
 else
    (*list)[(*nlist)]=NULL;

 (*nlist)++;
}


/*++++++++++++++++++++++++++++++++++++++
  Fix the list up with canonical URLs not the relative ones.

  RefType type The type of reference.
  ++++++++++++++++++++++++++++++++++++++*/

static void canonicalise_references(RefType type)
{
 char ***list=NULL;
 int *nlist=0;
 int i,j;

 switch(type)
   {
   case Image:
    list=&images;
    nlist=&nimages;
    break;
   case Link:
    list=&links;
    nlist=&nlinks;
    break;
   case Frame:
    list=&frames;
    nlist=&nframes;
    break;
   }

 for(i=0;(*list)[i];i++)
   {
    char **item=&(*list)[i];
    char *name=*item;

    if(strncasecmp("http:",name,5))
      {
       if(*name=='/')
         {
          *item=(char*)malloc(strlen(refhost)+strlen(name)+8);
          sprintf(*item,"http://%s%s",refhost,name);
         }
       else
         {
          int i=0,j;
          char *path=(char*)malloc(strlen(refpath)+1);

          strcpy(path,refpath);

          for(j=strlen(path);j>0;j--)
             if(path[j]=='/')
                break;
          path[j]=0;

          while(name[i]=='.')
            {
             if(!strncmp("./",&name[i],2))
                i+=2;
             else if(!strncmp("../",&name[i],3))
               {
                i+=3;
                for(j=strlen(path)-1;j>0;j--)
                   if(path[j]=='/')
                      break;
                path[j]=0;
               }
            }

          *item=(char*)malloc(strlen(refhost)+strlen(path)+strlen(&name[i])+12);
          if(*path)
             sprintf(*item,"http://%s/%s/%s",refhost,path,&name[i]);
          else
             sprintf(*item,"http://%s/%s",refhost,&name[i]);
          free(path);
         }

       free(name);
      }
   }

 /* remove the duplicates */

 for(i=0;(*list)[i];i++)
   {
    for(j=i+1;(*list)[j];j++)
       if(!strcmp((*list)[i],(*list)[j]))
          break;

    if((*list)[j])
      {
       free((*list)[j]);
       do
         {
          (*list)[j]=(*list)[j+1];
         }
       while((*list)[j++]);
       i--;
       (*nlist)--;
      }
   }
}

%}

%%
 int open_angle=0,position=0,html_end=0,body_end=0;
 BEGIN(HEADER);

<HEADER>\r*\n                                           { if(is_html) BEGIN(INITIAL); else return(EOF); }
<HEADER>"content-type:"[ \t]+"text/html"[ \t]*\r*\n     { is_html=1; }
<HEADER>.+\r*\n                                         { }


[^<]+                                   { position+=yyleng; }
"<!--"                                  { position+=yyleng; BEGIN(COMMENT); }
"<"{W}*                                 { position+=yyleng; BEGIN(ANGLE_START); open_angle=yyleng; }


<COMMENT>">"                            { position+=yyleng; BEGIN(INITIAL); }
<COMMENT>[^>]+                          { position+=yyleng; }


<ANGLE_START>"img"{W}                   { position+=yyleng; BEGIN(IMAGE); }
<ANGLE_START>"body"{W}                  { position+=yyleng; BEGIN(BODY); }
<ANGLE_START>"a"{W}                     { position+=yyleng; BEGIN(ANCHOR); }
<ANGLE_START>"link"{W}                  { position+=yyleng; BEGIN(LINK); }
<ANGLE_START>"frame"{W}                 { position+=yyleng; BEGIN(FRAME); }
<ANGLE_START>"/body"                    { position+=yyleng; BEGIN(ANGLE); body_end=position-yyleng-open_angle; }
<ANGLE_START>"/html"                    { position+=yyleng; BEGIN(ANGLE); html_end=position-yyleng-open_angle; }
<ANGLE_START>">"                        { position+=yyleng; BEGIN(INITIAL); }
<ANGLE_START>.                          { position+=yyleng; BEGIN(ANGLE); }


<ANGLE>">"                              { position+=yyleng; BEGIN(INITIAL); }
<ANGLE>[^>]+                            { position+=yyleng; }


<IMAGE>">"                              { position+=yyleng; BEGIN(INITIAL); }
<IMAGE>"src"{W}*"="{W}*"\""*            { position+=yyleng; BEGIN(IMAGE_SRC); }
<IMAGE>.|\n                             { position+=yyleng; }
<IMAGE_SRC>{F}+                         { position+=yyleng; BEGIN(IMAGE); add_reference(yytext,Image); }
<IMAGE_SRC>.                            { position+=yyleng; BEGIN(IMAGE); }


<BODY>">"                               { position+=yyleng; BEGIN(INITIAL); }
<BODY>"background"{W}*"="{W}*"\""*      { position+=yyleng; BEGIN(BODY_BACK); }
<BODY>.|\n                              { position+=yyleng; }
<BODY_BACK>{F}+                         { position+=yyleng; BEGIN(BODY); add_reference(yytext,Image); }
<BODY_BACK>.                            { position+=yyleng; BEGIN(BODY); }


<ANCHOR>">"                             { position+=yyleng; BEGIN(INITIAL); }
<ANCHOR>"href"{W}*"="{W}*"\""*          { position+=yyleng; BEGIN(ANCHOR_HREF); }
<ANCHOR>.|\n                            { position+=yyleng; }
<ANCHOR_HREF>{F}+                       { position+=yyleng; BEGIN(ANCHOR); add_reference(yytext,Link); }
<ANCHOR_HREF>.                          { position+=yyleng; BEGIN(ANCHOR); }


<LINK>">"                               { position+=yyleng; BEGIN(INITIAL); }
<LINK>"href"{W}*"="{W}*"\""*            { position+=yyleng; BEGIN(LINK_HREF); }
<LINK>.|\n                              { position+=yyleng; }
<LINK_HREF>{F}+                         { position+=yyleng; BEGIN(LINK); add_reference(yytext,Link); }
<LINK_HREF>.                            { position+=yyleng; BEGIN(LINK); }


<FRAME>">"                              { position+=yyleng; BEGIN(INITIAL); }
<FRAME>"src"{W}*"="{W}*"\""*            { position+=yyleng; BEGIN(FRAME_SRC); }
<FRAME>.|\n                             { position+=yyleng; }
<FRAME_SRC>{F}+                         { position+=yyleng; BEGIN(FRAME); add_reference(yytext,Frame); }
<FRAME_SRC>.                            { position+=yyleng; BEGIN(FRAME); }


<<EOF>>                                 { if(body_end && html_end && (html_end-body_end)<16 && (position-html_end)<16)
                                             body_or_html_end=body_end;
                                          else if(body_end && (position-body_end)<16)
                                             body_or_html_end=body_end;
                                          else if(html_end && (position-html_end)<16)
                                             body_or_html_end=html_end;
                                          else
                                             body_or_html_end=position;
                                          return(EOF); }

%%
