/***************************************
  $Header: /home/amb/wwwoffle/RCS/errors.h 1.7 1997/07/06 09:18:56 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.2c.
  Error logging header file.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef ERRORS_H
#define ERRORS_H    /*+ To stop multiple inclusions. +*/

/*+ For debugging messages set to 1, else leave at 0. +*/
#define DEBUG 1

typedef enum _ErrorLevel
{
 Debug,                         /*+ For debugging, only if DEBUG is defined (not in syslog). +*/
 Inform,                        /*+ General information (not in syslog). +*/
 Important,                     /*+ Important information (notice in syslog). +*/
 Warning,                       /*+ A warning (warning in syslog). +*/
 Fatal                          /*+ A fatal error (err in syslog). +*/
}
ErrorLevel;

/* In errors.c */

void InitErrorHandler(char *name,int syslogable,int stderrable);
void PrintMessage(ErrorLevel errlev,char* fmt, ...);

#endif /* ERRORS_H */
