/***************************************
  $Header: /home/amb/wwwoffle/RCS/wwwoffle.h 1.23 1997/06/26 16:07:32 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.2b.
  A header file for all of the programs wwwoffle, wwwoffled.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef WWWOFFLE_H
#define WWWOFFLE_H    /*+ To stop multiple inclusions. +*/

#include <stdio.h>

/*+ The default port number to use for the http proxy demon. +*/
#define DEF_HTTP_PORT 8080

/*+ The default port number to use for the wwwoffle control. +*/
#define DEF_WWWOFFLE_PORT 8081

/*+ The default spool directory. +*/
#define DEF_SPOOL "/var/spool/wwwoffle"

/*+ The default age of pages in days before purging. +*/
#define DEF_PURGE_AGE 14

/*+ The maximum number of servers to fork in total. +*/
#define MAX_SERVERS 8

/*+ The maximum number of servers to fork for fetching previously requested pages. +*/
#define MAX_FETCH_SERVERS 4

/*+ The character to use to replace '/' in the spool directories. +*/
#define PATH_SEP '%'

/*+ The time in seconds to wait while reading from a socket. +*/
#define SOCKET_TIMEOUT 120

/* In connect.c */

void CommandConnect(FILE *client);
void ForkServer(int client,int browser);

/* In purge.c */

void PurgeCache(int fd);

/* In spool.c */

int OpenOutgoingSpoolFile(int rw);
void CloseOutgoingSpoolFile(int fd);
int OpenWebpageSpoolFile(int rw,char *host,char *path,char *args);

/* In parse.c */

char *ParseRequest(FILE *req,char **url);
int RequestChanges(int fd,char **request);
char *RequestMoved(char *request,char *reply,char *host,char *path);
char *RequestURL(char *url,char *referer);
void MakeRequestNonProxy(char *url,char *path,char *args,char **request);
char *ParseReply(int rep,int *status,int *length);
void SplitURL(char *url,char **host,char **path,char **args);
unsigned long MakeHashFromArgs(char *args);
char *RFC822Date(long t,int utc);
char *UrlDecode(char *str);
char *UrlEncode(char *str);

/* In messages.c */

void ServerError(int fd,char *string);
void RemoteHostError(int fd,char *url,char *reason);
void CantRefreshPosted(int fd,char *url);
void WillGetURL(int fd,char *url,int already);
void RefreshRedirect(int fd,char *url);
void WelcomePage(int fd,int password);
void IllegalPage(int fd,char *path,char *args);

/* In index.c */

void IndexPage(int fd,char *path,char *args);

/* In control.c */

void ControlPage(int fd,char *path,char *request);

/* In refresh.c */

char *RefreshPage(int fd,char *path,char *args,char *url,char **request,int is_online);

/* In html.c (html.l) */

int ParseHTML(FILE *file,char *host,char *path);
char **ListImages(void);
char **ListLinks(void);
int GetHTMLEnd(void);

/* In io.c */

char *fgets_realloc(char *buffer,FILE *file);
int ReadOrTimeout(int fd,char *buffer,int n);

/* In wwwoffles.c */

int wwwoffles(int online,int browser,int client);

#endif /* WWWOFFLE_H */
