.\" $Header: /home/amb/wwwoffle/RCS/wwwoffle.man 1.12 1997/03/22 21:27:21 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 1.1.
.\"
.\"  Manual page for wwwoffle
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffle 1 "March 10, 1997"
.SH NAME
wwwoffle \- A program to control the World Wide Web Offline Explorer.
.SH SYNOPSIS
.B wwwoffle
.B \-h
.P
.B wwwoffle
.B \-online
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-offline
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-fetch
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-config
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B \-purge
.B [\-p <host>[:<port>] | \-c <config-file>]
.P
.B wwwoffle
.B url
.B [\-p <host>[:<port>]]
.B [\-i]
.B [\-r[<depth>] | \-R[<depth>]]
.SH DESCRIPTION
.I wwwoffle
controls the
.I
World Wide Web Offline Explorer proxy HTTP server.
.LP
The wwwoffle program is used to control the wwwoffled program, to tell it when
the computer is online or offline, and which URLs to get and when to fetch them.
.LP
The control options are also available from the server on an interactive control
web page at http://localhost:8080/control/.
.SH OPTIONS
The command line options available for the program are described below.
.TP
.B \-h
A help message is printed giving a brief description of the usage of the
program.
.TP
.B \-online
Tell the wwwoffled proxy server that the computer is online to the internet and
that requests are to be fetched immediately.
.TP
.B \-offline
Tell the wwwoffled proxy server that the computer is not online to the internet
and that requests are to be cached until they are fetched later.
.TP
.B \-fetch
Tell the wwwoffled proxy server to fetch all of the requests that have been
cached.  (The proxy server must be online for this to work.)  The program will
wait until all of the requests have been met before exiting.
.TP
.B \-config
Tell the wwwoffled proxy server to re-read the configuration file.
.TP
.B \-purge
Tell the wwwoffled proxy server that the cache is to be purged.  The
configuration file wwwoffle.conf(5) specifies the maximum age of the pages to
keep.
.TP
.B url
The URL of a web page that is to be fetched.  This is the same as using a
browser and entering the URL if not already in the cache or pressing the refresh
button in the index if it is in the cache.
.TP
.B \-c <config-file>
Specifies the name of the configuration file that contains the server host name,
port number and authorisation password.  This is required for the -online,
-offline, -fetch, -config and -purge options if a password is set.  The user
must have read access to the configuration file to be able to use the command if
a password is set.
(See the StartUp and LocalHost section of wwwoffle.conf(5) for more information
on setting the server host name, ports and password.)
.TP
.B \-p <host>[:<port>]
Sets the hostname and port number that is to be ued for the connection to the
proxy server.  For the -online, -offline, -fetch, -config and -purge option this
must be the wwwoffle demon port, for the url option it must be the http proxy
server port.  If no -p option is specified then the compiled in defaults are
used.
.TP
.B \-i
Also fetches the images that are included in the specified URLs.  If you have
.B fetch-images
set to true in wwwoffle.conf and you are using wwwoffle when offline then you do
not need to use this option because the images will be fetched anyway.
.TP
.B \-r[<depth>]
Causes the pages linked to by the specified URLs also to be fetched if they are
on the same host.  If you are using wwwoffle while offline then this option will
only work if the URL is currently in the cache.  In this case the page will be
refreshed and the links will be fetched.
.TP
.B \-R[<depth>]
The same as
.B \-r
above, but it also works for links that are not on the same host.
.SH SEE ALSO
wwwoffled(8), wwwoffle.conf(5).
.SH AUTHOR
Andrew M. Bishop 1996,1997 (amb@gedanken.demon.co.uk)
