.\" $Header: /home/amb/wwwoffle/RCS/wwwoffle.conf.man 1.15 1997/03/22 14:47:06 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 1.1.
.\"
.\"  Manual page for wwwoffle.conf
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffle.conf 5 "March 10, 1997"
.SH NAME
wwwoffle.conf \- The configuration file for the proxy server for the World Wide Web Offline Explorer.
.SH DESCRIPTION
The
.I wwwoffle.conf
file contains the configuration for the wwwoffled proxy HTTP server part of the
.I
World Wide Web Offline Explorer
program.
.LP
The file is split into sections, each of which has a format similar to a C
function (see the example below).  The section has a name, followed on the next
line by an open brace '{', followed on the next lines by a list of names and
values separated by an equals sign '=', the section ends with a close brace
'}' on a line.  Comments are marked by a '#' at the start of the line.
.LP
The
.B StartUp
section can contain the following:
.TP
.B http-port = <port>
The port number to use on the local host as the HTTP proxy (default=8080).
.TP
.B wwwoffle-port = <port>
The port number to use on the local host as the wwwoffle control port
(default=8081).
.TP
.B spool-dir = <dirname>
The name of the spool directory to use for the cache. A subdirectory is created
in this for each new web server that is contacted (default=/var/spool/wwwoffle).
.TP
.B use-syslog = yes | no
The syslog facility can be used to log the important error messages as well as
standard error if this is set and the option is compiled into the program
(default=no).
.TP
.B password = <word> | none |
The authorisation password that is required to use the wwwoffle program to
configure the server or use the interactive control page (default=none).  If
this is not present, or set to an empty string or 'none' then there is no
password required.  If there is a password set, then the -c option to wwwoffle
must be used, and the file wwwoffle.conf should be made readable only by
authorised users.
.LP
The
.B Options
section contains other options that configure the server.
.TP
.B fetch-images = yes | no
When pages are requested while offline and downloaded later, there is a choice
of whether to fetch the images from these pages as well (default=no).
.TP
.B index-latest-days = <age>
The maximum age in days of pages to show in the index of the latest pages
(default=7).
.Tp
.B add-info-refresh = yes | no
The option to add into the bottom of all of the spooled pages the date that the
page was cached and a refresh button (default=no).  This uses the first entry in
the LocalHost section as the server name.
.LP
The
.B LocalHost
section contains a list of possible names or IP addresses that the host running
wwwoffled may be known as.
.TP
.I hostname
The server may be known as
.I hostname
so does not need to contact itself to get pages.  All of the entries here are
also used as if they were in the DontCache and AllowConnect sections.
.LP
The
.B AllowedConnect
section contains a list of host names or IP addresses that are allowed to
connect to the server.
.TP
.I hostname
A server that matches
.I hostname
is allowed to connect to the server.  The match is done from the right so that
domain names can be used to match all hosts in the domain, IP addresses match
from the left.  All of the entries in the LocalHost section are also allowed to
connect.
.LP
The
.B DontCache
section contains a list of host names or IP addresses that are not to be cached.
.TP
.I hostname
A server that matches
.I hostname
is not to be cached.  The match is done from the right so that domain names can
be used to match all hosts in the domain, IP addresses match from the left.  All
entries here are assumed to be reachable even when offline.  All of the entries
in the LocalHost section are also not cached as if they were here also.
.LP
The
.B Proxy
section contains a list of the hosts that are to be served via specified proxy
servers.  If no proxy is required then use 'none' or leave the proxy name blank.
.TP
.B default = <hostname:[port]> | none |
The name of a default external proxy server to route all requests through unless
a specific proxy applies (default=none).
.TP
.I host = <hostname:[port]> | none |
The server called
.I host
is to use the specified proxy instead of the default.  The match is done from
the right so that domain names can be used to match all hosts in the domain, IP
addresses match from the left.
.LP
The
.B Purge
The method to determine which pages to purge and the default age and the host
specific maximum age of the pages in days.  An age of zero means to always
delete when a purge is done, a negative age means never purge.
.TP
.B use-mtime = yes | no
The decision of which pages to purge can be made on last access time (atime) or
last modification time (mtime) (default=no).
.B default = <age>
The age to purge hosts that are not otherwise specified here (default=28).
.TP
.I hostname = <age>
The age to purge hosts that match
.I hostname.
The match is done from the right so that domain names can be used to match all
hosts in the domain, IP addresses match from the left.
.LP
.SH EXAMPLE
 StartUp
 {
  http-port     = 8080
  wwwoffle-port = 8081
  spool-dir     = /var/spool/wwwoffle
  use-syslog    = no
  password      =
 }

 Options
 {
  fetch-images      = yes
  index-latest-days = 14
  add-info-refresh  = no
 }

 LocalHost
 {
  localhost
  127.0.0.1
  bar.foo.com
 }

 AllowedConnect
 {
  foo.com
 }

 DontCache
 {
  foo.com
 }

 Proxy
 {
  default = none
  foo.com = www-cache.foo.com:8080
 }

 Purge
 {
  default = 28
  bar.com = 7
 }
.SH FILES
/var/spool/wwwoffle/wwwoffle.conf The wwwoffled(8) configuration file.
.SH SEE ALSO
wwwoffle(1), wwwoffled(8).
.SH AUTHOR
Andrew M. Bishop 1996,1997 (amb@gedanken.demon.co.uk)
