/***************************************
  $Header: /home/amb/wwwoffle/RCS/messages.c 1.10 1997/03/24 17:36:50 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.1.
  Messages that the program sends in reply to requests from browsers
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>

#include "wwwoffle.h"


/*++++++++++++++++++++++++++++++++++++++
  A fatal server error occured.

  int fd The file descriptor to report the error to.

  char *string The message string of the error.
  ++++++++++++++++++++++++++++++++++++++*/

void ServerError(int fd,char *string)
{
 char *head=
 "HTTP/1.0 500 WWWOFFLE Server Error\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Server Error\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Server Error</H1>\n"
 "<p align=center>\n"
 "The WWWOFFLE server encountered a fatal error\n"
 "<br><b><tt>\n";
 char *tail=
 "\n"
 "</tt></b>\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 write(fd,string,strlen(string));
 write(fd,tail,strlen(tail));
}


/*++++++++++++++++++++++++++++++++++++++
  The connection to the remote host failed.

  int fd The file descriptor to send the message to.

  char *url The url that failed.

  char *host The host that the connection to failed.

  int port The port number on the host that failed.

  char *reason The reason for the error.
  ++++++++++++++++++++++++++++++++++++++*/

void RemoteHostError(int fd,char *url,char *host,int port,char *reason)
{
 char string[16];
 char *head=
 "HTTP/1.0 503 WWWOFFLE Remote Host Error\r\n" /* This line must not be changed (see wwwoffles.c). */
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Remote Host Error\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Remote Host Error</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle1=
 "\n"
 "</tt></b><br>\n"
 "failed because the server\n"
 "<br><b><tt>\n";
 char *middle2=
 "\n"
 "</tt></b><br>\n";
 char *tail=
 "\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 write(fd,url,strlen(url));
 write(fd,middle1,strlen(middle1));
 write(fd,host,strlen(host));
 sprintf(string," port %d",port);
 write(fd,string,strlen(string));
 write(fd,middle2,strlen(middle2));
 write(fd,reason,strlen(reason));
 write(fd,tail,strlen(tail));
}


/*++++++++++++++++++++++++++++++++++++++
  Print the message stating that we will get the URL.

  int fd The file descriptor to send the message to.

  char *url The url we are going to get.

  int already Set to true if we have already marked this for getting.
  ++++++++++++++++++++++++++++++++++++++*/

void WillGetURL(int fd,char *url,int already)
{
 char *head=
 "HTTP/1.0 404 WWWOFFLE Will Get\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Will Get\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n";
 char *middle1=
 "<H1 align=center>WWWOFFLE Request Recorded</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle2=
 "<H1 align=center>WWWOFFLE Request Already Recorded</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *tail1=
 "\n"
 "</tt></b><br>\n"
 "has been recorded for download.\n"
 "</BODY>\n"
 "</HTML>\n";
 char *tail2=
 "\n"
 "</tt></b><br>\n"
 "has already been recorded for download.\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 if(already)
    write(fd,middle2,strlen(middle2));
 else
    write(fd,middle1,strlen(middle1));
 write(fd,url ,strlen(url));
 if(already)
    write(fd,tail2,strlen(tail2));
 else
    write(fd,tail1,strlen(tail1));
}


/*++++++++++++++++++++++++++++++++++++++
  Print the message redirecting the user to the real URL.

  int fd The file descriptor to send the message to.

  char *url The url we are going to get.
  ++++++++++++++++++++++++++++++++++++++*/

void RefreshRedirect(int fd,char *url)
{
 char *string=(char*)malloc(2*strlen(url)+16);
 char *head=
 "HTTP/1.0 301 WWWOFFLE Refresh Redirect\r\n" /* This line must not be changed (see refresh.c). */
 "Content-type: text/html\r\n";
 char *head2=
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Refresh Redirect\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Refresh</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle=
 "\n"
 "</tt></b><br>\n"
 "will be refreshed by selecting the link below.\n"
 "<br>\n";
 char *tail=
 "\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 sprintf(string,"Location: %s\r\n",url);
 write(fd,string,strlen(string));
 write(fd,head2,strlen(head2));
 write(fd,url,strlen(url));
 write(fd,middle,strlen(middle));
 sprintf(string,"<a href=\"%s\">%s</a>",url,url);
 write(fd,string,strlen(string));
 write(fd,tail,strlen(tail));

 free(string);
}


/*++++++++++++++++++++++++++++++++++++++
  Print the welcome message for the proxy server.

  int fd The file descriptor to send the message to.

  int password Set to true if there is a password.
  ++++++++++++++++++++++++++++++++++++++*/

void WelcomePage(int fd,int password)
{
 char *head=
 "HTTP/1.0 200 WWWOFFLE Welcome Page\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Proxy Welcome Page\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Proxy Welcome Page</H1>\n"
 "The WWWOFFLE programs simplify World Wide Web browsing from computers that use\n"
 "intermittent (dial-up) connections to the internet.\n"
 "<h2>Description</h2>\n"
 "The wwwoffled program is a simple proxy server with special features for use\n"
 "with dial-up internet links.  This means that it is possible to browse web pages\n"
 "and read them without having to remain connected.\n"
 "<br>While Online\n"
 "<ul>\n"
 "<li> Cacheing of pages that are viewed for review later.\n"
 "<li> Conditional fetching to only get pages that have changed.\n"
 "</ul>\n"
 "While Offline\n"
 "<ul>\n"
 "<li> The ability to follow links and mark other pages for download.\n"
 "<li> Browser or command line interface to select pages for downloading.\n"
 "<li> Optional info on bottom of pages showing cached date and allowing refresh.\n"
 "<li> Works with pages containing forms.\n"
 "</ul>\n"
 "Automated Download\n"
 "<ul>\n"
 "<li> Downloading of specified pages non-interactively.\n"
 "<li> Can automatically fetch inlined images in pages fetched this way.\n"
 "<li> Automatically follows links for pages that have been moved.\n"
 "</ul>\n"
 "Provides\n"
 "<ul>\n"
 "<li> An introductory page with information and links to the built-in pages.\n"
 "<li> Multiple indices of pages stored in cache for easy selection.\n"
 "<li> Interactive or command line control of online/offline status.\n"
 "<li> User selectable purging of pages from cache based on hostname.\n"
 "<li> Interactive or command line option to fetch pages and links recursively.\n"
 "</ul>\n"
 "General\n"
 "<ul>\n"
 "<li> Can be used with one or more external proxies based on hostname.\n"
 "<li> Configurable to still allow use on intranets while offline.\n"
 "<li> All options controlled using a simple configuration file.\n"
 "<li> Optional password control for management functions.\n"
 "</ul>\n"
 "<h2>WWWOFFLE Proxy Index</h2>\n"
 "The index of all of the pages stored in the WWWOFFLE cache is available in a number of formats.\n"
 "<br>\n"
 "The indexes are organised by hostname with a separate list for each host.\n"
 "The basic URL is /index/, but this can be modified with an argument as follows.\n"
 "<dl compact>\n"
 "<dt><a href=\"/index/?none\">/index/?none</a>\n"
 "<dd>To have the indexes unsorted.\n"
 "<dt><a href=\"/index/?mtime\">/index/?mtime</a>\n"
 "<dd>To have the indexes sorted by modification time, newest file at the top.\n"
 "<dt><a href=\"/index/?atime\">/index/?atime</a>\n"
 "<dd>To have the indexes sorted by access time, most recently used at the top.\n"
 "<dt><a href=\"/index/?alpha\">/index/?alpha</a>\n"
 "<dd>To have the indexes sorted alphabetically according to the file name.\n"
 "<dt><a href=\"/index/?type\">/index/?type</a>\n"
 "<dd>To have the indexes sorted alphabetically according to the file extension.\n"
 "<dt><a href=\"/index/?latest\">/index/?latest</a>\n"
 "<dd>A flat index of all files modified in the few days sorted by modification time.\n"
 "</dl>\n"
 "<h2>WWWOFFLE Single and Recursive Page Requests</h2>\n"
 "Pages that are wanted can be fetched by entering them into the browser's own page selector.\n"
 "Or alternatively by using the command line interface or interactively from a web page.\n"
 "<dl compact>\n"
 "<dt><a href=\"/refresh/\">/refresh/</a>\n"
 "<dd>An interactive page for fetching pages.\n"
 "</dl>\n"
 "<h2>WWWOFFLE Interactive Control</h2>\n"
 "The WWWOFFLE proxy can be controlled either through a command line interface, or interactively from a web page.\n"
 "<dl compact>\n"
 "<dt><a href=\"/control/\">/control/</a>\n"
 "<dd>An interactive page to control the proxy program.\n";
 char *middle=
 "[Requires the password from the configuration file, but any user name.]\n";
 char *tail=
 "</dl>\n"
 "<h2>WWWOFFLE HomePage</h2>\n"
 "The WWWOFFLE homepage on the internet is available at\n"
 "<a href=\"http://www.gedanken.demon.co.uk/wwwoffle/\">http://www.gedanken.demon.co.uk/wwwoffle/</a>,\n"
 "this contains the latest information about the program.\n"
 "You can e-mail the author at <a href=\"mailto:amb@gedanken.demon.co.uk\">amb@gedanken.demon.co.uk</a>,\n"
 "this is helped if you put wwwoffle in the subject line.\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 if(password)
    write(fd,middle,strlen(middle));
 write(fd,tail,strlen(tail));
}


/*++++++++++++++++++++++++++++++++++++++
  Print a message that an illegal page has been requested on the proxy server.

  int fd The file descriptor to send the message to.

  char *path The path that was specified.

  char *args The arguments that were specified.
  ++++++++++++++++++++++++++++++++++++++*/

void IllegalPage(int fd,char *path,char *args)
{
 char *string=(char*)malloc(strlen(path)+(args?strlen(args):0)+8);
 char *head=
 "HTTP/1.0 404 WWWOFFLE Illegal Page\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - Illegal Page\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Illegal Page</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *tail=
 "\n"
 "</tt></b><br>\n"
 "is not a legal URL on the wwwoffle proxy server.\n"
 "<br>\n"
 "<a href=\"/\">WWWOFFLE Proxy Welcome Page</a>\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 if(args)
    sprintf(string,"/%s?%s",path,args);
 else
    sprintf(string,"/%s",path);
 write(fd,string,strlen(string));
 write(fd,tail,strlen(tail));
}
