/***************************************
  $Header: /home/amb/wwwoffle/RCS/errors.c 1.7 1997/03/04 20:33:24 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.1.
  Generate error messages in a standard format on stderr and optionally also to syslog.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


/*+ Under Linux or SGI, stdarg is used +*/
#if defined(__linux__) || defined(__sgi__)
#define USE_STD_ARG
#endif

/*+ Under Linux use syslog as an option for error messages. +*/
#if defined(__linux__)
#define USE_SYSLOG
#endif

#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_STD_ARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef USE_SYSLOG
#include <syslog.h>
#endif

#include <errno.h>

/* SunOS 4.x does not have strerror(). */
#if defined(__sun__) && !defined(__svr4__)
extern int sys_nerr;
extern char *sys_errlist[];

char* strerror(int err)
{
 if(err>0 && err<sys_nerr)
    return(sys_errlist[err]);
 else
    return("Unknown error");
}
#endif

#include "config.h"
#include "errors.h"


/*+ The name of the program. +*/
static char *program=NULL;

/*+ The process id of the program. +*/
static pid_t pid;

/*+ The error messages. +*/
static char *ErrorString[]={" Debug:",""      ,""        ," Warning:"," Fatal:"};

#ifdef USE_SYSLOG
static int use_syslog=0;

/*+ The priority to apply to syslog messages. +*/
static int ErrorPriority[]={       -1,      -1,LOG_NOTICE,LOG_WARNING,LOG_ERR};
#endif


/*++++++++++++++++++++++++++++++++++++++
  Initialise the error handler, get the program name and pid.

  char *name The name of the program.

  int syslogable Set to true if the errors are allowed to go to syslog.
  ++++++++++++++++++++++++++++++++++++++*/

void InitErrorHandler(char *name,int syslogable)
{
#ifdef USE_SYSLOG
 use_syslog=syslogable;

 if(program) closelog();
 openlog(name,LOG_CONS|LOG_PID,LOG_DAEMON);
 atexit(closelog);
#endif

 program=name;

 pid=getpid();
}


/*++++++++++++++++++++++++++++++++++++++
  Print an error message.

  ErrorLevel errlev Which error level.

  char* fmt The format of the message.

  ... The rest of the arguments (printf style).
  ++++++++++++++++++++++++++++++++++++++*/

void PrintMessage(ErrorLevel errlev,char* fmt, ...)
{
 int str_len=16+strlen(fmt);
 char* string;
 va_list ap;
 int i,j;

#if !DEBUG
 if(errlev==Debug)
    return;
#endif

 string=(char*)malloc(str_len);

#ifdef USE_STD_ARG
 va_start(ap,fmt);
#else
 va_start(ap);
#endif

 for(i=0,j=0;fmt[i];i++)
    if(fmt[i]!='%')
       string[j++]=fmt[i];
    else
      {
       char str[16],*strp=NULL;

       switch(fmt[++i])
         {
         case '!':
          if(fmt[++i]=='s')
             strp=strerror(errno);
          else
             sprintf(strp=str,"%d",errno);
          break;

         case 'd':
          sprintf(strp=str,"%d",va_arg(ap,int));
          break;

         case 's':
          strp=va_arg(ap,char*);
          if(!strp) strp="(null)";
          break;

         default:
          str[0]='%';
          str[1]=fmt[i];
          str[2]=0;
          strp=str;
          (void)va_arg(ap,void*);
         }

       str_len+=strlen(strp);
       string=realloc(string,str_len);
       strcpy(&string[j],strp);
       j+=strlen(strp);
      }

 if(string[j-1]!='\n')
    string[j++]='\n';
 string[j]=0;

 va_end(ap);

#ifdef USE_SYSLOG
 if(UseSyslog && use_syslog && ErrorPriority[errlev]!=-1)
    syslog(ErrorPriority[errlev],"%s",string);
#endif

 fprintf(stderr,"%s[%d]%s %s",program,pid,ErrorString[errlev],string);

 free(string);

 if(errlev==Fatal)
    exit(2);
}
