/***************************************
  $Header: /home/amb/wwwoffle/RCS/config.h 1.11 1997/03/09 13:24:57 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.1.
  Configuration file management functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef CONFIG_H
#define CONFIG_H    /*+ To stop multiple inclusions. +*/

/*+ The name of the configuration file. +*/
extern char *ConfigFile;

/*+ The port number to use for the HTTP proxy port. +*/
extern int HTTP_Port;

/*+ The port number to use for the wwwoffle port. +*/
extern int WWWOFFLE_Port;

/*+ The spool directory. +*/
extern char *SpoolDir;

/*+ Whether to use the syslog facility or not. +*/
extern int UseSyslog;

/*+ The password required for demon configuration. +*/
extern char *PassWord;

/*+ The number of days to display in the index of the latest pages. +*/
extern int IndexLatestDays;

/*+ The option to also fetch images. +*/
extern int FetchImages;

/*+ The option of a tag that can be added to the bottom of the spooled pages with the date and a refresh button. +*/
extern int AddInfoRefresh;

/*+ If true then use modification time instead of access time. +*/
extern int PurgeUseMTime;

/* In config.h */

int ReadConfigFile(int fd);

char *WhichProxy(char *host);
int WhatPurgeAge(char *host);
char *GetLocalHost(void);
int IsLocalHost(char *host);
int IsAllowedConnect(char *host);
int IsCachedHost(char *host);

#endif /* CONFIG_H */
