.\" $Header: /home/amb/wwwoffle/RCS/wwwoffled.man 1.3 1997/01/20 19:56:42 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 1.0.
.\"
.\"  Manual page for wwwoffled
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffled 8 "January 8, 1997"
.SH NAME
wwwoffled \- A proxy server for the World Wide Web Offline Explorer.
.SH SYNOPSIS
.B wwwoffled
.B [\-h]
.B [\-proxy host[:port]]
.B [\-ports port1 port2]
.B [\-spool dir]
.SH DESCRIPTION
.I wwwoffled
is a proxy HTTP server for the
.I
World Wide Web Offline Explorer
program.
Using a standard web browser with the HTTP proxy set to the wwwoffled server,
web pages can be requested while not connected to the internet.
.LP
When the computer is connected to the internet, the server will fetch the web
pages requested by the browser and also store them in the cache.
When the computer is not connected, browsing of the pages in the cache is still
possible, and links can be followed.  This causes the request for the page to be
stored by the proxy server until a later time when the computer is connected and
the pages are fetched non-interactively.
.LP
Pages that are requested from a server on the same host (localhost) are not
cached, and are always fetched fresh from the server.
.LP
The pages that are stored in the cache can be indexed by using the URL
http://localhost:8080/ to get a list of the hosts that have cached pages.
This returns them in natural order, using any of the arguments alpha, atime,
mtime or ctime causes the index to be sorted into alphabetical order or time order.
For example http://localhost:8080/?atime returns the files sorts them so the
most recently accessed one is at the top.
.SH OPTIONS
.TP
.B [\-h]
A help message is printed giving a brief description of the usage of the program.
.TP
.B [\-proxy host[:port]]
The wwwoffled proxy server can itself use another proxy server to fetch the pages from.
By default no proxy is used, but setting the host and port number with the proxy
option will cause one to be used.
.TP
.B [\-ports port1 port2]
These two parameters set the port numbers to use for the HTTP proxy and the wwwoffle control port.
By default the values 8080 for the HTTP proxy and 8081 for the wwwoffle port are used.
(If the wwwoffle port is changed from the default then the -port option to wwwoffle(1) must be used.)
.TP
.B [\-spool dir]
The spool directory to use to store the cached pages in.
Each host that a page is fetched from is stored in a sub-directory.
This directory must also contain a copy of (or a link to) the wwwoffles server porgram.
.SH SEE ALSO
wwwoffle(1)
.SH AUTHOR
Andrew M. Bishop Dec 1996/Jan 1997 (amb@gedanken.demon.co.uk)
