/***************************************
  $Header: /home/amb/wwwoffle/RCS/spool.c 1.3 1997/01/22 20:21:09 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.0.
  Handle all of the spooling of files in the spool directory.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include "wwwoffle.h"
#include "errors.h"



/*++++++++++++++++++++++++++++++++++++++
  Open a file in the outgoing directory to write into / read from.

  int OpenOutgoingSpoolFile Returns a file descriptor, or -1 on failure.

  int rw Set to true to read, else false.
  ++++++++++++++++++++++++++++++++++++++*/

int OpenOutgoingSpoolFile(int rw)
{
 int fd=-1;
 int high=0,low=0;
 DIR *dir;
 struct dirent* ent;

 /* Open the outgoing directory. */

 dir=opendir("outgoing");
 if(!dir)
   {
    PrintMessage(Inform,"Cannot open outgoing directory [%!s]; creating one.");
    if(!mkdir("outgoing",0755))
      {PrintMessage(Warning,"Cannot create outgoing directory [%!s].");return(-1);}
   }

 ent=readdir(dir);
 if(!ent)
   {PrintMessage(Warning,"Cannot read outgoing directory [%!s].");closedir(dir);return(-1);}

 ent=readdir(dir);  /* skip .  */
 ent=readdir(dir);  /* skip .. */

 /* Go through the files and find the highest/lowest number. */

 while(ent)
   {
    int number=atoi(ent->d_name);

    if(number)
      {
       if(!high || number>high)
          high=number;
       if(!low  || number<low)
          low=number;
      }

    ent=readdir(dir);
   }

 closedir(dir);

 /* Open the lowest to read or the highest to write. */

 if(rw)
   {
    /* Open the lowest number. */

    if(low)
       for(;low<=high;low++) /* start at the lowest and keep going to the highest. */
         {
          struct stat buf;
          char name[20];

          sprintf(name,"outgoing/%d",low);

          if(!stat(name,&buf))
            {
             fd=open(name,O_RDONLY);
             if(fd==-1)
                PrintMessage(Inform,"Cannot open file '%s' [%!s]; race condition?",name);
             else
               {
                unlink(name);
                break;
               }
            }
          else
             PrintMessage(Inform,"Cannot stat file '%s' [%!s]; race condition?",name);
         }
    else
       return(-2);
   }
 else
   {
    /* Open the next highest number. */

    for(high++;;high++)         /* start 1 higher and keep going */
      {
       struct stat buf;
       char name[20];

       sprintf(name,"outgoing/%d",high);

       if(stat(name,&buf))
         {
          fd=open(name,O_WRONLY|O_CREAT|O_EXCL,0644);
          if(fd==-1)
             PrintMessage(Inform,"Cannot open file '%s' [%!s]; race condition?",name);
          else
             break;
         }
       else
          PrintMessage(Inform,"Can stat file '%s'; race condition?",name);
      }
   }

 return(fd);
}


/*++++++++++++++++++++++++++++++++++++++
  Open a file in a spool subdirectory to write into / read from / delete.

  int OpenWebpageSpoolFile Returns a file descriptor.

  int rw Set to +ve to read, zero to write, -ve to delete.

  char *host The hostname from the URL.

  char *path The pathname from the URL.

  char *args The arguments to the URL.
  ++++++++++++++++++++++++++++++++++++++*/

int OpenWebpageSpoolFile(int rw,char *host,char *path,char *args)
{
 struct stat buf;
 int fd=-1;
 char *file=(char*)malloc(strlen(host)+strlen(path)+16),*newpath=(char*)malloc(strlen(path)+2);
 unsigned long hash=0;
 int i;

 /* Modify the path and args. */

 if(!*path)
   {
    newpath[0]=PATH_SEP;
    newpath[1]=0;
   }
 else
   {
    for(i=0;path[i];i++)
       if(path[i]=='/')
          newpath[i]=PATH_SEP;
       else
          newpath[i]=path[i];
    newpath[i]=0;
   }

 if(args)
    hash=MakeHashFromArgs(args);

 if(args)
    sprintf(file,"%s/%s%c%c%08lx",host,newpath,PATH_SEP,PATH_SEP,hash);
 else
    sprintf(file,"%s/%s",host,newpath);

 /* Create or check for the directory for the spool file. */

 if(stat(host,&buf))
   {
    PrintMessage(Inform,"Cannot open directory '%s' [%!s]; creating one.",host);
    if(mkdir(host,0755))
      {PrintMessage(Warning,"Cannot create directory '%s' [%!s].",host);free(file);return(-1);}
   }
 else
    if(!S_ISDIR(buf.st_mode))
      {PrintMessage(Warning,"The file '%s' is not a directory.",host);free(file);return(-1);}

 /* Create the file for the web page. */

 if(rw>0)
    fd=open(file,O_RDONLY);
 else if(rw==0)
    fd=open(file,O_WRONLY|O_CREAT|O_TRUNC,0644);
 else
    unlink(file);

 if(args && (rw<0 || fd!=-1))
   {
    sprintf(file,"%s/%c%c%08lx",host,PATH_SEP,PATH_SEP,hash);

    if(rw<0)
       unlink(file);
    else if(rw==0)
      {
       int afd=open(file,O_WRONLY|O_CREAT|O_TRUNC,0644);
       if(afd!=-1)
         {
          write(afd,args,strlen(args));
          close(afd);
         }
       else
         {
          close(fd);
          fd=-1;
         }
      }
    else
      {
       int afd=open(file,O_RDONLY);
       if(afd!=-1)
          close(afd);
       else
         {
          close(fd);
          fd=-1;
         }
      }
   }

 free(file);
 free(newpath);

 return(fd);
}


/*++++++++++++++++++++++++++++++++++++++
  Generate a hash value depending on the arguments appended to the URL.

  unsigned long MakeHashFromArgs Returns a long integer to use.

  char *args The arguments.
  ++++++++++++++++++++++++++++++++++++++*/

unsigned long MakeHashFromArgs(char *args)
{
 int i;
 unsigned long hash=0;

 if(args)
    for(i=0;args[i];)
      {
       unsigned long subhash=args[i]&0x7f;

       for(i++;i%25 && args[i];i++)
          subhash=(subhash<<1)^(unsigned long)(args[i]&0x7f);

       hash^=subhash;
      }

 return(hash);
}
