/***************************************
  $Header: /home/amb/wwwoffle/RCS/index.c 1.7 1997/01/22 20:21:29 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.0.
  Generate an index of the web pages that are cached in the system.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <utime.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"


static void IndexRoot(int fd,char *args,int mode);
static void IndexDir(int fd,char *dirname,int mode);

static int sort_alpha(const void *a,const void *b);
static int sort_time(const void *a,const void *b);


typedef struct _FileIndex
{
 char *name;                    /*+ The name of the file. +*/
 long time;                     /*+ The time of the file, +*/
}
FileIndex;


/*++++++++++++++++++++++++++++++++++++++
  Generate an index of the pages that are in the cache.

  int fd The file descriptor to write the output to.

  char *url The URL that specifies the path to generate the index for.
  ++++++++++++++++++++++++++++++++++++++*/

void GenerateIndex(int fd,char *path,char *args)
{
 char *head=
 "HTTP/1.0 200 WWWOFFLE Index\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - World Wide Web Offline Explorer\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Cache Index</H1>\n";
 char *head2=
 "<ul>\n";
 char *tail2=
 "</ul>\n";
 char *tail=
 "</BODY>\n"
 "</HTML>\n";
 int sort=0;
 char *newargs=args,*newpath=(char*)malloc(strlen(path)+1);

 strcpy(newpath,path);

 if(newpath[strlen(newpath)-1]=='/')
    newpath[strlen(newpath)-1]=0;

 if(args)
   {
    if(!strcmp(args,"ctime"))
       sort=1;
    else if(!strcmp(args,"mtime"))
       sort=2;
    else if(!strcmp(args,"atime"))
       sort=3;
    else if(!strcmp(args,"alpha"))
       sort=4;
    else
      {sort=0;newargs=NULL;}
   }

 write(fd,head,strlen(head));

 if(!*path)
   {
    write(fd,head2,strlen(head2));

    IndexRoot(fd,args,sort);

    write(fd,tail2,strlen(tail2));
   }
 else
   {
    char *buffer=(char*)malloc(strlen(path)+64);

    sprintf(buffer,"<b>http://%s</b>\n",path);
    write(fd,buffer,strlen(buffer));

    write(fd,head2,strlen(head2));

    IndexDir(fd,path,sort);

    write(fd,tail2,strlen(tail2));

    sprintf(buffer,"<b><a href=\"../?%s\">[Back to the Hosts Index]</a></b>\n",args);
    write(fd,buffer,strlen(buffer));

    free(buffer);
   }

 write(fd,tail,strlen(tail));

 free(newpath);
}


/*++++++++++++++++++++++++++++++++++++++
  Index the root of the cache.

  int fd The file descriptor to write to.

  char *args The argument to put in the index for sorting.

  int mode The sort mode to use.
  ++++++++++++++++++++++++++++++++++++++*/

static void IndexRoot(int fd,char *args,int mode)
{
 DIR *dir;
 struct dirent* ent;
 FileIndex **files=NULL;
 int i,nfiles=0;

 /* Open the spool directory. */

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open spool directory [%!s]; index failed.");return;}

 ent=readdir(dir);
 if(!ent)
   {PrintMessage(Warning,"Cannot read spool directory [%!s]; index failed.");closedir(dir);return;}

 ent=readdir(dir);  /* skip .  */
 ent=readdir(dir);  /* skip .. */

 /* Print all of the sub directories. */

 while(ent)
   {
    char *name=ent->d_name;
    struct stat buf;

    if(stat(name,&buf))
       PrintMessage(Warning,"Cannot stat file '%s' [%!s]; race condition?",name);
    else
       if(S_ISDIR(buf.st_mode) && strcmp(name,"outgoing"))
         {
          if(!(nfiles%16))
            {
             if(!files)
                files=(FileIndex**)malloc(16*sizeof(FileIndex*));
             else
                files=(FileIndex**)realloc(files,(nfiles+16)*sizeof(FileIndex*));
            }
          files[nfiles]=(FileIndex*)malloc(sizeof(FileIndex));
          files[nfiles]->name=(char*)malloc(strlen(name)+1);
          strcpy(files[nfiles]->name,name);
          if(mode==1)
             files[nfiles]->time=buf.st_ctime;
          else if(mode==2)
             files[nfiles]->time=buf.st_mtime;
          else if(mode==3)
             files[nfiles]->time=buf.st_atime;
          nfiles++;
         }

    ent=readdir(dir);
   }

 closedir(dir);

 /* Sort the files. */

 if(mode==1 || mode==2 || mode==3)
    qsort(files,nfiles,sizeof(FileIndex*),sort_time);
 else if(mode==4)
    qsort(files,nfiles,sizeof(FileIndex*),sort_alpha);

 for(i=0;i<nfiles;i++)
   {
    char *buffer=(char*)malloc(2*strlen(files[i]->name)+(args?strlen(args):0)+32);

    if(args)
       sprintf(buffer,"<li><a href=\"%s?%s\">%s</a>\n",files[i]->name,args,files[i]->name);
    else
       sprintf(buffer,"<li><a href=\"%s\">%s</a>\n",files[i]->name,files[i]->name);
    write(fd,buffer,strlen(buffer));

    free(buffer);
    free(files[i]);
   }

 free(files);
}


/*++++++++++++++++++++++++++++++++++++++
  Create an index of a subdirectory.

  int fd The file descriptor to write to.

  char *dirname The name of the subdirectory.

  int mode The sort mode to use.
  ++++++++++++++++++++++++++++++++++++++*/

static void IndexDir(int fd,char *dirname,int mode)
{
 DIR *dir;
 struct dirent* ent;
 FileIndex **files=NULL;
 int i,nfiles=0;

 /* Open the spool subdirectory. */

 if(chdir(dirname))
   {PrintMessage(Warning,"Cannot change to directory '%s' [%!s]; not indexed.",dirname);return;}

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open directory '%s' [%!s]; not indexed.",dirname);chdir("..");return;}

 ent=readdir(dir);
 if(!ent)
   {PrintMessage(Warning,"Cannot read directory '%s' [%!s]; not indexed.",dirname);closedir(dir);chdir("..");return;}

 ent=readdir(dir);  /* skip .  */
 ent=readdir(dir);  /* skip .. */

 /* Print all of the file names. */

 while(ent)
   {
    char *name=(char*)malloc(strlen(ent->d_name)+1);
    struct stat buf;

    strcpy(name,ent->d_name);

    if(stat(name,&buf))
       PrintMessage(Warning,"Cannot stat file '%s/%s' [%!s]; race condition?",dirname,name);
    else
      {
       int i;
       char *args="";

       for(i=0;name[i];i++)
          if(name[i]==PATH_SEP)
            {
             if(name[i+1]!=PATH_SEP)
                name[i]='/';
             else
                if(name[i+1] && name[i+2]!=PATH_SEP)
                  {args=&name[i];break;}
                else
                  {name[i]='/';args=&name[i+1];break;}
            }

       if(args!=name)
         {
          if(*args)
            {
             char *old_args=args;
             int afd=open(old_args,O_RDONLY);

             if(afd!=-1)
               {
                int rr,r=0;
                struct utimbuf utbuf;

                args=(char*)malloc(64+1);

                while((rr=read(afd,&args[r],64)))
                  {
                   r+=rr;
                   args=(char*)realloc(args,r+64+1);
                  }

                args[r]=0;
                close(afd);

                utbuf.actime=buf.st_atime;
                utbuf.modtime=buf.st_mtime;
                utime(old_args,&utbuf);
               }

             *old_args=0;
            }

          if(!(nfiles%16))
            {
             if(!files)
                files=(FileIndex**)malloc(16*sizeof(FileIndex*));
             else
                files=(FileIndex**)realloc(files,(nfiles+16)*sizeof(FileIndex*));
            }
          files[nfiles]=(FileIndex*)malloc(sizeof(FileIndex));
          files[nfiles]->name=(char*)malloc(strlen(name)+strlen(args)+2);

          if(*args)
             sprintf(files[nfiles]->name,"%s?%s",name,args);
          else
             strcpy(files[nfiles]->name,name);

          if(mode==1)
             files[nfiles]->time=buf.st_ctime;
          else if(mode==2)
             files[nfiles]->time=buf.st_mtime;
          else if(mode==3)
             files[nfiles]->time=buf.st_atime;
          nfiles++;
         }
      }

    free(name);

    ent=readdir(dir);
   }

 chdir("..");

 /* Sort the files. */

 if(mode==1 || mode==2 || mode==3)
    qsort(files,nfiles,sizeof(FileIndex*),sort_time);
 else if(mode==4)
    qsort(files,nfiles,sizeof(FileIndex*),sort_alpha);

 for(i=0;i<nfiles;i++)
   {
    char *buffer=(char*)malloc(3*strlen(files[i]->name)+2*strlen(dirname)+128);

    if(strstr(files[i]->name,"?!"))
       sprintf(buffer,"<li>[Posted] &nbsp;&nbsp;&nbsp; <a href=\"http://%s/%s\">%s</a>\n",
               dirname,files[i]->name[0]=='/'?&files[i]->name[1]:files[i]->name,
               files[i]->name);
    else
       sprintf(buffer,"<li><a href=\"../outgoing/%s/%s\">[Refresh]</a> &nbsp;&nbsp;&nbsp; <a href=\"http://%s/%s\">%s</a>\n",
               dirname,files[i]->name[0]=='/'?&files[i]->name[1]:files[i]->name,
               dirname,files[i]->name[0]=='/'?&files[i]->name[1]:files[i]->name,
               files[i]->name);
    write(fd,buffer,strlen(buffer));

    free(buffer);
    free(files[i]);
   }

 free(files);
}


/*++++++++++++++++++++++++++++++++++++++
  Used to sort the files into alphabetical order.

  int sort_alpha Returns the comparison of the pointers to strings.

  const void *a The first FileIndex.

  const void *b The second FileIndex.
  ++++++++++++++++++++++++++++++++++++++*/

static int sort_alpha(const void *a,const void *b)
{
 char *aa=(*((FileIndex**)a))->name;
 char *bb=(*((FileIndex**)b))->name;

 return(strcmp(aa,bb));
}


/*++++++++++++++++++++++++++++++++++++++
  Used to sort the files into alphabetical order.

  int sort_time Returns the comparison of the times.

  const void *a The first FileIndex.

  const void *b The second FileIndex.
  ++++++++++++++++++++++++++++++++++++++*/

static int sort_time(const void *a,const void *b)
{
 long aa=(*((FileIndex**)a))->time;
 long bb=(*((FileIndex**)b))->time;

 return(bb-aa);
}
